/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateBandwidthRateLimitScheduleRequest extends StorageGatewayRequest implements
        ToCopyableBuilder<UpdateBandwidthRateLimitScheduleRequest.Builder, UpdateBandwidthRateLimitScheduleRequest> {
    private static final SdkField<String> GATEWAY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GatewayARN").getter(getter(UpdateBandwidthRateLimitScheduleRequest::gatewayARN))
            .setter(setter(Builder::gatewayARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayARN").build()).build();

    private static final SdkField<List<BandwidthRateLimitInterval>> BANDWIDTH_RATE_LIMIT_INTERVALS_FIELD = SdkField
            .<List<BandwidthRateLimitInterval>> builder(MarshallingType.LIST)
            .memberName("BandwidthRateLimitIntervals")
            .getter(getter(UpdateBandwidthRateLimitScheduleRequest::bandwidthRateLimitIntervals))
            .setter(setter(Builder::bandwidthRateLimitIntervals))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BandwidthRateLimitIntervals")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BandwidthRateLimitInterval> builder(MarshallingType.SDK_POJO)
                                            .constructor(BandwidthRateLimitInterval::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_ARN_FIELD,
            BANDWIDTH_RATE_LIMIT_INTERVALS_FIELD));

    private final String gatewayARN;

    private final List<BandwidthRateLimitInterval> bandwidthRateLimitIntervals;

    private UpdateBandwidthRateLimitScheduleRequest(BuilderImpl builder) {
        super(builder);
        this.gatewayARN = builder.gatewayARN;
        this.bandwidthRateLimitIntervals = builder.bandwidthRateLimitIntervals;
    }

    /**
     * Returns the value of the GatewayARN property for this object.
     * 
     * @return The value of the GatewayARN property for this object.
     */
    public final String gatewayARN() {
        return gatewayARN;
    }

    /**
     * For responses, this returns true if the service returned a value for the BandwidthRateLimitIntervals property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasBandwidthRateLimitIntervals() {
        return bandwidthRateLimitIntervals != null && !(bandwidthRateLimitIntervals instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array containing bandwidth rate limit schedule intervals for a gateway. When no bandwidth rate limit intervals
     * have been scheduled, the array is empty.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBandwidthRateLimitIntervals} method.
     * </p>
     * 
     * @return An array containing bandwidth rate limit schedule intervals for a gateway. When no bandwidth rate limit
     *         intervals have been scheduled, the array is empty.
     */
    public final List<BandwidthRateLimitInterval> bandwidthRateLimitIntervals() {
        return bandwidthRateLimitIntervals;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(gatewayARN());
        hashCode = 31 * hashCode + Objects.hashCode(hasBandwidthRateLimitIntervals() ? bandwidthRateLimitIntervals() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateBandwidthRateLimitScheduleRequest)) {
            return false;
        }
        UpdateBandwidthRateLimitScheduleRequest other = (UpdateBandwidthRateLimitScheduleRequest) obj;
        return Objects.equals(gatewayARN(), other.gatewayARN())
                && hasBandwidthRateLimitIntervals() == other.hasBandwidthRateLimitIntervals()
                && Objects.equals(bandwidthRateLimitIntervals(), other.bandwidthRateLimitIntervals());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateBandwidthRateLimitScheduleRequest").add("GatewayARN", gatewayARN())
                .add("BandwidthRateLimitIntervals", hasBandwidthRateLimitIntervals() ? bandwidthRateLimitIntervals() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GatewayARN":
            return Optional.ofNullable(clazz.cast(gatewayARN()));
        case "BandwidthRateLimitIntervals":
            return Optional.ofNullable(clazz.cast(bandwidthRateLimitIntervals()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateBandwidthRateLimitScheduleRequest, T> g) {
        return obj -> g.apply((UpdateBandwidthRateLimitScheduleRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends StorageGatewayRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateBandwidthRateLimitScheduleRequest> {
        /**
         * Sets the value of the GatewayARN property for this object.
         *
         * @param gatewayARN
         *        The new value for the GatewayARN property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayARN(String gatewayARN);

        /**
         * <p>
         * An array containing bandwidth rate limit schedule intervals for a gateway. When no bandwidth rate limit
         * intervals have been scheduled, the array is empty.
         * </p>
         * 
         * @param bandwidthRateLimitIntervals
         *        An array containing bandwidth rate limit schedule intervals for a gateway. When no bandwidth rate
         *        limit intervals have been scheduled, the array is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bandwidthRateLimitIntervals(Collection<BandwidthRateLimitInterval> bandwidthRateLimitIntervals);

        /**
         * <p>
         * An array containing bandwidth rate limit schedule intervals for a gateway. When no bandwidth rate limit
         * intervals have been scheduled, the array is empty.
         * </p>
         * 
         * @param bandwidthRateLimitIntervals
         *        An array containing bandwidth rate limit schedule intervals for a gateway. When no bandwidth rate
         *        limit intervals have been scheduled, the array is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bandwidthRateLimitIntervals(BandwidthRateLimitInterval... bandwidthRateLimitIntervals);

        /**
         * <p>
         * An array containing bandwidth rate limit schedule intervals for a gateway. When no bandwidth rate limit
         * intervals have been scheduled, the array is empty.
         * </p>
         * This is a convenience that creates an instance of the {@link List<BandwidthRateLimitInterval>.Builder}
         * avoiding the need to create one manually via {@link List<BandwidthRateLimitInterval>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<BandwidthRateLimitInterval>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #bandwidthRateLimitIntervals(List<BandwidthRateLimitInterval>)}.
         * 
         * @param bandwidthRateLimitIntervals
         *        a consumer that will call methods on {@link List<BandwidthRateLimitInterval>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #bandwidthRateLimitIntervals(List<BandwidthRateLimitInterval>)
         */
        Builder bandwidthRateLimitIntervals(Consumer<BandwidthRateLimitInterval.Builder>... bandwidthRateLimitIntervals);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends StorageGatewayRequest.BuilderImpl implements Builder {
        private String gatewayARN;

        private List<BandwidthRateLimitInterval> bandwidthRateLimitIntervals = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateBandwidthRateLimitScheduleRequest model) {
            super(model);
            gatewayARN(model.gatewayARN);
            bandwidthRateLimitIntervals(model.bandwidthRateLimitIntervals);
        }

        public final String getGatewayARN() {
            return gatewayARN;
        }

        public final void setGatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
        }

        @Override
        @Transient
        public final Builder gatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
            return this;
        }

        public final List<BandwidthRateLimitInterval.Builder> getBandwidthRateLimitIntervals() {
            List<BandwidthRateLimitInterval.Builder> result = BandwidthRateLimitIntervalsCopier
                    .copyToBuilder(this.bandwidthRateLimitIntervals);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBandwidthRateLimitIntervals(
                Collection<BandwidthRateLimitInterval.BuilderImpl> bandwidthRateLimitIntervals) {
            this.bandwidthRateLimitIntervals = BandwidthRateLimitIntervalsCopier.copyFromBuilder(bandwidthRateLimitIntervals);
        }

        @Override
        @Transient
        public final Builder bandwidthRateLimitIntervals(Collection<BandwidthRateLimitInterval> bandwidthRateLimitIntervals) {
            this.bandwidthRateLimitIntervals = BandwidthRateLimitIntervalsCopier.copy(bandwidthRateLimitIntervals);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder bandwidthRateLimitIntervals(BandwidthRateLimitInterval... bandwidthRateLimitIntervals) {
            bandwidthRateLimitIntervals(Arrays.asList(bandwidthRateLimitIntervals));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder bandwidthRateLimitIntervals(
                Consumer<BandwidthRateLimitInterval.Builder>... bandwidthRateLimitIntervals) {
            bandwidthRateLimitIntervals(Stream.of(bandwidthRateLimitIntervals)
                    .map(c -> BandwidthRateLimitInterval.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateBandwidthRateLimitScheduleRequest build() {
            return new UpdateBandwidthRateLimitScheduleRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
