/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A JSON object containing the following fields:
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeGatewayInformationResponse extends StorageGatewayResponse implements
        ToCopyableBuilder<DescribeGatewayInformationResponse.Builder, DescribeGatewayInformationResponse> {
    private static final SdkField<String> GATEWAY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GatewayARN").getter(getter(DescribeGatewayInformationResponse::gatewayARN))
            .setter(setter(Builder::gatewayARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayARN").build()).build();

    private static final SdkField<String> GATEWAY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GatewayId").getter(getter(DescribeGatewayInformationResponse::gatewayId))
            .setter(setter(Builder::gatewayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayId").build()).build();

    private static final SdkField<String> GATEWAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GatewayName").getter(getter(DescribeGatewayInformationResponse::gatewayName))
            .setter(setter(Builder::gatewayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayName").build()).build();

    private static final SdkField<String> GATEWAY_TIMEZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GatewayTimezone").getter(getter(DescribeGatewayInformationResponse::gatewayTimezone))
            .setter(setter(Builder::gatewayTimezone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayTimezone").build()).build();

    private static final SdkField<String> GATEWAY_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GatewayState").getter(getter(DescribeGatewayInformationResponse::gatewayState))
            .setter(setter(Builder::gatewayState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayState").build()).build();

    private static final SdkField<List<NetworkInterface>> GATEWAY_NETWORK_INTERFACES_FIELD = SdkField
            .<List<NetworkInterface>> builder(MarshallingType.LIST)
            .memberName("GatewayNetworkInterfaces")
            .getter(getter(DescribeGatewayInformationResponse::gatewayNetworkInterfaces))
            .setter(setter(Builder::gatewayNetworkInterfaces))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayNetworkInterfaces").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<NetworkInterface> builder(MarshallingType.SDK_POJO)
                                            .constructor(NetworkInterface::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> GATEWAY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GatewayType").getter(getter(DescribeGatewayInformationResponse::gatewayType))
            .setter(setter(Builder::gatewayType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayType").build()).build();

    private static final SdkField<String> NEXT_UPDATE_AVAILABILITY_DATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextUpdateAvailabilityDate")
            .getter(getter(DescribeGatewayInformationResponse::nextUpdateAvailabilityDate))
            .setter(setter(Builder::nextUpdateAvailabilityDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextUpdateAvailabilityDate").build())
            .build();

    private static final SdkField<String> LAST_SOFTWARE_UPDATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastSoftwareUpdate").getter(getter(DescribeGatewayInformationResponse::lastSoftwareUpdate))
            .setter(setter(Builder::lastSoftwareUpdate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastSoftwareUpdate").build())
            .build();

    private static final SdkField<String> EC2_INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Ec2InstanceId").getter(getter(DescribeGatewayInformationResponse::ec2InstanceId))
            .setter(setter(Builder::ec2InstanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ec2InstanceId").build()).build();

    private static final SdkField<String> EC2_INSTANCE_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Ec2InstanceRegion").getter(getter(DescribeGatewayInformationResponse::ec2InstanceRegion))
            .setter(setter(Builder::ec2InstanceRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ec2InstanceRegion").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(DescribeGatewayInformationResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> VPC_ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VPCEndpoint").getter(getter(DescribeGatewayInformationResponse::vpcEndpoint))
            .setter(setter(Builder::vpcEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VPCEndpoint").build()).build();

    private static final SdkField<String> CLOUD_WATCH_LOG_GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CloudWatchLogGroupARN").getter(getter(DescribeGatewayInformationResponse::cloudWatchLogGroupARN))
            .setter(setter(Builder::cloudWatchLogGroupARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchLogGroupARN").build())
            .build();

    private static final SdkField<String> HOST_ENVIRONMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HostEnvironment").getter(getter(DescribeGatewayInformationResponse::hostEnvironmentAsString))
            .setter(setter(Builder::hostEnvironment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostEnvironment").build()).build();

    private static final SdkField<String> ENDPOINT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndpointType").getter(getter(DescribeGatewayInformationResponse::endpointType))
            .setter(setter(Builder::endpointType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointType").build()).build();

    private static final SdkField<String> SOFTWARE_UPDATES_END_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SoftwareUpdatesEndDate").getter(getter(DescribeGatewayInformationResponse::softwareUpdatesEndDate))
            .setter(setter(Builder::softwareUpdatesEndDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SoftwareUpdatesEndDate").build())
            .build();

    private static final SdkField<String> DEPRECATION_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeprecationDate").getter(getter(DescribeGatewayInformationResponse::deprecationDate))
            .setter(setter(Builder::deprecationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeprecationDate").build()).build();

    private static final SdkField<String> GATEWAY_CAPACITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GatewayCapacity").getter(getter(DescribeGatewayInformationResponse::gatewayCapacityAsString))
            .setter(setter(Builder::gatewayCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayCapacity").build()).build();

    private static final SdkField<List<String>> SUPPORTED_GATEWAY_CAPACITIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SupportedGatewayCapacities")
            .getter(getter(DescribeGatewayInformationResponse::supportedGatewayCapacitiesAsStrings))
            .setter(setter(Builder::supportedGatewayCapacitiesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedGatewayCapacities").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> HOST_ENVIRONMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HostEnvironmentId").getter(getter(DescribeGatewayInformationResponse::hostEnvironmentId))
            .setter(setter(Builder::hostEnvironmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostEnvironmentId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_ARN_FIELD,
            GATEWAY_ID_FIELD, GATEWAY_NAME_FIELD, GATEWAY_TIMEZONE_FIELD, GATEWAY_STATE_FIELD, GATEWAY_NETWORK_INTERFACES_FIELD,
            GATEWAY_TYPE_FIELD, NEXT_UPDATE_AVAILABILITY_DATE_FIELD, LAST_SOFTWARE_UPDATE_FIELD, EC2_INSTANCE_ID_FIELD,
            EC2_INSTANCE_REGION_FIELD, TAGS_FIELD, VPC_ENDPOINT_FIELD, CLOUD_WATCH_LOG_GROUP_ARN_FIELD, HOST_ENVIRONMENT_FIELD,
            ENDPOINT_TYPE_FIELD, SOFTWARE_UPDATES_END_DATE_FIELD, DEPRECATION_DATE_FIELD, GATEWAY_CAPACITY_FIELD,
            SUPPORTED_GATEWAY_CAPACITIES_FIELD, HOST_ENVIRONMENT_ID_FIELD));

    private final String gatewayARN;

    private final String gatewayId;

    private final String gatewayName;

    private final String gatewayTimezone;

    private final String gatewayState;

    private final List<NetworkInterface> gatewayNetworkInterfaces;

    private final String gatewayType;

    private final String nextUpdateAvailabilityDate;

    private final String lastSoftwareUpdate;

    private final String ec2InstanceId;

    private final String ec2InstanceRegion;

    private final List<Tag> tags;

    private final String vpcEndpoint;

    private final String cloudWatchLogGroupARN;

    private final String hostEnvironment;

    private final String endpointType;

    private final String softwareUpdatesEndDate;

    private final String deprecationDate;

    private final String gatewayCapacity;

    private final List<String> supportedGatewayCapacities;

    private final String hostEnvironmentId;

    private DescribeGatewayInformationResponse(BuilderImpl builder) {
        super(builder);
        this.gatewayARN = builder.gatewayARN;
        this.gatewayId = builder.gatewayId;
        this.gatewayName = builder.gatewayName;
        this.gatewayTimezone = builder.gatewayTimezone;
        this.gatewayState = builder.gatewayState;
        this.gatewayNetworkInterfaces = builder.gatewayNetworkInterfaces;
        this.gatewayType = builder.gatewayType;
        this.nextUpdateAvailabilityDate = builder.nextUpdateAvailabilityDate;
        this.lastSoftwareUpdate = builder.lastSoftwareUpdate;
        this.ec2InstanceId = builder.ec2InstanceId;
        this.ec2InstanceRegion = builder.ec2InstanceRegion;
        this.tags = builder.tags;
        this.vpcEndpoint = builder.vpcEndpoint;
        this.cloudWatchLogGroupARN = builder.cloudWatchLogGroupARN;
        this.hostEnvironment = builder.hostEnvironment;
        this.endpointType = builder.endpointType;
        this.softwareUpdatesEndDate = builder.softwareUpdatesEndDate;
        this.deprecationDate = builder.deprecationDate;
        this.gatewayCapacity = builder.gatewayCapacity;
        this.supportedGatewayCapacities = builder.supportedGatewayCapacities;
        this.hostEnvironmentId = builder.hostEnvironmentId;
    }

    /**
     * Returns the value of the GatewayARN property for this object.
     * 
     * @return The value of the GatewayARN property for this object.
     */
    public final String gatewayARN() {
        return gatewayARN;
    }

    /**
     * <p>
     * The unique identifier assigned to your gateway during activation. This ID becomes part of the gateway Amazon
     * Resource Name (ARN), which you use as input for other operations.
     * </p>
     * 
     * @return The unique identifier assigned to your gateway during activation. This ID becomes part of the gateway
     *         Amazon Resource Name (ARN), which you use as input for other operations.
     */
    public final String gatewayId() {
        return gatewayId;
    }

    /**
     * <p>
     * The name you configured for your gateway.
     * </p>
     * 
     * @return The name you configured for your gateway.
     */
    public final String gatewayName() {
        return gatewayName;
    }

    /**
     * <p>
     * A value that indicates the time zone configured for the gateway.
     * </p>
     * 
     * @return A value that indicates the time zone configured for the gateway.
     */
    public final String gatewayTimezone() {
        return gatewayTimezone;
    }

    /**
     * <p>
     * A value that indicates the operating state of the gateway.
     * </p>
     * 
     * @return A value that indicates the operating state of the gateway.
     */
    public final String gatewayState() {
        return gatewayState;
    }

    /**
     * For responses, this returns true if the service returned a value for the GatewayNetworkInterfaces property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasGatewayNetworkInterfaces() {
        return gatewayNetworkInterfaces != null && !(gatewayNetworkInterfaces instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A <a>NetworkInterface</a> array that contains descriptions of the gateway network interfaces.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGatewayNetworkInterfaces} method.
     * </p>
     * 
     * @return A <a>NetworkInterface</a> array that contains descriptions of the gateway network interfaces.
     */
    public final List<NetworkInterface> gatewayNetworkInterfaces() {
        return gatewayNetworkInterfaces;
    }

    /**
     * <p>
     * The type of the gateway.
     * </p>
     * 
     * @return The type of the gateway.
     */
    public final String gatewayType() {
        return gatewayType;
    }

    /**
     * <p>
     * The date on which an update to the gateway is available. This date is in the time zone of the gateway. If the
     * gateway is not available for an update this field is not returned in the response.
     * </p>
     * 
     * @return The date on which an update to the gateway is available. This date is in the time zone of the gateway. If
     *         the gateway is not available for an update this field is not returned in the response.
     */
    public final String nextUpdateAvailabilityDate() {
        return nextUpdateAvailabilityDate;
    }

    /**
     * <p>
     * The date on which the last software update was applied to the gateway. If the gateway has never been updated,
     * this field does not return a value in the response.
     * </p>
     * 
     * @return The date on which the last software update was applied to the gateway. If the gateway has never been
     *         updated, this field does not return a value in the response.
     */
    public final String lastSoftwareUpdate() {
        return lastSoftwareUpdate;
    }

    /**
     * <p>
     * The ID of the Amazon EC2 instance that was used to launch the gateway.
     * </p>
     * 
     * @return The ID of the Amazon EC2 instance that was used to launch the gateway.
     */
    public final String ec2InstanceId() {
        return ec2InstanceId;
    }

    /**
     * <p>
     * The Amazon Web Services Region where the Amazon EC2 instance is located.
     * </p>
     * 
     * @return The Amazon Web Services Region where the Amazon EC2 instance is located.
     */
    public final String ec2InstanceRegion() {
        return ec2InstanceRegion;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of up to 50 tags assigned to the gateway, sorted alphabetically by key name. Each tag is a key-value pair.
     * For a gateway with more than 10 tags assigned, you can view all tags using the <code>ListTagsForResource</code>
     * API operation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of up to 50 tags assigned to the gateway, sorted alphabetically by key name. Each tag is a
     *         key-value pair. For a gateway with more than 10 tags assigned, you can view all tags using the
     *         <code>ListTagsForResource</code> API operation.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The configuration settings for the virtual private cloud (VPC) endpoint for your gateway.
     * </p>
     * 
     * @return The configuration settings for the virtual private cloud (VPC) endpoint for your gateway.
     */
    public final String vpcEndpoint() {
        return vpcEndpoint;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon CloudWatch log group that is used to monitor events in the gateway.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon CloudWatch log group that is used to monitor events in the
     *         gateway.
     */
    public final String cloudWatchLogGroupARN() {
        return cloudWatchLogGroupARN;
    }

    /**
     * <p>
     * The type of hardware or software platform on which the gateway is running.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #hostEnvironment}
     * will return {@link HostEnvironment#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #hostEnvironmentAsString}.
     * </p>
     * 
     * @return The type of hardware or software platform on which the gateway is running.
     * @see HostEnvironment
     */
    public final HostEnvironment hostEnvironment() {
        return HostEnvironment.fromValue(hostEnvironment);
    }

    /**
     * <p>
     * The type of hardware or software platform on which the gateway is running.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #hostEnvironment}
     * will return {@link HostEnvironment#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #hostEnvironmentAsString}.
     * </p>
     * 
     * @return The type of hardware or software platform on which the gateway is running.
     * @see HostEnvironment
     */
    public final String hostEnvironmentAsString() {
        return hostEnvironment;
    }

    /**
     * <p>
     * The type of endpoint for your gateway.
     * </p>
     * <p>
     * Valid Values: <code>STANDARD</code> | <code>FIPS</code>
     * </p>
     * 
     * @return The type of endpoint for your gateway.</p>
     *         <p>
     *         Valid Values: <code>STANDARD</code> | <code>FIPS</code>
     */
    public final String endpointType() {
        return endpointType;
    }

    /**
     * <p>
     * Date after which this gateway will not receive software updates for new features.
     * </p>
     * 
     * @return Date after which this gateway will not receive software updates for new features.
     */
    public final String softwareUpdatesEndDate() {
        return softwareUpdatesEndDate;
    }

    /**
     * <p>
     * Date after which this gateway will not receive software updates for new features and bug fixes.
     * </p>
     * 
     * @return Date after which this gateway will not receive software updates for new features and bug fixes.
     */
    public final String deprecationDate() {
        return deprecationDate;
    }

    /**
     * <p>
     * Specifies the size of the gateway's metadata cache.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #gatewayCapacity}
     * will return {@link GatewayCapacity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #gatewayCapacityAsString}.
     * </p>
     * 
     * @return Specifies the size of the gateway's metadata cache.
     * @see GatewayCapacity
     */
    public final GatewayCapacity gatewayCapacity() {
        return GatewayCapacity.fromValue(gatewayCapacity);
    }

    /**
     * <p>
     * Specifies the size of the gateway's metadata cache.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #gatewayCapacity}
     * will return {@link GatewayCapacity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #gatewayCapacityAsString}.
     * </p>
     * 
     * @return Specifies the size of the gateway's metadata cache.
     * @see GatewayCapacity
     */
    public final String gatewayCapacityAsString() {
        return gatewayCapacity;
    }

    /**
     * <p>
     * A list of the metadata cache sizes that the gateway can support based on its current hardware specifications.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSupportedGatewayCapacities} method.
     * </p>
     * 
     * @return A list of the metadata cache sizes that the gateway can support based on its current hardware
     *         specifications.
     */
    public final List<GatewayCapacity> supportedGatewayCapacities() {
        return SupportedGatewayCapacitiesCopier.copyStringToEnum(supportedGatewayCapacities);
    }

    /**
     * For responses, this returns true if the service returned a value for the SupportedGatewayCapacities property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSupportedGatewayCapacities() {
        return supportedGatewayCapacities != null && !(supportedGatewayCapacities instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the metadata cache sizes that the gateway can support based on its current hardware specifications.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSupportedGatewayCapacities} method.
     * </p>
     * 
     * @return A list of the metadata cache sizes that the gateway can support based on its current hardware
     *         specifications.
     */
    public final List<String> supportedGatewayCapacitiesAsStrings() {
        return supportedGatewayCapacities;
    }

    /**
     * <p>
     * A unique identifier for the specific instance of the host platform running the gateway. This value is only
     * available for certain host environments, and its format depends on the host environment type.
     * </p>
     * 
     * @return A unique identifier for the specific instance of the host platform running the gateway. This value is
     *         only available for certain host environments, and its format depends on the host environment type.
     */
    public final String hostEnvironmentId() {
        return hostEnvironmentId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(gatewayARN());
        hashCode = 31 * hashCode + Objects.hashCode(gatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(gatewayName());
        hashCode = 31 * hashCode + Objects.hashCode(gatewayTimezone());
        hashCode = 31 * hashCode + Objects.hashCode(gatewayState());
        hashCode = 31 * hashCode + Objects.hashCode(hasGatewayNetworkInterfaces() ? gatewayNetworkInterfaces() : null);
        hashCode = 31 * hashCode + Objects.hashCode(gatewayType());
        hashCode = 31 * hashCode + Objects.hashCode(nextUpdateAvailabilityDate());
        hashCode = 31 * hashCode + Objects.hashCode(lastSoftwareUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(ec2InstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(ec2InstanceRegion());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(vpcEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(cloudWatchLogGroupARN());
        hashCode = 31 * hashCode + Objects.hashCode(hostEnvironmentAsString());
        hashCode = 31 * hashCode + Objects.hashCode(endpointType());
        hashCode = 31 * hashCode + Objects.hashCode(softwareUpdatesEndDate());
        hashCode = 31 * hashCode + Objects.hashCode(deprecationDate());
        hashCode = 31 * hashCode + Objects.hashCode(gatewayCapacityAsString());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasSupportedGatewayCapacities() ? supportedGatewayCapacitiesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hostEnvironmentId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeGatewayInformationResponse)) {
            return false;
        }
        DescribeGatewayInformationResponse other = (DescribeGatewayInformationResponse) obj;
        return Objects.equals(gatewayARN(), other.gatewayARN()) && Objects.equals(gatewayId(), other.gatewayId())
                && Objects.equals(gatewayName(), other.gatewayName())
                && Objects.equals(gatewayTimezone(), other.gatewayTimezone())
                && Objects.equals(gatewayState(), other.gatewayState())
                && hasGatewayNetworkInterfaces() == other.hasGatewayNetworkInterfaces()
                && Objects.equals(gatewayNetworkInterfaces(), other.gatewayNetworkInterfaces())
                && Objects.equals(gatewayType(), other.gatewayType())
                && Objects.equals(nextUpdateAvailabilityDate(), other.nextUpdateAvailabilityDate())
                && Objects.equals(lastSoftwareUpdate(), other.lastSoftwareUpdate())
                && Objects.equals(ec2InstanceId(), other.ec2InstanceId())
                && Objects.equals(ec2InstanceRegion(), other.ec2InstanceRegion()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(vpcEndpoint(), other.vpcEndpoint())
                && Objects.equals(cloudWatchLogGroupARN(), other.cloudWatchLogGroupARN())
                && Objects.equals(hostEnvironmentAsString(), other.hostEnvironmentAsString())
                && Objects.equals(endpointType(), other.endpointType())
                && Objects.equals(softwareUpdatesEndDate(), other.softwareUpdatesEndDate())
                && Objects.equals(deprecationDate(), other.deprecationDate())
                && Objects.equals(gatewayCapacityAsString(), other.gatewayCapacityAsString())
                && hasSupportedGatewayCapacities() == other.hasSupportedGatewayCapacities()
                && Objects.equals(supportedGatewayCapacitiesAsStrings(), other.supportedGatewayCapacitiesAsStrings())
                && Objects.equals(hostEnvironmentId(), other.hostEnvironmentId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("DescribeGatewayInformationResponse")
                .add("GatewayARN", gatewayARN())
                .add("GatewayId", gatewayId())
                .add("GatewayName", gatewayName())
                .add("GatewayTimezone", gatewayTimezone())
                .add("GatewayState", gatewayState())
                .add("GatewayNetworkInterfaces", hasGatewayNetworkInterfaces() ? gatewayNetworkInterfaces() : null)
                .add("GatewayType", gatewayType())
                .add("NextUpdateAvailabilityDate", nextUpdateAvailabilityDate())
                .add("LastSoftwareUpdate", lastSoftwareUpdate())
                .add("Ec2InstanceId", ec2InstanceId())
                .add("Ec2InstanceRegion", ec2InstanceRegion())
                .add("Tags", hasTags() ? tags() : null)
                .add("VPCEndpoint", vpcEndpoint())
                .add("CloudWatchLogGroupARN", cloudWatchLogGroupARN())
                .add("HostEnvironment", hostEnvironmentAsString())
                .add("EndpointType", endpointType())
                .add("SoftwareUpdatesEndDate", softwareUpdatesEndDate())
                .add("DeprecationDate", deprecationDate())
                .add("GatewayCapacity", gatewayCapacityAsString())
                .add("SupportedGatewayCapacities", hasSupportedGatewayCapacities() ? supportedGatewayCapacitiesAsStrings() : null)
                .add("HostEnvironmentId", hostEnvironmentId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GatewayARN":
            return Optional.ofNullable(clazz.cast(gatewayARN()));
        case "GatewayId":
            return Optional.ofNullable(clazz.cast(gatewayId()));
        case "GatewayName":
            return Optional.ofNullable(clazz.cast(gatewayName()));
        case "GatewayTimezone":
            return Optional.ofNullable(clazz.cast(gatewayTimezone()));
        case "GatewayState":
            return Optional.ofNullable(clazz.cast(gatewayState()));
        case "GatewayNetworkInterfaces":
            return Optional.ofNullable(clazz.cast(gatewayNetworkInterfaces()));
        case "GatewayType":
            return Optional.ofNullable(clazz.cast(gatewayType()));
        case "NextUpdateAvailabilityDate":
            return Optional.ofNullable(clazz.cast(nextUpdateAvailabilityDate()));
        case "LastSoftwareUpdate":
            return Optional.ofNullable(clazz.cast(lastSoftwareUpdate()));
        case "Ec2InstanceId":
            return Optional.ofNullable(clazz.cast(ec2InstanceId()));
        case "Ec2InstanceRegion":
            return Optional.ofNullable(clazz.cast(ec2InstanceRegion()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "VPCEndpoint":
            return Optional.ofNullable(clazz.cast(vpcEndpoint()));
        case "CloudWatchLogGroupARN":
            return Optional.ofNullable(clazz.cast(cloudWatchLogGroupARN()));
        case "HostEnvironment":
            return Optional.ofNullable(clazz.cast(hostEnvironmentAsString()));
        case "EndpointType":
            return Optional.ofNullable(clazz.cast(endpointType()));
        case "SoftwareUpdatesEndDate":
            return Optional.ofNullable(clazz.cast(softwareUpdatesEndDate()));
        case "DeprecationDate":
            return Optional.ofNullable(clazz.cast(deprecationDate()));
        case "GatewayCapacity":
            return Optional.ofNullable(clazz.cast(gatewayCapacityAsString()));
        case "SupportedGatewayCapacities":
            return Optional.ofNullable(clazz.cast(supportedGatewayCapacitiesAsStrings()));
        case "HostEnvironmentId":
            return Optional.ofNullable(clazz.cast(hostEnvironmentId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeGatewayInformationResponse, T> g) {
        return obj -> g.apply((DescribeGatewayInformationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends StorageGatewayResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeGatewayInformationResponse> {
        /**
         * Sets the value of the GatewayARN property for this object.
         *
         * @param gatewayARN
         *        The new value for the GatewayARN property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayARN(String gatewayARN);

        /**
         * <p>
         * The unique identifier assigned to your gateway during activation. This ID becomes part of the gateway Amazon
         * Resource Name (ARN), which you use as input for other operations.
         * </p>
         * 
         * @param gatewayId
         *        The unique identifier assigned to your gateway during activation. This ID becomes part of the gateway
         *        Amazon Resource Name (ARN), which you use as input for other operations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayId(String gatewayId);

        /**
         * <p>
         * The name you configured for your gateway.
         * </p>
         * 
         * @param gatewayName
         *        The name you configured for your gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayName(String gatewayName);

        /**
         * <p>
         * A value that indicates the time zone configured for the gateway.
         * </p>
         * 
         * @param gatewayTimezone
         *        A value that indicates the time zone configured for the gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayTimezone(String gatewayTimezone);

        /**
         * <p>
         * A value that indicates the operating state of the gateway.
         * </p>
         * 
         * @param gatewayState
         *        A value that indicates the operating state of the gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayState(String gatewayState);

        /**
         * <p>
         * A <a>NetworkInterface</a> array that contains descriptions of the gateway network interfaces.
         * </p>
         * 
         * @param gatewayNetworkInterfaces
         *        A <a>NetworkInterface</a> array that contains descriptions of the gateway network interfaces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayNetworkInterfaces(Collection<NetworkInterface> gatewayNetworkInterfaces);

        /**
         * <p>
         * A <a>NetworkInterface</a> array that contains descriptions of the gateway network interfaces.
         * </p>
         * 
         * @param gatewayNetworkInterfaces
         *        A <a>NetworkInterface</a> array that contains descriptions of the gateway network interfaces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayNetworkInterfaces(NetworkInterface... gatewayNetworkInterfaces);

        /**
         * <p>
         * A <a>NetworkInterface</a> array that contains descriptions of the gateway network interfaces.
         * </p>
         * This is a convenience that creates an instance of the {@link List<NetworkInterface>.Builder} avoiding the
         * need to create one manually via {@link List<NetworkInterface>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<NetworkInterface>.Builder#build()} is called immediately and
         * its result is passed to {@link #gatewayNetworkInterfaces(List<NetworkInterface>)}.
         * 
         * @param gatewayNetworkInterfaces
         *        a consumer that will call methods on {@link List<NetworkInterface>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #gatewayNetworkInterfaces(List<NetworkInterface>)
         */
        Builder gatewayNetworkInterfaces(Consumer<NetworkInterface.Builder>... gatewayNetworkInterfaces);

        /**
         * <p>
         * The type of the gateway.
         * </p>
         * 
         * @param gatewayType
         *        The type of the gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayType(String gatewayType);

        /**
         * <p>
         * The date on which an update to the gateway is available. This date is in the time zone of the gateway. If the
         * gateway is not available for an update this field is not returned in the response.
         * </p>
         * 
         * @param nextUpdateAvailabilityDate
         *        The date on which an update to the gateway is available. This date is in the time zone of the gateway.
         *        If the gateway is not available for an update this field is not returned in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextUpdateAvailabilityDate(String nextUpdateAvailabilityDate);

        /**
         * <p>
         * The date on which the last software update was applied to the gateway. If the gateway has never been updated,
         * this field does not return a value in the response.
         * </p>
         * 
         * @param lastSoftwareUpdate
         *        The date on which the last software update was applied to the gateway. If the gateway has never been
         *        updated, this field does not return a value in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastSoftwareUpdate(String lastSoftwareUpdate);

        /**
         * <p>
         * The ID of the Amazon EC2 instance that was used to launch the gateway.
         * </p>
         * 
         * @param ec2InstanceId
         *        The ID of the Amazon EC2 instance that was used to launch the gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2InstanceId(String ec2InstanceId);

        /**
         * <p>
         * The Amazon Web Services Region where the Amazon EC2 instance is located.
         * </p>
         * 
         * @param ec2InstanceRegion
         *        The Amazon Web Services Region where the Amazon EC2 instance is located.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2InstanceRegion(String ec2InstanceRegion);

        /**
         * <p>
         * A list of up to 50 tags assigned to the gateway, sorted alphabetically by key name. Each tag is a key-value
         * pair. For a gateway with more than 10 tags assigned, you can view all tags using the
         * <code>ListTagsForResource</code> API operation.
         * </p>
         * 
         * @param tags
         *        A list of up to 50 tags assigned to the gateway, sorted alphabetically by key name. Each tag is a
         *        key-value pair. For a gateway with more than 10 tags assigned, you can view all tags using the
         *        <code>ListTagsForResource</code> API operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of up to 50 tags assigned to the gateway, sorted alphabetically by key name. Each tag is a key-value
         * pair. For a gateway with more than 10 tags assigned, you can view all tags using the
         * <code>ListTagsForResource</code> API operation.
         * </p>
         * 
         * @param tags
         *        A list of up to 50 tags assigned to the gateway, sorted alphabetically by key name. Each tag is a
         *        key-value pair. For a gateway with more than 10 tags assigned, you can view all tags using the
         *        <code>ListTagsForResource</code> API operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of up to 50 tags assigned to the gateway, sorted alphabetically by key name. Each tag is a key-value
         * pair. For a gateway with more than 10 tags assigned, you can view all tags using the
         * <code>ListTagsForResource</code> API operation.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The configuration settings for the virtual private cloud (VPC) endpoint for your gateway.
         * </p>
         * 
         * @param vpcEndpoint
         *        The configuration settings for the virtual private cloud (VPC) endpoint for your gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcEndpoint(String vpcEndpoint);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Amazon CloudWatch log group that is used to monitor events in the
         * gateway.
         * </p>
         * 
         * @param cloudWatchLogGroupARN
         *        The Amazon Resource Name (ARN) of the Amazon CloudWatch log group that is used to monitor events in
         *        the gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchLogGroupARN(String cloudWatchLogGroupARN);

        /**
         * <p>
         * The type of hardware or software platform on which the gateway is running.
         * </p>
         * 
         * @param hostEnvironment
         *        The type of hardware or software platform on which the gateway is running.
         * @see HostEnvironment
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HostEnvironment
         */
        Builder hostEnvironment(String hostEnvironment);

        /**
         * <p>
         * The type of hardware or software platform on which the gateway is running.
         * </p>
         * 
         * @param hostEnvironment
         *        The type of hardware or software platform on which the gateway is running.
         * @see HostEnvironment
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HostEnvironment
         */
        Builder hostEnvironment(HostEnvironment hostEnvironment);

        /**
         * <p>
         * The type of endpoint for your gateway.
         * </p>
         * <p>
         * Valid Values: <code>STANDARD</code> | <code>FIPS</code>
         * </p>
         * 
         * @param endpointType
         *        The type of endpoint for your gateway.</p>
         *        <p>
         *        Valid Values: <code>STANDARD</code> | <code>FIPS</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointType(String endpointType);

        /**
         * <p>
         * Date after which this gateway will not receive software updates for new features.
         * </p>
         * 
         * @param softwareUpdatesEndDate
         *        Date after which this gateway will not receive software updates for new features.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder softwareUpdatesEndDate(String softwareUpdatesEndDate);

        /**
         * <p>
         * Date after which this gateway will not receive software updates for new features and bug fixes.
         * </p>
         * 
         * @param deprecationDate
         *        Date after which this gateway will not receive software updates for new features and bug fixes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deprecationDate(String deprecationDate);

        /**
         * <p>
         * Specifies the size of the gateway's metadata cache.
         * </p>
         * 
         * @param gatewayCapacity
         *        Specifies the size of the gateway's metadata cache.
         * @see GatewayCapacity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GatewayCapacity
         */
        Builder gatewayCapacity(String gatewayCapacity);

        /**
         * <p>
         * Specifies the size of the gateway's metadata cache.
         * </p>
         * 
         * @param gatewayCapacity
         *        Specifies the size of the gateway's metadata cache.
         * @see GatewayCapacity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GatewayCapacity
         */
        Builder gatewayCapacity(GatewayCapacity gatewayCapacity);

        /**
         * <p>
         * A list of the metadata cache sizes that the gateway can support based on its current hardware specifications.
         * </p>
         * 
         * @param supportedGatewayCapacities
         *        A list of the metadata cache sizes that the gateway can support based on its current hardware
         *        specifications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedGatewayCapacitiesWithStrings(Collection<String> supportedGatewayCapacities);

        /**
         * <p>
         * A list of the metadata cache sizes that the gateway can support based on its current hardware specifications.
         * </p>
         * 
         * @param supportedGatewayCapacities
         *        A list of the metadata cache sizes that the gateway can support based on its current hardware
         *        specifications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedGatewayCapacitiesWithStrings(String... supportedGatewayCapacities);

        /**
         * <p>
         * A list of the metadata cache sizes that the gateway can support based on its current hardware specifications.
         * </p>
         * 
         * @param supportedGatewayCapacities
         *        A list of the metadata cache sizes that the gateway can support based on its current hardware
         *        specifications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedGatewayCapacities(Collection<GatewayCapacity> supportedGatewayCapacities);

        /**
         * <p>
         * A list of the metadata cache sizes that the gateway can support based on its current hardware specifications.
         * </p>
         * 
         * @param supportedGatewayCapacities
         *        A list of the metadata cache sizes that the gateway can support based on its current hardware
         *        specifications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedGatewayCapacities(GatewayCapacity... supportedGatewayCapacities);

        /**
         * <p>
         * A unique identifier for the specific instance of the host platform running the gateway. This value is only
         * available for certain host environments, and its format depends on the host environment type.
         * </p>
         * 
         * @param hostEnvironmentId
         *        A unique identifier for the specific instance of the host platform running the gateway. This value is
         *        only available for certain host environments, and its format depends on the host environment type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostEnvironmentId(String hostEnvironmentId);
    }

    static final class BuilderImpl extends StorageGatewayResponse.BuilderImpl implements Builder {
        private String gatewayARN;

        private String gatewayId;

        private String gatewayName;

        private String gatewayTimezone;

        private String gatewayState;

        private List<NetworkInterface> gatewayNetworkInterfaces = DefaultSdkAutoConstructList.getInstance();

        private String gatewayType;

        private String nextUpdateAvailabilityDate;

        private String lastSoftwareUpdate;

        private String ec2InstanceId;

        private String ec2InstanceRegion;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String vpcEndpoint;

        private String cloudWatchLogGroupARN;

        private String hostEnvironment;

        private String endpointType;

        private String softwareUpdatesEndDate;

        private String deprecationDate;

        private String gatewayCapacity;

        private List<String> supportedGatewayCapacities = DefaultSdkAutoConstructList.getInstance();

        private String hostEnvironmentId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeGatewayInformationResponse model) {
            super(model);
            gatewayARN(model.gatewayARN);
            gatewayId(model.gatewayId);
            gatewayName(model.gatewayName);
            gatewayTimezone(model.gatewayTimezone);
            gatewayState(model.gatewayState);
            gatewayNetworkInterfaces(model.gatewayNetworkInterfaces);
            gatewayType(model.gatewayType);
            nextUpdateAvailabilityDate(model.nextUpdateAvailabilityDate);
            lastSoftwareUpdate(model.lastSoftwareUpdate);
            ec2InstanceId(model.ec2InstanceId);
            ec2InstanceRegion(model.ec2InstanceRegion);
            tags(model.tags);
            vpcEndpoint(model.vpcEndpoint);
            cloudWatchLogGroupARN(model.cloudWatchLogGroupARN);
            hostEnvironment(model.hostEnvironment);
            endpointType(model.endpointType);
            softwareUpdatesEndDate(model.softwareUpdatesEndDate);
            deprecationDate(model.deprecationDate);
            gatewayCapacity(model.gatewayCapacity);
            supportedGatewayCapacitiesWithStrings(model.supportedGatewayCapacities);
            hostEnvironmentId(model.hostEnvironmentId);
        }

        public final String getGatewayARN() {
            return gatewayARN;
        }

        public final void setGatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
        }

        @Override
        @Transient
        public final Builder gatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
            return this;
        }

        public final String getGatewayId() {
            return gatewayId;
        }

        public final void setGatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
        }

        @Override
        @Transient
        public final Builder gatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
            return this;
        }

        public final String getGatewayName() {
            return gatewayName;
        }

        public final void setGatewayName(String gatewayName) {
            this.gatewayName = gatewayName;
        }

        @Override
        @Transient
        public final Builder gatewayName(String gatewayName) {
            this.gatewayName = gatewayName;
            return this;
        }

        public final String getGatewayTimezone() {
            return gatewayTimezone;
        }

        public final void setGatewayTimezone(String gatewayTimezone) {
            this.gatewayTimezone = gatewayTimezone;
        }

        @Override
        @Transient
        public final Builder gatewayTimezone(String gatewayTimezone) {
            this.gatewayTimezone = gatewayTimezone;
            return this;
        }

        public final String getGatewayState() {
            return gatewayState;
        }

        public final void setGatewayState(String gatewayState) {
            this.gatewayState = gatewayState;
        }

        @Override
        @Transient
        public final Builder gatewayState(String gatewayState) {
            this.gatewayState = gatewayState;
            return this;
        }

        public final List<NetworkInterface.Builder> getGatewayNetworkInterfaces() {
            List<NetworkInterface.Builder> result = GatewayNetworkInterfacesCopier.copyToBuilder(this.gatewayNetworkInterfaces);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGatewayNetworkInterfaces(Collection<NetworkInterface.BuilderImpl> gatewayNetworkInterfaces) {
            this.gatewayNetworkInterfaces = GatewayNetworkInterfacesCopier.copyFromBuilder(gatewayNetworkInterfaces);
        }

        @Override
        @Transient
        public final Builder gatewayNetworkInterfaces(Collection<NetworkInterface> gatewayNetworkInterfaces) {
            this.gatewayNetworkInterfaces = GatewayNetworkInterfacesCopier.copy(gatewayNetworkInterfaces);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder gatewayNetworkInterfaces(NetworkInterface... gatewayNetworkInterfaces) {
            gatewayNetworkInterfaces(Arrays.asList(gatewayNetworkInterfaces));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder gatewayNetworkInterfaces(Consumer<NetworkInterface.Builder>... gatewayNetworkInterfaces) {
            gatewayNetworkInterfaces(Stream.of(gatewayNetworkInterfaces)
                    .map(c -> NetworkInterface.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getGatewayType() {
            return gatewayType;
        }

        public final void setGatewayType(String gatewayType) {
            this.gatewayType = gatewayType;
        }

        @Override
        @Transient
        public final Builder gatewayType(String gatewayType) {
            this.gatewayType = gatewayType;
            return this;
        }

        public final String getNextUpdateAvailabilityDate() {
            return nextUpdateAvailabilityDate;
        }

        public final void setNextUpdateAvailabilityDate(String nextUpdateAvailabilityDate) {
            this.nextUpdateAvailabilityDate = nextUpdateAvailabilityDate;
        }

        @Override
        @Transient
        public final Builder nextUpdateAvailabilityDate(String nextUpdateAvailabilityDate) {
            this.nextUpdateAvailabilityDate = nextUpdateAvailabilityDate;
            return this;
        }

        public final String getLastSoftwareUpdate() {
            return lastSoftwareUpdate;
        }

        public final void setLastSoftwareUpdate(String lastSoftwareUpdate) {
            this.lastSoftwareUpdate = lastSoftwareUpdate;
        }

        @Override
        @Transient
        public final Builder lastSoftwareUpdate(String lastSoftwareUpdate) {
            this.lastSoftwareUpdate = lastSoftwareUpdate;
            return this;
        }

        public final String getEc2InstanceId() {
            return ec2InstanceId;
        }

        public final void setEc2InstanceId(String ec2InstanceId) {
            this.ec2InstanceId = ec2InstanceId;
        }

        @Override
        @Transient
        public final Builder ec2InstanceId(String ec2InstanceId) {
            this.ec2InstanceId = ec2InstanceId;
            return this;
        }

        public final String getEc2InstanceRegion() {
            return ec2InstanceRegion;
        }

        public final void setEc2InstanceRegion(String ec2InstanceRegion) {
            this.ec2InstanceRegion = ec2InstanceRegion;
        }

        @Override
        @Transient
        public final Builder ec2InstanceRegion(String ec2InstanceRegion) {
            this.ec2InstanceRegion = ec2InstanceRegion;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        @Transient
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getVpcEndpoint() {
            return vpcEndpoint;
        }

        public final void setVpcEndpoint(String vpcEndpoint) {
            this.vpcEndpoint = vpcEndpoint;
        }

        @Override
        @Transient
        public final Builder vpcEndpoint(String vpcEndpoint) {
            this.vpcEndpoint = vpcEndpoint;
            return this;
        }

        public final String getCloudWatchLogGroupARN() {
            return cloudWatchLogGroupARN;
        }

        public final void setCloudWatchLogGroupARN(String cloudWatchLogGroupARN) {
            this.cloudWatchLogGroupARN = cloudWatchLogGroupARN;
        }

        @Override
        @Transient
        public final Builder cloudWatchLogGroupARN(String cloudWatchLogGroupARN) {
            this.cloudWatchLogGroupARN = cloudWatchLogGroupARN;
            return this;
        }

        public final String getHostEnvironment() {
            return hostEnvironment;
        }

        public final void setHostEnvironment(String hostEnvironment) {
            this.hostEnvironment = hostEnvironment;
        }

        @Override
        @Transient
        public final Builder hostEnvironment(String hostEnvironment) {
            this.hostEnvironment = hostEnvironment;
            return this;
        }

        @Override
        @Transient
        public final Builder hostEnvironment(HostEnvironment hostEnvironment) {
            this.hostEnvironment(hostEnvironment == null ? null : hostEnvironment.toString());
            return this;
        }

        public final String getEndpointType() {
            return endpointType;
        }

        public final void setEndpointType(String endpointType) {
            this.endpointType = endpointType;
        }

        @Override
        @Transient
        public final Builder endpointType(String endpointType) {
            this.endpointType = endpointType;
            return this;
        }

        public final String getSoftwareUpdatesEndDate() {
            return softwareUpdatesEndDate;
        }

        public final void setSoftwareUpdatesEndDate(String softwareUpdatesEndDate) {
            this.softwareUpdatesEndDate = softwareUpdatesEndDate;
        }

        @Override
        @Transient
        public final Builder softwareUpdatesEndDate(String softwareUpdatesEndDate) {
            this.softwareUpdatesEndDate = softwareUpdatesEndDate;
            return this;
        }

        public final String getDeprecationDate() {
            return deprecationDate;
        }

        public final void setDeprecationDate(String deprecationDate) {
            this.deprecationDate = deprecationDate;
        }

        @Override
        @Transient
        public final Builder deprecationDate(String deprecationDate) {
            this.deprecationDate = deprecationDate;
            return this;
        }

        public final String getGatewayCapacity() {
            return gatewayCapacity;
        }

        public final void setGatewayCapacity(String gatewayCapacity) {
            this.gatewayCapacity = gatewayCapacity;
        }

        @Override
        @Transient
        public final Builder gatewayCapacity(String gatewayCapacity) {
            this.gatewayCapacity = gatewayCapacity;
            return this;
        }

        @Override
        @Transient
        public final Builder gatewayCapacity(GatewayCapacity gatewayCapacity) {
            this.gatewayCapacity(gatewayCapacity == null ? null : gatewayCapacity.toString());
            return this;
        }

        public final Collection<String> getSupportedGatewayCapacities() {
            if (supportedGatewayCapacities instanceof SdkAutoConstructList) {
                return null;
            }
            return supportedGatewayCapacities;
        }

        public final void setSupportedGatewayCapacities(Collection<String> supportedGatewayCapacities) {
            this.supportedGatewayCapacities = SupportedGatewayCapacitiesCopier.copy(supportedGatewayCapacities);
        }

        @Override
        @Transient
        public final Builder supportedGatewayCapacitiesWithStrings(Collection<String> supportedGatewayCapacities) {
            this.supportedGatewayCapacities = SupportedGatewayCapacitiesCopier.copy(supportedGatewayCapacities);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder supportedGatewayCapacitiesWithStrings(String... supportedGatewayCapacities) {
            supportedGatewayCapacitiesWithStrings(Arrays.asList(supportedGatewayCapacities));
            return this;
        }

        @Override
        @Transient
        public final Builder supportedGatewayCapacities(Collection<GatewayCapacity> supportedGatewayCapacities) {
            this.supportedGatewayCapacities = SupportedGatewayCapacitiesCopier.copyEnumToString(supportedGatewayCapacities);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder supportedGatewayCapacities(GatewayCapacity... supportedGatewayCapacities) {
            supportedGatewayCapacities(Arrays.asList(supportedGatewayCapacities));
            return this;
        }

        public final String getHostEnvironmentId() {
            return hostEnvironmentId;
        }

        public final void setHostEnvironmentId(String hostEnvironmentId) {
            this.hostEnvironmentId = hostEnvironmentId;
        }

        @Override
        @Transient
        public final Builder hostEnvironmentId(String hostEnvironmentId) {
            this.hostEnvironmentId = hostEnvironmentId;
            return this;
        }

        @Override
        public DescribeGatewayInformationResponse build() {
            return new DescribeGatewayInformationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
