/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NetworkInterface
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NetworkInterface> {
    private static final SdkField<String> IPV4_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Ipv4Address").getter(NetworkInterface.getter(NetworkInterface::ipv4Address)).setter(NetworkInterface.setter(Builder::ipv4Address)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv4Address").build()}).build();
    private static final SdkField<String> MAC_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MacAddress").getter(NetworkInterface.getter(NetworkInterface::macAddress)).setter(NetworkInterface.setter(Builder::macAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MacAddress").build()}).build();
    private static final SdkField<String> IPV6_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Ipv6Address").getter(NetworkInterface.getter(NetworkInterface::ipv6Address)).setter(NetworkInterface.setter(Builder::ipv6Address)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6Address").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IPV4_ADDRESS_FIELD, MAC_ADDRESS_FIELD, IPV6_ADDRESS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String ipv4Address;
    private final String macAddress;
    private final String ipv6Address;

    private NetworkInterface(BuilderImpl builder) {
        this.ipv4Address = builder.ipv4Address;
        this.macAddress = builder.macAddress;
        this.ipv6Address = builder.ipv6Address;
    }

    public final String ipv4Address() {
        return this.ipv4Address;
    }

    public final String macAddress() {
        return this.macAddress;
    }

    public final String ipv6Address() {
        return this.ipv6Address;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ipv4Address());
        hashCode = 31 * hashCode + Objects.hashCode(this.macAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipv6Address());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkInterface)) {
            return false;
        }
        NetworkInterface other = (NetworkInterface)obj;
        return Objects.equals(this.ipv4Address(), other.ipv4Address()) && Objects.equals(this.macAddress(), other.macAddress()) && Objects.equals(this.ipv6Address(), other.ipv6Address());
    }

    public final String toString() {
        return ToString.builder((String)"NetworkInterface").add("Ipv4Address", (Object)this.ipv4Address()).add("MacAddress", (Object)this.macAddress()).add("Ipv6Address", (Object)this.ipv6Address()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Ipv4Address": {
                return Optional.ofNullable(clazz.cast(this.ipv4Address()));
            }
            case "MacAddress": {
                return Optional.ofNullable(clazz.cast(this.macAddress()));
            }
            case "Ipv6Address": {
                return Optional.ofNullable(clazz.cast(this.ipv6Address()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NetworkInterface, T> g) {
        return obj -> g.apply((NetworkInterface)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String ipv4Address;
        private String macAddress;
        private String ipv6Address;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkInterface model) {
            this.ipv4Address(model.ipv4Address);
            this.macAddress(model.macAddress);
            this.ipv6Address(model.ipv6Address);
        }

        public final String getIpv4Address() {
            return this.ipv4Address;
        }

        public final void setIpv4Address(String ipv4Address) {
            this.ipv4Address = ipv4Address;
        }

        @Override
        @Transient
        public final Builder ipv4Address(String ipv4Address) {
            this.ipv4Address = ipv4Address;
            return this;
        }

        public final String getMacAddress() {
            return this.macAddress;
        }

        public final void setMacAddress(String macAddress) {
            this.macAddress = macAddress;
        }

        @Override
        @Transient
        public final Builder macAddress(String macAddress) {
            this.macAddress = macAddress;
            return this;
        }

        public final String getIpv6Address() {
            return this.ipv6Address;
        }

        public final void setIpv6Address(String ipv6Address) {
            this.ipv6Address = ipv6Address;
        }

        @Override
        @Transient
        public final Builder ipv6Address(String ipv6Address) {
            this.ipv6Address = ipv6Address;
            return this;
        }

        public NetworkInterface build() {
            return new NetworkInterface(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NetworkInterface> {
        public Builder ipv4Address(String var1);

        public Builder macAddress(String var1);

        public Builder ipv6Address(String var1);
    }
}

