/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssignTapePoolRequest extends StorageGatewayRequest implements
        ToCopyableBuilder<AssignTapePoolRequest.Builder, AssignTapePoolRequest> {
    private static final SdkField<String> TAPE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TapeARN").getter(getter(AssignTapePoolRequest::tapeARN)).setter(setter(Builder::tapeARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TapeARN").build()).build();

    private static final SdkField<String> POOL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("PoolId")
            .getter(getter(AssignTapePoolRequest::poolId)).setter(setter(Builder::poolId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoolId").build()).build();

    private static final SdkField<Boolean> BYPASS_GOVERNANCE_RETENTION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("BypassGovernanceRetention")
            .getter(getter(AssignTapePoolRequest::bypassGovernanceRetention)).setter(setter(Builder::bypassGovernanceRetention))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BypassGovernanceRetention").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TAPE_ARN_FIELD, POOL_ID_FIELD,
            BYPASS_GOVERNANCE_RETENTION_FIELD));

    private final String tapeARN;

    private final String poolId;

    private final Boolean bypassGovernanceRetention;

    private AssignTapePoolRequest(BuilderImpl builder) {
        super(builder);
        this.tapeARN = builder.tapeARN;
        this.poolId = builder.poolId;
        this.bypassGovernanceRetention = builder.bypassGovernanceRetention;
    }

    /**
     * <p>
     * The unique Amazon Resource Name (ARN) of the virtual tape that you want to add to the tape pool.
     * </p>
     * 
     * @return The unique Amazon Resource Name (ARN) of the virtual tape that you want to add to the tape pool.
     */
    public final String tapeARN() {
        return tapeARN;
    }

    /**
     * <p>
     * The ID of the pool that you want to add your tape to for archiving. The tape in this pool is archived in the S3
     * storage class that is associated with the pool. When you use your backup application to eject the tape, the tape
     * is archived directly into the storage class (S3 Glacier or S3 Glacier Deep Archive) that corresponds to the pool.
     * </p>
     * <p>
     * Valid Values: <code>GLACIER</code> | <code>DEEP_ARCHIVE</code>
     * </p>
     * 
     * @return The ID of the pool that you want to add your tape to for archiving. The tape in this pool is archived in
     *         the S3 storage class that is associated with the pool. When you use your backup application to eject the
     *         tape, the tape is archived directly into the storage class (S3 Glacier or S3 Glacier Deep Archive) that
     *         corresponds to the pool.</p>
     *         <p>
     *         Valid Values: <code>GLACIER</code> | <code>DEEP_ARCHIVE</code>
     */
    public final String poolId() {
        return poolId;
    }

    /**
     * <p>
     * Set permissions to bypass governance retention. If the lock type of the archived tape is <code>Governance</code>,
     * the tape's archived age is not older than <code>RetentionLockInDays</code>, and the user does not already have
     * <code>BypassGovernanceRetention</code>, setting this to TRUE enables the user to bypass the retention lock. This
     * parameter is set to true by default for calls from the console.
     * </p>
     * <p>
     * Valid values: <code>TRUE</code> | <code>FALSE</code>
     * </p>
     * 
     * @return Set permissions to bypass governance retention. If the lock type of the archived tape is
     *         <code>Governance</code>, the tape's archived age is not older than <code>RetentionLockInDays</code>, and
     *         the user does not already have <code>BypassGovernanceRetention</code>, setting this to TRUE enables the
     *         user to bypass the retention lock. This parameter is set to true by default for calls from the
     *         console.</p>
     *         <p>
     *         Valid values: <code>TRUE</code> | <code>FALSE</code>
     */
    public final Boolean bypassGovernanceRetention() {
        return bypassGovernanceRetention;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(tapeARN());
        hashCode = 31 * hashCode + Objects.hashCode(poolId());
        hashCode = 31 * hashCode + Objects.hashCode(bypassGovernanceRetention());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssignTapePoolRequest)) {
            return false;
        }
        AssignTapePoolRequest other = (AssignTapePoolRequest) obj;
        return Objects.equals(tapeARN(), other.tapeARN()) && Objects.equals(poolId(), other.poolId())
                && Objects.equals(bypassGovernanceRetention(), other.bypassGovernanceRetention());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssignTapePoolRequest").add("TapeARN", tapeARN()).add("PoolId", poolId())
                .add("BypassGovernanceRetention", bypassGovernanceRetention()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TapeARN":
            return Optional.ofNullable(clazz.cast(tapeARN()));
        case "PoolId":
            return Optional.ofNullable(clazz.cast(poolId()));
        case "BypassGovernanceRetention":
            return Optional.ofNullable(clazz.cast(bypassGovernanceRetention()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssignTapePoolRequest, T> g) {
        return obj -> g.apply((AssignTapePoolRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends StorageGatewayRequest.Builder, SdkPojo, CopyableBuilder<Builder, AssignTapePoolRequest> {
        /**
         * <p>
         * The unique Amazon Resource Name (ARN) of the virtual tape that you want to add to the tape pool.
         * </p>
         * 
         * @param tapeARN
         *        The unique Amazon Resource Name (ARN) of the virtual tape that you want to add to the tape pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tapeARN(String tapeARN);

        /**
         * <p>
         * The ID of the pool that you want to add your tape to for archiving. The tape in this pool is archived in the
         * S3 storage class that is associated with the pool. When you use your backup application to eject the tape,
         * the tape is archived directly into the storage class (S3 Glacier or S3 Glacier Deep Archive) that corresponds
         * to the pool.
         * </p>
         * <p>
         * Valid Values: <code>GLACIER</code> | <code>DEEP_ARCHIVE</code>
         * </p>
         * 
         * @param poolId
         *        The ID of the pool that you want to add your tape to for archiving. The tape in this pool is archived
         *        in the S3 storage class that is associated with the pool. When you use your backup application to
         *        eject the tape, the tape is archived directly into the storage class (S3 Glacier or S3 Glacier Deep
         *        Archive) that corresponds to the pool.</p>
         *        <p>
         *        Valid Values: <code>GLACIER</code> | <code>DEEP_ARCHIVE</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder poolId(String poolId);

        /**
         * <p>
         * Set permissions to bypass governance retention. If the lock type of the archived tape is
         * <code>Governance</code>, the tape's archived age is not older than <code>RetentionLockInDays</code>, and the
         * user does not already have <code>BypassGovernanceRetention</code>, setting this to TRUE enables the user to
         * bypass the retention lock. This parameter is set to true by default for calls from the console.
         * </p>
         * <p>
         * Valid values: <code>TRUE</code> | <code>FALSE</code>
         * </p>
         * 
         * @param bypassGovernanceRetention
         *        Set permissions to bypass governance retention. If the lock type of the archived tape is
         *        <code>Governance</code>, the tape's archived age is not older than <code>RetentionLockInDays</code>,
         *        and the user does not already have <code>BypassGovernanceRetention</code>, setting this to TRUE
         *        enables the user to bypass the retention lock. This parameter is set to true by default for calls from
         *        the console.</p>
         *        <p>
         *        Valid values: <code>TRUE</code> | <code>FALSE</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bypassGovernanceRetention(Boolean bypassGovernanceRetention);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends StorageGatewayRequest.BuilderImpl implements Builder {
        private String tapeARN;

        private String poolId;

        private Boolean bypassGovernanceRetention;

        private BuilderImpl() {
        }

        private BuilderImpl(AssignTapePoolRequest model) {
            super(model);
            tapeARN(model.tapeARN);
            poolId(model.poolId);
            bypassGovernanceRetention(model.bypassGovernanceRetention);
        }

        public final String getTapeARN() {
            return tapeARN;
        }

        public final void setTapeARN(String tapeARN) {
            this.tapeARN = tapeARN;
        }

        @Override
        public final Builder tapeARN(String tapeARN) {
            this.tapeARN = tapeARN;
            return this;
        }

        public final String getPoolId() {
            return poolId;
        }

        public final void setPoolId(String poolId) {
            this.poolId = poolId;
        }

        @Override
        public final Builder poolId(String poolId) {
            this.poolId = poolId;
            return this;
        }

        public final Boolean getBypassGovernanceRetention() {
            return bypassGovernanceRetention;
        }

        public final void setBypassGovernanceRetention(Boolean bypassGovernanceRetention) {
            this.bypassGovernanceRetention = bypassGovernanceRetention;
        }

        @Override
        public final Builder bypassGovernanceRetention(Boolean bypassGovernanceRetention) {
            this.bypassGovernanceRetention = bypassGovernanceRetention;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssignTapePoolRequest build() {
            return new AssignTapePoolRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
