/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the gateway's automatic tape creation policies, including the automatic tape creation rules and the
 * gateway that is using the policies.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutomaticTapeCreationPolicyInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<AutomaticTapeCreationPolicyInfo.Builder, AutomaticTapeCreationPolicyInfo> {
    private static final SdkField<List<AutomaticTapeCreationRule>> AUTOMATIC_TAPE_CREATION_RULES_FIELD = SdkField
            .<List<AutomaticTapeCreationRule>> builder(MarshallingType.LIST)
            .memberName("AutomaticTapeCreationRules")
            .getter(getter(AutomaticTapeCreationPolicyInfo::automaticTapeCreationRules))
            .setter(setter(Builder::automaticTapeCreationRules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutomaticTapeCreationRules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AutomaticTapeCreationRule> builder(MarshallingType.SDK_POJO)
                                            .constructor(AutomaticTapeCreationRule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> GATEWAY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GatewayARN").getter(getter(AutomaticTapeCreationPolicyInfo::gatewayARN))
            .setter(setter(Builder::gatewayARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayARN").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            AUTOMATIC_TAPE_CREATION_RULES_FIELD, GATEWAY_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<AutomaticTapeCreationRule> automaticTapeCreationRules;

    private final String gatewayARN;

    private AutomaticTapeCreationPolicyInfo(BuilderImpl builder) {
        this.automaticTapeCreationRules = builder.automaticTapeCreationRules;
        this.gatewayARN = builder.gatewayARN;
    }

    /**
     * For responses, this returns true if the service returned a value for the AutomaticTapeCreationRules property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAutomaticTapeCreationRules() {
        return automaticTapeCreationRules != null && !(automaticTapeCreationRules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An automatic tape creation policy consists of a list of automatic tape creation rules. This returns the rules
     * that determine when and how to automatically create new tapes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAutomaticTapeCreationRules} method.
     * </p>
     * 
     * @return An automatic tape creation policy consists of a list of automatic tape creation rules. This returns the
     *         rules that determine when and how to automatically create new tapes.
     */
    public final List<AutomaticTapeCreationRule> automaticTapeCreationRules() {
        return automaticTapeCreationRules;
    }

    /**
     * Returns the value of the GatewayARN property for this object.
     * 
     * @return The value of the GatewayARN property for this object.
     */
    public final String gatewayARN() {
        return gatewayARN;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAutomaticTapeCreationRules() ? automaticTapeCreationRules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(gatewayARN());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutomaticTapeCreationPolicyInfo)) {
            return false;
        }
        AutomaticTapeCreationPolicyInfo other = (AutomaticTapeCreationPolicyInfo) obj;
        return hasAutomaticTapeCreationRules() == other.hasAutomaticTapeCreationRules()
                && Objects.equals(automaticTapeCreationRules(), other.automaticTapeCreationRules())
                && Objects.equals(gatewayARN(), other.gatewayARN());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutomaticTapeCreationPolicyInfo")
                .add("AutomaticTapeCreationRules", hasAutomaticTapeCreationRules() ? automaticTapeCreationRules() : null)
                .add("GatewayARN", gatewayARN()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutomaticTapeCreationRules":
            return Optional.ofNullable(clazz.cast(automaticTapeCreationRules()));
        case "GatewayARN":
            return Optional.ofNullable(clazz.cast(gatewayARN()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AutomaticTapeCreationPolicyInfo, T> g) {
        return obj -> g.apply((AutomaticTapeCreationPolicyInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutomaticTapeCreationPolicyInfo> {
        /**
         * <p>
         * An automatic tape creation policy consists of a list of automatic tape creation rules. This returns the rules
         * that determine when and how to automatically create new tapes.
         * </p>
         * 
         * @param automaticTapeCreationRules
         *        An automatic tape creation policy consists of a list of automatic tape creation rules. This returns
         *        the rules that determine when and how to automatically create new tapes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder automaticTapeCreationRules(Collection<AutomaticTapeCreationRule> automaticTapeCreationRules);

        /**
         * <p>
         * An automatic tape creation policy consists of a list of automatic tape creation rules. This returns the rules
         * that determine when and how to automatically create new tapes.
         * </p>
         * 
         * @param automaticTapeCreationRules
         *        An automatic tape creation policy consists of a list of automatic tape creation rules. This returns
         *        the rules that determine when and how to automatically create new tapes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder automaticTapeCreationRules(AutomaticTapeCreationRule... automaticTapeCreationRules);

        /**
         * <p>
         * An automatic tape creation policy consists of a list of automatic tape creation rules. This returns the rules
         * that determine when and how to automatically create new tapes.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<AutomaticTapeCreationRule>.Builder}
         * avoiding the need to create one manually via {@link List<AutomaticTapeCreationRule>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AutomaticTapeCreationRule>.Builder#build()} is called
         * immediately and its result is passed to {@link #automaticTapeCreationRules(List<AutomaticTapeCreationRule>)}.
         * 
         * @param automaticTapeCreationRules
         *        a consumer that will call methods on {@link List<AutomaticTapeCreationRule>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #automaticTapeCreationRules(List<AutomaticTapeCreationRule>)
         */
        Builder automaticTapeCreationRules(Consumer<AutomaticTapeCreationRule.Builder>... automaticTapeCreationRules);

        /**
         * Sets the value of the GatewayARN property for this object.
         *
         * @param gatewayARN
         *        The new value for the GatewayARN property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayARN(String gatewayARN);
    }

    static final class BuilderImpl implements Builder {
        private List<AutomaticTapeCreationRule> automaticTapeCreationRules = DefaultSdkAutoConstructList.getInstance();

        private String gatewayARN;

        private BuilderImpl() {
        }

        private BuilderImpl(AutomaticTapeCreationPolicyInfo model) {
            automaticTapeCreationRules(model.automaticTapeCreationRules);
            gatewayARN(model.gatewayARN);
        }

        public final List<AutomaticTapeCreationRule.Builder> getAutomaticTapeCreationRules() {
            List<AutomaticTapeCreationRule.Builder> result = AutomaticTapeCreationRulesCopier
                    .copyToBuilder(this.automaticTapeCreationRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAutomaticTapeCreationRules(
                Collection<AutomaticTapeCreationRule.BuilderImpl> automaticTapeCreationRules) {
            this.automaticTapeCreationRules = AutomaticTapeCreationRulesCopier.copyFromBuilder(automaticTapeCreationRules);
        }

        @Override
        public final Builder automaticTapeCreationRules(Collection<AutomaticTapeCreationRule> automaticTapeCreationRules) {
            this.automaticTapeCreationRules = AutomaticTapeCreationRulesCopier.copy(automaticTapeCreationRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder automaticTapeCreationRules(AutomaticTapeCreationRule... automaticTapeCreationRules) {
            automaticTapeCreationRules(Arrays.asList(automaticTapeCreationRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder automaticTapeCreationRules(Consumer<AutomaticTapeCreationRule.Builder>... automaticTapeCreationRules) {
            automaticTapeCreationRules(Stream.of(automaticTapeCreationRules)
                    .map(c -> AutomaticTapeCreationRule.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getGatewayARN() {
            return gatewayARN;
        }

        public final void setGatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
        }

        @Override
        public final Builder gatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
            return this;
        }

        @Override
        public AutomaticTapeCreationPolicyInfo build() {
            return new AutomaticTapeCreationPolicyInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
