/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A JSON object containing the following fields:
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeCachediScsiVolumesResponse extends StorageGatewayResponse implements
        ToCopyableBuilder<DescribeCachediScsiVolumesResponse.Builder, DescribeCachediScsiVolumesResponse> {
    private static final SdkField<List<CachediSCSIVolume>> CACHEDI_SCSI_VOLUMES_FIELD = SdkField
            .<List<CachediSCSIVolume>> builder(MarshallingType.LIST)
            .memberName("CachediSCSIVolumes")
            .getter(getter(DescribeCachediScsiVolumesResponse::cachediSCSIVolumes))
            .setter(setter(Builder::cachediSCSIVolumes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CachediSCSIVolumes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CachediSCSIVolume> builder(MarshallingType.SDK_POJO)
                                            .constructor(CachediSCSIVolume::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CACHEDI_SCSI_VOLUMES_FIELD));

    private final List<CachediSCSIVolume> cachediSCSIVolumes;

    private DescribeCachediScsiVolumesResponse(BuilderImpl builder) {
        super(builder);
        this.cachediSCSIVolumes = builder.cachediSCSIVolumes;
    }

    /**
     * For responses, this returns true if the service returned a value for the CachediSCSIVolumes property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCachediSCSIVolumes() {
        return cachediSCSIVolumes != null && !(cachediSCSIVolumes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects where each object contains metadata about one cached volume.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCachediSCSIVolumes} method.
     * </p>
     * 
     * @return An array of objects where each object contains metadata about one cached volume.
     */
    public final List<CachediSCSIVolume> cachediSCSIVolumes() {
        return cachediSCSIVolumes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasCachediSCSIVolumes() ? cachediSCSIVolumes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCachediScsiVolumesResponse)) {
            return false;
        }
        DescribeCachediScsiVolumesResponse other = (DescribeCachediScsiVolumesResponse) obj;
        return hasCachediSCSIVolumes() == other.hasCachediSCSIVolumes()
                && Objects.equals(cachediSCSIVolumes(), other.cachediSCSIVolumes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeCachediScsiVolumesResponse")
                .add("CachediSCSIVolumes", hasCachediSCSIVolumes() ? cachediSCSIVolumes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CachediSCSIVolumes":
            return Optional.ofNullable(clazz.cast(cachediSCSIVolumes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeCachediScsiVolumesResponse, T> g) {
        return obj -> g.apply((DescribeCachediScsiVolumesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends StorageGatewayResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeCachediScsiVolumesResponse> {
        /**
         * <p>
         * An array of objects where each object contains metadata about one cached volume.
         * </p>
         * 
         * @param cachediSCSIVolumes
         *        An array of objects where each object contains metadata about one cached volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cachediSCSIVolumes(Collection<CachediSCSIVolume> cachediSCSIVolumes);

        /**
         * <p>
         * An array of objects where each object contains metadata about one cached volume.
         * </p>
         * 
         * @param cachediSCSIVolumes
         *        An array of objects where each object contains metadata about one cached volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cachediSCSIVolumes(CachediSCSIVolume... cachediSCSIVolumes);

        /**
         * <p>
         * An array of objects where each object contains metadata about one cached volume.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<CachediSCSIVolume>.Builder} avoiding
         * the need to create one manually via {@link List<CachediSCSIVolume>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CachediSCSIVolume>.Builder#build()} is called immediately
         * and its result is passed to {@link #cachediSCSIVolumes(List<CachediSCSIVolume>)}.
         * 
         * @param cachediSCSIVolumes
         *        a consumer that will call methods on {@link List<CachediSCSIVolume>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cachediSCSIVolumes(List<CachediSCSIVolume>)
         */
        Builder cachediSCSIVolumes(Consumer<CachediSCSIVolume.Builder>... cachediSCSIVolumes);
    }

    static final class BuilderImpl extends StorageGatewayResponse.BuilderImpl implements Builder {
        private List<CachediSCSIVolume> cachediSCSIVolumes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCachediScsiVolumesResponse model) {
            super(model);
            cachediSCSIVolumes(model.cachediSCSIVolumes);
        }

        public final List<CachediSCSIVolume.Builder> getCachediSCSIVolumes() {
            List<CachediSCSIVolume.Builder> result = CachediSCSIVolumesCopier.copyToBuilder(this.cachediSCSIVolumes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCachediSCSIVolumes(Collection<CachediSCSIVolume.BuilderImpl> cachediSCSIVolumes) {
            this.cachediSCSIVolumes = CachediSCSIVolumesCopier.copyFromBuilder(cachediSCSIVolumes);
        }

        @Override
        public final Builder cachediSCSIVolumes(Collection<CachediSCSIVolume> cachediSCSIVolumes) {
            this.cachediSCSIVolumes = CachediSCSIVolumesCopier.copy(cachediSCSIVolumes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cachediSCSIVolumes(CachediSCSIVolume... cachediSCSIVolumes) {
            cachediSCSIVolumes(Arrays.asList(cachediSCSIVolumes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cachediSCSIVolumes(Consumer<CachediSCSIVolume.Builder>... cachediSCSIVolumes) {
            cachediSCSIVolumes(Stream.of(cachediSCSIVolumes).map(c -> CachediSCSIVolume.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeCachediScsiVolumesResponse build() {
            return new DescribeCachediScsiVolumesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
