/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeFileSystemAssociationsResponse extends StorageGatewayResponse implements
        ToCopyableBuilder<DescribeFileSystemAssociationsResponse.Builder, DescribeFileSystemAssociationsResponse> {
    private static final SdkField<List<FileSystemAssociationInfo>> FILE_SYSTEM_ASSOCIATION_INFO_LIST_FIELD = SdkField
            .<List<FileSystemAssociationInfo>> builder(MarshallingType.LIST)
            .memberName("FileSystemAssociationInfoList")
            .getter(getter(DescribeFileSystemAssociationsResponse::fileSystemAssociationInfoList))
            .setter(setter(Builder::fileSystemAssociationInfoList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileSystemAssociationInfoList")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FileSystemAssociationInfo> builder(MarshallingType.SDK_POJO)
                                            .constructor(FileSystemAssociationInfo::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(FILE_SYSTEM_ASSOCIATION_INFO_LIST_FIELD));

    private final List<FileSystemAssociationInfo> fileSystemAssociationInfoList;

    private DescribeFileSystemAssociationsResponse(BuilderImpl builder) {
        super(builder);
        this.fileSystemAssociationInfoList = builder.fileSystemAssociationInfoList;
    }

    /**
     * For responses, this returns true if the service returned a value for the FileSystemAssociationInfoList property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasFileSystemAssociationInfoList() {
        return fileSystemAssociationInfoList != null && !(fileSystemAssociationInfoList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array containing the <code>FileSystemAssociationInfo</code> data type of each file system association to be
     * described.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFileSystemAssociationInfoList} method.
     * </p>
     * 
     * @return An array containing the <code>FileSystemAssociationInfo</code> data type of each file system association
     *         to be described.
     */
    public final List<FileSystemAssociationInfo> fileSystemAssociationInfoList() {
        return fileSystemAssociationInfoList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasFileSystemAssociationInfoList() ? fileSystemAssociationInfoList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFileSystemAssociationsResponse)) {
            return false;
        }
        DescribeFileSystemAssociationsResponse other = (DescribeFileSystemAssociationsResponse) obj;
        return hasFileSystemAssociationInfoList() == other.hasFileSystemAssociationInfoList()
                && Objects.equals(fileSystemAssociationInfoList(), other.fileSystemAssociationInfoList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("DescribeFileSystemAssociationsResponse")
                .add("FileSystemAssociationInfoList", hasFileSystemAssociationInfoList() ? fileSystemAssociationInfoList() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FileSystemAssociationInfoList":
            return Optional.ofNullable(clazz.cast(fileSystemAssociationInfoList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeFileSystemAssociationsResponse, T> g) {
        return obj -> g.apply((DescribeFileSystemAssociationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends StorageGatewayResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeFileSystemAssociationsResponse> {
        /**
         * <p>
         * An array containing the <code>FileSystemAssociationInfo</code> data type of each file system association to
         * be described.
         * </p>
         * 
         * @param fileSystemAssociationInfoList
         *        An array containing the <code>FileSystemAssociationInfo</code> data type of each file system
         *        association to be described.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileSystemAssociationInfoList(Collection<FileSystemAssociationInfo> fileSystemAssociationInfoList);

        /**
         * <p>
         * An array containing the <code>FileSystemAssociationInfo</code> data type of each file system association to
         * be described.
         * </p>
         * 
         * @param fileSystemAssociationInfoList
         *        An array containing the <code>FileSystemAssociationInfo</code> data type of each file system
         *        association to be described.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileSystemAssociationInfoList(FileSystemAssociationInfo... fileSystemAssociationInfoList);

        /**
         * <p>
         * An array containing the <code>FileSystemAssociationInfo</code> data type of each file system association to
         * be described.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<FileSystemAssociationInfo>.Builder}
         * avoiding the need to create one manually via {@link List<FileSystemAssociationInfo>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<FileSystemAssociationInfo>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #fileSystemAssociationInfoList(List<FileSystemAssociationInfo>)}.
         * 
         * @param fileSystemAssociationInfoList
         *        a consumer that will call methods on {@link List<FileSystemAssociationInfo>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fileSystemAssociationInfoList(List<FileSystemAssociationInfo>)
         */
        Builder fileSystemAssociationInfoList(Consumer<FileSystemAssociationInfo.Builder>... fileSystemAssociationInfoList);
    }

    static final class BuilderImpl extends StorageGatewayResponse.BuilderImpl implements Builder {
        private List<FileSystemAssociationInfo> fileSystemAssociationInfoList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFileSystemAssociationsResponse model) {
            super(model);
            fileSystemAssociationInfoList(model.fileSystemAssociationInfoList);
        }

        public final List<FileSystemAssociationInfo.Builder> getFileSystemAssociationInfoList() {
            List<FileSystemAssociationInfo.Builder> result = FileSystemAssociationInfoListCopier
                    .copyToBuilder(this.fileSystemAssociationInfoList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFileSystemAssociationInfoList(
                Collection<FileSystemAssociationInfo.BuilderImpl> fileSystemAssociationInfoList) {
            this.fileSystemAssociationInfoList = FileSystemAssociationInfoListCopier
                    .copyFromBuilder(fileSystemAssociationInfoList);
        }

        @Override
        public final Builder fileSystemAssociationInfoList(Collection<FileSystemAssociationInfo> fileSystemAssociationInfoList) {
            this.fileSystemAssociationInfoList = FileSystemAssociationInfoListCopier.copy(fileSystemAssociationInfoList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fileSystemAssociationInfoList(FileSystemAssociationInfo... fileSystemAssociationInfoList) {
            fileSystemAssociationInfoList(Arrays.asList(fileSystemAssociationInfoList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fileSystemAssociationInfoList(
                Consumer<FileSystemAssociationInfo.Builder>... fileSystemAssociationInfoList) {
            fileSystemAssociationInfoList(Stream.of(fileSystemAssociationInfoList)
                    .map(c -> FileSystemAssociationInfo.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeFileSystemAssociationsResponse build() {
            return new DescribeFileSystemAssociationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
