/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * DescribeTapesOutput
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeTapesResponse extends StorageGatewayResponse implements
        ToCopyableBuilder<DescribeTapesResponse.Builder, DescribeTapesResponse> {
    private static final SdkField<List<Tape>> TAPES_FIELD = SdkField
            .<List<Tape>> builder(MarshallingType.LIST)
            .memberName("Tapes")
            .getter(getter(DescribeTapesResponse::tapes))
            .setter(setter(Builder::tapes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tapes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tape> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tape::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(DescribeTapesResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TAPES_FIELD, MARKER_FIELD));

    private final List<Tape> tapes;

    private final String marker;

    private DescribeTapesResponse(BuilderImpl builder) {
        super(builder);
        this.tapes = builder.tapes;
        this.marker = builder.marker;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tapes property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTapes() {
        return tapes != null && !(tapes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of virtual tape descriptions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTapes} method.
     * </p>
     * 
     * @return An array of virtual tape descriptions.
     */
    public final List<Tape> tapes() {
        return tapes;
    }

    /**
     * <p>
     * An opaque string that can be used as part of a subsequent <code>DescribeTapes</code> call to retrieve the next
     * page of results.
     * </p>
     * <p>
     * If a response does not contain a marker, then there are no more results to be retrieved.
     * </p>
     * 
     * @return An opaque string that can be used as part of a subsequent <code>DescribeTapes</code> call to retrieve the
     *         next page of results.</p>
     *         <p>
     *         If a response does not contain a marker, then there are no more results to be retrieved.
     */
    public final String marker() {
        return marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasTapes() ? tapes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTapesResponse)) {
            return false;
        }
        DescribeTapesResponse other = (DescribeTapesResponse) obj;
        return hasTapes() == other.hasTapes() && Objects.equals(tapes(), other.tapes())
                && Objects.equals(marker(), other.marker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeTapesResponse").add("Tapes", hasTapes() ? tapes() : null).add("Marker", marker())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Tapes":
            return Optional.ofNullable(clazz.cast(tapes()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeTapesResponse, T> g) {
        return obj -> g.apply((DescribeTapesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends StorageGatewayResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeTapesResponse> {
        /**
         * <p>
         * An array of virtual tape descriptions.
         * </p>
         * 
         * @param tapes
         *        An array of virtual tape descriptions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tapes(Collection<Tape> tapes);

        /**
         * <p>
         * An array of virtual tape descriptions.
         * </p>
         * 
         * @param tapes
         *        An array of virtual tape descriptions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tapes(Tape... tapes);

        /**
         * <p>
         * An array of virtual tape descriptions.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<Tape>.Builder} avoiding the need to
         * create one manually via {@link List<Tape>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tape>.Builder#build()} is called immediately and its result
         * is passed to {@link #tapes(List<Tape>)}.
         * 
         * @param tapes
         *        a consumer that will call methods on {@link List<Tape>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tapes(List<Tape>)
         */
        Builder tapes(Consumer<Tape.Builder>... tapes);

        /**
         * <p>
         * An opaque string that can be used as part of a subsequent <code>DescribeTapes</code> call to retrieve the
         * next page of results.
         * </p>
         * <p>
         * If a response does not contain a marker, then there are no more results to be retrieved.
         * </p>
         * 
         * @param marker
         *        An opaque string that can be used as part of a subsequent <code>DescribeTapes</code> call to retrieve
         *        the next page of results.</p>
         *        <p>
         *        If a response does not contain a marker, then there are no more results to be retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);
    }

    static final class BuilderImpl extends StorageGatewayResponse.BuilderImpl implements Builder {
        private List<Tape> tapes = DefaultSdkAutoConstructList.getInstance();

        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTapesResponse model) {
            super(model);
            tapes(model.tapes);
            marker(model.marker);
        }

        public final List<Tape.Builder> getTapes() {
            List<Tape.Builder> result = TapesCopier.copyToBuilder(this.tapes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTapes(Collection<Tape.BuilderImpl> tapes) {
            this.tapes = TapesCopier.copyFromBuilder(tapes);
        }

        @Override
        public final Builder tapes(Collection<Tape> tapes) {
            this.tapes = TapesCopier.copy(tapes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tapes(Tape... tapes) {
            tapes(Arrays.asList(tapes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tapes(Consumer<Tape.Builder>... tapes) {
            tapes(Stream.of(tapes).map(c -> Tape.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        @Override
        public DescribeTapesResponse build() {
            return new DescribeTapesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
