/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the object returned by <code>DescribeFileSystemAssociations</code> that describes a created file system
 * association.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FileSystemAssociationInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<FileSystemAssociationInfo.Builder, FileSystemAssociationInfo> {
    private static final SdkField<String> FILE_SYSTEM_ASSOCIATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FileSystemAssociationARN").getter(getter(FileSystemAssociationInfo::fileSystemAssociationARN))
            .setter(setter(Builder::fileSystemAssociationARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileSystemAssociationARN").build())
            .build();

    private static final SdkField<String> LOCATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LocationARN").getter(getter(FileSystemAssociationInfo::locationARN))
            .setter(setter(Builder::locationARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocationARN").build()).build();

    private static final SdkField<String> FILE_SYSTEM_ASSOCIATION_STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("FileSystemAssociationStatus")
            .getter(getter(FileSystemAssociationInfo::fileSystemAssociationStatus))
            .setter(setter(Builder::fileSystemAssociationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileSystemAssociationStatus")
                    .build()).build();

    private static final SdkField<String> AUDIT_DESTINATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuditDestinationARN").getter(getter(FileSystemAssociationInfo::auditDestinationARN))
            .setter(setter(Builder::auditDestinationARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuditDestinationARN").build())
            .build();

    private static final SdkField<String> GATEWAY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GatewayARN").getter(getter(FileSystemAssociationInfo::gatewayARN)).setter(setter(Builder::gatewayARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayARN").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(FileSystemAssociationInfo::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<CacheAttributes> CACHE_ATTRIBUTES_FIELD = SdkField
            .<CacheAttributes> builder(MarshallingType.SDK_POJO).memberName("CacheAttributes")
            .getter(getter(FileSystemAssociationInfo::cacheAttributes)).setter(setter(Builder::cacheAttributes))
            .constructor(CacheAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheAttributes").build()).build();

    private static final SdkField<EndpointNetworkConfiguration> ENDPOINT_NETWORK_CONFIGURATION_FIELD = SdkField
            .<EndpointNetworkConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("EndpointNetworkConfiguration")
            .getter(getter(FileSystemAssociationInfo::endpointNetworkConfiguration))
            .setter(setter(Builder::endpointNetworkConfiguration))
            .constructor(EndpointNetworkConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointNetworkConfiguration")
                    .build()).build();

    private static final SdkField<List<FileSystemAssociationStatusDetail>> FILE_SYSTEM_ASSOCIATION_STATUS_DETAILS_FIELD = SdkField
            .<List<FileSystemAssociationStatusDetail>> builder(MarshallingType.LIST)
            .memberName("FileSystemAssociationStatusDetails")
            .getter(getter(FileSystemAssociationInfo::fileSystemAssociationStatusDetails))
            .setter(setter(Builder::fileSystemAssociationStatusDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileSystemAssociationStatusDetails")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FileSystemAssociationStatusDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(FileSystemAssociationStatusDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            FILE_SYSTEM_ASSOCIATION_ARN_FIELD, LOCATION_ARN_FIELD, FILE_SYSTEM_ASSOCIATION_STATUS_FIELD,
            AUDIT_DESTINATION_ARN_FIELD, GATEWAY_ARN_FIELD, TAGS_FIELD, CACHE_ATTRIBUTES_FIELD,
            ENDPOINT_NETWORK_CONFIGURATION_FIELD, FILE_SYSTEM_ASSOCIATION_STATUS_DETAILS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String fileSystemAssociationARN;

    private final String locationARN;

    private final String fileSystemAssociationStatus;

    private final String auditDestinationARN;

    private final String gatewayARN;

    private final List<Tag> tags;

    private final CacheAttributes cacheAttributes;

    private final EndpointNetworkConfiguration endpointNetworkConfiguration;

    private final List<FileSystemAssociationStatusDetail> fileSystemAssociationStatusDetails;

    private FileSystemAssociationInfo(BuilderImpl builder) {
        this.fileSystemAssociationARN = builder.fileSystemAssociationARN;
        this.locationARN = builder.locationARN;
        this.fileSystemAssociationStatus = builder.fileSystemAssociationStatus;
        this.auditDestinationARN = builder.auditDestinationARN;
        this.gatewayARN = builder.gatewayARN;
        this.tags = builder.tags;
        this.cacheAttributes = builder.cacheAttributes;
        this.endpointNetworkConfiguration = builder.endpointNetworkConfiguration;
        this.fileSystemAssociationStatusDetails = builder.fileSystemAssociationStatusDetails;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the file system association.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the file system association.
     */
    public final String fileSystemAssociationARN() {
        return fileSystemAssociationARN;
    }

    /**
     * <p>
     * The ARN of the backend Amazon FSx file system used for storing file data. For information, see <a
     * href="https://docs.aws.amazon.com/fsx/latest/APIReference/API_FileSystem.html">FileSystem</a> in the <i>Amazon
     * FSx API Reference</i>.
     * </p>
     * 
     * @return The ARN of the backend Amazon FSx file system used for storing file data. For information, see <a
     *         href="https://docs.aws.amazon.com/fsx/latest/APIReference/API_FileSystem.html">FileSystem</a> in the
     *         <i>Amazon FSx API Reference</i>.
     */
    public final String locationARN() {
        return locationARN;
    }

    /**
     * <p>
     * The status of the file system association. Valid Values: <code>AVAILABLE</code> | <code>CREATING</code> |
     * <code>DELETING</code> | <code>FORCE_DELETING</code> | <code>UPDATING</code> | <code>ERROR</code>
     * </p>
     * 
     * @return The status of the file system association. Valid Values: <code>AVAILABLE</code> | <code>CREATING</code> |
     *         <code>DELETING</code> | <code>FORCE_DELETING</code> | <code>UPDATING</code> | <code>ERROR</code>
     */
    public final String fileSystemAssociationStatus() {
        return fileSystemAssociationStatus;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the storage used for the audit logs.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the storage used for the audit logs.
     */
    public final String auditDestinationARN() {
        return auditDestinationARN;
    }

    /**
     * Returns the value of the GatewayARN property for this object.
     * 
     * @return The value of the GatewayARN property for this object.
     */
    public final String gatewayARN() {
        return gatewayARN;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of up to 50 tags assigned to the SMB file share, sorted alphabetically by key name. Each tag is a
     * key-value pair.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of up to 50 tags assigned to the SMB file share, sorted alphabetically by key name. Each tag is a
     *         key-value pair.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * Returns the value of the CacheAttributes property for this object.
     * 
     * @return The value of the CacheAttributes property for this object.
     */
    public final CacheAttributes cacheAttributes() {
        return cacheAttributes;
    }

    /**
     * <p>
     * Specifies network configuration information for the gateway associated with the Amazon FSx file system.
     * </p>
     * <note>
     * <p>
     * If multiple file systems are associated with this gateway, this parameter's <code>IpAddresses</code> field is
     * required.
     * </p>
     * </note>
     * 
     * @return Specifies network configuration information for the gateway associated with the Amazon FSx file
     *         system.</p> <note>
     *         <p>
     *         If multiple file systems are associated with this gateway, this parameter's <code>IpAddresses</code>
     *         field is required.
     *         </p>
     */
    public final EndpointNetworkConfiguration endpointNetworkConfiguration() {
        return endpointNetworkConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the FileSystemAssociationStatusDetails
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasFileSystemAssociationStatusDetails() {
        return fileSystemAssociationStatusDetails != null
                && !(fileSystemAssociationStatusDetails instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array containing the FileSystemAssociationStatusDetail data type, which provides detailed information on file
     * system association status.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFileSystemAssociationStatusDetails}
     * method.
     * </p>
     * 
     * @return An array containing the FileSystemAssociationStatusDetail data type, which provides detailed information
     *         on file system association status.
     */
    public final List<FileSystemAssociationStatusDetail> fileSystemAssociationStatusDetails() {
        return fileSystemAssociationStatusDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fileSystemAssociationARN());
        hashCode = 31 * hashCode + Objects.hashCode(locationARN());
        hashCode = 31 * hashCode + Objects.hashCode(fileSystemAssociationStatus());
        hashCode = 31 * hashCode + Objects.hashCode(auditDestinationARN());
        hashCode = 31 * hashCode + Objects.hashCode(gatewayARN());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(cacheAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(endpointNetworkConfiguration());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasFileSystemAssociationStatusDetails() ? fileSystemAssociationStatusDetails() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FileSystemAssociationInfo)) {
            return false;
        }
        FileSystemAssociationInfo other = (FileSystemAssociationInfo) obj;
        return Objects.equals(fileSystemAssociationARN(), other.fileSystemAssociationARN())
                && Objects.equals(locationARN(), other.locationARN())
                && Objects.equals(fileSystemAssociationStatus(), other.fileSystemAssociationStatus())
                && Objects.equals(auditDestinationARN(), other.auditDestinationARN())
                && Objects.equals(gatewayARN(), other.gatewayARN()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(cacheAttributes(), other.cacheAttributes())
                && Objects.equals(endpointNetworkConfiguration(), other.endpointNetworkConfiguration())
                && hasFileSystemAssociationStatusDetails() == other.hasFileSystemAssociationStatusDetails()
                && Objects.equals(fileSystemAssociationStatusDetails(), other.fileSystemAssociationStatusDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("FileSystemAssociationInfo")
                .add("FileSystemAssociationARN", fileSystemAssociationARN())
                .add("LocationARN", locationARN())
                .add("FileSystemAssociationStatus", fileSystemAssociationStatus())
                .add("AuditDestinationARN", auditDestinationARN())
                .add("GatewayARN", gatewayARN())
                .add("Tags", hasTags() ? tags() : null)
                .add("CacheAttributes", cacheAttributes())
                .add("EndpointNetworkConfiguration", endpointNetworkConfiguration())
                .add("FileSystemAssociationStatusDetails",
                        hasFileSystemAssociationStatusDetails() ? fileSystemAssociationStatusDetails() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FileSystemAssociationARN":
            return Optional.ofNullable(clazz.cast(fileSystemAssociationARN()));
        case "LocationARN":
            return Optional.ofNullable(clazz.cast(locationARN()));
        case "FileSystemAssociationStatus":
            return Optional.ofNullable(clazz.cast(fileSystemAssociationStatus()));
        case "AuditDestinationARN":
            return Optional.ofNullable(clazz.cast(auditDestinationARN()));
        case "GatewayARN":
            return Optional.ofNullable(clazz.cast(gatewayARN()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "CacheAttributes":
            return Optional.ofNullable(clazz.cast(cacheAttributes()));
        case "EndpointNetworkConfiguration":
            return Optional.ofNullable(clazz.cast(endpointNetworkConfiguration()));
        case "FileSystemAssociationStatusDetails":
            return Optional.ofNullable(clazz.cast(fileSystemAssociationStatusDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FileSystemAssociationInfo, T> g) {
        return obj -> g.apply((FileSystemAssociationInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FileSystemAssociationInfo> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the file system association.
         * </p>
         * 
         * @param fileSystemAssociationARN
         *        The Amazon Resource Name (ARN) of the file system association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileSystemAssociationARN(String fileSystemAssociationARN);

        /**
         * <p>
         * The ARN of the backend Amazon FSx file system used for storing file data. For information, see <a
         * href="https://docs.aws.amazon.com/fsx/latest/APIReference/API_FileSystem.html">FileSystem</a> in the
         * <i>Amazon FSx API Reference</i>.
         * </p>
         * 
         * @param locationARN
         *        The ARN of the backend Amazon FSx file system used for storing file data. For information, see <a
         *        href="https://docs.aws.amazon.com/fsx/latest/APIReference/API_FileSystem.html">FileSystem</a> in the
         *        <i>Amazon FSx API Reference</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder locationARN(String locationARN);

        /**
         * <p>
         * The status of the file system association. Valid Values: <code>AVAILABLE</code> | <code>CREATING</code> |
         * <code>DELETING</code> | <code>FORCE_DELETING</code> | <code>UPDATING</code> | <code>ERROR</code>
         * </p>
         * 
         * @param fileSystemAssociationStatus
         *        The status of the file system association. Valid Values: <code>AVAILABLE</code> |
         *        <code>CREATING</code> | <code>DELETING</code> | <code>FORCE_DELETING</code> | <code>UPDATING</code> |
         *        <code>ERROR</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileSystemAssociationStatus(String fileSystemAssociationStatus);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the storage used for the audit logs.
         * </p>
         * 
         * @param auditDestinationARN
         *        The Amazon Resource Name (ARN) of the storage used for the audit logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder auditDestinationARN(String auditDestinationARN);

        /**
         * Sets the value of the GatewayARN property for this object.
         *
         * @param gatewayARN
         *        The new value for the GatewayARN property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayARN(String gatewayARN);

        /**
         * <p>
         * A list of up to 50 tags assigned to the SMB file share, sorted alphabetically by key name. Each tag is a
         * key-value pair.
         * </p>
         * 
         * @param tags
         *        A list of up to 50 tags assigned to the SMB file share, sorted alphabetically by key name. Each tag is
         *        a key-value pair.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of up to 50 tags assigned to the SMB file share, sorted alphabetically by key name. Each tag is a
         * key-value pair.
         * </p>
         * 
         * @param tags
         *        A list of up to 50 tags assigned to the SMB file share, sorted alphabetically by key name. Each tag is
         *        a key-value pair.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of up to 50 tags assigned to the SMB file share, sorted alphabetically by key name. Each tag is a
         * key-value pair.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<Tag>.Builder} avoiding the need to
         * create one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * Sets the value of the CacheAttributes property for this object.
         *
         * @param cacheAttributes
         *        The new value for the CacheAttributes property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheAttributes(CacheAttributes cacheAttributes);

        /**
         * Sets the value of the CacheAttributes property for this object.
         *
         * This is a convenience method that creates an instance of the {@link CacheAttributes.Builder} avoiding the
         * need to create one manually via {@link CacheAttributes#builder()}.
         *
         * When the {@link Consumer} completes, {@link CacheAttributes.Builder#build()} is called immediately and its
         * result is passed to {@link #cacheAttributes(CacheAttributes)}.
         * 
         * @param cacheAttributes
         *        a consumer that will call methods on {@link CacheAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cacheAttributes(CacheAttributes)
         */
        default Builder cacheAttributes(Consumer<CacheAttributes.Builder> cacheAttributes) {
            return cacheAttributes(CacheAttributes.builder().applyMutation(cacheAttributes).build());
        }

        /**
         * <p>
         * Specifies network configuration information for the gateway associated with the Amazon FSx file system.
         * </p>
         * <note>
         * <p>
         * If multiple file systems are associated with this gateway, this parameter's <code>IpAddresses</code> field is
         * required.
         * </p>
         * </note>
         * 
         * @param endpointNetworkConfiguration
         *        Specifies network configuration information for the gateway associated with the Amazon FSx file
         *        system.</p> <note>
         *        <p>
         *        If multiple file systems are associated with this gateway, this parameter's <code>IpAddresses</code>
         *        field is required.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointNetworkConfiguration(EndpointNetworkConfiguration endpointNetworkConfiguration);

        /**
         * <p>
         * Specifies network configuration information for the gateway associated with the Amazon FSx file system.
         * </p>
         * <note>
         * <p>
         * If multiple file systems are associated with this gateway, this parameter's <code>IpAddresses</code> field is
         * required.
         * </p>
         * </note> This is a convenience method that creates an instance of the
         * {@link EndpointNetworkConfiguration.Builder} avoiding the need to create one manually via
         * {@link EndpointNetworkConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link EndpointNetworkConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #endpointNetworkConfiguration(EndpointNetworkConfiguration)}.
         * 
         * @param endpointNetworkConfiguration
         *        a consumer that will call methods on {@link EndpointNetworkConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #endpointNetworkConfiguration(EndpointNetworkConfiguration)
         */
        default Builder endpointNetworkConfiguration(Consumer<EndpointNetworkConfiguration.Builder> endpointNetworkConfiguration) {
            return endpointNetworkConfiguration(EndpointNetworkConfiguration.builder()
                    .applyMutation(endpointNetworkConfiguration).build());
        }

        /**
         * <p>
         * An array containing the FileSystemAssociationStatusDetail data type, which provides detailed information on
         * file system association status.
         * </p>
         * 
         * @param fileSystemAssociationStatusDetails
         *        An array containing the FileSystemAssociationStatusDetail data type, which provides detailed
         *        information on file system association status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileSystemAssociationStatusDetails(
                Collection<FileSystemAssociationStatusDetail> fileSystemAssociationStatusDetails);

        /**
         * <p>
         * An array containing the FileSystemAssociationStatusDetail data type, which provides detailed information on
         * file system association status.
         * </p>
         * 
         * @param fileSystemAssociationStatusDetails
         *        An array containing the FileSystemAssociationStatusDetail data type, which provides detailed
         *        information on file system association status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileSystemAssociationStatusDetails(FileSystemAssociationStatusDetail... fileSystemAssociationStatusDetails);

        /**
         * <p>
         * An array containing the FileSystemAssociationStatusDetail data type, which provides detailed information on
         * file system association status.
         * </p>
         * This is a convenience method that creates an instance of the {@link List
         * <FileSystemAssociationStatusDetail>.Builder} avoiding the need to create one manually via {@link List
         * <FileSystemAssociationStatusDetail>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<FileSystemAssociationStatusDetail>.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #fileSystemAssociationStatusDetails(List<FileSystemAssociationStatusDetail>)}.
         * 
         * @param fileSystemAssociationStatusDetails
         *        a consumer that will call methods on {@link List<FileSystemAssociationStatusDetail>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fileSystemAssociationStatusDetails(List<FileSystemAssociationStatusDetail>)
         */
        Builder fileSystemAssociationStatusDetails(
                Consumer<FileSystemAssociationStatusDetail.Builder>... fileSystemAssociationStatusDetails);
    }

    static final class BuilderImpl implements Builder {
        private String fileSystemAssociationARN;

        private String locationARN;

        private String fileSystemAssociationStatus;

        private String auditDestinationARN;

        private String gatewayARN;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private CacheAttributes cacheAttributes;

        private EndpointNetworkConfiguration endpointNetworkConfiguration;

        private List<FileSystemAssociationStatusDetail> fileSystemAssociationStatusDetails = DefaultSdkAutoConstructList
                .getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FileSystemAssociationInfo model) {
            fileSystemAssociationARN(model.fileSystemAssociationARN);
            locationARN(model.locationARN);
            fileSystemAssociationStatus(model.fileSystemAssociationStatus);
            auditDestinationARN(model.auditDestinationARN);
            gatewayARN(model.gatewayARN);
            tags(model.tags);
            cacheAttributes(model.cacheAttributes);
            endpointNetworkConfiguration(model.endpointNetworkConfiguration);
            fileSystemAssociationStatusDetails(model.fileSystemAssociationStatusDetails);
        }

        public final String getFileSystemAssociationARN() {
            return fileSystemAssociationARN;
        }

        public final void setFileSystemAssociationARN(String fileSystemAssociationARN) {
            this.fileSystemAssociationARN = fileSystemAssociationARN;
        }

        @Override
        public final Builder fileSystemAssociationARN(String fileSystemAssociationARN) {
            this.fileSystemAssociationARN = fileSystemAssociationARN;
            return this;
        }

        public final String getLocationARN() {
            return locationARN;
        }

        public final void setLocationARN(String locationARN) {
            this.locationARN = locationARN;
        }

        @Override
        public final Builder locationARN(String locationARN) {
            this.locationARN = locationARN;
            return this;
        }

        public final String getFileSystemAssociationStatus() {
            return fileSystemAssociationStatus;
        }

        public final void setFileSystemAssociationStatus(String fileSystemAssociationStatus) {
            this.fileSystemAssociationStatus = fileSystemAssociationStatus;
        }

        @Override
        public final Builder fileSystemAssociationStatus(String fileSystemAssociationStatus) {
            this.fileSystemAssociationStatus = fileSystemAssociationStatus;
            return this;
        }

        public final String getAuditDestinationARN() {
            return auditDestinationARN;
        }

        public final void setAuditDestinationARN(String auditDestinationARN) {
            this.auditDestinationARN = auditDestinationARN;
        }

        @Override
        public final Builder auditDestinationARN(String auditDestinationARN) {
            this.auditDestinationARN = auditDestinationARN;
            return this;
        }

        public final String getGatewayARN() {
            return gatewayARN;
        }

        public final void setGatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
        }

        @Override
        public final Builder gatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final CacheAttributes.Builder getCacheAttributes() {
            return cacheAttributes != null ? cacheAttributes.toBuilder() : null;
        }

        public final void setCacheAttributes(CacheAttributes.BuilderImpl cacheAttributes) {
            this.cacheAttributes = cacheAttributes != null ? cacheAttributes.build() : null;
        }

        @Override
        public final Builder cacheAttributes(CacheAttributes cacheAttributes) {
            this.cacheAttributes = cacheAttributes;
            return this;
        }

        public final EndpointNetworkConfiguration.Builder getEndpointNetworkConfiguration() {
            return endpointNetworkConfiguration != null ? endpointNetworkConfiguration.toBuilder() : null;
        }

        public final void setEndpointNetworkConfiguration(EndpointNetworkConfiguration.BuilderImpl endpointNetworkConfiguration) {
            this.endpointNetworkConfiguration = endpointNetworkConfiguration != null ? endpointNetworkConfiguration.build()
                    : null;
        }

        @Override
        public final Builder endpointNetworkConfiguration(EndpointNetworkConfiguration endpointNetworkConfiguration) {
            this.endpointNetworkConfiguration = endpointNetworkConfiguration;
            return this;
        }

        public final List<FileSystemAssociationStatusDetail.Builder> getFileSystemAssociationStatusDetails() {
            List<FileSystemAssociationStatusDetail.Builder> result = FileSystemAssociationStatusDetailsCopier
                    .copyToBuilder(this.fileSystemAssociationStatusDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFileSystemAssociationStatusDetails(
                Collection<FileSystemAssociationStatusDetail.BuilderImpl> fileSystemAssociationStatusDetails) {
            this.fileSystemAssociationStatusDetails = FileSystemAssociationStatusDetailsCopier
                    .copyFromBuilder(fileSystemAssociationStatusDetails);
        }

        @Override
        public final Builder fileSystemAssociationStatusDetails(
                Collection<FileSystemAssociationStatusDetail> fileSystemAssociationStatusDetails) {
            this.fileSystemAssociationStatusDetails = FileSystemAssociationStatusDetailsCopier
                    .copy(fileSystemAssociationStatusDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fileSystemAssociationStatusDetails(
                FileSystemAssociationStatusDetail... fileSystemAssociationStatusDetails) {
            fileSystemAssociationStatusDetails(Arrays.asList(fileSystemAssociationStatusDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fileSystemAssociationStatusDetails(
                Consumer<FileSystemAssociationStatusDetail.Builder>... fileSystemAssociationStatusDetails) {
            fileSystemAssociationStatusDetails(Stream.of(fileSystemAssociationStatusDetails)
                    .map(c -> FileSystemAssociationStatusDetail.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public FileSystemAssociationInfo build() {
            return new FileSystemAssociationInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
