/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an iSCSI stored volume.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StorediSCSIVolume implements SdkPojo, Serializable,
        ToCopyableBuilder<StorediSCSIVolume.Builder, StorediSCSIVolume> {
    private static final SdkField<String> VOLUME_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VolumeARN").getter(getter(StorediSCSIVolume::volumeARN)).setter(setter(Builder::volumeARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeARN").build()).build();

    private static final SdkField<String> VOLUME_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VolumeId").getter(getter(StorediSCSIVolume::volumeId)).setter(setter(Builder::volumeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeId").build()).build();

    private static final SdkField<String> VOLUME_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VolumeType").getter(getter(StorediSCSIVolume::volumeType)).setter(setter(Builder::volumeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeType").build()).build();

    private static final SdkField<String> VOLUME_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VolumeStatus").getter(getter(StorediSCSIVolume::volumeStatus)).setter(setter(Builder::volumeStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeStatus").build()).build();

    private static final SdkField<String> VOLUME_ATTACHMENT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VolumeAttachmentStatus").getter(getter(StorediSCSIVolume::volumeAttachmentStatus))
            .setter(setter(Builder::volumeAttachmentStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeAttachmentStatus").build())
            .build();

    private static final SdkField<Long> VOLUME_SIZE_IN_BYTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("VolumeSizeInBytes").getter(getter(StorediSCSIVolume::volumeSizeInBytes))
            .setter(setter(Builder::volumeSizeInBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeSizeInBytes").build()).build();

    private static final SdkField<Double> VOLUME_PROGRESS_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("VolumeProgress").getter(getter(StorediSCSIVolume::volumeProgress))
            .setter(setter(Builder::volumeProgress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeProgress").build()).build();

    private static final SdkField<String> VOLUME_DISK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VolumeDiskId").getter(getter(StorediSCSIVolume::volumeDiskId)).setter(setter(Builder::volumeDiskId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeDiskId").build()).build();

    private static final SdkField<String> SOURCE_SNAPSHOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceSnapshotId").getter(getter(StorediSCSIVolume::sourceSnapshotId))
            .setter(setter(Builder::sourceSnapshotId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceSnapshotId").build()).build();

    private static final SdkField<Boolean> PRESERVED_EXISTING_DATA_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("PreservedExistingData").getter(getter(StorediSCSIVolume::preservedExistingData))
            .setter(setter(Builder::preservedExistingData))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreservedExistingData").build())
            .build();

    private static final SdkField<VolumeiSCSIAttributes> VOLUMEI_SCSI_ATTRIBUTES_FIELD = SdkField
            .<VolumeiSCSIAttributes> builder(MarshallingType.SDK_POJO).memberName("VolumeiSCSIAttributes")
            .getter(getter(StorediSCSIVolume::volumeiSCSIAttributes)).setter(setter(Builder::volumeiSCSIAttributes))
            .constructor(VolumeiSCSIAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeiSCSIAttributes").build())
            .build();

    private static final SdkField<Instant> CREATED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedDate").getter(getter(StorediSCSIVolume::createdDate)).setter(setter(Builder::createdDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedDate").build()).build();

    private static final SdkField<Long> VOLUME_USED_IN_BYTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("VolumeUsedInBytes").getter(getter(StorediSCSIVolume::volumeUsedInBytes))
            .setter(setter(Builder::volumeUsedInBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeUsedInBytes").build()).build();

    private static final SdkField<String> KMS_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("KMSKey")
            .getter(getter(StorediSCSIVolume::kmsKey)).setter(setter(Builder::kmsKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KMSKey").build()).build();

    private static final SdkField<String> TARGET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetName").getter(getter(StorediSCSIVolume::targetName)).setter(setter(Builder::targetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOLUME_ARN_FIELD,
            VOLUME_ID_FIELD, VOLUME_TYPE_FIELD, VOLUME_STATUS_FIELD, VOLUME_ATTACHMENT_STATUS_FIELD, VOLUME_SIZE_IN_BYTES_FIELD,
            VOLUME_PROGRESS_FIELD, VOLUME_DISK_ID_FIELD, SOURCE_SNAPSHOT_ID_FIELD, PRESERVED_EXISTING_DATA_FIELD,
            VOLUMEI_SCSI_ATTRIBUTES_FIELD, CREATED_DATE_FIELD, VOLUME_USED_IN_BYTES_FIELD, KMS_KEY_FIELD, TARGET_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String volumeARN;

    private final String volumeId;

    private final String volumeType;

    private final String volumeStatus;

    private final String volumeAttachmentStatus;

    private final Long volumeSizeInBytes;

    private final Double volumeProgress;

    private final String volumeDiskId;

    private final String sourceSnapshotId;

    private final Boolean preservedExistingData;

    private final VolumeiSCSIAttributes volumeiSCSIAttributes;

    private final Instant createdDate;

    private final Long volumeUsedInBytes;

    private final String kmsKey;

    private final String targetName;

    private StorediSCSIVolume(BuilderImpl builder) {
        this.volumeARN = builder.volumeARN;
        this.volumeId = builder.volumeId;
        this.volumeType = builder.volumeType;
        this.volumeStatus = builder.volumeStatus;
        this.volumeAttachmentStatus = builder.volumeAttachmentStatus;
        this.volumeSizeInBytes = builder.volumeSizeInBytes;
        this.volumeProgress = builder.volumeProgress;
        this.volumeDiskId = builder.volumeDiskId;
        this.sourceSnapshotId = builder.sourceSnapshotId;
        this.preservedExistingData = builder.preservedExistingData;
        this.volumeiSCSIAttributes = builder.volumeiSCSIAttributes;
        this.createdDate = builder.createdDate;
        this.volumeUsedInBytes = builder.volumeUsedInBytes;
        this.kmsKey = builder.kmsKey;
        this.targetName = builder.targetName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the storage volume.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the storage volume.
     */
    public final String volumeARN() {
        return volumeARN;
    }

    /**
     * <p>
     * The unique identifier of the volume, e.g., vol-AE4B946D.
     * </p>
     * 
     * @return The unique identifier of the volume, e.g., vol-AE4B946D.
     */
    public final String volumeId() {
        return volumeId;
    }

    /**
     * <p>
     * One of the VolumeType enumeration values describing the type of the volume.
     * </p>
     * 
     * @return One of the VolumeType enumeration values describing the type of the volume.
     */
    public final String volumeType() {
        return volumeType;
    }

    /**
     * <p>
     * One of the VolumeStatus values that indicates the state of the storage volume.
     * </p>
     * 
     * @return One of the VolumeStatus values that indicates the state of the storage volume.
     */
    public final String volumeStatus() {
        return volumeStatus;
    }

    /**
     * <p>
     * A value that indicates whether a storage volume is attached to, detached from, or is in the process of detaching
     * from a gateway. For more information, see <a
     * href="https://docs.aws.amazon.com/storagegateway/latest/userguide/managing-volumes.html#attach-detach-volume"
     * >Moving your volumes to a different gateway</a>.
     * </p>
     * 
     * @return A value that indicates whether a storage volume is attached to, detached from, or is in the process of
     *         detaching from a gateway. For more information, see <a href=
     *         "https://docs.aws.amazon.com/storagegateway/latest/userguide/managing-volumes.html#attach-detach-volume"
     *         >Moving your volumes to a different gateway</a>.
     */
    public final String volumeAttachmentStatus() {
        return volumeAttachmentStatus;
    }

    /**
     * <p>
     * The size of the volume in bytes.
     * </p>
     * 
     * @return The size of the volume in bytes.
     */
    public final Long volumeSizeInBytes() {
        return volumeSizeInBytes;
    }

    /**
     * <p>
     * Represents the percentage complete if the volume is restoring or bootstrapping that represents the percent of
     * data transferred. This field does not appear in the response if the stored volume is not restoring or
     * bootstrapping.
     * </p>
     * 
     * @return Represents the percentage complete if the volume is restoring or bootstrapping that represents the
     *         percent of data transferred. This field does not appear in the response if the stored volume is not
     *         restoring or bootstrapping.
     */
    public final Double volumeProgress() {
        return volumeProgress;
    }

    /**
     * <p>
     * The ID of the local disk that was specified in the <a>CreateStorediSCSIVolume</a> operation.
     * </p>
     * 
     * @return The ID of the local disk that was specified in the <a>CreateStorediSCSIVolume</a> operation.
     */
    public final String volumeDiskId() {
        return volumeDiskId;
    }

    /**
     * <p>
     * If the stored volume was created from a snapshot, this field contains the snapshot ID used, e.g. snap-78e22663.
     * Otherwise, this field is not included.
     * </p>
     * 
     * @return If the stored volume was created from a snapshot, this field contains the snapshot ID used, e.g.
     *         snap-78e22663. Otherwise, this field is not included.
     */
    public final String sourceSnapshotId() {
        return sourceSnapshotId;
    }

    /**
     * <p>
     * Indicates if when the stored volume was created, existing data on the underlying local disk was preserved.
     * </p>
     * <p>
     * Valid Values: <code>true</code> | <code>false</code>
     * </p>
     * 
     * @return Indicates if when the stored volume was created, existing data on the underlying local disk was
     *         preserved.</p>
     *         <p>
     *         Valid Values: <code>true</code> | <code>false</code>
     */
    public final Boolean preservedExistingData() {
        return preservedExistingData;
    }

    /**
     * <p>
     * An <a>VolumeiSCSIAttributes</a> object that represents a collection of iSCSI attributes for one stored volume.
     * </p>
     * 
     * @return An <a>VolumeiSCSIAttributes</a> object that represents a collection of iSCSI attributes for one stored
     *         volume.
     */
    public final VolumeiSCSIAttributes volumeiSCSIAttributes() {
        return volumeiSCSIAttributes;
    }

    /**
     * <p>
     * The date the volume was created. Volumes created prior to March 28, 2017 don’t have this timestamp.
     * </p>
     * 
     * @return The date the volume was created. Volumes created prior to March 28, 2017 don’t have this timestamp.
     */
    public final Instant createdDate() {
        return createdDate;
    }

    /**
     * <p>
     * The size of the data stored on the volume in bytes. This value is calculated based on the number of blocks that
     * are touched, instead of the actual amount of data written. This value can be useful for sequential write patterns
     * but less accurate for random write patterns. <code>VolumeUsedInBytes</code> is different from the compressed size
     * of the volume, which is the value that is used to calculate your bill.
     * </p>
     * <note>
     * <p>
     * This value is not available for volumes created prior to May 13, 2015, until you store data on the volume.
     * </p>
     * </note>
     * 
     * @return The size of the data stored on the volume in bytes. This value is calculated based on the number of
     *         blocks that are touched, instead of the actual amount of data written. This value can be useful for
     *         sequential write patterns but less accurate for random write patterns. <code>VolumeUsedInBytes</code> is
     *         different from the compressed size of the volume, which is the value that is used to calculate your
     *         bill.</p> <note>
     *         <p>
     *         This value is not available for volumes created prior to May 13, 2015, until you store data on the
     *         volume.
     *         </p>
     */
    public final Long volumeUsedInBytes() {
        return volumeUsedInBytes;
    }

    /**
     * Returns the value of the KMSKey property for this object.
     * 
     * @return The value of the KMSKey property for this object.
     */
    public final String kmsKey() {
        return kmsKey;
    }

    /**
     * <p>
     * The name of the iSCSI target used by an initiator to connect to a volume and used as a suffix for the target ARN.
     * For example, specifying <code>TargetName</code> as <i>myvolume</i> results in the target ARN of
     * <code>arn:aws:storagegateway:us-east-2:111122223333:gateway/sgw-12A3456B/target/iqn.1997-05.com.amazon:myvolume</code>
     * . The target name must be unique across all volumes on a gateway.
     * </p>
     * <p>
     * If you don't specify a value, Storage Gateway uses the value that was previously used for this volume as the new
     * target name.
     * </p>
     * 
     * @return The name of the iSCSI target used by an initiator to connect to a volume and used as a suffix for the
     *         target ARN. For example, specifying <code>TargetName</code> as <i>myvolume</i> results in the target ARN
     *         of
     *         <code>arn:aws:storagegateway:us-east-2:111122223333:gateway/sgw-12A3456B/target/iqn.1997-05.com.amazon:myvolume</code>
     *         . The target name must be unique across all volumes on a gateway.</p>
     *         <p>
     *         If you don't specify a value, Storage Gateway uses the value that was previously used for this volume as
     *         the new target name.
     */
    public final String targetName() {
        return targetName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(volumeARN());
        hashCode = 31 * hashCode + Objects.hashCode(volumeId());
        hashCode = 31 * hashCode + Objects.hashCode(volumeType());
        hashCode = 31 * hashCode + Objects.hashCode(volumeStatus());
        hashCode = 31 * hashCode + Objects.hashCode(volumeAttachmentStatus());
        hashCode = 31 * hashCode + Objects.hashCode(volumeSizeInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(volumeProgress());
        hashCode = 31 * hashCode + Objects.hashCode(volumeDiskId());
        hashCode = 31 * hashCode + Objects.hashCode(sourceSnapshotId());
        hashCode = 31 * hashCode + Objects.hashCode(preservedExistingData());
        hashCode = 31 * hashCode + Objects.hashCode(volumeiSCSIAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(volumeUsedInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKey());
        hashCode = 31 * hashCode + Objects.hashCode(targetName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StorediSCSIVolume)) {
            return false;
        }
        StorediSCSIVolume other = (StorediSCSIVolume) obj;
        return Objects.equals(volumeARN(), other.volumeARN()) && Objects.equals(volumeId(), other.volumeId())
                && Objects.equals(volumeType(), other.volumeType()) && Objects.equals(volumeStatus(), other.volumeStatus())
                && Objects.equals(volumeAttachmentStatus(), other.volumeAttachmentStatus())
                && Objects.equals(volumeSizeInBytes(), other.volumeSizeInBytes())
                && Objects.equals(volumeProgress(), other.volumeProgress())
                && Objects.equals(volumeDiskId(), other.volumeDiskId())
                && Objects.equals(sourceSnapshotId(), other.sourceSnapshotId())
                && Objects.equals(preservedExistingData(), other.preservedExistingData())
                && Objects.equals(volumeiSCSIAttributes(), other.volumeiSCSIAttributes())
                && Objects.equals(createdDate(), other.createdDate())
                && Objects.equals(volumeUsedInBytes(), other.volumeUsedInBytes()) && Objects.equals(kmsKey(), other.kmsKey())
                && Objects.equals(targetName(), other.targetName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StorediSCSIVolume").add("VolumeARN", volumeARN()).add("VolumeId", volumeId())
                .add("VolumeType", volumeType()).add("VolumeStatus", volumeStatus())
                .add("VolumeAttachmentStatus", volumeAttachmentStatus()).add("VolumeSizeInBytes", volumeSizeInBytes())
                .add("VolumeProgress", volumeProgress()).add("VolumeDiskId", volumeDiskId())
                .add("SourceSnapshotId", sourceSnapshotId()).add("PreservedExistingData", preservedExistingData())
                .add("VolumeiSCSIAttributes", volumeiSCSIAttributes()).add("CreatedDate", createdDate())
                .add("VolumeUsedInBytes", volumeUsedInBytes()).add("KMSKey", kmsKey()).add("TargetName", targetName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VolumeARN":
            return Optional.ofNullable(clazz.cast(volumeARN()));
        case "VolumeId":
            return Optional.ofNullable(clazz.cast(volumeId()));
        case "VolumeType":
            return Optional.ofNullable(clazz.cast(volumeType()));
        case "VolumeStatus":
            return Optional.ofNullable(clazz.cast(volumeStatus()));
        case "VolumeAttachmentStatus":
            return Optional.ofNullable(clazz.cast(volumeAttachmentStatus()));
        case "VolumeSizeInBytes":
            return Optional.ofNullable(clazz.cast(volumeSizeInBytes()));
        case "VolumeProgress":
            return Optional.ofNullable(clazz.cast(volumeProgress()));
        case "VolumeDiskId":
            return Optional.ofNullable(clazz.cast(volumeDiskId()));
        case "SourceSnapshotId":
            return Optional.ofNullable(clazz.cast(sourceSnapshotId()));
        case "PreservedExistingData":
            return Optional.ofNullable(clazz.cast(preservedExistingData()));
        case "VolumeiSCSIAttributes":
            return Optional.ofNullable(clazz.cast(volumeiSCSIAttributes()));
        case "CreatedDate":
            return Optional.ofNullable(clazz.cast(createdDate()));
        case "VolumeUsedInBytes":
            return Optional.ofNullable(clazz.cast(volumeUsedInBytes()));
        case "KMSKey":
            return Optional.ofNullable(clazz.cast(kmsKey()));
        case "TargetName":
            return Optional.ofNullable(clazz.cast(targetName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StorediSCSIVolume, T> g) {
        return obj -> g.apply((StorediSCSIVolume) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StorediSCSIVolume> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the storage volume.
         * </p>
         * 
         * @param volumeARN
         *        The Amazon Resource Name (ARN) of the storage volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeARN(String volumeARN);

        /**
         * <p>
         * The unique identifier of the volume, e.g., vol-AE4B946D.
         * </p>
         * 
         * @param volumeId
         *        The unique identifier of the volume, e.g., vol-AE4B946D.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeId(String volumeId);

        /**
         * <p>
         * One of the VolumeType enumeration values describing the type of the volume.
         * </p>
         * 
         * @param volumeType
         *        One of the VolumeType enumeration values describing the type of the volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeType(String volumeType);

        /**
         * <p>
         * One of the VolumeStatus values that indicates the state of the storage volume.
         * </p>
         * 
         * @param volumeStatus
         *        One of the VolumeStatus values that indicates the state of the storage volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeStatus(String volumeStatus);

        /**
         * <p>
         * A value that indicates whether a storage volume is attached to, detached from, or is in the process of
         * detaching from a gateway. For more information, see <a href=
         * "https://docs.aws.amazon.com/storagegateway/latest/userguide/managing-volumes.html#attach-detach-volume"
         * >Moving your volumes to a different gateway</a>.
         * </p>
         * 
         * @param volumeAttachmentStatus
         *        A value that indicates whether a storage volume is attached to, detached from, or is in the process of
         *        detaching from a gateway. For more information, see <a href=
         *        "https://docs.aws.amazon.com/storagegateway/latest/userguide/managing-volumes.html#attach-detach-volume"
         *        >Moving your volumes to a different gateway</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeAttachmentStatus(String volumeAttachmentStatus);

        /**
         * <p>
         * The size of the volume in bytes.
         * </p>
         * 
         * @param volumeSizeInBytes
         *        The size of the volume in bytes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeSizeInBytes(Long volumeSizeInBytes);

        /**
         * <p>
         * Represents the percentage complete if the volume is restoring or bootstrapping that represents the percent of
         * data transferred. This field does not appear in the response if the stored volume is not restoring or
         * bootstrapping.
         * </p>
         * 
         * @param volumeProgress
         *        Represents the percentage complete if the volume is restoring or bootstrapping that represents the
         *        percent of data transferred. This field does not appear in the response if the stored volume is not
         *        restoring or bootstrapping.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeProgress(Double volumeProgress);

        /**
         * <p>
         * The ID of the local disk that was specified in the <a>CreateStorediSCSIVolume</a> operation.
         * </p>
         * 
         * @param volumeDiskId
         *        The ID of the local disk that was specified in the <a>CreateStorediSCSIVolume</a> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeDiskId(String volumeDiskId);

        /**
         * <p>
         * If the stored volume was created from a snapshot, this field contains the snapshot ID used, e.g.
         * snap-78e22663. Otherwise, this field is not included.
         * </p>
         * 
         * @param sourceSnapshotId
         *        If the stored volume was created from a snapshot, this field contains the snapshot ID used, e.g.
         *        snap-78e22663. Otherwise, this field is not included.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceSnapshotId(String sourceSnapshotId);

        /**
         * <p>
         * Indicates if when the stored volume was created, existing data on the underlying local disk was preserved.
         * </p>
         * <p>
         * Valid Values: <code>true</code> | <code>false</code>
         * </p>
         * 
         * @param preservedExistingData
         *        Indicates if when the stored volume was created, existing data on the underlying local disk was
         *        preserved.</p>
         *        <p>
         *        Valid Values: <code>true</code> | <code>false</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preservedExistingData(Boolean preservedExistingData);

        /**
         * <p>
         * An <a>VolumeiSCSIAttributes</a> object that represents a collection of iSCSI attributes for one stored
         * volume.
         * </p>
         * 
         * @param volumeiSCSIAttributes
         *        An <a>VolumeiSCSIAttributes</a> object that represents a collection of iSCSI attributes for one stored
         *        volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeiSCSIAttributes(VolumeiSCSIAttributes volumeiSCSIAttributes);

        /**
         * <p>
         * An <a>VolumeiSCSIAttributes</a> object that represents a collection of iSCSI attributes for one stored
         * volume.
         * </p>
         * This is a convenience method that creates an instance of the {@link VolumeiSCSIAttributes.Builder} avoiding
         * the need to create one manually via {@link VolumeiSCSIAttributes#builder()}.
         *
         * When the {@link Consumer} completes, {@link VolumeiSCSIAttributes.Builder#build()} is called immediately and
         * its result is passed to {@link #volumeiSCSIAttributes(VolumeiSCSIAttributes)}.
         * 
         * @param volumeiSCSIAttributes
         *        a consumer that will call methods on {@link VolumeiSCSIAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #volumeiSCSIAttributes(VolumeiSCSIAttributes)
         */
        default Builder volumeiSCSIAttributes(Consumer<VolumeiSCSIAttributes.Builder> volumeiSCSIAttributes) {
            return volumeiSCSIAttributes(VolumeiSCSIAttributes.builder().applyMutation(volumeiSCSIAttributes).build());
        }

        /**
         * <p>
         * The date the volume was created. Volumes created prior to March 28, 2017 don’t have this timestamp.
         * </p>
         * 
         * @param createdDate
         *        The date the volume was created. Volumes created prior to March 28, 2017 don’t have this timestamp.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdDate(Instant createdDate);

        /**
         * <p>
         * The size of the data stored on the volume in bytes. This value is calculated based on the number of blocks
         * that are touched, instead of the actual amount of data written. This value can be useful for sequential write
         * patterns but less accurate for random write patterns. <code>VolumeUsedInBytes</code> is different from the
         * compressed size of the volume, which is the value that is used to calculate your bill.
         * </p>
         * <note>
         * <p>
         * This value is not available for volumes created prior to May 13, 2015, until you store data on the volume.
         * </p>
         * </note>
         * 
         * @param volumeUsedInBytes
         *        The size of the data stored on the volume in bytes. This value is calculated based on the number of
         *        blocks that are touched, instead of the actual amount of data written. This value can be useful for
         *        sequential write patterns but less accurate for random write patterns. <code>VolumeUsedInBytes</code>
         *        is different from the compressed size of the volume, which is the value that is used to calculate your
         *        bill.</p> <note>
         *        <p>
         *        This value is not available for volumes created prior to May 13, 2015, until you store data on the
         *        volume.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeUsedInBytes(Long volumeUsedInBytes);

        /**
         * Sets the value of the KMSKey property for this object.
         *
         * @param kmsKey
         *        The new value for the KMSKey property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKey(String kmsKey);

        /**
         * <p>
         * The name of the iSCSI target used by an initiator to connect to a volume and used as a suffix for the target
         * ARN. For example, specifying <code>TargetName</code> as <i>myvolume</i> results in the target ARN of
         * <code>arn:aws:storagegateway:us-east-2:111122223333:gateway/sgw-12A3456B/target/iqn.1997-05.com.amazon:myvolume</code>
         * . The target name must be unique across all volumes on a gateway.
         * </p>
         * <p>
         * If you don't specify a value, Storage Gateway uses the value that was previously used for this volume as the
         * new target name.
         * </p>
         * 
         * @param targetName
         *        The name of the iSCSI target used by an initiator to connect to a volume and used as a suffix for the
         *        target ARN. For example, specifying <code>TargetName</code> as <i>myvolume</i> results in the target
         *        ARN of
         *        <code>arn:aws:storagegateway:us-east-2:111122223333:gateway/sgw-12A3456B/target/iqn.1997-05.com.amazon:myvolume</code>
         *        . The target name must be unique across all volumes on a gateway.</p>
         *        <p>
         *        If you don't specify a value, Storage Gateway uses the value that was previously used for this volume
         *        as the new target name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetName(String targetName);
    }

    static final class BuilderImpl implements Builder {
        private String volumeARN;

        private String volumeId;

        private String volumeType;

        private String volumeStatus;

        private String volumeAttachmentStatus;

        private Long volumeSizeInBytes;

        private Double volumeProgress;

        private String volumeDiskId;

        private String sourceSnapshotId;

        private Boolean preservedExistingData;

        private VolumeiSCSIAttributes volumeiSCSIAttributes;

        private Instant createdDate;

        private Long volumeUsedInBytes;

        private String kmsKey;

        private String targetName;

        private BuilderImpl() {
        }

        private BuilderImpl(StorediSCSIVolume model) {
            volumeARN(model.volumeARN);
            volumeId(model.volumeId);
            volumeType(model.volumeType);
            volumeStatus(model.volumeStatus);
            volumeAttachmentStatus(model.volumeAttachmentStatus);
            volumeSizeInBytes(model.volumeSizeInBytes);
            volumeProgress(model.volumeProgress);
            volumeDiskId(model.volumeDiskId);
            sourceSnapshotId(model.sourceSnapshotId);
            preservedExistingData(model.preservedExistingData);
            volumeiSCSIAttributes(model.volumeiSCSIAttributes);
            createdDate(model.createdDate);
            volumeUsedInBytes(model.volumeUsedInBytes);
            kmsKey(model.kmsKey);
            targetName(model.targetName);
        }

        public final String getVolumeARN() {
            return volumeARN;
        }

        public final void setVolumeARN(String volumeARN) {
            this.volumeARN = volumeARN;
        }

        @Override
        public final Builder volumeARN(String volumeARN) {
            this.volumeARN = volumeARN;
            return this;
        }

        public final String getVolumeId() {
            return volumeId;
        }

        public final void setVolumeId(String volumeId) {
            this.volumeId = volumeId;
        }

        @Override
        public final Builder volumeId(String volumeId) {
            this.volumeId = volumeId;
            return this;
        }

        public final String getVolumeType() {
            return volumeType;
        }

        public final void setVolumeType(String volumeType) {
            this.volumeType = volumeType;
        }

        @Override
        public final Builder volumeType(String volumeType) {
            this.volumeType = volumeType;
            return this;
        }

        public final String getVolumeStatus() {
            return volumeStatus;
        }

        public final void setVolumeStatus(String volumeStatus) {
            this.volumeStatus = volumeStatus;
        }

        @Override
        public final Builder volumeStatus(String volumeStatus) {
            this.volumeStatus = volumeStatus;
            return this;
        }

        public final String getVolumeAttachmentStatus() {
            return volumeAttachmentStatus;
        }

        public final void setVolumeAttachmentStatus(String volumeAttachmentStatus) {
            this.volumeAttachmentStatus = volumeAttachmentStatus;
        }

        @Override
        public final Builder volumeAttachmentStatus(String volumeAttachmentStatus) {
            this.volumeAttachmentStatus = volumeAttachmentStatus;
            return this;
        }

        public final Long getVolumeSizeInBytes() {
            return volumeSizeInBytes;
        }

        public final void setVolumeSizeInBytes(Long volumeSizeInBytes) {
            this.volumeSizeInBytes = volumeSizeInBytes;
        }

        @Override
        public final Builder volumeSizeInBytes(Long volumeSizeInBytes) {
            this.volumeSizeInBytes = volumeSizeInBytes;
            return this;
        }

        public final Double getVolumeProgress() {
            return volumeProgress;
        }

        public final void setVolumeProgress(Double volumeProgress) {
            this.volumeProgress = volumeProgress;
        }

        @Override
        public final Builder volumeProgress(Double volumeProgress) {
            this.volumeProgress = volumeProgress;
            return this;
        }

        public final String getVolumeDiskId() {
            return volumeDiskId;
        }

        public final void setVolumeDiskId(String volumeDiskId) {
            this.volumeDiskId = volumeDiskId;
        }

        @Override
        public final Builder volumeDiskId(String volumeDiskId) {
            this.volumeDiskId = volumeDiskId;
            return this;
        }

        public final String getSourceSnapshotId() {
            return sourceSnapshotId;
        }

        public final void setSourceSnapshotId(String sourceSnapshotId) {
            this.sourceSnapshotId = sourceSnapshotId;
        }

        @Override
        public final Builder sourceSnapshotId(String sourceSnapshotId) {
            this.sourceSnapshotId = sourceSnapshotId;
            return this;
        }

        public final Boolean getPreservedExistingData() {
            return preservedExistingData;
        }

        public final void setPreservedExistingData(Boolean preservedExistingData) {
            this.preservedExistingData = preservedExistingData;
        }

        @Override
        public final Builder preservedExistingData(Boolean preservedExistingData) {
            this.preservedExistingData = preservedExistingData;
            return this;
        }

        public final VolumeiSCSIAttributes.Builder getVolumeiSCSIAttributes() {
            return volumeiSCSIAttributes != null ? volumeiSCSIAttributes.toBuilder() : null;
        }

        public final void setVolumeiSCSIAttributes(VolumeiSCSIAttributes.BuilderImpl volumeiSCSIAttributes) {
            this.volumeiSCSIAttributes = volumeiSCSIAttributes != null ? volumeiSCSIAttributes.build() : null;
        }

        @Override
        public final Builder volumeiSCSIAttributes(VolumeiSCSIAttributes volumeiSCSIAttributes) {
            this.volumeiSCSIAttributes = volumeiSCSIAttributes;
            return this;
        }

        public final Instant getCreatedDate() {
            return createdDate;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final Long getVolumeUsedInBytes() {
            return volumeUsedInBytes;
        }

        public final void setVolumeUsedInBytes(Long volumeUsedInBytes) {
            this.volumeUsedInBytes = volumeUsedInBytes;
        }

        @Override
        public final Builder volumeUsedInBytes(Long volumeUsedInBytes) {
            this.volumeUsedInBytes = volumeUsedInBytes;
            return this;
        }

        public final String getKmsKey() {
            return kmsKey;
        }

        public final void setKmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
        }

        @Override
        public final Builder kmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
            return this;
        }

        public final String getTargetName() {
            return targetName;
        }

        public final void setTargetName(String targetName) {
            this.targetName = targetName;
        }

        @Override
        public final Builder targetName(String targetName) {
            this.targetName = targetName;
            return this;
        }

        @Override
        public StorediSCSIVolume build() {
            return new StorediSCSIVolume(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
