/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a virtual tape object.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Tape implements SdkPojo, Serializable, ToCopyableBuilder<Tape.Builder, Tape> {
    private static final SdkField<String> TAPE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TapeARN").getter(getter(Tape::tapeARN)).setter(setter(Builder::tapeARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TapeARN").build()).build();

    private static final SdkField<String> TAPE_BARCODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TapeBarcode").getter(getter(Tape::tapeBarcode)).setter(setter(Builder::tapeBarcode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TapeBarcode").build()).build();

    private static final SdkField<Instant> TAPE_CREATED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("TapeCreatedDate").getter(getter(Tape::tapeCreatedDate)).setter(setter(Builder::tapeCreatedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TapeCreatedDate").build()).build();

    private static final SdkField<Long> TAPE_SIZE_IN_BYTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("TapeSizeInBytes").getter(getter(Tape::tapeSizeInBytes)).setter(setter(Builder::tapeSizeInBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TapeSizeInBytes").build()).build();

    private static final SdkField<String> TAPE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TapeStatus").getter(getter(Tape::tapeStatus)).setter(setter(Builder::tapeStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TapeStatus").build()).build();

    private static final SdkField<String> VTL_DEVICE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VTLDevice").getter(getter(Tape::vtlDevice)).setter(setter(Builder::vtlDevice))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VTLDevice").build()).build();

    private static final SdkField<Double> PROGRESS_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("Progress").getter(getter(Tape::progress)).setter(setter(Builder::progress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Progress").build()).build();

    private static final SdkField<Long> TAPE_USED_IN_BYTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("TapeUsedInBytes").getter(getter(Tape::tapeUsedInBytes)).setter(setter(Builder::tapeUsedInBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TapeUsedInBytes").build()).build();

    private static final SdkField<String> KMS_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("KMSKey")
            .getter(getter(Tape::kmsKey)).setter(setter(Builder::kmsKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KMSKey").build()).build();

    private static final SdkField<String> POOL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("PoolId")
            .getter(getter(Tape::poolId)).setter(setter(Builder::poolId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoolId").build()).build();

    private static final SdkField<Boolean> WORM_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN).memberName("Worm")
            .getter(getter(Tape::worm)).setter(setter(Builder::worm))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Worm").build()).build();

    private static final SdkField<Instant> RETENTION_START_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("RetentionStartDate").getter(getter(Tape::retentionStartDate))
            .setter(setter(Builder::retentionStartDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetentionStartDate").build())
            .build();

    private static final SdkField<Instant> POOL_ENTRY_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("PoolEntryDate").getter(getter(Tape::poolEntryDate)).setter(setter(Builder::poolEntryDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoolEntryDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TAPE_ARN_FIELD,
            TAPE_BARCODE_FIELD, TAPE_CREATED_DATE_FIELD, TAPE_SIZE_IN_BYTES_FIELD, TAPE_STATUS_FIELD, VTL_DEVICE_FIELD,
            PROGRESS_FIELD, TAPE_USED_IN_BYTES_FIELD, KMS_KEY_FIELD, POOL_ID_FIELD, WORM_FIELD, RETENTION_START_DATE_FIELD,
            POOL_ENTRY_DATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String tapeARN;

    private final String tapeBarcode;

    private final Instant tapeCreatedDate;

    private final Long tapeSizeInBytes;

    private final String tapeStatus;

    private final String vtlDevice;

    private final Double progress;

    private final Long tapeUsedInBytes;

    private final String kmsKey;

    private final String poolId;

    private final Boolean worm;

    private final Instant retentionStartDate;

    private final Instant poolEntryDate;

    private Tape(BuilderImpl builder) {
        this.tapeARN = builder.tapeARN;
        this.tapeBarcode = builder.tapeBarcode;
        this.tapeCreatedDate = builder.tapeCreatedDate;
        this.tapeSizeInBytes = builder.tapeSizeInBytes;
        this.tapeStatus = builder.tapeStatus;
        this.vtlDevice = builder.vtlDevice;
        this.progress = builder.progress;
        this.tapeUsedInBytes = builder.tapeUsedInBytes;
        this.kmsKey = builder.kmsKey;
        this.poolId = builder.poolId;
        this.worm = builder.worm;
        this.retentionStartDate = builder.retentionStartDate;
        this.poolEntryDate = builder.poolEntryDate;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the virtual tape.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the virtual tape.
     */
    public final String tapeARN() {
        return tapeARN;
    }

    /**
     * <p>
     * The barcode that identifies a specific virtual tape.
     * </p>
     * 
     * @return The barcode that identifies a specific virtual tape.
     */
    public final String tapeBarcode() {
        return tapeBarcode;
    }

    /**
     * <p>
     * The date the virtual tape was created.
     * </p>
     * 
     * @return The date the virtual tape was created.
     */
    public final Instant tapeCreatedDate() {
        return tapeCreatedDate;
    }

    /**
     * <p>
     * The size, in bytes, of the virtual tape capacity.
     * </p>
     * 
     * @return The size, in bytes, of the virtual tape capacity.
     */
    public final Long tapeSizeInBytes() {
        return tapeSizeInBytes;
    }

    /**
     * <p>
     * The current state of the virtual tape.
     * </p>
     * 
     * @return The current state of the virtual tape.
     */
    public final String tapeStatus() {
        return tapeStatus;
    }

    /**
     * <p>
     * The virtual tape library (VTL) device that the virtual tape is associated with.
     * </p>
     * 
     * @return The virtual tape library (VTL) device that the virtual tape is associated with.
     */
    public final String vtlDevice() {
        return vtlDevice;
    }

    /**
     * <p>
     * For archiving virtual tapes, indicates how much data remains to be uploaded before archiving is complete.
     * </p>
     * <p>
     * Range: 0 (not started) to 100 (complete).
     * </p>
     * 
     * @return For archiving virtual tapes, indicates how much data remains to be uploaded before archiving is
     *         complete.</p>
     *         <p>
     *         Range: 0 (not started) to 100 (complete).
     */
    public final Double progress() {
        return progress;
    }

    /**
     * <p>
     * The size, in bytes, of data stored on the virtual tape.
     * </p>
     * <note>
     * <p>
     * This value is not available for tapes created prior to May 13, 2015.
     * </p>
     * </note>
     * 
     * @return The size, in bytes, of data stored on the virtual tape.</p> <note>
     *         <p>
     *         This value is not available for tapes created prior to May 13, 2015.
     *         </p>
     */
    public final Long tapeUsedInBytes() {
        return tapeUsedInBytes;
    }

    /**
     * Returns the value of the KMSKey property for this object.
     * 
     * @return The value of the KMSKey property for this object.
     */
    public final String kmsKey() {
        return kmsKey;
    }

    /**
     * <p>
     * The ID of the pool that contains tapes that will be archived. The tapes in this pool are archived in the S3
     * storage class that is associated with the pool. When you use your backup application to eject the tape, the tape
     * is archived directly into the storage class (S3 Glacier or S3 Glacier Deep Archive) that corresponds to the pool.
     * </p>
     * <p>
     * Valid Values: <code>GLACIER</code> | <code>DEEP_ARCHIVE</code>
     * </p>
     * 
     * @return The ID of the pool that contains tapes that will be archived. The tapes in this pool are archived in the
     *         S3 storage class that is associated with the pool. When you use your backup application to eject the
     *         tape, the tape is archived directly into the storage class (S3 Glacier or S3 Glacier Deep Archive) that
     *         corresponds to the pool.</p>
     *         <p>
     *         Valid Values: <code>GLACIER</code> | <code>DEEP_ARCHIVE</code>
     */
    public final String poolId() {
        return poolId;
    }

    /**
     * <p>
     * If the tape is archived as write-once-read-many (WORM), this value is <code>true</code>.
     * </p>
     * 
     * @return If the tape is archived as write-once-read-many (WORM), this value is <code>true</code>.
     */
    public final Boolean worm() {
        return worm;
    }

    /**
     * <p>
     * The date that the tape is first archived with tape retention lock enabled.
     * </p>
     * 
     * @return The date that the tape is first archived with tape retention lock enabled.
     */
    public final Instant retentionStartDate() {
        return retentionStartDate;
    }

    /**
     * <p>
     * The date that the tape enters a custom tape pool.
     * </p>
     * 
     * @return The date that the tape enters a custom tape pool.
     */
    public final Instant poolEntryDate() {
        return poolEntryDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(tapeARN());
        hashCode = 31 * hashCode + Objects.hashCode(tapeBarcode());
        hashCode = 31 * hashCode + Objects.hashCode(tapeCreatedDate());
        hashCode = 31 * hashCode + Objects.hashCode(tapeSizeInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(tapeStatus());
        hashCode = 31 * hashCode + Objects.hashCode(vtlDevice());
        hashCode = 31 * hashCode + Objects.hashCode(progress());
        hashCode = 31 * hashCode + Objects.hashCode(tapeUsedInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKey());
        hashCode = 31 * hashCode + Objects.hashCode(poolId());
        hashCode = 31 * hashCode + Objects.hashCode(worm());
        hashCode = 31 * hashCode + Objects.hashCode(retentionStartDate());
        hashCode = 31 * hashCode + Objects.hashCode(poolEntryDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Tape)) {
            return false;
        }
        Tape other = (Tape) obj;
        return Objects.equals(tapeARN(), other.tapeARN()) && Objects.equals(tapeBarcode(), other.tapeBarcode())
                && Objects.equals(tapeCreatedDate(), other.tapeCreatedDate())
                && Objects.equals(tapeSizeInBytes(), other.tapeSizeInBytes()) && Objects.equals(tapeStatus(), other.tapeStatus())
                && Objects.equals(vtlDevice(), other.vtlDevice()) && Objects.equals(progress(), other.progress())
                && Objects.equals(tapeUsedInBytes(), other.tapeUsedInBytes()) && Objects.equals(kmsKey(), other.kmsKey())
                && Objects.equals(poolId(), other.poolId()) && Objects.equals(worm(), other.worm())
                && Objects.equals(retentionStartDate(), other.retentionStartDate())
                && Objects.equals(poolEntryDate(), other.poolEntryDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Tape").add("TapeARN", tapeARN()).add("TapeBarcode", tapeBarcode())
                .add("TapeCreatedDate", tapeCreatedDate()).add("TapeSizeInBytes", tapeSizeInBytes())
                .add("TapeStatus", tapeStatus()).add("VTLDevice", vtlDevice()).add("Progress", progress())
                .add("TapeUsedInBytes", tapeUsedInBytes()).add("KMSKey", kmsKey()).add("PoolId", poolId()).add("Worm", worm())
                .add("RetentionStartDate", retentionStartDate()).add("PoolEntryDate", poolEntryDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TapeARN":
            return Optional.ofNullable(clazz.cast(tapeARN()));
        case "TapeBarcode":
            return Optional.ofNullable(clazz.cast(tapeBarcode()));
        case "TapeCreatedDate":
            return Optional.ofNullable(clazz.cast(tapeCreatedDate()));
        case "TapeSizeInBytes":
            return Optional.ofNullable(clazz.cast(tapeSizeInBytes()));
        case "TapeStatus":
            return Optional.ofNullable(clazz.cast(tapeStatus()));
        case "VTLDevice":
            return Optional.ofNullable(clazz.cast(vtlDevice()));
        case "Progress":
            return Optional.ofNullable(clazz.cast(progress()));
        case "TapeUsedInBytes":
            return Optional.ofNullable(clazz.cast(tapeUsedInBytes()));
        case "KMSKey":
            return Optional.ofNullable(clazz.cast(kmsKey()));
        case "PoolId":
            return Optional.ofNullable(clazz.cast(poolId()));
        case "Worm":
            return Optional.ofNullable(clazz.cast(worm()));
        case "RetentionStartDate":
            return Optional.ofNullable(clazz.cast(retentionStartDate()));
        case "PoolEntryDate":
            return Optional.ofNullable(clazz.cast(poolEntryDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Tape, T> g) {
        return obj -> g.apply((Tape) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Tape> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the virtual tape.
         * </p>
         * 
         * @param tapeARN
         *        The Amazon Resource Name (ARN) of the virtual tape.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tapeARN(String tapeARN);

        /**
         * <p>
         * The barcode that identifies a specific virtual tape.
         * </p>
         * 
         * @param tapeBarcode
         *        The barcode that identifies a specific virtual tape.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tapeBarcode(String tapeBarcode);

        /**
         * <p>
         * The date the virtual tape was created.
         * </p>
         * 
         * @param tapeCreatedDate
         *        The date the virtual tape was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tapeCreatedDate(Instant tapeCreatedDate);

        /**
         * <p>
         * The size, in bytes, of the virtual tape capacity.
         * </p>
         * 
         * @param tapeSizeInBytes
         *        The size, in bytes, of the virtual tape capacity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tapeSizeInBytes(Long tapeSizeInBytes);

        /**
         * <p>
         * The current state of the virtual tape.
         * </p>
         * 
         * @param tapeStatus
         *        The current state of the virtual tape.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tapeStatus(String tapeStatus);

        /**
         * <p>
         * The virtual tape library (VTL) device that the virtual tape is associated with.
         * </p>
         * 
         * @param vtlDevice
         *        The virtual tape library (VTL) device that the virtual tape is associated with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vtlDevice(String vtlDevice);

        /**
         * <p>
         * For archiving virtual tapes, indicates how much data remains to be uploaded before archiving is complete.
         * </p>
         * <p>
         * Range: 0 (not started) to 100 (complete).
         * </p>
         * 
         * @param progress
         *        For archiving virtual tapes, indicates how much data remains to be uploaded before archiving is
         *        complete.</p>
         *        <p>
         *        Range: 0 (not started) to 100 (complete).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder progress(Double progress);

        /**
         * <p>
         * The size, in bytes, of data stored on the virtual tape.
         * </p>
         * <note>
         * <p>
         * This value is not available for tapes created prior to May 13, 2015.
         * </p>
         * </note>
         * 
         * @param tapeUsedInBytes
         *        The size, in bytes, of data stored on the virtual tape.</p> <note>
         *        <p>
         *        This value is not available for tapes created prior to May 13, 2015.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tapeUsedInBytes(Long tapeUsedInBytes);

        /**
         * Sets the value of the KMSKey property for this object.
         *
         * @param kmsKey
         *        The new value for the KMSKey property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKey(String kmsKey);

        /**
         * <p>
         * The ID of the pool that contains tapes that will be archived. The tapes in this pool are archived in the S3
         * storage class that is associated with the pool. When you use your backup application to eject the tape, the
         * tape is archived directly into the storage class (S3 Glacier or S3 Glacier Deep Archive) that corresponds to
         * the pool.
         * </p>
         * <p>
         * Valid Values: <code>GLACIER</code> | <code>DEEP_ARCHIVE</code>
         * </p>
         * 
         * @param poolId
         *        The ID of the pool that contains tapes that will be archived. The tapes in this pool are archived in
         *        the S3 storage class that is associated with the pool. When you use your backup application to eject
         *        the tape, the tape is archived directly into the storage class (S3 Glacier or S3 Glacier Deep Archive)
         *        that corresponds to the pool.</p>
         *        <p>
         *        Valid Values: <code>GLACIER</code> | <code>DEEP_ARCHIVE</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder poolId(String poolId);

        /**
         * <p>
         * If the tape is archived as write-once-read-many (WORM), this value is <code>true</code>.
         * </p>
         * 
         * @param worm
         *        If the tape is archived as write-once-read-many (WORM), this value is <code>true</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder worm(Boolean worm);

        /**
         * <p>
         * The date that the tape is first archived with tape retention lock enabled.
         * </p>
         * 
         * @param retentionStartDate
         *        The date that the tape is first archived with tape retention lock enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retentionStartDate(Instant retentionStartDate);

        /**
         * <p>
         * The date that the tape enters a custom tape pool.
         * </p>
         * 
         * @param poolEntryDate
         *        The date that the tape enters a custom tape pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder poolEntryDate(Instant poolEntryDate);
    }

    static final class BuilderImpl implements Builder {
        private String tapeARN;

        private String tapeBarcode;

        private Instant tapeCreatedDate;

        private Long tapeSizeInBytes;

        private String tapeStatus;

        private String vtlDevice;

        private Double progress;

        private Long tapeUsedInBytes;

        private String kmsKey;

        private String poolId;

        private Boolean worm;

        private Instant retentionStartDate;

        private Instant poolEntryDate;

        private BuilderImpl() {
        }

        private BuilderImpl(Tape model) {
            tapeARN(model.tapeARN);
            tapeBarcode(model.tapeBarcode);
            tapeCreatedDate(model.tapeCreatedDate);
            tapeSizeInBytes(model.tapeSizeInBytes);
            tapeStatus(model.tapeStatus);
            vtlDevice(model.vtlDevice);
            progress(model.progress);
            tapeUsedInBytes(model.tapeUsedInBytes);
            kmsKey(model.kmsKey);
            poolId(model.poolId);
            worm(model.worm);
            retentionStartDate(model.retentionStartDate);
            poolEntryDate(model.poolEntryDate);
        }

        public final String getTapeARN() {
            return tapeARN;
        }

        public final void setTapeARN(String tapeARN) {
            this.tapeARN = tapeARN;
        }

        @Override
        public final Builder tapeARN(String tapeARN) {
            this.tapeARN = tapeARN;
            return this;
        }

        public final String getTapeBarcode() {
            return tapeBarcode;
        }

        public final void setTapeBarcode(String tapeBarcode) {
            this.tapeBarcode = tapeBarcode;
        }

        @Override
        public final Builder tapeBarcode(String tapeBarcode) {
            this.tapeBarcode = tapeBarcode;
            return this;
        }

        public final Instant getTapeCreatedDate() {
            return tapeCreatedDate;
        }

        public final void setTapeCreatedDate(Instant tapeCreatedDate) {
            this.tapeCreatedDate = tapeCreatedDate;
        }

        @Override
        public final Builder tapeCreatedDate(Instant tapeCreatedDate) {
            this.tapeCreatedDate = tapeCreatedDate;
            return this;
        }

        public final Long getTapeSizeInBytes() {
            return tapeSizeInBytes;
        }

        public final void setTapeSizeInBytes(Long tapeSizeInBytes) {
            this.tapeSizeInBytes = tapeSizeInBytes;
        }

        @Override
        public final Builder tapeSizeInBytes(Long tapeSizeInBytes) {
            this.tapeSizeInBytes = tapeSizeInBytes;
            return this;
        }

        public final String getTapeStatus() {
            return tapeStatus;
        }

        public final void setTapeStatus(String tapeStatus) {
            this.tapeStatus = tapeStatus;
        }

        @Override
        public final Builder tapeStatus(String tapeStatus) {
            this.tapeStatus = tapeStatus;
            return this;
        }

        public final String getVtlDevice() {
            return vtlDevice;
        }

        public final void setVtlDevice(String vtlDevice) {
            this.vtlDevice = vtlDevice;
        }

        @Override
        public final Builder vtlDevice(String vtlDevice) {
            this.vtlDevice = vtlDevice;
            return this;
        }

        public final Double getProgress() {
            return progress;
        }

        public final void setProgress(Double progress) {
            this.progress = progress;
        }

        @Override
        public final Builder progress(Double progress) {
            this.progress = progress;
            return this;
        }

        public final Long getTapeUsedInBytes() {
            return tapeUsedInBytes;
        }

        public final void setTapeUsedInBytes(Long tapeUsedInBytes) {
            this.tapeUsedInBytes = tapeUsedInBytes;
        }

        @Override
        public final Builder tapeUsedInBytes(Long tapeUsedInBytes) {
            this.tapeUsedInBytes = tapeUsedInBytes;
            return this;
        }

        public final String getKmsKey() {
            return kmsKey;
        }

        public final void setKmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
        }

        @Override
        public final Builder kmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
            return this;
        }

        public final String getPoolId() {
            return poolId;
        }

        public final void setPoolId(String poolId) {
            this.poolId = poolId;
        }

        @Override
        public final Builder poolId(String poolId) {
            this.poolId = poolId;
            return this;
        }

        public final Boolean getWorm() {
            return worm;
        }

        public final void setWorm(Boolean worm) {
            this.worm = worm;
        }

        @Override
        public final Builder worm(Boolean worm) {
            this.worm = worm;
            return this;
        }

        public final Instant getRetentionStartDate() {
            return retentionStartDate;
        }

        public final void setRetentionStartDate(Instant retentionStartDate) {
            this.retentionStartDate = retentionStartDate;
        }

        @Override
        public final Builder retentionStartDate(Instant retentionStartDate) {
            this.retentionStartDate = retentionStartDate;
            return this;
        }

        public final Instant getPoolEntryDate() {
            return poolEntryDate;
        }

        public final void setPoolEntryDate(Instant poolEntryDate) {
            this.poolEntryDate = poolEntryDate;
        }

        @Override
        public final Builder poolEntryDate(Instant poolEntryDate) {
            this.poolEntryDate = poolEntryDate;
            return this;
        }

        @Override
        public Tape build() {
            return new Tape(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
