/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.storagegateway.model.StorageGatewayResponse;
import software.amazon.awssdk.services.storagegateway.model.TapeInfo;
import software.amazon.awssdk.services.storagegateway.model.TapeInfosCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTapesResponse
extends StorageGatewayResponse
implements ToCopyableBuilder<Builder, ListTapesResponse> {
    private static final SdkField<List<TapeInfo>> TAPE_INFOS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TapeInfos").getter(ListTapesResponse.getter(ListTapesResponse::tapeInfos)).setter(ListTapesResponse.setter(Builder::tapeInfos)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TapeInfos").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TapeInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(ListTapesResponse.getter(ListTapesResponse::marker)).setter(ListTapesResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TAPE_INFOS_FIELD, MARKER_FIELD));
    private final List<TapeInfo> tapeInfos;
    private final String marker;

    private ListTapesResponse(BuilderImpl builder) {
        super(builder);
        this.tapeInfos = builder.tapeInfos;
        this.marker = builder.marker;
    }

    public final boolean hasTapeInfos() {
        return this.tapeInfos != null && !(this.tapeInfos instanceof SdkAutoConstructList);
    }

    public final List<TapeInfo> tapeInfos() {
        return this.tapeInfos;
    }

    public final String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTapeInfos() ? this.tapeInfos() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTapesResponse)) {
            return false;
        }
        ListTapesResponse other = (ListTapesResponse)((Object)obj);
        return this.hasTapeInfos() == other.hasTapeInfos() && Objects.equals(this.tapeInfos(), other.tapeInfos()) && Objects.equals(this.marker(), other.marker());
    }

    public final String toString() {
        return ToString.builder((String)"ListTapesResponse").add("TapeInfos", this.hasTapeInfos() ? this.tapeInfos() : null).add("Marker", (Object)this.marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TapeInfos": {
                return Optional.ofNullable(clazz.cast(this.tapeInfos()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTapesResponse, T> g) {
        return obj -> g.apply((ListTapesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends StorageGatewayResponse.BuilderImpl
    implements Builder {
        private List<TapeInfo> tapeInfos = DefaultSdkAutoConstructList.getInstance();
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTapesResponse model) {
            super(model);
            this.tapeInfos(model.tapeInfos);
            this.marker(model.marker);
        }

        public final List<TapeInfo.Builder> getTapeInfos() {
            List<TapeInfo.Builder> result = TapeInfosCopier.copyToBuilder(this.tapeInfos);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTapeInfos(Collection<TapeInfo.BuilderImpl> tapeInfos) {
            this.tapeInfos = TapeInfosCopier.copyFromBuilder(tapeInfos);
        }

        @Override
        @Transient
        public final Builder tapeInfos(Collection<TapeInfo> tapeInfos) {
            this.tapeInfos = TapeInfosCopier.copy(tapeInfos);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tapeInfos(TapeInfo ... tapeInfos) {
            this.tapeInfos(Arrays.asList(tapeInfos));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tapeInfos(Consumer<TapeInfo.Builder> ... tapeInfos) {
            this.tapeInfos(Stream.of(tapeInfos).map(c -> (TapeInfo)((TapeInfo.Builder)TapeInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getMarker() {
            return this.marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        @Transient
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        @Override
        public ListTapesResponse build() {
            return new ListTapesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends StorageGatewayResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTapesResponse> {
        public Builder tapeInfos(Collection<TapeInfo> var1);

        public Builder tapeInfos(TapeInfo ... var1);

        public Builder tapeInfos(Consumer<TapeInfo.Builder> ... var1);

        public Builder marker(String var1);
    }
}

