/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a custom tape pool.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PoolInfo implements SdkPojo, Serializable, ToCopyableBuilder<PoolInfo.Builder, PoolInfo> {
    private static final SdkField<String> POOL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PoolARN").getter(getter(PoolInfo::poolARN)).setter(setter(Builder::poolARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoolARN").build()).build();

    private static final SdkField<String> POOL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PoolName").getter(getter(PoolInfo::poolName)).setter(setter(Builder::poolName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoolName").build()).build();

    private static final SdkField<String> STORAGE_CLASS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StorageClass").getter(getter(PoolInfo::storageClassAsString)).setter(setter(Builder::storageClass))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageClass").build()).build();

    private static final SdkField<String> RETENTION_LOCK_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RetentionLockType").getter(getter(PoolInfo::retentionLockTypeAsString))
            .setter(setter(Builder::retentionLockType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetentionLockType").build()).build();

    private static final SdkField<Integer> RETENTION_LOCK_TIME_IN_DAYS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("RetentionLockTimeInDays")
            .getter(getter(PoolInfo::retentionLockTimeInDays)).setter(setter(Builder::retentionLockTimeInDays))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetentionLockTimeInDays").build())
            .build();

    private static final SdkField<String> POOL_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PoolStatus").getter(getter(PoolInfo::poolStatusAsString)).setter(setter(Builder::poolStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoolStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(POOL_ARN_FIELD, POOL_NAME_FIELD, STORAGE_CLASS_FIELD, RETENTION_LOCK_TYPE_FIELD,
                    RETENTION_LOCK_TIME_IN_DAYS_FIELD, POOL_STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String poolARN;

    private final String poolName;

    private final String storageClass;

    private final String retentionLockType;

    private final Integer retentionLockTimeInDays;

    private final String poolStatus;

    private PoolInfo(BuilderImpl builder) {
        this.poolARN = builder.poolARN;
        this.poolName = builder.poolName;
        this.storageClass = builder.storageClass;
        this.retentionLockType = builder.retentionLockType;
        this.retentionLockTimeInDays = builder.retentionLockTimeInDays;
        this.poolStatus = builder.poolStatus;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the custom tape pool. Use the <a>ListTapePools</a> operation to return a list
     * of custom tape pools for your account and Region.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the custom tape pool. Use the <a>ListTapePools</a> operation to return
     *         a list of custom tape pools for your account and Region.
     */
    public final String poolARN() {
        return poolARN;
    }

    /**
     * <p>
     * The name of the custom tape pool. <code>PoolName</code> can use all ASCII characters, except '/' and '\'.
     * </p>
     * 
     * @return The name of the custom tape pool. <code>PoolName</code> can use all ASCII characters, except '/' and '\'.
     */
    public final String poolName() {
        return poolName;
    }

    /**
     * <p>
     * The storage class that is associated with the custom pool. When you use your backup application to eject the
     * tape, the tape is archived directly into the storage class (S3 Glacier or S3 Glacier Deep Archive) that
     * corresponds to the pool.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #storageClass} will
     * return {@link TapeStorageClass#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #storageClassAsString}.
     * </p>
     * 
     * @return The storage class that is associated with the custom pool. When you use your backup application to eject
     *         the tape, the tape is archived directly into the storage class (S3 Glacier or S3 Glacier Deep Archive)
     *         that corresponds to the pool.
     * @see TapeStorageClass
     */
    public final TapeStorageClass storageClass() {
        return TapeStorageClass.fromValue(storageClass);
    }

    /**
     * <p>
     * The storage class that is associated with the custom pool. When you use your backup application to eject the
     * tape, the tape is archived directly into the storage class (S3 Glacier or S3 Glacier Deep Archive) that
     * corresponds to the pool.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #storageClass} will
     * return {@link TapeStorageClass#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #storageClassAsString}.
     * </p>
     * 
     * @return The storage class that is associated with the custom pool. When you use your backup application to eject
     *         the tape, the tape is archived directly into the storage class (S3 Glacier or S3 Glacier Deep Archive)
     *         that corresponds to the pool.
     * @see TapeStorageClass
     */
    public final String storageClassAsString() {
        return storageClass;
    }

    /**
     * <p>
     * Tape retention lock type, which can be configured in two modes. When configured in governance mode, accounts with
     * specific IAM permissions are authorized to remove the tape retention lock from archived virtual tapes. When
     * configured in compliance mode, the tape retention lock cannot be removed by any user, including the root account.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #retentionLockType}
     * will return {@link RetentionLockType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #retentionLockTypeAsString}.
     * </p>
     * 
     * @return Tape retention lock type, which can be configured in two modes. When configured in governance mode,
     *         accounts with specific IAM permissions are authorized to remove the tape retention lock from archived
     *         virtual tapes. When configured in compliance mode, the tape retention lock cannot be removed by any user,
     *         including the root account.
     * @see RetentionLockType
     */
    public final RetentionLockType retentionLockType() {
        return RetentionLockType.fromValue(retentionLockType);
    }

    /**
     * <p>
     * Tape retention lock type, which can be configured in two modes. When configured in governance mode, accounts with
     * specific IAM permissions are authorized to remove the tape retention lock from archived virtual tapes. When
     * configured in compliance mode, the tape retention lock cannot be removed by any user, including the root account.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #retentionLockType}
     * will return {@link RetentionLockType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #retentionLockTypeAsString}.
     * </p>
     * 
     * @return Tape retention lock type, which can be configured in two modes. When configured in governance mode,
     *         accounts with specific IAM permissions are authorized to remove the tape retention lock from archived
     *         virtual tapes. When configured in compliance mode, the tape retention lock cannot be removed by any user,
     *         including the root account.
     * @see RetentionLockType
     */
    public final String retentionLockTypeAsString() {
        return retentionLockType;
    }

    /**
     * <p>
     * Tape retention lock time is set in days. Tape retention lock can be enabled for up to 100 years (36,500 days).
     * </p>
     * 
     * @return Tape retention lock time is set in days. Tape retention lock can be enabled for up to 100 years (36,500
     *         days).
     */
    public final Integer retentionLockTimeInDays() {
        return retentionLockTimeInDays;
    }

    /**
     * <p>
     * Status of the custom tape pool. Pool can be <code>ACTIVE</code> or <code>DELETED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #poolStatus} will
     * return {@link PoolStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #poolStatusAsString}.
     * </p>
     * 
     * @return Status of the custom tape pool. Pool can be <code>ACTIVE</code> or <code>DELETED</code>.
     * @see PoolStatus
     */
    public final PoolStatus poolStatus() {
        return PoolStatus.fromValue(poolStatus);
    }

    /**
     * <p>
     * Status of the custom tape pool. Pool can be <code>ACTIVE</code> or <code>DELETED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #poolStatus} will
     * return {@link PoolStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #poolStatusAsString}.
     * </p>
     * 
     * @return Status of the custom tape pool. Pool can be <code>ACTIVE</code> or <code>DELETED</code>.
     * @see PoolStatus
     */
    public final String poolStatusAsString() {
        return poolStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(poolARN());
        hashCode = 31 * hashCode + Objects.hashCode(poolName());
        hashCode = 31 * hashCode + Objects.hashCode(storageClassAsString());
        hashCode = 31 * hashCode + Objects.hashCode(retentionLockTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(retentionLockTimeInDays());
        hashCode = 31 * hashCode + Objects.hashCode(poolStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PoolInfo)) {
            return false;
        }
        PoolInfo other = (PoolInfo) obj;
        return Objects.equals(poolARN(), other.poolARN()) && Objects.equals(poolName(), other.poolName())
                && Objects.equals(storageClassAsString(), other.storageClassAsString())
                && Objects.equals(retentionLockTypeAsString(), other.retentionLockTypeAsString())
                && Objects.equals(retentionLockTimeInDays(), other.retentionLockTimeInDays())
                && Objects.equals(poolStatusAsString(), other.poolStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PoolInfo").add("PoolARN", poolARN()).add("PoolName", poolName())
                .add("StorageClass", storageClassAsString()).add("RetentionLockType", retentionLockTypeAsString())
                .add("RetentionLockTimeInDays", retentionLockTimeInDays()).add("PoolStatus", poolStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PoolARN":
            return Optional.ofNullable(clazz.cast(poolARN()));
        case "PoolName":
            return Optional.ofNullable(clazz.cast(poolName()));
        case "StorageClass":
            return Optional.ofNullable(clazz.cast(storageClassAsString()));
        case "RetentionLockType":
            return Optional.ofNullable(clazz.cast(retentionLockTypeAsString()));
        case "RetentionLockTimeInDays":
            return Optional.ofNullable(clazz.cast(retentionLockTimeInDays()));
        case "PoolStatus":
            return Optional.ofNullable(clazz.cast(poolStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PoolInfo, T> g) {
        return obj -> g.apply((PoolInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PoolInfo> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the custom tape pool. Use the <a>ListTapePools</a> operation to return a
         * list of custom tape pools for your account and Region.
         * </p>
         * 
         * @param poolARN
         *        The Amazon Resource Name (ARN) of the custom tape pool. Use the <a>ListTapePools</a> operation to
         *        return a list of custom tape pools for your account and Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder poolARN(String poolARN);

        /**
         * <p>
         * The name of the custom tape pool. <code>PoolName</code> can use all ASCII characters, except '/' and '\'.
         * </p>
         * 
         * @param poolName
         *        The name of the custom tape pool. <code>PoolName</code> can use all ASCII characters, except '/' and
         *        '\'.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder poolName(String poolName);

        /**
         * <p>
         * The storage class that is associated with the custom pool. When you use your backup application to eject the
         * tape, the tape is archived directly into the storage class (S3 Glacier or S3 Glacier Deep Archive) that
         * corresponds to the pool.
         * </p>
         * 
         * @param storageClass
         *        The storage class that is associated with the custom pool. When you use your backup application to
         *        eject the tape, the tape is archived directly into the storage class (S3 Glacier or S3 Glacier Deep
         *        Archive) that corresponds to the pool.
         * @see TapeStorageClass
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TapeStorageClass
         */
        Builder storageClass(String storageClass);

        /**
         * <p>
         * The storage class that is associated with the custom pool. When you use your backup application to eject the
         * tape, the tape is archived directly into the storage class (S3 Glacier or S3 Glacier Deep Archive) that
         * corresponds to the pool.
         * </p>
         * 
         * @param storageClass
         *        The storage class that is associated with the custom pool. When you use your backup application to
         *        eject the tape, the tape is archived directly into the storage class (S3 Glacier or S3 Glacier Deep
         *        Archive) that corresponds to the pool.
         * @see TapeStorageClass
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TapeStorageClass
         */
        Builder storageClass(TapeStorageClass storageClass);

        /**
         * <p>
         * Tape retention lock type, which can be configured in two modes. When configured in governance mode, accounts
         * with specific IAM permissions are authorized to remove the tape retention lock from archived virtual tapes.
         * When configured in compliance mode, the tape retention lock cannot be removed by any user, including the root
         * account.
         * </p>
         * 
         * @param retentionLockType
         *        Tape retention lock type, which can be configured in two modes. When configured in governance mode,
         *        accounts with specific IAM permissions are authorized to remove the tape retention lock from archived
         *        virtual tapes. When configured in compliance mode, the tape retention lock cannot be removed by any
         *        user, including the root account.
         * @see RetentionLockType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RetentionLockType
         */
        Builder retentionLockType(String retentionLockType);

        /**
         * <p>
         * Tape retention lock type, which can be configured in two modes. When configured in governance mode, accounts
         * with specific IAM permissions are authorized to remove the tape retention lock from archived virtual tapes.
         * When configured in compliance mode, the tape retention lock cannot be removed by any user, including the root
         * account.
         * </p>
         * 
         * @param retentionLockType
         *        Tape retention lock type, which can be configured in two modes. When configured in governance mode,
         *        accounts with specific IAM permissions are authorized to remove the tape retention lock from archived
         *        virtual tapes. When configured in compliance mode, the tape retention lock cannot be removed by any
         *        user, including the root account.
         * @see RetentionLockType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RetentionLockType
         */
        Builder retentionLockType(RetentionLockType retentionLockType);

        /**
         * <p>
         * Tape retention lock time is set in days. Tape retention lock can be enabled for up to 100 years (36,500
         * days).
         * </p>
         * 
         * @param retentionLockTimeInDays
         *        Tape retention lock time is set in days. Tape retention lock can be enabled for up to 100 years
         *        (36,500 days).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retentionLockTimeInDays(Integer retentionLockTimeInDays);

        /**
         * <p>
         * Status of the custom tape pool. Pool can be <code>ACTIVE</code> or <code>DELETED</code>.
         * </p>
         * 
         * @param poolStatus
         *        Status of the custom tape pool. Pool can be <code>ACTIVE</code> or <code>DELETED</code>.
         * @see PoolStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PoolStatus
         */
        Builder poolStatus(String poolStatus);

        /**
         * <p>
         * Status of the custom tape pool. Pool can be <code>ACTIVE</code> or <code>DELETED</code>.
         * </p>
         * 
         * @param poolStatus
         *        Status of the custom tape pool. Pool can be <code>ACTIVE</code> or <code>DELETED</code>.
         * @see PoolStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PoolStatus
         */
        Builder poolStatus(PoolStatus poolStatus);
    }

    static final class BuilderImpl implements Builder {
        private String poolARN;

        private String poolName;

        private String storageClass;

        private String retentionLockType;

        private Integer retentionLockTimeInDays;

        private String poolStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(PoolInfo model) {
            poolARN(model.poolARN);
            poolName(model.poolName);
            storageClass(model.storageClass);
            retentionLockType(model.retentionLockType);
            retentionLockTimeInDays(model.retentionLockTimeInDays);
            poolStatus(model.poolStatus);
        }

        public final String getPoolARN() {
            return poolARN;
        }

        public final void setPoolARN(String poolARN) {
            this.poolARN = poolARN;
        }

        @Override
        @Transient
        public final Builder poolARN(String poolARN) {
            this.poolARN = poolARN;
            return this;
        }

        public final String getPoolName() {
            return poolName;
        }

        public final void setPoolName(String poolName) {
            this.poolName = poolName;
        }

        @Override
        @Transient
        public final Builder poolName(String poolName) {
            this.poolName = poolName;
            return this;
        }

        public final String getStorageClass() {
            return storageClass;
        }

        public final void setStorageClass(String storageClass) {
            this.storageClass = storageClass;
        }

        @Override
        @Transient
        public final Builder storageClass(String storageClass) {
            this.storageClass = storageClass;
            return this;
        }

        @Override
        @Transient
        public final Builder storageClass(TapeStorageClass storageClass) {
            this.storageClass(storageClass == null ? null : storageClass.toString());
            return this;
        }

        public final String getRetentionLockType() {
            return retentionLockType;
        }

        public final void setRetentionLockType(String retentionLockType) {
            this.retentionLockType = retentionLockType;
        }

        @Override
        @Transient
        public final Builder retentionLockType(String retentionLockType) {
            this.retentionLockType = retentionLockType;
            return this;
        }

        @Override
        @Transient
        public final Builder retentionLockType(RetentionLockType retentionLockType) {
            this.retentionLockType(retentionLockType == null ? null : retentionLockType.toString());
            return this;
        }

        public final Integer getRetentionLockTimeInDays() {
            return retentionLockTimeInDays;
        }

        public final void setRetentionLockTimeInDays(Integer retentionLockTimeInDays) {
            this.retentionLockTimeInDays = retentionLockTimeInDays;
        }

        @Override
        @Transient
        public final Builder retentionLockTimeInDays(Integer retentionLockTimeInDays) {
            this.retentionLockTimeInDays = retentionLockTimeInDays;
            return this;
        }

        public final String getPoolStatus() {
            return poolStatus;
        }

        public final void setPoolStatus(String poolStatus) {
            this.poolStatus = poolStatus;
        }

        @Override
        @Transient
        public final Builder poolStatus(String poolStatus) {
            this.poolStatus = poolStatus;
            return this;
        }

        @Override
        @Transient
        public final Builder poolStatus(PoolStatus poolStatus) {
            this.poolStatus(poolStatus == null ? null : poolStatus.toString());
            return this;
        }

        @Override
        public PoolInfo build() {
            return new PoolInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
