/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * RetrieveTapeArchiveInput
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RetrieveTapeArchiveRequest extends StorageGatewayRequest implements
        ToCopyableBuilder<RetrieveTapeArchiveRequest.Builder, RetrieveTapeArchiveRequest> {
    private static final SdkField<String> TAPE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TapeARN").getter(getter(RetrieveTapeArchiveRequest::tapeARN)).setter(setter(Builder::tapeARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TapeARN").build()).build();

    private static final SdkField<String> GATEWAY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GatewayARN").getter(getter(RetrieveTapeArchiveRequest::gatewayARN)).setter(setter(Builder::gatewayARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayARN").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TAPE_ARN_FIELD,
            GATEWAY_ARN_FIELD));

    private final String tapeARN;

    private final String gatewayARN;

    private RetrieveTapeArchiveRequest(BuilderImpl builder) {
        super(builder);
        this.tapeARN = builder.tapeARN;
        this.gatewayARN = builder.gatewayARN;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the virtual tape you want to retrieve from the virtual tape shelf (VTS).
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the virtual tape you want to retrieve from the virtual tape shelf
     *         (VTS).
     */
    public final String tapeARN() {
        return tapeARN;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the gateway you want to retrieve the virtual tape to. Use the
     * <a>ListGateways</a> operation to return a list of gateways for your account and Region.
     * </p>
     * <p>
     * You retrieve archived virtual tapes to only one gateway and the gateway must be a tape gateway.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the gateway you want to retrieve the virtual tape to. Use the
     *         <a>ListGateways</a> operation to return a list of gateways for your account and Region.</p>
     *         <p>
     *         You retrieve archived virtual tapes to only one gateway and the gateway must be a tape gateway.
     */
    public final String gatewayARN() {
        return gatewayARN;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(tapeARN());
        hashCode = 31 * hashCode + Objects.hashCode(gatewayARN());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RetrieveTapeArchiveRequest)) {
            return false;
        }
        RetrieveTapeArchiveRequest other = (RetrieveTapeArchiveRequest) obj;
        return Objects.equals(tapeARN(), other.tapeARN()) && Objects.equals(gatewayARN(), other.gatewayARN());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RetrieveTapeArchiveRequest").add("TapeARN", tapeARN()).add("GatewayARN", gatewayARN()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TapeARN":
            return Optional.ofNullable(clazz.cast(tapeARN()));
        case "GatewayARN":
            return Optional.ofNullable(clazz.cast(gatewayARN()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RetrieveTapeArchiveRequest, T> g) {
        return obj -> g.apply((RetrieveTapeArchiveRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends StorageGatewayRequest.Builder, SdkPojo, CopyableBuilder<Builder, RetrieveTapeArchiveRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the virtual tape you want to retrieve from the virtual tape shelf (VTS).
         * </p>
         * 
         * @param tapeARN
         *        The Amazon Resource Name (ARN) of the virtual tape you want to retrieve from the virtual tape shelf
         *        (VTS).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tapeARN(String tapeARN);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the gateway you want to retrieve the virtual tape to. Use the
         * <a>ListGateways</a> operation to return a list of gateways for your account and Region.
         * </p>
         * <p>
         * You retrieve archived virtual tapes to only one gateway and the gateway must be a tape gateway.
         * </p>
         * 
         * @param gatewayARN
         *        The Amazon Resource Name (ARN) of the gateway you want to retrieve the virtual tape to. Use the
         *        <a>ListGateways</a> operation to return a list of gateways for your account and Region.</p>
         *        <p>
         *        You retrieve archived virtual tapes to only one gateway and the gateway must be a tape gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayARN(String gatewayARN);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends StorageGatewayRequest.BuilderImpl implements Builder {
        private String tapeARN;

        private String gatewayARN;

        private BuilderImpl() {
        }

        private BuilderImpl(RetrieveTapeArchiveRequest model) {
            super(model);
            tapeARN(model.tapeARN);
            gatewayARN(model.gatewayARN);
        }

        public final String getTapeARN() {
            return tapeARN;
        }

        public final void setTapeARN(String tapeARN) {
            this.tapeARN = tapeARN;
        }

        @Override
        @Transient
        public final Builder tapeARN(String tapeARN) {
            this.tapeARN = tapeARN;
            return this;
        }

        public final String getGatewayARN() {
            return gatewayARN;
        }

        public final void setGatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
        }

        @Override
        @Transient
        public final Builder gatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RetrieveTapeArchiveRequest build() {
            return new RetrieveTapeArchiveRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
