/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.storagegateway.model.CacheAttributes;
import software.amazon.awssdk.services.storagegateway.model.EndpointNetworkConfiguration;
import software.amazon.awssdk.services.storagegateway.model.Tag;
import software.amazon.awssdk.services.storagegateway.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FileSystemAssociationInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FileSystemAssociationInfo> {
    private static final SdkField<String> FILE_SYSTEM_ASSOCIATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FileSystemAssociationARN").getter(FileSystemAssociationInfo.getter(FileSystemAssociationInfo::fileSystemAssociationARN)).setter(FileSystemAssociationInfo.setter(Builder::fileSystemAssociationARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileSystemAssociationARN").build()}).build();
    private static final SdkField<String> LOCATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LocationARN").getter(FileSystemAssociationInfo.getter(FileSystemAssociationInfo::locationARN)).setter(FileSystemAssociationInfo.setter(Builder::locationARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocationARN").build()}).build();
    private static final SdkField<String> FILE_SYSTEM_ASSOCIATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FileSystemAssociationStatus").getter(FileSystemAssociationInfo.getter(FileSystemAssociationInfo::fileSystemAssociationStatus)).setter(FileSystemAssociationInfo.setter(Builder::fileSystemAssociationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileSystemAssociationStatus").build()}).build();
    private static final SdkField<String> AUDIT_DESTINATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AuditDestinationARN").getter(FileSystemAssociationInfo.getter(FileSystemAssociationInfo::auditDestinationARN)).setter(FileSystemAssociationInfo.setter(Builder::auditDestinationARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuditDestinationARN").build()}).build();
    private static final SdkField<String> GATEWAY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GatewayARN").getter(FileSystemAssociationInfo.getter(FileSystemAssociationInfo::gatewayARN)).setter(FileSystemAssociationInfo.setter(Builder::gatewayARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayARN").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(FileSystemAssociationInfo.getter(FileSystemAssociationInfo::tags)).setter(FileSystemAssociationInfo.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<CacheAttributes> CACHE_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CacheAttributes").getter(FileSystemAssociationInfo.getter(FileSystemAssociationInfo::cacheAttributes)).setter(FileSystemAssociationInfo.setter(Builder::cacheAttributes)).constructor(CacheAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheAttributes").build()}).build();
    private static final SdkField<EndpointNetworkConfiguration> ENDPOINT_NETWORK_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EndpointNetworkConfiguration").getter(FileSystemAssociationInfo.getter(FileSystemAssociationInfo::endpointNetworkConfiguration)).setter(FileSystemAssociationInfo.setter(Builder::endpointNetworkConfiguration)).constructor(EndpointNetworkConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointNetworkConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_SYSTEM_ASSOCIATION_ARN_FIELD, LOCATION_ARN_FIELD, FILE_SYSTEM_ASSOCIATION_STATUS_FIELD, AUDIT_DESTINATION_ARN_FIELD, GATEWAY_ARN_FIELD, TAGS_FIELD, CACHE_ATTRIBUTES_FIELD, ENDPOINT_NETWORK_CONFIGURATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String fileSystemAssociationARN;
    private final String locationARN;
    private final String fileSystemAssociationStatus;
    private final String auditDestinationARN;
    private final String gatewayARN;
    private final List<Tag> tags;
    private final CacheAttributes cacheAttributes;
    private final EndpointNetworkConfiguration endpointNetworkConfiguration;

    private FileSystemAssociationInfo(BuilderImpl builder) {
        this.fileSystemAssociationARN = builder.fileSystemAssociationARN;
        this.locationARN = builder.locationARN;
        this.fileSystemAssociationStatus = builder.fileSystemAssociationStatus;
        this.auditDestinationARN = builder.auditDestinationARN;
        this.gatewayARN = builder.gatewayARN;
        this.tags = builder.tags;
        this.cacheAttributes = builder.cacheAttributes;
        this.endpointNetworkConfiguration = builder.endpointNetworkConfiguration;
    }

    public final String fileSystemAssociationARN() {
        return this.fileSystemAssociationARN;
    }

    public final String locationARN() {
        return this.locationARN;
    }

    public final String fileSystemAssociationStatus() {
        return this.fileSystemAssociationStatus;
    }

    public final String auditDestinationARN() {
        return this.auditDestinationARN;
    }

    public final String gatewayARN() {
        return this.gatewayARN;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final CacheAttributes cacheAttributes() {
        return this.cacheAttributes;
    }

    public final EndpointNetworkConfiguration endpointNetworkConfiguration() {
        return this.endpointNetworkConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fileSystemAssociationARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.locationARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileSystemAssociationStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.auditDestinationARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointNetworkConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FileSystemAssociationInfo)) {
            return false;
        }
        FileSystemAssociationInfo other = (FileSystemAssociationInfo)obj;
        return Objects.equals(this.fileSystemAssociationARN(), other.fileSystemAssociationARN()) && Objects.equals(this.locationARN(), other.locationARN()) && Objects.equals(this.fileSystemAssociationStatus(), other.fileSystemAssociationStatus()) && Objects.equals(this.auditDestinationARN(), other.auditDestinationARN()) && Objects.equals(this.gatewayARN(), other.gatewayARN()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.cacheAttributes(), other.cacheAttributes()) && Objects.equals(this.endpointNetworkConfiguration(), other.endpointNetworkConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"FileSystemAssociationInfo").add("FileSystemAssociationARN", (Object)this.fileSystemAssociationARN()).add("LocationARN", (Object)this.locationARN()).add("FileSystemAssociationStatus", (Object)this.fileSystemAssociationStatus()).add("AuditDestinationARN", (Object)this.auditDestinationARN()).add("GatewayARN", (Object)this.gatewayARN()).add("Tags", this.hasTags() ? this.tags() : null).add("CacheAttributes", (Object)this.cacheAttributes()).add("EndpointNetworkConfiguration", (Object)this.endpointNetworkConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FileSystemAssociationARN": {
                return Optional.ofNullable(clazz.cast(this.fileSystemAssociationARN()));
            }
            case "LocationARN": {
                return Optional.ofNullable(clazz.cast(this.locationARN()));
            }
            case "FileSystemAssociationStatus": {
                return Optional.ofNullable(clazz.cast(this.fileSystemAssociationStatus()));
            }
            case "AuditDestinationARN": {
                return Optional.ofNullable(clazz.cast(this.auditDestinationARN()));
            }
            case "GatewayARN": {
                return Optional.ofNullable(clazz.cast(this.gatewayARN()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "CacheAttributes": {
                return Optional.ofNullable(clazz.cast(this.cacheAttributes()));
            }
            case "EndpointNetworkConfiguration": {
                return Optional.ofNullable(clazz.cast(this.endpointNetworkConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FileSystemAssociationInfo, T> g) {
        return obj -> g.apply((FileSystemAssociationInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String fileSystemAssociationARN;
        private String locationARN;
        private String fileSystemAssociationStatus;
        private String auditDestinationARN;
        private String gatewayARN;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private CacheAttributes cacheAttributes;
        private EndpointNetworkConfiguration endpointNetworkConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(FileSystemAssociationInfo model) {
            this.fileSystemAssociationARN(model.fileSystemAssociationARN);
            this.locationARN(model.locationARN);
            this.fileSystemAssociationStatus(model.fileSystemAssociationStatus);
            this.auditDestinationARN(model.auditDestinationARN);
            this.gatewayARN(model.gatewayARN);
            this.tags(model.tags);
            this.cacheAttributes(model.cacheAttributes);
            this.endpointNetworkConfiguration(model.endpointNetworkConfiguration);
        }

        public final String getFileSystemAssociationARN() {
            return this.fileSystemAssociationARN;
        }

        public final void setFileSystemAssociationARN(String fileSystemAssociationARN) {
            this.fileSystemAssociationARN = fileSystemAssociationARN;
        }

        @Override
        @Transient
        public final Builder fileSystemAssociationARN(String fileSystemAssociationARN) {
            this.fileSystemAssociationARN = fileSystemAssociationARN;
            return this;
        }

        public final String getLocationARN() {
            return this.locationARN;
        }

        public final void setLocationARN(String locationARN) {
            this.locationARN = locationARN;
        }

        @Override
        @Transient
        public final Builder locationARN(String locationARN) {
            this.locationARN = locationARN;
            return this;
        }

        public final String getFileSystemAssociationStatus() {
            return this.fileSystemAssociationStatus;
        }

        public final void setFileSystemAssociationStatus(String fileSystemAssociationStatus) {
            this.fileSystemAssociationStatus = fileSystemAssociationStatus;
        }

        @Override
        @Transient
        public final Builder fileSystemAssociationStatus(String fileSystemAssociationStatus) {
            this.fileSystemAssociationStatus = fileSystemAssociationStatus;
            return this;
        }

        public final String getAuditDestinationARN() {
            return this.auditDestinationARN;
        }

        public final void setAuditDestinationARN(String auditDestinationARN) {
            this.auditDestinationARN = auditDestinationARN;
        }

        @Override
        @Transient
        public final Builder auditDestinationARN(String auditDestinationARN) {
            this.auditDestinationARN = auditDestinationARN;
            return this;
        }

        public final String getGatewayARN() {
            return this.gatewayARN;
        }

        public final void setGatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
        }

        @Override
        @Transient
        public final Builder gatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        @Transient
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final CacheAttributes.Builder getCacheAttributes() {
            return this.cacheAttributes != null ? this.cacheAttributes.toBuilder() : null;
        }

        public final void setCacheAttributes(CacheAttributes.BuilderImpl cacheAttributes) {
            this.cacheAttributes = cacheAttributes != null ? cacheAttributes.build() : null;
        }

        @Override
        @Transient
        public final Builder cacheAttributes(CacheAttributes cacheAttributes) {
            this.cacheAttributes = cacheAttributes;
            return this;
        }

        public final EndpointNetworkConfiguration.Builder getEndpointNetworkConfiguration() {
            return this.endpointNetworkConfiguration != null ? this.endpointNetworkConfiguration.toBuilder() : null;
        }

        public final void setEndpointNetworkConfiguration(EndpointNetworkConfiguration.BuilderImpl endpointNetworkConfiguration) {
            this.endpointNetworkConfiguration = endpointNetworkConfiguration != null ? endpointNetworkConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder endpointNetworkConfiguration(EndpointNetworkConfiguration endpointNetworkConfiguration) {
            this.endpointNetworkConfiguration = endpointNetworkConfiguration;
            return this;
        }

        public FileSystemAssociationInfo build() {
            return new FileSystemAssociationInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FileSystemAssociationInfo> {
        public Builder fileSystemAssociationARN(String var1);

        public Builder locationARN(String var1);

        public Builder fileSystemAssociationStatus(String var1);

        public Builder auditDestinationARN(String var1);

        public Builder gatewayARN(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder cacheAttributes(CacheAttributes var1);

        default public Builder cacheAttributes(Consumer<CacheAttributes.Builder> cacheAttributes) {
            return this.cacheAttributes((CacheAttributes)((CacheAttributes.Builder)CacheAttributes.builder().applyMutation(cacheAttributes)).build());
        }

        public Builder endpointNetworkConfiguration(EndpointNetworkConfiguration var1);

        default public Builder endpointNetworkConfiguration(Consumer<EndpointNetworkConfiguration.Builder> endpointNetworkConfiguration) {
            return this.endpointNetworkConfiguration((EndpointNetworkConfiguration)((EndpointNetworkConfiguration.Builder)EndpointNetworkConfiguration.builder().applyMutation(endpointNetworkConfiguration)).build());
        }
    }
}

