/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.storagegateway.model.RetentionLockType;
import software.amazon.awssdk.services.storagegateway.model.StorageGatewayRequest;
import software.amazon.awssdk.services.storagegateway.model.Tag;
import software.amazon.awssdk.services.storagegateway.model.TagsCopier;
import software.amazon.awssdk.services.storagegateway.model.TapeStorageClass;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateTapePoolRequest
extends StorageGatewayRequest
implements ToCopyableBuilder<Builder, CreateTapePoolRequest> {
    private static final SdkField<String> POOL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PoolName").getter(CreateTapePoolRequest.getter(CreateTapePoolRequest::poolName)).setter(CreateTapePoolRequest.setter(Builder::poolName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoolName").build()}).build();
    private static final SdkField<String> STORAGE_CLASS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StorageClass").getter(CreateTapePoolRequest.getter(CreateTapePoolRequest::storageClassAsString)).setter(CreateTapePoolRequest.setter(Builder::storageClass)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageClass").build()}).build();
    private static final SdkField<String> RETENTION_LOCK_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RetentionLockType").getter(CreateTapePoolRequest.getter(CreateTapePoolRequest::retentionLockTypeAsString)).setter(CreateTapePoolRequest.setter(Builder::retentionLockType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetentionLockType").build()}).build();
    private static final SdkField<Integer> RETENTION_LOCK_TIME_IN_DAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("RetentionLockTimeInDays").getter(CreateTapePoolRequest.getter(CreateTapePoolRequest::retentionLockTimeInDays)).setter(CreateTapePoolRequest.setter(Builder::retentionLockTimeInDays)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetentionLockTimeInDays").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateTapePoolRequest.getter(CreateTapePoolRequest::tags)).setter(CreateTapePoolRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POOL_NAME_FIELD, STORAGE_CLASS_FIELD, RETENTION_LOCK_TYPE_FIELD, RETENTION_LOCK_TIME_IN_DAYS_FIELD, TAGS_FIELD));
    private final String poolName;
    private final String storageClass;
    private final String retentionLockType;
    private final Integer retentionLockTimeInDays;
    private final List<Tag> tags;

    private CreateTapePoolRequest(BuilderImpl builder) {
        super(builder);
        this.poolName = builder.poolName;
        this.storageClass = builder.storageClass;
        this.retentionLockType = builder.retentionLockType;
        this.retentionLockTimeInDays = builder.retentionLockTimeInDays;
        this.tags = builder.tags;
    }

    public final String poolName() {
        return this.poolName;
    }

    public final TapeStorageClass storageClass() {
        return TapeStorageClass.fromValue(this.storageClass);
    }

    public final String storageClassAsString() {
        return this.storageClass;
    }

    public final RetentionLockType retentionLockType() {
        return RetentionLockType.fromValue(this.retentionLockType);
    }

    public final String retentionLockTypeAsString() {
        return this.retentionLockType;
    }

    public final Integer retentionLockTimeInDays() {
        return this.retentionLockTimeInDays;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.poolName());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageClassAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.retentionLockTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.retentionLockTimeInDays());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTapePoolRequest)) {
            return false;
        }
        CreateTapePoolRequest other = (CreateTapePoolRequest)((Object)obj);
        return Objects.equals(this.poolName(), other.poolName()) && Objects.equals(this.storageClassAsString(), other.storageClassAsString()) && Objects.equals(this.retentionLockTypeAsString(), other.retentionLockTypeAsString()) && Objects.equals(this.retentionLockTimeInDays(), other.retentionLockTimeInDays()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateTapePoolRequest").add("PoolName", (Object)this.poolName()).add("StorageClass", (Object)this.storageClassAsString()).add("RetentionLockType", (Object)this.retentionLockTypeAsString()).add("RetentionLockTimeInDays", (Object)this.retentionLockTimeInDays()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PoolName": {
                return Optional.ofNullable(clazz.cast(this.poolName()));
            }
            case "StorageClass": {
                return Optional.ofNullable(clazz.cast(this.storageClassAsString()));
            }
            case "RetentionLockType": {
                return Optional.ofNullable(clazz.cast(this.retentionLockTypeAsString()));
            }
            case "RetentionLockTimeInDays": {
                return Optional.ofNullable(clazz.cast(this.retentionLockTimeInDays()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateTapePoolRequest, T> g) {
        return obj -> g.apply((CreateTapePoolRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends StorageGatewayRequest.BuilderImpl
    implements Builder {
        private String poolName;
        private String storageClass;
        private String retentionLockType;
        private Integer retentionLockTimeInDays;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTapePoolRequest model) {
            super(model);
            this.poolName(model.poolName);
            this.storageClass(model.storageClass);
            this.retentionLockType(model.retentionLockType);
            this.retentionLockTimeInDays(model.retentionLockTimeInDays);
            this.tags(model.tags);
        }

        public final String getPoolName() {
            return this.poolName;
        }

        public final void setPoolName(String poolName) {
            this.poolName = poolName;
        }

        @Override
        @Transient
        public final Builder poolName(String poolName) {
            this.poolName = poolName;
            return this;
        }

        public final String getStorageClass() {
            return this.storageClass;
        }

        public final void setStorageClass(String storageClass) {
            this.storageClass = storageClass;
        }

        @Override
        @Transient
        public final Builder storageClass(String storageClass) {
            this.storageClass = storageClass;
            return this;
        }

        @Override
        @Transient
        public final Builder storageClass(TapeStorageClass storageClass) {
            this.storageClass(storageClass == null ? null : storageClass.toString());
            return this;
        }

        public final String getRetentionLockType() {
            return this.retentionLockType;
        }

        public final void setRetentionLockType(String retentionLockType) {
            this.retentionLockType = retentionLockType;
        }

        @Override
        @Transient
        public final Builder retentionLockType(String retentionLockType) {
            this.retentionLockType = retentionLockType;
            return this;
        }

        @Override
        @Transient
        public final Builder retentionLockType(RetentionLockType retentionLockType) {
            this.retentionLockType(retentionLockType == null ? null : retentionLockType.toString());
            return this;
        }

        public final Integer getRetentionLockTimeInDays() {
            return this.retentionLockTimeInDays;
        }

        public final void setRetentionLockTimeInDays(Integer retentionLockTimeInDays) {
            this.retentionLockTimeInDays = retentionLockTimeInDays;
        }

        @Override
        @Transient
        public final Builder retentionLockTimeInDays(Integer retentionLockTimeInDays) {
            this.retentionLockTimeInDays = retentionLockTimeInDays;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        @Transient
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateTapePoolRequest build() {
            return new CreateTapePoolRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends StorageGatewayRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateTapePoolRequest> {
        public Builder poolName(String var1);

        public Builder storageClass(String var1);

        public Builder storageClass(TapeStorageClass var1);

        public Builder retentionLockType(String var1);

        public Builder retentionLockType(RetentionLockType var1);

        public Builder retentionLockTimeInDays(Integer var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

