/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.util.VersionInfo;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.storagegateway.model.ActivateGatewayRequest;
import software.amazon.awssdk.services.storagegateway.model.ActivateGatewayResponse;
import software.amazon.awssdk.services.storagegateway.model.AddCacheRequest;
import software.amazon.awssdk.services.storagegateway.model.AddCacheResponse;
import software.amazon.awssdk.services.storagegateway.model.AddTagsToResourceRequest;
import software.amazon.awssdk.services.storagegateway.model.AddTagsToResourceResponse;
import software.amazon.awssdk.services.storagegateway.model.AddUploadBufferRequest;
import software.amazon.awssdk.services.storagegateway.model.AddUploadBufferResponse;
import software.amazon.awssdk.services.storagegateway.model.AddWorkingStorageRequest;
import software.amazon.awssdk.services.storagegateway.model.AddWorkingStorageResponse;
import software.amazon.awssdk.services.storagegateway.model.AssignTapePoolRequest;
import software.amazon.awssdk.services.storagegateway.model.AssignTapePoolResponse;
import software.amazon.awssdk.services.storagegateway.model.AssociateFileSystemRequest;
import software.amazon.awssdk.services.storagegateway.model.AssociateFileSystemResponse;
import software.amazon.awssdk.services.storagegateway.model.AttachVolumeRequest;
import software.amazon.awssdk.services.storagegateway.model.AttachVolumeResponse;
import software.amazon.awssdk.services.storagegateway.model.CancelArchivalRequest;
import software.amazon.awssdk.services.storagegateway.model.CancelArchivalResponse;
import software.amazon.awssdk.services.storagegateway.model.CancelRetrievalRequest;
import software.amazon.awssdk.services.storagegateway.model.CancelRetrievalResponse;
import software.amazon.awssdk.services.storagegateway.model.CreateCachediScsiVolumeRequest;
import software.amazon.awssdk.services.storagegateway.model.CreateCachediScsiVolumeResponse;
import software.amazon.awssdk.services.storagegateway.model.CreateNfsFileShareRequest;
import software.amazon.awssdk.services.storagegateway.model.CreateNfsFileShareResponse;
import software.amazon.awssdk.services.storagegateway.model.CreateSmbFileShareRequest;
import software.amazon.awssdk.services.storagegateway.model.CreateSmbFileShareResponse;
import software.amazon.awssdk.services.storagegateway.model.CreateSnapshotFromVolumeRecoveryPointRequest;
import software.amazon.awssdk.services.storagegateway.model.CreateSnapshotFromVolumeRecoveryPointResponse;
import software.amazon.awssdk.services.storagegateway.model.CreateSnapshotRequest;
import software.amazon.awssdk.services.storagegateway.model.CreateSnapshotResponse;
import software.amazon.awssdk.services.storagegateway.model.CreateStorediScsiVolumeRequest;
import software.amazon.awssdk.services.storagegateway.model.CreateStorediScsiVolumeResponse;
import software.amazon.awssdk.services.storagegateway.model.CreateTapePoolRequest;
import software.amazon.awssdk.services.storagegateway.model.CreateTapePoolResponse;
import software.amazon.awssdk.services.storagegateway.model.CreateTapeWithBarcodeRequest;
import software.amazon.awssdk.services.storagegateway.model.CreateTapeWithBarcodeResponse;
import software.amazon.awssdk.services.storagegateway.model.CreateTapesRequest;
import software.amazon.awssdk.services.storagegateway.model.CreateTapesResponse;
import software.amazon.awssdk.services.storagegateway.model.DeleteAutomaticTapeCreationPolicyRequest;
import software.amazon.awssdk.services.storagegateway.model.DeleteAutomaticTapeCreationPolicyResponse;
import software.amazon.awssdk.services.storagegateway.model.DeleteBandwidthRateLimitRequest;
import software.amazon.awssdk.services.storagegateway.model.DeleteBandwidthRateLimitResponse;
import software.amazon.awssdk.services.storagegateway.model.DeleteChapCredentialsRequest;
import software.amazon.awssdk.services.storagegateway.model.DeleteChapCredentialsResponse;
import software.amazon.awssdk.services.storagegateway.model.DeleteFileShareRequest;
import software.amazon.awssdk.services.storagegateway.model.DeleteFileShareResponse;
import software.amazon.awssdk.services.storagegateway.model.DeleteGatewayRequest;
import software.amazon.awssdk.services.storagegateway.model.DeleteGatewayResponse;
import software.amazon.awssdk.services.storagegateway.model.DeleteSnapshotScheduleRequest;
import software.amazon.awssdk.services.storagegateway.model.DeleteSnapshotScheduleResponse;
import software.amazon.awssdk.services.storagegateway.model.DeleteTapeArchiveRequest;
import software.amazon.awssdk.services.storagegateway.model.DeleteTapeArchiveResponse;
import software.amazon.awssdk.services.storagegateway.model.DeleteTapePoolRequest;
import software.amazon.awssdk.services.storagegateway.model.DeleteTapePoolResponse;
import software.amazon.awssdk.services.storagegateway.model.DeleteTapeRequest;
import software.amazon.awssdk.services.storagegateway.model.DeleteTapeResponse;
import software.amazon.awssdk.services.storagegateway.model.DeleteVolumeRequest;
import software.amazon.awssdk.services.storagegateway.model.DeleteVolumeResponse;
import software.amazon.awssdk.services.storagegateway.model.DescribeAvailabilityMonitorTestRequest;
import software.amazon.awssdk.services.storagegateway.model.DescribeAvailabilityMonitorTestResponse;
import software.amazon.awssdk.services.storagegateway.model.DescribeBandwidthRateLimitRequest;
import software.amazon.awssdk.services.storagegateway.model.DescribeBandwidthRateLimitResponse;
import software.amazon.awssdk.services.storagegateway.model.DescribeBandwidthRateLimitScheduleRequest;
import software.amazon.awssdk.services.storagegateway.model.DescribeBandwidthRateLimitScheduleResponse;
import software.amazon.awssdk.services.storagegateway.model.DescribeCacheRequest;
import software.amazon.awssdk.services.storagegateway.model.DescribeCacheResponse;
import software.amazon.awssdk.services.storagegateway.model.DescribeCachediScsiVolumesRequest;
import software.amazon.awssdk.services.storagegateway.model.DescribeCachediScsiVolumesResponse;
import software.amazon.awssdk.services.storagegateway.model.DescribeChapCredentialsRequest;
import software.amazon.awssdk.services.storagegateway.model.DescribeChapCredentialsResponse;
import software.amazon.awssdk.services.storagegateway.model.DescribeFileSystemAssociationsRequest;
import software.amazon.awssdk.services.storagegateway.model.DescribeFileSystemAssociationsResponse;
import software.amazon.awssdk.services.storagegateway.model.DescribeGatewayInformationRequest;
import software.amazon.awssdk.services.storagegateway.model.DescribeGatewayInformationResponse;
import software.amazon.awssdk.services.storagegateway.model.DescribeMaintenanceStartTimeRequest;
import software.amazon.awssdk.services.storagegateway.model.DescribeMaintenanceStartTimeResponse;
import software.amazon.awssdk.services.storagegateway.model.DescribeNfsFileSharesRequest;
import software.amazon.awssdk.services.storagegateway.model.DescribeNfsFileSharesResponse;
import software.amazon.awssdk.services.storagegateway.model.DescribeSmbFileSharesRequest;
import software.amazon.awssdk.services.storagegateway.model.DescribeSmbFileSharesResponse;
import software.amazon.awssdk.services.storagegateway.model.DescribeSmbSettingsRequest;
import software.amazon.awssdk.services.storagegateway.model.DescribeSmbSettingsResponse;
import software.amazon.awssdk.services.storagegateway.model.DescribeSnapshotScheduleRequest;
import software.amazon.awssdk.services.storagegateway.model.DescribeSnapshotScheduleResponse;
import software.amazon.awssdk.services.storagegateway.model.DescribeStorediScsiVolumesRequest;
import software.amazon.awssdk.services.storagegateway.model.DescribeStorediScsiVolumesResponse;
import software.amazon.awssdk.services.storagegateway.model.DescribeTapeArchivesRequest;
import software.amazon.awssdk.services.storagegateway.model.DescribeTapeArchivesResponse;
import software.amazon.awssdk.services.storagegateway.model.DescribeTapeRecoveryPointsRequest;
import software.amazon.awssdk.services.storagegateway.model.DescribeTapeRecoveryPointsResponse;
import software.amazon.awssdk.services.storagegateway.model.DescribeTapesRequest;
import software.amazon.awssdk.services.storagegateway.model.DescribeTapesResponse;
import software.amazon.awssdk.services.storagegateway.model.DescribeUploadBufferRequest;
import software.amazon.awssdk.services.storagegateway.model.DescribeUploadBufferResponse;
import software.amazon.awssdk.services.storagegateway.model.DescribeVtlDevicesRequest;
import software.amazon.awssdk.services.storagegateway.model.DescribeVtlDevicesResponse;
import software.amazon.awssdk.services.storagegateway.model.DescribeWorkingStorageRequest;
import software.amazon.awssdk.services.storagegateway.model.DescribeWorkingStorageResponse;
import software.amazon.awssdk.services.storagegateway.model.DetachVolumeRequest;
import software.amazon.awssdk.services.storagegateway.model.DetachVolumeResponse;
import software.amazon.awssdk.services.storagegateway.model.DisableGatewayRequest;
import software.amazon.awssdk.services.storagegateway.model.DisableGatewayResponse;
import software.amazon.awssdk.services.storagegateway.model.DisassociateFileSystemRequest;
import software.amazon.awssdk.services.storagegateway.model.DisassociateFileSystemResponse;
import software.amazon.awssdk.services.storagegateway.model.InternalServerErrorException;
import software.amazon.awssdk.services.storagegateway.model.InvalidGatewayRequestException;
import software.amazon.awssdk.services.storagegateway.model.JoinDomainRequest;
import software.amazon.awssdk.services.storagegateway.model.JoinDomainResponse;
import software.amazon.awssdk.services.storagegateway.model.ListAutomaticTapeCreationPoliciesRequest;
import software.amazon.awssdk.services.storagegateway.model.ListAutomaticTapeCreationPoliciesResponse;
import software.amazon.awssdk.services.storagegateway.model.ListFileSharesRequest;
import software.amazon.awssdk.services.storagegateway.model.ListFileSharesResponse;
import software.amazon.awssdk.services.storagegateway.model.ListFileSystemAssociationsRequest;
import software.amazon.awssdk.services.storagegateway.model.ListFileSystemAssociationsResponse;
import software.amazon.awssdk.services.storagegateway.model.ListGatewaysRequest;
import software.amazon.awssdk.services.storagegateway.model.ListGatewaysResponse;
import software.amazon.awssdk.services.storagegateway.model.ListLocalDisksRequest;
import software.amazon.awssdk.services.storagegateway.model.ListLocalDisksResponse;
import software.amazon.awssdk.services.storagegateway.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.storagegateway.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.storagegateway.model.ListTapePoolsRequest;
import software.amazon.awssdk.services.storagegateway.model.ListTapePoolsResponse;
import software.amazon.awssdk.services.storagegateway.model.ListTapesRequest;
import software.amazon.awssdk.services.storagegateway.model.ListTapesResponse;
import software.amazon.awssdk.services.storagegateway.model.ListVolumeInitiatorsRequest;
import software.amazon.awssdk.services.storagegateway.model.ListVolumeInitiatorsResponse;
import software.amazon.awssdk.services.storagegateway.model.ListVolumeRecoveryPointsRequest;
import software.amazon.awssdk.services.storagegateway.model.ListVolumeRecoveryPointsResponse;
import software.amazon.awssdk.services.storagegateway.model.ListVolumesRequest;
import software.amazon.awssdk.services.storagegateway.model.ListVolumesResponse;
import software.amazon.awssdk.services.storagegateway.model.NotifyWhenUploadedRequest;
import software.amazon.awssdk.services.storagegateway.model.NotifyWhenUploadedResponse;
import software.amazon.awssdk.services.storagegateway.model.RefreshCacheRequest;
import software.amazon.awssdk.services.storagegateway.model.RefreshCacheResponse;
import software.amazon.awssdk.services.storagegateway.model.RemoveTagsFromResourceRequest;
import software.amazon.awssdk.services.storagegateway.model.RemoveTagsFromResourceResponse;
import software.amazon.awssdk.services.storagegateway.model.ResetCacheRequest;
import software.amazon.awssdk.services.storagegateway.model.ResetCacheResponse;
import software.amazon.awssdk.services.storagegateway.model.RetrieveTapeArchiveRequest;
import software.amazon.awssdk.services.storagegateway.model.RetrieveTapeArchiveResponse;
import software.amazon.awssdk.services.storagegateway.model.RetrieveTapeRecoveryPointRequest;
import software.amazon.awssdk.services.storagegateway.model.RetrieveTapeRecoveryPointResponse;
import software.amazon.awssdk.services.storagegateway.model.ServiceUnavailableErrorException;
import software.amazon.awssdk.services.storagegateway.model.SetLocalConsolePasswordRequest;
import software.amazon.awssdk.services.storagegateway.model.SetLocalConsolePasswordResponse;
import software.amazon.awssdk.services.storagegateway.model.SetSmbGuestPasswordRequest;
import software.amazon.awssdk.services.storagegateway.model.SetSmbGuestPasswordResponse;
import software.amazon.awssdk.services.storagegateway.model.ShutdownGatewayRequest;
import software.amazon.awssdk.services.storagegateway.model.ShutdownGatewayResponse;
import software.amazon.awssdk.services.storagegateway.model.StartAvailabilityMonitorTestRequest;
import software.amazon.awssdk.services.storagegateway.model.StartAvailabilityMonitorTestResponse;
import software.amazon.awssdk.services.storagegateway.model.StartGatewayRequest;
import software.amazon.awssdk.services.storagegateway.model.StartGatewayResponse;
import software.amazon.awssdk.services.storagegateway.model.StorageGatewayException;
import software.amazon.awssdk.services.storagegateway.model.StorageGatewayRequest;
import software.amazon.awssdk.services.storagegateway.model.UpdateAutomaticTapeCreationPolicyRequest;
import software.amazon.awssdk.services.storagegateway.model.UpdateAutomaticTapeCreationPolicyResponse;
import software.amazon.awssdk.services.storagegateway.model.UpdateBandwidthRateLimitRequest;
import software.amazon.awssdk.services.storagegateway.model.UpdateBandwidthRateLimitResponse;
import software.amazon.awssdk.services.storagegateway.model.UpdateBandwidthRateLimitScheduleRequest;
import software.amazon.awssdk.services.storagegateway.model.UpdateBandwidthRateLimitScheduleResponse;
import software.amazon.awssdk.services.storagegateway.model.UpdateChapCredentialsRequest;
import software.amazon.awssdk.services.storagegateway.model.UpdateChapCredentialsResponse;
import software.amazon.awssdk.services.storagegateway.model.UpdateFileSystemAssociationRequest;
import software.amazon.awssdk.services.storagegateway.model.UpdateFileSystemAssociationResponse;
import software.amazon.awssdk.services.storagegateway.model.UpdateGatewayInformationRequest;
import software.amazon.awssdk.services.storagegateway.model.UpdateGatewayInformationResponse;
import software.amazon.awssdk.services.storagegateway.model.UpdateGatewaySoftwareNowRequest;
import software.amazon.awssdk.services.storagegateway.model.UpdateGatewaySoftwareNowResponse;
import software.amazon.awssdk.services.storagegateway.model.UpdateMaintenanceStartTimeRequest;
import software.amazon.awssdk.services.storagegateway.model.UpdateMaintenanceStartTimeResponse;
import software.amazon.awssdk.services.storagegateway.model.UpdateNfsFileShareRequest;
import software.amazon.awssdk.services.storagegateway.model.UpdateNfsFileShareResponse;
import software.amazon.awssdk.services.storagegateway.model.UpdateSmbFileShareRequest;
import software.amazon.awssdk.services.storagegateway.model.UpdateSmbFileShareResponse;
import software.amazon.awssdk.services.storagegateway.model.UpdateSmbFileShareVisibilityRequest;
import software.amazon.awssdk.services.storagegateway.model.UpdateSmbFileShareVisibilityResponse;
import software.amazon.awssdk.services.storagegateway.model.UpdateSmbLocalGroupsRequest;
import software.amazon.awssdk.services.storagegateway.model.UpdateSmbLocalGroupsResponse;
import software.amazon.awssdk.services.storagegateway.model.UpdateSmbSecurityStrategyRequest;
import software.amazon.awssdk.services.storagegateway.model.UpdateSmbSecurityStrategyResponse;
import software.amazon.awssdk.services.storagegateway.model.UpdateSnapshotScheduleRequest;
import software.amazon.awssdk.services.storagegateway.model.UpdateSnapshotScheduleResponse;
import software.amazon.awssdk.services.storagegateway.model.UpdateVtlDeviceTypeRequest;
import software.amazon.awssdk.services.storagegateway.model.UpdateVtlDeviceTypeResponse;
import software.amazon.awssdk.services.storagegateway.paginators.DescribeTapeArchivesPublisher;
import software.amazon.awssdk.services.storagegateway.paginators.DescribeTapeRecoveryPointsPublisher;
import software.amazon.awssdk.services.storagegateway.paginators.DescribeTapesPublisher;
import software.amazon.awssdk.services.storagegateway.paginators.DescribeVTLDevicesPublisher;
import software.amazon.awssdk.services.storagegateway.paginators.ListFileSharesPublisher;
import software.amazon.awssdk.services.storagegateway.paginators.ListFileSystemAssociationsPublisher;
import software.amazon.awssdk.services.storagegateway.paginators.ListGatewaysPublisher;
import software.amazon.awssdk.services.storagegateway.paginators.ListTagsForResourcePublisher;
import software.amazon.awssdk.services.storagegateway.paginators.ListTapePoolsPublisher;
import software.amazon.awssdk.services.storagegateway.paginators.ListTapesPublisher;
import software.amazon.awssdk.services.storagegateway.paginators.ListVolumesPublisher;
import software.amazon.awssdk.services.storagegateway.transform.ActivateGatewayRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.AddCacheRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.AddTagsToResourceRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.AddUploadBufferRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.AddWorkingStorageRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.AssignTapePoolRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.AssociateFileSystemRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.AttachVolumeRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.CancelArchivalRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.CancelRetrievalRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.CreateCachediScsiVolumeRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.CreateNfsFileShareRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.CreateSmbFileShareRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.CreateSnapshotFromVolumeRecoveryPointRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.CreateSnapshotRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.CreateStorediScsiVolumeRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.CreateTapePoolRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.CreateTapeWithBarcodeRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.CreateTapesRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.DeleteAutomaticTapeCreationPolicyRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.DeleteBandwidthRateLimitRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.DeleteChapCredentialsRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.DeleteFileShareRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.DeleteGatewayRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.DeleteSnapshotScheduleRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.DeleteTapeArchiveRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.DeleteTapePoolRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.DeleteTapeRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.DeleteVolumeRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.DescribeAvailabilityMonitorTestRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.DescribeBandwidthRateLimitRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.DescribeBandwidthRateLimitScheduleRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.DescribeCacheRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.DescribeCachediScsiVolumesRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.DescribeChapCredentialsRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.DescribeFileSystemAssociationsRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.DescribeGatewayInformationRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.DescribeMaintenanceStartTimeRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.DescribeNfsFileSharesRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.DescribeSmbFileSharesRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.DescribeSmbSettingsRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.DescribeSnapshotScheduleRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.DescribeStorediScsiVolumesRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.DescribeTapeArchivesRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.DescribeTapeRecoveryPointsRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.DescribeTapesRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.DescribeUploadBufferRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.DescribeVtlDevicesRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.DescribeWorkingStorageRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.DetachVolumeRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.DisableGatewayRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.DisassociateFileSystemRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.JoinDomainRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.ListAutomaticTapeCreationPoliciesRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.ListFileSharesRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.ListFileSystemAssociationsRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.ListGatewaysRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.ListLocalDisksRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.ListTapePoolsRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.ListTapesRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.ListVolumeInitiatorsRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.ListVolumeRecoveryPointsRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.ListVolumesRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.NotifyWhenUploadedRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.RefreshCacheRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.RemoveTagsFromResourceRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.ResetCacheRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.RetrieveTapeArchiveRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.RetrieveTapeRecoveryPointRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.SetLocalConsolePasswordRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.SetSmbGuestPasswordRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.ShutdownGatewayRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.StartAvailabilityMonitorTestRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.StartGatewayRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.UpdateAutomaticTapeCreationPolicyRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.UpdateBandwidthRateLimitRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.UpdateBandwidthRateLimitScheduleRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.UpdateChapCredentialsRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.UpdateFileSystemAssociationRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.UpdateGatewayInformationRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.UpdateGatewaySoftwareNowRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.UpdateMaintenanceStartTimeRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.UpdateNfsFileShareRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.UpdateSmbFileShareRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.UpdateSmbFileShareVisibilityRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.UpdateSmbLocalGroupsRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.UpdateSmbSecurityStrategyRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.UpdateSnapshotScheduleRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.UpdateVtlDeviceTypeRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

/**
 * Internal implementation of {@link StorageGatewayAsyncClient}.
 *
 * @see StorageGatewayAsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultStorageGatewayAsyncClient implements StorageGatewayAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultStorageGatewayAsyncClient.class);

    private final AsyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultStorageGatewayAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    /**
     * <p>
     * Activates the gateway you previously deployed on your host. In the activation process, you specify information
     * such as the Amazon Web Services Region that you want to use for storing snapshots or tapes, the time zone for
     * scheduled snapshots the gateway snapshot schedule window, an activation key, and a name for your gateway. The
     * activation process also associates your gateway with your account. For more information, see
     * <a>UpdateGatewayInformation</a>.
     * </p>
     * <note>
     * <p>
     * You must turn on the gateway VM before you can activate your gateway.
     * </p>
     * </note>
     *
     * @param activateGatewayRequest
     *        A JSON object containing one or more of the following fields:</p>
     *        <ul>
     *        <li>
     *        <p>
     *        <a>ActivateGatewayInput&#36ActivationKey</a>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <a>ActivateGatewayInput&#36GatewayName</a>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <a>ActivateGatewayInput&#36GatewayRegion</a>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <a>ActivateGatewayInput&#36GatewayTimezone</a>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <a>ActivateGatewayInput&#36GatewayType</a>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <a>ActivateGatewayInput&#36MediumChangerType</a>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <a>ActivateGatewayInput&#36TapeDriveType</a>
     *        </p>
     *        </li>
     * @return A Java Future containing the result of the ActivateGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidGatewayRequestException An exception occurred because an invalid gateway request was issued to
     *         the service. For more information, see the error and message fields.</li>
     *         <li>InternalServerErrorException An internal server error has occurred during the request. For more
     *         information, see the error and message fields.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>StorageGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample StorageGatewayAsyncClient.ActivateGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ActivateGateway"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ActivateGatewayResponse> activateGateway(ActivateGatewayRequest activateGatewayRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, activateGatewayRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ActivateGateway");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ActivateGatewayResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ActivateGatewayResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ActivateGatewayResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ActivateGatewayRequest, ActivateGatewayResponse>()
                            .withOperationName("ActivateGateway")
                            .withMarshaller(new ActivateGatewayRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(activateGatewayRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = activateGatewayRequest.overrideConfiguration().orElse(null);
            CompletableFuture<ActivateGatewayResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Configures one or more gateway local disks as cache for a gateway. This operation is only supported in the cached
     * volume, tape, and file gateway type (see <a
     * href="https://docs.aws.amazon.com/storagegateway/latest/userguide/StorageGatewayConcepts.html">How Storage
     * Gateway works (architecture)</a>.
     * </p>
     * <p>
     * In the request, you specify the gateway Amazon Resource Name (ARN) to which you want to add cache, and one or
     * more disk IDs that you want to configure as cache.
     * </p>
     *
     * @param addCacheRequest
     * @return A Java Future containing the result of the AddCache operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidGatewayRequestException An exception occurred because an invalid gateway request was issued to
     *         the service. For more information, see the error and message fields.</li>
     *         <li>InternalServerErrorException An internal server error has occurred during the request. For more
     *         information, see the error and message fields.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>StorageGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample StorageGatewayAsyncClient.AddCache
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/AddCache" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<AddCacheResponse> addCache(AddCacheRequest addCacheRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, addCacheRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AddCache");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AddCacheResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    AddCacheResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AddCacheResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AddCacheRequest, AddCacheResponse>().withOperationName("AddCache")
                            .withMarshaller(new AddCacheRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(addCacheRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = addCacheRequest.overrideConfiguration().orElse(null);
            CompletableFuture<AddCacheResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds one or more tags to the specified resource. You use tags to add metadata to resources, which you can use to
     * categorize these resources. For example, you can categorize resources by purpose, owner, environment, or team.
     * Each tag consists of a key and a value, which you define. You can add tags to the following Storage Gateway
     * resources:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Storage gateways of all types
     * </p>
     * </li>
     * <li>
     * <p>
     * Storage volumes
     * </p>
     * </li>
     * <li>
     * <p>
     * Virtual tapes
     * </p>
     * </li>
     * <li>
     * <p>
     * NFS and SMB file shares
     * </p>
     * </li>
     * <li>
     * <p>
     * File System associations
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can create a maximum of 50 tags for each resource. Virtual tapes and storage volumes that are recovered to a
     * new gateway maintain their tags.
     * </p>
     *
     * @param addTagsToResourceRequest
     *        AddTagsToResourceInput
     * @return A Java Future containing the result of the AddTagsToResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidGatewayRequestException An exception occurred because an invalid gateway request was issued to
     *         the service. For more information, see the error and message fields.</li>
     *         <li>InternalServerErrorException An internal server error has occurred during the request. For more
     *         information, see the error and message fields.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>StorageGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample StorageGatewayAsyncClient.AddTagsToResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/AddTagsToResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AddTagsToResourceResponse> addTagsToResource(AddTagsToResourceRequest addTagsToResourceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, addTagsToResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AddTagsToResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AddTagsToResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AddTagsToResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AddTagsToResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AddTagsToResourceRequest, AddTagsToResourceResponse>()
                            .withOperationName("AddTagsToResource")
                            .withMarshaller(new AddTagsToResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(addTagsToResourceRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = addTagsToResourceRequest.overrideConfiguration().orElse(null);
            CompletableFuture<AddTagsToResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Configures one or more gateway local disks as upload buffer for a specified gateway. This operation is supported
     * for the stored volume, cached volume, and tape gateway types.
     * </p>
     * <p>
     * In the request, you specify the gateway Amazon Resource Name (ARN) to which you want to add upload buffer, and
     * one or more disk IDs that you want to configure as upload buffer.
     * </p>
     *
     * @param addUploadBufferRequest
     * @return A Java Future containing the result of the AddUploadBuffer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidGatewayRequestException An exception occurred because an invalid gateway request was issued to
     *         the service. For more information, see the error and message fields.</li>
     *         <li>InternalServerErrorException An internal server error has occurred during the request. For more
     *         information, see the error and message fields.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>StorageGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample StorageGatewayAsyncClient.AddUploadBuffer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/AddUploadBuffer"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AddUploadBufferResponse> addUploadBuffer(AddUploadBufferRequest addUploadBufferRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, addUploadBufferRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AddUploadBuffer");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AddUploadBufferResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AddUploadBufferResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AddUploadBufferResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AddUploadBufferRequest, AddUploadBufferResponse>()
                            .withOperationName("AddUploadBuffer")
                            .withMarshaller(new AddUploadBufferRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(addUploadBufferRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = addUploadBufferRequest.overrideConfiguration().orElse(null);
            CompletableFuture<AddUploadBufferResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Configures one or more gateway local disks as working storage for a gateway. This operation is only supported in
     * the stored volume gateway type. This operation is deprecated in cached volume API version 20120630. Use
     * <a>AddUploadBuffer</a> instead.
     * </p>
     * <note>
     * <p>
     * Working storage is also referred to as upload buffer. You can also use the <a>AddUploadBuffer</a> operation to
     * add upload buffer to a stored volume gateway.
     * </p>
     * </note>
     * <p>
     * In the request, you specify the gateway Amazon Resource Name (ARN) to which you want to add working storage, and
     * one or more disk IDs that you want to configure as working storage.
     * </p>
     *
     * @param addWorkingStorageRequest
     *        A JSON object containing one or more of the following fields:</p>
     *        <ul>
     *        <li>
     *        <p>
     *        <a>AddWorkingStorageInput&#36DiskIds</a>
     *        </p>
     *        </li>
     * @return A Java Future containing the result of the AddWorkingStorage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidGatewayRequestException An exception occurred because an invalid gateway request was issued to
     *         the service. For more information, see the error and message fields.</li>
     *         <li>InternalServerErrorException An internal server error has occurred during the request. For more
     *         information, see the error and message fields.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>StorageGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample StorageGatewayAsyncClient.AddWorkingStorage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/AddWorkingStorage"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AddWorkingStorageResponse> addWorkingStorage(AddWorkingStorageRequest addWorkingStorageRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, addWorkingStorageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AddWorkingStorage");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AddWorkingStorageResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AddWorkingStorageResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AddWorkingStorageResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AddWorkingStorageRequest, AddWorkingStorageResponse>()
                            .withOperationName("AddWorkingStorage")
                            .withMarshaller(new AddWorkingStorageRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(addWorkingStorageRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = addWorkingStorageRequest.overrideConfiguration().orElse(null);
            CompletableFuture<AddWorkingStorageResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Assigns a tape to a tape pool for archiving. The tape assigned to a pool is archived in the S3 storage class that
     * is associated with the pool. When you use your backup application to eject the tape, the tape is archived
     * directly into the S3 storage class (S3 Glacier or S3 Glacier Deep Archive) that corresponds to the pool.
     * </p>
     * <p>
     * Valid Values: <code>GLACIER</code> | <code>DEEP_ARCHIVE</code>
     * </p>
     *
     * @param assignTapePoolRequest
     * @return A Java Future containing the result of the AssignTapePool operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidGatewayRequestException An exception occurred because an invalid gateway request was issued to
     *         the service. For more information, see the error and message fields.</li>
     *         <li>InternalServerErrorException An internal server error has occurred during the request. For more
     *         information, see the error and message fields.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>StorageGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample StorageGatewayAsyncClient.AssignTapePool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/AssignTapePool" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<AssignTapePoolResponse> assignTapePool(AssignTapePoolRequest assignTapePoolRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, assignTapePoolRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssignTapePool");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AssignTapePoolResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AssignTapePoolResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AssignTapePoolResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AssignTapePoolRequest, AssignTapePoolResponse>()
                            .withOperationName("AssignTapePool")
                            .withMarshaller(new AssignTapePoolRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(assignTapePoolRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = assignTapePoolRequest.overrideConfiguration().orElse(null);
            CompletableFuture<AssignTapePoolResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Associate an Amazon FSx file system with the FSx File Gateway. After the association process is complete, the
     * file shares on the Amazon FSx file system are available for access through the gateway. This operation only
     * supports the FSx File Gateway type.
     * </p>
     *
     * @param associateFileSystemRequest
     * @return A Java Future containing the result of the AssociateFileSystem operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidGatewayRequestException An exception occurred because an invalid gateway request was issued to
     *         the service. For more information, see the error and message fields.</li>
     *         <li>InternalServerErrorException An internal server error has occurred during the request. For more
     *         information, see the error and message fields.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>StorageGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample StorageGatewayAsyncClient.AssociateFileSystem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/AssociateFileSystem"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AssociateFileSystemResponse> associateFileSystem(
            AssociateFileSystemRequest associateFileSystemRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateFileSystemRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateFileSystem");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AssociateFileSystemResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AssociateFileSystemResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AssociateFileSystemResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AssociateFileSystemRequest, AssociateFileSystemResponse>()
                            .withOperationName("AssociateFileSystem")
                            .withMarshaller(new AssociateFileSystemRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(associateFileSystemRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = associateFileSystemRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<AssociateFileSystemResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Connects a volume to an iSCSI connection and then attaches the volume to the specified gateway. Detaching and
     * attaching a volume enables you to recover your data from one gateway to a different gateway without creating a
     * snapshot. It also makes it easier to move your volumes from an on-premises gateway to a gateway hosted on an
     * Amazon EC2 instance.
     * </p>
     *
     * @param attachVolumeRequest
     *        AttachVolumeInput
     * @return A Java Future containing the result of the AttachVolume operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidGatewayRequestException An exception occurred because an invalid gateway request was issued to
     *         the service. For more information, see the error and message fields.</li>
     *         <li>InternalServerErrorException An internal server error has occurred during the request. For more
     *         information, see the error and message fields.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>StorageGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample StorageGatewayAsyncClient.AttachVolume
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/AttachVolume" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<AttachVolumeResponse> attachVolume(AttachVolumeRequest attachVolumeRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, attachVolumeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AttachVolume");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AttachVolumeResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    AttachVolumeResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AttachVolumeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AttachVolumeRequest, AttachVolumeResponse>()
                            .withOperationName("AttachVolume").withMarshaller(new AttachVolumeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(attachVolumeRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = attachVolumeRequest.overrideConfiguration().orElse(null);
            CompletableFuture<AttachVolumeResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Cancels archiving of a virtual tape to the virtual tape shelf (VTS) after the archiving process is initiated.
     * This operation is only supported in the tape gateway type.
     * </p>
     *
     * @param cancelArchivalRequest
     *        CancelArchivalInput
     * @return A Java Future containing the result of the CancelArchival operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidGatewayRequestException An exception occurred because an invalid gateway request was issued to
     *         the service. For more information, see the error and message fields.</li>
     *         <li>InternalServerErrorException An internal server error has occurred during the request. For more
     *         information, see the error and message fields.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>StorageGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample StorageGatewayAsyncClient.CancelArchival
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/CancelArchival" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CancelArchivalResponse> cancelArchival(CancelArchivalRequest cancelArchivalRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, cancelArchivalRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelArchival");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CancelArchivalResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CancelArchivalResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CancelArchivalResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CancelArchivalRequest, CancelArchivalResponse>()
                            .withOperationName("CancelArchival")
                            .withMarshaller(new CancelArchivalRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(cancelArchivalRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = cancelArchivalRequest.overrideConfiguration().orElse(null);
            CompletableFuture<CancelArchivalResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Cancels retrieval of a virtual tape from the virtual tape shelf (VTS) to a gateway after the retrieval process is
     * initiated. The virtual tape is returned to the VTS. This operation is only supported in the tape gateway type.
     * </p>
     *
     * @param cancelRetrievalRequest
     *        CancelRetrievalInput
     * @return A Java Future containing the result of the CancelRetrieval operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidGatewayRequestException An exception occurred because an invalid gateway request was issued to
     *         the service. For more information, see the error and message fields.</li>
     *         <li>InternalServerErrorException An internal server error has occurred during the request. For more
     *         information, see the error and message fields.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>StorageGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample StorageGatewayAsyncClient.CancelRetrieval
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/CancelRetrieval"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CancelRetrievalResponse> cancelRetrieval(CancelRetrievalRequest cancelRetrievalRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, cancelRetrievalRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelRetrieval");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CancelRetrievalResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CancelRetrievalResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CancelRetrievalResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CancelRetrievalRequest, CancelRetrievalResponse>()
                            .withOperationName("CancelRetrieval")
                            .withMarshaller(new CancelRetrievalRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(cancelRetrievalRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = cancelRetrievalRequest.overrideConfiguration().orElse(null);
            CompletableFuture<CancelRetrievalResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a cached volume on a specified cached volume gateway. This operation is only supported in the cached
     * volume gateway type.
     * </p>
     * <note>
     * <p>
     * Cache storage must be allocated to the gateway before you can create a cached volume. Use the <a>AddCache</a>
     * operation to add cache storage to a gateway.
     * </p>
     * </note>
     * <p>
     * In the request, you must specify the gateway, size of the volume in bytes, the iSCSI target name, an IP address
     * on which to expose the target, and a unique client token. In response, the gateway creates the volume and returns
     * information about it. This information includes the volume Amazon Resource Name (ARN), its size, and the iSCSI
     * target ARN that initiators can use to connect to the volume target.
     * </p>
     * <p>
     * Optionally, you can provide the ARN for an existing volume as the <code>SourceVolumeARN</code> for this cached
     * volume, which creates an exact copy of the existing volume’s latest recovery point. The
     * <code>VolumeSizeInBytes</code> value must be equal to or larger than the size of the copied volume, in bytes.
     * </p>
     *
     * @param createCachediScsiVolumeRequest
     * @return A Java Future containing the result of the CreateCachediSCSIVolume operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidGatewayRequestException An exception occurred because an invalid gateway request was issued to
     *         the service. For more information, see the error and message fields.</li>
     *         <li>InternalServerErrorException An internal server error has occurred during the request. For more
     *         information, see the error and message fields.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>StorageGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample StorageGatewayAsyncClient.CreateCachediSCSIVolume
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/CreateCachediSCSIVolume"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateCachediScsiVolumeResponse> createCachediSCSIVolume(
            CreateCachediScsiVolumeRequest createCachediScsiVolumeRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createCachediScsiVolumeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateCachediSCSIVolume");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateCachediScsiVolumeResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateCachediScsiVolumeResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateCachediScsiVolumeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateCachediScsiVolumeRequest, CreateCachediScsiVolumeResponse>()
                            .withOperationName("CreateCachediSCSIVolume")
                            .withMarshaller(new CreateCachediScsiVolumeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createCachediScsiVolumeRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createCachediScsiVolumeRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<CreateCachediScsiVolumeResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a Network File System (NFS) file share on an existing S3 File Gateway. In Storage Gateway, a file share
     * is a file system mount point backed by Amazon S3 cloud storage. Storage Gateway exposes file shares using an NFS
     * interface. This operation is only supported for S3 File Gateways.
     * </p>
     * <important>
     * <p>
     * S3 File gateway requires Security Token Service (Amazon Web Services STS) to be activated to enable you to create
     * a file share. Make sure Amazon Web Services STS is activated in the Amazon Web Services Region you are creating
     * your S3 File Gateway in. If Amazon Web Services STS is not activated in the Amazon Web Services Region, activate
     * it. For information about how to activate Amazon Web Services STS, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_enable-regions.html">Activating and
     * deactivating Amazon Web Services STS in an Amazon Web Services Region</a> in the <i>Identity and Access
     * Management User Guide</i>.
     * </p>
     * <p>
     * S3 File Gateways do not support creating hard or symbolic links on a file share.
     * </p>
     * </important>
     *
     * @param createNfsFileShareRequest
     *        CreateNFSFileShareInput
     * @return A Java Future containing the result of the CreateNFSFileShare operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidGatewayRequestException An exception occurred because an invalid gateway request was issued to
     *         the service. For more information, see the error and message fields.</li>
     *         <li>InternalServerErrorException An internal server error has occurred during the request. For more
     *         information, see the error and message fields.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>StorageGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample StorageGatewayAsyncClient.CreateNFSFileShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/CreateNFSFileShare"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateNfsFileShareResponse> createNFSFileShare(CreateNfsFileShareRequest createNfsFileShareRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createNfsFileShareRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateNFSFileShare");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateNfsFileShareResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateNfsFileShareResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateNfsFileShareResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateNfsFileShareRequest, CreateNfsFileShareResponse>()
                            .withOperationName("CreateNFSFileShare")
                            .withMarshaller(new CreateNfsFileShareRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createNfsFileShareRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createNfsFileShareRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<CreateNfsFileShareResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a Server Message Block (SMB) file share on an existing S3 File Gateway. In Storage Gateway, a file share
     * is a file system mount point backed by Amazon S3 cloud storage. Storage Gateway exposes file shares using an SMB
     * interface. This operation is only supported for S3 File Gateways.
     * </p>
     * <important>
     * <p>
     * S3 File Gateways require Security Token Service (Amazon Web Services STS) to be activated to enable you to create
     * a file share. Make sure that Amazon Web Services STS is activated in the Amazon Web Services Region you are
     * creating your S3 File Gateway in. If Amazon Web Services STS is not activated in this Amazon Web Services Region,
     * activate it. For information about how to activate Amazon Web Services STS, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_enable-regions.html">Activating and
     * deactivating Amazon Web Services STS in an Amazon Web Services Region</a> in the <i>Identity and Access
     * Management User Guide</i>.
     * </p>
     * <p>
     * File gateways don't support creating hard or symbolic links on a file share.
     * </p>
     * </important>
     *
     * @param createSmbFileShareRequest
     *        CreateSMBFileShareInput
     * @return A Java Future containing the result of the CreateSMBFileShare operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidGatewayRequestException An exception occurred because an invalid gateway request was issued to
     *         the service. For more information, see the error and message fields.</li>
     *         <li>InternalServerErrorException An internal server error has occurred during the request. For more
     *         information, see the error and message fields.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>StorageGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample StorageGatewayAsyncClient.CreateSMBFileShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/CreateSMBFileShare"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateSmbFileShareResponse> createSMBFileShare(CreateSmbFileShareRequest createSmbFileShareRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createSmbFileShareRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateSMBFileShare");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateSmbFileShareResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateSmbFileShareResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateSmbFileShareResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateSmbFileShareRequest, CreateSmbFileShareResponse>()
                            .withOperationName("CreateSMBFileShare")
                            .withMarshaller(new CreateSmbFileShareRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createSmbFileShareRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createSmbFileShareRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<CreateSmbFileShareResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Initiates a snapshot of a volume.
     * </p>
     * <p>
     * Storage Gateway provides the ability to back up point-in-time snapshots of your data to Amazon Simple Storage
     * (Amazon S3) for durable off-site recovery, and also import the data to an Amazon Elastic Block Store (EBS) volume
     * in Amazon Elastic Compute Cloud (EC2). You can take snapshots of your gateway volume on a scheduled or ad hoc
     * basis. This API enables you to take an ad hoc snapshot. For more information, see <a
     * href="https://docs.aws.amazon.com/storagegateway/latest/userguide/managing-volumes.html#SchedulingSnapshot"
     * >Editing a snapshot schedule</a>.
     * </p>
     * <p>
     * In the <code>CreateSnapshot</code> request, you identify the volume by providing its Amazon Resource Name (ARN).
     * You must also provide description for the snapshot. When Storage Gateway takes the snapshot of specified volume,
     * the snapshot and description appears in the Storage Gateway console. In response, Storage Gateway returns you a
     * snapshot ID. You can use this snapshot ID to check the snapshot progress or later use it when you want to create
     * a volume from a snapshot. This operation is only supported in stored and cached volume gateway type.
     * </p>
     * <note>
     * <p>
     * To list or delete a snapshot, you must use the Amazon EC2 API. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeSnapshots.html">DescribeSnapshots</a> or
     * <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteSnapshot.html">DeleteSnapshot</a> in
     * the <i>Amazon Elastic Compute Cloud API Reference</i>.
     * </p>
     * </note> <important>
     * <p>
     * Volume and snapshot IDs are changing to a longer length ID format. For more information, see the important note
     * on the <a href="https://docs.aws.amazon.com/storagegateway/latest/APIReference/Welcome.html">Welcome</a> page.
     * </p>
     * </important>
     *
     * @param createSnapshotRequest
     *        A JSON object containing one or more of the following fields:</p>
     *        <ul>
     *        <li>
     *        <p>
     *        <a>CreateSnapshotInput&#36SnapshotDescription</a>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <a>CreateSnapshotInput&#36VolumeARN</a>
     *        </p>
     *        </li>
     * @return A Java Future containing the result of the CreateSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidGatewayRequestException An exception occurred because an invalid gateway request was issued to
     *         the service. For more information, see the error and message fields.</li>
     *         <li>InternalServerErrorException An internal server error has occurred during the request. For more
     *         information, see the error and message fields.</li>
     *         <li>ServiceUnavailableErrorException An internal server error has occurred because the service is
     *         unavailable. For more information, see the error and message fields.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>StorageGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample StorageGatewayAsyncClient.CreateSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/CreateSnapshot" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateSnapshotResponse> createSnapshot(CreateSnapshotRequest createSnapshotRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createSnapshotRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateSnapshot");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateSnapshotResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateSnapshotResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateSnapshotResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateSnapshotRequest, CreateSnapshotResponse>()
                            .withOperationName("CreateSnapshot")
                            .withMarshaller(new CreateSnapshotRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createSnapshotRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createSnapshotRequest.overrideConfiguration().orElse(null);
            CompletableFuture<CreateSnapshotResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Initiates a snapshot of a gateway from a volume recovery point. This operation is only supported in the cached
     * volume gateway type.
     * </p>
     * <p>
     * A volume recovery point is a point in time at which all data of the volume is consistent and from which you can
     * create a snapshot. To get a list of volume recovery point for cached volume gateway, use
     * <a>ListVolumeRecoveryPoints</a>.
     * </p>
     * <p>
     * In the <code>CreateSnapshotFromVolumeRecoveryPoint</code> request, you identify the volume by providing its
     * Amazon Resource Name (ARN). You must also provide a description for the snapshot. When the gateway takes a
     * snapshot of the specified volume, the snapshot and its description appear in the Storage Gateway console. In
     * response, the gateway returns you a snapshot ID. You can use this snapshot ID to check the snapshot progress or
     * later use it when you want to create a volume from a snapshot.
     * </p>
     * <note>
     * <p>
     * To list or delete a snapshot, you must use the Amazon EC2 API. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeSnapshots.html">DescribeSnapshots</a> or
     * <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteSnapshot.html">DeleteSnapshot</a> in
     * the <i>Amazon Elastic Compute Cloud API Reference</i>.
     * </p>
     * </note>
     *
     * @param createSnapshotFromVolumeRecoveryPointRequest
     * @return A Java Future containing the result of the CreateSnapshotFromVolumeRecoveryPoint operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidGatewayRequestException An exception occurred because an invalid gateway request was issued to
     *         the service. For more information, see the error and message fields.</li>
     *         <li>InternalServerErrorException An internal server error has occurred during the request. For more
     *         information, see the error and message fields.</li>
     *         <li>ServiceUnavailableErrorException An internal server error has occurred because the service is
     *         unavailable. For more information, see the error and message fields.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>StorageGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample StorageGatewayAsyncClient.CreateSnapshotFromVolumeRecoveryPoint
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/CreateSnapshotFromVolumeRecoveryPoint"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateSnapshotFromVolumeRecoveryPointResponse> createSnapshotFromVolumeRecoveryPoint(
            CreateSnapshotFromVolumeRecoveryPointRequest createSnapshotFromVolumeRecoveryPointRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createSnapshotFromVolumeRecoveryPointRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateSnapshotFromVolumeRecoveryPoint");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateSnapshotFromVolumeRecoveryPointResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, CreateSnapshotFromVolumeRecoveryPointResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateSnapshotFromVolumeRecoveryPointResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateSnapshotFromVolumeRecoveryPointRequest, CreateSnapshotFromVolumeRecoveryPointResponse>()
                            .withOperationName("CreateSnapshotFromVolumeRecoveryPoint")
                            .withMarshaller(new CreateSnapshotFromVolumeRecoveryPointRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createSnapshotFromVolumeRecoveryPointRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createSnapshotFromVolumeRecoveryPointRequest
                    .overrideConfiguration().orElse(null);
            CompletableFuture<CreateSnapshotFromVolumeRecoveryPointResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a volume on a specified gateway. This operation is only supported in the stored volume gateway type.
     * </p>
     * <p>
     * The size of the volume to create is inferred from the disk size. You can choose to preserve existing data on the
     * disk, create volume from an existing snapshot, or create an empty volume. If you choose to create an empty
     * gateway volume, then any existing data on the disk is erased.
     * </p>
     * <p>
     * In the request, you must specify the gateway and the disk information on which you are creating the volume. In
     * response, the gateway creates the volume and returns volume information such as the volume Amazon Resource Name
     * (ARN), its size, and the iSCSI target ARN that initiators can use to connect to the volume target.
     * </p>
     *
     * @param createStorediScsiVolumeRequest
     *        A JSON object containing one or more of the following fields:</p>
     *        <ul>
     *        <li>
     *        <p>
     *        <a>CreateStorediSCSIVolumeInput&#36DiskId</a>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <a>CreateStorediSCSIVolumeInput&#36NetworkInterfaceId</a>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <a>CreateStorediSCSIVolumeInput&#36PreserveExistingData</a>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <a>CreateStorediSCSIVolumeInput&#36SnapshotId</a>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <a>CreateStorediSCSIVolumeInput&#36TargetName</a>
     *        </p>
     *        </li>
     * @return A Java Future containing the result of the CreateStorediSCSIVolume operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidGatewayRequestException An exception occurred because an invalid gateway request was issued to
     *         the service. For more information, see the error and message fields.</li>
     *         <li>InternalServerErrorException An internal server error has occurred during the request. For more
     *         information, see the error and message fields.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>StorageGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample StorageGatewayAsyncClient.CreateStorediSCSIVolume
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/CreateStorediSCSIVolume"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateStorediScsiVolumeResponse> createStorediSCSIVolume(
            CreateStorediScsiVolumeRequest createStorediScsiVolumeRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createStorediScsiVolumeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateStorediSCSIVolume");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateStorediScsiVolumeResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateStorediScsiVolumeResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateStorediScsiVolumeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateStorediScsiVolumeRequest, CreateStorediScsiVolumeResponse>()
                            .withOperationName("CreateStorediSCSIVolume")
                            .withMarshaller(new CreateStorediScsiVolumeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createStorediScsiVolumeRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createStorediScsiVolumeRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<CreateStorediScsiVolumeResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new custom tape pool. You can use custom tape pool to enable tape retention lock on tapes that are
     * archived in the custom pool.
     * </p>
     *
     * @param createTapePoolRequest
     * @return A Java Future containing the result of the CreateTapePool operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidGatewayRequestException An exception occurred because an invalid gateway request was issued to
     *         the service. For more information, see the error and message fields.</li>
     *         <li>InternalServerErrorException An internal server error has occurred during the request. For more
     *         information, see the error and message fields.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>StorageGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample StorageGatewayAsyncClient.CreateTapePool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/CreateTapePool" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateTapePoolResponse> createTapePool(CreateTapePoolRequest createTapePoolRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createTapePoolRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateTapePool");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateTapePoolResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateTapePoolResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateTapePoolResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateTapePoolRequest, CreateTapePoolResponse>()
                            .withOperationName("CreateTapePool")
                            .withMarshaller(new CreateTapePoolRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createTapePoolRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createTapePoolRequest.overrideConfiguration().orElse(null);
            CompletableFuture<CreateTapePoolResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a virtual tape by using your own barcode. You write data to the virtual tape and then archive the tape. A
     * barcode is unique and cannot be reused if it has already been used on a tape. This applies to barcodes used on
     * deleted tapes. This operation is only supported in the tape gateway type.
     * </p>
     * <note>
     * <p>
     * Cache storage must be allocated to the gateway before you can create a virtual tape. Use the <a>AddCache</a>
     * operation to add cache storage to a gateway.
     * </p>
     * </note>
     *
     * @param createTapeWithBarcodeRequest
     *        CreateTapeWithBarcodeInput
     * @return A Java Future containing the result of the CreateTapeWithBarcode operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidGatewayRequestException An exception occurred because an invalid gateway request was issued to
     *         the service. For more information, see the error and message fields.</li>
     *         <li>InternalServerErrorException An internal server error has occurred during the request. For more
     *         information, see the error and message fields.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>StorageGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample StorageGatewayAsyncClient.CreateTapeWithBarcode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/CreateTapeWithBarcode"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateTapeWithBarcodeResponse> createTapeWithBarcode(
            CreateTapeWithBarcodeRequest createTapeWithBarcodeRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createTapeWithBarcodeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateTapeWithBarcode");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateTapeWithBarcodeResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateTapeWithBarcodeResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateTapeWithBarcodeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateTapeWithBarcodeRequest, CreateTapeWithBarcodeResponse>()
                            .withOperationName("CreateTapeWithBarcode")
                            .withMarshaller(new CreateTapeWithBarcodeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createTapeWithBarcodeRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createTapeWithBarcodeRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<CreateTapeWithBarcodeResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates one or more virtual tapes. You write data to the virtual tapes and then archive the tapes. This operation
     * is only supported in the tape gateway type.
     * </p>
     * <note>
     * <p>
     * Cache storage must be allocated to the gateway before you can create virtual tapes. Use the <a>AddCache</a>
     * operation to add cache storage to a gateway.
     * </p>
     * </note>
     *
     * @param createTapesRequest
     *        CreateTapesInput
     * @return A Java Future containing the result of the CreateTapes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidGatewayRequestException An exception occurred because an invalid gateway request was issued to
     *         the service. For more information, see the error and message fields.</li>
     *         <li>InternalServerErrorException An internal server error has occurred during the request. For more
     *         information, see the error and message fields.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>StorageGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample StorageGatewayAsyncClient.CreateTapes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/CreateTapes" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateTapesResponse> createTapes(CreateTapesRequest createTapesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createTapesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateTapes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateTapesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateTapesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateTapesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateTapesRequest, CreateTapesResponse>()
                            .withOperationName("CreateTapes").withMarshaller(new CreateTapesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createTapesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createTapesRequest.overrideConfiguration().orElse(null);
            CompletableFuture<CreateTapesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the automatic tape creation policy of a gateway. If you delete this policy, new virtual tapes must be
     * created manually. Use the Amazon Resource Name (ARN) of the gateway in your request to remove the policy.
     * </p>
     *
     * @param deleteAutomaticTapeCreationPolicyRequest
     * @return A Java Future containing the result of the DeleteAutomaticTapeCreationPolicy operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidGatewayRequestException An exception occurred because an invalid gateway request was issued to
     *         the service. For more information, see the error and message fields.</li>
     *         <li>InternalServerErrorException An internal server error has occurred during the request. For more
     *         information, see the error and message fields.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>StorageGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample StorageGatewayAsyncClient.DeleteAutomaticTapeCreationPolicy
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DeleteAutomaticTapeCreationPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteAutomaticTapeCreationPolicyResponse> deleteAutomaticTapeCreationPolicy(
            DeleteAutomaticTapeCreationPolicyRequest deleteAutomaticTapeCreationPolicyRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteAutomaticTapeCreationPolicyRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAutomaticTapeCreationPolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteAutomaticTapeCreationPolicyResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DeleteAutomaticTapeCreationPolicyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteAutomaticTapeCreationPolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteAutomaticTapeCreationPolicyRequest, DeleteAutomaticTapeCreationPolicyResponse>()
                            .withOperationName("DeleteAutomaticTapeCreationPolicy")
                            .withMarshaller(new DeleteAutomaticTapeCreationPolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteAutomaticTapeCreationPolicyRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteAutomaticTapeCreationPolicyRequest
                    .overrideConfiguration().orElse(null);
            CompletableFuture<DeleteAutomaticTapeCreationPolicyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the bandwidth rate limits of a gateway. You can delete either the upload and download bandwidth rate
     * limit, or you can delete both. If you delete only one of the limits, the other limit remains unchanged. To
     * specify which gateway to work with, use the Amazon Resource Name (ARN) of the gateway in your request. This
     * operation is supported for the stored volume, cached volume and tape gateway types.
     * </p>
     *
     * @param deleteBandwidthRateLimitRequest
     *        A JSON object containing the following fields:</p>
     *        <ul>
     *        <li>
     *        <p>
     *        <a>DeleteBandwidthRateLimitInput&#36BandwidthType</a>
     *        </p>
     *        </li>
     * @return A Java Future containing the result of the DeleteBandwidthRateLimit operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidGatewayRequestException An exception occurred because an invalid gateway request was issued to
     *         the service. For more information, see the error and message fields.</li>
     *         <li>InternalServerErrorException An internal server error has occurred during the request. For more
     *         information, see the error and message fields.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>StorageGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample StorageGatewayAsyncClient.DeleteBandwidthRateLimit
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DeleteBandwidthRateLimit"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteBandwidthRateLimitResponse> deleteBandwidthRateLimit(
            DeleteBandwidthRateLimitRequest deleteBandwidthRateLimitRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteBandwidthRateLimitRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteBandwidthRateLimit");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteBandwidthRateLimitResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteBandwidthRateLimitResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteBandwidthRateLimitResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteBandwidthRateLimitRequest, DeleteBandwidthRateLimitResponse>()
                            .withOperationName("DeleteBandwidthRateLimit")
                            .withMarshaller(new DeleteBandwidthRateLimitRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteBandwidthRateLimitRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteBandwidthRateLimitRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<DeleteBandwidthRateLimitResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes Challenge-Handshake Authentication Protocol (CHAP) credentials for a specified iSCSI target and initiator
     * pair. This operation is supported in volume and tape gateway types.
     * </p>
     *
     * @param deleteChapCredentialsRequest
     *        A JSON object containing one or more of the following fields:</p>
     *        <ul>
     *        <li>
     *        <p>
     *        <a>DeleteChapCredentialsInput&#36InitiatorName</a>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <a>DeleteChapCredentialsInput&#36TargetARN</a>
     *        </p>
     *        </li>
     * @return A Java Future containing the result of the DeleteChapCredentials operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidGatewayRequestException An exception occurred because an invalid gateway request was issued to
     *         the service. For more information, see the error and message fields.</li>
     *         <li>InternalServerErrorException An internal server error has occurred during the request. For more
     *         information, see the error and message fields.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>StorageGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample StorageGatewayAsyncClient.DeleteChapCredentials
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DeleteChapCredentials"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteChapCredentialsResponse> deleteChapCredentials(
            DeleteChapCredentialsRequest deleteChapCredentialsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteChapCredentialsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteChapCredentials");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteChapCredentialsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteChapCredentialsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteChapCredentialsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteChapCredentialsRequest, DeleteChapCredentialsResponse>()
                            .withOperationName("DeleteChapCredentials")
                            .withMarshaller(new DeleteChapCredentialsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteChapCredentialsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteChapCredentialsRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<DeleteChapCredentialsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a file share from an S3 File Gateway. This operation is only supported for S3 File Gateways.
     * </p>
     *
     * @param deleteFileShareRequest
     *        DeleteFileShareInput
     * @return A Java Future containing the result of the DeleteFileShare operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidGatewayRequestException An exception occurred because an invalid gateway request was issued to
     *         the service. For more information, see the error and message fields.</li>
     *         <li>InternalServerErrorException An internal server error has occurred during the request. For more
     *         information, see the error and message fields.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>StorageGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample StorageGatewayAsyncClient.DeleteFileShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DeleteFileShare"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteFileShareResponse> deleteFileShare(DeleteFileShareRequest deleteFileShareRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteFileShareRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteFileShare");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteFileShareResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteFileShareResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteFileShareResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteFileShareRequest, DeleteFileShareResponse>()
                            .withOperationName("DeleteFileShare")
                            .withMarshaller(new DeleteFileShareRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteFileShareRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteFileShareRequest.overrideConfiguration().orElse(null);
            CompletableFuture<DeleteFileShareResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a gateway. To specify which gateway to delete, use the Amazon Resource Name (ARN) of the gateway in your
     * request. The operation deletes the gateway; however, it does not delete the gateway virtual machine (VM) from
     * your host computer.
     * </p>
     * <p>
     * After you delete a gateway, you cannot reactivate it. Completed snapshots of the gateway volumes are not deleted
     * upon deleting the gateway, however, pending snapshots will not complete. After you delete a gateway, your next
     * step is to remove it from your environment.
     * </p>
     * <important>
     * <p>
     * You no longer pay software charges after the gateway is deleted; however, your existing Amazon EBS snapshots
     * persist and you will continue to be billed for these snapshots. You can choose to remove all remaining Amazon EBS
     * snapshots by canceling your Amazon EC2 subscription.  If you prefer not to cancel your Amazon EC2 subscription,
     * you can delete your snapshots using the Amazon EC2 console. For more information, see the <a
     * href="http://aws.amazon.com/storagegateway">Storage Gateway detail page</a>.
     * </p>
     * </important>
     *
     * @param deleteGatewayRequest
     *        A JSON object containing the ID of the gateway to delete.
     * @return A Java Future containing the result of the DeleteGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidGatewayRequestException An exception occurred because an invalid gateway request was issued to
     *         the service. For more information, see the error and message fields.</li>
     *         <li>InternalServerErrorException An internal server error has occurred during the request. For more
     *         information, see the error and message fields.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>StorageGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample StorageGatewayAsyncClient.DeleteGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DeleteGateway" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteGatewayResponse> deleteGateway(DeleteGatewayRequest deleteGatewayRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteGatewayRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteGateway");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteGatewayResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteGatewayResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteGatewayResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteGatewayRequest, DeleteGatewayResponse>()
                            .withOperationName("DeleteGateway")
                            .withMarshaller(new DeleteGatewayRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteGatewayRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteGatewayRequest.overrideConfiguration().orElse(null);
            CompletableFuture<DeleteGatewayResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a snapshot of a volume.
     * </p>
     * <p>
     * You can take snapshots of your gateway volumes on a scheduled or ad hoc basis. This API action enables you to
     * delete a snapshot schedule for a volume. For more information, see <a
     * href="https://docs.aws.amazon.com/storagegateway/latest/userguide/backing-up-volumes.html">Backing up your
     * volumes</a>. In the <code>DeleteSnapshotSchedule</code> request, you identify the volume by providing its Amazon
     * Resource Name (ARN). This operation is only supported in stored and cached volume gateway types.
     * </p>
     * <note>
     * <p>
     * To list or delete a snapshot, you must use the Amazon EC2 API. For more information, go to <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeSnapshots.html">DescribeSnapshots</a> in
     * the <i>Amazon Elastic Compute Cloud API Reference</i>.
     * </p>
     * </note>
     *
     * @param deleteSnapshotScheduleRequest
     * @return A Java Future containing the result of the DeleteSnapshotSchedule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidGatewayRequestException An exception occurred because an invalid gateway request was issued to
     *         the service. For more information, see the error and message fields.</li>
     *         <li>InternalServerErrorException An internal server error has occurred during the request. For more
     *         information, see the error and message fields.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>StorageGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample StorageGatewayAsyncClient.DeleteSnapshotSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DeleteSnapshotSchedule"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteSnapshotScheduleResponse> deleteSnapshotSchedule(
            DeleteSnapshotScheduleRequest deleteSnapshotScheduleRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteSnapshotScheduleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteSnapshotSchedule");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteSnapshotScheduleResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteSnapshotScheduleResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteSnapshotScheduleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteSnapshotScheduleRequest, DeleteSnapshotScheduleResponse>()
                            .withOperationName("DeleteSnapshotSchedule")
                            .withMarshaller(new DeleteSnapshotScheduleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteSnapshotScheduleRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteSnapshotScheduleRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<DeleteSnapshotScheduleResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified virtual tape. This operation is only supported in the tape gateway type.
     * </p>
     *
     * @param deleteTapeRequest
     *        DeleteTapeInput
     * @return A Java Future containing the result of the DeleteTape operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidGatewayRequestException An exception occurred because an invalid gateway request was issued to
     *         the service. For more information, see the error and message fields.</li>
     *         <li>InternalServerErrorException An internal server error has occurred during the request. For more
     *         information, see the error and message fields.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>StorageGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample StorageGatewayAsyncClient.DeleteTape
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DeleteTape" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteTapeResponse> deleteTape(DeleteTapeRequest deleteTapeRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteTapeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteTape");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteTapeResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteTapeResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteTapeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteTapeRequest, DeleteTapeResponse>().withOperationName("DeleteTape")
                            .withMarshaller(new DeleteTapeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteTapeRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteTapeRequest.overrideConfiguration().orElse(null);
            CompletableFuture<DeleteTapeResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified virtual tape from the virtual tape shelf (VTS). This operation is only supported in the
     * tape gateway type.
     * </p>
     *
     * @param deleteTapeArchiveRequest
     *        DeleteTapeArchiveInput
     * @return A Java Future containing the result of the DeleteTapeArchive operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidGatewayRequestException An exception occurred because an invalid gateway request was issued to
     *         the service. For more information, see the error and message fields.</li>
     *         <li>InternalServerErrorException An internal server error has occurred during the request. For more
     *         information, see the error and message fields.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>StorageGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample StorageGatewayAsyncClient.DeleteTapeArchive
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DeleteTapeArchive"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteTapeArchiveResponse> deleteTapeArchive(DeleteTapeArchiveRequest deleteTapeArchiveRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteTapeArchiveRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteTapeArchive");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteTapeArchiveResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteTapeArchiveResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteTapeArchiveResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteTapeArchiveRequest, DeleteTapeArchiveResponse>()
                            .withOperationName("DeleteTapeArchive")
                            .withMarshaller(new DeleteTapeArchiveRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteTapeArchiveRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteTapeArchiveRequest.overrideConfiguration().orElse(null);
            CompletableFuture<DeleteTapeArchiveResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Delete a custom tape pool. A custom tape pool can only be deleted if there are no tapes in the pool and if there
     * are no automatic tape creation policies that reference the custom tape pool.
     * </p>
     *
     * @param deleteTapePoolRequest
     * @return A Java Future containing the result of the DeleteTapePool operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidGatewayRequestException An exception occurred because an invalid gateway request was issued to
     *         the service. For more information, see the error and message fields.</li>
     *         <li>InternalServerErrorException An internal server error has occurred during the request. For more
     *         information, see the error and message fields.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>StorageGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample StorageGatewayAsyncClient.DeleteTapePool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DeleteTapePool" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteTapePoolResponse> deleteTapePool(DeleteTapePoolRequest deleteTapePoolRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteTapePoolRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteTapePool");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteTapePoolResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteTapePoolResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteTapePoolResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteTapePoolRequest, DeleteTapePoolResponse>()
                            .withOperationName("DeleteTapePool")
                            .withMarshaller(new DeleteTapePoolRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteTapePoolRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteTapePoolRequest.overrideConfiguration().orElse(null);
            CompletableFuture<DeleteTapePoolResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified storage volume that you previously created using the <a>CreateCachediSCSIVolume</a> or
     * <a>CreateStorediSCSIVolume</a> API. This operation is only supported in the cached volume and stored volume
     * types. For stored volume gateways, the local disk that was configured as the storage volume is not deleted. You
     * can reuse the local disk to create another storage volume.
     * </p>
     * <p>
     * Before you delete a volume, make sure there are no iSCSI connections to the volume you are deleting. You should
     * also make sure there is no snapshot in progress. You can use the Amazon Elastic Compute Cloud (Amazon EC2) API to
     * query snapshots on the volume you are deleting and check the snapshot status. For more information, go to <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/ApiReference-query-DescribeSnapshots.html">
     * DescribeSnapshots</a> in the <i>Amazon Elastic Compute Cloud API Reference</i>.
     * </p>
     * <p>
     * In the request, you must provide the Amazon Resource Name (ARN) of the storage volume you want to delete.
     * </p>
     *
     * @param deleteVolumeRequest
     *        A JSON object containing the <a>DeleteVolumeInput&#36VolumeARN</a> to delete.
     * @return A Java Future containing the result of the DeleteVolume operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidGatewayRequestException An exception occurred because an invalid gateway request was issued to
     *         the service. For more information, see the error and message fields.</li>
     *         <li>InternalServerErrorException An internal server error has occurred during the request. For more
     *         information, see the error and message fields.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>StorageGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample StorageGatewayAsyncClient.DeleteVolume
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DeleteVolume" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteVolumeResponse> deleteVolume(DeleteVolumeRequest deleteVolumeRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteVolumeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteVolume");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteVolumeResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteVolumeResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteVolumeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteVolumeRequest, DeleteVolumeResponse>()
                            .withOperationName("DeleteVolume").withMarshaller(new DeleteVolumeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteVolumeRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteVolumeRequest.overrideConfiguration().orElse(null);
            CompletableFuture<DeleteVolumeResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about the most recent high availability monitoring test that was performed on the host in a
     * cluster. If a test isn't performed, the status and start time in the response would be null.
     * </p>
     *
     * @param describeAvailabilityMonitorTestRequest
     * @return A Java Future containing the result of the DescribeAvailabilityMonitorTest operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidGatewayRequestException An exception occurred because an invalid gateway request was issued to
     *         the service. For more information, see the error and message fields.</li>
     *         <li>InternalServerErrorException An internal server error has occurred during the request. For more
     *         information, see the error and message fields.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>StorageGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample StorageGatewayAsyncClient.DescribeAvailabilityMonitorTest
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeAvailabilityMonitorTest"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeAvailabilityMonitorTestResponse> describeAvailabilityMonitorTest(
            DescribeAvailabilityMonitorTestRequest describeAvailabilityMonitorTestRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeAvailabilityMonitorTestRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAvailabilityMonitorTest");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeAvailabilityMonitorTestResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeAvailabilityMonitorTestResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeAvailabilityMonitorTestResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeAvailabilityMonitorTestRequest, DescribeAvailabilityMonitorTestResponse>()
                            .withOperationName("DescribeAvailabilityMonitorTest")
                            .withMarshaller(new DescribeAvailabilityMonitorTestRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeAvailabilityMonitorTestRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeAvailabilityMonitorTestRequest
                    .overrideConfiguration().orElse(null);
            CompletableFuture<DescribeAvailabilityMonitorTestResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the bandwidth rate limits of a gateway. By default, these limits are not set, which means no bandwidth
     * rate limiting is in effect. This operation is supported for the stored volume, cached volume, and tape gateway
     * types.
     * </p>
     * <p>
     * This operation only returns a value for a bandwidth rate limit only if the limit is set. If no limits are set for
     * the gateway, then this operation returns only the gateway ARN in the response body. To specify which gateway to
     * describe, use the Amazon Resource Name (ARN) of the gateway in your request.
     * </p>
     *
     * @param describeBandwidthRateLimitRequest
     *        A JSON object containing the Amazon Resource Name (ARN) of the gateway.
     * @return A Java Future containing the result of the DescribeBandwidthRateLimit operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidGatewayRequestException An exception occurred because an invalid gateway request was issued to
     *         the service. For more information, see the error and message fields.</li>
     *         <li>InternalServerErrorException An internal server error has occurred during the request. For more
     *         information, see the error and message fields.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>StorageGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample StorageGatewayAsyncClient.DescribeBandwidthRateLimit
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeBandwidthRateLimit"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeBandwidthRateLimitResponse> describeBandwidthRateLimit(
            DescribeBandwidthRateLimitRequest describeBandwidthRateLimitRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeBandwidthRateLimitRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeBandwidthRateLimit");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeBandwidthRateLimitResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeBandwidthRateLimitResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeBandwidthRateLimitResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeBandwidthRateLimitRequest, DescribeBandwidthRateLimitResponse>()
                            .withOperationName("DescribeBandwidthRateLimit")
                            .withMarshaller(new DescribeBandwidthRateLimitRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeBandwidthRateLimitRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeBandwidthRateLimitRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<DescribeBandwidthRateLimitResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about the bandwidth rate limit schedule of a gateway. By default, gateways do not have
     * bandwidth rate limit schedules, which means no bandwidth rate limiting is in effect. This operation is supported
     * only in the volume and tape gateway types.
     * </p>
     * <p>
     * This operation returns information about a gateway's bandwidth rate limit schedule. A bandwidth rate limit
     * schedule consists of one or more bandwidth rate limit intervals. A bandwidth rate limit interval defines a period
     * of time on one or more days of the week, during which bandwidth rate limits are specified for uploading,
     * downloading, or both.
     * </p>
     * <p>
     * A bandwidth rate limit interval consists of one or more days of the week, a start hour and minute, an ending hour
     * and minute, and bandwidth rate limits for uploading and downloading
     * </p>
     * <p>
     * If no bandwidth rate limit schedule intervals are set for the gateway, this operation returns an empty response.
     * To specify which gateway to describe, use the Amazon Resource Name (ARN) of the gateway in your request.
     * </p>
     *
     * @param describeBandwidthRateLimitScheduleRequest
     * @return A Java Future containing the result of the DescribeBandwidthRateLimitSchedule operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidGatewayRequestException An exception occurred because an invalid gateway request was issued to
     *         the service. For more information, see the error and message fields.</li>
     *         <li>InternalServerErrorException An internal server error has occurred during the request. For more
     *         information, see the error and message fields.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>StorageGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample StorageGatewayAsyncClient.DescribeBandwidthRateLimitSchedule
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeBandwidthRateLimitSchedule"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeBandwidthRateLimitScheduleResponse> describeBandwidthRateLimitSchedule(
            DescribeBandwidthRateLimitScheduleRequest describeBandwidthRateLimitScheduleRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeBandwidthRateLimitScheduleRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeBandwidthRateLimitSchedule");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeBandwidthRateLimitScheduleResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribeBandwidthRateLimitScheduleResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeBandwidthRateLimitScheduleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeBandwidthRateLimitScheduleRequest, DescribeBandwidthRateLimitScheduleResponse>()
                            .withOperationName("DescribeBandwidthRateLimitSchedule")
                            .withMarshaller(new DescribeBandwidthRateLimitScheduleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeBandwidthRateLimitScheduleRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeBandwidthRateLimitScheduleRequest
                    .overrideConfiguration().orElse(null);
            CompletableFuture<DescribeBandwidthRateLimitScheduleResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about the cache of a gateway. This operation is only supported in the cached volume, tape,
     * and file gateway types.
     * </p>
     * <p>
     * The response includes disk IDs that are configured as cache, and it includes the amount of cache allocated and
     * used.
     * </p>
     *
     * @param describeCacheRequest
     * @return A Java Future containing the result of the DescribeCache operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidGatewayRequestException An exception occurred because an invalid gateway request was issued to
     *         the service. For more information, see the error and message fields.</li>
     *         <li>InternalServerErrorException An internal server error has occurred during the request. For more
     *         information, see the error and message fields.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>StorageGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample StorageGatewayAsyncClient.DescribeCache
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeCache" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeCacheResponse> describeCache(DescribeCacheRequest describeCacheRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeCacheRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeCache");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeCacheResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DescribeCacheResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeCacheResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeCacheRequest, DescribeCacheResponse>()
                            .withOperationName("DescribeCache")
                            .withMarshaller(new DescribeCacheRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeCacheRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeCacheRequest.overrideConfiguration().orElse(null);
            CompletableFuture<DescribeCacheResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a description of the gateway volumes specified in the request. This operation is only supported in the
     * cached volume gateway types.
     * </p>
     * <p>
     * The list of gateway volumes in the request must be from one gateway. In the response, Storage Gateway returns
     * volume information sorted by volume Amazon Resource Name (ARN).
     * </p>
     *
     * @param describeCachediScsiVolumesRequest
     * @return A Java Future containing the result of the DescribeCachediSCSIVolumes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidGatewayRequestException An exception occurred because an invalid gateway request was issued to
     *         the service. For more information, see the error and message fields.</li>
     *         <li>InternalServerErrorException An internal server error has occurred during the request. For more
     *         information, see the error and message fields.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>StorageGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample StorageGatewayAsyncClient.DescribeCachediSCSIVolumes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeCachediSCSIVolumes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeCachediScsiVolumesResponse> describeCachediSCSIVolumes(
            DescribeCachediScsiVolumesRequest describeCachediScsiVolumesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeCachediScsiVolumesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeCachediSCSIVolumes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeCachediScsiVolumesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeCachediScsiVolumesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeCachediScsiVolumesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeCachediScsiVolumesRequest, DescribeCachediScsiVolumesResponse>()
                            .withOperationName("DescribeCachediSCSIVolumes")
                            .withMarshaller(new DescribeCachediScsiVolumesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeCachediScsiVolumesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeCachediScsiVolumesRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<DescribeCachediScsiVolumesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns an array of Challenge-Handshake Authentication Protocol (CHAP) credentials information for a specified
     * iSCSI target, one for each target-initiator pair. This operation is supported in the volume and tape gateway
     * types.
     * </p>
     *
     * @param describeChapCredentialsRequest
     *        A JSON object containing the Amazon Resource Name (ARN) of the iSCSI volume target.
     * @return A Java Future containing the result of the DescribeChapCredentials operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidGatewayRequestException An exception occurred because an invalid gateway request was issued to
     *         the service. For more information, see the error and message fields.</li>
     *         <li>InternalServerErrorException An internal server error has occurred during the request. For more
     *         information, see the error and message fields.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>StorageGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample StorageGatewayAsyncClient.DescribeChapCredentials
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeChapCredentials"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeChapCredentialsResponse> describeChapCredentials(
            DescribeChapCredentialsRequest describeChapCredentialsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeChapCredentialsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeChapCredentials");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeChapCredentialsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeChapCredentialsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeChapCredentialsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeChapCredentialsRequest, DescribeChapCredentialsResponse>()
                            .withOperationName("DescribeChapCredentials")
                            .withMarshaller(new DescribeChapCredentialsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeChapCredentialsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeChapCredentialsRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<DescribeChapCredentialsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the file system association information. This operation is only supported for FSx File Gateways.
     * </p>
     *
     * @param describeFileSystemAssociationsRequest
     * @return A Java Future containing the result of the DescribeFileSystemAssociations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidGatewayRequestException An exception occurred because an invalid gateway request was issued to
     *         the service. For more information, see the error and message fields.</li>
     *         <li>InternalServerErrorException An internal server error has occurred during the request. For more
     *         information, see the error and message fields.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>StorageGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample StorageGatewayAsyncClient.DescribeFileSystemAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeFileSystemAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeFileSystemAssociationsResponse> describeFileSystemAssociations(
            DescribeFileSystemAssociationsRequest describeFileSystemAssociationsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeFileSystemAssociationsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeFileSystemAssociations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeFileSystemAssociationsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeFileSystemAssociationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeFileSystemAssociationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeFileSystemAssociationsRequest, DescribeFileSystemAssociationsResponse>()
                            .withOperationName("DescribeFileSystemAssociations")
                            .withMarshaller(new DescribeFileSystemAssociationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeFileSystemAssociationsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeFileSystemAssociationsRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<DescribeFileSystemAssociationsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns metadata about a gateway such as its name, network interfaces, configured time zone, and the state
     * (whether the gateway is running or not). To specify which gateway to describe, use the Amazon Resource Name (ARN)
     * of the gateway in your request.
     * </p>
     *
     * @param describeGatewayInformationRequest
     *        A JSON object containing the ID of the gateway.
     * @return A Java Future containing the result of the DescribeGatewayInformation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidGatewayRequestException An exception occurred because an invalid gateway request was issued to
     *         the service. For more information, see the error and message fields.</li>
     *         <li>InternalServerErrorException An internal server error has occurred during the request. For more
     *         information, see the error and message fields.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>StorageGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample StorageGatewayAsyncClient.DescribeGatewayInformation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeGatewayInformation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeGatewayInformationResponse> describeGatewayInformation(
            DescribeGatewayInformationRequest describeGatewayInformationRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeGatewayInformationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeGatewayInformation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeGatewayInformationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeGatewayInformationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeGatewayInformationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeGatewayInformationRequest, DescribeGatewayInformationResponse>()
                            .withOperationName("DescribeGatewayInformation")
                            .withMarshaller(new DescribeGatewayInformationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeGatewayInformationRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeGatewayInformationRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<DescribeGatewayInformationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns your gateway's weekly maintenance start time including the day and time of the week. Note that values are
     * in terms of the gateway's time zone.
     * </p>
     *
     * @param describeMaintenanceStartTimeRequest
     *        A JSON object containing the Amazon Resource Name (ARN) of the gateway.
     * @return A Java Future containing the result of the DescribeMaintenanceStartTime operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidGatewayRequestException An exception occurred because an invalid gateway request was issued to
     *         the service. For more information, see the error and message fields.</li>
     *         <li>InternalServerErrorException An internal server error has occurred during the request. For more
     *         information, see the error and message fields.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>StorageGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample StorageGatewayAsyncClient.DescribeMaintenanceStartTime
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeMaintenanceStartTime"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeMaintenanceStartTimeResponse> describeMaintenanceStartTime(
            DescribeMaintenanceStartTimeRequest describeMaintenanceStartTimeRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeMaintenanceStartTimeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeMaintenanceStartTime");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeMaintenanceStartTimeResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeMaintenanceStartTimeResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeMaintenanceStartTimeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeMaintenanceStartTimeRequest, DescribeMaintenanceStartTimeResponse>()
                            .withOperationName("DescribeMaintenanceStartTime")
                            .withMarshaller(new DescribeMaintenanceStartTimeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeMaintenanceStartTimeRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeMaintenanceStartTimeRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<DescribeMaintenanceStartTimeResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a description for one or more Network File System (NFS) file shares from an S3 File Gateway. This operation
     * is only supported for S3 File Gateways.
     * </p>
     *
     * @param describeNfsFileSharesRequest
     *        DescribeNFSFileSharesInput
     * @return A Java Future containing the result of the DescribeNFSFileShares operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidGatewayRequestException An exception occurred because an invalid gateway request was issued to
     *         the service. For more information, see the error and message fields.</li>
     *         <li>InternalServerErrorException An internal server error has occurred during the request. For more
     *         information, see the error and message fields.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>StorageGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample StorageGatewayAsyncClient.DescribeNFSFileShares
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeNFSFileShares"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeNfsFileSharesResponse> describeNFSFileShares(
            DescribeNfsFileSharesRequest describeNfsFileSharesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeNfsFileSharesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeNFSFileShares");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeNfsFileSharesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeNfsFileSharesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeNfsFileSharesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeNfsFileSharesRequest, DescribeNfsFileSharesResponse>()
                            .withOperationName("DescribeNFSFileShares")
                            .withMarshaller(new DescribeNfsFileSharesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeNfsFileSharesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeNfsFileSharesRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<DescribeNfsFileSharesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a description for one or more Server Message Block (SMB) file shares from a S3 File Gateway. This operation
     * is only supported for S3 File Gateways.
     * </p>
     *
     * @param describeSmbFileSharesRequest
     *        DescribeSMBFileSharesInput
     * @return A Java Future containing the result of the DescribeSMBFileShares operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidGatewayRequestException An exception occurred because an invalid gateway request was issued to
     *         the service. For more information, see the error and message fields.</li>
     *         <li>InternalServerErrorException An internal server error has occurred during the request. For more
     *         information, see the error and message fields.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>StorageGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample StorageGatewayAsyncClient.DescribeSMBFileShares
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeSMBFileShares"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeSmbFileSharesResponse> describeSMBFileShares(
            DescribeSmbFileSharesRequest describeSmbFileSharesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeSmbFileSharesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeSMBFileShares");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeSmbFileSharesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeSmbFileSharesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeSmbFileSharesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeSmbFileSharesRequest, DescribeSmbFileSharesResponse>()
                            .withOperationName("DescribeSMBFileShares")
                            .withMarshaller(new DescribeSmbFileSharesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeSmbFileSharesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeSmbFileSharesRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<DescribeSmbFileSharesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a description of a Server Message Block (SMB) file share settings from a file gateway. This operation is
     * only supported for file gateways.
     * </p>
     *
     * @param describeSmbSettingsRequest
     * @return A Java Future containing the result of the DescribeSMBSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidGatewayRequestException An exception occurred because an invalid gateway request was issued to
     *         the service. For more information, see the error and message fields.</li>
     *         <li>InternalServerErrorException An internal server error has occurred during the request. For more
     *         information, see the error and message fields.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>StorageGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample StorageGatewayAsyncClient.DescribeSMBSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeSMBSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeSmbSettingsResponse> describeSMBSettings(
            DescribeSmbSettingsRequest describeSmbSettingsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeSmbSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeSMBSettings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeSmbSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeSmbSettingsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeSmbSettingsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeSmbSettingsRequest, DescribeSmbSettingsResponse>()
                            .withOperationName("DescribeSMBSettings")
                            .withMarshaller(new DescribeSmbSettingsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeSmbSettingsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeSmbSettingsRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<DescribeSmbSettingsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the snapshot schedule for the specified gateway volume. The snapshot schedule information includes
     * intervals at which snapshots are automatically initiated on the volume. This operation is only supported in the
     * cached volume and stored volume types.
     * </p>
     *
     * @param describeSnapshotScheduleRequest
     *        A JSON object containing the <a>DescribeSnapshotScheduleInput&#36VolumeARN</a> of the volume.
     * @return A Java Future containing the result of the DescribeSnapshotSchedule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidGatewayRequestException An exception occurred because an invalid gateway request was issued to
     *         the service. For more information, see the error and message fields.</li>
     *         <li>InternalServerErrorException An internal server error has occurred during the request. For more
     *         information, see the error and message fields.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>StorageGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample StorageGatewayAsyncClient.DescribeSnapshotSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeSnapshotSchedule"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeSnapshotScheduleResponse> describeSnapshotSchedule(
            DescribeSnapshotScheduleRequest describeSnapshotScheduleRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeSnapshotScheduleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeSnapshotSchedule");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeSnapshotScheduleResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeSnapshotScheduleResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeSnapshotScheduleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeSnapshotScheduleRequest, DescribeSnapshotScheduleResponse>()
                            .withOperationName("DescribeSnapshotSchedule")
                            .withMarshaller(new DescribeSnapshotScheduleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeSnapshotScheduleRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeSnapshotScheduleRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<DescribeSnapshotScheduleResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the description of the gateway volumes specified in the request. The list of gateway volumes in the
     * request must be from one gateway. In the response, Storage Gateway returns volume information sorted by volume
     * ARNs. This operation is only supported in stored volume gateway type.
     * </p>
     *
     * @param describeStorediScsiVolumesRequest
     *        A JSON object containing a list of <a>DescribeStorediSCSIVolumesInput&#36VolumeARNs</a>.
     * @return A Java Future containing the result of the DescribeStorediSCSIVolumes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidGatewayRequestException An exception occurred because an invalid gateway request was issued to
     *         the service. For more information, see the error and message fields.</li>
     *         <li>InternalServerErrorException An internal server error has occurred during the request. For more
     *         information, see the error and message fields.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>StorageGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample StorageGatewayAsyncClient.DescribeStorediSCSIVolumes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeStorediSCSIVolumes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeStorediScsiVolumesResponse> describeStorediSCSIVolumes(
            DescribeStorediScsiVolumesRequest describeStorediScsiVolumesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeStorediScsiVolumesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeStorediSCSIVolumes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeStorediScsiVolumesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeStorediScsiVolumesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeStorediScsiVolumesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeStorediScsiVolumesRequest, DescribeStorediScsiVolumesResponse>()
                            .withOperationName("DescribeStorediSCSIVolumes")
                            .withMarshaller(new DescribeStorediScsiVolumesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeStorediScsiVolumesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeStorediScsiVolumesRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<DescribeStorediScsiVolumesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a description of specified virtual tapes in the virtual tape shelf (VTS). This operation is only
     * supported in the tape gateway type.
     * </p>
     * <p>
     * If a specific <code>TapeARN</code> is not specified, Storage Gateway returns a description of all virtual tapes
     * found in the VTS associated with your account.
     * </p>
     *
     * @param describeTapeArchivesRequest
     *        DescribeTapeArchivesInput
     * @return A Java Future containing the result of the DescribeTapeArchives operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidGatewayRequestException An exception occurred because an invalid gateway request was issued to
     *         the service. For more information, see the error and message fields.</li>
     *         <li>InternalServerErrorException An internal server error has occurred during the request. For more
     *         information, see the error and message fields.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>StorageGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample StorageGatewayAsyncClient.DescribeTapeArchives
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeTapeArchives"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeTapeArchivesResponse> describeTapeArchives(
            DescribeTapeArchivesRequest describeTapeArchivesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeTapeArchivesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeTapeArchives");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeTapeArchivesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeTapeArchivesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeTapeArchivesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeTapeArchivesRequest, DescribeTapeArchivesResponse>()
                            .withOperationName("DescribeTapeArchives")
                            .withMarshaller(new DescribeTapeArchivesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeTapeArchivesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeTapeArchivesRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<DescribeTapeArchivesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a description of specified virtual tapes in the virtual tape shelf (VTS). This operation is only
     * supported in the tape gateway type.
     * </p>
     * <p>
     * If a specific <code>TapeARN</code> is not specified, Storage Gateway returns a description of all virtual tapes
     * found in the VTS associated with your account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeTapeArchives(software.amazon.awssdk.services.storagegateway.model.DescribeTapeArchivesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.storagegateway.paginators.DescribeTapeArchivesPublisher publisher = client.describeTapeArchivesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.storagegateway.paginators.DescribeTapeArchivesPublisher publisher = client.describeTapeArchivesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.storagegateway.model.DescribeTapeArchivesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.storagegateway.model.DescribeTapeArchivesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeTapeArchives(software.amazon.awssdk.services.storagegateway.model.DescribeTapeArchivesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeTapeArchivesRequest
     *        DescribeTapeArchivesInput
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidGatewayRequestException An exception occurred because an invalid gateway request was issued to
     *         the service. For more information, see the error and message fields.</li>
     *         <li>InternalServerErrorException An internal server error has occurred during the request. For more
     *         information, see the error and message fields.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>StorageGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample StorageGatewayAsyncClient.DescribeTapeArchives
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeTapeArchives"
     *      target="_top">AWS API Documentation</a>
     */
    public DescribeTapeArchivesPublisher describeTapeArchivesPaginator(DescribeTapeArchivesRequest describeTapeArchivesRequest) {
        return new DescribeTapeArchivesPublisher(this, applyPaginatorUserAgent(describeTapeArchivesRequest));
    }

    /**
     * <p>
     * Returns a list of virtual tape recovery points that are available for the specified tape gateway.
     * </p>
     * <p>
     * A recovery point is a point-in-time view of a virtual tape at which all the data on the virtual tape is
     * consistent. If your gateway crashes, virtual tapes that have recovery points can be recovered to a new gateway.
     * This operation is only supported in the tape gateway type.
     * </p>
     *
     * @param describeTapeRecoveryPointsRequest
     *        DescribeTapeRecoveryPointsInput
     * @return A Java Future containing the result of the DescribeTapeRecoveryPoints operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidGatewayRequestException An exception occurred because an invalid gateway request was issued to
     *         the service. For more information, see the error and message fields.</li>
     *         <li>InternalServerErrorException An internal server error has occurred during the request. For more
     *         information, see the error and message fields.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>StorageGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample StorageGatewayAsyncClient.DescribeTapeRecoveryPoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeTapeRecoveryPoints"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeTapeRecoveryPointsResponse> describeTapeRecoveryPoints(
            DescribeTapeRecoveryPointsRequest describeTapeRecoveryPointsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeTapeRecoveryPointsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeTapeRecoveryPoints");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeTapeRecoveryPointsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeTapeRecoveryPointsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeTapeRecoveryPointsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeTapeRecoveryPointsRequest, DescribeTapeRecoveryPointsResponse>()
                            .withOperationName("DescribeTapeRecoveryPoints")
                            .withMarshaller(new DescribeTapeRecoveryPointsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeTapeRecoveryPointsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeTapeRecoveryPointsRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<DescribeTapeRecoveryPointsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of virtual tape recovery points that are available for the specified tape gateway.
     * </p>
     * <p>
     * A recovery point is a point-in-time view of a virtual tape at which all the data on the virtual tape is
     * consistent. If your gateway crashes, virtual tapes that have recovery points can be recovered to a new gateway.
     * This operation is only supported in the tape gateway type.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeTapeRecoveryPoints(software.amazon.awssdk.services.storagegateway.model.DescribeTapeRecoveryPointsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.storagegateway.paginators.DescribeTapeRecoveryPointsPublisher publisher = client.describeTapeRecoveryPointsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.storagegateway.paginators.DescribeTapeRecoveryPointsPublisher publisher = client.describeTapeRecoveryPointsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.storagegateway.model.DescribeTapeRecoveryPointsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.storagegateway.model.DescribeTapeRecoveryPointsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeTapeRecoveryPoints(software.amazon.awssdk.services.storagegateway.model.DescribeTapeRecoveryPointsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeTapeRecoveryPointsRequest
     *        DescribeTapeRecoveryPointsInput
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidGatewayRequestException An exception occurred because an invalid gateway request was issued to
     *         the service. For more information, see the error and message fields.</li>
     *         <li>InternalServerErrorException An internal server error has occurred during the request. For more
     *         information, see the error and message fields.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>StorageGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample StorageGatewayAsyncClient.DescribeTapeRecoveryPoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeTapeRecoveryPoints"
     *      target="_top">AWS API Documentation</a>
     */
    public DescribeTapeRecoveryPointsPublisher describeTapeRecoveryPointsPaginator(
            DescribeTapeRecoveryPointsRequest describeTapeRecoveryPointsRequest) {
        return new DescribeTapeRecoveryPointsPublisher(this, applyPaginatorUserAgent(describeTapeRecoveryPointsRequest));
    }

    /**
     * <p>
     * Returns a description of the specified Amazon Resource Name (ARN) of virtual tapes. If a <code>TapeARN</code> is
     * not specified, returns a description of all virtual tapes associated with the specified gateway. This operation
     * is only supported in the tape gateway type.
     * </p>
     *
     * @param describeTapesRequest
     *        DescribeTapesInput
     * @return A Java Future containing the result of the DescribeTapes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidGatewayRequestException An exception occurred because an invalid gateway request was issued to
     *         the service. For more information, see the error and message fields.</li>
     *         <li>InternalServerErrorException An internal server error has occurred during the request. For more
     *         information, see the error and message fields.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>StorageGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample StorageGatewayAsyncClient.DescribeTapes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeTapes" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeTapesResponse> describeTapes(DescribeTapesRequest describeTapesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeTapesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeTapes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeTapesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DescribeTapesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeTapesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeTapesRequest, DescribeTapesResponse>()
                            .withOperationName("DescribeTapes")
                            .withMarshaller(new DescribeTapesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeTapesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeTapesRequest.overrideConfiguration().orElse(null);
            CompletableFuture<DescribeTapesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a description of the specified Amazon Resource Name (ARN) of virtual tapes. If a <code>TapeARN</code> is
     * not specified, returns a description of all virtual tapes associated with the specified gateway. This operation
     * is only supported in the tape gateway type.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeTapes(software.amazon.awssdk.services.storagegateway.model.DescribeTapesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.storagegateway.paginators.DescribeTapesPublisher publisher = client.describeTapesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.storagegateway.paginators.DescribeTapesPublisher publisher = client.describeTapesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.storagegateway.model.DescribeTapesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.storagegateway.model.DescribeTapesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeTapes(software.amazon.awssdk.services.storagegateway.model.DescribeTapesRequest)} operation.</b>
     * </p>
     *
     * @param describeTapesRequest
     *        DescribeTapesInput
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidGatewayRequestException An exception occurred because an invalid gateway request was issued to
     *         the service. For more information, see the error and message fields.</li>
     *         <li>InternalServerErrorException An internal server error has occurred during the request. For more
     *         information, see the error and message fields.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>StorageGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample StorageGatewayAsyncClient.DescribeTapes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeTapes" target="_top">AWS
     *      API Documentation</a>
     */
    public DescribeTapesPublisher describeTapesPaginator(DescribeTapesRequest describeTapesRequest) {
        return new DescribeTapesPublisher(this, applyPaginatorUserAgent(describeTapesRequest));
    }

    /**
     * <p>
     * Returns information about the upload buffer of a gateway. This operation is supported for the stored volume,
     * cached volume, and tape gateway types.
     * </p>
     * <p>
     * The response includes disk IDs that are configured as upload buffer space, and it includes the amount of upload
     * buffer space allocated and used.
     * </p>
     *
     * @param describeUploadBufferRequest
     * @return A Java Future containing the result of the DescribeUploadBuffer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidGatewayRequestException An exception occurred because an invalid gateway request was issued to
     *         the service. For more information, see the error and message fields.</li>
     *         <li>InternalServerErrorException An internal server error has occurred during the request. For more
     *         information, see the error and message fields.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>StorageGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample StorageGatewayAsyncClient.DescribeUploadBuffer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeUploadBuffer"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeUploadBufferResponse> describeUploadBuffer(
            DescribeUploadBufferRequest describeUploadBufferRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeUploadBufferRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeUploadBuffer");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeUploadBufferResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeUploadBufferResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeUploadBufferResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeUploadBufferRequest, DescribeUploadBufferResponse>()
                            .withOperationName("DescribeUploadBuffer")
                            .withMarshaller(new DescribeUploadBufferRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeUploadBufferRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeUploadBufferRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<DescribeUploadBufferResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a description of virtual tape library (VTL) devices for the specified tape gateway. In the response,
     * Storage Gateway returns VTL device information.
     * </p>
     * <p>
     * This operation is only supported in the tape gateway type.
     * </p>
     *
     * @param describeVtlDevicesRequest
     *        DescribeVTLDevicesInput
     * @return A Java Future containing the result of the DescribeVTLDevices operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidGatewayRequestException An exception occurred because an invalid gateway request was issued to
     *         the service. For more information, see the error and message fields.</li>
     *         <li>InternalServerErrorException An internal server error has occurred during the request. For more
     *         information, see the error and message fields.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>StorageGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample StorageGatewayAsyncClient.DescribeVTLDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeVTLDevices"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeVtlDevicesResponse> describeVTLDevices(DescribeVtlDevicesRequest describeVtlDevicesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeVtlDevicesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeVTLDevices");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeVtlDevicesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeVtlDevicesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeVtlDevicesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeVtlDevicesRequest, DescribeVtlDevicesResponse>()
                            .withOperationName("DescribeVTLDevices")
                            .withMarshaller(new DescribeVtlDevicesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeVtlDevicesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeVtlDevicesRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<DescribeVtlDevicesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a description of virtual tape library (VTL) devices for the specified tape gateway. In the response,
     * Storage Gateway returns VTL device information.
     * </p>
     * <p>
     * This operation is only supported in the tape gateway type.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeVTLDevices(software.amazon.awssdk.services.storagegateway.model.DescribeVtlDevicesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.storagegateway.paginators.DescribeVTLDevicesPublisher publisher = client.describeVTLDevicesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.storagegateway.paginators.DescribeVTLDevicesPublisher publisher = client.describeVTLDevicesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.storagegateway.model.DescribeVtlDevicesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.storagegateway.model.DescribeVtlDevicesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeVTLDevices(software.amazon.awssdk.services.storagegateway.model.DescribeVtlDevicesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeVtlDevicesRequest
     *        DescribeVTLDevicesInput
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidGatewayRequestException An exception occurred because an invalid gateway request was issued to
     *         the service. For more information, see the error and message fields.</li>
     *         <li>InternalServerErrorException An internal server error has occurred during the request. For more
     *         information, see the error and message fields.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>StorageGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample StorageGatewayAsyncClient.DescribeVTLDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeVTLDevices"
     *      target="_top">AWS API Documentation</a>
     */
    public DescribeVTLDevicesPublisher describeVTLDevicesPaginator(DescribeVtlDevicesRequest describeVtlDevicesRequest) {
        return new DescribeVTLDevicesPublisher(this, applyPaginatorUserAgent(describeVtlDevicesRequest));
    }

    /**
     * <p>
     * Returns information about the working storage of a gateway. This operation is only supported in the stored
     * volumes gateway type. This operation is deprecated in cached volumes API version (20120630). Use
     * DescribeUploadBuffer instead.
     * </p>
     * <note>
     * <p>
     * Working storage is also referred to as upload buffer. You can also use the DescribeUploadBuffer operation to add
     * upload buffer to a stored volume gateway.
     * </p>
     * </note>
     * <p>
     * The response includes disk IDs that are configured as working storage, and it includes the amount of working
     * storage allocated and used.
     * </p>
     *
     * @param describeWorkingStorageRequest
     *        A JSON object containing the Amazon Resource Name (ARN) of the gateway.
     * @return A Java Future containing the result of the DescribeWorkingStorage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidGatewayRequestException An exception occurred because an invalid gateway request was issued to
     *         the service. For more information, see the error and message fields.</li>
     *         <li>InternalServerErrorException An internal server error has occurred during the request. For more
     *         information, see the error and message fields.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>StorageGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample StorageGatewayAsyncClient.DescribeWorkingStorage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeWorkingStorage"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeWorkingStorageResponse> describeWorkingStorage(
            DescribeWorkingStorageRequest describeWorkingStorageRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeWorkingStorageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeWorkingStorage");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeWorkingStorageResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeWorkingStorageResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeWorkingStorageResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeWorkingStorageRequest, DescribeWorkingStorageResponse>()
                            .withOperationName("DescribeWorkingStorage")
                            .withMarshaller(new DescribeWorkingStorageRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeWorkingStorageRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeWorkingStorageRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<DescribeWorkingStorageResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Disconnects a volume from an iSCSI connection and then detaches the volume from the specified gateway. Detaching
     * and attaching a volume enables you to recover your data from one gateway to a different gateway without creating
     * a snapshot. It also makes it easier to move your volumes from an on-premises gateway to a gateway hosted on an
     * Amazon EC2 instance. This operation is only supported in the volume gateway type.
     * </p>
     *
     * @param detachVolumeRequest
     *        AttachVolumeInput
     * @return A Java Future containing the result of the DetachVolume operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidGatewayRequestException An exception occurred because an invalid gateway request was issued to
     *         the service. For more information, see the error and message fields.</li>
     *         <li>InternalServerErrorException An internal server error has occurred during the request. For more
     *         information, see the error and message fields.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>StorageGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample StorageGatewayAsyncClient.DetachVolume
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DetachVolume" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DetachVolumeResponse> detachVolume(DetachVolumeRequest detachVolumeRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, detachVolumeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DetachVolume");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DetachVolumeResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DetachVolumeResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DetachVolumeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DetachVolumeRequest, DetachVolumeResponse>()
                            .withOperationName("DetachVolume").withMarshaller(new DetachVolumeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(detachVolumeRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = detachVolumeRequest.overrideConfiguration().orElse(null);
            CompletableFuture<DetachVolumeResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Disables a tape gateway when the gateway is no longer functioning. For example, if your gateway VM is damaged,
     * you can disable the gateway so you can recover virtual tapes.
     * </p>
     * <p>
     * Use this operation for a tape gateway that is not reachable or not functioning. This operation is only supported
     * in the tape gateway type.
     * </p>
     * <important>
     * <p>
     * After a gateway is disabled, it cannot be enabled.
     * </p>
     * </important>
     *
     * @param disableGatewayRequest
     *        DisableGatewayInput
     * @return A Java Future containing the result of the DisableGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidGatewayRequestException An exception occurred because an invalid gateway request was issued to
     *         the service. For more information, see the error and message fields.</li>
     *         <li>InternalServerErrorException An internal server error has occurred during the request. For more
     *         information, see the error and message fields.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>StorageGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample StorageGatewayAsyncClient.DisableGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DisableGateway" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DisableGatewayResponse> disableGateway(DisableGatewayRequest disableGatewayRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, disableGatewayRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisableGateway");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DisableGatewayResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DisableGatewayResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DisableGatewayResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DisableGatewayRequest, DisableGatewayResponse>()
                            .withOperationName("DisableGateway")
                            .withMarshaller(new DisableGatewayRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(disableGatewayRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = disableGatewayRequest.overrideConfiguration().orElse(null);
            CompletableFuture<DisableGatewayResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Disassociates an Amazon FSx file system from the specified gateway. After the disassociation process finishes,
     * the gateway can no longer access the Amazon FSx file system. This operation is only supported in the FSx File
     * Gateway type.
     * </p>
     *
     * @param disassociateFileSystemRequest
     * @return A Java Future containing the result of the DisassociateFileSystem operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidGatewayRequestException An exception occurred because an invalid gateway request was issued to
     *         the service. For more information, see the error and message fields.</li>
     *         <li>InternalServerErrorException An internal server error has occurred during the request. For more
     *         information, see the error and message fields.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>StorageGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample StorageGatewayAsyncClient.DisassociateFileSystem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DisassociateFileSystem"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DisassociateFileSystemResponse> disassociateFileSystem(
            DisassociateFileSystemRequest disassociateFileSystemRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, disassociateFileSystemRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociateFileSystem");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DisassociateFileSystemResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DisassociateFileSystemResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DisassociateFileSystemResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DisassociateFileSystemRequest, DisassociateFileSystemResponse>()
                            .withOperationName("DisassociateFileSystem")
                            .withMarshaller(new DisassociateFileSystemRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(disassociateFileSystemRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = disassociateFileSystemRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<DisassociateFileSystemResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds a file gateway to an Active Directory domain. This operation is only supported for file gateways that
     * support the SMB file protocol.
     * </p>
     *
     * @param joinDomainRequest
     *        JoinDomainInput
     * @return A Java Future containing the result of the JoinDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidGatewayRequestException An exception occurred because an invalid gateway request was issued to
     *         the service. For more information, see the error and message fields.</li>
     *         <li>InternalServerErrorException An internal server error has occurred during the request. For more
     *         information, see the error and message fields.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>StorageGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample StorageGatewayAsyncClient.JoinDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/JoinDomain" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<JoinDomainResponse> joinDomain(JoinDomainRequest joinDomainRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, joinDomainRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "JoinDomain");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<JoinDomainResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    JoinDomainResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<JoinDomainResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<JoinDomainRequest, JoinDomainResponse>().withOperationName("JoinDomain")
                            .withMarshaller(new JoinDomainRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(joinDomainRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = joinDomainRequest.overrideConfiguration().orElse(null);
            CompletableFuture<JoinDomainResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the automatic tape creation policies for a gateway. If there are no automatic tape creation policies for
     * the gateway, it returns an empty list.
     * </p>
     * <p>
     * This operation is only supported for tape gateways.
     * </p>
     *
     * @param listAutomaticTapeCreationPoliciesRequest
     * @return A Java Future containing the result of the ListAutomaticTapeCreationPolicies operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidGatewayRequestException An exception occurred because an invalid gateway request was issued to
     *         the service. For more information, see the error and message fields.</li>
     *         <li>InternalServerErrorException An internal server error has occurred during the request. For more
     *         information, see the error and message fields.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>StorageGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample StorageGatewayAsyncClient.ListAutomaticTapeCreationPolicies
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ListAutomaticTapeCreationPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListAutomaticTapeCreationPoliciesResponse> listAutomaticTapeCreationPolicies(
            ListAutomaticTapeCreationPoliciesRequest listAutomaticTapeCreationPoliciesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listAutomaticTapeCreationPoliciesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAutomaticTapeCreationPolicies");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListAutomaticTapeCreationPoliciesResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, ListAutomaticTapeCreationPoliciesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListAutomaticTapeCreationPoliciesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListAutomaticTapeCreationPoliciesRequest, ListAutomaticTapeCreationPoliciesResponse>()
                            .withOperationName("ListAutomaticTapeCreationPolicies")
                            .withMarshaller(new ListAutomaticTapeCreationPoliciesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listAutomaticTapeCreationPoliciesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listAutomaticTapeCreationPoliciesRequest
                    .overrideConfiguration().orElse(null);
            CompletableFuture<ListAutomaticTapeCreationPoliciesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a list of the file shares for a specific S3 File Gateway, or the list of file shares that belong to the
     * calling user account. This operation is only supported for S3 File Gateways.
     * </p>
     *
     * @param listFileSharesRequest
     *        ListFileShareInput
     * @return A Java Future containing the result of the ListFileShares operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidGatewayRequestException An exception occurred because an invalid gateway request was issued to
     *         the service. For more information, see the error and message fields.</li>
     *         <li>InternalServerErrorException An internal server error has occurred during the request. For more
     *         information, see the error and message fields.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>StorageGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample StorageGatewayAsyncClient.ListFileShares
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ListFileShares" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListFileSharesResponse> listFileShares(ListFileSharesRequest listFileSharesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listFileSharesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListFileShares");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListFileSharesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListFileSharesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListFileSharesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListFileSharesRequest, ListFileSharesResponse>()
                            .withOperationName("ListFileShares")
                            .withMarshaller(new ListFileSharesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listFileSharesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listFileSharesRequest.overrideConfiguration().orElse(null);
            CompletableFuture<ListFileSharesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a list of the file shares for a specific S3 File Gateway, or the list of file shares that belong to the
     * calling user account. This operation is only supported for S3 File Gateways.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listFileShares(software.amazon.awssdk.services.storagegateway.model.ListFileSharesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.storagegateway.paginators.ListFileSharesPublisher publisher = client.listFileSharesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.storagegateway.paginators.ListFileSharesPublisher publisher = client.listFileSharesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.storagegateway.model.ListFileSharesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.storagegateway.model.ListFileSharesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFileShares(software.amazon.awssdk.services.storagegateway.model.ListFileSharesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listFileSharesRequest
     *        ListFileShareInput
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidGatewayRequestException An exception occurred because an invalid gateway request was issued to
     *         the service. For more information, see the error and message fields.</li>
     *         <li>InternalServerErrorException An internal server error has occurred during the request. For more
     *         information, see the error and message fields.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>StorageGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample StorageGatewayAsyncClient.ListFileShares
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ListFileShares" target="_top">AWS
     *      API Documentation</a>
     */
    public ListFileSharesPublisher listFileSharesPaginator(ListFileSharesRequest listFileSharesRequest) {
        return new ListFileSharesPublisher(this, applyPaginatorUserAgent(listFileSharesRequest));
    }

    /**
     * <p>
     * Gets a list of <code>FileSystemAssociationSummary</code> objects. Each object contains a summary of a file system
     * association. This operation is only supported for FSx File Gateways.
     * </p>
     *
     * @param listFileSystemAssociationsRequest
     * @return A Java Future containing the result of the ListFileSystemAssociations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidGatewayRequestException An exception occurred because an invalid gateway request was issued to
     *         the service. For more information, see the error and message fields.</li>
     *         <li>InternalServerErrorException An internal server error has occurred during the request. For more
     *         information, see the error and message fields.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>StorageGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample StorageGatewayAsyncClient.ListFileSystemAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ListFileSystemAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListFileSystemAssociationsResponse> listFileSystemAssociations(
            ListFileSystemAssociationsRequest listFileSystemAssociationsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listFileSystemAssociationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListFileSystemAssociations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListFileSystemAssociationsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListFileSystemAssociationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListFileSystemAssociationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListFileSystemAssociationsRequest, ListFileSystemAssociationsResponse>()
                            .withOperationName("ListFileSystemAssociations")
                            .withMarshaller(new ListFileSystemAssociationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listFileSystemAssociationsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listFileSystemAssociationsRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<ListFileSystemAssociationsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a list of <code>FileSystemAssociationSummary</code> objects. Each object contains a summary of a file system
     * association. This operation is only supported for FSx File Gateways.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listFileSystemAssociations(software.amazon.awssdk.services.storagegateway.model.ListFileSystemAssociationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.storagegateway.paginators.ListFileSystemAssociationsPublisher publisher = client.listFileSystemAssociationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.storagegateway.paginators.ListFileSystemAssociationsPublisher publisher = client.listFileSystemAssociationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.storagegateway.model.ListFileSystemAssociationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.storagegateway.model.ListFileSystemAssociationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFileSystemAssociations(software.amazon.awssdk.services.storagegateway.model.ListFileSystemAssociationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listFileSystemAssociationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidGatewayRequestException An exception occurred because an invalid gateway request was issued to
     *         the service. For more information, see the error and message fields.</li>
     *         <li>InternalServerErrorException An internal server error has occurred during the request. For more
     *         information, see the error and message fields.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>StorageGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample StorageGatewayAsyncClient.ListFileSystemAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ListFileSystemAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    public ListFileSystemAssociationsPublisher listFileSystemAssociationsPaginator(
            ListFileSystemAssociationsRequest listFileSystemAssociationsRequest) {
        return new ListFileSystemAssociationsPublisher(this, applyPaginatorUserAgent(listFileSystemAssociationsRequest));
    }

    /**
     * <p>
     * Lists gateways owned by an Amazon Web Services account in an Amazon Web Services Region specified in the request.
     * The returned list is ordered by gateway Amazon Resource Name (ARN).
     * </p>
     * <p>
     * By default, the operation returns a maximum of 100 gateways. This operation supports pagination that allows you
     * to optionally reduce the number of gateways returned in a response.
     * </p>
     * <p>
     * If you have more gateways than are returned in a response (that is, the response returns only a truncated list of
     * your gateways), the response contains a marker that you can specify in your next request to fetch the next page
     * of gateways.
     * </p>
     *
     * @param listGatewaysRequest
     *        A JSON object containing zero or more of the following fields:</p>
     *        <ul>
     *        <li>
     *        <p>
     *        <a>ListGatewaysInput&#36Limit</a>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <a>ListGatewaysInput&#36Marker</a>
     *        </p>
     *        </li>
     * @return A Java Future containing the result of the ListGateways operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidGatewayRequestException An exception occurred because an invalid gateway request was issued to
     *         the service. For more information, see the error and message fields.</li>
     *         <li>InternalServerErrorException An internal server error has occurred during the request. For more
     *         information, see the error and message fields.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>StorageGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample StorageGatewayAsyncClient.ListGateways
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ListGateways" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListGatewaysResponse> listGateways(ListGatewaysRequest listGatewaysRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listGatewaysRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListGateways");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListGatewaysResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListGatewaysResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListGatewaysResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListGatewaysRequest, ListGatewaysResponse>()
                            .withOperationName("ListGateways").withMarshaller(new ListGatewaysRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listGatewaysRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listGatewaysRequest.overrideConfiguration().orElse(null);
            CompletableFuture<ListGatewaysResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists gateways owned by an Amazon Web Services account in an Amazon Web Services Region specified in the request.
     * The returned list is ordered by gateway Amazon Resource Name (ARN).
     * </p>
     * <p>
     * By default, the operation returns a maximum of 100 gateways. This operation supports pagination that allows you
     * to optionally reduce the number of gateways returned in a response.
     * </p>
     * <p>
     * If you have more gateways than are returned in a response (that is, the response returns only a truncated list of
     * your gateways), the response contains a marker that you can specify in your next request to fetch the next page
     * of gateways.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listGateways(software.amazon.awssdk.services.storagegateway.model.ListGatewaysRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.storagegateway.paginators.ListGatewaysPublisher publisher = client.listGatewaysPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.storagegateway.paginators.ListGatewaysPublisher publisher = client.listGatewaysPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.storagegateway.model.ListGatewaysResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.storagegateway.model.ListGatewaysResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGateways(software.amazon.awssdk.services.storagegateway.model.ListGatewaysRequest)} operation.</b>
     * </p>
     *
     * @param listGatewaysRequest
     *        A JSON object containing zero or more of the following fields:</p>
     *        <ul>
     *        <li>
     *        <p>
     *        <a>ListGatewaysInput&#36Limit</a>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <a>ListGatewaysInput&#36Marker</a>
     *        </p>
     *        </li>
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidGatewayRequestException An exception occurred because an invalid gateway request was issued to
     *         the service. For more information, see the error and message fields.</li>
     *         <li>InternalServerErrorException An internal server error has occurred during the request. For more
     *         information, see the error and message fields.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>StorageGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample StorageGatewayAsyncClient.ListGateways
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ListGateways" target="_top">AWS
     *      API Documentation</a>
     */
    public ListGatewaysPublisher listGatewaysPaginator(ListGatewaysRequest listGatewaysRequest) {
        return new ListGatewaysPublisher(this, applyPaginatorUserAgent(listGatewaysRequest));
    }

    /**
     * <p>
     * Returns a list of the gateway's local disks. To specify which gateway to describe, you use the Amazon Resource
     * Name (ARN) of the gateway in the body of the request.
     * </p>
     * <p>
     * The request returns a list of all disks, specifying which are configured as working storage, cache storage, or
     * stored volume or not configured at all. The response includes a <code>DiskStatus</code> field. This field can
     * have a value of present (the disk is available to use), missing (the disk is no longer connected to the gateway),
     * or mismatch (the disk node is occupied by a disk that has incorrect metadata or the disk content is corrupted).
     * </p>
     *
     * @param listLocalDisksRequest
     *        A JSON object containing the Amazon Resource Name (ARN) of the gateway.
     * @return A Java Future containing the result of the ListLocalDisks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidGatewayRequestException An exception occurred because an invalid gateway request was issued to
     *         the service. For more information, see the error and message fields.</li>
     *         <li>InternalServerErrorException An internal server error has occurred during the request. For more
     *         information, see the error and message fields.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>StorageGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample StorageGatewayAsyncClient.ListLocalDisks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ListLocalDisks" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListLocalDisksResponse> listLocalDisks(ListLocalDisksRequest listLocalDisksRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listLocalDisksRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListLocalDisks");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListLocalDisksResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListLocalDisksResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListLocalDisksResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListLocalDisksRequest, ListLocalDisksResponse>()
                            .withOperationName("ListLocalDisks")
                            .withMarshaller(new ListLocalDisksRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listLocalDisksRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listLocalDisksRequest.overrideConfiguration().orElse(null);
            CompletableFuture<ListLocalDisksResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the tags that have been added to the specified resource. This operation is supported in storage gateways of
     * all types.
     * </p>
     *
     * @param listTagsForResourceRequest
     *        ListTagsForResourceInput
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidGatewayRequestException An exception occurred because an invalid gateway request was issued to
     *         the service. For more information, see the error and message fields.</li>
     *         <li>InternalServerErrorException An internal server error has occurred during the request. For more
     *         information, see the error and message fields.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>StorageGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample StorageGatewayAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListTagsForResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListTagsForResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                            .withOperationName("ListTagsForResource")
                            .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listTagsForResourceRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listTagsForResourceRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<ListTagsForResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the tags that have been added to the specified resource. This operation is supported in storage gateways of
     * all types.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTagsForResource(software.amazon.awssdk.services.storagegateway.model.ListTagsForResourceRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.storagegateway.paginators.ListTagsForResourcePublisher publisher = client.listTagsForResourcePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.storagegateway.paginators.ListTagsForResourcePublisher publisher = client.listTagsForResourcePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.storagegateway.model.ListTagsForResourceResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.storagegateway.model.ListTagsForResourceResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTagsForResource(software.amazon.awssdk.services.storagegateway.model.ListTagsForResourceRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTagsForResourceRequest
     *        ListTagsForResourceInput
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidGatewayRequestException An exception occurred because an invalid gateway request was issued to
     *         the service. For more information, see the error and message fields.</li>
     *         <li>InternalServerErrorException An internal server error has occurred during the request. For more
     *         information, see the error and message fields.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>StorageGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample StorageGatewayAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    public ListTagsForResourcePublisher listTagsForResourcePaginator(ListTagsForResourceRequest listTagsForResourceRequest) {
        return new ListTagsForResourcePublisher(this, applyPaginatorUserAgent(listTagsForResourceRequest));
    }

    /**
     * <p>
     * Lists custom tape pools. You specify custom tape pools to list by specifying one or more custom tape pool Amazon
     * Resource Names (ARNs). If you don't specify a custom tape pool ARN, the operation lists all custom tape pools.
     * </p>
     * <p>
     * This operation supports pagination. You can optionally specify the <code>Limit</code> parameter in the body to
     * limit the number of tape pools in the response. If the number of tape pools returned in the response is
     * truncated, the response includes a <code>Marker</code> element that you can use in your subsequent request to
     * retrieve the next set of tape pools.
     * </p>
     *
     * @param listTapePoolsRequest
     * @return A Java Future containing the result of the ListTapePools operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidGatewayRequestException An exception occurred because an invalid gateway request was issued to
     *         the service. For more information, see the error and message fields.</li>
     *         <li>InternalServerErrorException An internal server error has occurred during the request. For more
     *         information, see the error and message fields.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>StorageGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample StorageGatewayAsyncClient.ListTapePools
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ListTapePools" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListTapePoolsResponse> listTapePools(ListTapePoolsRequest listTapePoolsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTapePoolsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTapePools");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListTapePoolsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListTapePoolsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListTapePoolsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListTapePoolsRequest, ListTapePoolsResponse>()
                            .withOperationName("ListTapePools")
                            .withMarshaller(new ListTapePoolsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listTapePoolsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listTapePoolsRequest.overrideConfiguration().orElse(null);
            CompletableFuture<ListTapePoolsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists custom tape pools. You specify custom tape pools to list by specifying one or more custom tape pool Amazon
     * Resource Names (ARNs). If you don't specify a custom tape pool ARN, the operation lists all custom tape pools.
     * </p>
     * <p>
     * This operation supports pagination. You can optionally specify the <code>Limit</code> parameter in the body to
     * limit the number of tape pools in the response. If the number of tape pools returned in the response is
     * truncated, the response includes a <code>Marker</code> element that you can use in your subsequent request to
     * retrieve the next set of tape pools.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTapePools(software.amazon.awssdk.services.storagegateway.model.ListTapePoolsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.storagegateway.paginators.ListTapePoolsPublisher publisher = client.listTapePoolsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.storagegateway.paginators.ListTapePoolsPublisher publisher = client.listTapePoolsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.storagegateway.model.ListTapePoolsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.storagegateway.model.ListTapePoolsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTapePools(software.amazon.awssdk.services.storagegateway.model.ListTapePoolsRequest)} operation.</b>
     * </p>
     *
     * @param listTapePoolsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidGatewayRequestException An exception occurred because an invalid gateway request was issued to
     *         the service. For more information, see the error and message fields.</li>
     *         <li>InternalServerErrorException An internal server error has occurred during the request. For more
     *         information, see the error and message fields.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>StorageGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample StorageGatewayAsyncClient.ListTapePools
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ListTapePools" target="_top">AWS
     *      API Documentation</a>
     */
    public ListTapePoolsPublisher listTapePoolsPaginator(ListTapePoolsRequest listTapePoolsRequest) {
        return new ListTapePoolsPublisher(this, applyPaginatorUserAgent(listTapePoolsRequest));
    }

    /**
     * <p>
     * Lists virtual tapes in your virtual tape library (VTL) and your virtual tape shelf (VTS). You specify the tapes
     * to list by specifying one or more tape Amazon Resource Names (ARNs). If you don't specify a tape ARN, the
     * operation lists all virtual tapes in both your VTL and VTS.
     * </p>
     * <p>
     * This operation supports pagination. By default, the operation returns a maximum of up to 100 tapes. You can
     * optionally specify the <code>Limit</code> parameter in the body to limit the number of tapes in the response. If
     * the number of tapes returned in the response is truncated, the response includes a <code>Marker</code> element
     * that you can use in your subsequent request to retrieve the next set of tapes. This operation is only supported
     * in the tape gateway type.
     * </p>
     *
     * @param listTapesRequest
     *        A JSON object that contains one or more of the following fields:</p>
     *        <ul>
     *        <li>
     *        <p>
     *        <a>ListTapesInput&#36Limit</a>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <a>ListTapesInput&#36Marker</a>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <a>ListTapesInput&#36TapeARNs</a>
     *        </p>
     *        </li>
     * @return A Java Future containing the result of the ListTapes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidGatewayRequestException An exception occurred because an invalid gateway request was issued to
     *         the service. For more information, see the error and message fields.</li>
     *         <li>InternalServerErrorException An internal server error has occurred during the request. For more
     *         information, see the error and message fields.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>StorageGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample StorageGatewayAsyncClient.ListTapes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ListTapes" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListTapesResponse> listTapes(ListTapesRequest listTapesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTapesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTapes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListTapesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListTapesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListTapesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListTapesRequest, ListTapesResponse>().withOperationName("ListTapes")
                            .withMarshaller(new ListTapesRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(listTapesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listTapesRequest.overrideConfiguration().orElse(null);
            CompletableFuture<ListTapesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists virtual tapes in your virtual tape library (VTL) and your virtual tape shelf (VTS). You specify the tapes
     * to list by specifying one or more tape Amazon Resource Names (ARNs). If you don't specify a tape ARN, the
     * operation lists all virtual tapes in both your VTL and VTS.
     * </p>
     * <p>
     * This operation supports pagination. By default, the operation returns a maximum of up to 100 tapes. You can
     * optionally specify the <code>Limit</code> parameter in the body to limit the number of tapes in the response. If
     * the number of tapes returned in the response is truncated, the response includes a <code>Marker</code> element
     * that you can use in your subsequent request to retrieve the next set of tapes. This operation is only supported
     * in the tape gateway type.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listTapes(software.amazon.awssdk.services.storagegateway.model.ListTapesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.storagegateway.paginators.ListTapesPublisher publisher = client.listTapesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.storagegateway.paginators.ListTapesPublisher publisher = client.listTapesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.storagegateway.model.ListTapesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.storagegateway.model.ListTapesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTapes(software.amazon.awssdk.services.storagegateway.model.ListTapesRequest)} operation.</b>
     * </p>
     *
     * @param listTapesRequest
     *        A JSON object that contains one or more of the following fields:</p>
     *        <ul>
     *        <li>
     *        <p>
     *        <a>ListTapesInput&#36Limit</a>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <a>ListTapesInput&#36Marker</a>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <a>ListTapesInput&#36TapeARNs</a>
     *        </p>
     *        </li>
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidGatewayRequestException An exception occurred because an invalid gateway request was issued to
     *         the service. For more information, see the error and message fields.</li>
     *         <li>InternalServerErrorException An internal server error has occurred during the request. For more
     *         information, see the error and message fields.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>StorageGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample StorageGatewayAsyncClient.ListTapes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ListTapes" target="_top">AWS API
     *      Documentation</a>
     */
    public ListTapesPublisher listTapesPaginator(ListTapesRequest listTapesRequest) {
        return new ListTapesPublisher(this, applyPaginatorUserAgent(listTapesRequest));
    }

    /**
     * <p>
     * Lists iSCSI initiators that are connected to a volume. You can use this operation to determine whether a volume
     * is being used or not. This operation is only supported in the cached volume and stored volume gateway types.
     * </p>
     *
     * @param listVolumeInitiatorsRequest
     *        ListVolumeInitiatorsInput
     * @return A Java Future containing the result of the ListVolumeInitiators operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidGatewayRequestException An exception occurred because an invalid gateway request was issued to
     *         the service. For more information, see the error and message fields.</li>
     *         <li>InternalServerErrorException An internal server error has occurred during the request. For more
     *         information, see the error and message fields.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>StorageGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample StorageGatewayAsyncClient.ListVolumeInitiators
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ListVolumeInitiators"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListVolumeInitiatorsResponse> listVolumeInitiators(
            ListVolumeInitiatorsRequest listVolumeInitiatorsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listVolumeInitiatorsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListVolumeInitiators");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListVolumeInitiatorsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListVolumeInitiatorsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListVolumeInitiatorsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListVolumeInitiatorsRequest, ListVolumeInitiatorsResponse>()
                            .withOperationName("ListVolumeInitiators")
                            .withMarshaller(new ListVolumeInitiatorsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listVolumeInitiatorsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listVolumeInitiatorsRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<ListVolumeInitiatorsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the recovery points for a specified gateway. This operation is only supported in the cached volume gateway
     * type.
     * </p>
     * <p>
     * Each cache volume has one recovery point. A volume recovery point is a point in time at which all data of the
     * volume is consistent and from which you can create a snapshot or clone a new cached volume from a source volume.
     * To create a snapshot from a volume recovery point use the <a>CreateSnapshotFromVolumeRecoveryPoint</a> operation.
     * </p>
     *
     * @param listVolumeRecoveryPointsRequest
     * @return A Java Future containing the result of the ListVolumeRecoveryPoints operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidGatewayRequestException An exception occurred because an invalid gateway request was issued to
     *         the service. For more information, see the error and message fields.</li>
     *         <li>InternalServerErrorException An internal server error has occurred during the request. For more
     *         information, see the error and message fields.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>StorageGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample StorageGatewayAsyncClient.ListVolumeRecoveryPoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ListVolumeRecoveryPoints"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListVolumeRecoveryPointsResponse> listVolumeRecoveryPoints(
            ListVolumeRecoveryPointsRequest listVolumeRecoveryPointsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listVolumeRecoveryPointsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListVolumeRecoveryPoints");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListVolumeRecoveryPointsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListVolumeRecoveryPointsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListVolumeRecoveryPointsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListVolumeRecoveryPointsRequest, ListVolumeRecoveryPointsResponse>()
                            .withOperationName("ListVolumeRecoveryPoints")
                            .withMarshaller(new ListVolumeRecoveryPointsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listVolumeRecoveryPointsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listVolumeRecoveryPointsRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<ListVolumeRecoveryPointsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the iSCSI stored volumes of a gateway. Results are sorted by volume ARN. The response includes only the
     * volume ARNs. If you want additional volume information, use the <a>DescribeStorediSCSIVolumes</a> or the
     * <a>DescribeCachediSCSIVolumes</a> API.
     * </p>
     * <p>
     * The operation supports pagination. By default, the operation returns a maximum of up to 100 volumes. You can
     * optionally specify the <code>Limit</code> field in the body to limit the number of volumes in the response. If
     * the number of volumes returned in the response is truncated, the response includes a Marker field. You can use
     * this Marker value in your subsequent request to retrieve the next set of volumes. This operation is only
     * supported in the cached volume and stored volume gateway types.
     * </p>
     *
     * @param listVolumesRequest
     *        A JSON object that contains one or more of the following fields:</p>
     *        <ul>
     *        <li>
     *        <p>
     *        <a>ListVolumesInput&#36Limit</a>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <a>ListVolumesInput&#36Marker</a>
     *        </p>
     *        </li>
     * @return A Java Future containing the result of the ListVolumes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidGatewayRequestException An exception occurred because an invalid gateway request was issued to
     *         the service. For more information, see the error and message fields.</li>
     *         <li>InternalServerErrorException An internal server error has occurred during the request. For more
     *         information, see the error and message fields.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>StorageGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample StorageGatewayAsyncClient.ListVolumes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ListVolumes" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListVolumesResponse> listVolumes(ListVolumesRequest listVolumesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listVolumesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListVolumes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListVolumesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListVolumesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListVolumesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListVolumesRequest, ListVolumesResponse>()
                            .withOperationName("ListVolumes").withMarshaller(new ListVolumesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listVolumesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listVolumesRequest.overrideConfiguration().orElse(null);
            CompletableFuture<ListVolumesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the iSCSI stored volumes of a gateway. Results are sorted by volume ARN. The response includes only the
     * volume ARNs. If you want additional volume information, use the <a>DescribeStorediSCSIVolumes</a> or the
     * <a>DescribeCachediSCSIVolumes</a> API.
     * </p>
     * <p>
     * The operation supports pagination. By default, the operation returns a maximum of up to 100 volumes. You can
     * optionally specify the <code>Limit</code> field in the body to limit the number of volumes in the response. If
     * the number of volumes returned in the response is truncated, the response includes a Marker field. You can use
     * this Marker value in your subsequent request to retrieve the next set of volumes. This operation is only
     * supported in the cached volume and stored volume gateway types.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listVolumes(software.amazon.awssdk.services.storagegateway.model.ListVolumesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.storagegateway.paginators.ListVolumesPublisher publisher = client.listVolumesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.storagegateway.paginators.ListVolumesPublisher publisher = client.listVolumesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.storagegateway.model.ListVolumesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.storagegateway.model.ListVolumesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listVolumes(software.amazon.awssdk.services.storagegateway.model.ListVolumesRequest)} operation.</b>
     * </p>
     *
     * @param listVolumesRequest
     *        A JSON object that contains one or more of the following fields:</p>
     *        <ul>
     *        <li>
     *        <p>
     *        <a>ListVolumesInput&#36Limit</a>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <a>ListVolumesInput&#36Marker</a>
     *        </p>
     *        </li>
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidGatewayRequestException An exception occurred because an invalid gateway request was issued to
     *         the service. For more information, see the error and message fields.</li>
     *         <li>InternalServerErrorException An internal server error has occurred during the request. For more
     *         information, see the error and message fields.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>StorageGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample StorageGatewayAsyncClient.ListVolumes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ListVolumes" target="_top">AWS
     *      API Documentation</a>
     */
    public ListVolumesPublisher listVolumesPaginator(ListVolumesRequest listVolumesRequest) {
        return new ListVolumesPublisher(this, applyPaginatorUserAgent(listVolumesRequest));
    }

    /**
     * <p>
     * Sends you notification through CloudWatch Events when all files written to your file share have been uploaded to
     * Amazon S3.
     * </p>
     * <p>
     * Storage Gateway can send a notification through Amazon CloudWatch Events when all files written to your file
     * share up to that point in time have been uploaded to Amazon S3. These files include files written to the file
     * share up to the time that you make a request for notification. When the upload is done, Storage Gateway sends you
     * notification through an Amazon CloudWatch Event. You can configure CloudWatch Events to send the notification
     * through event targets such as Amazon SNS or Lambda function. This operation is only supported for S3 File
     * Gateways.
     * </p>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/storagegateway/latest/userguide/monitoring-file-gateway.html#get-upload-notification"
     * >Getting file upload notification</a> in the <i>Storage Gateway User Guide</i>.
     * </p>
     *
     * @param notifyWhenUploadedRequest
     * @return A Java Future containing the result of the NotifyWhenUploaded operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidGatewayRequestException An exception occurred because an invalid gateway request was issued to
     *         the service. For more information, see the error and message fields.</li>
     *         <li>InternalServerErrorException An internal server error has occurred during the request. For more
     *         information, see the error and message fields.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>StorageGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample StorageGatewayAsyncClient.NotifyWhenUploaded
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/NotifyWhenUploaded"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<NotifyWhenUploadedResponse> notifyWhenUploaded(NotifyWhenUploadedRequest notifyWhenUploadedRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, notifyWhenUploadedRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "NotifyWhenUploaded");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<NotifyWhenUploadedResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, NotifyWhenUploadedResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<NotifyWhenUploadedResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<NotifyWhenUploadedRequest, NotifyWhenUploadedResponse>()
                            .withOperationName("NotifyWhenUploaded")
                            .withMarshaller(new NotifyWhenUploadedRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(notifyWhenUploadedRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = notifyWhenUploadedRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<NotifyWhenUploadedResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Refreshes the cached inventory of objects for the specified file share. This operation finds objects in the
     * Amazon S3 bucket that were added, removed, or replaced since the gateway last listed the bucket's contents and
     * cached the results. This operation does not import files into the S3 File Gateway cache storage. It only updates
     * the cached inventory to reflect changes in the inventory of the objects in the S3 bucket. This operation is only
     * supported in the S3 File Gateway types.
     * </p>
     * <p>
     * You can subscribe to be notified through an Amazon CloudWatch event when your <code>RefreshCache</code> operation
     * completes. For more information, see <a href=
     * "https://docs.aws.amazon.com/storagegateway/latest/userguide/monitoring-file-gateway.html#get-notification"
     * >Getting notified about file operations</a> in the <i>Storage Gateway User Guide</i>. This operation is Only
     * supported for S3 File Gateways.
     * </p>
     * <p>
     * When this API is called, it only initiates the refresh operation. When the API call completes and returns a
     * success code, it doesn't necessarily mean that the file refresh has completed. You should use the
     * refresh-complete notification to determine that the operation has completed before you check for new files on the
     * gateway file share. You can subscribe to be notified through a CloudWatch event when your
     * <code>RefreshCache</code> operation completes.
     * </p>
     * <p>
     * Throttle limit: This API is asynchronous, so the gateway will accept no more than two refreshes at any time. We
     * recommend using the refresh-complete CloudWatch event notification before issuing additional requests. For more
     * information, see <a href=
     * "https://docs.aws.amazon.com/storagegateway/latest/userguide/monitoring-file-gateway.html#get-notification"
     * >Getting notified about file operations</a> in the <i>Storage Gateway User Guide</i>.
     * </p>
     * <p>
     * If you invoke the RefreshCache API when two requests are already being processed, any new request will cause an
     * <code>InvalidGatewayRequestException</code> error because too many requests were sent to the server.
     * </p>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/storagegateway/latest/userguide/monitoring-file-gateway.html#get-notification"
     * >Getting notified about file operations</a> in the <i>Storage Gateway User Guide</i>.
     * </p>
     *
     * @param refreshCacheRequest
     *        RefreshCacheInput
     * @return A Java Future containing the result of the RefreshCache operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidGatewayRequestException An exception occurred because an invalid gateway request was issued to
     *         the service. For more information, see the error and message fields.</li>
     *         <li>InternalServerErrorException An internal server error has occurred during the request. For more
     *         information, see the error and message fields.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>StorageGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample StorageGatewayAsyncClient.RefreshCache
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/RefreshCache" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<RefreshCacheResponse> refreshCache(RefreshCacheRequest refreshCacheRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, refreshCacheRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RefreshCache");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<RefreshCacheResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    RefreshCacheResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<RefreshCacheResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RefreshCacheRequest, RefreshCacheResponse>()
                            .withOperationName("RefreshCache").withMarshaller(new RefreshCacheRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(refreshCacheRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = refreshCacheRequest.overrideConfiguration().orElse(null);
            CompletableFuture<RefreshCacheResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes one or more tags from the specified resource. This operation is supported in storage gateways of all
     * types.
     * </p>
     *
     * @param removeTagsFromResourceRequest
     *        RemoveTagsFromResourceInput
     * @return A Java Future containing the result of the RemoveTagsFromResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidGatewayRequestException An exception occurred because an invalid gateway request was issued to
     *         the service. For more information, see the error and message fields.</li>
     *         <li>InternalServerErrorException An internal server error has occurred during the request. For more
     *         information, see the error and message fields.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>StorageGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample StorageGatewayAsyncClient.RemoveTagsFromResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/RemoveTagsFromResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<RemoveTagsFromResourceResponse> removeTagsFromResource(
            RemoveTagsFromResourceRequest removeTagsFromResourceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, removeTagsFromResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RemoveTagsFromResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<RemoveTagsFromResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, RemoveTagsFromResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<RemoveTagsFromResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RemoveTagsFromResourceRequest, RemoveTagsFromResourceResponse>()
                            .withOperationName("RemoveTagsFromResource")
                            .withMarshaller(new RemoveTagsFromResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(removeTagsFromResourceRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = removeTagsFromResourceRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<RemoveTagsFromResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Resets all cache disks that have encountered an error and makes the disks available for reconfiguration as cache
     * storage. If your cache disk encounters an error, the gateway prevents read and write operations on virtual tapes
     * in the gateway. For example, an error can occur when a disk is corrupted or removed from the gateway. When a
     * cache is reset, the gateway loses its cache storage. At this point, you can reconfigure the disks as cache disks.
     * This operation is only supported in the cached volume and tape types.
     * </p>
     * <important>
     * <p>
     * If the cache disk you are resetting contains data that has not been uploaded to Amazon S3 yet, that data can be
     * lost. After you reset cache disks, there will be no configured cache disks left in the gateway, so you must
     * configure at least one new cache disk for your gateway to function properly.
     * </p>
     * </important>
     *
     * @param resetCacheRequest
     * @return A Java Future containing the result of the ResetCache operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidGatewayRequestException An exception occurred because an invalid gateway request was issued to
     *         the service. For more information, see the error and message fields.</li>
     *         <li>InternalServerErrorException An internal server error has occurred during the request. For more
     *         information, see the error and message fields.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>StorageGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample StorageGatewayAsyncClient.ResetCache
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ResetCache" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ResetCacheResponse> resetCache(ResetCacheRequest resetCacheRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, resetCacheRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ResetCache");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ResetCacheResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ResetCacheResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ResetCacheResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ResetCacheRequest, ResetCacheResponse>().withOperationName("ResetCache")
                            .withMarshaller(new ResetCacheRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(resetCacheRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = resetCacheRequest.overrideConfiguration().orElse(null);
            CompletableFuture<ResetCacheResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves an archived virtual tape from the virtual tape shelf (VTS) to a tape gateway. Virtual tapes archived in
     * the VTS are not associated with any gateway. However after a tape is retrieved, it is associated with a gateway,
     * even though it is also listed in the VTS, that is, archive. This operation is only supported in the tape gateway
     * type.
     * </p>
     * <p>
     * Once a tape is successfully retrieved to a gateway, it cannot be retrieved again to another gateway. You must
     * archive the tape again before you can retrieve it to another gateway. This operation is only supported in the
     * tape gateway type.
     * </p>
     *
     * @param retrieveTapeArchiveRequest
     *        RetrieveTapeArchiveInput
     * @return A Java Future containing the result of the RetrieveTapeArchive operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidGatewayRequestException An exception occurred because an invalid gateway request was issued to
     *         the service. For more information, see the error and message fields.</li>
     *         <li>InternalServerErrorException An internal server error has occurred during the request. For more
     *         information, see the error and message fields.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>StorageGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample StorageGatewayAsyncClient.RetrieveTapeArchive
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/RetrieveTapeArchive"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<RetrieveTapeArchiveResponse> retrieveTapeArchive(
            RetrieveTapeArchiveRequest retrieveTapeArchiveRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, retrieveTapeArchiveRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RetrieveTapeArchive");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<RetrieveTapeArchiveResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, RetrieveTapeArchiveResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<RetrieveTapeArchiveResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RetrieveTapeArchiveRequest, RetrieveTapeArchiveResponse>()
                            .withOperationName("RetrieveTapeArchive")
                            .withMarshaller(new RetrieveTapeArchiveRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(retrieveTapeArchiveRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = retrieveTapeArchiveRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<RetrieveTapeArchiveResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the recovery point for the specified virtual tape. This operation is only supported in the tape gateway
     * type.
     * </p>
     * <p>
     * A recovery point is a point in time view of a virtual tape at which all the data on the tape is consistent. If
     * your gateway crashes, virtual tapes that have recovery points can be recovered to a new gateway.
     * </p>
     * <note>
     * <p>
     * The virtual tape can be retrieved to only one gateway. The retrieved tape is read-only. The virtual tape can be
     * retrieved to only a tape gateway. There is no charge for retrieving recovery points.
     * </p>
     * </note>
     *
     * @param retrieveTapeRecoveryPointRequest
     *        RetrieveTapeRecoveryPointInput
     * @return A Java Future containing the result of the RetrieveTapeRecoveryPoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidGatewayRequestException An exception occurred because an invalid gateway request was issued to
     *         the service. For more information, see the error and message fields.</li>
     *         <li>InternalServerErrorException An internal server error has occurred during the request. For more
     *         information, see the error and message fields.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>StorageGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample StorageGatewayAsyncClient.RetrieveTapeRecoveryPoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/RetrieveTapeRecoveryPoint"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<RetrieveTapeRecoveryPointResponse> retrieveTapeRecoveryPoint(
            RetrieveTapeRecoveryPointRequest retrieveTapeRecoveryPointRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, retrieveTapeRecoveryPointRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RetrieveTapeRecoveryPoint");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<RetrieveTapeRecoveryPointResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, RetrieveTapeRecoveryPointResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<RetrieveTapeRecoveryPointResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RetrieveTapeRecoveryPointRequest, RetrieveTapeRecoveryPointResponse>()
                            .withOperationName("RetrieveTapeRecoveryPoint")
                            .withMarshaller(new RetrieveTapeRecoveryPointRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(retrieveTapeRecoveryPointRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = retrieveTapeRecoveryPointRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<RetrieveTapeRecoveryPointResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Sets the password for your VM local console. When you log in to the local console for the first time, you log in
     * to the VM with the default credentials. We recommend that you set a new password. You don't need to know the
     * default password to set a new password.
     * </p>
     *
     * @param setLocalConsolePasswordRequest
     *        SetLocalConsolePasswordInput
     * @return A Java Future containing the result of the SetLocalConsolePassword operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidGatewayRequestException An exception occurred because an invalid gateway request was issued to
     *         the service. For more information, see the error and message fields.</li>
     *         <li>InternalServerErrorException An internal server error has occurred during the request. For more
     *         information, see the error and message fields.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>StorageGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample StorageGatewayAsyncClient.SetLocalConsolePassword
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/SetLocalConsolePassword"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<SetLocalConsolePasswordResponse> setLocalConsolePassword(
            SetLocalConsolePasswordRequest setLocalConsolePasswordRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, setLocalConsolePasswordRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SetLocalConsolePassword");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<SetLocalConsolePasswordResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, SetLocalConsolePasswordResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<SetLocalConsolePasswordResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<SetLocalConsolePasswordRequest, SetLocalConsolePasswordResponse>()
                            .withOperationName("SetLocalConsolePassword")
                            .withMarshaller(new SetLocalConsolePasswordRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(setLocalConsolePasswordRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = setLocalConsolePasswordRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<SetLocalConsolePasswordResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Sets the password for the guest user <code>smbguest</code>. The <code>smbguest</code> user is the user when the
     * authentication method for the file share is set to <code>GuestAccess</code>. This operation only supported for S3
     * File Gateways
     * </p>
     *
     * @param setSmbGuestPasswordRequest
     *        SetSMBGuestPasswordInput
     * @return A Java Future containing the result of the SetSMBGuestPassword operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidGatewayRequestException An exception occurred because an invalid gateway request was issued to
     *         the service. For more information, see the error and message fields.</li>
     *         <li>InternalServerErrorException An internal server error has occurred during the request. For more
     *         information, see the error and message fields.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>StorageGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample StorageGatewayAsyncClient.SetSMBGuestPassword
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/SetSMBGuestPassword"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<SetSmbGuestPasswordResponse> setSMBGuestPassword(
            SetSmbGuestPasswordRequest setSmbGuestPasswordRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, setSmbGuestPasswordRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SetSMBGuestPassword");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<SetSmbGuestPasswordResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, SetSmbGuestPasswordResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<SetSmbGuestPasswordResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<SetSmbGuestPasswordRequest, SetSmbGuestPasswordResponse>()
                            .withOperationName("SetSMBGuestPassword")
                            .withMarshaller(new SetSmbGuestPasswordRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(setSmbGuestPasswordRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = setSmbGuestPasswordRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<SetSmbGuestPasswordResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Shuts down a gateway. To specify which gateway to shut down, use the Amazon Resource Name (ARN) of the gateway in
     * the body of your request.
     * </p>
     * <p>
     * The operation shuts down the gateway service component running in the gateway's virtual machine (VM) and not the
     * host VM.
     * </p>
     * <note>
     * <p>
     * If you want to shut down the VM, it is recommended that you first shut down the gateway component in the VM to
     * avoid unpredictable conditions.
     * </p>
     * </note>
     * <p>
     * After the gateway is shutdown, you cannot call any other API except <a>StartGateway</a>,
     * <a>DescribeGatewayInformation</a>, and <a>ListGateways</a>. For more information, see <a>ActivateGateway</a>.
     * Your applications cannot read from or write to the gateway's storage volumes, and there are no snapshots taken.
     * </p>
     * <note>
     * <p>
     * When you make a shutdown request, you will get a <code>200 OK</code> success response immediately. However, it
     * might take some time for the gateway to shut down. You can call the <a>DescribeGatewayInformation</a> API to
     * check the status. For more information, see <a>ActivateGateway</a>.
     * </p>
     * </note>
     * <p>
     * If do not intend to use the gateway again, you must delete the gateway (using <a>DeleteGateway</a>) to no longer
     * pay software charges associated with the gateway.
     * </p>
     *
     * @param shutdownGatewayRequest
     *        A JSON object containing the Amazon Resource Name (ARN) of the gateway to shut down.
     * @return A Java Future containing the result of the ShutdownGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidGatewayRequestException An exception occurred because an invalid gateway request was issued to
     *         the service. For more information, see the error and message fields.</li>
     *         <li>InternalServerErrorException An internal server error has occurred during the request. For more
     *         information, see the error and message fields.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>StorageGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample StorageGatewayAsyncClient.ShutdownGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ShutdownGateway"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ShutdownGatewayResponse> shutdownGateway(ShutdownGatewayRequest shutdownGatewayRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, shutdownGatewayRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ShutdownGateway");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ShutdownGatewayResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ShutdownGatewayResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ShutdownGatewayResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ShutdownGatewayRequest, ShutdownGatewayResponse>()
                            .withOperationName("ShutdownGateway")
                            .withMarshaller(new ShutdownGatewayRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(shutdownGatewayRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = shutdownGatewayRequest.overrideConfiguration().orElse(null);
            CompletableFuture<ShutdownGatewayResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Start a test that verifies that the specified gateway is configured for High Availability monitoring in your host
     * environment. This request only initiates the test and that a successful response only indicates that the test was
     * started. It doesn't indicate that the test passed. For the status of the test, invoke the
     * <code>DescribeAvailabilityMonitorTest</code> API.
     * </p>
     * <note>
     * <p>
     * Starting this test will cause your gateway to go offline for a brief period.
     * </p>
     * </note>
     *
     * @param startAvailabilityMonitorTestRequest
     * @return A Java Future containing the result of the StartAvailabilityMonitorTest operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidGatewayRequestException An exception occurred because an invalid gateway request was issued to
     *         the service. For more information, see the error and message fields.</li>
     *         <li>InternalServerErrorException An internal server error has occurred during the request. For more
     *         information, see the error and message fields.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>StorageGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample StorageGatewayAsyncClient.StartAvailabilityMonitorTest
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/StartAvailabilityMonitorTest"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StartAvailabilityMonitorTestResponse> startAvailabilityMonitorTest(
            StartAvailabilityMonitorTestRequest startAvailabilityMonitorTestRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startAvailabilityMonitorTestRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartAvailabilityMonitorTest");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartAvailabilityMonitorTestResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StartAvailabilityMonitorTestResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StartAvailabilityMonitorTestResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartAvailabilityMonitorTestRequest, StartAvailabilityMonitorTestResponse>()
                            .withOperationName("StartAvailabilityMonitorTest")
                            .withMarshaller(new StartAvailabilityMonitorTestRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(startAvailabilityMonitorTestRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = startAvailabilityMonitorTestRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<StartAvailabilityMonitorTestResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Starts a gateway that you previously shut down (see <a>ShutdownGateway</a>). After the gateway starts, you can
     * then make other API calls, your applications can read from or write to the gateway's storage volumes and you will
     * be able to take snapshot backups.
     * </p>
     * <note>
     * <p>
     * When you make a request, you will get a 200 OK success response immediately. However, it might take some time for
     * the gateway to be ready. You should call <a>DescribeGatewayInformation</a> and check the status before making any
     * additional API calls. For more information, see <a>ActivateGateway</a>.
     * </p>
     * </note>
     * <p>
     * To specify which gateway to start, use the Amazon Resource Name (ARN) of the gateway in your request.
     * </p>
     *
     * @param startGatewayRequest
     *        A JSON object containing the Amazon Resource Name (ARN) of the gateway to start.
     * @return A Java Future containing the result of the StartGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidGatewayRequestException An exception occurred because an invalid gateway request was issued to
     *         the service. For more information, see the error and message fields.</li>
     *         <li>InternalServerErrorException An internal server error has occurred during the request. For more
     *         information, see the error and message fields.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>StorageGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample StorageGatewayAsyncClient.StartGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/StartGateway" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<StartGatewayResponse> startGateway(StartGatewayRequest startGatewayRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startGatewayRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartGateway");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartGatewayResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    StartGatewayResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StartGatewayResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartGatewayRequest, StartGatewayResponse>()
                            .withOperationName("StartGateway").withMarshaller(new StartGatewayRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(startGatewayRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = startGatewayRequest.overrideConfiguration().orElse(null);
            CompletableFuture<StartGatewayResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the automatic tape creation policy of a gateway. Use this to update the policy with a new set of
     * automatic tape creation rules. This is only supported for tape gateways.
     * </p>
     * <p>
     * By default, there is no automatic tape creation policy.
     * </p>
     * <note>
     * <p>
     * A gateway can have only one automatic tape creation policy.
     * </p>
     * </note>
     *
     * @param updateAutomaticTapeCreationPolicyRequest
     * @return A Java Future containing the result of the UpdateAutomaticTapeCreationPolicy operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidGatewayRequestException An exception occurred because an invalid gateway request was issued to
     *         the service. For more information, see the error and message fields.</li>
     *         <li>InternalServerErrorException An internal server error has occurred during the request. For more
     *         information, see the error and message fields.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>StorageGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample StorageGatewayAsyncClient.UpdateAutomaticTapeCreationPolicy
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/UpdateAutomaticTapeCreationPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateAutomaticTapeCreationPolicyResponse> updateAutomaticTapeCreationPolicy(
            UpdateAutomaticTapeCreationPolicyRequest updateAutomaticTapeCreationPolicyRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateAutomaticTapeCreationPolicyRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateAutomaticTapeCreationPolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateAutomaticTapeCreationPolicyResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, UpdateAutomaticTapeCreationPolicyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateAutomaticTapeCreationPolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateAutomaticTapeCreationPolicyRequest, UpdateAutomaticTapeCreationPolicyResponse>()
                            .withOperationName("UpdateAutomaticTapeCreationPolicy")
                            .withMarshaller(new UpdateAutomaticTapeCreationPolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateAutomaticTapeCreationPolicyRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateAutomaticTapeCreationPolicyRequest
                    .overrideConfiguration().orElse(null);
            CompletableFuture<UpdateAutomaticTapeCreationPolicyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the bandwidth rate limits of a gateway. You can update both the upload and download bandwidth rate limit
     * or specify only one of the two. If you don't set a bandwidth rate limit, the existing rate limit remains. This
     * operation is supported for the stored volume, cached volume, and tape gateway types.
     * </p>
     * <p>
     * By default, a gateway's bandwidth rate limits are not set. If you don't set any limit, the gateway does not have
     * any limitations on its bandwidth usage and could potentially use the maximum available bandwidth.
     * </p>
     * <p>
     * To specify which gateway to update, use the Amazon Resource Name (ARN) of the gateway in your request.
     * </p>
     *
     * @param updateBandwidthRateLimitRequest
     *        A JSON object containing one or more of the following fields:</p>
     *        <ul>
     *        <li>
     *        <p>
     *        <a>UpdateBandwidthRateLimitInput&#36AverageDownloadRateLimitInBitsPerSec</a>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <a>UpdateBandwidthRateLimitInput&#36AverageUploadRateLimitInBitsPerSec</a>
     *        </p>
     *        </li>
     * @return A Java Future containing the result of the UpdateBandwidthRateLimit operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidGatewayRequestException An exception occurred because an invalid gateway request was issued to
     *         the service. For more information, see the error and message fields.</li>
     *         <li>InternalServerErrorException An internal server error has occurred during the request. For more
     *         information, see the error and message fields.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>StorageGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample StorageGatewayAsyncClient.UpdateBandwidthRateLimit
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/UpdateBandwidthRateLimit"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateBandwidthRateLimitResponse> updateBandwidthRateLimit(
            UpdateBandwidthRateLimitRequest updateBandwidthRateLimitRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateBandwidthRateLimitRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateBandwidthRateLimit");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateBandwidthRateLimitResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateBandwidthRateLimitResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateBandwidthRateLimitResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateBandwidthRateLimitRequest, UpdateBandwidthRateLimitResponse>()
                            .withOperationName("UpdateBandwidthRateLimit")
                            .withMarshaller(new UpdateBandwidthRateLimitRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateBandwidthRateLimitRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateBandwidthRateLimitRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<UpdateBandwidthRateLimitResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the bandwidth rate limit schedule for a specified gateway. By default, gateways do not have bandwidth
     * rate limit schedules, which means no bandwidth rate limiting is in effect. Use this to initiate or update a
     * gateway's bandwidth rate limit schedule. This operation is supported in the volume and tape gateway types.
     * </p>
     *
     * @param updateBandwidthRateLimitScheduleRequest
     * @return A Java Future containing the result of the UpdateBandwidthRateLimitSchedule operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidGatewayRequestException An exception occurred because an invalid gateway request was issued to
     *         the service. For more information, see the error and message fields.</li>
     *         <li>InternalServerErrorException An internal server error has occurred during the request. For more
     *         information, see the error and message fields.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>StorageGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample StorageGatewayAsyncClient.UpdateBandwidthRateLimitSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/UpdateBandwidthRateLimitSchedule"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateBandwidthRateLimitScheduleResponse> updateBandwidthRateLimitSchedule(
            UpdateBandwidthRateLimitScheduleRequest updateBandwidthRateLimitScheduleRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateBandwidthRateLimitScheduleRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateBandwidthRateLimitSchedule");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateBandwidthRateLimitScheduleResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, UpdateBandwidthRateLimitScheduleResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateBandwidthRateLimitScheduleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateBandwidthRateLimitScheduleRequest, UpdateBandwidthRateLimitScheduleResponse>()
                            .withOperationName("UpdateBandwidthRateLimitSchedule")
                            .withMarshaller(new UpdateBandwidthRateLimitScheduleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateBandwidthRateLimitScheduleRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateBandwidthRateLimitScheduleRequest
                    .overrideConfiguration().orElse(null);
            CompletableFuture<UpdateBandwidthRateLimitScheduleResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the Challenge-Handshake Authentication Protocol (CHAP) credentials for a specified iSCSI target. By
     * default, a gateway does not have CHAP enabled; however, for added security, you might use it. This operation is
     * supported in the volume and tape gateway types.
     * </p>
     * <important>
     * <p>
     * When you update CHAP credentials, all existing connections on the target are closed and initiators must reconnect
     * with the new credentials.
     * </p>
     * </important>
     *
     * @param updateChapCredentialsRequest
     *        A JSON object containing one or more of the following fields:</p>
     *        <ul>
     *        <li>
     *        <p>
     *        <a>UpdateChapCredentialsInput&#36InitiatorName</a>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <a>UpdateChapCredentialsInput&#36SecretToAuthenticateInitiator</a>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <a>UpdateChapCredentialsInput&#36SecretToAuthenticateTarget</a>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <a>UpdateChapCredentialsInput&#36TargetARN</a>
     *        </p>
     *        </li>
     * @return A Java Future containing the result of the UpdateChapCredentials operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidGatewayRequestException An exception occurred because an invalid gateway request was issued to
     *         the service. For more information, see the error and message fields.</li>
     *         <li>InternalServerErrorException An internal server error has occurred during the request. For more
     *         information, see the error and message fields.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>StorageGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample StorageGatewayAsyncClient.UpdateChapCredentials
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/UpdateChapCredentials"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateChapCredentialsResponse> updateChapCredentials(
            UpdateChapCredentialsRequest updateChapCredentialsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateChapCredentialsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateChapCredentials");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateChapCredentialsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateChapCredentialsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateChapCredentialsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateChapCredentialsRequest, UpdateChapCredentialsResponse>()
                            .withOperationName("UpdateChapCredentials")
                            .withMarshaller(new UpdateChapCredentialsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateChapCredentialsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateChapCredentialsRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<UpdateChapCredentialsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a file system association. This operation is only supported in the FSx File Gateways.
     * </p>
     *
     * @param updateFileSystemAssociationRequest
     * @return A Java Future containing the result of the UpdateFileSystemAssociation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidGatewayRequestException An exception occurred because an invalid gateway request was issued to
     *         the service. For more information, see the error and message fields.</li>
     *         <li>InternalServerErrorException An internal server error has occurred during the request. For more
     *         information, see the error and message fields.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>StorageGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample StorageGatewayAsyncClient.UpdateFileSystemAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/UpdateFileSystemAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateFileSystemAssociationResponse> updateFileSystemAssociation(
            UpdateFileSystemAssociationRequest updateFileSystemAssociationRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateFileSystemAssociationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateFileSystemAssociation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateFileSystemAssociationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateFileSystemAssociationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateFileSystemAssociationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateFileSystemAssociationRequest, UpdateFileSystemAssociationResponse>()
                            .withOperationName("UpdateFileSystemAssociation")
                            .withMarshaller(new UpdateFileSystemAssociationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateFileSystemAssociationRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateFileSystemAssociationRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<UpdateFileSystemAssociationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a gateway's metadata, which includes the gateway's name and time zone. To specify which gateway to
     * update, use the Amazon Resource Name (ARN) of the gateway in your request.
     * </p>
     * <note>
     * <p>
     * For gateways activated after September 2, 2015, the gateway's ARN contains the gateway ID rather than the gateway
     * name. However, changing the name of the gateway has no effect on the gateway's ARN.
     * </p>
     * </note>
     *
     * @param updateGatewayInformationRequest
     * @return A Java Future containing the result of the UpdateGatewayInformation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidGatewayRequestException An exception occurred because an invalid gateway request was issued to
     *         the service. For more information, see the error and message fields.</li>
     *         <li>InternalServerErrorException An internal server error has occurred during the request. For more
     *         information, see the error and message fields.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>StorageGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample StorageGatewayAsyncClient.UpdateGatewayInformation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/UpdateGatewayInformation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateGatewayInformationResponse> updateGatewayInformation(
            UpdateGatewayInformationRequest updateGatewayInformationRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateGatewayInformationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateGatewayInformation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateGatewayInformationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateGatewayInformationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateGatewayInformationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateGatewayInformationRequest, UpdateGatewayInformationResponse>()
                            .withOperationName("UpdateGatewayInformation")
                            .withMarshaller(new UpdateGatewayInformationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateGatewayInformationRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateGatewayInformationRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<UpdateGatewayInformationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the gateway virtual machine (VM) software. The request immediately triggers the software update.
     * </p>
     * <note>
     * <p>
     * When you make this request, you get a <code>200 OK</code> success response immediately. However, it might take
     * some time for the update to complete. You can call <a>DescribeGatewayInformation</a> to verify the gateway is in
     * the <code>STATE_RUNNING</code> state.
     * </p>
     * </note> <important>
     * <p>
     * A software update forces a system restart of your gateway. You can minimize the chance of any disruption to your
     * applications by increasing your iSCSI Initiators' timeouts. For more information about increasing iSCSI Initiator
     * timeouts for Windows and Linux, see <a href=
     * "https://docs.aws.amazon.com/storagegateway/latest/userguide/ConfiguringiSCSIClientInitiatorWindowsClient.html#CustomizeWindowsiSCSISettings"
     * >Customizing your Windows iSCSI settings</a> and <a href=
     * "https://docs.aws.amazon.com/storagegateway/latest/userguide/ConfiguringiSCSIClientInitiatorRedHatClient.html#CustomizeLinuxiSCSISettings"
     * >Customizing your Linux iSCSI settings</a>, respectively.
     * </p>
     * </important>
     *
     * @param updateGatewaySoftwareNowRequest
     *        A JSON object containing the Amazon Resource Name (ARN) of the gateway to update.
     * @return A Java Future containing the result of the UpdateGatewaySoftwareNow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidGatewayRequestException An exception occurred because an invalid gateway request was issued to
     *         the service. For more information, see the error and message fields.</li>
     *         <li>InternalServerErrorException An internal server error has occurred during the request. For more
     *         information, see the error and message fields.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>StorageGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample StorageGatewayAsyncClient.UpdateGatewaySoftwareNow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/UpdateGatewaySoftwareNow"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateGatewaySoftwareNowResponse> updateGatewaySoftwareNow(
            UpdateGatewaySoftwareNowRequest updateGatewaySoftwareNowRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateGatewaySoftwareNowRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateGatewaySoftwareNow");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateGatewaySoftwareNowResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateGatewaySoftwareNowResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateGatewaySoftwareNowResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateGatewaySoftwareNowRequest, UpdateGatewaySoftwareNowResponse>()
                            .withOperationName("UpdateGatewaySoftwareNow")
                            .withMarshaller(new UpdateGatewaySoftwareNowRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateGatewaySoftwareNowRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateGatewaySoftwareNowRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<UpdateGatewaySoftwareNowResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a gateway's weekly maintenance start time information, including day and time of the week. The
     * maintenance time is the time in your gateway's time zone.
     * </p>
     *
     * @param updateMaintenanceStartTimeRequest
     *        A JSON object containing the following fields:</p>
     *        <ul>
     *        <li>
     *        <p>
     *        <a>UpdateMaintenanceStartTimeInput&#36DayOfMonth</a>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <a>UpdateMaintenanceStartTimeInput&#36DayOfWeek</a>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <a>UpdateMaintenanceStartTimeInput&#36HourOfDay</a>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <a>UpdateMaintenanceStartTimeInput&#36MinuteOfHour</a>
     *        </p>
     *        </li>
     * @return A Java Future containing the result of the UpdateMaintenanceStartTime operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidGatewayRequestException An exception occurred because an invalid gateway request was issued to
     *         the service. For more information, see the error and message fields.</li>
     *         <li>InternalServerErrorException An internal server error has occurred during the request. For more
     *         information, see the error and message fields.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>StorageGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample StorageGatewayAsyncClient.UpdateMaintenanceStartTime
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/UpdateMaintenanceStartTime"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateMaintenanceStartTimeResponse> updateMaintenanceStartTime(
            UpdateMaintenanceStartTimeRequest updateMaintenanceStartTimeRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateMaintenanceStartTimeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateMaintenanceStartTime");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateMaintenanceStartTimeResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateMaintenanceStartTimeResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateMaintenanceStartTimeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateMaintenanceStartTimeRequest, UpdateMaintenanceStartTimeResponse>()
                            .withOperationName("UpdateMaintenanceStartTime")
                            .withMarshaller(new UpdateMaintenanceStartTimeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateMaintenanceStartTimeRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateMaintenanceStartTimeRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<UpdateMaintenanceStartTimeResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a Network File System (NFS) file share. This operation is only supported in S3 File Gateways.
     * </p>
     * <note>
     * <p>
     * To leave a file share field unchanged, set the corresponding input field to null.
     * </p>
     * </note>
     * <p>
     * Updates the following file share settings:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Default storage class for your S3 bucket
     * </p>
     * </li>
     * <li>
     * <p>
     * Metadata defaults for your S3 bucket
     * </p>
     * </li>
     * <li>
     * <p>
     * Allowed NFS clients for your file share
     * </p>
     * </li>
     * <li>
     * <p>
     * Squash settings
     * </p>
     * </li>
     * <li>
     * <p>
     * Write status of your file share
     * </p>
     * </li>
     * </ul>
     *
     * @param updateNfsFileShareRequest
     *        UpdateNFSFileShareInput
     * @return A Java Future containing the result of the UpdateNFSFileShare operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidGatewayRequestException An exception occurred because an invalid gateway request was issued to
     *         the service. For more information, see the error and message fields.</li>
     *         <li>InternalServerErrorException An internal server error has occurred during the request. For more
     *         information, see the error and message fields.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>StorageGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample StorageGatewayAsyncClient.UpdateNFSFileShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/UpdateNFSFileShare"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateNfsFileShareResponse> updateNFSFileShare(UpdateNfsFileShareRequest updateNfsFileShareRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateNfsFileShareRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateNFSFileShare");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateNfsFileShareResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateNfsFileShareResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateNfsFileShareResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateNfsFileShareRequest, UpdateNfsFileShareResponse>()
                            .withOperationName("UpdateNFSFileShare")
                            .withMarshaller(new UpdateNfsFileShareRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateNfsFileShareRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateNfsFileShareRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<UpdateNfsFileShareResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a Server Message Block (SMB) file share. This operation is only supported for S3 File Gateways.
     * </p>
     * <note>
     * <p>
     * To leave a file share field unchanged, set the corresponding input field to null.
     * </p>
     * </note> <important>
     * <p>
     * File gateways require Security Token Service (Amazon Web Services STS) to be activated to enable you to create a
     * file share. Make sure that Amazon Web Services STS is activated in the Amazon Web Services Region you are
     * creating your file gateway in. If Amazon Web Services STS is not activated in this Amazon Web Services Region,
     * activate it. For information about how to activate Amazon Web Services STS, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_enable-regions.html">Activating and
     * deactivating Amazon Web Services STS in an Amazon Web Services Region</a> in the <i>Identity and Access
     * Management User Guide</i>.
     * </p>
     * <p>
     * File gateways don't support creating hard or symbolic links on a file share.
     * </p>
     * </important>
     *
     * @param updateSmbFileShareRequest
     *        UpdateSMBFileShareInput
     * @return A Java Future containing the result of the UpdateSMBFileShare operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidGatewayRequestException An exception occurred because an invalid gateway request was issued to
     *         the service. For more information, see the error and message fields.</li>
     *         <li>InternalServerErrorException An internal server error has occurred during the request. For more
     *         information, see the error and message fields.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>StorageGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample StorageGatewayAsyncClient.UpdateSMBFileShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/UpdateSMBFileShare"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateSmbFileShareResponse> updateSMBFileShare(UpdateSmbFileShareRequest updateSmbFileShareRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateSmbFileShareRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateSMBFileShare");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateSmbFileShareResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateSmbFileShareResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateSmbFileShareResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateSmbFileShareRequest, UpdateSmbFileShareResponse>()
                            .withOperationName("UpdateSMBFileShare")
                            .withMarshaller(new UpdateSmbFileShareRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateSmbFileShareRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateSmbFileShareRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<UpdateSmbFileShareResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Controls whether the shares on an S3 File Gateway are visible in a net view or browse list. The operation is only
     * supported for S3 File Gateways.
     * </p>
     *
     * @param updateSmbFileShareVisibilityRequest
     * @return A Java Future containing the result of the UpdateSMBFileShareVisibility operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidGatewayRequestException An exception occurred because an invalid gateway request was issued to
     *         the service. For more information, see the error and message fields.</li>
     *         <li>InternalServerErrorException An internal server error has occurred during the request. For more
     *         information, see the error and message fields.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>StorageGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample StorageGatewayAsyncClient.UpdateSMBFileShareVisibility
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/UpdateSMBFileShareVisibility"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateSmbFileShareVisibilityResponse> updateSMBFileShareVisibility(
            UpdateSmbFileShareVisibilityRequest updateSmbFileShareVisibilityRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateSmbFileShareVisibilityRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateSMBFileShareVisibility");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateSmbFileShareVisibilityResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateSmbFileShareVisibilityResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateSmbFileShareVisibilityResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateSmbFileShareVisibilityRequest, UpdateSmbFileShareVisibilityResponse>()
                            .withOperationName("UpdateSMBFileShareVisibility")
                            .withMarshaller(new UpdateSmbFileShareVisibilityRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateSmbFileShareVisibilityRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateSmbFileShareVisibilityRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<UpdateSmbFileShareVisibilityResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the list of Active Directory users and groups that have special permissions for SMB file shares on the
     * gateway.
     * </p>
     *
     * @param updateSmbLocalGroupsRequest
     * @return A Java Future containing the result of the UpdateSMBLocalGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidGatewayRequestException An exception occurred because an invalid gateway request was issued to
     *         the service. For more information, see the error and message fields.</li>
     *         <li>InternalServerErrorException An internal server error has occurred during the request. For more
     *         information, see the error and message fields.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>StorageGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample StorageGatewayAsyncClient.UpdateSMBLocalGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/UpdateSMBLocalGroups"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateSmbLocalGroupsResponse> updateSMBLocalGroups(
            UpdateSmbLocalGroupsRequest updateSmbLocalGroupsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateSmbLocalGroupsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateSMBLocalGroups");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateSmbLocalGroupsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateSmbLocalGroupsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateSmbLocalGroupsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateSmbLocalGroupsRequest, UpdateSmbLocalGroupsResponse>()
                            .withOperationName("UpdateSMBLocalGroups")
                            .withMarshaller(new UpdateSmbLocalGroupsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateSmbLocalGroupsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateSmbLocalGroupsRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<UpdateSmbLocalGroupsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the SMB security strategy on a file gateway. This action is only supported in file gateways.
     * </p>
     * <note>
     * <p>
     * This API is called Security level in the User Guide.
     * </p>
     * <p>
     * A higher security level can affect performance of the gateway.
     * </p>
     * </note>
     *
     * @param updateSmbSecurityStrategyRequest
     * @return A Java Future containing the result of the UpdateSMBSecurityStrategy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidGatewayRequestException An exception occurred because an invalid gateway request was issued to
     *         the service. For more information, see the error and message fields.</li>
     *         <li>InternalServerErrorException An internal server error has occurred during the request. For more
     *         information, see the error and message fields.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>StorageGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample StorageGatewayAsyncClient.UpdateSMBSecurityStrategy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/UpdateSMBSecurityStrategy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateSmbSecurityStrategyResponse> updateSMBSecurityStrategy(
            UpdateSmbSecurityStrategyRequest updateSmbSecurityStrategyRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateSmbSecurityStrategyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateSMBSecurityStrategy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateSmbSecurityStrategyResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateSmbSecurityStrategyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateSmbSecurityStrategyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateSmbSecurityStrategyRequest, UpdateSmbSecurityStrategyResponse>()
                            .withOperationName("UpdateSMBSecurityStrategy")
                            .withMarshaller(new UpdateSmbSecurityStrategyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateSmbSecurityStrategyRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateSmbSecurityStrategyRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<UpdateSmbSecurityStrategyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a snapshot schedule configured for a gateway volume. This operation is only supported in the cached
     * volume and stored volume gateway types.
     * </p>
     * <p>
     * The default snapshot schedule for volume is once every 24 hours, starting at the creation time of the volume. You
     * can use this API to change the snapshot schedule configured for the volume.
     * </p>
     * <p>
     * In the request you must identify the gateway volume whose snapshot schedule you want to update, and the schedule
     * information, including when you want the snapshot to begin on a day and the frequency (in hours) of snapshots.
     * </p>
     *
     * @param updateSnapshotScheduleRequest
     *        A JSON object containing one or more of the following fields:</p>
     *        <ul>
     *        <li>
     *        <p>
     *        <a>UpdateSnapshotScheduleInput&#36Description</a>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <a>UpdateSnapshotScheduleInput&#36RecurrenceInHours</a>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <a>UpdateSnapshotScheduleInput&#36StartAt</a>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <a>UpdateSnapshotScheduleInput&#36VolumeARN</a>
     *        </p>
     *        </li>
     * @return A Java Future containing the result of the UpdateSnapshotSchedule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidGatewayRequestException An exception occurred because an invalid gateway request was issued to
     *         the service. For more information, see the error and message fields.</li>
     *         <li>InternalServerErrorException An internal server error has occurred during the request. For more
     *         information, see the error and message fields.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>StorageGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample StorageGatewayAsyncClient.UpdateSnapshotSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/UpdateSnapshotSchedule"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateSnapshotScheduleResponse> updateSnapshotSchedule(
            UpdateSnapshotScheduleRequest updateSnapshotScheduleRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateSnapshotScheduleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateSnapshotSchedule");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateSnapshotScheduleResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateSnapshotScheduleResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateSnapshotScheduleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateSnapshotScheduleRequest, UpdateSnapshotScheduleResponse>()
                            .withOperationName("UpdateSnapshotSchedule")
                            .withMarshaller(new UpdateSnapshotScheduleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateSnapshotScheduleRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateSnapshotScheduleRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<UpdateSnapshotScheduleResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the type of medium changer in a tape gateway. When you activate a tape gateway, you select a medium
     * changer type for the tape gateway. This operation enables you to select a different type of medium changer after
     * a tape gateway is activated. This operation is only supported in the tape gateway type.
     * </p>
     *
     * @param updateVtlDeviceTypeRequest
     * @return A Java Future containing the result of the UpdateVTLDeviceType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidGatewayRequestException An exception occurred because an invalid gateway request was issued to
     *         the service. For more information, see the error and message fields.</li>
     *         <li>InternalServerErrorException An internal server error has occurred during the request. For more
     *         information, see the error and message fields.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>StorageGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample StorageGatewayAsyncClient.UpdateVTLDeviceType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/UpdateVTLDeviceType"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateVtlDeviceTypeResponse> updateVTLDeviceType(
            UpdateVtlDeviceTypeRequest updateVtlDeviceTypeRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateVtlDeviceTypeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateVTLDeviceType");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateVtlDeviceTypeResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateVtlDeviceTypeResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateVtlDeviceTypeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateVtlDeviceTypeRequest, UpdateVtlDeviceTypeResponse>()
                            .withOperationName("UpdateVTLDeviceType")
                            .withMarshaller(new UpdateVtlDeviceTypeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateVtlDeviceTypeRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateVtlDeviceTypeRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<UpdateVtlDeviceTypeResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public void close() {
        clientHandler.close();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(StorageGatewayException::builder)
                .protocol(AwsJsonProtocol.AWS_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidGatewayRequestException")
                                .exceptionBuilderSupplier(InvalidGatewayRequestException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ServiceUnavailableError")
                                .exceptionBuilderSupplier(ServiceUnavailableErrorException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InternalServerError")
                                .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private <T extends StorageGatewayRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder()
                .version(VersionInfo.SDK_VERSION).name("PAGINATED").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration()
                .map(c -> c.toBuilder().applyMutation(userAgentApplier).build())
                .orElse((AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier).build()));
        return (T) request.toBuilder().overrideConfiguration(overrideConfiguration).build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }
}
