/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A JSON object containing one or more of the following fields:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a>CreateStorediSCSIVolumeInput$DiskId</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>CreateStorediSCSIVolumeInput$NetworkInterfaceId</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>CreateStorediSCSIVolumeInput$PreserveExistingData</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>CreateStorediSCSIVolumeInput$SnapshotId</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>CreateStorediSCSIVolumeInput$TargetName</a>
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateStorediScsiVolumeRequest extends StorageGatewayRequest implements
        ToCopyableBuilder<CreateStorediScsiVolumeRequest.Builder, CreateStorediScsiVolumeRequest> {
    private static final SdkField<String> GATEWAY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GatewayARN").getter(getter(CreateStorediScsiVolumeRequest::gatewayARN))
            .setter(setter(Builder::gatewayARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayARN").build()).build();

    private static final SdkField<String> DISK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("DiskId")
            .getter(getter(CreateStorediScsiVolumeRequest::diskId)).setter(setter(Builder::diskId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DiskId").build()).build();

    private static final SdkField<String> SNAPSHOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SnapshotId").getter(getter(CreateStorediScsiVolumeRequest::snapshotId))
            .setter(setter(Builder::snapshotId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotId").build()).build();

    private static final SdkField<Boolean> PRESERVE_EXISTING_DATA_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("PreserveExistingData").getter(getter(CreateStorediScsiVolumeRequest::preserveExistingData))
            .setter(setter(Builder::preserveExistingData))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreserveExistingData").build())
            .build();

    private static final SdkField<String> TARGET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetName").getter(getter(CreateStorediScsiVolumeRequest::targetName))
            .setter(setter(Builder::targetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetName").build()).build();

    private static final SdkField<String> NETWORK_INTERFACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NetworkInterfaceId").getter(getter(CreateStorediScsiVolumeRequest::networkInterfaceId))
            .setter(setter(Builder::networkInterfaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceId").build())
            .build();

    private static final SdkField<Boolean> KMS_ENCRYPTED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("KMSEncrypted").getter(getter(CreateStorediScsiVolumeRequest::kmsEncrypted))
            .setter(setter(Builder::kmsEncrypted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KMSEncrypted").build()).build();

    private static final SdkField<String> KMS_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("KMSKey")
            .getter(getter(CreateStorediScsiVolumeRequest::kmsKey)).setter(setter(Builder::kmsKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KMSKey").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateStorediScsiVolumeRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_ARN_FIELD,
            DISK_ID_FIELD, SNAPSHOT_ID_FIELD, PRESERVE_EXISTING_DATA_FIELD, TARGET_NAME_FIELD, NETWORK_INTERFACE_ID_FIELD,
            KMS_ENCRYPTED_FIELD, KMS_KEY_FIELD, TAGS_FIELD));

    private final String gatewayARN;

    private final String diskId;

    private final String snapshotId;

    private final Boolean preserveExistingData;

    private final String targetName;

    private final String networkInterfaceId;

    private final Boolean kmsEncrypted;

    private final String kmsKey;

    private final List<Tag> tags;

    private CreateStorediScsiVolumeRequest(BuilderImpl builder) {
        super(builder);
        this.gatewayARN = builder.gatewayARN;
        this.diskId = builder.diskId;
        this.snapshotId = builder.snapshotId;
        this.preserveExistingData = builder.preserveExistingData;
        this.targetName = builder.targetName;
        this.networkInterfaceId = builder.networkInterfaceId;
        this.kmsEncrypted = builder.kmsEncrypted;
        this.kmsKey = builder.kmsKey;
        this.tags = builder.tags;
    }

    /**
     * Returns the value of the GatewayARN property for this object.
     * 
     * @return The value of the GatewayARN property for this object.
     */
    public final String gatewayARN() {
        return gatewayARN;
    }

    /**
     * <p>
     * The unique identifier for the gateway local disk that is configured as a stored volume. Use <a
     * href="https://docs.aws.amazon.com/storagegateway/latest/userguide/API_ListLocalDisks.html">ListLocalDisks</a> to
     * list disk IDs for a gateway.
     * </p>
     * 
     * @return The unique identifier for the gateway local disk that is configured as a stored volume. Use <a
     *         href="https://docs.aws.amazon.com/storagegateway/latest/userguide/API_ListLocalDisks.html"
     *         >ListLocalDisks</a> to list disk IDs for a gateway.
     */
    public final String diskId() {
        return diskId;
    }

    /**
     * <p>
     * The snapshot ID (e.g., "snap-1122aabb") of the snapshot to restore as the new stored volume. Specify this field
     * if you want to create the iSCSI storage volume from a snapshot; otherwise, do not include this field. To list
     * snapshots for your account use <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/ApiReference-query-DescribeSnapshots.html"
     * >DescribeSnapshots</a> in the <i>Amazon Elastic Compute Cloud API Reference</i>.
     * </p>
     * 
     * @return The snapshot ID (e.g., "snap-1122aabb") of the snapshot to restore as the new stored volume. Specify this
     *         field if you want to create the iSCSI storage volume from a snapshot; otherwise, do not include this
     *         field. To list snapshots for your account use <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/ApiReference-query-DescribeSnapshots.html"
     *         >DescribeSnapshots</a> in the <i>Amazon Elastic Compute Cloud API Reference</i>.
     */
    public final String snapshotId() {
        return snapshotId;
    }

    /**
     * <p>
     * Set to <code>true</code> if you want to preserve the data on the local disk. Otherwise, set to <code>false</code>
     * to create an empty volume.
     * </p>
     * <p>
     * Valid Values: <code>true</code> | <code>false</code>
     * </p>
     * 
     * @return Set to <code>true</code> if you want to preserve the data on the local disk. Otherwise, set to
     *         <code>false</code> to create an empty volume.</p>
     *         <p>
     *         Valid Values: <code>true</code> | <code>false</code>
     */
    public final Boolean preserveExistingData() {
        return preserveExistingData;
    }

    /**
     * <p>
     * The name of the iSCSI target used by an initiator to connect to a volume and used as a suffix for the target ARN.
     * For example, specifying <code>TargetName</code> as <i>myvolume</i> results in the target ARN of
     * <code>arn:aws:storagegateway:us-east-2:111122223333:gateway/sgw-12A3456B/target/iqn.1997-05.com.amazon:myvolume</code>
     * . The target name must be unique across all volumes on a gateway.
     * </p>
     * <p>
     * If you don't specify a value, Storage Gateway uses the value that was previously used for this volume as the new
     * target name.
     * </p>
     * 
     * @return The name of the iSCSI target used by an initiator to connect to a volume and used as a suffix for the
     *         target ARN. For example, specifying <code>TargetName</code> as <i>myvolume</i> results in the target ARN
     *         of
     *         <code>arn:aws:storagegateway:us-east-2:111122223333:gateway/sgw-12A3456B/target/iqn.1997-05.com.amazon:myvolume</code>
     *         . The target name must be unique across all volumes on a gateway.</p>
     *         <p>
     *         If you don't specify a value, Storage Gateway uses the value that was previously used for this volume as
     *         the new target name.
     */
    public final String targetName() {
        return targetName;
    }

    /**
     * <p>
     * The network interface of the gateway on which to expose the iSCSI target. Only IPv4 addresses are accepted. Use
     * <a>DescribeGatewayInformation</a> to get a list of the network interfaces available on a gateway.
     * </p>
     * <p>
     * Valid Values: A valid IP address.
     * </p>
     * 
     * @return The network interface of the gateway on which to expose the iSCSI target. Only IPv4 addresses are
     *         accepted. Use <a>DescribeGatewayInformation</a> to get a list of the network interfaces available on a
     *         gateway.</p>
     *         <p>
     *         Valid Values: A valid IP address.
     */
    public final String networkInterfaceId() {
        return networkInterfaceId;
    }

    /**
     * <p>
     * Set to <code>true</code> to use Amazon S3 server-side encryption with your own KMS key, or <code>false</code> to
     * use a key managed by Amazon S3. Optional.
     * </p>
     * <p>
     * Valid Values: <code>true</code> | <code>false</code>
     * </p>
     * 
     * @return Set to <code>true</code> to use Amazon S3 server-side encryption with your own KMS key, or
     *         <code>false</code> to use a key managed by Amazon S3. Optional.</p>
     *         <p>
     *         Valid Values: <code>true</code> | <code>false</code>
     */
    public final Boolean kmsEncrypted() {
        return kmsEncrypted;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side
     * encryption. Storage Gateway does not support asymmetric CMKs. This value can only be set when
     * <code>KMSEncrypted</code> is <code>true</code>. Optional.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side
     *         encryption. Storage Gateway does not support asymmetric CMKs. This value can only be set when
     *         <code>KMSEncrypted</code> is <code>true</code>. Optional.
     */
    public final String kmsKey() {
        return kmsKey;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of up to 50 tags that can be assigned to a stored volume. Each tag is a key-value pair.
     * </p>
     * <note>
     * <p>
     * Valid characters for key and value are letters, spaces, and numbers representable in UTF-8 format, and the
     * following special characters: + - = . _ : / @. The maximum length of a tag's key is 128 characters, and the
     * maximum length for a tag's value is 256.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of up to 50 tags that can be assigned to a stored volume. Each tag is a key-value pair.</p> <note>
     *         <p>
     *         Valid characters for key and value are letters, spaces, and numbers representable in UTF-8 format, and
     *         the following special characters: + - = . _ : / @. The maximum length of a tag's key is 128 characters,
     *         and the maximum length for a tag's value is 256.
     *         </p>
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(gatewayARN());
        hashCode = 31 * hashCode + Objects.hashCode(diskId());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotId());
        hashCode = 31 * hashCode + Objects.hashCode(preserveExistingData());
        hashCode = 31 * hashCode + Objects.hashCode(targetName());
        hashCode = 31 * hashCode + Objects.hashCode(networkInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(kmsEncrypted());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKey());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateStorediScsiVolumeRequest)) {
            return false;
        }
        CreateStorediScsiVolumeRequest other = (CreateStorediScsiVolumeRequest) obj;
        return Objects.equals(gatewayARN(), other.gatewayARN()) && Objects.equals(diskId(), other.diskId())
                && Objects.equals(snapshotId(), other.snapshotId())
                && Objects.equals(preserveExistingData(), other.preserveExistingData())
                && Objects.equals(targetName(), other.targetName())
                && Objects.equals(networkInterfaceId(), other.networkInterfaceId())
                && Objects.equals(kmsEncrypted(), other.kmsEncrypted()) && Objects.equals(kmsKey(), other.kmsKey())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateStorediScsiVolumeRequest").add("GatewayARN", gatewayARN()).add("DiskId", diskId())
                .add("SnapshotId", snapshotId()).add("PreserveExistingData", preserveExistingData())
                .add("TargetName", targetName()).add("NetworkInterfaceId", networkInterfaceId())
                .add("KMSEncrypted", kmsEncrypted()).add("KMSKey", kmsKey()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GatewayARN":
            return Optional.ofNullable(clazz.cast(gatewayARN()));
        case "DiskId":
            return Optional.ofNullable(clazz.cast(diskId()));
        case "SnapshotId":
            return Optional.ofNullable(clazz.cast(snapshotId()));
        case "PreserveExistingData":
            return Optional.ofNullable(clazz.cast(preserveExistingData()));
        case "TargetName":
            return Optional.ofNullable(clazz.cast(targetName()));
        case "NetworkInterfaceId":
            return Optional.ofNullable(clazz.cast(networkInterfaceId()));
        case "KMSEncrypted":
            return Optional.ofNullable(clazz.cast(kmsEncrypted()));
        case "KMSKey":
            return Optional.ofNullable(clazz.cast(kmsKey()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateStorediScsiVolumeRequest, T> g) {
        return obj -> g.apply((CreateStorediScsiVolumeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends StorageGatewayRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateStorediScsiVolumeRequest> {
        /**
         * Sets the value of the GatewayARN property for this object.
         *
         * @param gatewayARN
         *        The new value for the GatewayARN property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayARN(String gatewayARN);

        /**
         * <p>
         * The unique identifier for the gateway local disk that is configured as a stored volume. Use <a
         * href="https://docs.aws.amazon.com/storagegateway/latest/userguide/API_ListLocalDisks.html">ListLocalDisks</a>
         * to list disk IDs for a gateway.
         * </p>
         * 
         * @param diskId
         *        The unique identifier for the gateway local disk that is configured as a stored volume. Use <a
         *        href="https://docs.aws.amazon.com/storagegateway/latest/userguide/API_ListLocalDisks.html"
         *        >ListLocalDisks</a> to list disk IDs for a gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder diskId(String diskId);

        /**
         * <p>
         * The snapshot ID (e.g., "snap-1122aabb") of the snapshot to restore as the new stored volume. Specify this
         * field if you want to create the iSCSI storage volume from a snapshot; otherwise, do not include this field.
         * To list snapshots for your account use <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/ApiReference-query-DescribeSnapshots.html"
         * >DescribeSnapshots</a> in the <i>Amazon Elastic Compute Cloud API Reference</i>.
         * </p>
         * 
         * @param snapshotId
         *        The snapshot ID (e.g., "snap-1122aabb") of the snapshot to restore as the new stored volume. Specify
         *        this field if you want to create the iSCSI storage volume from a snapshot; otherwise, do not include
         *        this field. To list snapshots for your account use <a href=
         *        "https://docs.aws.amazon.com/AWSEC2/latest/APIReference/ApiReference-query-DescribeSnapshots.html"
         *        >DescribeSnapshots</a> in the <i>Amazon Elastic Compute Cloud API Reference</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotId(String snapshotId);

        /**
         * <p>
         * Set to <code>true</code> if you want to preserve the data on the local disk. Otherwise, set to
         * <code>false</code> to create an empty volume.
         * </p>
         * <p>
         * Valid Values: <code>true</code> | <code>false</code>
         * </p>
         * 
         * @param preserveExistingData
         *        Set to <code>true</code> if you want to preserve the data on the local disk. Otherwise, set to
         *        <code>false</code> to create an empty volume.</p>
         *        <p>
         *        Valid Values: <code>true</code> | <code>false</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preserveExistingData(Boolean preserveExistingData);

        /**
         * <p>
         * The name of the iSCSI target used by an initiator to connect to a volume and used as a suffix for the target
         * ARN. For example, specifying <code>TargetName</code> as <i>myvolume</i> results in the target ARN of
         * <code>arn:aws:storagegateway:us-east-2:111122223333:gateway/sgw-12A3456B/target/iqn.1997-05.com.amazon:myvolume</code>
         * . The target name must be unique across all volumes on a gateway.
         * </p>
         * <p>
         * If you don't specify a value, Storage Gateway uses the value that was previously used for this volume as the
         * new target name.
         * </p>
         * 
         * @param targetName
         *        The name of the iSCSI target used by an initiator to connect to a volume and used as a suffix for the
         *        target ARN. For example, specifying <code>TargetName</code> as <i>myvolume</i> results in the target
         *        ARN of
         *        <code>arn:aws:storagegateway:us-east-2:111122223333:gateway/sgw-12A3456B/target/iqn.1997-05.com.amazon:myvolume</code>
         *        . The target name must be unique across all volumes on a gateway.</p>
         *        <p>
         *        If you don't specify a value, Storage Gateway uses the value that was previously used for this volume
         *        as the new target name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetName(String targetName);

        /**
         * <p>
         * The network interface of the gateway on which to expose the iSCSI target. Only IPv4 addresses are accepted.
         * Use <a>DescribeGatewayInformation</a> to get a list of the network interfaces available on a gateway.
         * </p>
         * <p>
         * Valid Values: A valid IP address.
         * </p>
         * 
         * @param networkInterfaceId
         *        The network interface of the gateway on which to expose the iSCSI target. Only IPv4 addresses are
         *        accepted. Use <a>DescribeGatewayInformation</a> to get a list of the network interfaces available on a
         *        gateway.</p>
         *        <p>
         *        Valid Values: A valid IP address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaceId(String networkInterfaceId);

        /**
         * <p>
         * Set to <code>true</code> to use Amazon S3 server-side encryption with your own KMS key, or <code>false</code>
         * to use a key managed by Amazon S3. Optional.
         * </p>
         * <p>
         * Valid Values: <code>true</code> | <code>false</code>
         * </p>
         * 
         * @param kmsEncrypted
         *        Set to <code>true</code> to use Amazon S3 server-side encryption with your own KMS key, or
         *        <code>false</code> to use a key managed by Amazon S3. Optional.</p>
         *        <p>
         *        Valid Values: <code>true</code> | <code>false</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsEncrypted(Boolean kmsEncrypted);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side
         * encryption. Storage Gateway does not support asymmetric CMKs. This value can only be set when
         * <code>KMSEncrypted</code> is <code>true</code>. Optional.
         * </p>
         * 
         * @param kmsKey
         *        The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side
         *        encryption. Storage Gateway does not support asymmetric CMKs. This value can only be set when
         *        <code>KMSEncrypted</code> is <code>true</code>. Optional.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKey(String kmsKey);

        /**
         * <p>
         * A list of up to 50 tags that can be assigned to a stored volume. Each tag is a key-value pair.
         * </p>
         * <note>
         * <p>
         * Valid characters for key and value are letters, spaces, and numbers representable in UTF-8 format, and the
         * following special characters: + - = . _ : / @. The maximum length of a tag's key is 128 characters, and the
         * maximum length for a tag's value is 256.
         * </p>
         * </note>
         * 
         * @param tags
         *        A list of up to 50 tags that can be assigned to a stored volume. Each tag is a key-value pair.</p>
         *        <note>
         *        <p>
         *        Valid characters for key and value are letters, spaces, and numbers representable in UTF-8 format, and
         *        the following special characters: + - = . _ : / @. The maximum length of a tag's key is 128
         *        characters, and the maximum length for a tag's value is 256.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of up to 50 tags that can be assigned to a stored volume. Each tag is a key-value pair.
         * </p>
         * <note>
         * <p>
         * Valid characters for key and value are letters, spaces, and numbers representable in UTF-8 format, and the
         * following special characters: + - = . _ : / @. The maximum length of a tag's key is 128 characters, and the
         * maximum length for a tag's value is 256.
         * </p>
         * </note>
         * 
         * @param tags
         *        A list of up to 50 tags that can be assigned to a stored volume. Each tag is a key-value pair.</p>
         *        <note>
         *        <p>
         *        Valid characters for key and value are letters, spaces, and numbers representable in UTF-8 format, and
         *        the following special characters: + - = . _ : / @. The maximum length of a tag's key is 128
         *        characters, and the maximum length for a tag's value is 256.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of up to 50 tags that can be assigned to a stored volume. Each tag is a key-value pair.
         * </p>
         * <note>
         * <p>
         * Valid characters for key and value are letters, spaces, and numbers representable in UTF-8 format, and the
         * following special characters: + - = . _ : / @. The maximum length of a tag's key is 128 characters, and the
         * maximum length for a tag's value is 256.
         * </p>
         * </note> This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to
         * create one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends StorageGatewayRequest.BuilderImpl implements Builder {
        private String gatewayARN;

        private String diskId;

        private String snapshotId;

        private Boolean preserveExistingData;

        private String targetName;

        private String networkInterfaceId;

        private Boolean kmsEncrypted;

        private String kmsKey;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateStorediScsiVolumeRequest model) {
            super(model);
            gatewayARN(model.gatewayARN);
            diskId(model.diskId);
            snapshotId(model.snapshotId);
            preserveExistingData(model.preserveExistingData);
            targetName(model.targetName);
            networkInterfaceId(model.networkInterfaceId);
            kmsEncrypted(model.kmsEncrypted);
            kmsKey(model.kmsKey);
            tags(model.tags);
        }

        public final String getGatewayARN() {
            return gatewayARN;
        }

        public final void setGatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
        }

        @Override
        @Transient
        public final Builder gatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
            return this;
        }

        public final String getDiskId() {
            return diskId;
        }

        public final void setDiskId(String diskId) {
            this.diskId = diskId;
        }

        @Override
        @Transient
        public final Builder diskId(String diskId) {
            this.diskId = diskId;
            return this;
        }

        public final String getSnapshotId() {
            return snapshotId;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        @Override
        @Transient
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final Boolean getPreserveExistingData() {
            return preserveExistingData;
        }

        public final void setPreserveExistingData(Boolean preserveExistingData) {
            this.preserveExistingData = preserveExistingData;
        }

        @Override
        @Transient
        public final Builder preserveExistingData(Boolean preserveExistingData) {
            this.preserveExistingData = preserveExistingData;
            return this;
        }

        public final String getTargetName() {
            return targetName;
        }

        public final void setTargetName(String targetName) {
            this.targetName = targetName;
        }

        @Override
        @Transient
        public final Builder targetName(String targetName) {
            this.targetName = targetName;
            return this;
        }

        public final String getNetworkInterfaceId() {
            return networkInterfaceId;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        @Override
        @Transient
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final Boolean getKmsEncrypted() {
            return kmsEncrypted;
        }

        public final void setKmsEncrypted(Boolean kmsEncrypted) {
            this.kmsEncrypted = kmsEncrypted;
        }

        @Override
        @Transient
        public final Builder kmsEncrypted(Boolean kmsEncrypted) {
            this.kmsEncrypted = kmsEncrypted;
            return this;
        }

        public final String getKmsKey() {
            return kmsKey;
        }

        public final void setKmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
        }

        @Override
        @Transient
        public final Builder kmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        @Transient
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateStorediScsiVolumeRequest build() {
            return new CreateStorediScsiVolumeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
