/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum HostEnvironment {
    VMWARE("VMWARE"),
    HYPER_V("HYPER-V"),
    EC2("EC2"),
    KVM("KVM"),
    OTHER("OTHER"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, HostEnvironment> VALUE_MAP;
    private final String value;

    private HostEnvironment(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static HostEnvironment fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<HostEnvironment> knownValues() {
        EnumSet<HostEnvironment> knownValues = EnumSet.allOf(HostEnvironment.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(HostEnvironment.class, HostEnvironment::toString);
    }
}

