/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A JSON object containing one or more of the following fields:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a>ActivateGatewayInput$ActivationKey</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>ActivateGatewayInput$GatewayName</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>ActivateGatewayInput$GatewayRegion</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>ActivateGatewayInput$GatewayTimezone</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>ActivateGatewayInput$GatewayType</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>ActivateGatewayInput$MediumChangerType</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>ActivateGatewayInput$TapeDriveType</a>
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ActivateGatewayRequest extends StorageGatewayRequest implements
        ToCopyableBuilder<ActivateGatewayRequest.Builder, ActivateGatewayRequest> {
    private static final SdkField<String> ACTIVATION_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ActivationKey").getter(getter(ActivateGatewayRequest::activationKey))
            .setter(setter(Builder::activationKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActivationKey").build()).build();

    private static final SdkField<String> GATEWAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GatewayName").getter(getter(ActivateGatewayRequest::gatewayName)).setter(setter(Builder::gatewayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayName").build()).build();

    private static final SdkField<String> GATEWAY_TIMEZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GatewayTimezone").getter(getter(ActivateGatewayRequest::gatewayTimezone))
            .setter(setter(Builder::gatewayTimezone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayTimezone").build()).build();

    private static final SdkField<String> GATEWAY_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GatewayRegion").getter(getter(ActivateGatewayRequest::gatewayRegion))
            .setter(setter(Builder::gatewayRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayRegion").build()).build();

    private static final SdkField<String> GATEWAY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GatewayType").getter(getter(ActivateGatewayRequest::gatewayType)).setter(setter(Builder::gatewayType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayType").build()).build();

    private static final SdkField<String> TAPE_DRIVE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TapeDriveType").getter(getter(ActivateGatewayRequest::tapeDriveType))
            .setter(setter(Builder::tapeDriveType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TapeDriveType").build()).build();

    private static final SdkField<String> MEDIUM_CHANGER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MediumChangerType").getter(getter(ActivateGatewayRequest::mediumChangerType))
            .setter(setter(Builder::mediumChangerType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediumChangerType").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(ActivateGatewayRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIVATION_KEY_FIELD,
            GATEWAY_NAME_FIELD, GATEWAY_TIMEZONE_FIELD, GATEWAY_REGION_FIELD, GATEWAY_TYPE_FIELD, TAPE_DRIVE_TYPE_FIELD,
            MEDIUM_CHANGER_TYPE_FIELD, TAGS_FIELD));

    private final String activationKey;

    private final String gatewayName;

    private final String gatewayTimezone;

    private final String gatewayRegion;

    private final String gatewayType;

    private final String tapeDriveType;

    private final String mediumChangerType;

    private final List<Tag> tags;

    private ActivateGatewayRequest(BuilderImpl builder) {
        super(builder);
        this.activationKey = builder.activationKey;
        this.gatewayName = builder.gatewayName;
        this.gatewayTimezone = builder.gatewayTimezone;
        this.gatewayRegion = builder.gatewayRegion;
        this.gatewayType = builder.gatewayType;
        this.tapeDriveType = builder.tapeDriveType;
        this.mediumChangerType = builder.mediumChangerType;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * Your gateway activation key. You can obtain the activation key by sending an HTTP GET request with redirects
     * enabled to the gateway IP address (port 80). The redirect URL returned in the response provides you the
     * activation key for your gateway in the query string parameter <code>activationKey</code>. It may also include
     * other activation-related parameters, however, these are merely defaults -- the arguments you pass to the
     * <code>ActivateGateway</code> API call determine the actual configuration of your gateway.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/storagegateway/latest/userguide/get-activation-key.html">Getting activation
     * key</a> in the <i>Storage Gateway User Guide</i>.
     * </p>
     * 
     * @return Your gateway activation key. You can obtain the activation key by sending an HTTP GET request with
     *         redirects enabled to the gateway IP address (port 80). The redirect URL returned in the response provides
     *         you the activation key for your gateway in the query string parameter <code>activationKey</code>. It may
     *         also include other activation-related parameters, however, these are merely defaults -- the arguments you
     *         pass to the <code>ActivateGateway</code> API call determine the actual configuration of your gateway.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/storagegateway/latest/userguide/get-activation-key.html">Getting
     *         activation key</a> in the <i>Storage Gateway User Guide</i>.
     */
    public final String activationKey() {
        return activationKey;
    }

    /**
     * <p>
     * The name you configured for your gateway.
     * </p>
     * 
     * @return The name you configured for your gateway.
     */
    public final String gatewayName() {
        return gatewayName;
    }

    /**
     * <p>
     * A value that indicates the time zone you want to set for the gateway. The time zone is of the format "GMT-hr:mm"
     * or "GMT+hr:mm". For example, GMT-4:00 indicates the time is 4 hours behind GMT. GMT+2:00 indicates the time is 2
     * hours ahead of GMT. The time zone is used, for example, for scheduling snapshots and your gateway's maintenance
     * schedule.
     * </p>
     * 
     * @return A value that indicates the time zone you want to set for the gateway. The time zone is of the format
     *         "GMT-hr:mm" or "GMT+hr:mm". For example, GMT-4:00 indicates the time is 4 hours behind GMT. GMT+2:00
     *         indicates the time is 2 hours ahead of GMT. The time zone is used, for example, for scheduling snapshots
     *         and your gateway's maintenance schedule.
     */
    public final String gatewayTimezone() {
        return gatewayTimezone;
    }

    /**
     * <p>
     * A value that indicates the Amazon Web Services Region where you want to store your data. The gateway Amazon Web
     * Services Region specified must be the same Amazon Web Services Region as the Amazon Web Services Region in your
     * <code>Host</code> header in the request. For more information about available Amazon Web Services Regions and
     * endpoints for Storage Gateway, see <a href="https://docs.aws.amazon.com/general/latest/gr/sg.html"> Storage
     * Gateway endpoints and quotas</a> in the <i>Amazon Web Services General Reference</i>.
     * </p>
     * <p>
     * Valid Values: See <a href="https://docs.aws.amazon.com/general/latest/gr/sg.html"> Storage Gateway endpoints and
     * quotas</a> in the <i>Amazon Web Services General Reference</i>.
     * </p>
     * 
     * @return A value that indicates the Amazon Web Services Region where you want to store your data. The gateway
     *         Amazon Web Services Region specified must be the same Amazon Web Services Region as the Amazon Web
     *         Services Region in your <code>Host</code> header in the request. For more information about available
     *         Amazon Web Services Regions and endpoints for Storage Gateway, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/sg.html"> Storage Gateway endpoints and quotas</a> in
     *         the <i>Amazon Web Services General Reference</i>.</p>
     *         <p>
     *         Valid Values: See <a href="https://docs.aws.amazon.com/general/latest/gr/sg.html"> Storage Gateway
     *         endpoints and quotas</a> in the <i>Amazon Web Services General Reference</i>.
     */
    public final String gatewayRegion() {
        return gatewayRegion;
    }

    /**
     * <p>
     * A value that defines the type of gateway to activate. The type specified is critical to all later functions of
     * the gateway and cannot be changed after activation. The default value is <code>CACHED</code>.
     * </p>
     * <p>
     * Valid Values: <code>STORED</code> | <code>CACHED</code> | <code>VTL</code> | <code>FILE_S3</code> |
     * <code>FILE_FSX_SMB|</code>
     * </p>
     * 
     * @return A value that defines the type of gateway to activate. The type specified is critical to all later
     *         functions of the gateway and cannot be changed after activation. The default value is <code>CACHED</code>
     *         .</p>
     *         <p>
     *         Valid Values: <code>STORED</code> | <code>CACHED</code> | <code>VTL</code> | <code>FILE_S3</code> |
     *         <code>FILE_FSX_SMB|</code>
     */
    public final String gatewayType() {
        return gatewayType;
    }

    /**
     * <p>
     * The value that indicates the type of tape drive to use for tape gateway. This field is optional.
     * </p>
     * <p>
     * Valid Values: <code>IBM-ULT3580-TD5</code>
     * </p>
     * 
     * @return The value that indicates the type of tape drive to use for tape gateway. This field is optional.</p>
     *         <p>
     *         Valid Values: <code>IBM-ULT3580-TD5</code>
     */
    public final String tapeDriveType() {
        return tapeDriveType;
    }

    /**
     * <p>
     * The value that indicates the type of medium changer to use for tape gateway. This field is optional.
     * </p>
     * <p>
     * Valid Values: <code>STK-L700</code> | <code>AWS-Gateway-VTL</code> | <code>IBM-03584L32-0402</code>
     * </p>
     * 
     * @return The value that indicates the type of medium changer to use for tape gateway. This field is optional.</p>
     *         <p>
     *         Valid Values: <code>STK-L700</code> | <code>AWS-Gateway-VTL</code> | <code>IBM-03584L32-0402</code>
     */
    public final String mediumChangerType() {
        return mediumChangerType;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of up to 50 tags that you can assign to the gateway. Each tag is a key-value pair.
     * </p>
     * <note>
     * <p>
     * Valid characters for key and value are letters, spaces, and numbers that can be represented in UTF-8 format, and
     * the following special characters: + - = . _ : / @. The maximum length of a tag's key is 128 characters, and the
     * maximum length for a tag's value is 256 characters.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of up to 50 tags that you can assign to the gateway. Each tag is a key-value pair.</p> <note>
     *         <p>
     *         Valid characters for key and value are letters, spaces, and numbers that can be represented in UTF-8
     *         format, and the following special characters: + - = . _ : / @. The maximum length of a tag's key is 128
     *         characters, and the maximum length for a tag's value is 256 characters.
     *         </p>
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(activationKey());
        hashCode = 31 * hashCode + Objects.hashCode(gatewayName());
        hashCode = 31 * hashCode + Objects.hashCode(gatewayTimezone());
        hashCode = 31 * hashCode + Objects.hashCode(gatewayRegion());
        hashCode = 31 * hashCode + Objects.hashCode(gatewayType());
        hashCode = 31 * hashCode + Objects.hashCode(tapeDriveType());
        hashCode = 31 * hashCode + Objects.hashCode(mediumChangerType());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActivateGatewayRequest)) {
            return false;
        }
        ActivateGatewayRequest other = (ActivateGatewayRequest) obj;
        return Objects.equals(activationKey(), other.activationKey()) && Objects.equals(gatewayName(), other.gatewayName())
                && Objects.equals(gatewayTimezone(), other.gatewayTimezone())
                && Objects.equals(gatewayRegion(), other.gatewayRegion()) && Objects.equals(gatewayType(), other.gatewayType())
                && Objects.equals(tapeDriveType(), other.tapeDriveType())
                && Objects.equals(mediumChangerType(), other.mediumChangerType()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ActivateGatewayRequest").add("ActivationKey", activationKey()).add("GatewayName", gatewayName())
                .add("GatewayTimezone", gatewayTimezone()).add("GatewayRegion", gatewayRegion())
                .add("GatewayType", gatewayType()).add("TapeDriveType", tapeDriveType())
                .add("MediumChangerType", mediumChangerType()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ActivationKey":
            return Optional.ofNullable(clazz.cast(activationKey()));
        case "GatewayName":
            return Optional.ofNullable(clazz.cast(gatewayName()));
        case "GatewayTimezone":
            return Optional.ofNullable(clazz.cast(gatewayTimezone()));
        case "GatewayRegion":
            return Optional.ofNullable(clazz.cast(gatewayRegion()));
        case "GatewayType":
            return Optional.ofNullable(clazz.cast(gatewayType()));
        case "TapeDriveType":
            return Optional.ofNullable(clazz.cast(tapeDriveType()));
        case "MediumChangerType":
            return Optional.ofNullable(clazz.cast(mediumChangerType()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ActivateGatewayRequest, T> g) {
        return obj -> g.apply((ActivateGatewayRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends StorageGatewayRequest.Builder, SdkPojo, CopyableBuilder<Builder, ActivateGatewayRequest> {
        /**
         * <p>
         * Your gateway activation key. You can obtain the activation key by sending an HTTP GET request with redirects
         * enabled to the gateway IP address (port 80). The redirect URL returned in the response provides you the
         * activation key for your gateway in the query string parameter <code>activationKey</code>. It may also include
         * other activation-related parameters, however, these are merely defaults -- the arguments you pass to the
         * <code>ActivateGateway</code> API call determine the actual configuration of your gateway.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/storagegateway/latest/userguide/get-activation-key.html">Getting activation
         * key</a> in the <i>Storage Gateway User Guide</i>.
         * </p>
         * 
         * @param activationKey
         *        Your gateway activation key. You can obtain the activation key by sending an HTTP GET request with
         *        redirects enabled to the gateway IP address (port 80). The redirect URL returned in the response
         *        provides you the activation key for your gateway in the query string parameter
         *        <code>activationKey</code>. It may also include other activation-related parameters, however, these
         *        are merely defaults -- the arguments you pass to the <code>ActivateGateway</code> API call determine
         *        the actual configuration of your gateway.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/storagegateway/latest/userguide/get-activation-key.html">Getting
         *        activation key</a> in the <i>Storage Gateway User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activationKey(String activationKey);

        /**
         * <p>
         * The name you configured for your gateway.
         * </p>
         * 
         * @param gatewayName
         *        The name you configured for your gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayName(String gatewayName);

        /**
         * <p>
         * A value that indicates the time zone you want to set for the gateway. The time zone is of the format
         * "GMT-hr:mm" or "GMT+hr:mm". For example, GMT-4:00 indicates the time is 4 hours behind GMT. GMT+2:00
         * indicates the time is 2 hours ahead of GMT. The time zone is used, for example, for scheduling snapshots and
         * your gateway's maintenance schedule.
         * </p>
         * 
         * @param gatewayTimezone
         *        A value that indicates the time zone you want to set for the gateway. The time zone is of the format
         *        "GMT-hr:mm" or "GMT+hr:mm". For example, GMT-4:00 indicates the time is 4 hours behind GMT. GMT+2:00
         *        indicates the time is 2 hours ahead of GMT. The time zone is used, for example, for scheduling
         *        snapshots and your gateway's maintenance schedule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayTimezone(String gatewayTimezone);

        /**
         * <p>
         * A value that indicates the Amazon Web Services Region where you want to store your data. The gateway Amazon
         * Web Services Region specified must be the same Amazon Web Services Region as the Amazon Web Services Region
         * in your <code>Host</code> header in the request. For more information about available Amazon Web Services
         * Regions and endpoints for Storage Gateway, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/sg.html"> Storage Gateway endpoints and quotas</a> in the
         * <i>Amazon Web Services General Reference</i>.
         * </p>
         * <p>
         * Valid Values: See <a href="https://docs.aws.amazon.com/general/latest/gr/sg.html"> Storage Gateway endpoints
         * and quotas</a> in the <i>Amazon Web Services General Reference</i>.
         * </p>
         * 
         * @param gatewayRegion
         *        A value that indicates the Amazon Web Services Region where you want to store your data. The gateway
         *        Amazon Web Services Region specified must be the same Amazon Web Services Region as the Amazon Web
         *        Services Region in your <code>Host</code> header in the request. For more information about available
         *        Amazon Web Services Regions and endpoints for Storage Gateway, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/sg.html"> Storage Gateway endpoints and quotas</a>
         *        in the <i>Amazon Web Services General Reference</i>.</p>
         *        <p>
         *        Valid Values: See <a href="https://docs.aws.amazon.com/general/latest/gr/sg.html"> Storage Gateway
         *        endpoints and quotas</a> in the <i>Amazon Web Services General Reference</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayRegion(String gatewayRegion);

        /**
         * <p>
         * A value that defines the type of gateway to activate. The type specified is critical to all later functions
         * of the gateway and cannot be changed after activation. The default value is <code>CACHED</code>.
         * </p>
         * <p>
         * Valid Values: <code>STORED</code> | <code>CACHED</code> | <code>VTL</code> | <code>FILE_S3</code> |
         * <code>FILE_FSX_SMB|</code>
         * </p>
         * 
         * @param gatewayType
         *        A value that defines the type of gateway to activate. The type specified is critical to all later
         *        functions of the gateway and cannot be changed after activation. The default value is
         *        <code>CACHED</code>.</p>
         *        <p>
         *        Valid Values: <code>STORED</code> | <code>CACHED</code> | <code>VTL</code> | <code>FILE_S3</code> |
         *        <code>FILE_FSX_SMB|</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayType(String gatewayType);

        /**
         * <p>
         * The value that indicates the type of tape drive to use for tape gateway. This field is optional.
         * </p>
         * <p>
         * Valid Values: <code>IBM-ULT3580-TD5</code>
         * </p>
         * 
         * @param tapeDriveType
         *        The value that indicates the type of tape drive to use for tape gateway. This field is optional.</p>
         *        <p>
         *        Valid Values: <code>IBM-ULT3580-TD5</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tapeDriveType(String tapeDriveType);

        /**
         * <p>
         * The value that indicates the type of medium changer to use for tape gateway. This field is optional.
         * </p>
         * <p>
         * Valid Values: <code>STK-L700</code> | <code>AWS-Gateway-VTL</code> | <code>IBM-03584L32-0402</code>
         * </p>
         * 
         * @param mediumChangerType
         *        The value that indicates the type of medium changer to use for tape gateway. This field is
         *        optional.</p>
         *        <p>
         *        Valid Values: <code>STK-L700</code> | <code>AWS-Gateway-VTL</code> | <code>IBM-03584L32-0402</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediumChangerType(String mediumChangerType);

        /**
         * <p>
         * A list of up to 50 tags that you can assign to the gateway. Each tag is a key-value pair.
         * </p>
         * <note>
         * <p>
         * Valid characters for key and value are letters, spaces, and numbers that can be represented in UTF-8 format,
         * and the following special characters: + - = . _ : / @. The maximum length of a tag's key is 128 characters,
         * and the maximum length for a tag's value is 256 characters.
         * </p>
         * </note>
         * 
         * @param tags
         *        A list of up to 50 tags that you can assign to the gateway. Each tag is a key-value pair.</p> <note>
         *        <p>
         *        Valid characters for key and value are letters, spaces, and numbers that can be represented in UTF-8
         *        format, and the following special characters: + - = . _ : / @. The maximum length of a tag's key is
         *        128 characters, and the maximum length for a tag's value is 256 characters.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of up to 50 tags that you can assign to the gateway. Each tag is a key-value pair.
         * </p>
         * <note>
         * <p>
         * Valid characters for key and value are letters, spaces, and numbers that can be represented in UTF-8 format,
         * and the following special characters: + - = . _ : / @. The maximum length of a tag's key is 128 characters,
         * and the maximum length for a tag's value is 256 characters.
         * </p>
         * </note>
         * 
         * @param tags
         *        A list of up to 50 tags that you can assign to the gateway. Each tag is a key-value pair.</p> <note>
         *        <p>
         *        Valid characters for key and value are letters, spaces, and numbers that can be represented in UTF-8
         *        format, and the following special characters: + - = . _ : / @. The maximum length of a tag's key is
         *        128 characters, and the maximum length for a tag's value is 256 characters.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of up to 50 tags that you can assign to the gateway. Each tag is a key-value pair.
         * </p>
         * <note>
         * <p>
         * Valid characters for key and value are letters, spaces, and numbers that can be represented in UTF-8 format,
         * and the following special characters: + - = . _ : / @. The maximum length of a tag's key is 128 characters,
         * and the maximum length for a tag's value is 256 characters.
         * </p>
         * </note> This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to
         * create one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends StorageGatewayRequest.BuilderImpl implements Builder {
        private String activationKey;

        private String gatewayName;

        private String gatewayTimezone;

        private String gatewayRegion;

        private String gatewayType;

        private String tapeDriveType;

        private String mediumChangerType;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ActivateGatewayRequest model) {
            super(model);
            activationKey(model.activationKey);
            gatewayName(model.gatewayName);
            gatewayTimezone(model.gatewayTimezone);
            gatewayRegion(model.gatewayRegion);
            gatewayType(model.gatewayType);
            tapeDriveType(model.tapeDriveType);
            mediumChangerType(model.mediumChangerType);
            tags(model.tags);
        }

        public final String getActivationKey() {
            return activationKey;
        }

        public final void setActivationKey(String activationKey) {
            this.activationKey = activationKey;
        }

        @Override
        @Transient
        public final Builder activationKey(String activationKey) {
            this.activationKey = activationKey;
            return this;
        }

        public final String getGatewayName() {
            return gatewayName;
        }

        public final void setGatewayName(String gatewayName) {
            this.gatewayName = gatewayName;
        }

        @Override
        @Transient
        public final Builder gatewayName(String gatewayName) {
            this.gatewayName = gatewayName;
            return this;
        }

        public final String getGatewayTimezone() {
            return gatewayTimezone;
        }

        public final void setGatewayTimezone(String gatewayTimezone) {
            this.gatewayTimezone = gatewayTimezone;
        }

        @Override
        @Transient
        public final Builder gatewayTimezone(String gatewayTimezone) {
            this.gatewayTimezone = gatewayTimezone;
            return this;
        }

        public final String getGatewayRegion() {
            return gatewayRegion;
        }

        public final void setGatewayRegion(String gatewayRegion) {
            this.gatewayRegion = gatewayRegion;
        }

        @Override
        @Transient
        public final Builder gatewayRegion(String gatewayRegion) {
            this.gatewayRegion = gatewayRegion;
            return this;
        }

        public final String getGatewayType() {
            return gatewayType;
        }

        public final void setGatewayType(String gatewayType) {
            this.gatewayType = gatewayType;
        }

        @Override
        @Transient
        public final Builder gatewayType(String gatewayType) {
            this.gatewayType = gatewayType;
            return this;
        }

        public final String getTapeDriveType() {
            return tapeDriveType;
        }

        public final void setTapeDriveType(String tapeDriveType) {
            this.tapeDriveType = tapeDriveType;
        }

        @Override
        @Transient
        public final Builder tapeDriveType(String tapeDriveType) {
            this.tapeDriveType = tapeDriveType;
            return this;
        }

        public final String getMediumChangerType() {
            return mediumChangerType;
        }

        public final void setMediumChangerType(String mediumChangerType) {
            this.mediumChangerType = mediumChangerType;
        }

        @Override
        @Transient
        public final Builder mediumChangerType(String mediumChangerType) {
            this.mediumChangerType = mediumChangerType;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        @Transient
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ActivateGatewayRequest build() {
            return new ActivateGatewayRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
