/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a gateway object.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GatewayInfo implements SdkPojo, Serializable, ToCopyableBuilder<GatewayInfo.Builder, GatewayInfo> {
    private static final SdkField<String> GATEWAY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GatewayId").getter(getter(GatewayInfo::gatewayId)).setter(setter(Builder::gatewayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayId").build()).build();

    private static final SdkField<String> GATEWAY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GatewayARN").getter(getter(GatewayInfo::gatewayARN)).setter(setter(Builder::gatewayARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayARN").build()).build();

    private static final SdkField<String> GATEWAY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GatewayType").getter(getter(GatewayInfo::gatewayType)).setter(setter(Builder::gatewayType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayType").build()).build();

    private static final SdkField<String> GATEWAY_OPERATIONAL_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GatewayOperationalState").getter(getter(GatewayInfo::gatewayOperationalState))
            .setter(setter(Builder::gatewayOperationalState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayOperationalState").build())
            .build();

    private static final SdkField<String> GATEWAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GatewayName").getter(getter(GatewayInfo::gatewayName)).setter(setter(Builder::gatewayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayName").build()).build();

    private static final SdkField<String> EC2_INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Ec2InstanceId").getter(getter(GatewayInfo::ec2InstanceId)).setter(setter(Builder::ec2InstanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ec2InstanceId").build()).build();

    private static final SdkField<String> EC2_INSTANCE_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Ec2InstanceRegion").getter(getter(GatewayInfo::ec2InstanceRegion))
            .setter(setter(Builder::ec2InstanceRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ec2InstanceRegion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_ID_FIELD,
            GATEWAY_ARN_FIELD, GATEWAY_TYPE_FIELD, GATEWAY_OPERATIONAL_STATE_FIELD, GATEWAY_NAME_FIELD, EC2_INSTANCE_ID_FIELD,
            EC2_INSTANCE_REGION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String gatewayId;

    private final String gatewayARN;

    private final String gatewayType;

    private final String gatewayOperationalState;

    private final String gatewayName;

    private final String ec2InstanceId;

    private final String ec2InstanceRegion;

    private GatewayInfo(BuilderImpl builder) {
        this.gatewayId = builder.gatewayId;
        this.gatewayARN = builder.gatewayARN;
        this.gatewayType = builder.gatewayType;
        this.gatewayOperationalState = builder.gatewayOperationalState;
        this.gatewayName = builder.gatewayName;
        this.ec2InstanceId = builder.ec2InstanceId;
        this.ec2InstanceRegion = builder.ec2InstanceRegion;
    }

    /**
     * <p>
     * The unique identifier assigned to your gateway during activation. This ID becomes part of the gateway Amazon
     * Resource Name (ARN), which you use as input for other operations.
     * </p>
     * 
     * @return The unique identifier assigned to your gateway during activation. This ID becomes part of the gateway
     *         Amazon Resource Name (ARN), which you use as input for other operations.
     */
    public final String gatewayId() {
        return gatewayId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a> operation to return a list of gateways
     * for your account and Amazon Web Services Region.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a> operation to return a list of
     *         gateways for your account and Amazon Web Services Region.
     */
    public final String gatewayARN() {
        return gatewayARN;
    }

    /**
     * <p>
     * The type of the gateway.
     * </p>
     * 
     * @return The type of the gateway.
     */
    public final String gatewayType() {
        return gatewayType;
    }

    /**
     * <p>
     * The state of the gateway.
     * </p>
     * <p>
     * Valid Values: <code>DISABLED</code> | <code>ACTIVE</code>
     * </p>
     * 
     * @return The state of the gateway.</p>
     *         <p>
     *         Valid Values: <code>DISABLED</code> | <code>ACTIVE</code>
     */
    public final String gatewayOperationalState() {
        return gatewayOperationalState;
    }

    /**
     * <p>
     * The name of the gateway.
     * </p>
     * 
     * @return The name of the gateway.
     */
    public final String gatewayName() {
        return gatewayName;
    }

    /**
     * <p>
     * The ID of the Amazon EC2 instance that was used to launch the gateway.
     * </p>
     * 
     * @return The ID of the Amazon EC2 instance that was used to launch the gateway.
     */
    public final String ec2InstanceId() {
        return ec2InstanceId;
    }

    /**
     * <p>
     * The Amazon Web Services Region where the Amazon EC2 instance is located.
     * </p>
     * 
     * @return The Amazon Web Services Region where the Amazon EC2 instance is located.
     */
    public final String ec2InstanceRegion() {
        return ec2InstanceRegion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(gatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(gatewayARN());
        hashCode = 31 * hashCode + Objects.hashCode(gatewayType());
        hashCode = 31 * hashCode + Objects.hashCode(gatewayOperationalState());
        hashCode = 31 * hashCode + Objects.hashCode(gatewayName());
        hashCode = 31 * hashCode + Objects.hashCode(ec2InstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(ec2InstanceRegion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GatewayInfo)) {
            return false;
        }
        GatewayInfo other = (GatewayInfo) obj;
        return Objects.equals(gatewayId(), other.gatewayId()) && Objects.equals(gatewayARN(), other.gatewayARN())
                && Objects.equals(gatewayType(), other.gatewayType())
                && Objects.equals(gatewayOperationalState(), other.gatewayOperationalState())
                && Objects.equals(gatewayName(), other.gatewayName()) && Objects.equals(ec2InstanceId(), other.ec2InstanceId())
                && Objects.equals(ec2InstanceRegion(), other.ec2InstanceRegion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GatewayInfo").add("GatewayId", gatewayId()).add("GatewayARN", gatewayARN())
                .add("GatewayType", gatewayType()).add("GatewayOperationalState", gatewayOperationalState())
                .add("GatewayName", gatewayName()).add("Ec2InstanceId", ec2InstanceId())
                .add("Ec2InstanceRegion", ec2InstanceRegion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GatewayId":
            return Optional.ofNullable(clazz.cast(gatewayId()));
        case "GatewayARN":
            return Optional.ofNullable(clazz.cast(gatewayARN()));
        case "GatewayType":
            return Optional.ofNullable(clazz.cast(gatewayType()));
        case "GatewayOperationalState":
            return Optional.ofNullable(clazz.cast(gatewayOperationalState()));
        case "GatewayName":
            return Optional.ofNullable(clazz.cast(gatewayName()));
        case "Ec2InstanceId":
            return Optional.ofNullable(clazz.cast(ec2InstanceId()));
        case "Ec2InstanceRegion":
            return Optional.ofNullable(clazz.cast(ec2InstanceRegion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GatewayInfo, T> g) {
        return obj -> g.apply((GatewayInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GatewayInfo> {
        /**
         * <p>
         * The unique identifier assigned to your gateway during activation. This ID becomes part of the gateway Amazon
         * Resource Name (ARN), which you use as input for other operations.
         * </p>
         * 
         * @param gatewayId
         *        The unique identifier assigned to your gateway during activation. This ID becomes part of the gateway
         *        Amazon Resource Name (ARN), which you use as input for other operations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayId(String gatewayId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a> operation to return a list of
         * gateways for your account and Amazon Web Services Region.
         * </p>
         * 
         * @param gatewayARN
         *        The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a> operation to return a list
         *        of gateways for your account and Amazon Web Services Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayARN(String gatewayARN);

        /**
         * <p>
         * The type of the gateway.
         * </p>
         * 
         * @param gatewayType
         *        The type of the gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayType(String gatewayType);

        /**
         * <p>
         * The state of the gateway.
         * </p>
         * <p>
         * Valid Values: <code>DISABLED</code> | <code>ACTIVE</code>
         * </p>
         * 
         * @param gatewayOperationalState
         *        The state of the gateway.</p>
         *        <p>
         *        Valid Values: <code>DISABLED</code> | <code>ACTIVE</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayOperationalState(String gatewayOperationalState);

        /**
         * <p>
         * The name of the gateway.
         * </p>
         * 
         * @param gatewayName
         *        The name of the gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayName(String gatewayName);

        /**
         * <p>
         * The ID of the Amazon EC2 instance that was used to launch the gateway.
         * </p>
         * 
         * @param ec2InstanceId
         *        The ID of the Amazon EC2 instance that was used to launch the gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2InstanceId(String ec2InstanceId);

        /**
         * <p>
         * The Amazon Web Services Region where the Amazon EC2 instance is located.
         * </p>
         * 
         * @param ec2InstanceRegion
         *        The Amazon Web Services Region where the Amazon EC2 instance is located.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2InstanceRegion(String ec2InstanceRegion);
    }

    static final class BuilderImpl implements Builder {
        private String gatewayId;

        private String gatewayARN;

        private String gatewayType;

        private String gatewayOperationalState;

        private String gatewayName;

        private String ec2InstanceId;

        private String ec2InstanceRegion;

        private BuilderImpl() {
        }

        private BuilderImpl(GatewayInfo model) {
            gatewayId(model.gatewayId);
            gatewayARN(model.gatewayARN);
            gatewayType(model.gatewayType);
            gatewayOperationalState(model.gatewayOperationalState);
            gatewayName(model.gatewayName);
            ec2InstanceId(model.ec2InstanceId);
            ec2InstanceRegion(model.ec2InstanceRegion);
        }

        public final String getGatewayId() {
            return gatewayId;
        }

        public final void setGatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
        }

        @Override
        @Transient
        public final Builder gatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
            return this;
        }

        public final String getGatewayARN() {
            return gatewayARN;
        }

        public final void setGatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
        }

        @Override
        @Transient
        public final Builder gatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
            return this;
        }

        public final String getGatewayType() {
            return gatewayType;
        }

        public final void setGatewayType(String gatewayType) {
            this.gatewayType = gatewayType;
        }

        @Override
        @Transient
        public final Builder gatewayType(String gatewayType) {
            this.gatewayType = gatewayType;
            return this;
        }

        public final String getGatewayOperationalState() {
            return gatewayOperationalState;
        }

        public final void setGatewayOperationalState(String gatewayOperationalState) {
            this.gatewayOperationalState = gatewayOperationalState;
        }

        @Override
        @Transient
        public final Builder gatewayOperationalState(String gatewayOperationalState) {
            this.gatewayOperationalState = gatewayOperationalState;
            return this;
        }

        public final String getGatewayName() {
            return gatewayName;
        }

        public final void setGatewayName(String gatewayName) {
            this.gatewayName = gatewayName;
        }

        @Override
        @Transient
        public final Builder gatewayName(String gatewayName) {
            this.gatewayName = gatewayName;
            return this;
        }

        public final String getEc2InstanceId() {
            return ec2InstanceId;
        }

        public final void setEc2InstanceId(String ec2InstanceId) {
            this.ec2InstanceId = ec2InstanceId;
        }

        @Override
        @Transient
        public final Builder ec2InstanceId(String ec2InstanceId) {
            this.ec2InstanceId = ec2InstanceId;
            return this;
        }

        public final String getEc2InstanceRegion() {
            return ec2InstanceRegion;
        }

        public final void setEc2InstanceRegion(String ec2InstanceRegion) {
            this.ec2InstanceRegion = ec2InstanceRegion;
        }

        @Override
        @Transient
        public final Builder ec2InstanceRegion(String ec2InstanceRegion) {
            this.ec2InstanceRegion = ec2InstanceRegion;
            return this;
        }

        @Override
        public GatewayInfo build() {
            return new GatewayInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
