/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * JoinDomainOutput
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JoinDomainResponse extends StorageGatewayResponse implements
        ToCopyableBuilder<JoinDomainResponse.Builder, JoinDomainResponse> {
    private static final SdkField<String> GATEWAY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GatewayARN").getter(getter(JoinDomainResponse::gatewayARN)).setter(setter(Builder::gatewayARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayARN").build()).build();

    private static final SdkField<String> ACTIVE_DIRECTORY_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ActiveDirectoryStatus").getter(getter(JoinDomainResponse::activeDirectoryStatusAsString))
            .setter(setter(Builder::activeDirectoryStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActiveDirectoryStatus").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_ARN_FIELD,
            ACTIVE_DIRECTORY_STATUS_FIELD));

    private final String gatewayARN;

    private final String activeDirectoryStatus;

    private JoinDomainResponse(BuilderImpl builder) {
        super(builder);
        this.gatewayARN = builder.gatewayARN;
        this.activeDirectoryStatus = builder.activeDirectoryStatus;
    }

    /**
     * <p>
     * The unique Amazon Resource Name (ARN) of the gateway that joined the domain.
     * </p>
     * 
     * @return The unique Amazon Resource Name (ARN) of the gateway that joined the domain.
     */
    public final String gatewayARN() {
        return gatewayARN;
    }

    /**
     * <p>
     * Indicates the status of the gateway as a member of the Active Directory domain.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ACCESS_DENIED</code>: Indicates that the <code>JoinDomain</code> operation failed due to an authentication
     * error.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DETACHED</code>: Indicates that gateway is not joined to a domain.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>JOINED</code>: Indicates that the gateway has successfully joined a domain.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>JOINING</code>: Indicates that a <code>JoinDomain</code> operation is in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NETWORK_ERROR</code>: Indicates that <code>JoinDomain</code> operation failed due to a network or
     * connectivity error.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TIMEOUT</code>: Indicates that the <code>JoinDomain</code> operation failed because the operation didn't
     * complete within the allotted time.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UNKNOWN_ERROR</code>: Indicates that the <code>JoinDomain</code> operation failed due to another type of
     * error.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #activeDirectoryStatus} will return {@link ActiveDirectoryStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #activeDirectoryStatusAsString}.
     * </p>
     * 
     * @return Indicates the status of the gateway as a member of the Active Directory domain.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ACCESS_DENIED</code>: Indicates that the <code>JoinDomain</code> operation failed due to an
     *         authentication error.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DETACHED</code>: Indicates that gateway is not joined to a domain.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>JOINED</code>: Indicates that the gateway has successfully joined a domain.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>JOINING</code>: Indicates that a <code>JoinDomain</code> operation is in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NETWORK_ERROR</code>: Indicates that <code>JoinDomain</code> operation failed due to a network or
     *         connectivity error.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TIMEOUT</code>: Indicates that the <code>JoinDomain</code> operation failed because the operation
     *         didn't complete within the allotted time.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UNKNOWN_ERROR</code>: Indicates that the <code>JoinDomain</code> operation failed due to another
     *         type of error.
     *         </p>
     *         </li>
     * @see ActiveDirectoryStatus
     */
    public final ActiveDirectoryStatus activeDirectoryStatus() {
        return ActiveDirectoryStatus.fromValue(activeDirectoryStatus);
    }

    /**
     * <p>
     * Indicates the status of the gateway as a member of the Active Directory domain.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ACCESS_DENIED</code>: Indicates that the <code>JoinDomain</code> operation failed due to an authentication
     * error.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DETACHED</code>: Indicates that gateway is not joined to a domain.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>JOINED</code>: Indicates that the gateway has successfully joined a domain.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>JOINING</code>: Indicates that a <code>JoinDomain</code> operation is in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NETWORK_ERROR</code>: Indicates that <code>JoinDomain</code> operation failed due to a network or
     * connectivity error.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TIMEOUT</code>: Indicates that the <code>JoinDomain</code> operation failed because the operation didn't
     * complete within the allotted time.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UNKNOWN_ERROR</code>: Indicates that the <code>JoinDomain</code> operation failed due to another type of
     * error.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #activeDirectoryStatus} will return {@link ActiveDirectoryStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #activeDirectoryStatusAsString}.
     * </p>
     * 
     * @return Indicates the status of the gateway as a member of the Active Directory domain.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ACCESS_DENIED</code>: Indicates that the <code>JoinDomain</code> operation failed due to an
     *         authentication error.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DETACHED</code>: Indicates that gateway is not joined to a domain.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>JOINED</code>: Indicates that the gateway has successfully joined a domain.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>JOINING</code>: Indicates that a <code>JoinDomain</code> operation is in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NETWORK_ERROR</code>: Indicates that <code>JoinDomain</code> operation failed due to a network or
     *         connectivity error.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TIMEOUT</code>: Indicates that the <code>JoinDomain</code> operation failed because the operation
     *         didn't complete within the allotted time.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UNKNOWN_ERROR</code>: Indicates that the <code>JoinDomain</code> operation failed due to another
     *         type of error.
     *         </p>
     *         </li>
     * @see ActiveDirectoryStatus
     */
    public final String activeDirectoryStatusAsString() {
        return activeDirectoryStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(gatewayARN());
        hashCode = 31 * hashCode + Objects.hashCode(activeDirectoryStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JoinDomainResponse)) {
            return false;
        }
        JoinDomainResponse other = (JoinDomainResponse) obj;
        return Objects.equals(gatewayARN(), other.gatewayARN())
                && Objects.equals(activeDirectoryStatusAsString(), other.activeDirectoryStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("JoinDomainResponse").add("GatewayARN", gatewayARN())
                .add("ActiveDirectoryStatus", activeDirectoryStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GatewayARN":
            return Optional.ofNullable(clazz.cast(gatewayARN()));
        case "ActiveDirectoryStatus":
            return Optional.ofNullable(clazz.cast(activeDirectoryStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JoinDomainResponse, T> g) {
        return obj -> g.apply((JoinDomainResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends StorageGatewayResponse.Builder, SdkPojo, CopyableBuilder<Builder, JoinDomainResponse> {
        /**
         * <p>
         * The unique Amazon Resource Name (ARN) of the gateway that joined the domain.
         * </p>
         * 
         * @param gatewayARN
         *        The unique Amazon Resource Name (ARN) of the gateway that joined the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayARN(String gatewayARN);

        /**
         * <p>
         * Indicates the status of the gateway as a member of the Active Directory domain.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ACCESS_DENIED</code>: Indicates that the <code>JoinDomain</code> operation failed due to an
         * authentication error.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DETACHED</code>: Indicates that gateway is not joined to a domain.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>JOINED</code>: Indicates that the gateway has successfully joined a domain.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>JOINING</code>: Indicates that a <code>JoinDomain</code> operation is in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NETWORK_ERROR</code>: Indicates that <code>JoinDomain</code> operation failed due to a network or
         * connectivity error.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TIMEOUT</code>: Indicates that the <code>JoinDomain</code> operation failed because the operation
         * didn't complete within the allotted time.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UNKNOWN_ERROR</code>: Indicates that the <code>JoinDomain</code> operation failed due to another type
         * of error.
         * </p>
         * </li>
         * </ul>
         * 
         * @param activeDirectoryStatus
         *        Indicates the status of the gateway as a member of the Active Directory domain.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ACCESS_DENIED</code>: Indicates that the <code>JoinDomain</code> operation failed due to an
         *        authentication error.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DETACHED</code>: Indicates that gateway is not joined to a domain.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>JOINED</code>: Indicates that the gateway has successfully joined a domain.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>JOINING</code>: Indicates that a <code>JoinDomain</code> operation is in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NETWORK_ERROR</code>: Indicates that <code>JoinDomain</code> operation failed due to a network
         *        or connectivity error.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TIMEOUT</code>: Indicates that the <code>JoinDomain</code> operation failed because the
         *        operation didn't complete within the allotted time.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UNKNOWN_ERROR</code>: Indicates that the <code>JoinDomain</code> operation failed due to another
         *        type of error.
         *        </p>
         *        </li>
         * @see ActiveDirectoryStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActiveDirectoryStatus
         */
        Builder activeDirectoryStatus(String activeDirectoryStatus);

        /**
         * <p>
         * Indicates the status of the gateway as a member of the Active Directory domain.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ACCESS_DENIED</code>: Indicates that the <code>JoinDomain</code> operation failed due to an
         * authentication error.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DETACHED</code>: Indicates that gateway is not joined to a domain.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>JOINED</code>: Indicates that the gateway has successfully joined a domain.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>JOINING</code>: Indicates that a <code>JoinDomain</code> operation is in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NETWORK_ERROR</code>: Indicates that <code>JoinDomain</code> operation failed due to a network or
         * connectivity error.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TIMEOUT</code>: Indicates that the <code>JoinDomain</code> operation failed because the operation
         * didn't complete within the allotted time.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UNKNOWN_ERROR</code>: Indicates that the <code>JoinDomain</code> operation failed due to another type
         * of error.
         * </p>
         * </li>
         * </ul>
         * 
         * @param activeDirectoryStatus
         *        Indicates the status of the gateway as a member of the Active Directory domain.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ACCESS_DENIED</code>: Indicates that the <code>JoinDomain</code> operation failed due to an
         *        authentication error.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DETACHED</code>: Indicates that gateway is not joined to a domain.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>JOINED</code>: Indicates that the gateway has successfully joined a domain.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>JOINING</code>: Indicates that a <code>JoinDomain</code> operation is in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NETWORK_ERROR</code>: Indicates that <code>JoinDomain</code> operation failed due to a network
         *        or connectivity error.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TIMEOUT</code>: Indicates that the <code>JoinDomain</code> operation failed because the
         *        operation didn't complete within the allotted time.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UNKNOWN_ERROR</code>: Indicates that the <code>JoinDomain</code> operation failed due to another
         *        type of error.
         *        </p>
         *        </li>
         * @see ActiveDirectoryStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActiveDirectoryStatus
         */
        Builder activeDirectoryStatus(ActiveDirectoryStatus activeDirectoryStatus);
    }

    static final class BuilderImpl extends StorageGatewayResponse.BuilderImpl implements Builder {
        private String gatewayARN;

        private String activeDirectoryStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(JoinDomainResponse model) {
            super(model);
            gatewayARN(model.gatewayARN);
            activeDirectoryStatus(model.activeDirectoryStatus);
        }

        public final String getGatewayARN() {
            return gatewayARN;
        }

        public final void setGatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
        }

        @Override
        @Transient
        public final Builder gatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
            return this;
        }

        public final String getActiveDirectoryStatus() {
            return activeDirectoryStatus;
        }

        public final void setActiveDirectoryStatus(String activeDirectoryStatus) {
            this.activeDirectoryStatus = activeDirectoryStatus;
        }

        @Override
        @Transient
        public final Builder activeDirectoryStatus(String activeDirectoryStatus) {
            this.activeDirectoryStatus = activeDirectoryStatus;
            return this;
        }

        @Override
        @Transient
        public final Builder activeDirectoryStatus(ActiveDirectoryStatus activeDirectoryStatus) {
            this.activeDirectoryStatus(activeDirectoryStatus == null ? null : activeDirectoryStatus.toString());
            return this;
        }

        @Override
        public JoinDomainResponse build() {
            return new JoinDomainResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
