/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.storagegateway.model.HostEnvironment;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GatewayInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GatewayInfo> {
    private static final SdkField<String> GATEWAY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GatewayId").getter(GatewayInfo.getter(GatewayInfo::gatewayId)).setter(GatewayInfo.setter(Builder::gatewayId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayId").build()}).build();
    private static final SdkField<String> GATEWAY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GatewayARN").getter(GatewayInfo.getter(GatewayInfo::gatewayARN)).setter(GatewayInfo.setter(Builder::gatewayARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayARN").build()}).build();
    private static final SdkField<String> GATEWAY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GatewayType").getter(GatewayInfo.getter(GatewayInfo::gatewayType)).setter(GatewayInfo.setter(Builder::gatewayType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayType").build()}).build();
    private static final SdkField<String> GATEWAY_OPERATIONAL_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GatewayOperationalState").getter(GatewayInfo.getter(GatewayInfo::gatewayOperationalState)).setter(GatewayInfo.setter(Builder::gatewayOperationalState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayOperationalState").build()}).build();
    private static final SdkField<String> GATEWAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GatewayName").getter(GatewayInfo.getter(GatewayInfo::gatewayName)).setter(GatewayInfo.setter(Builder::gatewayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayName").build()}).build();
    private static final SdkField<String> EC2_INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Ec2InstanceId").getter(GatewayInfo.getter(GatewayInfo::ec2InstanceId)).setter(GatewayInfo.setter(Builder::ec2InstanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ec2InstanceId").build()}).build();
    private static final SdkField<String> EC2_INSTANCE_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Ec2InstanceRegion").getter(GatewayInfo.getter(GatewayInfo::ec2InstanceRegion)).setter(GatewayInfo.setter(Builder::ec2InstanceRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ec2InstanceRegion").build()}).build();
    private static final SdkField<String> HOST_ENVIRONMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HostEnvironment").getter(GatewayInfo.getter(GatewayInfo::hostEnvironmentAsString)).setter(GatewayInfo.setter(Builder::hostEnvironment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostEnvironment").build()}).build();
    private static final SdkField<String> HOST_ENVIRONMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HostEnvironmentId").getter(GatewayInfo.getter(GatewayInfo::hostEnvironmentId)).setter(GatewayInfo.setter(Builder::hostEnvironmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostEnvironmentId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_ID_FIELD, GATEWAY_ARN_FIELD, GATEWAY_TYPE_FIELD, GATEWAY_OPERATIONAL_STATE_FIELD, GATEWAY_NAME_FIELD, EC2_INSTANCE_ID_FIELD, EC2_INSTANCE_REGION_FIELD, HOST_ENVIRONMENT_FIELD, HOST_ENVIRONMENT_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String gatewayId;
    private final String gatewayARN;
    private final String gatewayType;
    private final String gatewayOperationalState;
    private final String gatewayName;
    private final String ec2InstanceId;
    private final String ec2InstanceRegion;
    private final String hostEnvironment;
    private final String hostEnvironmentId;

    private GatewayInfo(BuilderImpl builder) {
        this.gatewayId = builder.gatewayId;
        this.gatewayARN = builder.gatewayARN;
        this.gatewayType = builder.gatewayType;
        this.gatewayOperationalState = builder.gatewayOperationalState;
        this.gatewayName = builder.gatewayName;
        this.ec2InstanceId = builder.ec2InstanceId;
        this.ec2InstanceRegion = builder.ec2InstanceRegion;
        this.hostEnvironment = builder.hostEnvironment;
        this.hostEnvironmentId = builder.hostEnvironmentId;
    }

    public final String gatewayId() {
        return this.gatewayId;
    }

    public final String gatewayARN() {
        return this.gatewayARN;
    }

    public final String gatewayType() {
        return this.gatewayType;
    }

    public final String gatewayOperationalState() {
        return this.gatewayOperationalState;
    }

    public final String gatewayName() {
        return this.gatewayName;
    }

    public final String ec2InstanceId() {
        return this.ec2InstanceId;
    }

    public final String ec2InstanceRegion() {
        return this.ec2InstanceRegion;
    }

    public final HostEnvironment hostEnvironment() {
        return HostEnvironment.fromValue(this.hostEnvironment);
    }

    public final String hostEnvironmentAsString() {
        return this.hostEnvironment;
    }

    public final String hostEnvironmentId() {
        return this.hostEnvironmentId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayType());
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayOperationalState());
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.ec2InstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ec2InstanceRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostEnvironmentAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostEnvironmentId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GatewayInfo)) {
            return false;
        }
        GatewayInfo other = (GatewayInfo)obj;
        return Objects.equals(this.gatewayId(), other.gatewayId()) && Objects.equals(this.gatewayARN(), other.gatewayARN()) && Objects.equals(this.gatewayType(), other.gatewayType()) && Objects.equals(this.gatewayOperationalState(), other.gatewayOperationalState()) && Objects.equals(this.gatewayName(), other.gatewayName()) && Objects.equals(this.ec2InstanceId(), other.ec2InstanceId()) && Objects.equals(this.ec2InstanceRegion(), other.ec2InstanceRegion()) && Objects.equals(this.hostEnvironmentAsString(), other.hostEnvironmentAsString()) && Objects.equals(this.hostEnvironmentId(), other.hostEnvironmentId());
    }

    public final String toString() {
        return ToString.builder((String)"GatewayInfo").add("GatewayId", (Object)this.gatewayId()).add("GatewayARN", (Object)this.gatewayARN()).add("GatewayType", (Object)this.gatewayType()).add("GatewayOperationalState", (Object)this.gatewayOperationalState()).add("GatewayName", (Object)this.gatewayName()).add("Ec2InstanceId", (Object)this.ec2InstanceId()).add("Ec2InstanceRegion", (Object)this.ec2InstanceRegion()).add("HostEnvironment", (Object)this.hostEnvironmentAsString()).add("HostEnvironmentId", (Object)this.hostEnvironmentId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GatewayId": {
                return Optional.ofNullable(clazz.cast(this.gatewayId()));
            }
            case "GatewayARN": {
                return Optional.ofNullable(clazz.cast(this.gatewayARN()));
            }
            case "GatewayType": {
                return Optional.ofNullable(clazz.cast(this.gatewayType()));
            }
            case "GatewayOperationalState": {
                return Optional.ofNullable(clazz.cast(this.gatewayOperationalState()));
            }
            case "GatewayName": {
                return Optional.ofNullable(clazz.cast(this.gatewayName()));
            }
            case "Ec2InstanceId": {
                return Optional.ofNullable(clazz.cast(this.ec2InstanceId()));
            }
            case "Ec2InstanceRegion": {
                return Optional.ofNullable(clazz.cast(this.ec2InstanceRegion()));
            }
            case "HostEnvironment": {
                return Optional.ofNullable(clazz.cast(this.hostEnvironmentAsString()));
            }
            case "HostEnvironmentId": {
                return Optional.ofNullable(clazz.cast(this.hostEnvironmentId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GatewayInfo, T> g) {
        return obj -> g.apply((GatewayInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String gatewayId;
        private String gatewayARN;
        private String gatewayType;
        private String gatewayOperationalState;
        private String gatewayName;
        private String ec2InstanceId;
        private String ec2InstanceRegion;
        private String hostEnvironment;
        private String hostEnvironmentId;

        private BuilderImpl() {
        }

        private BuilderImpl(GatewayInfo model) {
            this.gatewayId(model.gatewayId);
            this.gatewayARN(model.gatewayARN);
            this.gatewayType(model.gatewayType);
            this.gatewayOperationalState(model.gatewayOperationalState);
            this.gatewayName(model.gatewayName);
            this.ec2InstanceId(model.ec2InstanceId);
            this.ec2InstanceRegion(model.ec2InstanceRegion);
            this.hostEnvironment(model.hostEnvironment);
            this.hostEnvironmentId(model.hostEnvironmentId);
        }

        public final String getGatewayId() {
            return this.gatewayId;
        }

        public final void setGatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
        }

        @Override
        @Transient
        public final Builder gatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
            return this;
        }

        public final String getGatewayARN() {
            return this.gatewayARN;
        }

        public final void setGatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
        }

        @Override
        @Transient
        public final Builder gatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
            return this;
        }

        public final String getGatewayType() {
            return this.gatewayType;
        }

        public final void setGatewayType(String gatewayType) {
            this.gatewayType = gatewayType;
        }

        @Override
        @Transient
        public final Builder gatewayType(String gatewayType) {
            this.gatewayType = gatewayType;
            return this;
        }

        public final String getGatewayOperationalState() {
            return this.gatewayOperationalState;
        }

        public final void setGatewayOperationalState(String gatewayOperationalState) {
            this.gatewayOperationalState = gatewayOperationalState;
        }

        @Override
        @Transient
        public final Builder gatewayOperationalState(String gatewayOperationalState) {
            this.gatewayOperationalState = gatewayOperationalState;
            return this;
        }

        public final String getGatewayName() {
            return this.gatewayName;
        }

        public final void setGatewayName(String gatewayName) {
            this.gatewayName = gatewayName;
        }

        @Override
        @Transient
        public final Builder gatewayName(String gatewayName) {
            this.gatewayName = gatewayName;
            return this;
        }

        public final String getEc2InstanceId() {
            return this.ec2InstanceId;
        }

        public final void setEc2InstanceId(String ec2InstanceId) {
            this.ec2InstanceId = ec2InstanceId;
        }

        @Override
        @Transient
        public final Builder ec2InstanceId(String ec2InstanceId) {
            this.ec2InstanceId = ec2InstanceId;
            return this;
        }

        public final String getEc2InstanceRegion() {
            return this.ec2InstanceRegion;
        }

        public final void setEc2InstanceRegion(String ec2InstanceRegion) {
            this.ec2InstanceRegion = ec2InstanceRegion;
        }

        @Override
        @Transient
        public final Builder ec2InstanceRegion(String ec2InstanceRegion) {
            this.ec2InstanceRegion = ec2InstanceRegion;
            return this;
        }

        public final String getHostEnvironment() {
            return this.hostEnvironment;
        }

        public final void setHostEnvironment(String hostEnvironment) {
            this.hostEnvironment = hostEnvironment;
        }

        @Override
        @Transient
        public final Builder hostEnvironment(String hostEnvironment) {
            this.hostEnvironment = hostEnvironment;
            return this;
        }

        @Override
        @Transient
        public final Builder hostEnvironment(HostEnvironment hostEnvironment) {
            this.hostEnvironment(hostEnvironment == null ? null : hostEnvironment.toString());
            return this;
        }

        public final String getHostEnvironmentId() {
            return this.hostEnvironmentId;
        }

        public final void setHostEnvironmentId(String hostEnvironmentId) {
            this.hostEnvironmentId = hostEnvironmentId;
        }

        @Override
        @Transient
        public final Builder hostEnvironmentId(String hostEnvironmentId) {
            this.hostEnvironmentId = hostEnvironmentId;
            return this;
        }

        public GatewayInfo build() {
            return new GatewayInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GatewayInfo> {
        public Builder gatewayId(String var1);

        public Builder gatewayARN(String var1);

        public Builder gatewayType(String var1);

        public Builder gatewayOperationalState(String var1);

        public Builder gatewayName(String var1);

        public Builder ec2InstanceId(String var1);

        public Builder ec2InstanceRegion(String var1);

        public Builder hostEnvironment(String var1);

        public Builder hostEnvironment(HostEnvironment var1);

        public Builder hostEnvironmentId(String var1);
    }
}

