/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.storagegateway.model.ActivateGatewayRequest;
import software.amazon.awssdk.services.storagegateway.model.ActivateGatewayResponse;
import software.amazon.awssdk.services.storagegateway.model.AddCacheRequest;
import software.amazon.awssdk.services.storagegateway.model.AddCacheResponse;
import software.amazon.awssdk.services.storagegateway.model.AddTagsToResourceRequest;
import software.amazon.awssdk.services.storagegateway.model.AddTagsToResourceResponse;
import software.amazon.awssdk.services.storagegateway.model.AddUploadBufferRequest;
import software.amazon.awssdk.services.storagegateway.model.AddUploadBufferResponse;
import software.amazon.awssdk.services.storagegateway.model.AddWorkingStorageRequest;
import software.amazon.awssdk.services.storagegateway.model.AddWorkingStorageResponse;
import software.amazon.awssdk.services.storagegateway.model.AssignTapePoolRequest;
import software.amazon.awssdk.services.storagegateway.model.AssignTapePoolResponse;
import software.amazon.awssdk.services.storagegateway.model.AssociateFileSystemRequest;
import software.amazon.awssdk.services.storagegateway.model.AssociateFileSystemResponse;
import software.amazon.awssdk.services.storagegateway.model.AttachVolumeRequest;
import software.amazon.awssdk.services.storagegateway.model.AttachVolumeResponse;
import software.amazon.awssdk.services.storagegateway.model.CancelArchivalRequest;
import software.amazon.awssdk.services.storagegateway.model.CancelArchivalResponse;
import software.amazon.awssdk.services.storagegateway.model.CancelRetrievalRequest;
import software.amazon.awssdk.services.storagegateway.model.CancelRetrievalResponse;
import software.amazon.awssdk.services.storagegateway.model.CreateCachediScsiVolumeRequest;
import software.amazon.awssdk.services.storagegateway.model.CreateCachediScsiVolumeResponse;
import software.amazon.awssdk.services.storagegateway.model.CreateNfsFileShareRequest;
import software.amazon.awssdk.services.storagegateway.model.CreateNfsFileShareResponse;
import software.amazon.awssdk.services.storagegateway.model.CreateSmbFileShareRequest;
import software.amazon.awssdk.services.storagegateway.model.CreateSmbFileShareResponse;
import software.amazon.awssdk.services.storagegateway.model.CreateSnapshotFromVolumeRecoveryPointRequest;
import software.amazon.awssdk.services.storagegateway.model.CreateSnapshotFromVolumeRecoveryPointResponse;
import software.amazon.awssdk.services.storagegateway.model.CreateSnapshotRequest;
import software.amazon.awssdk.services.storagegateway.model.CreateSnapshotResponse;
import software.amazon.awssdk.services.storagegateway.model.CreateStorediScsiVolumeRequest;
import software.amazon.awssdk.services.storagegateway.model.CreateStorediScsiVolumeResponse;
import software.amazon.awssdk.services.storagegateway.model.CreateTapePoolRequest;
import software.amazon.awssdk.services.storagegateway.model.CreateTapePoolResponse;
import software.amazon.awssdk.services.storagegateway.model.CreateTapeWithBarcodeRequest;
import software.amazon.awssdk.services.storagegateway.model.CreateTapeWithBarcodeResponse;
import software.amazon.awssdk.services.storagegateway.model.CreateTapesRequest;
import software.amazon.awssdk.services.storagegateway.model.CreateTapesResponse;
import software.amazon.awssdk.services.storagegateway.model.DeleteAutomaticTapeCreationPolicyRequest;
import software.amazon.awssdk.services.storagegateway.model.DeleteAutomaticTapeCreationPolicyResponse;
import software.amazon.awssdk.services.storagegateway.model.DeleteBandwidthRateLimitRequest;
import software.amazon.awssdk.services.storagegateway.model.DeleteBandwidthRateLimitResponse;
import software.amazon.awssdk.services.storagegateway.model.DeleteChapCredentialsRequest;
import software.amazon.awssdk.services.storagegateway.model.DeleteChapCredentialsResponse;
import software.amazon.awssdk.services.storagegateway.model.DeleteFileShareRequest;
import software.amazon.awssdk.services.storagegateway.model.DeleteFileShareResponse;
import software.amazon.awssdk.services.storagegateway.model.DeleteGatewayRequest;
import software.amazon.awssdk.services.storagegateway.model.DeleteGatewayResponse;
import software.amazon.awssdk.services.storagegateway.model.DeleteSnapshotScheduleRequest;
import software.amazon.awssdk.services.storagegateway.model.DeleteSnapshotScheduleResponse;
import software.amazon.awssdk.services.storagegateway.model.DeleteTapeArchiveRequest;
import software.amazon.awssdk.services.storagegateway.model.DeleteTapeArchiveResponse;
import software.amazon.awssdk.services.storagegateway.model.DeleteTapePoolRequest;
import software.amazon.awssdk.services.storagegateway.model.DeleteTapePoolResponse;
import software.amazon.awssdk.services.storagegateway.model.DeleteTapeRequest;
import software.amazon.awssdk.services.storagegateway.model.DeleteTapeResponse;
import software.amazon.awssdk.services.storagegateway.model.DeleteVolumeRequest;
import software.amazon.awssdk.services.storagegateway.model.DeleteVolumeResponse;
import software.amazon.awssdk.services.storagegateway.model.DescribeAvailabilityMonitorTestRequest;
import software.amazon.awssdk.services.storagegateway.model.DescribeAvailabilityMonitorTestResponse;
import software.amazon.awssdk.services.storagegateway.model.DescribeBandwidthRateLimitRequest;
import software.amazon.awssdk.services.storagegateway.model.DescribeBandwidthRateLimitResponse;
import software.amazon.awssdk.services.storagegateway.model.DescribeBandwidthRateLimitScheduleRequest;
import software.amazon.awssdk.services.storagegateway.model.DescribeBandwidthRateLimitScheduleResponse;
import software.amazon.awssdk.services.storagegateway.model.DescribeCacheRequest;
import software.amazon.awssdk.services.storagegateway.model.DescribeCacheResponse;
import software.amazon.awssdk.services.storagegateway.model.DescribeCachediScsiVolumesRequest;
import software.amazon.awssdk.services.storagegateway.model.DescribeCachediScsiVolumesResponse;
import software.amazon.awssdk.services.storagegateway.model.DescribeChapCredentialsRequest;
import software.amazon.awssdk.services.storagegateway.model.DescribeChapCredentialsResponse;
import software.amazon.awssdk.services.storagegateway.model.DescribeFileSystemAssociationsRequest;
import software.amazon.awssdk.services.storagegateway.model.DescribeFileSystemAssociationsResponse;
import software.amazon.awssdk.services.storagegateway.model.DescribeGatewayInformationRequest;
import software.amazon.awssdk.services.storagegateway.model.DescribeGatewayInformationResponse;
import software.amazon.awssdk.services.storagegateway.model.DescribeMaintenanceStartTimeRequest;
import software.amazon.awssdk.services.storagegateway.model.DescribeMaintenanceStartTimeResponse;
import software.amazon.awssdk.services.storagegateway.model.DescribeNfsFileSharesRequest;
import software.amazon.awssdk.services.storagegateway.model.DescribeNfsFileSharesResponse;
import software.amazon.awssdk.services.storagegateway.model.DescribeSmbFileSharesRequest;
import software.amazon.awssdk.services.storagegateway.model.DescribeSmbFileSharesResponse;
import software.amazon.awssdk.services.storagegateway.model.DescribeSmbSettingsRequest;
import software.amazon.awssdk.services.storagegateway.model.DescribeSmbSettingsResponse;
import software.amazon.awssdk.services.storagegateway.model.DescribeSnapshotScheduleRequest;
import software.amazon.awssdk.services.storagegateway.model.DescribeSnapshotScheduleResponse;
import software.amazon.awssdk.services.storagegateway.model.DescribeStorediScsiVolumesRequest;
import software.amazon.awssdk.services.storagegateway.model.DescribeStorediScsiVolumesResponse;
import software.amazon.awssdk.services.storagegateway.model.DescribeTapeArchivesRequest;
import software.amazon.awssdk.services.storagegateway.model.DescribeTapeArchivesResponse;
import software.amazon.awssdk.services.storagegateway.model.DescribeTapeRecoveryPointsRequest;
import software.amazon.awssdk.services.storagegateway.model.DescribeTapeRecoveryPointsResponse;
import software.amazon.awssdk.services.storagegateway.model.DescribeTapesRequest;
import software.amazon.awssdk.services.storagegateway.model.DescribeTapesResponse;
import software.amazon.awssdk.services.storagegateway.model.DescribeUploadBufferRequest;
import software.amazon.awssdk.services.storagegateway.model.DescribeUploadBufferResponse;
import software.amazon.awssdk.services.storagegateway.model.DescribeVtlDevicesRequest;
import software.amazon.awssdk.services.storagegateway.model.DescribeVtlDevicesResponse;
import software.amazon.awssdk.services.storagegateway.model.DescribeWorkingStorageRequest;
import software.amazon.awssdk.services.storagegateway.model.DescribeWorkingStorageResponse;
import software.amazon.awssdk.services.storagegateway.model.DetachVolumeRequest;
import software.amazon.awssdk.services.storagegateway.model.DetachVolumeResponse;
import software.amazon.awssdk.services.storagegateway.model.DisableGatewayRequest;
import software.amazon.awssdk.services.storagegateway.model.DisableGatewayResponse;
import software.amazon.awssdk.services.storagegateway.model.DisassociateFileSystemRequest;
import software.amazon.awssdk.services.storagegateway.model.DisassociateFileSystemResponse;
import software.amazon.awssdk.services.storagegateway.model.InternalServerErrorException;
import software.amazon.awssdk.services.storagegateway.model.InvalidGatewayRequestException;
import software.amazon.awssdk.services.storagegateway.model.JoinDomainRequest;
import software.amazon.awssdk.services.storagegateway.model.JoinDomainResponse;
import software.amazon.awssdk.services.storagegateway.model.ListAutomaticTapeCreationPoliciesRequest;
import software.amazon.awssdk.services.storagegateway.model.ListAutomaticTapeCreationPoliciesResponse;
import software.amazon.awssdk.services.storagegateway.model.ListFileSharesRequest;
import software.amazon.awssdk.services.storagegateway.model.ListFileSharesResponse;
import software.amazon.awssdk.services.storagegateway.model.ListFileSystemAssociationsRequest;
import software.amazon.awssdk.services.storagegateway.model.ListFileSystemAssociationsResponse;
import software.amazon.awssdk.services.storagegateway.model.ListGatewaysRequest;
import software.amazon.awssdk.services.storagegateway.model.ListGatewaysResponse;
import software.amazon.awssdk.services.storagegateway.model.ListLocalDisksRequest;
import software.amazon.awssdk.services.storagegateway.model.ListLocalDisksResponse;
import software.amazon.awssdk.services.storagegateway.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.storagegateway.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.storagegateway.model.ListTapePoolsRequest;
import software.amazon.awssdk.services.storagegateway.model.ListTapePoolsResponse;
import software.amazon.awssdk.services.storagegateway.model.ListTapesRequest;
import software.amazon.awssdk.services.storagegateway.model.ListTapesResponse;
import software.amazon.awssdk.services.storagegateway.model.ListVolumeInitiatorsRequest;
import software.amazon.awssdk.services.storagegateway.model.ListVolumeInitiatorsResponse;
import software.amazon.awssdk.services.storagegateway.model.ListVolumeRecoveryPointsRequest;
import software.amazon.awssdk.services.storagegateway.model.ListVolumeRecoveryPointsResponse;
import software.amazon.awssdk.services.storagegateway.model.ListVolumesRequest;
import software.amazon.awssdk.services.storagegateway.model.ListVolumesResponse;
import software.amazon.awssdk.services.storagegateway.model.NotifyWhenUploadedRequest;
import software.amazon.awssdk.services.storagegateway.model.NotifyWhenUploadedResponse;
import software.amazon.awssdk.services.storagegateway.model.RefreshCacheRequest;
import software.amazon.awssdk.services.storagegateway.model.RefreshCacheResponse;
import software.amazon.awssdk.services.storagegateway.model.RemoveTagsFromResourceRequest;
import software.amazon.awssdk.services.storagegateway.model.RemoveTagsFromResourceResponse;
import software.amazon.awssdk.services.storagegateway.model.ResetCacheRequest;
import software.amazon.awssdk.services.storagegateway.model.ResetCacheResponse;
import software.amazon.awssdk.services.storagegateway.model.RetrieveTapeArchiveRequest;
import software.amazon.awssdk.services.storagegateway.model.RetrieveTapeArchiveResponse;
import software.amazon.awssdk.services.storagegateway.model.RetrieveTapeRecoveryPointRequest;
import software.amazon.awssdk.services.storagegateway.model.RetrieveTapeRecoveryPointResponse;
import software.amazon.awssdk.services.storagegateway.model.ServiceUnavailableErrorException;
import software.amazon.awssdk.services.storagegateway.model.SetLocalConsolePasswordRequest;
import software.amazon.awssdk.services.storagegateway.model.SetLocalConsolePasswordResponse;
import software.amazon.awssdk.services.storagegateway.model.SetSmbGuestPasswordRequest;
import software.amazon.awssdk.services.storagegateway.model.SetSmbGuestPasswordResponse;
import software.amazon.awssdk.services.storagegateway.model.ShutdownGatewayRequest;
import software.amazon.awssdk.services.storagegateway.model.ShutdownGatewayResponse;
import software.amazon.awssdk.services.storagegateway.model.StartAvailabilityMonitorTestRequest;
import software.amazon.awssdk.services.storagegateway.model.StartAvailabilityMonitorTestResponse;
import software.amazon.awssdk.services.storagegateway.model.StartGatewayRequest;
import software.amazon.awssdk.services.storagegateway.model.StartGatewayResponse;
import software.amazon.awssdk.services.storagegateway.model.StorageGatewayException;
import software.amazon.awssdk.services.storagegateway.model.UpdateAutomaticTapeCreationPolicyRequest;
import software.amazon.awssdk.services.storagegateway.model.UpdateAutomaticTapeCreationPolicyResponse;
import software.amazon.awssdk.services.storagegateway.model.UpdateBandwidthRateLimitRequest;
import software.amazon.awssdk.services.storagegateway.model.UpdateBandwidthRateLimitResponse;
import software.amazon.awssdk.services.storagegateway.model.UpdateBandwidthRateLimitScheduleRequest;
import software.amazon.awssdk.services.storagegateway.model.UpdateBandwidthRateLimitScheduleResponse;
import software.amazon.awssdk.services.storagegateway.model.UpdateChapCredentialsRequest;
import software.amazon.awssdk.services.storagegateway.model.UpdateChapCredentialsResponse;
import software.amazon.awssdk.services.storagegateway.model.UpdateFileSystemAssociationRequest;
import software.amazon.awssdk.services.storagegateway.model.UpdateFileSystemAssociationResponse;
import software.amazon.awssdk.services.storagegateway.model.UpdateGatewayInformationRequest;
import software.amazon.awssdk.services.storagegateway.model.UpdateGatewayInformationResponse;
import software.amazon.awssdk.services.storagegateway.model.UpdateGatewaySoftwareNowRequest;
import software.amazon.awssdk.services.storagegateway.model.UpdateGatewaySoftwareNowResponse;
import software.amazon.awssdk.services.storagegateway.model.UpdateMaintenanceStartTimeRequest;
import software.amazon.awssdk.services.storagegateway.model.UpdateMaintenanceStartTimeResponse;
import software.amazon.awssdk.services.storagegateway.model.UpdateNfsFileShareRequest;
import software.amazon.awssdk.services.storagegateway.model.UpdateNfsFileShareResponse;
import software.amazon.awssdk.services.storagegateway.model.UpdateSmbFileShareRequest;
import software.amazon.awssdk.services.storagegateway.model.UpdateSmbFileShareResponse;
import software.amazon.awssdk.services.storagegateway.model.UpdateSmbFileShareVisibilityRequest;
import software.amazon.awssdk.services.storagegateway.model.UpdateSmbFileShareVisibilityResponse;
import software.amazon.awssdk.services.storagegateway.model.UpdateSmbLocalGroupsRequest;
import software.amazon.awssdk.services.storagegateway.model.UpdateSmbLocalGroupsResponse;
import software.amazon.awssdk.services.storagegateway.model.UpdateSmbSecurityStrategyRequest;
import software.amazon.awssdk.services.storagegateway.model.UpdateSmbSecurityStrategyResponse;
import software.amazon.awssdk.services.storagegateway.model.UpdateSnapshotScheduleRequest;
import software.amazon.awssdk.services.storagegateway.model.UpdateSnapshotScheduleResponse;
import software.amazon.awssdk.services.storagegateway.model.UpdateVtlDeviceTypeRequest;
import software.amazon.awssdk.services.storagegateway.model.UpdateVtlDeviceTypeResponse;
import software.amazon.awssdk.services.storagegateway.paginators.DescribeTapeArchivesIterable;
import software.amazon.awssdk.services.storagegateway.paginators.DescribeTapeRecoveryPointsIterable;
import software.amazon.awssdk.services.storagegateway.paginators.DescribeTapesIterable;
import software.amazon.awssdk.services.storagegateway.paginators.DescribeVTLDevicesIterable;
import software.amazon.awssdk.services.storagegateway.paginators.ListFileSharesIterable;
import software.amazon.awssdk.services.storagegateway.paginators.ListFileSystemAssociationsIterable;
import software.amazon.awssdk.services.storagegateway.paginators.ListGatewaysIterable;
import software.amazon.awssdk.services.storagegateway.paginators.ListTagsForResourceIterable;
import software.amazon.awssdk.services.storagegateway.paginators.ListTapePoolsIterable;
import software.amazon.awssdk.services.storagegateway.paginators.ListTapesIterable;
import software.amazon.awssdk.services.storagegateway.paginators.ListVolumesIterable;

/**
 * Service client for accessing AWS Storage Gateway. This can be created using the static {@link #builder()} method.
 *
 * <fullname>Storage Gateway Service</fullname>
 * <p>
 * Storage Gateway is the service that connects an on-premises software appliance with cloud-based storage to provide
 * seamless and secure integration between an organization's on-premises IT environment and the Amazon Web Services
 * storage infrastructure. The service enables you to securely upload data to the Amazon Web Services Cloud for cost
 * effective backup and rapid disaster recovery.
 * </p>
 * <p>
 * Use the following links to get started using the <i>Storage Gateway Service API Reference</i>:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a href=
 * "https://docs.aws.amazon.com/storagegateway/latest/userguide/AWSStorageGatewayAPI.html#AWSStorageGatewayHTTPRequestsHeaders"
 * >Storage Gateway required request headers</a>: Describes the required headers that you must send with every POST
 * request to Storage Gateway.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href=
 * "https://docs.aws.amazon.com/storagegateway/latest/userguide/AWSStorageGatewayAPI.html#AWSStorageGatewaySigningRequests"
 * >Signing requests</a>: Storage Gateway requires that you authenticate every request you send; this topic describes
 * how sign such a request.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/storagegateway/latest/userguide/AWSStorageGatewayAPI.html#APIErrorResponses">
 * Error responses</a>: Provides reference information about Storage Gateway errors.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_Operations.html">Operations in Storage
 * Gateway</a>: Contains detailed descriptions of all Storage Gateway operations, their request parameters, response
 * elements, possible errors, and examples of requests and responses.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/general/latest/gr/sg.html">Storage Gateway endpoints and quotas</a>: Provides a
 * list of each Amazon Web Services Region and the endpoints available for use with Storage Gateway.
 * </p>
 * </li>
 * </ul>
 * <note>
 * <p>
 * Storage Gateway resource IDs are in uppercase. When you use these resource IDs with the Amazon EC2 API, EC2 expects
 * resource IDs in lowercase. You must change your resource ID to lowercase to use it with the EC2 API. For example, in
 * Storage Gateway the ID for a volume might be <code>vol-AA22BB012345DAF670</code>. When you use this ID with the EC2
 * API, you must change it to <code>vol-aa22bb012345daf670</code>. Otherwise, the EC2 API might not behave as expected.
 * </p>
 * </note> <important>
 * <p>
 * IDs for Storage Gateway volumes and Amazon EBS snapshots created from gateway volumes are changing to a longer
 * format. Starting in December 2016, all new volumes and snapshots will be created with a 17-character string. Starting
 * in April 2016, you will be able to use these longer IDs so you can test your systems with the new format. For more
 * information, see <a href="http://aws.amazon.com/ec2/faqs/#longer-ids">Longer EC2 and EBS resource IDs</a>.
 * </p>
 * <p>
 * For example, a volume Amazon Resource Name (ARN) with the longer volume ID format looks like the following:
 * </p>
 * <p>
 * <code>arn:aws:storagegateway:us-west-2:111122223333:gateway/sgw-12A3456B/volume/vol-1122AABBCCDDEEFFG</code>.
 * </p>
 * <p>
 * A snapshot ID with the longer ID format looks like the following: <code>snap-78e226633445566ee</code>.
 * </p>
 * <p>
 * For more information, see <a href="http://forums.aws.amazon.com/ann.jspa?annID=3557">Announcement: Heads-up – Longer
 * Storage Gateway volume and snapshot IDs coming in 2016</a>.
 * </p>
 * </important>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface StorageGatewayClient extends SdkClient {
    String SERVICE_NAME = "storagegateway";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "storagegateway";

    /**
     * Create a {@link StorageGatewayClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static StorageGatewayClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link StorageGatewayClient}.
     */
    static StorageGatewayClientBuilder builder() {
        return new DefaultStorageGatewayClientBuilder();
    }

    /**
     * <p>
     * Activates the gateway you previously deployed on your host. In the activation process, you specify information
     * such as the Amazon Web Services Region that you want to use for storing snapshots or tapes, the time zone for
     * scheduled snapshots the gateway snapshot schedule window, an activation key, and a name for your gateway. The
     * activation process also associates your gateway with your account. For more information, see
     * <a>UpdateGatewayInformation</a>.
     * </p>
     * <note>
     * <p>
     * You must turn on the gateway VM before you can activate your gateway.
     * </p>
     * </note>
     *
     * @param activateGatewayRequest
     *        A JSON object containing one or more of the following fields:</p>
     *        <ul>
     *        <li>
     *        <p>
     *        <a>ActivateGatewayInput&#36ActivationKey</a>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <a>ActivateGatewayInput&#36GatewayName</a>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <a>ActivateGatewayInput&#36GatewayRegion</a>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <a>ActivateGatewayInput&#36GatewayTimezone</a>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <a>ActivateGatewayInput&#36GatewayType</a>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <a>ActivateGatewayInput&#36MediumChangerType</a>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <a>ActivateGatewayInput&#36TapeDriveType</a>
     *        </p>
     *        </li>
     * @return Result of the ActivateGateway operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.ActivateGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ActivateGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default ActivateGatewayResponse activateGateway(ActivateGatewayRequest activateGatewayRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Activates the gateway you previously deployed on your host. In the activation process, you specify information
     * such as the Amazon Web Services Region that you want to use for storing snapshots or tapes, the time zone for
     * scheduled snapshots the gateway snapshot schedule window, an activation key, and a name for your gateway. The
     * activation process also associates your gateway with your account. For more information, see
     * <a>UpdateGatewayInformation</a>.
     * </p>
     * <note>
     * <p>
     * You must turn on the gateway VM before you can activate your gateway.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ActivateGatewayRequest.Builder} avoiding the need
     * to create one manually via {@link ActivateGatewayRequest#builder()}
     * </p>
     *
     * @param activateGatewayRequest
     *        A {@link Consumer} that will call methods on {@link ActivateGatewayInput.Builder} to create a request. A
     *        JSON object containing one or more of the following fields:</p>
     *        <ul>
     *        <li>
     *        <p>
     *        <a>ActivateGatewayInput&#36ActivationKey</a>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <a>ActivateGatewayInput&#36GatewayName</a>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <a>ActivateGatewayInput&#36GatewayRegion</a>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <a>ActivateGatewayInput&#36GatewayTimezone</a>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <a>ActivateGatewayInput&#36GatewayType</a>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <a>ActivateGatewayInput&#36MediumChangerType</a>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <a>ActivateGatewayInput&#36TapeDriveType</a>
     *        </p>
     *        </li>
     * @return Result of the ActivateGateway operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.ActivateGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ActivateGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default ActivateGatewayResponse activateGateway(Consumer<ActivateGatewayRequest.Builder> activateGatewayRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        return activateGateway(ActivateGatewayRequest.builder().applyMutation(activateGatewayRequest).build());
    }

    /**
     * <p>
     * Configures one or more gateway local disks as cache for a gateway. This operation is only supported in the cached
     * volume, tape, and file gateway type (see <a
     * href="https://docs.aws.amazon.com/storagegateway/latest/userguide/StorageGatewayConcepts.html">How Storage
     * Gateway works (architecture)</a>.
     * </p>
     * <p>
     * In the request, you specify the gateway Amazon Resource Name (ARN) to which you want to add cache, and one or
     * more disk IDs that you want to configure as cache.
     * </p>
     *
     * @param addCacheRequest
     * @return Result of the AddCache operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.AddCache
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/AddCache" target="_top">AWS API
     *      Documentation</a>
     */
    default AddCacheResponse addCache(AddCacheRequest addCacheRequest) throws InvalidGatewayRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, StorageGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Configures one or more gateway local disks as cache for a gateway. This operation is only supported in the cached
     * volume, tape, and file gateway type (see <a
     * href="https://docs.aws.amazon.com/storagegateway/latest/userguide/StorageGatewayConcepts.html">How Storage
     * Gateway works (architecture)</a>.
     * </p>
     * <p>
     * In the request, you specify the gateway Amazon Resource Name (ARN) to which you want to add cache, and one or
     * more disk IDs that you want to configure as cache.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddCacheRequest.Builder} avoiding the need to
     * create one manually via {@link AddCacheRequest#builder()}
     * </p>
     *
     * @param addCacheRequest
     *        A {@link Consumer} that will call methods on {@link AddCacheInput.Builder} to create a request.
     * @return Result of the AddCache operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.AddCache
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/AddCache" target="_top">AWS API
     *      Documentation</a>
     */
    default AddCacheResponse addCache(Consumer<AddCacheRequest.Builder> addCacheRequest) throws InvalidGatewayRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, StorageGatewayException {
        return addCache(AddCacheRequest.builder().applyMutation(addCacheRequest).build());
    }

    /**
     * <p>
     * Adds one or more tags to the specified resource. You use tags to add metadata to resources, which you can use to
     * categorize these resources. For example, you can categorize resources by purpose, owner, environment, or team.
     * Each tag consists of a key and a value, which you define. You can add tags to the following Storage Gateway
     * resources:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Storage gateways of all types
     * </p>
     * </li>
     * <li>
     * <p>
     * Storage volumes
     * </p>
     * </li>
     * <li>
     * <p>
     * Virtual tapes
     * </p>
     * </li>
     * <li>
     * <p>
     * NFS and SMB file shares
     * </p>
     * </li>
     * <li>
     * <p>
     * File System associations
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can create a maximum of 50 tags for each resource. Virtual tapes and storage volumes that are recovered to a
     * new gateway maintain their tags.
     * </p>
     *
     * @param addTagsToResourceRequest
     *        AddTagsToResourceInput
     * @return Result of the AddTagsToResource operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.AddTagsToResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/AddTagsToResource"
     *      target="_top">AWS API Documentation</a>
     */
    default AddTagsToResourceResponse addTagsToResource(AddTagsToResourceRequest addTagsToResourceRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds one or more tags to the specified resource. You use tags to add metadata to resources, which you can use to
     * categorize these resources. For example, you can categorize resources by purpose, owner, environment, or team.
     * Each tag consists of a key and a value, which you define. You can add tags to the following Storage Gateway
     * resources:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Storage gateways of all types
     * </p>
     * </li>
     * <li>
     * <p>
     * Storage volumes
     * </p>
     * </li>
     * <li>
     * <p>
     * Virtual tapes
     * </p>
     * </li>
     * <li>
     * <p>
     * NFS and SMB file shares
     * </p>
     * </li>
     * <li>
     * <p>
     * File System associations
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can create a maximum of 50 tags for each resource. Virtual tapes and storage volumes that are recovered to a
     * new gateway maintain their tags.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddTagsToResourceRequest.Builder} avoiding the need
     * to create one manually via {@link AddTagsToResourceRequest#builder()}
     * </p>
     *
     * @param addTagsToResourceRequest
     *        A {@link Consumer} that will call methods on {@link AddTagsToResourceInput.Builder} to create a request.
     *        AddTagsToResourceInput
     * @return Result of the AddTagsToResource operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.AddTagsToResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/AddTagsToResource"
     *      target="_top">AWS API Documentation</a>
     */
    default AddTagsToResourceResponse addTagsToResource(Consumer<AddTagsToResourceRequest.Builder> addTagsToResourceRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        return addTagsToResource(AddTagsToResourceRequest.builder().applyMutation(addTagsToResourceRequest).build());
    }

    /**
     * <p>
     * Configures one or more gateway local disks as upload buffer for a specified gateway. This operation is supported
     * for the stored volume, cached volume, and tape gateway types.
     * </p>
     * <p>
     * In the request, you specify the gateway Amazon Resource Name (ARN) to which you want to add upload buffer, and
     * one or more disk IDs that you want to configure as upload buffer.
     * </p>
     *
     * @param addUploadBufferRequest
     * @return Result of the AddUploadBuffer operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.AddUploadBuffer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/AddUploadBuffer"
     *      target="_top">AWS API Documentation</a>
     */
    default AddUploadBufferResponse addUploadBuffer(AddUploadBufferRequest addUploadBufferRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Configures one or more gateway local disks as upload buffer for a specified gateway. This operation is supported
     * for the stored volume, cached volume, and tape gateway types.
     * </p>
     * <p>
     * In the request, you specify the gateway Amazon Resource Name (ARN) to which you want to add upload buffer, and
     * one or more disk IDs that you want to configure as upload buffer.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddUploadBufferRequest.Builder} avoiding the need
     * to create one manually via {@link AddUploadBufferRequest#builder()}
     * </p>
     *
     * @param addUploadBufferRequest
     *        A {@link Consumer} that will call methods on {@link AddUploadBufferInput.Builder} to create a request.
     * @return Result of the AddUploadBuffer operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.AddUploadBuffer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/AddUploadBuffer"
     *      target="_top">AWS API Documentation</a>
     */
    default AddUploadBufferResponse addUploadBuffer(Consumer<AddUploadBufferRequest.Builder> addUploadBufferRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        return addUploadBuffer(AddUploadBufferRequest.builder().applyMutation(addUploadBufferRequest).build());
    }

    /**
     * <p>
     * Configures one or more gateway local disks as working storage for a gateway. This operation is only supported in
     * the stored volume gateway type. This operation is deprecated in cached volume API version 20120630. Use
     * <a>AddUploadBuffer</a> instead.
     * </p>
     * <note>
     * <p>
     * Working storage is also referred to as upload buffer. You can also use the <a>AddUploadBuffer</a> operation to
     * add upload buffer to a stored volume gateway.
     * </p>
     * </note>
     * <p>
     * In the request, you specify the gateway Amazon Resource Name (ARN) to which you want to add working storage, and
     * one or more disk IDs that you want to configure as working storage.
     * </p>
     *
     * @param addWorkingStorageRequest
     *        A JSON object containing one or more of the following fields:</p>
     *        <ul>
     *        <li>
     *        <p>
     *        <a>AddWorkingStorageInput&#36DiskIds</a>
     *        </p>
     *        </li>
     * @return Result of the AddWorkingStorage operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.AddWorkingStorage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/AddWorkingStorage"
     *      target="_top">AWS API Documentation</a>
     */
    default AddWorkingStorageResponse addWorkingStorage(AddWorkingStorageRequest addWorkingStorageRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Configures one or more gateway local disks as working storage for a gateway. This operation is only supported in
     * the stored volume gateway type. This operation is deprecated in cached volume API version 20120630. Use
     * <a>AddUploadBuffer</a> instead.
     * </p>
     * <note>
     * <p>
     * Working storage is also referred to as upload buffer. You can also use the <a>AddUploadBuffer</a> operation to
     * add upload buffer to a stored volume gateway.
     * </p>
     * </note>
     * <p>
     * In the request, you specify the gateway Amazon Resource Name (ARN) to which you want to add working storage, and
     * one or more disk IDs that you want to configure as working storage.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddWorkingStorageRequest.Builder} avoiding the need
     * to create one manually via {@link AddWorkingStorageRequest#builder()}
     * </p>
     *
     * @param addWorkingStorageRequest
     *        A {@link Consumer} that will call methods on {@link AddWorkingStorageInput.Builder} to create a request. A
     *        JSON object containing one or more of the following fields:</p>
     *        <ul>
     *        <li>
     *        <p>
     *        <a>AddWorkingStorageInput&#36DiskIds</a>
     *        </p>
     *        </li>
     * @return Result of the AddWorkingStorage operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.AddWorkingStorage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/AddWorkingStorage"
     *      target="_top">AWS API Documentation</a>
     */
    default AddWorkingStorageResponse addWorkingStorage(Consumer<AddWorkingStorageRequest.Builder> addWorkingStorageRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        return addWorkingStorage(AddWorkingStorageRequest.builder().applyMutation(addWorkingStorageRequest).build());
    }

    /**
     * <p>
     * Assigns a tape to a tape pool for archiving. The tape assigned to a pool is archived in the S3 storage class that
     * is associated with the pool. When you use your backup application to eject the tape, the tape is archived
     * directly into the S3 storage class (S3 Glacier or S3 Glacier Deep Archive) that corresponds to the pool.
     * </p>
     *
     * @param assignTapePoolRequest
     * @return Result of the AssignTapePool operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.AssignTapePool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/AssignTapePool" target="_top">AWS
     *      API Documentation</a>
     */
    default AssignTapePoolResponse assignTapePool(AssignTapePoolRequest assignTapePoolRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Assigns a tape to a tape pool for archiving. The tape assigned to a pool is archived in the S3 storage class that
     * is associated with the pool. When you use your backup application to eject the tape, the tape is archived
     * directly into the S3 storage class (S3 Glacier or S3 Glacier Deep Archive) that corresponds to the pool.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssignTapePoolRequest.Builder} avoiding the need to
     * create one manually via {@link AssignTapePoolRequest#builder()}
     * </p>
     *
     * @param assignTapePoolRequest
     *        A {@link Consumer} that will call methods on {@link AssignTapePoolInput.Builder} to create a request.
     * @return Result of the AssignTapePool operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.AssignTapePool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/AssignTapePool" target="_top">AWS
     *      API Documentation</a>
     */
    default AssignTapePoolResponse assignTapePool(Consumer<AssignTapePoolRequest.Builder> assignTapePoolRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        return assignTapePool(AssignTapePoolRequest.builder().applyMutation(assignTapePoolRequest).build());
    }

    /**
     * <p>
     * Associate an Amazon FSx file system with the FSx File Gateway. After the association process is complete, the
     * file shares on the Amazon FSx file system are available for access through the gateway. This operation only
     * supports the FSx File Gateway type.
     * </p>
     *
     * @param associateFileSystemRequest
     * @return Result of the AssociateFileSystem operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.AssociateFileSystem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/AssociateFileSystem"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateFileSystemResponse associateFileSystem(AssociateFileSystemRequest associateFileSystemRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associate an Amazon FSx file system with the FSx File Gateway. After the association process is complete, the
     * file shares on the Amazon FSx file system are available for access through the gateway. This operation only
     * supports the FSx File Gateway type.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateFileSystemRequest.Builder} avoiding the
     * need to create one manually via {@link AssociateFileSystemRequest#builder()}
     * </p>
     *
     * @param associateFileSystemRequest
     *        A {@link Consumer} that will call methods on {@link AssociateFileSystemInput.Builder} to create a request.
     * @return Result of the AssociateFileSystem operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.AssociateFileSystem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/AssociateFileSystem"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateFileSystemResponse associateFileSystem(
            Consumer<AssociateFileSystemRequest.Builder> associateFileSystemRequest) throws InvalidGatewayRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, StorageGatewayException {
        return associateFileSystem(AssociateFileSystemRequest.builder().applyMutation(associateFileSystemRequest).build());
    }

    /**
     * <p>
     * Connects a volume to an iSCSI connection and then attaches the volume to the specified gateway. Detaching and
     * attaching a volume enables you to recover your data from one gateway to a different gateway without creating a
     * snapshot. It also makes it easier to move your volumes from an on-premises gateway to a gateway hosted on an
     * Amazon EC2 instance.
     * </p>
     *
     * @param attachVolumeRequest
     *        AttachVolumeInput
     * @return Result of the AttachVolume operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.AttachVolume
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/AttachVolume" target="_top">AWS
     *      API Documentation</a>
     */
    default AttachVolumeResponse attachVolume(AttachVolumeRequest attachVolumeRequest) throws InvalidGatewayRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, StorageGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Connects a volume to an iSCSI connection and then attaches the volume to the specified gateway. Detaching and
     * attaching a volume enables you to recover your data from one gateway to a different gateway without creating a
     * snapshot. It also makes it easier to move your volumes from an on-premises gateway to a gateway hosted on an
     * Amazon EC2 instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AttachVolumeRequest.Builder} avoiding the need to
     * create one manually via {@link AttachVolumeRequest#builder()}
     * </p>
     *
     * @param attachVolumeRequest
     *        A {@link Consumer} that will call methods on {@link AttachVolumeInput.Builder} to create a request.
     *        AttachVolumeInput
     * @return Result of the AttachVolume operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.AttachVolume
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/AttachVolume" target="_top">AWS
     *      API Documentation</a>
     */
    default AttachVolumeResponse attachVolume(Consumer<AttachVolumeRequest.Builder> attachVolumeRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        return attachVolume(AttachVolumeRequest.builder().applyMutation(attachVolumeRequest).build());
    }

    /**
     * <p>
     * Cancels archiving of a virtual tape to the virtual tape shelf (VTS) after the archiving process is initiated.
     * This operation is only supported in the tape gateway type.
     * </p>
     *
     * @param cancelArchivalRequest
     *        CancelArchivalInput
     * @return Result of the CancelArchival operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.CancelArchival
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/CancelArchival" target="_top">AWS
     *      API Documentation</a>
     */
    default CancelArchivalResponse cancelArchival(CancelArchivalRequest cancelArchivalRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels archiving of a virtual tape to the virtual tape shelf (VTS) after the archiving process is initiated.
     * This operation is only supported in the tape gateway type.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelArchivalRequest.Builder} avoiding the need to
     * create one manually via {@link CancelArchivalRequest#builder()}
     * </p>
     *
     * @param cancelArchivalRequest
     *        A {@link Consumer} that will call methods on {@link CancelArchivalInput.Builder} to create a request.
     *        CancelArchivalInput
     * @return Result of the CancelArchival operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.CancelArchival
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/CancelArchival" target="_top">AWS
     *      API Documentation</a>
     */
    default CancelArchivalResponse cancelArchival(Consumer<CancelArchivalRequest.Builder> cancelArchivalRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        return cancelArchival(CancelArchivalRequest.builder().applyMutation(cancelArchivalRequest).build());
    }

    /**
     * <p>
     * Cancels retrieval of a virtual tape from the virtual tape shelf (VTS) to a gateway after the retrieval process is
     * initiated. The virtual tape is returned to the VTS. This operation is only supported in the tape gateway type.
     * </p>
     *
     * @param cancelRetrievalRequest
     *        CancelRetrievalInput
     * @return Result of the CancelRetrieval operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.CancelRetrieval
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/CancelRetrieval"
     *      target="_top">AWS API Documentation</a>
     */
    default CancelRetrievalResponse cancelRetrieval(CancelRetrievalRequest cancelRetrievalRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels retrieval of a virtual tape from the virtual tape shelf (VTS) to a gateway after the retrieval process is
     * initiated. The virtual tape is returned to the VTS. This operation is only supported in the tape gateway type.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelRetrievalRequest.Builder} avoiding the need
     * to create one manually via {@link CancelRetrievalRequest#builder()}
     * </p>
     *
     * @param cancelRetrievalRequest
     *        A {@link Consumer} that will call methods on {@link CancelRetrievalInput.Builder} to create a request.
     *        CancelRetrievalInput
     * @return Result of the CancelRetrieval operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.CancelRetrieval
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/CancelRetrieval"
     *      target="_top">AWS API Documentation</a>
     */
    default CancelRetrievalResponse cancelRetrieval(Consumer<CancelRetrievalRequest.Builder> cancelRetrievalRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        return cancelRetrieval(CancelRetrievalRequest.builder().applyMutation(cancelRetrievalRequest).build());
    }

    /**
     * <p>
     * Creates a cached volume on a specified cached volume gateway. This operation is only supported in the cached
     * volume gateway type.
     * </p>
     * <note>
     * <p>
     * Cache storage must be allocated to the gateway before you can create a cached volume. Use the <a>AddCache</a>
     * operation to add cache storage to a gateway.
     * </p>
     * </note>
     * <p>
     * In the request, you must specify the gateway, size of the volume in bytes, the iSCSI target name, an IP address
     * on which to expose the target, and a unique client token. In response, the gateway creates the volume and returns
     * information about it. This information includes the volume Amazon Resource Name (ARN), its size, and the iSCSI
     * target ARN that initiators can use to connect to the volume target.
     * </p>
     * <p>
     * Optionally, you can provide the ARN for an existing volume as the <code>SourceVolumeARN</code> for this cached
     * volume, which creates an exact copy of the existing volume’s latest recovery point. The
     * <code>VolumeSizeInBytes</code> value must be equal to or larger than the size of the copied volume, in bytes.
     * </p>
     *
     * @param createCachediScsiVolumeRequest
     * @return Result of the CreateCachediSCSIVolume operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.CreateCachediSCSIVolume
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/CreateCachediSCSIVolume"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateCachediScsiVolumeResponse createCachediSCSIVolume(CreateCachediScsiVolumeRequest createCachediScsiVolumeRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a cached volume on a specified cached volume gateway. This operation is only supported in the cached
     * volume gateway type.
     * </p>
     * <note>
     * <p>
     * Cache storage must be allocated to the gateway before you can create a cached volume. Use the <a>AddCache</a>
     * operation to add cache storage to a gateway.
     * </p>
     * </note>
     * <p>
     * In the request, you must specify the gateway, size of the volume in bytes, the iSCSI target name, an IP address
     * on which to expose the target, and a unique client token. In response, the gateway creates the volume and returns
     * information about it. This information includes the volume Amazon Resource Name (ARN), its size, and the iSCSI
     * target ARN that initiators can use to connect to the volume target.
     * </p>
     * <p>
     * Optionally, you can provide the ARN for an existing volume as the <code>SourceVolumeARN</code> for this cached
     * volume, which creates an exact copy of the existing volume’s latest recovery point. The
     * <code>VolumeSizeInBytes</code> value must be equal to or larger than the size of the copied volume, in bytes.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCachediScsiVolumeRequest.Builder} avoiding
     * the need to create one manually via {@link CreateCachediScsiVolumeRequest#builder()}
     * </p>
     *
     * @param createCachediScsiVolumeRequest
     *        A {@link Consumer} that will call methods on {@link CreateCachediSCSIVolumeInput.Builder} to create a
     *        request.
     * @return Result of the CreateCachediSCSIVolume operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.CreateCachediSCSIVolume
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/CreateCachediSCSIVolume"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateCachediScsiVolumeResponse createCachediSCSIVolume(
            Consumer<CreateCachediScsiVolumeRequest.Builder> createCachediScsiVolumeRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        return createCachediSCSIVolume(CreateCachediScsiVolumeRequest.builder().applyMutation(createCachediScsiVolumeRequest)
                .build());
    }

    /**
     * <p>
     * Creates a Network File System (NFS) file share on an existing S3 File Gateway. In Storage Gateway, a file share
     * is a file system mount point backed by Amazon S3 cloud storage. Storage Gateway exposes file shares using an NFS
     * interface. This operation is only supported for S3 File Gateways.
     * </p>
     * <important>
     * <p>
     * S3 File gateway requires Security Token Service (Amazon Web Services STS) to be activated to enable you to create
     * a file share. Make sure Amazon Web Services STS is activated in the Amazon Web Services Region you are creating
     * your S3 File Gateway in. If Amazon Web Services STS is not activated in the Amazon Web Services Region, activate
     * it. For information about how to activate Amazon Web Services STS, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_enable-regions.html">Activating and
     * deactivating Amazon Web Services STS in an Amazon Web Services Region</a> in the <i>Identity and Access
     * Management User Guide</i>.
     * </p>
     * <p>
     * S3 File Gateways do not support creating hard or symbolic links on a file share.
     * </p>
     * </important>
     *
     * @param createNfsFileShareRequest
     *        CreateNFSFileShareInput
     * @return Result of the CreateNFSFileShare operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.CreateNFSFileShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/CreateNFSFileShare"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateNfsFileShareResponse createNFSFileShare(CreateNfsFileShareRequest createNfsFileShareRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a Network File System (NFS) file share on an existing S3 File Gateway. In Storage Gateway, a file share
     * is a file system mount point backed by Amazon S3 cloud storage. Storage Gateway exposes file shares using an NFS
     * interface. This operation is only supported for S3 File Gateways.
     * </p>
     * <important>
     * <p>
     * S3 File gateway requires Security Token Service (Amazon Web Services STS) to be activated to enable you to create
     * a file share. Make sure Amazon Web Services STS is activated in the Amazon Web Services Region you are creating
     * your S3 File Gateway in. If Amazon Web Services STS is not activated in the Amazon Web Services Region, activate
     * it. For information about how to activate Amazon Web Services STS, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_enable-regions.html">Activating and
     * deactivating Amazon Web Services STS in an Amazon Web Services Region</a> in the <i>Identity and Access
     * Management User Guide</i>.
     * </p>
     * <p>
     * S3 File Gateways do not support creating hard or symbolic links on a file share.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateNfsFileShareRequest.Builder} avoiding the
     * need to create one manually via {@link CreateNfsFileShareRequest#builder()}
     * </p>
     *
     * @param createNfsFileShareRequest
     *        A {@link Consumer} that will call methods on {@link CreateNFSFileShareInput.Builder} to create a request.
     *        CreateNFSFileShareInput
     * @return Result of the CreateNFSFileShare operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.CreateNFSFileShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/CreateNFSFileShare"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateNfsFileShareResponse createNFSFileShare(Consumer<CreateNfsFileShareRequest.Builder> createNfsFileShareRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        return createNFSFileShare(CreateNfsFileShareRequest.builder().applyMutation(createNfsFileShareRequest).build());
    }

    /**
     * <p>
     * Creates a Server Message Block (SMB) file share on an existing S3 File Gateway. In Storage Gateway, a file share
     * is a file system mount point backed by Amazon S3 cloud storage. Storage Gateway exposes file shares using an SMB
     * interface. This operation is only supported for S3 File Gateways.
     * </p>
     * <important>
     * <p>
     * S3 File Gateways require Security Token Service (Amazon Web Services STS) to be activated to enable you to create
     * a file share. Make sure that Amazon Web Services STS is activated in the Amazon Web Services Region you are
     * creating your S3 File Gateway in. If Amazon Web Services STS is not activated in this Amazon Web Services Region,
     * activate it. For information about how to activate Amazon Web Services STS, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_enable-regions.html">Activating and
     * deactivating Amazon Web Services STS in an Amazon Web Services Region</a> in the <i>Identity and Access
     * Management User Guide</i>.
     * </p>
     * <p>
     * File gateways don't support creating hard or symbolic links on a file share.
     * </p>
     * </important>
     *
     * @param createSmbFileShareRequest
     *        CreateSMBFileShareInput
     * @return Result of the CreateSMBFileShare operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.CreateSMBFileShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/CreateSMBFileShare"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateSmbFileShareResponse createSMBFileShare(CreateSmbFileShareRequest createSmbFileShareRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a Server Message Block (SMB) file share on an existing S3 File Gateway. In Storage Gateway, a file share
     * is a file system mount point backed by Amazon S3 cloud storage. Storage Gateway exposes file shares using an SMB
     * interface. This operation is only supported for S3 File Gateways.
     * </p>
     * <important>
     * <p>
     * S3 File Gateways require Security Token Service (Amazon Web Services STS) to be activated to enable you to create
     * a file share. Make sure that Amazon Web Services STS is activated in the Amazon Web Services Region you are
     * creating your S3 File Gateway in. If Amazon Web Services STS is not activated in this Amazon Web Services Region,
     * activate it. For information about how to activate Amazon Web Services STS, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_enable-regions.html">Activating and
     * deactivating Amazon Web Services STS in an Amazon Web Services Region</a> in the <i>Identity and Access
     * Management User Guide</i>.
     * </p>
     * <p>
     * File gateways don't support creating hard or symbolic links on a file share.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSmbFileShareRequest.Builder} avoiding the
     * need to create one manually via {@link CreateSmbFileShareRequest#builder()}
     * </p>
     *
     * @param createSmbFileShareRequest
     *        A {@link Consumer} that will call methods on {@link CreateSMBFileShareInput.Builder} to create a request.
     *        CreateSMBFileShareInput
     * @return Result of the CreateSMBFileShare operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.CreateSMBFileShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/CreateSMBFileShare"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateSmbFileShareResponse createSMBFileShare(Consumer<CreateSmbFileShareRequest.Builder> createSmbFileShareRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        return createSMBFileShare(CreateSmbFileShareRequest.builder().applyMutation(createSmbFileShareRequest).build());
    }

    /**
     * <p>
     * Initiates a snapshot of a volume.
     * </p>
     * <p>
     * Storage Gateway provides the ability to back up point-in-time snapshots of your data to Amazon Simple Storage
     * (Amazon S3) for durable off-site recovery, and also import the data to an Amazon Elastic Block Store (EBS) volume
     * in Amazon Elastic Compute Cloud (EC2). You can take snapshots of your gateway volume on a scheduled or ad hoc
     * basis. This API enables you to take an ad hoc snapshot. For more information, see <a
     * href="https://docs.aws.amazon.com/storagegateway/latest/userguide/managing-volumes.html#SchedulingSnapshot"
     * >Editing a snapshot schedule</a>.
     * </p>
     * <p>
     * In the <code>CreateSnapshot</code> request, you identify the volume by providing its Amazon Resource Name (ARN).
     * You must also provide description for the snapshot. When Storage Gateway takes the snapshot of specified volume,
     * the snapshot and description appears in the Storage Gateway console. In response, Storage Gateway returns you a
     * snapshot ID. You can use this snapshot ID to check the snapshot progress or later use it when you want to create
     * a volume from a snapshot. This operation is only supported in stored and cached volume gateway type.
     * </p>
     * <note>
     * <p>
     * To list or delete a snapshot, you must use the Amazon EC2 API. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeSnapshots.html">DescribeSnapshots</a> or
     * <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteSnapshot.html">DeleteSnapshot</a> in
     * the <i>Amazon Elastic Compute Cloud API Reference</i>.
     * </p>
     * </note> <important>
     * <p>
     * Volume and snapshot IDs are changing to a longer length ID format. For more information, see the important note
     * on the <a href="https://docs.aws.amazon.com/storagegateway/latest/APIReference/Welcome.html">Welcome</a> page.
     * </p>
     * </important>
     *
     * @param createSnapshotRequest
     *        A JSON object containing one or more of the following fields:</p>
     *        <ul>
     *        <li>
     *        <p>
     *        <a>CreateSnapshotInput&#36SnapshotDescription</a>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <a>CreateSnapshotInput&#36VolumeARN</a>
     *        </p>
     *        </li>
     * @return Result of the CreateSnapshot operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws ServiceUnavailableErrorException
     *         An internal server error has occurred because the service is unavailable. For more information, see the
     *         error and message fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.CreateSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/CreateSnapshot" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateSnapshotResponse createSnapshot(CreateSnapshotRequest createSnapshotRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, ServiceUnavailableErrorException,
            AwsServiceException, SdkClientException, StorageGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Initiates a snapshot of a volume.
     * </p>
     * <p>
     * Storage Gateway provides the ability to back up point-in-time snapshots of your data to Amazon Simple Storage
     * (Amazon S3) for durable off-site recovery, and also import the data to an Amazon Elastic Block Store (EBS) volume
     * in Amazon Elastic Compute Cloud (EC2). You can take snapshots of your gateway volume on a scheduled or ad hoc
     * basis. This API enables you to take an ad hoc snapshot. For more information, see <a
     * href="https://docs.aws.amazon.com/storagegateway/latest/userguide/managing-volumes.html#SchedulingSnapshot"
     * >Editing a snapshot schedule</a>.
     * </p>
     * <p>
     * In the <code>CreateSnapshot</code> request, you identify the volume by providing its Amazon Resource Name (ARN).
     * You must also provide description for the snapshot. When Storage Gateway takes the snapshot of specified volume,
     * the snapshot and description appears in the Storage Gateway console. In response, Storage Gateway returns you a
     * snapshot ID. You can use this snapshot ID to check the snapshot progress or later use it when you want to create
     * a volume from a snapshot. This operation is only supported in stored and cached volume gateway type.
     * </p>
     * <note>
     * <p>
     * To list or delete a snapshot, you must use the Amazon EC2 API. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeSnapshots.html">DescribeSnapshots</a> or
     * <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteSnapshot.html">DeleteSnapshot</a> in
     * the <i>Amazon Elastic Compute Cloud API Reference</i>.
     * </p>
     * </note> <important>
     * <p>
     * Volume and snapshot IDs are changing to a longer length ID format. For more information, see the important note
     * on the <a href="https://docs.aws.amazon.com/storagegateway/latest/APIReference/Welcome.html">Welcome</a> page.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSnapshotRequest.Builder} avoiding the need to
     * create one manually via {@link CreateSnapshotRequest#builder()}
     * </p>
     *
     * @param createSnapshotRequest
     *        A {@link Consumer} that will call methods on {@link CreateSnapshotInput.Builder} to create a request. A
     *        JSON object containing one or more of the following fields:</p>
     *        <ul>
     *        <li>
     *        <p>
     *        <a>CreateSnapshotInput&#36SnapshotDescription</a>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <a>CreateSnapshotInput&#36VolumeARN</a>
     *        </p>
     *        </li>
     * @return Result of the CreateSnapshot operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws ServiceUnavailableErrorException
     *         An internal server error has occurred because the service is unavailable. For more information, see the
     *         error and message fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.CreateSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/CreateSnapshot" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateSnapshotResponse createSnapshot(Consumer<CreateSnapshotRequest.Builder> createSnapshotRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, ServiceUnavailableErrorException,
            AwsServiceException, SdkClientException, StorageGatewayException {
        return createSnapshot(CreateSnapshotRequest.builder().applyMutation(createSnapshotRequest).build());
    }

    /**
     * <p>
     * Initiates a snapshot of a gateway from a volume recovery point. This operation is only supported in the cached
     * volume gateway type.
     * </p>
     * <p>
     * A volume recovery point is a point in time at which all data of the volume is consistent and from which you can
     * create a snapshot. To get a list of volume recovery point for cached volume gateway, use
     * <a>ListVolumeRecoveryPoints</a>.
     * </p>
     * <p>
     * In the <code>CreateSnapshotFromVolumeRecoveryPoint</code> request, you identify the volume by providing its
     * Amazon Resource Name (ARN). You must also provide a description for the snapshot. When the gateway takes a
     * snapshot of the specified volume, the snapshot and its description appear in the Storage Gateway console. In
     * response, the gateway returns you a snapshot ID. You can use this snapshot ID to check the snapshot progress or
     * later use it when you want to create a volume from a snapshot.
     * </p>
     * <note>
     * <p>
     * To list or delete a snapshot, you must use the Amazon EC2 API. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeSnapshots.html">DescribeSnapshots</a> or
     * <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteSnapshot.html">DeleteSnapshot</a> in
     * the <i>Amazon Elastic Compute Cloud API Reference</i>.
     * </p>
     * </note>
     *
     * @param createSnapshotFromVolumeRecoveryPointRequest
     * @return Result of the CreateSnapshotFromVolumeRecoveryPoint operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws ServiceUnavailableErrorException
     *         An internal server error has occurred because the service is unavailable. For more information, see the
     *         error and message fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.CreateSnapshotFromVolumeRecoveryPoint
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/CreateSnapshotFromVolumeRecoveryPoint"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateSnapshotFromVolumeRecoveryPointResponse createSnapshotFromVolumeRecoveryPoint(
            CreateSnapshotFromVolumeRecoveryPointRequest createSnapshotFromVolumeRecoveryPointRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, ServiceUnavailableErrorException,
            AwsServiceException, SdkClientException, StorageGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Initiates a snapshot of a gateway from a volume recovery point. This operation is only supported in the cached
     * volume gateway type.
     * </p>
     * <p>
     * A volume recovery point is a point in time at which all data of the volume is consistent and from which you can
     * create a snapshot. To get a list of volume recovery point for cached volume gateway, use
     * <a>ListVolumeRecoveryPoints</a>.
     * </p>
     * <p>
     * In the <code>CreateSnapshotFromVolumeRecoveryPoint</code> request, you identify the volume by providing its
     * Amazon Resource Name (ARN). You must also provide a description for the snapshot. When the gateway takes a
     * snapshot of the specified volume, the snapshot and its description appear in the Storage Gateway console. In
     * response, the gateway returns you a snapshot ID. You can use this snapshot ID to check the snapshot progress or
     * later use it when you want to create a volume from a snapshot.
     * </p>
     * <note>
     * <p>
     * To list or delete a snapshot, you must use the Amazon EC2 API. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeSnapshots.html">DescribeSnapshots</a> or
     * <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteSnapshot.html">DeleteSnapshot</a> in
     * the <i>Amazon Elastic Compute Cloud API Reference</i>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link CreateSnapshotFromVolumeRecoveryPointRequest.Builder} avoiding the need to create one manually via
     * {@link CreateSnapshotFromVolumeRecoveryPointRequest#builder()}
     * </p>
     *
     * @param createSnapshotFromVolumeRecoveryPointRequest
     *        A {@link Consumer} that will call methods on {@link CreateSnapshotFromVolumeRecoveryPointInput.Builder} to
     *        create a request.
     * @return Result of the CreateSnapshotFromVolumeRecoveryPoint operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws ServiceUnavailableErrorException
     *         An internal server error has occurred because the service is unavailable. For more information, see the
     *         error and message fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.CreateSnapshotFromVolumeRecoveryPoint
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/CreateSnapshotFromVolumeRecoveryPoint"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateSnapshotFromVolumeRecoveryPointResponse createSnapshotFromVolumeRecoveryPoint(
            Consumer<CreateSnapshotFromVolumeRecoveryPointRequest.Builder> createSnapshotFromVolumeRecoveryPointRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, ServiceUnavailableErrorException,
            AwsServiceException, SdkClientException, StorageGatewayException {
        return createSnapshotFromVolumeRecoveryPoint(CreateSnapshotFromVolumeRecoveryPointRequest.builder()
                .applyMutation(createSnapshotFromVolumeRecoveryPointRequest).build());
    }

    /**
     * <p>
     * Creates a volume on a specified gateway. This operation is only supported in the stored volume gateway type.
     * </p>
     * <p>
     * The size of the volume to create is inferred from the disk size. You can choose to preserve existing data on the
     * disk, create volume from an existing snapshot, or create an empty volume. If you choose to create an empty
     * gateway volume, then any existing data on the disk is erased.
     * </p>
     * <p>
     * In the request, you must specify the gateway and the disk information on which you are creating the volume. In
     * response, the gateway creates the volume and returns volume information such as the volume Amazon Resource Name
     * (ARN), its size, and the iSCSI target ARN that initiators can use to connect to the volume target.
     * </p>
     *
     * @param createStorediScsiVolumeRequest
     *        A JSON object containing one or more of the following fields:</p>
     *        <ul>
     *        <li>
     *        <p>
     *        <a>CreateStorediSCSIVolumeInput&#36DiskId</a>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <a>CreateStorediSCSIVolumeInput&#36NetworkInterfaceId</a>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <a>CreateStorediSCSIVolumeInput&#36PreserveExistingData</a>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <a>CreateStorediSCSIVolumeInput&#36SnapshotId</a>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <a>CreateStorediSCSIVolumeInput&#36TargetName</a>
     *        </p>
     *        </li>
     * @return Result of the CreateStorediSCSIVolume operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.CreateStorediSCSIVolume
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/CreateStorediSCSIVolume"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateStorediScsiVolumeResponse createStorediSCSIVolume(CreateStorediScsiVolumeRequest createStorediScsiVolumeRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a volume on a specified gateway. This operation is only supported in the stored volume gateway type.
     * </p>
     * <p>
     * The size of the volume to create is inferred from the disk size. You can choose to preserve existing data on the
     * disk, create volume from an existing snapshot, or create an empty volume. If you choose to create an empty
     * gateway volume, then any existing data on the disk is erased.
     * </p>
     * <p>
     * In the request, you must specify the gateway and the disk information on which you are creating the volume. In
     * response, the gateway creates the volume and returns volume information such as the volume Amazon Resource Name
     * (ARN), its size, and the iSCSI target ARN that initiators can use to connect to the volume target.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateStorediScsiVolumeRequest.Builder} avoiding
     * the need to create one manually via {@link CreateStorediScsiVolumeRequest#builder()}
     * </p>
     *
     * @param createStorediScsiVolumeRequest
     *        A {@link Consumer} that will call methods on {@link CreateStorediSCSIVolumeInput.Builder} to create a
     *        request. A JSON object containing one or more of the following fields:</p>
     *        <ul>
     *        <li>
     *        <p>
     *        <a>CreateStorediSCSIVolumeInput&#36DiskId</a>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <a>CreateStorediSCSIVolumeInput&#36NetworkInterfaceId</a>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <a>CreateStorediSCSIVolumeInput&#36PreserveExistingData</a>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <a>CreateStorediSCSIVolumeInput&#36SnapshotId</a>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <a>CreateStorediSCSIVolumeInput&#36TargetName</a>
     *        </p>
     *        </li>
     * @return Result of the CreateStorediSCSIVolume operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.CreateStorediSCSIVolume
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/CreateStorediSCSIVolume"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateStorediScsiVolumeResponse createStorediSCSIVolume(
            Consumer<CreateStorediScsiVolumeRequest.Builder> createStorediScsiVolumeRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        return createStorediSCSIVolume(CreateStorediScsiVolumeRequest.builder().applyMutation(createStorediScsiVolumeRequest)
                .build());
    }

    /**
     * <p>
     * Creates a new custom tape pool. You can use custom tape pool to enable tape retention lock on tapes that are
     * archived in the custom pool.
     * </p>
     *
     * @param createTapePoolRequest
     * @return Result of the CreateTapePool operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.CreateTapePool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/CreateTapePool" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateTapePoolResponse createTapePool(CreateTapePoolRequest createTapePoolRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new custom tape pool. You can use custom tape pool to enable tape retention lock on tapes that are
     * archived in the custom pool.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTapePoolRequest.Builder} avoiding the need to
     * create one manually via {@link CreateTapePoolRequest#builder()}
     * </p>
     *
     * @param createTapePoolRequest
     *        A {@link Consumer} that will call methods on {@link CreateTapePoolInput.Builder} to create a request.
     * @return Result of the CreateTapePool operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.CreateTapePool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/CreateTapePool" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateTapePoolResponse createTapePool(Consumer<CreateTapePoolRequest.Builder> createTapePoolRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        return createTapePool(CreateTapePoolRequest.builder().applyMutation(createTapePoolRequest).build());
    }

    /**
     * <p>
     * Creates a virtual tape by using your own barcode. You write data to the virtual tape and then archive the tape. A
     * barcode is unique and cannot be reused if it has already been used on a tape. This applies to barcodes used on
     * deleted tapes. This operation is only supported in the tape gateway type.
     * </p>
     * <note>
     * <p>
     * Cache storage must be allocated to the gateway before you can create a virtual tape. Use the <a>AddCache</a>
     * operation to add cache storage to a gateway.
     * </p>
     * </note>
     *
     * @param createTapeWithBarcodeRequest
     *        CreateTapeWithBarcodeInput
     * @return Result of the CreateTapeWithBarcode operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.CreateTapeWithBarcode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/CreateTapeWithBarcode"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateTapeWithBarcodeResponse createTapeWithBarcode(CreateTapeWithBarcodeRequest createTapeWithBarcodeRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a virtual tape by using your own barcode. You write data to the virtual tape and then archive the tape. A
     * barcode is unique and cannot be reused if it has already been used on a tape. This applies to barcodes used on
     * deleted tapes. This operation is only supported in the tape gateway type.
     * </p>
     * <note>
     * <p>
     * Cache storage must be allocated to the gateway before you can create a virtual tape. Use the <a>AddCache</a>
     * operation to add cache storage to a gateway.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTapeWithBarcodeRequest.Builder} avoiding the
     * need to create one manually via {@link CreateTapeWithBarcodeRequest#builder()}
     * </p>
     *
     * @param createTapeWithBarcodeRequest
     *        A {@link Consumer} that will call methods on {@link CreateTapeWithBarcodeInput.Builder} to create a
     *        request. CreateTapeWithBarcodeInput
     * @return Result of the CreateTapeWithBarcode operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.CreateTapeWithBarcode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/CreateTapeWithBarcode"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateTapeWithBarcodeResponse createTapeWithBarcode(
            Consumer<CreateTapeWithBarcodeRequest.Builder> createTapeWithBarcodeRequest) throws InvalidGatewayRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, StorageGatewayException {
        return createTapeWithBarcode(CreateTapeWithBarcodeRequest.builder().applyMutation(createTapeWithBarcodeRequest).build());
    }

    /**
     * <p>
     * Creates one or more virtual tapes. You write data to the virtual tapes and then archive the tapes. This operation
     * is only supported in the tape gateway type.
     * </p>
     * <note>
     * <p>
     * Cache storage must be allocated to the gateway before you can create virtual tapes. Use the <a>AddCache</a>
     * operation to add cache storage to a gateway.
     * </p>
     * </note>
     *
     * @param createTapesRequest
     *        CreateTapesInput
     * @return Result of the CreateTapes operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.CreateTapes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/CreateTapes" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateTapesResponse createTapes(CreateTapesRequest createTapesRequest) throws InvalidGatewayRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, StorageGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates one or more virtual tapes. You write data to the virtual tapes and then archive the tapes. This operation
     * is only supported in the tape gateway type.
     * </p>
     * <note>
     * <p>
     * Cache storage must be allocated to the gateway before you can create virtual tapes. Use the <a>AddCache</a>
     * operation to add cache storage to a gateway.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTapesRequest.Builder} avoiding the need to
     * create one manually via {@link CreateTapesRequest#builder()}
     * </p>
     *
     * @param createTapesRequest
     *        A {@link Consumer} that will call methods on {@link CreateTapesInput.Builder} to create a request.
     *        CreateTapesInput
     * @return Result of the CreateTapes operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.CreateTapes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/CreateTapes" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateTapesResponse createTapes(Consumer<CreateTapesRequest.Builder> createTapesRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        return createTapes(CreateTapesRequest.builder().applyMutation(createTapesRequest).build());
    }

    /**
     * <p>
     * Deletes the automatic tape creation policy of a gateway. If you delete this policy, new virtual tapes must be
     * created manually. Use the Amazon Resource Name (ARN) of the gateway in your request to remove the policy.
     * </p>
     *
     * @param deleteAutomaticTapeCreationPolicyRequest
     * @return Result of the DeleteAutomaticTapeCreationPolicy operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.DeleteAutomaticTapeCreationPolicy
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DeleteAutomaticTapeCreationPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteAutomaticTapeCreationPolicyResponse deleteAutomaticTapeCreationPolicy(
            DeleteAutomaticTapeCreationPolicyRequest deleteAutomaticTapeCreationPolicyRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the automatic tape creation policy of a gateway. If you delete this policy, new virtual tapes must be
     * created manually. Use the Amazon Resource Name (ARN) of the gateway in your request to remove the policy.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAutomaticTapeCreationPolicyRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteAutomaticTapeCreationPolicyRequest#builder()}
     * </p>
     *
     * @param deleteAutomaticTapeCreationPolicyRequest
     *        A {@link Consumer} that will call methods on {@link DeleteAutomaticTapeCreationPolicyInput.Builder} to
     *        create a request.
     * @return Result of the DeleteAutomaticTapeCreationPolicy operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.DeleteAutomaticTapeCreationPolicy
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DeleteAutomaticTapeCreationPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteAutomaticTapeCreationPolicyResponse deleteAutomaticTapeCreationPolicy(
            Consumer<DeleteAutomaticTapeCreationPolicyRequest.Builder> deleteAutomaticTapeCreationPolicyRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        return deleteAutomaticTapeCreationPolicy(DeleteAutomaticTapeCreationPolicyRequest.builder()
                .applyMutation(deleteAutomaticTapeCreationPolicyRequest).build());
    }

    /**
     * <p>
     * Deletes the bandwidth rate limits of a gateway. You can delete either the upload and download bandwidth rate
     * limit, or you can delete both. If you delete only one of the limits, the other limit remains unchanged. To
     * specify which gateway to work with, use the Amazon Resource Name (ARN) of the gateway in your request. This
     * operation is supported only for the stored volume, cached volume, and tape gateway types.
     * </p>
     *
     * @param deleteBandwidthRateLimitRequest
     *        A JSON object containing the following fields:</p>
     *        <ul>
     *        <li>
     *        <p>
     *        <a>DeleteBandwidthRateLimitInput&#36BandwidthType</a>
     *        </p>
     *        </li>
     * @return Result of the DeleteBandwidthRateLimit operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.DeleteBandwidthRateLimit
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DeleteBandwidthRateLimit"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteBandwidthRateLimitResponse deleteBandwidthRateLimit(
            DeleteBandwidthRateLimitRequest deleteBandwidthRateLimitRequest) throws InvalidGatewayRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, StorageGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the bandwidth rate limits of a gateway. You can delete either the upload and download bandwidth rate
     * limit, or you can delete both. If you delete only one of the limits, the other limit remains unchanged. To
     * specify which gateway to work with, use the Amazon Resource Name (ARN) of the gateway in your request. This
     * operation is supported only for the stored volume, cached volume, and tape gateway types.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteBandwidthRateLimitRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteBandwidthRateLimitRequest#builder()}
     * </p>
     *
     * @param deleteBandwidthRateLimitRequest
     *        A {@link Consumer} that will call methods on {@link DeleteBandwidthRateLimitInput.Builder} to create a
     *        request. A JSON object containing the following fields:</p>
     *        <ul>
     *        <li>
     *        <p>
     *        <a>DeleteBandwidthRateLimitInput&#36BandwidthType</a>
     *        </p>
     *        </li>
     * @return Result of the DeleteBandwidthRateLimit operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.DeleteBandwidthRateLimit
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DeleteBandwidthRateLimit"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteBandwidthRateLimitResponse deleteBandwidthRateLimit(
            Consumer<DeleteBandwidthRateLimitRequest.Builder> deleteBandwidthRateLimitRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        return deleteBandwidthRateLimit(DeleteBandwidthRateLimitRequest.builder().applyMutation(deleteBandwidthRateLimitRequest)
                .build());
    }

    /**
     * <p>
     * Deletes Challenge-Handshake Authentication Protocol (CHAP) credentials for a specified iSCSI target and initiator
     * pair. This operation is supported in volume and tape gateway types.
     * </p>
     *
     * @param deleteChapCredentialsRequest
     *        A JSON object containing one or more of the following fields:</p>
     *        <ul>
     *        <li>
     *        <p>
     *        <a>DeleteChapCredentialsInput&#36InitiatorName</a>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <a>DeleteChapCredentialsInput&#36TargetARN</a>
     *        </p>
     *        </li>
     * @return Result of the DeleteChapCredentials operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.DeleteChapCredentials
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DeleteChapCredentials"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteChapCredentialsResponse deleteChapCredentials(DeleteChapCredentialsRequest deleteChapCredentialsRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes Challenge-Handshake Authentication Protocol (CHAP) credentials for a specified iSCSI target and initiator
     * pair. This operation is supported in volume and tape gateway types.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteChapCredentialsRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteChapCredentialsRequest#builder()}
     * </p>
     *
     * @param deleteChapCredentialsRequest
     *        A {@link Consumer} that will call methods on {@link DeleteChapCredentialsInput.Builder} to create a
     *        request. A JSON object containing one or more of the following fields:</p>
     *        <ul>
     *        <li>
     *        <p>
     *        <a>DeleteChapCredentialsInput&#36InitiatorName</a>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <a>DeleteChapCredentialsInput&#36TargetARN</a>
     *        </p>
     *        </li>
     * @return Result of the DeleteChapCredentials operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.DeleteChapCredentials
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DeleteChapCredentials"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteChapCredentialsResponse deleteChapCredentials(
            Consumer<DeleteChapCredentialsRequest.Builder> deleteChapCredentialsRequest) throws InvalidGatewayRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, StorageGatewayException {
        return deleteChapCredentials(DeleteChapCredentialsRequest.builder().applyMutation(deleteChapCredentialsRequest).build());
    }

    /**
     * <p>
     * Deletes a file share from an S3 File Gateway. This operation is only supported for S3 File Gateways.
     * </p>
     *
     * @param deleteFileShareRequest
     *        DeleteFileShareInput
     * @return Result of the DeleteFileShare operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.DeleteFileShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DeleteFileShare"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteFileShareResponse deleteFileShare(DeleteFileShareRequest deleteFileShareRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a file share from an S3 File Gateway. This operation is only supported for S3 File Gateways.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteFileShareRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteFileShareRequest#builder()}
     * </p>
     *
     * @param deleteFileShareRequest
     *        A {@link Consumer} that will call methods on {@link DeleteFileShareInput.Builder} to create a request.
     *        DeleteFileShareInput
     * @return Result of the DeleteFileShare operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.DeleteFileShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DeleteFileShare"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteFileShareResponse deleteFileShare(Consumer<DeleteFileShareRequest.Builder> deleteFileShareRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        return deleteFileShare(DeleteFileShareRequest.builder().applyMutation(deleteFileShareRequest).build());
    }

    /**
     * <p>
     * Deletes a gateway. To specify which gateway to delete, use the Amazon Resource Name (ARN) of the gateway in your
     * request. The operation deletes the gateway; however, it does not delete the gateway virtual machine (VM) from
     * your host computer.
     * </p>
     * <p>
     * After you delete a gateway, you cannot reactivate it. Completed snapshots of the gateway volumes are not deleted
     * upon deleting the gateway, however, pending snapshots will not complete. After you delete a gateway, your next
     * step is to remove it from your environment.
     * </p>
     * <important>
     * <p>
     * You no longer pay software charges after the gateway is deleted; however, your existing Amazon EBS snapshots
     * persist and you will continue to be billed for these snapshots. You can choose to remove all remaining Amazon EBS
     * snapshots by canceling your Amazon EC2 subscription.  If you prefer not to cancel your Amazon EC2 subscription,
     * you can delete your snapshots using the Amazon EC2 console. For more information, see the <a
     * href="http://aws.amazon.com/storagegateway">Storage Gateway detail page</a>.
     * </p>
     * </important>
     *
     * @param deleteGatewayRequest
     *        A JSON object containing the ID of the gateway to delete.
     * @return Result of the DeleteGateway operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.DeleteGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DeleteGateway" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteGatewayResponse deleteGateway(DeleteGatewayRequest deleteGatewayRequest) throws InvalidGatewayRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, StorageGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a gateway. To specify which gateway to delete, use the Amazon Resource Name (ARN) of the gateway in your
     * request. The operation deletes the gateway; however, it does not delete the gateway virtual machine (VM) from
     * your host computer.
     * </p>
     * <p>
     * After you delete a gateway, you cannot reactivate it. Completed snapshots of the gateway volumes are not deleted
     * upon deleting the gateway, however, pending snapshots will not complete. After you delete a gateway, your next
     * step is to remove it from your environment.
     * </p>
     * <important>
     * <p>
     * You no longer pay software charges after the gateway is deleted; however, your existing Amazon EBS snapshots
     * persist and you will continue to be billed for these snapshots. You can choose to remove all remaining Amazon EBS
     * snapshots by canceling your Amazon EC2 subscription.  If you prefer not to cancel your Amazon EC2 subscription,
     * you can delete your snapshots using the Amazon EC2 console. For more information, see the <a
     * href="http://aws.amazon.com/storagegateway">Storage Gateway detail page</a>.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteGatewayRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteGatewayRequest#builder()}
     * </p>
     *
     * @param deleteGatewayRequest
     *        A {@link Consumer} that will call methods on {@link DeleteGatewayInput.Builder} to create a request. A
     *        JSON object containing the ID of the gateway to delete.
     * @return Result of the DeleteGateway operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.DeleteGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DeleteGateway" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteGatewayResponse deleteGateway(Consumer<DeleteGatewayRequest.Builder> deleteGatewayRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        return deleteGateway(DeleteGatewayRequest.builder().applyMutation(deleteGatewayRequest).build());
    }

    /**
     * <p>
     * Deletes a snapshot of a volume.
     * </p>
     * <p>
     * You can take snapshots of your gateway volumes on a scheduled or ad hoc basis. This API action enables you to
     * delete a snapshot schedule for a volume. For more information, see <a
     * href="https://docs.aws.amazon.com/storagegateway/latest/userguide/backing-up-volumes.html">Backing up your
     * volumes</a>. In the <code>DeleteSnapshotSchedule</code> request, you identify the volume by providing its Amazon
     * Resource Name (ARN). This operation is only supported for cached volume gateway types.
     * </p>
     * <note>
     * <p>
     * To list or delete a snapshot, you must use the Amazon EC2 API. For more information, go to <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeSnapshots.html">DescribeSnapshots</a> in
     * the <i>Amazon Elastic Compute Cloud API Reference</i>.
     * </p>
     * </note>
     *
     * @param deleteSnapshotScheduleRequest
     * @return Result of the DeleteSnapshotSchedule operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.DeleteSnapshotSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DeleteSnapshotSchedule"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteSnapshotScheduleResponse deleteSnapshotSchedule(DeleteSnapshotScheduleRequest deleteSnapshotScheduleRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a snapshot of a volume.
     * </p>
     * <p>
     * You can take snapshots of your gateway volumes on a scheduled or ad hoc basis. This API action enables you to
     * delete a snapshot schedule for a volume. For more information, see <a
     * href="https://docs.aws.amazon.com/storagegateway/latest/userguide/backing-up-volumes.html">Backing up your
     * volumes</a>. In the <code>DeleteSnapshotSchedule</code> request, you identify the volume by providing its Amazon
     * Resource Name (ARN). This operation is only supported for cached volume gateway types.
     * </p>
     * <note>
     * <p>
     * To list or delete a snapshot, you must use the Amazon EC2 API. For more information, go to <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeSnapshots.html">DescribeSnapshots</a> in
     * the <i>Amazon Elastic Compute Cloud API Reference</i>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSnapshotScheduleRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteSnapshotScheduleRequest#builder()}
     * </p>
     *
     * @param deleteSnapshotScheduleRequest
     *        A {@link Consumer} that will call methods on {@link DeleteSnapshotScheduleInput.Builder} to create a
     *        request.
     * @return Result of the DeleteSnapshotSchedule operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.DeleteSnapshotSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DeleteSnapshotSchedule"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteSnapshotScheduleResponse deleteSnapshotSchedule(
            Consumer<DeleteSnapshotScheduleRequest.Builder> deleteSnapshotScheduleRequest) throws InvalidGatewayRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, StorageGatewayException {
        return deleteSnapshotSchedule(DeleteSnapshotScheduleRequest.builder().applyMutation(deleteSnapshotScheduleRequest)
                .build());
    }

    /**
     * <p>
     * Deletes the specified virtual tape. This operation is only supported in the tape gateway type.
     * </p>
     *
     * @param deleteTapeRequest
     *        DeleteTapeInput
     * @return Result of the DeleteTape operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.DeleteTape
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DeleteTape" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteTapeResponse deleteTape(DeleteTapeRequest deleteTapeRequest) throws InvalidGatewayRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, StorageGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified virtual tape. This operation is only supported in the tape gateway type.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTapeRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteTapeRequest#builder()}
     * </p>
     *
     * @param deleteTapeRequest
     *        A {@link Consumer} that will call methods on {@link DeleteTapeInput.Builder} to create a request.
     *        DeleteTapeInput
     * @return Result of the DeleteTape operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.DeleteTape
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DeleteTape" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteTapeResponse deleteTape(Consumer<DeleteTapeRequest.Builder> deleteTapeRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        return deleteTape(DeleteTapeRequest.builder().applyMutation(deleteTapeRequest).build());
    }

    /**
     * <p>
     * Deletes the specified virtual tape from the virtual tape shelf (VTS). This operation is only supported in the
     * tape gateway type.
     * </p>
     *
     * @param deleteTapeArchiveRequest
     *        DeleteTapeArchiveInput
     * @return Result of the DeleteTapeArchive operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.DeleteTapeArchive
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DeleteTapeArchive"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteTapeArchiveResponse deleteTapeArchive(DeleteTapeArchiveRequest deleteTapeArchiveRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified virtual tape from the virtual tape shelf (VTS). This operation is only supported in the
     * tape gateway type.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTapeArchiveRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteTapeArchiveRequest#builder()}
     * </p>
     *
     * @param deleteTapeArchiveRequest
     *        A {@link Consumer} that will call methods on {@link DeleteTapeArchiveInput.Builder} to create a request.
     *        DeleteTapeArchiveInput
     * @return Result of the DeleteTapeArchive operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.DeleteTapeArchive
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DeleteTapeArchive"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteTapeArchiveResponse deleteTapeArchive(Consumer<DeleteTapeArchiveRequest.Builder> deleteTapeArchiveRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        return deleteTapeArchive(DeleteTapeArchiveRequest.builder().applyMutation(deleteTapeArchiveRequest).build());
    }

    /**
     * <p>
     * Delete a custom tape pool. A custom tape pool can only be deleted if there are no tapes in the pool and if there
     * are no automatic tape creation policies that reference the custom tape pool.
     * </p>
     *
     * @param deleteTapePoolRequest
     * @return Result of the DeleteTapePool operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.DeleteTapePool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DeleteTapePool" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteTapePoolResponse deleteTapePool(DeleteTapePoolRequest deleteTapePoolRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete a custom tape pool. A custom tape pool can only be deleted if there are no tapes in the pool and if there
     * are no automatic tape creation policies that reference the custom tape pool.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTapePoolRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteTapePoolRequest#builder()}
     * </p>
     *
     * @param deleteTapePoolRequest
     *        A {@link Consumer} that will call methods on {@link DeleteTapePoolInput.Builder} to create a request.
     * @return Result of the DeleteTapePool operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.DeleteTapePool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DeleteTapePool" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteTapePoolResponse deleteTapePool(Consumer<DeleteTapePoolRequest.Builder> deleteTapePoolRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        return deleteTapePool(DeleteTapePoolRequest.builder().applyMutation(deleteTapePoolRequest).build());
    }

    /**
     * <p>
     * Deletes the specified storage volume that you previously created using the <a>CreateCachediSCSIVolume</a> or
     * <a>CreateStorediSCSIVolume</a> API. This operation is only supported in the cached volume and stored volume
     * types. For stored volume gateways, the local disk that was configured as the storage volume is not deleted. You
     * can reuse the local disk to create another storage volume.
     * </p>
     * <p>
     * Before you delete a volume, make sure there are no iSCSI connections to the volume you are deleting. You should
     * also make sure there is no snapshot in progress. You can use the Amazon Elastic Compute Cloud (Amazon EC2) API to
     * query snapshots on the volume you are deleting and check the snapshot status. For more information, go to <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/ApiReference-query-DescribeSnapshots.html">
     * DescribeSnapshots</a> in the <i>Amazon Elastic Compute Cloud API Reference</i>.
     * </p>
     * <p>
     * In the request, you must provide the Amazon Resource Name (ARN) of the storage volume you want to delete.
     * </p>
     *
     * @param deleteVolumeRequest
     *        A JSON object containing the <a>DeleteVolumeInput&#36VolumeARN</a> to delete.
     * @return Result of the DeleteVolume operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.DeleteVolume
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DeleteVolume" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteVolumeResponse deleteVolume(DeleteVolumeRequest deleteVolumeRequest) throws InvalidGatewayRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, StorageGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified storage volume that you previously created using the <a>CreateCachediSCSIVolume</a> or
     * <a>CreateStorediSCSIVolume</a> API. This operation is only supported in the cached volume and stored volume
     * types. For stored volume gateways, the local disk that was configured as the storage volume is not deleted. You
     * can reuse the local disk to create another storage volume.
     * </p>
     * <p>
     * Before you delete a volume, make sure there are no iSCSI connections to the volume you are deleting. You should
     * also make sure there is no snapshot in progress. You can use the Amazon Elastic Compute Cloud (Amazon EC2) API to
     * query snapshots on the volume you are deleting and check the snapshot status. For more information, go to <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/ApiReference-query-DescribeSnapshots.html">
     * DescribeSnapshots</a> in the <i>Amazon Elastic Compute Cloud API Reference</i>.
     * </p>
     * <p>
     * In the request, you must provide the Amazon Resource Name (ARN) of the storage volume you want to delete.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteVolumeRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteVolumeRequest#builder()}
     * </p>
     *
     * @param deleteVolumeRequest
     *        A {@link Consumer} that will call methods on {@link DeleteVolumeInput.Builder} to create a request. A JSON
     *        object containing the <a>DeleteVolumeInput&#36VolumeARN</a> to delete.
     * @return Result of the DeleteVolume operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.DeleteVolume
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DeleteVolume" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteVolumeResponse deleteVolume(Consumer<DeleteVolumeRequest.Builder> deleteVolumeRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        return deleteVolume(DeleteVolumeRequest.builder().applyMutation(deleteVolumeRequest).build());
    }

    /**
     * <p>
     * Returns information about the most recent high availability monitoring test that was performed on the host in a
     * cluster. If a test isn't performed, the status and start time in the response would be null.
     * </p>
     *
     * @param describeAvailabilityMonitorTestRequest
     * @return Result of the DescribeAvailabilityMonitorTest operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.DescribeAvailabilityMonitorTest
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeAvailabilityMonitorTest"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAvailabilityMonitorTestResponse describeAvailabilityMonitorTest(
            DescribeAvailabilityMonitorTestRequest describeAvailabilityMonitorTestRequest) throws InvalidGatewayRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, StorageGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the most recent high availability monitoring test that was performed on the host in a
     * cluster. If a test isn't performed, the status and start time in the response would be null.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAvailabilityMonitorTestRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeAvailabilityMonitorTestRequest#builder()}
     * </p>
     *
     * @param describeAvailabilityMonitorTestRequest
     *        A {@link Consumer} that will call methods on {@link DescribeAvailabilityMonitorTestInput.Builder} to
     *        create a request.
     * @return Result of the DescribeAvailabilityMonitorTest operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.DescribeAvailabilityMonitorTest
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeAvailabilityMonitorTest"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAvailabilityMonitorTestResponse describeAvailabilityMonitorTest(
            Consumer<DescribeAvailabilityMonitorTestRequest.Builder> describeAvailabilityMonitorTestRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        return describeAvailabilityMonitorTest(DescribeAvailabilityMonitorTestRequest.builder()
                .applyMutation(describeAvailabilityMonitorTestRequest).build());
    }

    /**
     * <p>
     * Returns the bandwidth rate limits of a gateway. By default, these limits are not set, which means no bandwidth
     * rate limiting is in effect. This operation is supported only for the stored volume, cached volume, and tape
     * gateway types. To describe bandwidth rate limits for S3 file gateways, use
     * <a>DescribeBandwidthRateLimitSchedule</a>.
     * </p>
     * <p>
     * This operation returns a value for a bandwidth rate limit only if the limit is set. If no limits are set for the
     * gateway, then this operation returns only the gateway ARN in the response body. To specify which gateway to
     * describe, use the Amazon Resource Name (ARN) of the gateway in your request.
     * </p>
     *
     * @param describeBandwidthRateLimitRequest
     *        A JSON object containing the Amazon Resource Name (ARN) of the gateway.
     * @return Result of the DescribeBandwidthRateLimit operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.DescribeBandwidthRateLimit
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeBandwidthRateLimit"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeBandwidthRateLimitResponse describeBandwidthRateLimit(
            DescribeBandwidthRateLimitRequest describeBandwidthRateLimitRequest) throws InvalidGatewayRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, StorageGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the bandwidth rate limits of a gateway. By default, these limits are not set, which means no bandwidth
     * rate limiting is in effect. This operation is supported only for the stored volume, cached volume, and tape
     * gateway types. To describe bandwidth rate limits for S3 file gateways, use
     * <a>DescribeBandwidthRateLimitSchedule</a>.
     * </p>
     * <p>
     * This operation returns a value for a bandwidth rate limit only if the limit is set. If no limits are set for the
     * gateway, then this operation returns only the gateway ARN in the response body. To specify which gateway to
     * describe, use the Amazon Resource Name (ARN) of the gateway in your request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeBandwidthRateLimitRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeBandwidthRateLimitRequest#builder()}
     * </p>
     *
     * @param describeBandwidthRateLimitRequest
     *        A {@link Consumer} that will call methods on {@link DescribeBandwidthRateLimitInput.Builder} to create a
     *        request. A JSON object containing the Amazon Resource Name (ARN) of the gateway.
     * @return Result of the DescribeBandwidthRateLimit operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.DescribeBandwidthRateLimit
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeBandwidthRateLimit"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeBandwidthRateLimitResponse describeBandwidthRateLimit(
            Consumer<DescribeBandwidthRateLimitRequest.Builder> describeBandwidthRateLimitRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        return describeBandwidthRateLimit(DescribeBandwidthRateLimitRequest.builder()
                .applyMutation(describeBandwidthRateLimitRequest).build());
    }

    /**
     * <p>
     * Returns information about the bandwidth rate limit schedule of a gateway. By default, gateways do not have
     * bandwidth rate limit schedules, which means no bandwidth rate limiting is in effect. This operation is supported
     * only for volume, tape and S3 file gateways. FSx file gateways do not support bandwidth rate limits.
     * </p>
     * <p>
     * This operation returns information about a gateway's bandwidth rate limit schedule. A bandwidth rate limit
     * schedule consists of one or more bandwidth rate limit intervals. A bandwidth rate limit interval defines a period
     * of time on one or more days of the week, during which bandwidth rate limits are specified for uploading,
     * downloading, or both.
     * </p>
     * <p>
     * A bandwidth rate limit interval consists of one or more days of the week, a start hour and minute, an ending hour
     * and minute, and bandwidth rate limits for uploading and downloading
     * </p>
     * <p>
     * If no bandwidth rate limit schedule intervals are set for the gateway, this operation returns an empty response.
     * To specify which gateway to describe, use the Amazon Resource Name (ARN) of the gateway in your request.
     * </p>
     *
     * @param describeBandwidthRateLimitScheduleRequest
     * @return Result of the DescribeBandwidthRateLimitSchedule operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.DescribeBandwidthRateLimitSchedule
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeBandwidthRateLimitSchedule"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeBandwidthRateLimitScheduleResponse describeBandwidthRateLimitSchedule(
            DescribeBandwidthRateLimitScheduleRequest describeBandwidthRateLimitScheduleRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the bandwidth rate limit schedule of a gateway. By default, gateways do not have
     * bandwidth rate limit schedules, which means no bandwidth rate limiting is in effect. This operation is supported
     * only for volume, tape and S3 file gateways. FSx file gateways do not support bandwidth rate limits.
     * </p>
     * <p>
     * This operation returns information about a gateway's bandwidth rate limit schedule. A bandwidth rate limit
     * schedule consists of one or more bandwidth rate limit intervals. A bandwidth rate limit interval defines a period
     * of time on one or more days of the week, during which bandwidth rate limits are specified for uploading,
     * downloading, or both.
     * </p>
     * <p>
     * A bandwidth rate limit interval consists of one or more days of the week, a start hour and minute, an ending hour
     * and minute, and bandwidth rate limits for uploading and downloading
     * </p>
     * <p>
     * If no bandwidth rate limit schedule intervals are set for the gateway, this operation returns an empty response.
     * To specify which gateway to describe, use the Amazon Resource Name (ARN) of the gateway in your request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeBandwidthRateLimitScheduleRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeBandwidthRateLimitScheduleRequest#builder()}
     * </p>
     *
     * @param describeBandwidthRateLimitScheduleRequest
     *        A {@link Consumer} that will call methods on {@link DescribeBandwidthRateLimitScheduleInput.Builder} to
     *        create a request.
     * @return Result of the DescribeBandwidthRateLimitSchedule operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.DescribeBandwidthRateLimitSchedule
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeBandwidthRateLimitSchedule"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeBandwidthRateLimitScheduleResponse describeBandwidthRateLimitSchedule(
            Consumer<DescribeBandwidthRateLimitScheduleRequest.Builder> describeBandwidthRateLimitScheduleRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        return describeBandwidthRateLimitSchedule(DescribeBandwidthRateLimitScheduleRequest.builder()
                .applyMutation(describeBandwidthRateLimitScheduleRequest).build());
    }

    /**
     * <p>
     * Returns information about the cache of a gateway. This operation is only supported in the cached volume, tape,
     * and file gateway types.
     * </p>
     * <p>
     * The response includes disk IDs that are configured as cache, and it includes the amount of cache allocated and
     * used.
     * </p>
     *
     * @param describeCacheRequest
     * @return Result of the DescribeCache operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.DescribeCache
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeCache" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeCacheResponse describeCache(DescribeCacheRequest describeCacheRequest) throws InvalidGatewayRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, StorageGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the cache of a gateway. This operation is only supported in the cached volume, tape,
     * and file gateway types.
     * </p>
     * <p>
     * The response includes disk IDs that are configured as cache, and it includes the amount of cache allocated and
     * used.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeCacheRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeCacheRequest#builder()}
     * </p>
     *
     * @param describeCacheRequest
     *        A {@link Consumer} that will call methods on {@link DescribeCacheInput.Builder} to create a request.
     * @return Result of the DescribeCache operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.DescribeCache
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeCache" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeCacheResponse describeCache(Consumer<DescribeCacheRequest.Builder> describeCacheRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        return describeCache(DescribeCacheRequest.builder().applyMutation(describeCacheRequest).build());
    }

    /**
     * <p>
     * Returns a description of the gateway volumes specified in the request. This operation is only supported in the
     * cached volume gateway types.
     * </p>
     * <p>
     * The list of gateway volumes in the request must be from one gateway. In the response, Storage Gateway returns
     * volume information sorted by volume Amazon Resource Name (ARN).
     * </p>
     *
     * @param describeCachediScsiVolumesRequest
     * @return Result of the DescribeCachediSCSIVolumes operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.DescribeCachediSCSIVolumes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeCachediSCSIVolumes"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeCachediScsiVolumesResponse describeCachediSCSIVolumes(
            DescribeCachediScsiVolumesRequest describeCachediScsiVolumesRequest) throws InvalidGatewayRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, StorageGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a description of the gateway volumes specified in the request. This operation is only supported in the
     * cached volume gateway types.
     * </p>
     * <p>
     * The list of gateway volumes in the request must be from one gateway. In the response, Storage Gateway returns
     * volume information sorted by volume Amazon Resource Name (ARN).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeCachediScsiVolumesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeCachediScsiVolumesRequest#builder()}
     * </p>
     *
     * @param describeCachediScsiVolumesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeCachediSCSIVolumesInput.Builder} to create a
     *        request.
     * @return Result of the DescribeCachediSCSIVolumes operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.DescribeCachediSCSIVolumes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeCachediSCSIVolumes"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeCachediScsiVolumesResponse describeCachediSCSIVolumes(
            Consumer<DescribeCachediScsiVolumesRequest.Builder> describeCachediScsiVolumesRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        return describeCachediSCSIVolumes(DescribeCachediScsiVolumesRequest.builder()
                .applyMutation(describeCachediScsiVolumesRequest).build());
    }

    /**
     * <p>
     * Returns an array of Challenge-Handshake Authentication Protocol (CHAP) credentials information for a specified
     * iSCSI target, one for each target-initiator pair. This operation is supported in the volume and tape gateway
     * types.
     * </p>
     *
     * @param describeChapCredentialsRequest
     *        A JSON object containing the Amazon Resource Name (ARN) of the iSCSI volume target.
     * @return Result of the DescribeChapCredentials operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.DescribeChapCredentials
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeChapCredentials"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeChapCredentialsResponse describeChapCredentials(DescribeChapCredentialsRequest describeChapCredentialsRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns an array of Challenge-Handshake Authentication Protocol (CHAP) credentials information for a specified
     * iSCSI target, one for each target-initiator pair. This operation is supported in the volume and tape gateway
     * types.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeChapCredentialsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeChapCredentialsRequest#builder()}
     * </p>
     *
     * @param describeChapCredentialsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeChapCredentialsInput.Builder} to create a
     *        request. A JSON object containing the Amazon Resource Name (ARN) of the iSCSI volume target.
     * @return Result of the DescribeChapCredentials operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.DescribeChapCredentials
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeChapCredentials"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeChapCredentialsResponse describeChapCredentials(
            Consumer<DescribeChapCredentialsRequest.Builder> describeChapCredentialsRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        return describeChapCredentials(DescribeChapCredentialsRequest.builder().applyMutation(describeChapCredentialsRequest)
                .build());
    }

    /**
     * <p>
     * Gets the file system association information. This operation is only supported for FSx File Gateways.
     * </p>
     *
     * @param describeFileSystemAssociationsRequest
     * @return Result of the DescribeFileSystemAssociations operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.DescribeFileSystemAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeFileSystemAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeFileSystemAssociationsResponse describeFileSystemAssociations(
            DescribeFileSystemAssociationsRequest describeFileSystemAssociationsRequest) throws InvalidGatewayRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, StorageGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the file system association information. This operation is only supported for FSx File Gateways.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeFileSystemAssociationsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeFileSystemAssociationsRequest#builder()}
     * </p>
     *
     * @param describeFileSystemAssociationsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeFileSystemAssociationsInput.Builder} to create
     *        a request.
     * @return Result of the DescribeFileSystemAssociations operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.DescribeFileSystemAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeFileSystemAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeFileSystemAssociationsResponse describeFileSystemAssociations(
            Consumer<DescribeFileSystemAssociationsRequest.Builder> describeFileSystemAssociationsRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        return describeFileSystemAssociations(DescribeFileSystemAssociationsRequest.builder()
                .applyMutation(describeFileSystemAssociationsRequest).build());
    }

    /**
     * <p>
     * Returns metadata about a gateway such as its name, network interfaces, configured time zone, and the state
     * (whether the gateway is running or not). To specify which gateway to describe, use the Amazon Resource Name (ARN)
     * of the gateway in your request.
     * </p>
     *
     * @param describeGatewayInformationRequest
     *        A JSON object containing the ID of the gateway.
     * @return Result of the DescribeGatewayInformation operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.DescribeGatewayInformation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeGatewayInformation"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeGatewayInformationResponse describeGatewayInformation(
            DescribeGatewayInformationRequest describeGatewayInformationRequest) throws InvalidGatewayRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, StorageGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns metadata about a gateway such as its name, network interfaces, configured time zone, and the state
     * (whether the gateway is running or not). To specify which gateway to describe, use the Amazon Resource Name (ARN)
     * of the gateway in your request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeGatewayInformationRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeGatewayInformationRequest#builder()}
     * </p>
     *
     * @param describeGatewayInformationRequest
     *        A {@link Consumer} that will call methods on {@link DescribeGatewayInformationInput.Builder} to create a
     *        request. A JSON object containing the ID of the gateway.
     * @return Result of the DescribeGatewayInformation operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.DescribeGatewayInformation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeGatewayInformation"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeGatewayInformationResponse describeGatewayInformation(
            Consumer<DescribeGatewayInformationRequest.Builder> describeGatewayInformationRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        return describeGatewayInformation(DescribeGatewayInformationRequest.builder()
                .applyMutation(describeGatewayInformationRequest).build());
    }

    /**
     * <p>
     * Returns your gateway's weekly maintenance start time including the day and time of the week. Note that values are
     * in terms of the gateway's time zone.
     * </p>
     *
     * @param describeMaintenanceStartTimeRequest
     *        A JSON object containing the Amazon Resource Name (ARN) of the gateway.
     * @return Result of the DescribeMaintenanceStartTime operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.DescribeMaintenanceStartTime
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeMaintenanceStartTime"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMaintenanceStartTimeResponse describeMaintenanceStartTime(
            DescribeMaintenanceStartTimeRequest describeMaintenanceStartTimeRequest) throws InvalidGatewayRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, StorageGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns your gateway's weekly maintenance start time including the day and time of the week. Note that values are
     * in terms of the gateway's time zone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeMaintenanceStartTimeRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeMaintenanceStartTimeRequest#builder()}
     * </p>
     *
     * @param describeMaintenanceStartTimeRequest
     *        A {@link Consumer} that will call methods on {@link DescribeMaintenanceStartTimeInput.Builder} to create a
     *        request. A JSON object containing the Amazon Resource Name (ARN) of the gateway.
     * @return Result of the DescribeMaintenanceStartTime operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.DescribeMaintenanceStartTime
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeMaintenanceStartTime"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMaintenanceStartTimeResponse describeMaintenanceStartTime(
            Consumer<DescribeMaintenanceStartTimeRequest.Builder> describeMaintenanceStartTimeRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        return describeMaintenanceStartTime(DescribeMaintenanceStartTimeRequest.builder()
                .applyMutation(describeMaintenanceStartTimeRequest).build());
    }

    /**
     * <p>
     * Gets a description for one or more Network File System (NFS) file shares from an S3 File Gateway. This operation
     * is only supported for S3 File Gateways.
     * </p>
     *
     * @param describeNfsFileSharesRequest
     *        DescribeNFSFileSharesInput
     * @return Result of the DescribeNFSFileShares operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.DescribeNFSFileShares
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeNFSFileShares"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeNfsFileSharesResponse describeNFSFileShares(DescribeNfsFileSharesRequest describeNfsFileSharesRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a description for one or more Network File System (NFS) file shares from an S3 File Gateway. This operation
     * is only supported for S3 File Gateways.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeNfsFileSharesRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeNfsFileSharesRequest#builder()}
     * </p>
     *
     * @param describeNfsFileSharesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeNFSFileSharesInput.Builder} to create a
     *        request. DescribeNFSFileSharesInput
     * @return Result of the DescribeNFSFileShares operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.DescribeNFSFileShares
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeNFSFileShares"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeNfsFileSharesResponse describeNFSFileShares(
            Consumer<DescribeNfsFileSharesRequest.Builder> describeNfsFileSharesRequest) throws InvalidGatewayRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, StorageGatewayException {
        return describeNFSFileShares(DescribeNfsFileSharesRequest.builder().applyMutation(describeNfsFileSharesRequest).build());
    }

    /**
     * <p>
     * Gets a description for one or more Server Message Block (SMB) file shares from a S3 File Gateway. This operation
     * is only supported for S3 File Gateways.
     * </p>
     *
     * @param describeSmbFileSharesRequest
     *        DescribeSMBFileSharesInput
     * @return Result of the DescribeSMBFileShares operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.DescribeSMBFileShares
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeSMBFileShares"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeSmbFileSharesResponse describeSMBFileShares(DescribeSmbFileSharesRequest describeSmbFileSharesRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a description for one or more Server Message Block (SMB) file shares from a S3 File Gateway. This operation
     * is only supported for S3 File Gateways.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSmbFileSharesRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeSmbFileSharesRequest#builder()}
     * </p>
     *
     * @param describeSmbFileSharesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeSMBFileSharesInput.Builder} to create a
     *        request. DescribeSMBFileSharesInput
     * @return Result of the DescribeSMBFileShares operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.DescribeSMBFileShares
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeSMBFileShares"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeSmbFileSharesResponse describeSMBFileShares(
            Consumer<DescribeSmbFileSharesRequest.Builder> describeSmbFileSharesRequest) throws InvalidGatewayRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, StorageGatewayException {
        return describeSMBFileShares(DescribeSmbFileSharesRequest.builder().applyMutation(describeSmbFileSharesRequest).build());
    }

    /**
     * <p>
     * Gets a description of a Server Message Block (SMB) file share settings from a file gateway. This operation is
     * only supported for file gateways.
     * </p>
     *
     * @param describeSmbSettingsRequest
     * @return Result of the DescribeSMBSettings operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.DescribeSMBSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeSMBSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeSmbSettingsResponse describeSMBSettings(DescribeSmbSettingsRequest describeSmbSettingsRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a description of a Server Message Block (SMB) file share settings from a file gateway. This operation is
     * only supported for file gateways.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSmbSettingsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeSmbSettingsRequest#builder()}
     * </p>
     *
     * @param describeSmbSettingsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeSMBSettingsInput.Builder} to create a request.
     * @return Result of the DescribeSMBSettings operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.DescribeSMBSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeSMBSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeSmbSettingsResponse describeSMBSettings(
            Consumer<DescribeSmbSettingsRequest.Builder> describeSmbSettingsRequest) throws InvalidGatewayRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, StorageGatewayException {
        return describeSMBSettings(DescribeSmbSettingsRequest.builder().applyMutation(describeSmbSettingsRequest).build());
    }

    /**
     * <p>
     * Describes the snapshot schedule for the specified gateway volume. The snapshot schedule information includes
     * intervals at which snapshots are automatically initiated on the volume. This operation is only supported in the
     * cached volume and stored volume types.
     * </p>
     *
     * @param describeSnapshotScheduleRequest
     *        A JSON object containing the <a>DescribeSnapshotScheduleInput&#36VolumeARN</a> of the volume.
     * @return Result of the DescribeSnapshotSchedule operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.DescribeSnapshotSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeSnapshotSchedule"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeSnapshotScheduleResponse describeSnapshotSchedule(
            DescribeSnapshotScheduleRequest describeSnapshotScheduleRequest) throws InvalidGatewayRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, StorageGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the snapshot schedule for the specified gateway volume. The snapshot schedule information includes
     * intervals at which snapshots are automatically initiated on the volume. This operation is only supported in the
     * cached volume and stored volume types.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSnapshotScheduleRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeSnapshotScheduleRequest#builder()}
     * </p>
     *
     * @param describeSnapshotScheduleRequest
     *        A {@link Consumer} that will call methods on {@link DescribeSnapshotScheduleInput.Builder} to create a
     *        request. A JSON object containing the <a>DescribeSnapshotScheduleInput&#36VolumeARN</a> of the volume.
     * @return Result of the DescribeSnapshotSchedule operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.DescribeSnapshotSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeSnapshotSchedule"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeSnapshotScheduleResponse describeSnapshotSchedule(
            Consumer<DescribeSnapshotScheduleRequest.Builder> describeSnapshotScheduleRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        return describeSnapshotSchedule(DescribeSnapshotScheduleRequest.builder().applyMutation(describeSnapshotScheduleRequest)
                .build());
    }

    /**
     * <p>
     * Returns the description of the gateway volumes specified in the request. The list of gateway volumes in the
     * request must be from one gateway. In the response, Storage Gateway returns volume information sorted by volume
     * ARNs. This operation is only supported in stored volume gateway type.
     * </p>
     *
     * @param describeStorediScsiVolumesRequest
     *        A JSON object containing a list of <a>DescribeStorediSCSIVolumesInput&#36VolumeARNs</a>.
     * @return Result of the DescribeStorediSCSIVolumes operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.DescribeStorediSCSIVolumes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeStorediSCSIVolumes"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeStorediScsiVolumesResponse describeStorediSCSIVolumes(
            DescribeStorediScsiVolumesRequest describeStorediScsiVolumesRequest) throws InvalidGatewayRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, StorageGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the description of the gateway volumes specified in the request. The list of gateway volumes in the
     * request must be from one gateway. In the response, Storage Gateway returns volume information sorted by volume
     * ARNs. This operation is only supported in stored volume gateway type.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeStorediScsiVolumesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeStorediScsiVolumesRequest#builder()}
     * </p>
     *
     * @param describeStorediScsiVolumesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeStorediSCSIVolumesInput.Builder} to create a
     *        request. A JSON object containing a list of <a>DescribeStorediSCSIVolumesInput&#36VolumeARNs</a>.
     * @return Result of the DescribeStorediSCSIVolumes operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.DescribeStorediSCSIVolumes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeStorediSCSIVolumes"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeStorediScsiVolumesResponse describeStorediSCSIVolumes(
            Consumer<DescribeStorediScsiVolumesRequest.Builder> describeStorediScsiVolumesRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        return describeStorediSCSIVolumes(DescribeStorediScsiVolumesRequest.builder()
                .applyMutation(describeStorediScsiVolumesRequest).build());
    }

    /**
     * <p>
     * Returns a description of specified virtual tapes in the virtual tape shelf (VTS). This operation is only
     * supported in the tape gateway type.
     * </p>
     * <p>
     * If a specific <code>TapeARN</code> is not specified, Storage Gateway returns a description of all virtual tapes
     * found in the VTS associated with your account.
     * </p>
     *
     * @return Result of the DescribeTapeArchives operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.DescribeTapeArchives
     * @see #describeTapeArchives(DescribeTapeArchivesRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeTapeArchives"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeTapeArchivesResponse describeTapeArchives() throws InvalidGatewayRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, StorageGatewayException {
        return describeTapeArchives(DescribeTapeArchivesRequest.builder().build());
    }

    /**
     * <p>
     * Returns a description of specified virtual tapes in the virtual tape shelf (VTS). This operation is only
     * supported in the tape gateway type.
     * </p>
     * <p>
     * If a specific <code>TapeARN</code> is not specified, Storage Gateway returns a description of all virtual tapes
     * found in the VTS associated with your account.
     * </p>
     *
     * @param describeTapeArchivesRequest
     *        DescribeTapeArchivesInput
     * @return Result of the DescribeTapeArchives operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.DescribeTapeArchives
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeTapeArchives"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeTapeArchivesResponse describeTapeArchives(DescribeTapeArchivesRequest describeTapeArchivesRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a description of specified virtual tapes in the virtual tape shelf (VTS). This operation is only
     * supported in the tape gateway type.
     * </p>
     * <p>
     * If a specific <code>TapeARN</code> is not specified, Storage Gateway returns a description of all virtual tapes
     * found in the VTS associated with your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTapeArchivesRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeTapeArchivesRequest#builder()}
     * </p>
     *
     * @param describeTapeArchivesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeTapeArchivesInput.Builder} to create a
     *        request. DescribeTapeArchivesInput
     * @return Result of the DescribeTapeArchives operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.DescribeTapeArchives
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeTapeArchives"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeTapeArchivesResponse describeTapeArchives(
            Consumer<DescribeTapeArchivesRequest.Builder> describeTapeArchivesRequest) throws InvalidGatewayRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, StorageGatewayException {
        return describeTapeArchives(DescribeTapeArchivesRequest.builder().applyMutation(describeTapeArchivesRequest).build());
    }

    /**
     * <p>
     * Returns a description of specified virtual tapes in the virtual tape shelf (VTS). This operation is only
     * supported in the tape gateway type.
     * </p>
     * <p>
     * If a specific <code>TapeARN</code> is not specified, Storage Gateway returns a description of all virtual tapes
     * found in the VTS associated with your account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeTapeArchives(software.amazon.awssdk.services.storagegateway.model.DescribeTapeArchivesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.storagegateway.paginators.DescribeTapeArchivesIterable responses = client.describeTapeArchivesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.storagegateway.paginators.DescribeTapeArchivesIterable responses = client
     *             .describeTapeArchivesPaginator(request);
     *     for (software.amazon.awssdk.services.storagegateway.model.DescribeTapeArchivesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.storagegateway.paginators.DescribeTapeArchivesIterable responses = client.describeTapeArchivesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeTapeArchives(software.amazon.awssdk.services.storagegateway.model.DescribeTapeArchivesRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.DescribeTapeArchives
     * @see #describeTapeArchivesPaginator(DescribeTapeArchivesRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeTapeArchives"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeTapeArchivesIterable describeTapeArchivesPaginator() throws InvalidGatewayRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, StorageGatewayException {
        return describeTapeArchivesPaginator(DescribeTapeArchivesRequest.builder().build());
    }

    /**
     * <p>
     * Returns a description of specified virtual tapes in the virtual tape shelf (VTS). This operation is only
     * supported in the tape gateway type.
     * </p>
     * <p>
     * If a specific <code>TapeARN</code> is not specified, Storage Gateway returns a description of all virtual tapes
     * found in the VTS associated with your account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeTapeArchives(software.amazon.awssdk.services.storagegateway.model.DescribeTapeArchivesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.storagegateway.paginators.DescribeTapeArchivesIterable responses = client.describeTapeArchivesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.storagegateway.paginators.DescribeTapeArchivesIterable responses = client
     *             .describeTapeArchivesPaginator(request);
     *     for (software.amazon.awssdk.services.storagegateway.model.DescribeTapeArchivesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.storagegateway.paginators.DescribeTapeArchivesIterable responses = client.describeTapeArchivesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeTapeArchives(software.amazon.awssdk.services.storagegateway.model.DescribeTapeArchivesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeTapeArchivesRequest
     *        DescribeTapeArchivesInput
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.DescribeTapeArchives
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeTapeArchives"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeTapeArchivesIterable describeTapeArchivesPaginator(DescribeTapeArchivesRequest describeTapeArchivesRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a description of specified virtual tapes in the virtual tape shelf (VTS). This operation is only
     * supported in the tape gateway type.
     * </p>
     * <p>
     * If a specific <code>TapeARN</code> is not specified, Storage Gateway returns a description of all virtual tapes
     * found in the VTS associated with your account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeTapeArchives(software.amazon.awssdk.services.storagegateway.model.DescribeTapeArchivesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.storagegateway.paginators.DescribeTapeArchivesIterable responses = client.describeTapeArchivesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.storagegateway.paginators.DescribeTapeArchivesIterable responses = client
     *             .describeTapeArchivesPaginator(request);
     *     for (software.amazon.awssdk.services.storagegateway.model.DescribeTapeArchivesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.storagegateway.paginators.DescribeTapeArchivesIterable responses = client.describeTapeArchivesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeTapeArchives(software.amazon.awssdk.services.storagegateway.model.DescribeTapeArchivesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTapeArchivesRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeTapeArchivesRequest#builder()}
     * </p>
     *
     * @param describeTapeArchivesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeTapeArchivesInput.Builder} to create a
     *        request. DescribeTapeArchivesInput
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.DescribeTapeArchives
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeTapeArchives"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeTapeArchivesIterable describeTapeArchivesPaginator(
            Consumer<DescribeTapeArchivesRequest.Builder> describeTapeArchivesRequest) throws InvalidGatewayRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, StorageGatewayException {
        return describeTapeArchivesPaginator(DescribeTapeArchivesRequest.builder().applyMutation(describeTapeArchivesRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of virtual tape recovery points that are available for the specified tape gateway.
     * </p>
     * <p>
     * A recovery point is a point-in-time view of a virtual tape at which all the data on the virtual tape is
     * consistent. If your gateway crashes, virtual tapes that have recovery points can be recovered to a new gateway.
     * This operation is only supported in the tape gateway type.
     * </p>
     *
     * @param describeTapeRecoveryPointsRequest
     *        DescribeTapeRecoveryPointsInput
     * @return Result of the DescribeTapeRecoveryPoints operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.DescribeTapeRecoveryPoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeTapeRecoveryPoints"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeTapeRecoveryPointsResponse describeTapeRecoveryPoints(
            DescribeTapeRecoveryPointsRequest describeTapeRecoveryPointsRequest) throws InvalidGatewayRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, StorageGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of virtual tape recovery points that are available for the specified tape gateway.
     * </p>
     * <p>
     * A recovery point is a point-in-time view of a virtual tape at which all the data on the virtual tape is
     * consistent. If your gateway crashes, virtual tapes that have recovery points can be recovered to a new gateway.
     * This operation is only supported in the tape gateway type.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTapeRecoveryPointsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeTapeRecoveryPointsRequest#builder()}
     * </p>
     *
     * @param describeTapeRecoveryPointsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeTapeRecoveryPointsInput.Builder} to create a
     *        request. DescribeTapeRecoveryPointsInput
     * @return Result of the DescribeTapeRecoveryPoints operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.DescribeTapeRecoveryPoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeTapeRecoveryPoints"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeTapeRecoveryPointsResponse describeTapeRecoveryPoints(
            Consumer<DescribeTapeRecoveryPointsRequest.Builder> describeTapeRecoveryPointsRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        return describeTapeRecoveryPoints(DescribeTapeRecoveryPointsRequest.builder()
                .applyMutation(describeTapeRecoveryPointsRequest).build());
    }

    /**
     * <p>
     * Returns a list of virtual tape recovery points that are available for the specified tape gateway.
     * </p>
     * <p>
     * A recovery point is a point-in-time view of a virtual tape at which all the data on the virtual tape is
     * consistent. If your gateway crashes, virtual tapes that have recovery points can be recovered to a new gateway.
     * This operation is only supported in the tape gateway type.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeTapeRecoveryPoints(software.amazon.awssdk.services.storagegateway.model.DescribeTapeRecoveryPointsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.storagegateway.paginators.DescribeTapeRecoveryPointsIterable responses = client.describeTapeRecoveryPointsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.storagegateway.paginators.DescribeTapeRecoveryPointsIterable responses = client
     *             .describeTapeRecoveryPointsPaginator(request);
     *     for (software.amazon.awssdk.services.storagegateway.model.DescribeTapeRecoveryPointsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.storagegateway.paginators.DescribeTapeRecoveryPointsIterable responses = client.describeTapeRecoveryPointsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeTapeRecoveryPoints(software.amazon.awssdk.services.storagegateway.model.DescribeTapeRecoveryPointsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeTapeRecoveryPointsRequest
     *        DescribeTapeRecoveryPointsInput
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.DescribeTapeRecoveryPoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeTapeRecoveryPoints"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeTapeRecoveryPointsIterable describeTapeRecoveryPointsPaginator(
            DescribeTapeRecoveryPointsRequest describeTapeRecoveryPointsRequest) throws InvalidGatewayRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, StorageGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of virtual tape recovery points that are available for the specified tape gateway.
     * </p>
     * <p>
     * A recovery point is a point-in-time view of a virtual tape at which all the data on the virtual tape is
     * consistent. If your gateway crashes, virtual tapes that have recovery points can be recovered to a new gateway.
     * This operation is only supported in the tape gateway type.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeTapeRecoveryPoints(software.amazon.awssdk.services.storagegateway.model.DescribeTapeRecoveryPointsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.storagegateway.paginators.DescribeTapeRecoveryPointsIterable responses = client.describeTapeRecoveryPointsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.storagegateway.paginators.DescribeTapeRecoveryPointsIterable responses = client
     *             .describeTapeRecoveryPointsPaginator(request);
     *     for (software.amazon.awssdk.services.storagegateway.model.DescribeTapeRecoveryPointsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.storagegateway.paginators.DescribeTapeRecoveryPointsIterable responses = client.describeTapeRecoveryPointsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeTapeRecoveryPoints(software.amazon.awssdk.services.storagegateway.model.DescribeTapeRecoveryPointsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTapeRecoveryPointsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeTapeRecoveryPointsRequest#builder()}
     * </p>
     *
     * @param describeTapeRecoveryPointsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeTapeRecoveryPointsInput.Builder} to create a
     *        request. DescribeTapeRecoveryPointsInput
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.DescribeTapeRecoveryPoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeTapeRecoveryPoints"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeTapeRecoveryPointsIterable describeTapeRecoveryPointsPaginator(
            Consumer<DescribeTapeRecoveryPointsRequest.Builder> describeTapeRecoveryPointsRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        return describeTapeRecoveryPointsPaginator(DescribeTapeRecoveryPointsRequest.builder()
                .applyMutation(describeTapeRecoveryPointsRequest).build());
    }

    /**
     * <p>
     * Returns a description of the specified Amazon Resource Name (ARN) of virtual tapes. If a <code>TapeARN</code> is
     * not specified, returns a description of all virtual tapes associated with the specified gateway. This operation
     * is only supported in the tape gateway type.
     * </p>
     *
     * @param describeTapesRequest
     *        DescribeTapesInput
     * @return Result of the DescribeTapes operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.DescribeTapes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeTapes" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeTapesResponse describeTapes(DescribeTapesRequest describeTapesRequest) throws InvalidGatewayRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, StorageGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a description of the specified Amazon Resource Name (ARN) of virtual tapes. If a <code>TapeARN</code> is
     * not specified, returns a description of all virtual tapes associated with the specified gateway. This operation
     * is only supported in the tape gateway type.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTapesRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeTapesRequest#builder()}
     * </p>
     *
     * @param describeTapesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeTapesInput.Builder} to create a request.
     *        DescribeTapesInput
     * @return Result of the DescribeTapes operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.DescribeTapes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeTapes" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeTapesResponse describeTapes(Consumer<DescribeTapesRequest.Builder> describeTapesRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        return describeTapes(DescribeTapesRequest.builder().applyMutation(describeTapesRequest).build());
    }

    /**
     * <p>
     * Returns a description of the specified Amazon Resource Name (ARN) of virtual tapes. If a <code>TapeARN</code> is
     * not specified, returns a description of all virtual tapes associated with the specified gateway. This operation
     * is only supported in the tape gateway type.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeTapes(software.amazon.awssdk.services.storagegateway.model.DescribeTapesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.storagegateway.paginators.DescribeTapesIterable responses = client.describeTapesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.storagegateway.paginators.DescribeTapesIterable responses = client
     *             .describeTapesPaginator(request);
     *     for (software.amazon.awssdk.services.storagegateway.model.DescribeTapesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.storagegateway.paginators.DescribeTapesIterable responses = client.describeTapesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeTapes(software.amazon.awssdk.services.storagegateway.model.DescribeTapesRequest)} operation.</b>
     * </p>
     *
     * @param describeTapesRequest
     *        DescribeTapesInput
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.DescribeTapes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeTapes" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeTapesIterable describeTapesPaginator(DescribeTapesRequest describeTapesRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a description of the specified Amazon Resource Name (ARN) of virtual tapes. If a <code>TapeARN</code> is
     * not specified, returns a description of all virtual tapes associated with the specified gateway. This operation
     * is only supported in the tape gateway type.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeTapes(software.amazon.awssdk.services.storagegateway.model.DescribeTapesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.storagegateway.paginators.DescribeTapesIterable responses = client.describeTapesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.storagegateway.paginators.DescribeTapesIterable responses = client
     *             .describeTapesPaginator(request);
     *     for (software.amazon.awssdk.services.storagegateway.model.DescribeTapesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.storagegateway.paginators.DescribeTapesIterable responses = client.describeTapesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeTapes(software.amazon.awssdk.services.storagegateway.model.DescribeTapesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTapesRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeTapesRequest#builder()}
     * </p>
     *
     * @param describeTapesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeTapesInput.Builder} to create a request.
     *        DescribeTapesInput
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.DescribeTapes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeTapes" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeTapesIterable describeTapesPaginator(Consumer<DescribeTapesRequest.Builder> describeTapesRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        return describeTapesPaginator(DescribeTapesRequest.builder().applyMutation(describeTapesRequest).build());
    }

    /**
     * <p>
     * Returns information about the upload buffer of a gateway. This operation is supported for the stored volume,
     * cached volume, and tape gateway types.
     * </p>
     * <p>
     * The response includes disk IDs that are configured as upload buffer space, and it includes the amount of upload
     * buffer space allocated and used.
     * </p>
     *
     * @param describeUploadBufferRequest
     * @return Result of the DescribeUploadBuffer operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.DescribeUploadBuffer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeUploadBuffer"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeUploadBufferResponse describeUploadBuffer(DescribeUploadBufferRequest describeUploadBufferRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the upload buffer of a gateway. This operation is supported for the stored volume,
     * cached volume, and tape gateway types.
     * </p>
     * <p>
     * The response includes disk IDs that are configured as upload buffer space, and it includes the amount of upload
     * buffer space allocated and used.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeUploadBufferRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeUploadBufferRequest#builder()}
     * </p>
     *
     * @param describeUploadBufferRequest
     *        A {@link Consumer} that will call methods on {@link DescribeUploadBufferInput.Builder} to create a
     *        request.
     * @return Result of the DescribeUploadBuffer operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.DescribeUploadBuffer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeUploadBuffer"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeUploadBufferResponse describeUploadBuffer(
            Consumer<DescribeUploadBufferRequest.Builder> describeUploadBufferRequest) throws InvalidGatewayRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, StorageGatewayException {
        return describeUploadBuffer(DescribeUploadBufferRequest.builder().applyMutation(describeUploadBufferRequest).build());
    }

    /**
     * <p>
     * Returns a description of virtual tape library (VTL) devices for the specified tape gateway. In the response,
     * Storage Gateway returns VTL device information.
     * </p>
     * <p>
     * This operation is only supported in the tape gateway type.
     * </p>
     *
     * @param describeVtlDevicesRequest
     *        DescribeVTLDevicesInput
     * @return Result of the DescribeVTLDevices operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.DescribeVTLDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeVTLDevices"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeVtlDevicesResponse describeVTLDevices(DescribeVtlDevicesRequest describeVtlDevicesRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a description of virtual tape library (VTL) devices for the specified tape gateway. In the response,
     * Storage Gateway returns VTL device information.
     * </p>
     * <p>
     * This operation is only supported in the tape gateway type.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeVtlDevicesRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeVtlDevicesRequest#builder()}
     * </p>
     *
     * @param describeVtlDevicesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeVTLDevicesInput.Builder} to create a request.
     *        DescribeVTLDevicesInput
     * @return Result of the DescribeVTLDevices operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.DescribeVTLDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeVTLDevices"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeVtlDevicesResponse describeVTLDevices(Consumer<DescribeVtlDevicesRequest.Builder> describeVtlDevicesRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        return describeVTLDevices(DescribeVtlDevicesRequest.builder().applyMutation(describeVtlDevicesRequest).build());
    }

    /**
     * <p>
     * Returns a description of virtual tape library (VTL) devices for the specified tape gateway. In the response,
     * Storage Gateway returns VTL device information.
     * </p>
     * <p>
     * This operation is only supported in the tape gateway type.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeVTLDevices(software.amazon.awssdk.services.storagegateway.model.DescribeVtlDevicesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.storagegateway.paginators.DescribeVTLDevicesIterable responses = client.describeVTLDevicesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.storagegateway.paginators.DescribeVTLDevicesIterable responses = client
     *             .describeVTLDevicesPaginator(request);
     *     for (software.amazon.awssdk.services.storagegateway.model.DescribeVtlDevicesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.storagegateway.paginators.DescribeVTLDevicesIterable responses = client.describeVTLDevicesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeVTLDevices(software.amazon.awssdk.services.storagegateway.model.DescribeVtlDevicesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeVtlDevicesRequest
     *        DescribeVTLDevicesInput
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.DescribeVTLDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeVTLDevices"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeVTLDevicesIterable describeVTLDevicesPaginator(DescribeVtlDevicesRequest describeVtlDevicesRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a description of virtual tape library (VTL) devices for the specified tape gateway. In the response,
     * Storage Gateway returns VTL device information.
     * </p>
     * <p>
     * This operation is only supported in the tape gateway type.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeVTLDevices(software.amazon.awssdk.services.storagegateway.model.DescribeVtlDevicesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.storagegateway.paginators.DescribeVTLDevicesIterable responses = client.describeVTLDevicesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.storagegateway.paginators.DescribeVTLDevicesIterable responses = client
     *             .describeVTLDevicesPaginator(request);
     *     for (software.amazon.awssdk.services.storagegateway.model.DescribeVtlDevicesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.storagegateway.paginators.DescribeVTLDevicesIterable responses = client.describeVTLDevicesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeVTLDevices(software.amazon.awssdk.services.storagegateway.model.DescribeVtlDevicesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeVtlDevicesRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeVtlDevicesRequest#builder()}
     * </p>
     *
     * @param describeVtlDevicesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeVTLDevicesInput.Builder} to create a request.
     *        DescribeVTLDevicesInput
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.DescribeVTLDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeVTLDevices"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeVTLDevicesIterable describeVTLDevicesPaginator(
            Consumer<DescribeVtlDevicesRequest.Builder> describeVtlDevicesRequest) throws InvalidGatewayRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, StorageGatewayException {
        return describeVTLDevicesPaginator(DescribeVtlDevicesRequest.builder().applyMutation(describeVtlDevicesRequest).build());
    }

    /**
     * <p>
     * Returns information about the working storage of a gateway. This operation is only supported in the stored
     * volumes gateway type. This operation is deprecated in cached volumes API version (20120630). Use
     * DescribeUploadBuffer instead.
     * </p>
     * <note>
     * <p>
     * Working storage is also referred to as upload buffer. You can also use the DescribeUploadBuffer operation to add
     * upload buffer to a stored volume gateway.
     * </p>
     * </note>
     * <p>
     * The response includes disk IDs that are configured as working storage, and it includes the amount of working
     * storage allocated and used.
     * </p>
     *
     * @param describeWorkingStorageRequest
     *        A JSON object containing the Amazon Resource Name (ARN) of the gateway.
     * @return Result of the DescribeWorkingStorage operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.DescribeWorkingStorage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeWorkingStorage"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeWorkingStorageResponse describeWorkingStorage(DescribeWorkingStorageRequest describeWorkingStorageRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the working storage of a gateway. This operation is only supported in the stored
     * volumes gateway type. This operation is deprecated in cached volumes API version (20120630). Use
     * DescribeUploadBuffer instead.
     * </p>
     * <note>
     * <p>
     * Working storage is also referred to as upload buffer. You can also use the DescribeUploadBuffer operation to add
     * upload buffer to a stored volume gateway.
     * </p>
     * </note>
     * <p>
     * The response includes disk IDs that are configured as working storage, and it includes the amount of working
     * storage allocated and used.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeWorkingStorageRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeWorkingStorageRequest#builder()}
     * </p>
     *
     * @param describeWorkingStorageRequest
     *        A {@link Consumer} that will call methods on {@link DescribeWorkingStorageInput.Builder} to create a
     *        request. A JSON object containing the Amazon Resource Name (ARN) of the gateway.
     * @return Result of the DescribeWorkingStorage operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.DescribeWorkingStorage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeWorkingStorage"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeWorkingStorageResponse describeWorkingStorage(
            Consumer<DescribeWorkingStorageRequest.Builder> describeWorkingStorageRequest) throws InvalidGatewayRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, StorageGatewayException {
        return describeWorkingStorage(DescribeWorkingStorageRequest.builder().applyMutation(describeWorkingStorageRequest)
                .build());
    }

    /**
     * <p>
     * Disconnects a volume from an iSCSI connection and then detaches the volume from the specified gateway. Detaching
     * and attaching a volume enables you to recover your data from one gateway to a different gateway without creating
     * a snapshot. It also makes it easier to move your volumes from an on-premises gateway to a gateway hosted on an
     * Amazon EC2 instance. This operation is only supported in the volume gateway type.
     * </p>
     *
     * @param detachVolumeRequest
     *        AttachVolumeInput
     * @return Result of the DetachVolume operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.DetachVolume
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DetachVolume" target="_top">AWS
     *      API Documentation</a>
     */
    default DetachVolumeResponse detachVolume(DetachVolumeRequest detachVolumeRequest) throws InvalidGatewayRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, StorageGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disconnects a volume from an iSCSI connection and then detaches the volume from the specified gateway. Detaching
     * and attaching a volume enables you to recover your data from one gateway to a different gateway without creating
     * a snapshot. It also makes it easier to move your volumes from an on-premises gateway to a gateway hosted on an
     * Amazon EC2 instance. This operation is only supported in the volume gateway type.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DetachVolumeRequest.Builder} avoiding the need to
     * create one manually via {@link DetachVolumeRequest#builder()}
     * </p>
     *
     * @param detachVolumeRequest
     *        A {@link Consumer} that will call methods on {@link DetachVolumeInput.Builder} to create a request.
     *        AttachVolumeInput
     * @return Result of the DetachVolume operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.DetachVolume
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DetachVolume" target="_top">AWS
     *      API Documentation</a>
     */
    default DetachVolumeResponse detachVolume(Consumer<DetachVolumeRequest.Builder> detachVolumeRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        return detachVolume(DetachVolumeRequest.builder().applyMutation(detachVolumeRequest).build());
    }

    /**
     * <p>
     * Disables a tape gateway when the gateway is no longer functioning. For example, if your gateway VM is damaged,
     * you can disable the gateway so you can recover virtual tapes.
     * </p>
     * <p>
     * Use this operation for a tape gateway that is not reachable or not functioning. This operation is only supported
     * in the tape gateway type.
     * </p>
     * <important>
     * <p>
     * After a gateway is disabled, it cannot be enabled.
     * </p>
     * </important>
     *
     * @param disableGatewayRequest
     *        DisableGatewayInput
     * @return Result of the DisableGateway operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.DisableGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DisableGateway" target="_top">AWS
     *      API Documentation</a>
     */
    default DisableGatewayResponse disableGateway(DisableGatewayRequest disableGatewayRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disables a tape gateway when the gateway is no longer functioning. For example, if your gateway VM is damaged,
     * you can disable the gateway so you can recover virtual tapes.
     * </p>
     * <p>
     * Use this operation for a tape gateway that is not reachable or not functioning. This operation is only supported
     * in the tape gateway type.
     * </p>
     * <important>
     * <p>
     * After a gateway is disabled, it cannot be enabled.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisableGatewayRequest.Builder} avoiding the need to
     * create one manually via {@link DisableGatewayRequest#builder()}
     * </p>
     *
     * @param disableGatewayRequest
     *        A {@link Consumer} that will call methods on {@link DisableGatewayInput.Builder} to create a request.
     *        DisableGatewayInput
     * @return Result of the DisableGateway operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.DisableGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DisableGateway" target="_top">AWS
     *      API Documentation</a>
     */
    default DisableGatewayResponse disableGateway(Consumer<DisableGatewayRequest.Builder> disableGatewayRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        return disableGateway(DisableGatewayRequest.builder().applyMutation(disableGatewayRequest).build());
    }

    /**
     * <p>
     * Disassociates an Amazon FSx file system from the specified gateway. After the disassociation process finishes,
     * the gateway can no longer access the Amazon FSx file system. This operation is only supported in the FSx File
     * Gateway type.
     * </p>
     *
     * @param disassociateFileSystemRequest
     * @return Result of the DisassociateFileSystem operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.DisassociateFileSystem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DisassociateFileSystem"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateFileSystemResponse disassociateFileSystem(DisassociateFileSystemRequest disassociateFileSystemRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates an Amazon FSx file system from the specified gateway. After the disassociation process finishes,
     * the gateway can no longer access the Amazon FSx file system. This operation is only supported in the FSx File
     * Gateway type.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateFileSystemRequest.Builder} avoiding the
     * need to create one manually via {@link DisassociateFileSystemRequest#builder()}
     * </p>
     *
     * @param disassociateFileSystemRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateFileSystemInput.Builder} to create a
     *        request.
     * @return Result of the DisassociateFileSystem operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.DisassociateFileSystem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DisassociateFileSystem"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateFileSystemResponse disassociateFileSystem(
            Consumer<DisassociateFileSystemRequest.Builder> disassociateFileSystemRequest) throws InvalidGatewayRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, StorageGatewayException {
        return disassociateFileSystem(DisassociateFileSystemRequest.builder().applyMutation(disassociateFileSystemRequest)
                .build());
    }

    /**
     * <p>
     * Adds a file gateway to an Active Directory domain. This operation is only supported for file gateways that
     * support the SMB file protocol.
     * </p>
     *
     * @param joinDomainRequest
     *        JoinDomainInput
     * @return Result of the JoinDomain operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.JoinDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/JoinDomain" target="_top">AWS API
     *      Documentation</a>
     */
    default JoinDomainResponse joinDomain(JoinDomainRequest joinDomainRequest) throws InvalidGatewayRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, StorageGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds a file gateway to an Active Directory domain. This operation is only supported for file gateways that
     * support the SMB file protocol.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link JoinDomainRequest.Builder} avoiding the need to
     * create one manually via {@link JoinDomainRequest#builder()}
     * </p>
     *
     * @param joinDomainRequest
     *        A {@link Consumer} that will call methods on {@link JoinDomainInput.Builder} to create a request.
     *        JoinDomainInput
     * @return Result of the JoinDomain operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.JoinDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/JoinDomain" target="_top">AWS API
     *      Documentation</a>
     */
    default JoinDomainResponse joinDomain(Consumer<JoinDomainRequest.Builder> joinDomainRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        return joinDomain(JoinDomainRequest.builder().applyMutation(joinDomainRequest).build());
    }

    /**
     * <p>
     * Lists the automatic tape creation policies for a gateway. If there are no automatic tape creation policies for
     * the gateway, it returns an empty list.
     * </p>
     * <p>
     * This operation is only supported for tape gateways.
     * </p>
     *
     * @param listAutomaticTapeCreationPoliciesRequest
     * @return Result of the ListAutomaticTapeCreationPolicies operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.ListAutomaticTapeCreationPolicies
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ListAutomaticTapeCreationPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAutomaticTapeCreationPoliciesResponse listAutomaticTapeCreationPolicies(
            ListAutomaticTapeCreationPoliciesRequest listAutomaticTapeCreationPoliciesRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the automatic tape creation policies for a gateway. If there are no automatic tape creation policies for
     * the gateway, it returns an empty list.
     * </p>
     * <p>
     * This operation is only supported for tape gateways.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAutomaticTapeCreationPoliciesRequest.Builder}
     * avoiding the need to create one manually via {@link ListAutomaticTapeCreationPoliciesRequest#builder()}
     * </p>
     *
     * @param listAutomaticTapeCreationPoliciesRequest
     *        A {@link Consumer} that will call methods on {@link ListAutomaticTapeCreationPoliciesInput.Builder} to
     *        create a request.
     * @return Result of the ListAutomaticTapeCreationPolicies operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.ListAutomaticTapeCreationPolicies
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ListAutomaticTapeCreationPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAutomaticTapeCreationPoliciesResponse listAutomaticTapeCreationPolicies(
            Consumer<ListAutomaticTapeCreationPoliciesRequest.Builder> listAutomaticTapeCreationPoliciesRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        return listAutomaticTapeCreationPolicies(ListAutomaticTapeCreationPoliciesRequest.builder()
                .applyMutation(listAutomaticTapeCreationPoliciesRequest).build());
    }

    /**
     * <p>
     * Gets a list of the file shares for a specific S3 File Gateway, or the list of file shares that belong to the
     * calling user account. This operation is only supported for S3 File Gateways.
     * </p>
     *
     * @return Result of the ListFileShares operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.ListFileShares
     * @see #listFileShares(ListFileSharesRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ListFileShares" target="_top">AWS
     *      API Documentation</a>
     */
    default ListFileSharesResponse listFileShares() throws InvalidGatewayRequestException, InternalServerErrorException,
            AwsServiceException, SdkClientException, StorageGatewayException {
        return listFileShares(ListFileSharesRequest.builder().build());
    }

    /**
     * <p>
     * Gets a list of the file shares for a specific S3 File Gateway, or the list of file shares that belong to the
     * calling user account. This operation is only supported for S3 File Gateways.
     * </p>
     *
     * @param listFileSharesRequest
     *        ListFileShareInput
     * @return Result of the ListFileShares operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.ListFileShares
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ListFileShares" target="_top">AWS
     *      API Documentation</a>
     */
    default ListFileSharesResponse listFileShares(ListFileSharesRequest listFileSharesRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of the file shares for a specific S3 File Gateway, or the list of file shares that belong to the
     * calling user account. This operation is only supported for S3 File Gateways.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFileSharesRequest.Builder} avoiding the need to
     * create one manually via {@link ListFileSharesRequest#builder()}
     * </p>
     *
     * @param listFileSharesRequest
     *        A {@link Consumer} that will call methods on {@link ListFileSharesInput.Builder} to create a request.
     *        ListFileShareInput
     * @return Result of the ListFileShares operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.ListFileShares
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ListFileShares" target="_top">AWS
     *      API Documentation</a>
     */
    default ListFileSharesResponse listFileShares(Consumer<ListFileSharesRequest.Builder> listFileSharesRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        return listFileShares(ListFileSharesRequest.builder().applyMutation(listFileSharesRequest).build());
    }

    /**
     * <p>
     * Gets a list of the file shares for a specific S3 File Gateway, or the list of file shares that belong to the
     * calling user account. This operation is only supported for S3 File Gateways.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listFileShares(software.amazon.awssdk.services.storagegateway.model.ListFileSharesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.storagegateway.paginators.ListFileSharesIterable responses = client.listFileSharesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.storagegateway.paginators.ListFileSharesIterable responses = client
     *             .listFileSharesPaginator(request);
     *     for (software.amazon.awssdk.services.storagegateway.model.ListFileSharesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.storagegateway.paginators.ListFileSharesIterable responses = client.listFileSharesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFileShares(software.amazon.awssdk.services.storagegateway.model.ListFileSharesRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.ListFileShares
     * @see #listFileSharesPaginator(ListFileSharesRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ListFileShares" target="_top">AWS
     *      API Documentation</a>
     */
    default ListFileSharesIterable listFileSharesPaginator() throws InvalidGatewayRequestException, InternalServerErrorException,
            AwsServiceException, SdkClientException, StorageGatewayException {
        return listFileSharesPaginator(ListFileSharesRequest.builder().build());
    }

    /**
     * <p>
     * Gets a list of the file shares for a specific S3 File Gateway, or the list of file shares that belong to the
     * calling user account. This operation is only supported for S3 File Gateways.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listFileShares(software.amazon.awssdk.services.storagegateway.model.ListFileSharesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.storagegateway.paginators.ListFileSharesIterable responses = client.listFileSharesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.storagegateway.paginators.ListFileSharesIterable responses = client
     *             .listFileSharesPaginator(request);
     *     for (software.amazon.awssdk.services.storagegateway.model.ListFileSharesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.storagegateway.paginators.ListFileSharesIterable responses = client.listFileSharesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFileShares(software.amazon.awssdk.services.storagegateway.model.ListFileSharesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listFileSharesRequest
     *        ListFileShareInput
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.ListFileShares
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ListFileShares" target="_top">AWS
     *      API Documentation</a>
     */
    default ListFileSharesIterable listFileSharesPaginator(ListFileSharesRequest listFileSharesRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of the file shares for a specific S3 File Gateway, or the list of file shares that belong to the
     * calling user account. This operation is only supported for S3 File Gateways.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listFileShares(software.amazon.awssdk.services.storagegateway.model.ListFileSharesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.storagegateway.paginators.ListFileSharesIterable responses = client.listFileSharesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.storagegateway.paginators.ListFileSharesIterable responses = client
     *             .listFileSharesPaginator(request);
     *     for (software.amazon.awssdk.services.storagegateway.model.ListFileSharesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.storagegateway.paginators.ListFileSharesIterable responses = client.listFileSharesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFileShares(software.amazon.awssdk.services.storagegateway.model.ListFileSharesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFileSharesRequest.Builder} avoiding the need to
     * create one manually via {@link ListFileSharesRequest#builder()}
     * </p>
     *
     * @param listFileSharesRequest
     *        A {@link Consumer} that will call methods on {@link ListFileSharesInput.Builder} to create a request.
     *        ListFileShareInput
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.ListFileShares
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ListFileShares" target="_top">AWS
     *      API Documentation</a>
     */
    default ListFileSharesIterable listFileSharesPaginator(Consumer<ListFileSharesRequest.Builder> listFileSharesRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        return listFileSharesPaginator(ListFileSharesRequest.builder().applyMutation(listFileSharesRequest).build());
    }

    /**
     * <p>
     * Gets a list of <code>FileSystemAssociationSummary</code> objects. Each object contains a summary of a file system
     * association. This operation is only supported for FSx File Gateways.
     * </p>
     *
     * @param listFileSystemAssociationsRequest
     * @return Result of the ListFileSystemAssociations operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.ListFileSystemAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ListFileSystemAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFileSystemAssociationsResponse listFileSystemAssociations(
            ListFileSystemAssociationsRequest listFileSystemAssociationsRequest) throws InvalidGatewayRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, StorageGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of <code>FileSystemAssociationSummary</code> objects. Each object contains a summary of a file system
     * association. This operation is only supported for FSx File Gateways.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFileSystemAssociationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListFileSystemAssociationsRequest#builder()}
     * </p>
     *
     * @param listFileSystemAssociationsRequest
     *        A {@link Consumer} that will call methods on {@link ListFileSystemAssociationsInput.Builder} to create a
     *        request.
     * @return Result of the ListFileSystemAssociations operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.ListFileSystemAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ListFileSystemAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFileSystemAssociationsResponse listFileSystemAssociations(
            Consumer<ListFileSystemAssociationsRequest.Builder> listFileSystemAssociationsRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        return listFileSystemAssociations(ListFileSystemAssociationsRequest.builder()
                .applyMutation(listFileSystemAssociationsRequest).build());
    }

    /**
     * <p>
     * Gets a list of <code>FileSystemAssociationSummary</code> objects. Each object contains a summary of a file system
     * association. This operation is only supported for FSx File Gateways.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listFileSystemAssociations(software.amazon.awssdk.services.storagegateway.model.ListFileSystemAssociationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.storagegateway.paginators.ListFileSystemAssociationsIterable responses = client.listFileSystemAssociationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.storagegateway.paginators.ListFileSystemAssociationsIterable responses = client
     *             .listFileSystemAssociationsPaginator(request);
     *     for (software.amazon.awssdk.services.storagegateway.model.ListFileSystemAssociationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.storagegateway.paginators.ListFileSystemAssociationsIterable responses = client.listFileSystemAssociationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFileSystemAssociations(software.amazon.awssdk.services.storagegateway.model.ListFileSystemAssociationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listFileSystemAssociationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.ListFileSystemAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ListFileSystemAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFileSystemAssociationsIterable listFileSystemAssociationsPaginator(
            ListFileSystemAssociationsRequest listFileSystemAssociationsRequest) throws InvalidGatewayRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, StorageGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of <code>FileSystemAssociationSummary</code> objects. Each object contains a summary of a file system
     * association. This operation is only supported for FSx File Gateways.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listFileSystemAssociations(software.amazon.awssdk.services.storagegateway.model.ListFileSystemAssociationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.storagegateway.paginators.ListFileSystemAssociationsIterable responses = client.listFileSystemAssociationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.storagegateway.paginators.ListFileSystemAssociationsIterable responses = client
     *             .listFileSystemAssociationsPaginator(request);
     *     for (software.amazon.awssdk.services.storagegateway.model.ListFileSystemAssociationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.storagegateway.paginators.ListFileSystemAssociationsIterable responses = client.listFileSystemAssociationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFileSystemAssociations(software.amazon.awssdk.services.storagegateway.model.ListFileSystemAssociationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFileSystemAssociationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListFileSystemAssociationsRequest#builder()}
     * </p>
     *
     * @param listFileSystemAssociationsRequest
     *        A {@link Consumer} that will call methods on {@link ListFileSystemAssociationsInput.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.ListFileSystemAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ListFileSystemAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFileSystemAssociationsIterable listFileSystemAssociationsPaginator(
            Consumer<ListFileSystemAssociationsRequest.Builder> listFileSystemAssociationsRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        return listFileSystemAssociationsPaginator(ListFileSystemAssociationsRequest.builder()
                .applyMutation(listFileSystemAssociationsRequest).build());
    }

    /**
     * <p>
     * Lists gateways owned by an Amazon Web Services account in an Amazon Web Services Region specified in the request.
     * The returned list is ordered by gateway Amazon Resource Name (ARN).
     * </p>
     * <p>
     * By default, the operation returns a maximum of 100 gateways. This operation supports pagination that allows you
     * to optionally reduce the number of gateways returned in a response.
     * </p>
     * <p>
     * If you have more gateways than are returned in a response (that is, the response returns only a truncated list of
     * your gateways), the response contains a marker that you can specify in your next request to fetch the next page
     * of gateways.
     * </p>
     *
     * @return Result of the ListGateways operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.ListGateways
     * @see #listGateways(ListGatewaysRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ListGateways" target="_top">AWS
     *      API Documentation</a>
     */
    default ListGatewaysResponse listGateways() throws InvalidGatewayRequestException, InternalServerErrorException,
            AwsServiceException, SdkClientException, StorageGatewayException {
        return listGateways(ListGatewaysRequest.builder().build());
    }

    /**
     * <p>
     * Lists gateways owned by an Amazon Web Services account in an Amazon Web Services Region specified in the request.
     * The returned list is ordered by gateway Amazon Resource Name (ARN).
     * </p>
     * <p>
     * By default, the operation returns a maximum of 100 gateways. This operation supports pagination that allows you
     * to optionally reduce the number of gateways returned in a response.
     * </p>
     * <p>
     * If you have more gateways than are returned in a response (that is, the response returns only a truncated list of
     * your gateways), the response contains a marker that you can specify in your next request to fetch the next page
     * of gateways.
     * </p>
     *
     * @param listGatewaysRequest
     *        A JSON object containing zero or more of the following fields:</p>
     *        <ul>
     *        <li>
     *        <p>
     *        <a>ListGatewaysInput&#36Limit</a>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <a>ListGatewaysInput&#36Marker</a>
     *        </p>
     *        </li>
     * @return Result of the ListGateways operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.ListGateways
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ListGateways" target="_top">AWS
     *      API Documentation</a>
     */
    default ListGatewaysResponse listGateways(ListGatewaysRequest listGatewaysRequest) throws InvalidGatewayRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, StorageGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists gateways owned by an Amazon Web Services account in an Amazon Web Services Region specified in the request.
     * The returned list is ordered by gateway Amazon Resource Name (ARN).
     * </p>
     * <p>
     * By default, the operation returns a maximum of 100 gateways. This operation supports pagination that allows you
     * to optionally reduce the number of gateways returned in a response.
     * </p>
     * <p>
     * If you have more gateways than are returned in a response (that is, the response returns only a truncated list of
     * your gateways), the response contains a marker that you can specify in your next request to fetch the next page
     * of gateways.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGatewaysRequest.Builder} avoiding the need to
     * create one manually via {@link ListGatewaysRequest#builder()}
     * </p>
     *
     * @param listGatewaysRequest
     *        A {@link Consumer} that will call methods on {@link ListGatewaysInput.Builder} to create a request. A JSON
     *        object containing zero or more of the following fields:</p>
     *        <ul>
     *        <li>
     *        <p>
     *        <a>ListGatewaysInput&#36Limit</a>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <a>ListGatewaysInput&#36Marker</a>
     *        </p>
     *        </li>
     * @return Result of the ListGateways operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.ListGateways
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ListGateways" target="_top">AWS
     *      API Documentation</a>
     */
    default ListGatewaysResponse listGateways(Consumer<ListGatewaysRequest.Builder> listGatewaysRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        return listGateways(ListGatewaysRequest.builder().applyMutation(listGatewaysRequest).build());
    }

    /**
     * <p>
     * Lists gateways owned by an Amazon Web Services account in an Amazon Web Services Region specified in the request.
     * The returned list is ordered by gateway Amazon Resource Name (ARN).
     * </p>
     * <p>
     * By default, the operation returns a maximum of 100 gateways. This operation supports pagination that allows you
     * to optionally reduce the number of gateways returned in a response.
     * </p>
     * <p>
     * If you have more gateways than are returned in a response (that is, the response returns only a truncated list of
     * your gateways), the response contains a marker that you can specify in your next request to fetch the next page
     * of gateways.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listGateways(software.amazon.awssdk.services.storagegateway.model.ListGatewaysRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.storagegateway.paginators.ListGatewaysIterable responses = client.listGatewaysPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.storagegateway.paginators.ListGatewaysIterable responses = client
     *             .listGatewaysPaginator(request);
     *     for (software.amazon.awssdk.services.storagegateway.model.ListGatewaysResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.storagegateway.paginators.ListGatewaysIterable responses = client.listGatewaysPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGateways(software.amazon.awssdk.services.storagegateway.model.ListGatewaysRequest)} operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.ListGateways
     * @see #listGatewaysPaginator(ListGatewaysRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ListGateways" target="_top">AWS
     *      API Documentation</a>
     */
    default ListGatewaysIterable listGatewaysPaginator() throws InvalidGatewayRequestException, InternalServerErrorException,
            AwsServiceException, SdkClientException, StorageGatewayException {
        return listGatewaysPaginator(ListGatewaysRequest.builder().build());
    }

    /**
     * <p>
     * Lists gateways owned by an Amazon Web Services account in an Amazon Web Services Region specified in the request.
     * The returned list is ordered by gateway Amazon Resource Name (ARN).
     * </p>
     * <p>
     * By default, the operation returns a maximum of 100 gateways. This operation supports pagination that allows you
     * to optionally reduce the number of gateways returned in a response.
     * </p>
     * <p>
     * If you have more gateways than are returned in a response (that is, the response returns only a truncated list of
     * your gateways), the response contains a marker that you can specify in your next request to fetch the next page
     * of gateways.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listGateways(software.amazon.awssdk.services.storagegateway.model.ListGatewaysRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.storagegateway.paginators.ListGatewaysIterable responses = client.listGatewaysPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.storagegateway.paginators.ListGatewaysIterable responses = client
     *             .listGatewaysPaginator(request);
     *     for (software.amazon.awssdk.services.storagegateway.model.ListGatewaysResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.storagegateway.paginators.ListGatewaysIterable responses = client.listGatewaysPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGateways(software.amazon.awssdk.services.storagegateway.model.ListGatewaysRequest)} operation.</b>
     * </p>
     *
     * @param listGatewaysRequest
     *        A JSON object containing zero or more of the following fields:</p>
     *        <ul>
     *        <li>
     *        <p>
     *        <a>ListGatewaysInput&#36Limit</a>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <a>ListGatewaysInput&#36Marker</a>
     *        </p>
     *        </li>
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.ListGateways
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ListGateways" target="_top">AWS
     *      API Documentation</a>
     */
    default ListGatewaysIterable listGatewaysPaginator(ListGatewaysRequest listGatewaysRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists gateways owned by an Amazon Web Services account in an Amazon Web Services Region specified in the request.
     * The returned list is ordered by gateway Amazon Resource Name (ARN).
     * </p>
     * <p>
     * By default, the operation returns a maximum of 100 gateways. This operation supports pagination that allows you
     * to optionally reduce the number of gateways returned in a response.
     * </p>
     * <p>
     * If you have more gateways than are returned in a response (that is, the response returns only a truncated list of
     * your gateways), the response contains a marker that you can specify in your next request to fetch the next page
     * of gateways.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listGateways(software.amazon.awssdk.services.storagegateway.model.ListGatewaysRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.storagegateway.paginators.ListGatewaysIterable responses = client.listGatewaysPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.storagegateway.paginators.ListGatewaysIterable responses = client
     *             .listGatewaysPaginator(request);
     *     for (software.amazon.awssdk.services.storagegateway.model.ListGatewaysResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.storagegateway.paginators.ListGatewaysIterable responses = client.listGatewaysPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGateways(software.amazon.awssdk.services.storagegateway.model.ListGatewaysRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGatewaysRequest.Builder} avoiding the need to
     * create one manually via {@link ListGatewaysRequest#builder()}
     * </p>
     *
     * @param listGatewaysRequest
     *        A {@link Consumer} that will call methods on {@link ListGatewaysInput.Builder} to create a request. A JSON
     *        object containing zero or more of the following fields:</p>
     *        <ul>
     *        <li>
     *        <p>
     *        <a>ListGatewaysInput&#36Limit</a>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <a>ListGatewaysInput&#36Marker</a>
     *        </p>
     *        </li>
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.ListGateways
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ListGateways" target="_top">AWS
     *      API Documentation</a>
     */
    default ListGatewaysIterable listGatewaysPaginator(Consumer<ListGatewaysRequest.Builder> listGatewaysRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        return listGatewaysPaginator(ListGatewaysRequest.builder().applyMutation(listGatewaysRequest).build());
    }

    /**
     * <p>
     * Returns a list of the gateway's local disks. To specify which gateway to describe, you use the Amazon Resource
     * Name (ARN) of the gateway in the body of the request.
     * </p>
     * <p>
     * The request returns a list of all disks, specifying which are configured as working storage, cache storage, or
     * stored volume or not configured at all. The response includes a <code>DiskStatus</code> field. This field can
     * have a value of present (the disk is available to use), missing (the disk is no longer connected to the gateway),
     * or mismatch (the disk node is occupied by a disk that has incorrect metadata or the disk content is corrupted).
     * </p>
     *
     * @param listLocalDisksRequest
     *        A JSON object containing the Amazon Resource Name (ARN) of the gateway.
     * @return Result of the ListLocalDisks operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.ListLocalDisks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ListLocalDisks" target="_top">AWS
     *      API Documentation</a>
     */
    default ListLocalDisksResponse listLocalDisks(ListLocalDisksRequest listLocalDisksRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the gateway's local disks. To specify which gateway to describe, you use the Amazon Resource
     * Name (ARN) of the gateway in the body of the request.
     * </p>
     * <p>
     * The request returns a list of all disks, specifying which are configured as working storage, cache storage, or
     * stored volume or not configured at all. The response includes a <code>DiskStatus</code> field. This field can
     * have a value of present (the disk is available to use), missing (the disk is no longer connected to the gateway),
     * or mismatch (the disk node is occupied by a disk that has incorrect metadata or the disk content is corrupted).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLocalDisksRequest.Builder} avoiding the need to
     * create one manually via {@link ListLocalDisksRequest#builder()}
     * </p>
     *
     * @param listLocalDisksRequest
     *        A {@link Consumer} that will call methods on {@link ListLocalDisksInput.Builder} to create a request. A
     *        JSON object containing the Amazon Resource Name (ARN) of the gateway.
     * @return Result of the ListLocalDisks operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.ListLocalDisks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ListLocalDisks" target="_top">AWS
     *      API Documentation</a>
     */
    default ListLocalDisksResponse listLocalDisks(Consumer<ListLocalDisksRequest.Builder> listLocalDisksRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        return listLocalDisks(ListLocalDisksRequest.builder().applyMutation(listLocalDisksRequest).build());
    }

    /**
     * <p>
     * Lists the tags that have been added to the specified resource. This operation is supported in storage gateways of
     * all types.
     * </p>
     *
     * @param listTagsForResourceRequest
     *        ListTagsForResourceInput
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the tags that have been added to the specified resource. This operation is supported in storage gateways of
     * all types.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceInput.Builder} to create a request.
     *        ListTagsForResourceInput
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws InvalidGatewayRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, StorageGatewayException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Lists the tags that have been added to the specified resource. This operation is supported in storage gateways of
     * all types.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTagsForResource(software.amazon.awssdk.services.storagegateway.model.ListTagsForResourceRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.storagegateway.paginators.ListTagsForResourceIterable responses = client.listTagsForResourcePaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.storagegateway.paginators.ListTagsForResourceIterable responses = client
     *             .listTagsForResourcePaginator(request);
     *     for (software.amazon.awssdk.services.storagegateway.model.ListTagsForResourceResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.storagegateway.paginators.ListTagsForResourceIterable responses = client.listTagsForResourcePaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTagsForResource(software.amazon.awssdk.services.storagegateway.model.ListTagsForResourceRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTagsForResourceRequest
     *        ListTagsForResourceInput
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceIterable listTagsForResourcePaginator(ListTagsForResourceRequest listTagsForResourceRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the tags that have been added to the specified resource. This operation is supported in storage gateways of
     * all types.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTagsForResource(software.amazon.awssdk.services.storagegateway.model.ListTagsForResourceRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.storagegateway.paginators.ListTagsForResourceIterable responses = client.listTagsForResourcePaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.storagegateway.paginators.ListTagsForResourceIterable responses = client
     *             .listTagsForResourcePaginator(request);
     *     for (software.amazon.awssdk.services.storagegateway.model.ListTagsForResourceResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.storagegateway.paginators.ListTagsForResourceIterable responses = client.listTagsForResourcePaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTagsForResource(software.amazon.awssdk.services.storagegateway.model.ListTagsForResourceRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceInput.Builder} to create a request.
     *        ListTagsForResourceInput
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceIterable listTagsForResourcePaginator(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws InvalidGatewayRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, StorageGatewayException {
        return listTagsForResourcePaginator(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest)
                .build());
    }

    /**
     * <p>
     * Lists custom tape pools. You specify custom tape pools to list by specifying one or more custom tape pool Amazon
     * Resource Names (ARNs). If you don't specify a custom tape pool ARN, the operation lists all custom tape pools.
     * </p>
     * <p>
     * This operation supports pagination. You can optionally specify the <code>Limit</code> parameter in the body to
     * limit the number of tape pools in the response. If the number of tape pools returned in the response is
     * truncated, the response includes a <code>Marker</code> element that you can use in your subsequent request to
     * retrieve the next set of tape pools.
     * </p>
     *
     * @param listTapePoolsRequest
     * @return Result of the ListTapePools operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.ListTapePools
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ListTapePools" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTapePoolsResponse listTapePools(ListTapePoolsRequest listTapePoolsRequest) throws InvalidGatewayRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, StorageGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists custom tape pools. You specify custom tape pools to list by specifying one or more custom tape pool Amazon
     * Resource Names (ARNs). If you don't specify a custom tape pool ARN, the operation lists all custom tape pools.
     * </p>
     * <p>
     * This operation supports pagination. You can optionally specify the <code>Limit</code> parameter in the body to
     * limit the number of tape pools in the response. If the number of tape pools returned in the response is
     * truncated, the response includes a <code>Marker</code> element that you can use in your subsequent request to
     * retrieve the next set of tape pools.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTapePoolsRequest.Builder} avoiding the need to
     * create one manually via {@link ListTapePoolsRequest#builder()}
     * </p>
     *
     * @param listTapePoolsRequest
     *        A {@link Consumer} that will call methods on {@link ListTapePoolsInput.Builder} to create a request.
     * @return Result of the ListTapePools operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.ListTapePools
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ListTapePools" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTapePoolsResponse listTapePools(Consumer<ListTapePoolsRequest.Builder> listTapePoolsRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        return listTapePools(ListTapePoolsRequest.builder().applyMutation(listTapePoolsRequest).build());
    }

    /**
     * <p>
     * Lists custom tape pools. You specify custom tape pools to list by specifying one or more custom tape pool Amazon
     * Resource Names (ARNs). If you don't specify a custom tape pool ARN, the operation lists all custom tape pools.
     * </p>
     * <p>
     * This operation supports pagination. You can optionally specify the <code>Limit</code> parameter in the body to
     * limit the number of tape pools in the response. If the number of tape pools returned in the response is
     * truncated, the response includes a <code>Marker</code> element that you can use in your subsequent request to
     * retrieve the next set of tape pools.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTapePools(software.amazon.awssdk.services.storagegateway.model.ListTapePoolsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.storagegateway.paginators.ListTapePoolsIterable responses = client.listTapePoolsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.storagegateway.paginators.ListTapePoolsIterable responses = client
     *             .listTapePoolsPaginator(request);
     *     for (software.amazon.awssdk.services.storagegateway.model.ListTapePoolsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.storagegateway.paginators.ListTapePoolsIterable responses = client.listTapePoolsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTapePools(software.amazon.awssdk.services.storagegateway.model.ListTapePoolsRequest)} operation.</b>
     * </p>
     *
     * @param listTapePoolsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.ListTapePools
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ListTapePools" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTapePoolsIterable listTapePoolsPaginator(ListTapePoolsRequest listTapePoolsRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists custom tape pools. You specify custom tape pools to list by specifying one or more custom tape pool Amazon
     * Resource Names (ARNs). If you don't specify a custom tape pool ARN, the operation lists all custom tape pools.
     * </p>
     * <p>
     * This operation supports pagination. You can optionally specify the <code>Limit</code> parameter in the body to
     * limit the number of tape pools in the response. If the number of tape pools returned in the response is
     * truncated, the response includes a <code>Marker</code> element that you can use in your subsequent request to
     * retrieve the next set of tape pools.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTapePools(software.amazon.awssdk.services.storagegateway.model.ListTapePoolsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.storagegateway.paginators.ListTapePoolsIterable responses = client.listTapePoolsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.storagegateway.paginators.ListTapePoolsIterable responses = client
     *             .listTapePoolsPaginator(request);
     *     for (software.amazon.awssdk.services.storagegateway.model.ListTapePoolsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.storagegateway.paginators.ListTapePoolsIterable responses = client.listTapePoolsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTapePools(software.amazon.awssdk.services.storagegateway.model.ListTapePoolsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTapePoolsRequest.Builder} avoiding the need to
     * create one manually via {@link ListTapePoolsRequest#builder()}
     * </p>
     *
     * @param listTapePoolsRequest
     *        A {@link Consumer} that will call methods on {@link ListTapePoolsInput.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.ListTapePools
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ListTapePools" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTapePoolsIterable listTapePoolsPaginator(Consumer<ListTapePoolsRequest.Builder> listTapePoolsRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        return listTapePoolsPaginator(ListTapePoolsRequest.builder().applyMutation(listTapePoolsRequest).build());
    }

    /**
     * <p>
     * Lists virtual tapes in your virtual tape library (VTL) and your virtual tape shelf (VTS). You specify the tapes
     * to list by specifying one or more tape Amazon Resource Names (ARNs). If you don't specify a tape ARN, the
     * operation lists all virtual tapes in both your VTL and VTS.
     * </p>
     * <p>
     * This operation supports pagination. By default, the operation returns a maximum of up to 100 tapes. You can
     * optionally specify the <code>Limit</code> parameter in the body to limit the number of tapes in the response. If
     * the number of tapes returned in the response is truncated, the response includes a <code>Marker</code> element
     * that you can use in your subsequent request to retrieve the next set of tapes. This operation is only supported
     * in the tape gateway type.
     * </p>
     *
     * @return Result of the ListTapes operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.ListTapes
     * @see #listTapes(ListTapesRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ListTapes" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTapesResponse listTapes() throws InvalidGatewayRequestException, InternalServerErrorException,
            AwsServiceException, SdkClientException, StorageGatewayException {
        return listTapes(ListTapesRequest.builder().build());
    }

    /**
     * <p>
     * Lists virtual tapes in your virtual tape library (VTL) and your virtual tape shelf (VTS). You specify the tapes
     * to list by specifying one or more tape Amazon Resource Names (ARNs). If you don't specify a tape ARN, the
     * operation lists all virtual tapes in both your VTL and VTS.
     * </p>
     * <p>
     * This operation supports pagination. By default, the operation returns a maximum of up to 100 tapes. You can
     * optionally specify the <code>Limit</code> parameter in the body to limit the number of tapes in the response. If
     * the number of tapes returned in the response is truncated, the response includes a <code>Marker</code> element
     * that you can use in your subsequent request to retrieve the next set of tapes. This operation is only supported
     * in the tape gateway type.
     * </p>
     *
     * @param listTapesRequest
     *        A JSON object that contains one or more of the following fields:</p>
     *        <ul>
     *        <li>
     *        <p>
     *        <a>ListTapesInput&#36Limit</a>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <a>ListTapesInput&#36Marker</a>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <a>ListTapesInput&#36TapeARNs</a>
     *        </p>
     *        </li>
     * @return Result of the ListTapes operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.ListTapes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ListTapes" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTapesResponse listTapes(ListTapesRequest listTapesRequest) throws InvalidGatewayRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, StorageGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists virtual tapes in your virtual tape library (VTL) and your virtual tape shelf (VTS). You specify the tapes
     * to list by specifying one or more tape Amazon Resource Names (ARNs). If you don't specify a tape ARN, the
     * operation lists all virtual tapes in both your VTL and VTS.
     * </p>
     * <p>
     * This operation supports pagination. By default, the operation returns a maximum of up to 100 tapes. You can
     * optionally specify the <code>Limit</code> parameter in the body to limit the number of tapes in the response. If
     * the number of tapes returned in the response is truncated, the response includes a <code>Marker</code> element
     * that you can use in your subsequent request to retrieve the next set of tapes. This operation is only supported
     * in the tape gateway type.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTapesRequest.Builder} avoiding the need to
     * create one manually via {@link ListTapesRequest#builder()}
     * </p>
     *
     * @param listTapesRequest
     *        A {@link Consumer} that will call methods on {@link ListTapesInput.Builder} to create a request. A JSON
     *        object that contains one or more of the following fields:</p>
     *        <ul>
     *        <li>
     *        <p>
     *        <a>ListTapesInput&#36Limit</a>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <a>ListTapesInput&#36Marker</a>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <a>ListTapesInput&#36TapeARNs</a>
     *        </p>
     *        </li>
     * @return Result of the ListTapes operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.ListTapes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ListTapes" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTapesResponse listTapes(Consumer<ListTapesRequest.Builder> listTapesRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        return listTapes(ListTapesRequest.builder().applyMutation(listTapesRequest).build());
    }

    /**
     * <p>
     * Lists virtual tapes in your virtual tape library (VTL) and your virtual tape shelf (VTS). You specify the tapes
     * to list by specifying one or more tape Amazon Resource Names (ARNs). If you don't specify a tape ARN, the
     * operation lists all virtual tapes in both your VTL and VTS.
     * </p>
     * <p>
     * This operation supports pagination. By default, the operation returns a maximum of up to 100 tapes. You can
     * optionally specify the <code>Limit</code> parameter in the body to limit the number of tapes in the response. If
     * the number of tapes returned in the response is truncated, the response includes a <code>Marker</code> element
     * that you can use in your subsequent request to retrieve the next set of tapes. This operation is only supported
     * in the tape gateway type.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listTapes(software.amazon.awssdk.services.storagegateway.model.ListTapesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.storagegateway.paginators.ListTapesIterable responses = client.listTapesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.storagegateway.paginators.ListTapesIterable responses = client.listTapesPaginator(request);
     *     for (software.amazon.awssdk.services.storagegateway.model.ListTapesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.storagegateway.paginators.ListTapesIterable responses = client.listTapesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTapes(software.amazon.awssdk.services.storagegateway.model.ListTapesRequest)} operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.ListTapes
     * @see #listTapesPaginator(ListTapesRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ListTapes" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTapesIterable listTapesPaginator() throws InvalidGatewayRequestException, InternalServerErrorException,
            AwsServiceException, SdkClientException, StorageGatewayException {
        return listTapesPaginator(ListTapesRequest.builder().build());
    }

    /**
     * <p>
     * Lists virtual tapes in your virtual tape library (VTL) and your virtual tape shelf (VTS). You specify the tapes
     * to list by specifying one or more tape Amazon Resource Names (ARNs). If you don't specify a tape ARN, the
     * operation lists all virtual tapes in both your VTL and VTS.
     * </p>
     * <p>
     * This operation supports pagination. By default, the operation returns a maximum of up to 100 tapes. You can
     * optionally specify the <code>Limit</code> parameter in the body to limit the number of tapes in the response. If
     * the number of tapes returned in the response is truncated, the response includes a <code>Marker</code> element
     * that you can use in your subsequent request to retrieve the next set of tapes. This operation is only supported
     * in the tape gateway type.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listTapes(software.amazon.awssdk.services.storagegateway.model.ListTapesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.storagegateway.paginators.ListTapesIterable responses = client.listTapesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.storagegateway.paginators.ListTapesIterable responses = client.listTapesPaginator(request);
     *     for (software.amazon.awssdk.services.storagegateway.model.ListTapesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.storagegateway.paginators.ListTapesIterable responses = client.listTapesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTapes(software.amazon.awssdk.services.storagegateway.model.ListTapesRequest)} operation.</b>
     * </p>
     *
     * @param listTapesRequest
     *        A JSON object that contains one or more of the following fields:</p>
     *        <ul>
     *        <li>
     *        <p>
     *        <a>ListTapesInput&#36Limit</a>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <a>ListTapesInput&#36Marker</a>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <a>ListTapesInput&#36TapeARNs</a>
     *        </p>
     *        </li>
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.ListTapes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ListTapes" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTapesIterable listTapesPaginator(ListTapesRequest listTapesRequest) throws InvalidGatewayRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, StorageGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists virtual tapes in your virtual tape library (VTL) and your virtual tape shelf (VTS). You specify the tapes
     * to list by specifying one or more tape Amazon Resource Names (ARNs). If you don't specify a tape ARN, the
     * operation lists all virtual tapes in both your VTL and VTS.
     * </p>
     * <p>
     * This operation supports pagination. By default, the operation returns a maximum of up to 100 tapes. You can
     * optionally specify the <code>Limit</code> parameter in the body to limit the number of tapes in the response. If
     * the number of tapes returned in the response is truncated, the response includes a <code>Marker</code> element
     * that you can use in your subsequent request to retrieve the next set of tapes. This operation is only supported
     * in the tape gateway type.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listTapes(software.amazon.awssdk.services.storagegateway.model.ListTapesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.storagegateway.paginators.ListTapesIterable responses = client.listTapesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.storagegateway.paginators.ListTapesIterable responses = client.listTapesPaginator(request);
     *     for (software.amazon.awssdk.services.storagegateway.model.ListTapesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.storagegateway.paginators.ListTapesIterable responses = client.listTapesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTapes(software.amazon.awssdk.services.storagegateway.model.ListTapesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTapesRequest.Builder} avoiding the need to
     * create one manually via {@link ListTapesRequest#builder()}
     * </p>
     *
     * @param listTapesRequest
     *        A {@link Consumer} that will call methods on {@link ListTapesInput.Builder} to create a request. A JSON
     *        object that contains one or more of the following fields:</p>
     *        <ul>
     *        <li>
     *        <p>
     *        <a>ListTapesInput&#36Limit</a>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <a>ListTapesInput&#36Marker</a>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <a>ListTapesInput&#36TapeARNs</a>
     *        </p>
     *        </li>
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.ListTapes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ListTapes" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTapesIterable listTapesPaginator(Consumer<ListTapesRequest.Builder> listTapesRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        return listTapesPaginator(ListTapesRequest.builder().applyMutation(listTapesRequest).build());
    }

    /**
     * <p>
     * Lists iSCSI initiators that are connected to a volume. You can use this operation to determine whether a volume
     * is being used or not. This operation is only supported in the cached volume and stored volume gateway types.
     * </p>
     *
     * @param listVolumeInitiatorsRequest
     *        ListVolumeInitiatorsInput
     * @return Result of the ListVolumeInitiators operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.ListVolumeInitiators
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ListVolumeInitiators"
     *      target="_top">AWS API Documentation</a>
     */
    default ListVolumeInitiatorsResponse listVolumeInitiators(ListVolumeInitiatorsRequest listVolumeInitiatorsRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists iSCSI initiators that are connected to a volume. You can use this operation to determine whether a volume
     * is being used or not. This operation is only supported in the cached volume and stored volume gateway types.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListVolumeInitiatorsRequest.Builder} avoiding the
     * need to create one manually via {@link ListVolumeInitiatorsRequest#builder()}
     * </p>
     *
     * @param listVolumeInitiatorsRequest
     *        A {@link Consumer} that will call methods on {@link ListVolumeInitiatorsInput.Builder} to create a
     *        request. ListVolumeInitiatorsInput
     * @return Result of the ListVolumeInitiators operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.ListVolumeInitiators
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ListVolumeInitiators"
     *      target="_top">AWS API Documentation</a>
     */
    default ListVolumeInitiatorsResponse listVolumeInitiators(
            Consumer<ListVolumeInitiatorsRequest.Builder> listVolumeInitiatorsRequest) throws InvalidGatewayRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, StorageGatewayException {
        return listVolumeInitiators(ListVolumeInitiatorsRequest.builder().applyMutation(listVolumeInitiatorsRequest).build());
    }

    /**
     * <p>
     * Lists the recovery points for a specified gateway. This operation is only supported in the cached volume gateway
     * type.
     * </p>
     * <p>
     * Each cache volume has one recovery point. A volume recovery point is a point in time at which all data of the
     * volume is consistent and from which you can create a snapshot or clone a new cached volume from a source volume.
     * To create a snapshot from a volume recovery point use the <a>CreateSnapshotFromVolumeRecoveryPoint</a> operation.
     * </p>
     *
     * @param listVolumeRecoveryPointsRequest
     * @return Result of the ListVolumeRecoveryPoints operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.ListVolumeRecoveryPoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ListVolumeRecoveryPoints"
     *      target="_top">AWS API Documentation</a>
     */
    default ListVolumeRecoveryPointsResponse listVolumeRecoveryPoints(
            ListVolumeRecoveryPointsRequest listVolumeRecoveryPointsRequest) throws InvalidGatewayRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, StorageGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the recovery points for a specified gateway. This operation is only supported in the cached volume gateway
     * type.
     * </p>
     * <p>
     * Each cache volume has one recovery point. A volume recovery point is a point in time at which all data of the
     * volume is consistent and from which you can create a snapshot or clone a new cached volume from a source volume.
     * To create a snapshot from a volume recovery point use the <a>CreateSnapshotFromVolumeRecoveryPoint</a> operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListVolumeRecoveryPointsRequest.Builder} avoiding
     * the need to create one manually via {@link ListVolumeRecoveryPointsRequest#builder()}
     * </p>
     *
     * @param listVolumeRecoveryPointsRequest
     *        A {@link Consumer} that will call methods on {@link ListVolumeRecoveryPointsInput.Builder} to create a
     *        request.
     * @return Result of the ListVolumeRecoveryPoints operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.ListVolumeRecoveryPoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ListVolumeRecoveryPoints"
     *      target="_top">AWS API Documentation</a>
     */
    default ListVolumeRecoveryPointsResponse listVolumeRecoveryPoints(
            Consumer<ListVolumeRecoveryPointsRequest.Builder> listVolumeRecoveryPointsRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        return listVolumeRecoveryPoints(ListVolumeRecoveryPointsRequest.builder().applyMutation(listVolumeRecoveryPointsRequest)
                .build());
    }

    /**
     * <p>
     * Lists the iSCSI stored volumes of a gateway. Results are sorted by volume ARN. The response includes only the
     * volume ARNs. If you want additional volume information, use the <a>DescribeStorediSCSIVolumes</a> or the
     * <a>DescribeCachediSCSIVolumes</a> API.
     * </p>
     * <p>
     * The operation supports pagination. By default, the operation returns a maximum of up to 100 volumes. You can
     * optionally specify the <code>Limit</code> field in the body to limit the number of volumes in the response. If
     * the number of volumes returned in the response is truncated, the response includes a Marker field. You can use
     * this Marker value in your subsequent request to retrieve the next set of volumes. This operation is only
     * supported in the cached volume and stored volume gateway types.
     * </p>
     *
     * @return Result of the ListVolumes operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.ListVolumes
     * @see #listVolumes(ListVolumesRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ListVolumes" target="_top">AWS
     *      API Documentation</a>
     */
    default ListVolumesResponse listVolumes() throws InvalidGatewayRequestException, InternalServerErrorException,
            AwsServiceException, SdkClientException, StorageGatewayException {
        return listVolumes(ListVolumesRequest.builder().build());
    }

    /**
     * <p>
     * Lists the iSCSI stored volumes of a gateway. Results are sorted by volume ARN. The response includes only the
     * volume ARNs. If you want additional volume information, use the <a>DescribeStorediSCSIVolumes</a> or the
     * <a>DescribeCachediSCSIVolumes</a> API.
     * </p>
     * <p>
     * The operation supports pagination. By default, the operation returns a maximum of up to 100 volumes. You can
     * optionally specify the <code>Limit</code> field in the body to limit the number of volumes in the response. If
     * the number of volumes returned in the response is truncated, the response includes a Marker field. You can use
     * this Marker value in your subsequent request to retrieve the next set of volumes. This operation is only
     * supported in the cached volume and stored volume gateway types.
     * </p>
     *
     * @param listVolumesRequest
     *        A JSON object that contains one or more of the following fields:</p>
     *        <ul>
     *        <li>
     *        <p>
     *        <a>ListVolumesInput&#36Limit</a>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <a>ListVolumesInput&#36Marker</a>
     *        </p>
     *        </li>
     * @return Result of the ListVolumes operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.ListVolumes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ListVolumes" target="_top">AWS
     *      API Documentation</a>
     */
    default ListVolumesResponse listVolumes(ListVolumesRequest listVolumesRequest) throws InvalidGatewayRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, StorageGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the iSCSI stored volumes of a gateway. Results are sorted by volume ARN. The response includes only the
     * volume ARNs. If you want additional volume information, use the <a>DescribeStorediSCSIVolumes</a> or the
     * <a>DescribeCachediSCSIVolumes</a> API.
     * </p>
     * <p>
     * The operation supports pagination. By default, the operation returns a maximum of up to 100 volumes. You can
     * optionally specify the <code>Limit</code> field in the body to limit the number of volumes in the response. If
     * the number of volumes returned in the response is truncated, the response includes a Marker field. You can use
     * this Marker value in your subsequent request to retrieve the next set of volumes. This operation is only
     * supported in the cached volume and stored volume gateway types.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListVolumesRequest.Builder} avoiding the need to
     * create one manually via {@link ListVolumesRequest#builder()}
     * </p>
     *
     * @param listVolumesRequest
     *        A {@link Consumer} that will call methods on {@link ListVolumesInput.Builder} to create a request. A JSON
     *        object that contains one or more of the following fields:</p>
     *        <ul>
     *        <li>
     *        <p>
     *        <a>ListVolumesInput&#36Limit</a>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <a>ListVolumesInput&#36Marker</a>
     *        </p>
     *        </li>
     * @return Result of the ListVolumes operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.ListVolumes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ListVolumes" target="_top">AWS
     *      API Documentation</a>
     */
    default ListVolumesResponse listVolumes(Consumer<ListVolumesRequest.Builder> listVolumesRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        return listVolumes(ListVolumesRequest.builder().applyMutation(listVolumesRequest).build());
    }

    /**
     * <p>
     * Lists the iSCSI stored volumes of a gateway. Results are sorted by volume ARN. The response includes only the
     * volume ARNs. If you want additional volume information, use the <a>DescribeStorediSCSIVolumes</a> or the
     * <a>DescribeCachediSCSIVolumes</a> API.
     * </p>
     * <p>
     * The operation supports pagination. By default, the operation returns a maximum of up to 100 volumes. You can
     * optionally specify the <code>Limit</code> field in the body to limit the number of volumes in the response. If
     * the number of volumes returned in the response is truncated, the response includes a Marker field. You can use
     * this Marker value in your subsequent request to retrieve the next set of volumes. This operation is only
     * supported in the cached volume and stored volume gateway types.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listVolumes(software.amazon.awssdk.services.storagegateway.model.ListVolumesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.storagegateway.paginators.ListVolumesIterable responses = client.listVolumesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.storagegateway.paginators.ListVolumesIterable responses = client
     *             .listVolumesPaginator(request);
     *     for (software.amazon.awssdk.services.storagegateway.model.ListVolumesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.storagegateway.paginators.ListVolumesIterable responses = client.listVolumesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listVolumes(software.amazon.awssdk.services.storagegateway.model.ListVolumesRequest)} operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.ListVolumes
     * @see #listVolumesPaginator(ListVolumesRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ListVolumes" target="_top">AWS
     *      API Documentation</a>
     */
    default ListVolumesIterable listVolumesPaginator() throws InvalidGatewayRequestException, InternalServerErrorException,
            AwsServiceException, SdkClientException, StorageGatewayException {
        return listVolumesPaginator(ListVolumesRequest.builder().build());
    }

    /**
     * <p>
     * Lists the iSCSI stored volumes of a gateway. Results are sorted by volume ARN. The response includes only the
     * volume ARNs. If you want additional volume information, use the <a>DescribeStorediSCSIVolumes</a> or the
     * <a>DescribeCachediSCSIVolumes</a> API.
     * </p>
     * <p>
     * The operation supports pagination. By default, the operation returns a maximum of up to 100 volumes. You can
     * optionally specify the <code>Limit</code> field in the body to limit the number of volumes in the response. If
     * the number of volumes returned in the response is truncated, the response includes a Marker field. You can use
     * this Marker value in your subsequent request to retrieve the next set of volumes. This operation is only
     * supported in the cached volume and stored volume gateway types.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listVolumes(software.amazon.awssdk.services.storagegateway.model.ListVolumesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.storagegateway.paginators.ListVolumesIterable responses = client.listVolumesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.storagegateway.paginators.ListVolumesIterable responses = client
     *             .listVolumesPaginator(request);
     *     for (software.amazon.awssdk.services.storagegateway.model.ListVolumesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.storagegateway.paginators.ListVolumesIterable responses = client.listVolumesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listVolumes(software.amazon.awssdk.services.storagegateway.model.ListVolumesRequest)} operation.</b>
     * </p>
     *
     * @param listVolumesRequest
     *        A JSON object that contains one or more of the following fields:</p>
     *        <ul>
     *        <li>
     *        <p>
     *        <a>ListVolumesInput&#36Limit</a>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <a>ListVolumesInput&#36Marker</a>
     *        </p>
     *        </li>
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.ListVolumes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ListVolumes" target="_top">AWS
     *      API Documentation</a>
     */
    default ListVolumesIterable listVolumesPaginator(ListVolumesRequest listVolumesRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the iSCSI stored volumes of a gateway. Results are sorted by volume ARN. The response includes only the
     * volume ARNs. If you want additional volume information, use the <a>DescribeStorediSCSIVolumes</a> or the
     * <a>DescribeCachediSCSIVolumes</a> API.
     * </p>
     * <p>
     * The operation supports pagination. By default, the operation returns a maximum of up to 100 volumes. You can
     * optionally specify the <code>Limit</code> field in the body to limit the number of volumes in the response. If
     * the number of volumes returned in the response is truncated, the response includes a Marker field. You can use
     * this Marker value in your subsequent request to retrieve the next set of volumes. This operation is only
     * supported in the cached volume and stored volume gateway types.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listVolumes(software.amazon.awssdk.services.storagegateway.model.ListVolumesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.storagegateway.paginators.ListVolumesIterable responses = client.listVolumesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.storagegateway.paginators.ListVolumesIterable responses = client
     *             .listVolumesPaginator(request);
     *     for (software.amazon.awssdk.services.storagegateway.model.ListVolumesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.storagegateway.paginators.ListVolumesIterable responses = client.listVolumesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listVolumes(software.amazon.awssdk.services.storagegateway.model.ListVolumesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListVolumesRequest.Builder} avoiding the need to
     * create one manually via {@link ListVolumesRequest#builder()}
     * </p>
     *
     * @param listVolumesRequest
     *        A {@link Consumer} that will call methods on {@link ListVolumesInput.Builder} to create a request. A JSON
     *        object that contains one or more of the following fields:</p>
     *        <ul>
     *        <li>
     *        <p>
     *        <a>ListVolumesInput&#36Limit</a>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <a>ListVolumesInput&#36Marker</a>
     *        </p>
     *        </li>
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.ListVolumes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ListVolumes" target="_top">AWS
     *      API Documentation</a>
     */
    default ListVolumesIterable listVolumesPaginator(Consumer<ListVolumesRequest.Builder> listVolumesRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        return listVolumesPaginator(ListVolumesRequest.builder().applyMutation(listVolumesRequest).build());
    }

    /**
     * <p>
     * Sends you notification through CloudWatch Events when all files written to your file share have been uploaded to
     * S3. Amazon S3.
     * </p>
     * <p>
     * Storage Gateway can send a notification through Amazon CloudWatch Events when all files written to your file
     * share up to that point in time have been uploaded to Amazon S3. These files include files written to the file
     * share up to the time that you make a request for notification. When the upload is done, Storage Gateway sends you
     * notification through an Amazon CloudWatch Event. You can configure CloudWatch Events to send the notification
     * through event targets such as Amazon SNS or Lambda function. This operation is only supported for S3 File
     * Gateways.
     * </p>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/storagegateway/latest/userguide/monitoring-file-gateway.html#get-upload-notification"
     * >Getting file upload notification</a> in the <i>Storage Gateway User Guide</i>.
     * </p>
     *
     * @param notifyWhenUploadedRequest
     * @return Result of the NotifyWhenUploaded operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.NotifyWhenUploaded
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/NotifyWhenUploaded"
     *      target="_top">AWS API Documentation</a>
     */
    default NotifyWhenUploadedResponse notifyWhenUploaded(NotifyWhenUploadedRequest notifyWhenUploadedRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sends you notification through CloudWatch Events when all files written to your file share have been uploaded to
     * S3. Amazon S3.
     * </p>
     * <p>
     * Storage Gateway can send a notification through Amazon CloudWatch Events when all files written to your file
     * share up to that point in time have been uploaded to Amazon S3. These files include files written to the file
     * share up to the time that you make a request for notification. When the upload is done, Storage Gateway sends you
     * notification through an Amazon CloudWatch Event. You can configure CloudWatch Events to send the notification
     * through event targets such as Amazon SNS or Lambda function. This operation is only supported for S3 File
     * Gateways.
     * </p>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/storagegateway/latest/userguide/monitoring-file-gateway.html#get-upload-notification"
     * >Getting file upload notification</a> in the <i>Storage Gateway User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link NotifyWhenUploadedRequest.Builder} avoiding the
     * need to create one manually via {@link NotifyWhenUploadedRequest#builder()}
     * </p>
     *
     * @param notifyWhenUploadedRequest
     *        A {@link Consumer} that will call methods on {@link NotifyWhenUploadedInput.Builder} to create a request.
     * @return Result of the NotifyWhenUploaded operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.NotifyWhenUploaded
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/NotifyWhenUploaded"
     *      target="_top">AWS API Documentation</a>
     */
    default NotifyWhenUploadedResponse notifyWhenUploaded(Consumer<NotifyWhenUploadedRequest.Builder> notifyWhenUploadedRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        return notifyWhenUploaded(NotifyWhenUploadedRequest.builder().applyMutation(notifyWhenUploadedRequest).build());
    }

    /**
     * <p>
     * Refreshes the cached inventory of objects for the specified file share. This operation finds objects in the
     * Amazon S3 bucket that were added, removed, or replaced since the gateway last listed the bucket's contents and
     * cached the results. This operation does not import files into the S3 File Gateway cache storage. It only updates
     * the cached inventory to reflect changes in the inventory of the objects in the S3 bucket. This operation is only
     * supported in the S3 File Gateway types.
     * </p>
     * <p>
     * You can subscribe to be notified through an Amazon CloudWatch event when your <code>RefreshCache</code> operation
     * completes. For more information, see <a href=
     * "https://docs.aws.amazon.com/storagegateway/latest/userguide/monitoring-file-gateway.html#get-notification"
     * >Getting notified about file operations</a> in the <i>Storage Gateway User Guide</i>. This operation is Only
     * supported for S3 File Gateways.
     * </p>
     * <p>
     * When this API is called, it only initiates the refresh operation. When the API call completes and returns a
     * success code, it doesn't necessarily mean that the file refresh has completed. You should use the
     * refresh-complete notification to determine that the operation has completed before you check for new files on the
     * gateway file share. You can subscribe to be notified through a CloudWatch event when your
     * <code>RefreshCache</code> operation completes.
     * </p>
     * <p>
     * Throttle limit: This API is asynchronous, so the gateway will accept no more than two refreshes at any time. We
     * recommend using the refresh-complete CloudWatch event notification before issuing additional requests. For more
     * information, see <a href=
     * "https://docs.aws.amazon.com/storagegateway/latest/userguide/monitoring-file-gateway.html#get-notification"
     * >Getting notified about file operations</a> in the <i>Storage Gateway User Guide</i>.
     * </p>
     * <important>
     * <ul>
     * <li>
     * <p>
     * Wait at least 60 seconds between consecutive RefreshCache API requests.
     * </p>
     * </li>
     * <li>
     * <p>
     * RefreshCache does not evict cache entries if invoked consecutively within 60 seconds of a previous RefreshCache
     * request.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you invoke the RefreshCache API when two requests are already being processed, any new request will cause an
     * <code>InvalidGatewayRequestException</code> error because too many requests were sent to the server.
     * </p>
     * </li>
     * </ul>
     * </important> <note>
     * <p>
     * The S3 bucket name does not need to be included when entering the list of folders in the FolderList parameter.
     * </p>
     * </note>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/storagegateway/latest/userguide/monitoring-file-gateway.html#get-notification"
     * >Getting notified about file operations</a> in the <i>Storage Gateway User Guide</i>.
     * </p>
     *
     * @param refreshCacheRequest
     *        RefreshCacheInput
     * @return Result of the RefreshCache operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.RefreshCache
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/RefreshCache" target="_top">AWS
     *      API Documentation</a>
     */
    default RefreshCacheResponse refreshCache(RefreshCacheRequest refreshCacheRequest) throws InvalidGatewayRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, StorageGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Refreshes the cached inventory of objects for the specified file share. This operation finds objects in the
     * Amazon S3 bucket that were added, removed, or replaced since the gateway last listed the bucket's contents and
     * cached the results. This operation does not import files into the S3 File Gateway cache storage. It only updates
     * the cached inventory to reflect changes in the inventory of the objects in the S3 bucket. This operation is only
     * supported in the S3 File Gateway types.
     * </p>
     * <p>
     * You can subscribe to be notified through an Amazon CloudWatch event when your <code>RefreshCache</code> operation
     * completes. For more information, see <a href=
     * "https://docs.aws.amazon.com/storagegateway/latest/userguide/monitoring-file-gateway.html#get-notification"
     * >Getting notified about file operations</a> in the <i>Storage Gateway User Guide</i>. This operation is Only
     * supported for S3 File Gateways.
     * </p>
     * <p>
     * When this API is called, it only initiates the refresh operation. When the API call completes and returns a
     * success code, it doesn't necessarily mean that the file refresh has completed. You should use the
     * refresh-complete notification to determine that the operation has completed before you check for new files on the
     * gateway file share. You can subscribe to be notified through a CloudWatch event when your
     * <code>RefreshCache</code> operation completes.
     * </p>
     * <p>
     * Throttle limit: This API is asynchronous, so the gateway will accept no more than two refreshes at any time. We
     * recommend using the refresh-complete CloudWatch event notification before issuing additional requests. For more
     * information, see <a href=
     * "https://docs.aws.amazon.com/storagegateway/latest/userguide/monitoring-file-gateway.html#get-notification"
     * >Getting notified about file operations</a> in the <i>Storage Gateway User Guide</i>.
     * </p>
     * <important>
     * <ul>
     * <li>
     * <p>
     * Wait at least 60 seconds between consecutive RefreshCache API requests.
     * </p>
     * </li>
     * <li>
     * <p>
     * RefreshCache does not evict cache entries if invoked consecutively within 60 seconds of a previous RefreshCache
     * request.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you invoke the RefreshCache API when two requests are already being processed, any new request will cause an
     * <code>InvalidGatewayRequestException</code> error because too many requests were sent to the server.
     * </p>
     * </li>
     * </ul>
     * </important> <note>
     * <p>
     * The S3 bucket name does not need to be included when entering the list of folders in the FolderList parameter.
     * </p>
     * </note>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/storagegateway/latest/userguide/monitoring-file-gateway.html#get-notification"
     * >Getting notified about file operations</a> in the <i>Storage Gateway User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RefreshCacheRequest.Builder} avoiding the need to
     * create one manually via {@link RefreshCacheRequest#builder()}
     * </p>
     *
     * @param refreshCacheRequest
     *        A {@link Consumer} that will call methods on {@link RefreshCacheInput.Builder} to create a request.
     *        RefreshCacheInput
     * @return Result of the RefreshCache operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.RefreshCache
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/RefreshCache" target="_top">AWS
     *      API Documentation</a>
     */
    default RefreshCacheResponse refreshCache(Consumer<RefreshCacheRequest.Builder> refreshCacheRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        return refreshCache(RefreshCacheRequest.builder().applyMutation(refreshCacheRequest).build());
    }

    /**
     * <p>
     * Removes one or more tags from the specified resource. This operation is supported in storage gateways of all
     * types.
     * </p>
     *
     * @param removeTagsFromResourceRequest
     *        RemoveTagsFromResourceInput
     * @return Result of the RemoveTagsFromResource operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.RemoveTagsFromResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/RemoveTagsFromResource"
     *      target="_top">AWS API Documentation</a>
     */
    default RemoveTagsFromResourceResponse removeTagsFromResource(RemoveTagsFromResourceRequest removeTagsFromResourceRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes one or more tags from the specified resource. This operation is supported in storage gateways of all
     * types.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RemoveTagsFromResourceRequest.Builder} avoiding the
     * need to create one manually via {@link RemoveTagsFromResourceRequest#builder()}
     * </p>
     *
     * @param removeTagsFromResourceRequest
     *        A {@link Consumer} that will call methods on {@link RemoveTagsFromResourceInput.Builder} to create a
     *        request. RemoveTagsFromResourceInput
     * @return Result of the RemoveTagsFromResource operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.RemoveTagsFromResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/RemoveTagsFromResource"
     *      target="_top">AWS API Documentation</a>
     */
    default RemoveTagsFromResourceResponse removeTagsFromResource(
            Consumer<RemoveTagsFromResourceRequest.Builder> removeTagsFromResourceRequest) throws InvalidGatewayRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, StorageGatewayException {
        return removeTagsFromResource(RemoveTagsFromResourceRequest.builder().applyMutation(removeTagsFromResourceRequest)
                .build());
    }

    /**
     * <p>
     * Resets all cache disks that have encountered an error and makes the disks available for reconfiguration as cache
     * storage. If your cache disk encounters an error, the gateway prevents read and write operations on virtual tapes
     * in the gateway. For example, an error can occur when a disk is corrupted or removed from the gateway. When a
     * cache is reset, the gateway loses its cache storage. At this point, you can reconfigure the disks as cache disks.
     * This operation is only supported in the cached volume and tape types.
     * </p>
     * <important>
     * <p>
     * If the cache disk you are resetting contains data that has not been uploaded to Amazon S3 yet, that data can be
     * lost. After you reset cache disks, there will be no configured cache disks left in the gateway, so you must
     * configure at least one new cache disk for your gateway to function properly.
     * </p>
     * </important>
     *
     * @param resetCacheRequest
     * @return Result of the ResetCache operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.ResetCache
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ResetCache" target="_top">AWS API
     *      Documentation</a>
     */
    default ResetCacheResponse resetCache(ResetCacheRequest resetCacheRequest) throws InvalidGatewayRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, StorageGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Resets all cache disks that have encountered an error and makes the disks available for reconfiguration as cache
     * storage. If your cache disk encounters an error, the gateway prevents read and write operations on virtual tapes
     * in the gateway. For example, an error can occur when a disk is corrupted or removed from the gateway. When a
     * cache is reset, the gateway loses its cache storage. At this point, you can reconfigure the disks as cache disks.
     * This operation is only supported in the cached volume and tape types.
     * </p>
     * <important>
     * <p>
     * If the cache disk you are resetting contains data that has not been uploaded to Amazon S3 yet, that data can be
     * lost. After you reset cache disks, there will be no configured cache disks left in the gateway, so you must
     * configure at least one new cache disk for your gateway to function properly.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ResetCacheRequest.Builder} avoiding the need to
     * create one manually via {@link ResetCacheRequest#builder()}
     * </p>
     *
     * @param resetCacheRequest
     *        A {@link Consumer} that will call methods on {@link ResetCacheInput.Builder} to create a request.
     * @return Result of the ResetCache operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.ResetCache
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ResetCache" target="_top">AWS API
     *      Documentation</a>
     */
    default ResetCacheResponse resetCache(Consumer<ResetCacheRequest.Builder> resetCacheRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        return resetCache(ResetCacheRequest.builder().applyMutation(resetCacheRequest).build());
    }

    /**
     * <p>
     * Retrieves an archived virtual tape from the virtual tape shelf (VTS) to a tape gateway. Virtual tapes archived in
     * the VTS are not associated with any gateway. However after a tape is retrieved, it is associated with a gateway,
     * even though it is also listed in the VTS, that is, archive. This operation is only supported in the tape gateway
     * type.
     * </p>
     * <p>
     * Once a tape is successfully retrieved to a gateway, it cannot be retrieved again to another gateway. You must
     * archive the tape again before you can retrieve it to another gateway. This operation is only supported in the
     * tape gateway type.
     * </p>
     *
     * @param retrieveTapeArchiveRequest
     *        RetrieveTapeArchiveInput
     * @return Result of the RetrieveTapeArchive operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.RetrieveTapeArchive
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/RetrieveTapeArchive"
     *      target="_top">AWS API Documentation</a>
     */
    default RetrieveTapeArchiveResponse retrieveTapeArchive(RetrieveTapeArchiveRequest retrieveTapeArchiveRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves an archived virtual tape from the virtual tape shelf (VTS) to a tape gateway. Virtual tapes archived in
     * the VTS are not associated with any gateway. However after a tape is retrieved, it is associated with a gateway,
     * even though it is also listed in the VTS, that is, archive. This operation is only supported in the tape gateway
     * type.
     * </p>
     * <p>
     * Once a tape is successfully retrieved to a gateway, it cannot be retrieved again to another gateway. You must
     * archive the tape again before you can retrieve it to another gateway. This operation is only supported in the
     * tape gateway type.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RetrieveTapeArchiveRequest.Builder} avoiding the
     * need to create one manually via {@link RetrieveTapeArchiveRequest#builder()}
     * </p>
     *
     * @param retrieveTapeArchiveRequest
     *        A {@link Consumer} that will call methods on {@link RetrieveTapeArchiveInput.Builder} to create a request.
     *        RetrieveTapeArchiveInput
     * @return Result of the RetrieveTapeArchive operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.RetrieveTapeArchive
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/RetrieveTapeArchive"
     *      target="_top">AWS API Documentation</a>
     */
    default RetrieveTapeArchiveResponse retrieveTapeArchive(
            Consumer<RetrieveTapeArchiveRequest.Builder> retrieveTapeArchiveRequest) throws InvalidGatewayRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, StorageGatewayException {
        return retrieveTapeArchive(RetrieveTapeArchiveRequest.builder().applyMutation(retrieveTapeArchiveRequest).build());
    }

    /**
     * <p>
     * Retrieves the recovery point for the specified virtual tape. This operation is only supported in the tape gateway
     * type.
     * </p>
     * <p>
     * A recovery point is a point in time view of a virtual tape at which all the data on the tape is consistent. If
     * your gateway crashes, virtual tapes that have recovery points can be recovered to a new gateway.
     * </p>
     * <note>
     * <p>
     * The virtual tape can be retrieved to only one gateway. The retrieved tape is read-only. The virtual tape can be
     * retrieved to only a tape gateway. There is no charge for retrieving recovery points.
     * </p>
     * </note>
     *
     * @param retrieveTapeRecoveryPointRequest
     *        RetrieveTapeRecoveryPointInput
     * @return Result of the RetrieveTapeRecoveryPoint operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.RetrieveTapeRecoveryPoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/RetrieveTapeRecoveryPoint"
     *      target="_top">AWS API Documentation</a>
     */
    default RetrieveTapeRecoveryPointResponse retrieveTapeRecoveryPoint(
            RetrieveTapeRecoveryPointRequest retrieveTapeRecoveryPointRequest) throws InvalidGatewayRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, StorageGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the recovery point for the specified virtual tape. This operation is only supported in the tape gateway
     * type.
     * </p>
     * <p>
     * A recovery point is a point in time view of a virtual tape at which all the data on the tape is consistent. If
     * your gateway crashes, virtual tapes that have recovery points can be recovered to a new gateway.
     * </p>
     * <note>
     * <p>
     * The virtual tape can be retrieved to only one gateway. The retrieved tape is read-only. The virtual tape can be
     * retrieved to only a tape gateway. There is no charge for retrieving recovery points.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RetrieveTapeRecoveryPointRequest.Builder} avoiding
     * the need to create one manually via {@link RetrieveTapeRecoveryPointRequest#builder()}
     * </p>
     *
     * @param retrieveTapeRecoveryPointRequest
     *        A {@link Consumer} that will call methods on {@link RetrieveTapeRecoveryPointInput.Builder} to create a
     *        request. RetrieveTapeRecoveryPointInput
     * @return Result of the RetrieveTapeRecoveryPoint operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.RetrieveTapeRecoveryPoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/RetrieveTapeRecoveryPoint"
     *      target="_top">AWS API Documentation</a>
     */
    default RetrieveTapeRecoveryPointResponse retrieveTapeRecoveryPoint(
            Consumer<RetrieveTapeRecoveryPointRequest.Builder> retrieveTapeRecoveryPointRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        return retrieveTapeRecoveryPoint(RetrieveTapeRecoveryPointRequest.builder()
                .applyMutation(retrieveTapeRecoveryPointRequest).build());
    }

    /**
     * <p>
     * Sets the password for your VM local console. When you log in to the local console for the first time, you log in
     * to the VM with the default credentials. We recommend that you set a new password. You don't need to know the
     * default password to set a new password.
     * </p>
     *
     * @param setLocalConsolePasswordRequest
     *        SetLocalConsolePasswordInput
     * @return Result of the SetLocalConsolePassword operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.SetLocalConsolePassword
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/SetLocalConsolePassword"
     *      target="_top">AWS API Documentation</a>
     */
    default SetLocalConsolePasswordResponse setLocalConsolePassword(SetLocalConsolePasswordRequest setLocalConsolePasswordRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets the password for your VM local console. When you log in to the local console for the first time, you log in
     * to the VM with the default credentials. We recommend that you set a new password. You don't need to know the
     * default password to set a new password.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SetLocalConsolePasswordRequest.Builder} avoiding
     * the need to create one manually via {@link SetLocalConsolePasswordRequest#builder()}
     * </p>
     *
     * @param setLocalConsolePasswordRequest
     *        A {@link Consumer} that will call methods on {@link SetLocalConsolePasswordInput.Builder} to create a
     *        request. SetLocalConsolePasswordInput
     * @return Result of the SetLocalConsolePassword operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.SetLocalConsolePassword
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/SetLocalConsolePassword"
     *      target="_top">AWS API Documentation</a>
     */
    default SetLocalConsolePasswordResponse setLocalConsolePassword(
            Consumer<SetLocalConsolePasswordRequest.Builder> setLocalConsolePasswordRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        return setLocalConsolePassword(SetLocalConsolePasswordRequest.builder().applyMutation(setLocalConsolePasswordRequest)
                .build());
    }

    /**
     * <p>
     * Sets the password for the guest user <code>smbguest</code>. The <code>smbguest</code> user is the user when the
     * authentication method for the file share is set to <code>GuestAccess</code>. This operation only supported for S3
     * File Gateways
     * </p>
     *
     * @param setSmbGuestPasswordRequest
     *        SetSMBGuestPasswordInput
     * @return Result of the SetSMBGuestPassword operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.SetSMBGuestPassword
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/SetSMBGuestPassword"
     *      target="_top">AWS API Documentation</a>
     */
    default SetSmbGuestPasswordResponse setSMBGuestPassword(SetSmbGuestPasswordRequest setSmbGuestPasswordRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets the password for the guest user <code>smbguest</code>. The <code>smbguest</code> user is the user when the
     * authentication method for the file share is set to <code>GuestAccess</code>. This operation only supported for S3
     * File Gateways
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SetSmbGuestPasswordRequest.Builder} avoiding the
     * need to create one manually via {@link SetSmbGuestPasswordRequest#builder()}
     * </p>
     *
     * @param setSmbGuestPasswordRequest
     *        A {@link Consumer} that will call methods on {@link SetSMBGuestPasswordInput.Builder} to create a request.
     *        SetSMBGuestPasswordInput
     * @return Result of the SetSMBGuestPassword operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.SetSMBGuestPassword
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/SetSMBGuestPassword"
     *      target="_top">AWS API Documentation</a>
     */
    default SetSmbGuestPasswordResponse setSMBGuestPassword(
            Consumer<SetSmbGuestPasswordRequest.Builder> setSmbGuestPasswordRequest) throws InvalidGatewayRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, StorageGatewayException {
        return setSMBGuestPassword(SetSmbGuestPasswordRequest.builder().applyMutation(setSmbGuestPasswordRequest).build());
    }

    /**
     * <p>
     * Shuts down a gateway. To specify which gateway to shut down, use the Amazon Resource Name (ARN) of the gateway in
     * the body of your request.
     * </p>
     * <p>
     * The operation shuts down the gateway service component running in the gateway's virtual machine (VM) and not the
     * host VM.
     * </p>
     * <note>
     * <p>
     * If you want to shut down the VM, it is recommended that you first shut down the gateway component in the VM to
     * avoid unpredictable conditions.
     * </p>
     * </note>
     * <p>
     * After the gateway is shutdown, you cannot call any other API except <a>StartGateway</a>,
     * <a>DescribeGatewayInformation</a>, and <a>ListGateways</a>. For more information, see <a>ActivateGateway</a>.
     * Your applications cannot read from or write to the gateway's storage volumes, and there are no snapshots taken.
     * </p>
     * <note>
     * <p>
     * When you make a shutdown request, you will get a <code>200 OK</code> success response immediately. However, it
     * might take some time for the gateway to shut down. You can call the <a>DescribeGatewayInformation</a> API to
     * check the status. For more information, see <a>ActivateGateway</a>.
     * </p>
     * </note>
     * <p>
     * If do not intend to use the gateway again, you must delete the gateway (using <a>DeleteGateway</a>) to no longer
     * pay software charges associated with the gateway.
     * </p>
     *
     * @param shutdownGatewayRequest
     *        A JSON object containing the Amazon Resource Name (ARN) of the gateway to shut down.
     * @return Result of the ShutdownGateway operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.ShutdownGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ShutdownGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default ShutdownGatewayResponse shutdownGateway(ShutdownGatewayRequest shutdownGatewayRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Shuts down a gateway. To specify which gateway to shut down, use the Amazon Resource Name (ARN) of the gateway in
     * the body of your request.
     * </p>
     * <p>
     * The operation shuts down the gateway service component running in the gateway's virtual machine (VM) and not the
     * host VM.
     * </p>
     * <note>
     * <p>
     * If you want to shut down the VM, it is recommended that you first shut down the gateway component in the VM to
     * avoid unpredictable conditions.
     * </p>
     * </note>
     * <p>
     * After the gateway is shutdown, you cannot call any other API except <a>StartGateway</a>,
     * <a>DescribeGatewayInformation</a>, and <a>ListGateways</a>. For more information, see <a>ActivateGateway</a>.
     * Your applications cannot read from or write to the gateway's storage volumes, and there are no snapshots taken.
     * </p>
     * <note>
     * <p>
     * When you make a shutdown request, you will get a <code>200 OK</code> success response immediately. However, it
     * might take some time for the gateway to shut down. You can call the <a>DescribeGatewayInformation</a> API to
     * check the status. For more information, see <a>ActivateGateway</a>.
     * </p>
     * </note>
     * <p>
     * If do not intend to use the gateway again, you must delete the gateway (using <a>DeleteGateway</a>) to no longer
     * pay software charges associated with the gateway.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ShutdownGatewayRequest.Builder} avoiding the need
     * to create one manually via {@link ShutdownGatewayRequest#builder()}
     * </p>
     *
     * @param shutdownGatewayRequest
     *        A {@link Consumer} that will call methods on {@link ShutdownGatewayInput.Builder} to create a request. A
     *        JSON object containing the Amazon Resource Name (ARN) of the gateway to shut down.
     * @return Result of the ShutdownGateway operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.ShutdownGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ShutdownGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default ShutdownGatewayResponse shutdownGateway(Consumer<ShutdownGatewayRequest.Builder> shutdownGatewayRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        return shutdownGateway(ShutdownGatewayRequest.builder().applyMutation(shutdownGatewayRequest).build());
    }

    /**
     * <p>
     * Start a test that verifies that the specified gateway is configured for High Availability monitoring in your host
     * environment. This request only initiates the test and that a successful response only indicates that the test was
     * started. It doesn't indicate that the test passed. For the status of the test, invoke the
     * <code>DescribeAvailabilityMonitorTest</code> API.
     * </p>
     * <note>
     * <p>
     * Starting this test will cause your gateway to go offline for a brief period.
     * </p>
     * </note>
     *
     * @param startAvailabilityMonitorTestRequest
     * @return Result of the StartAvailabilityMonitorTest operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.StartAvailabilityMonitorTest
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/StartAvailabilityMonitorTest"
     *      target="_top">AWS API Documentation</a>
     */
    default StartAvailabilityMonitorTestResponse startAvailabilityMonitorTest(
            StartAvailabilityMonitorTestRequest startAvailabilityMonitorTestRequest) throws InvalidGatewayRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, StorageGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Start a test that verifies that the specified gateway is configured for High Availability monitoring in your host
     * environment. This request only initiates the test and that a successful response only indicates that the test was
     * started. It doesn't indicate that the test passed. For the status of the test, invoke the
     * <code>DescribeAvailabilityMonitorTest</code> API.
     * </p>
     * <note>
     * <p>
     * Starting this test will cause your gateway to go offline for a brief period.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartAvailabilityMonitorTestRequest.Builder}
     * avoiding the need to create one manually via {@link StartAvailabilityMonitorTestRequest#builder()}
     * </p>
     *
     * @param startAvailabilityMonitorTestRequest
     *        A {@link Consumer} that will call methods on {@link StartAvailabilityMonitorTestInput.Builder} to create a
     *        request.
     * @return Result of the StartAvailabilityMonitorTest operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.StartAvailabilityMonitorTest
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/StartAvailabilityMonitorTest"
     *      target="_top">AWS API Documentation</a>
     */
    default StartAvailabilityMonitorTestResponse startAvailabilityMonitorTest(
            Consumer<StartAvailabilityMonitorTestRequest.Builder> startAvailabilityMonitorTestRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        return startAvailabilityMonitorTest(StartAvailabilityMonitorTestRequest.builder()
                .applyMutation(startAvailabilityMonitorTestRequest).build());
    }

    /**
     * <p>
     * Starts a gateway that you previously shut down (see <a>ShutdownGateway</a>). After the gateway starts, you can
     * then make other API calls, your applications can read from or write to the gateway's storage volumes and you will
     * be able to take snapshot backups.
     * </p>
     * <note>
     * <p>
     * When you make a request, you will get a 200 OK success response immediately. However, it might take some time for
     * the gateway to be ready. You should call <a>DescribeGatewayInformation</a> and check the status before making any
     * additional API calls. For more information, see <a>ActivateGateway</a>.
     * </p>
     * </note>
     * <p>
     * To specify which gateway to start, use the Amazon Resource Name (ARN) of the gateway in your request.
     * </p>
     *
     * @param startGatewayRequest
     *        A JSON object containing the Amazon Resource Name (ARN) of the gateway to start.
     * @return Result of the StartGateway operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.StartGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/StartGateway" target="_top">AWS
     *      API Documentation</a>
     */
    default StartGatewayResponse startGateway(StartGatewayRequest startGatewayRequest) throws InvalidGatewayRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, StorageGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a gateway that you previously shut down (see <a>ShutdownGateway</a>). After the gateway starts, you can
     * then make other API calls, your applications can read from or write to the gateway's storage volumes and you will
     * be able to take snapshot backups.
     * </p>
     * <note>
     * <p>
     * When you make a request, you will get a 200 OK success response immediately. However, it might take some time for
     * the gateway to be ready. You should call <a>DescribeGatewayInformation</a> and check the status before making any
     * additional API calls. For more information, see <a>ActivateGateway</a>.
     * </p>
     * </note>
     * <p>
     * To specify which gateway to start, use the Amazon Resource Name (ARN) of the gateway in your request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartGatewayRequest.Builder} avoiding the need to
     * create one manually via {@link StartGatewayRequest#builder()}
     * </p>
     *
     * @param startGatewayRequest
     *        A {@link Consumer} that will call methods on {@link StartGatewayInput.Builder} to create a request. A JSON
     *        object containing the Amazon Resource Name (ARN) of the gateway to start.
     * @return Result of the StartGateway operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.StartGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/StartGateway" target="_top">AWS
     *      API Documentation</a>
     */
    default StartGatewayResponse startGateway(Consumer<StartGatewayRequest.Builder> startGatewayRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        return startGateway(StartGatewayRequest.builder().applyMutation(startGatewayRequest).build());
    }

    /**
     * <p>
     * Updates the automatic tape creation policy of a gateway. Use this to update the policy with a new set of
     * automatic tape creation rules. This is only supported for tape gateways.
     * </p>
     * <p>
     * By default, there is no automatic tape creation policy.
     * </p>
     * <note>
     * <p>
     * A gateway can have only one automatic tape creation policy.
     * </p>
     * </note>
     *
     * @param updateAutomaticTapeCreationPolicyRequest
     * @return Result of the UpdateAutomaticTapeCreationPolicy operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.UpdateAutomaticTapeCreationPolicy
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/UpdateAutomaticTapeCreationPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateAutomaticTapeCreationPolicyResponse updateAutomaticTapeCreationPolicy(
            UpdateAutomaticTapeCreationPolicyRequest updateAutomaticTapeCreationPolicyRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the automatic tape creation policy of a gateway. Use this to update the policy with a new set of
     * automatic tape creation rules. This is only supported for tape gateways.
     * </p>
     * <p>
     * By default, there is no automatic tape creation policy.
     * </p>
     * <note>
     * <p>
     * A gateway can have only one automatic tape creation policy.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAutomaticTapeCreationPolicyRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateAutomaticTapeCreationPolicyRequest#builder()}
     * </p>
     *
     * @param updateAutomaticTapeCreationPolicyRequest
     *        A {@link Consumer} that will call methods on {@link UpdateAutomaticTapeCreationPolicyInput.Builder} to
     *        create a request.
     * @return Result of the UpdateAutomaticTapeCreationPolicy operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.UpdateAutomaticTapeCreationPolicy
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/UpdateAutomaticTapeCreationPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateAutomaticTapeCreationPolicyResponse updateAutomaticTapeCreationPolicy(
            Consumer<UpdateAutomaticTapeCreationPolicyRequest.Builder> updateAutomaticTapeCreationPolicyRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        return updateAutomaticTapeCreationPolicy(UpdateAutomaticTapeCreationPolicyRequest.builder()
                .applyMutation(updateAutomaticTapeCreationPolicyRequest).build());
    }

    /**
     * <p>
     * Updates the bandwidth rate limits of a gateway. You can update both the upload and download bandwidth rate limit
     * or specify only one of the two. If you don't set a bandwidth rate limit, the existing rate limit remains. This
     * operation is supported only for the stored volume, cached volume, and tape gateway types. To update bandwidth
     * rate limits for S3 file gateways, use <a>UpdateBandwidthRateLimitSchedule</a>.
     * </p>
     * <p>
     * By default, a gateway's bandwidth rate limits are not set. If you don't set any limit, the gateway does not have
     * any limitations on its bandwidth usage and could potentially use the maximum available bandwidth.
     * </p>
     * <p>
     * To specify which gateway to update, use the Amazon Resource Name (ARN) of the gateway in your request.
     * </p>
     *
     * @param updateBandwidthRateLimitRequest
     *        A JSON object containing one or more of the following fields:</p>
     *        <ul>
     *        <li>
     *        <p>
     *        <a>UpdateBandwidthRateLimitInput&#36AverageDownloadRateLimitInBitsPerSec</a>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <a>UpdateBandwidthRateLimitInput&#36AverageUploadRateLimitInBitsPerSec</a>
     *        </p>
     *        </li>
     * @return Result of the UpdateBandwidthRateLimit operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.UpdateBandwidthRateLimit
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/UpdateBandwidthRateLimit"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateBandwidthRateLimitResponse updateBandwidthRateLimit(
            UpdateBandwidthRateLimitRequest updateBandwidthRateLimitRequest) throws InvalidGatewayRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, StorageGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the bandwidth rate limits of a gateway. You can update both the upload and download bandwidth rate limit
     * or specify only one of the two. If you don't set a bandwidth rate limit, the existing rate limit remains. This
     * operation is supported only for the stored volume, cached volume, and tape gateway types. To update bandwidth
     * rate limits for S3 file gateways, use <a>UpdateBandwidthRateLimitSchedule</a>.
     * </p>
     * <p>
     * By default, a gateway's bandwidth rate limits are not set. If you don't set any limit, the gateway does not have
     * any limitations on its bandwidth usage and could potentially use the maximum available bandwidth.
     * </p>
     * <p>
     * To specify which gateway to update, use the Amazon Resource Name (ARN) of the gateway in your request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateBandwidthRateLimitRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateBandwidthRateLimitRequest#builder()}
     * </p>
     *
     * @param updateBandwidthRateLimitRequest
     *        A {@link Consumer} that will call methods on {@link UpdateBandwidthRateLimitInput.Builder} to create a
     *        request. A JSON object containing one or more of the following fields:</p>
     *        <ul>
     *        <li>
     *        <p>
     *        <a>UpdateBandwidthRateLimitInput&#36AverageDownloadRateLimitInBitsPerSec</a>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <a>UpdateBandwidthRateLimitInput&#36AverageUploadRateLimitInBitsPerSec</a>
     *        </p>
     *        </li>
     * @return Result of the UpdateBandwidthRateLimit operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.UpdateBandwidthRateLimit
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/UpdateBandwidthRateLimit"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateBandwidthRateLimitResponse updateBandwidthRateLimit(
            Consumer<UpdateBandwidthRateLimitRequest.Builder> updateBandwidthRateLimitRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        return updateBandwidthRateLimit(UpdateBandwidthRateLimitRequest.builder().applyMutation(updateBandwidthRateLimitRequest)
                .build());
    }

    /**
     * <p>
     * Updates the bandwidth rate limit schedule for a specified gateway. By default, gateways do not have bandwidth
     * rate limit schedules, which means no bandwidth rate limiting is in effect. Use this to initiate or update a
     * gateway's bandwidth rate limit schedule. This operation is supported only for volume, tape and S3 file gateways.
     * FSx file gateways do not support bandwidth rate limits.
     * </p>
     *
     * @param updateBandwidthRateLimitScheduleRequest
     * @return Result of the UpdateBandwidthRateLimitSchedule operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.UpdateBandwidthRateLimitSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/UpdateBandwidthRateLimitSchedule"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateBandwidthRateLimitScheduleResponse updateBandwidthRateLimitSchedule(
            UpdateBandwidthRateLimitScheduleRequest updateBandwidthRateLimitScheduleRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the bandwidth rate limit schedule for a specified gateway. By default, gateways do not have bandwidth
     * rate limit schedules, which means no bandwidth rate limiting is in effect. Use this to initiate or update a
     * gateway's bandwidth rate limit schedule. This operation is supported only for volume, tape and S3 file gateways.
     * FSx file gateways do not support bandwidth rate limits.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateBandwidthRateLimitScheduleRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateBandwidthRateLimitScheduleRequest#builder()}
     * </p>
     *
     * @param updateBandwidthRateLimitScheduleRequest
     *        A {@link Consumer} that will call methods on {@link UpdateBandwidthRateLimitScheduleInput.Builder} to
     *        create a request.
     * @return Result of the UpdateBandwidthRateLimitSchedule operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.UpdateBandwidthRateLimitSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/UpdateBandwidthRateLimitSchedule"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateBandwidthRateLimitScheduleResponse updateBandwidthRateLimitSchedule(
            Consumer<UpdateBandwidthRateLimitScheduleRequest.Builder> updateBandwidthRateLimitScheduleRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        return updateBandwidthRateLimitSchedule(UpdateBandwidthRateLimitScheduleRequest.builder()
                .applyMutation(updateBandwidthRateLimitScheduleRequest).build());
    }

    /**
     * <p>
     * Updates the Challenge-Handshake Authentication Protocol (CHAP) credentials for a specified iSCSI target. By
     * default, a gateway does not have CHAP enabled; however, for added security, you might use it. This operation is
     * supported in the volume and tape gateway types.
     * </p>
     * <important>
     * <p>
     * When you update CHAP credentials, all existing connections on the target are closed and initiators must reconnect
     * with the new credentials.
     * </p>
     * </important>
     *
     * @param updateChapCredentialsRequest
     *        A JSON object containing one or more of the following fields:</p>
     *        <ul>
     *        <li>
     *        <p>
     *        <a>UpdateChapCredentialsInput&#36InitiatorName</a>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <a>UpdateChapCredentialsInput&#36SecretToAuthenticateInitiator</a>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <a>UpdateChapCredentialsInput&#36SecretToAuthenticateTarget</a>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <a>UpdateChapCredentialsInput&#36TargetARN</a>
     *        </p>
     *        </li>
     * @return Result of the UpdateChapCredentials operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.UpdateChapCredentials
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/UpdateChapCredentials"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateChapCredentialsResponse updateChapCredentials(UpdateChapCredentialsRequest updateChapCredentialsRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the Challenge-Handshake Authentication Protocol (CHAP) credentials for a specified iSCSI target. By
     * default, a gateway does not have CHAP enabled; however, for added security, you might use it. This operation is
     * supported in the volume and tape gateway types.
     * </p>
     * <important>
     * <p>
     * When you update CHAP credentials, all existing connections on the target are closed and initiators must reconnect
     * with the new credentials.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateChapCredentialsRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateChapCredentialsRequest#builder()}
     * </p>
     *
     * @param updateChapCredentialsRequest
     *        A {@link Consumer} that will call methods on {@link UpdateChapCredentialsInput.Builder} to create a
     *        request. A JSON object containing one or more of the following fields:</p>
     *        <ul>
     *        <li>
     *        <p>
     *        <a>UpdateChapCredentialsInput&#36InitiatorName</a>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <a>UpdateChapCredentialsInput&#36SecretToAuthenticateInitiator</a>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <a>UpdateChapCredentialsInput&#36SecretToAuthenticateTarget</a>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <a>UpdateChapCredentialsInput&#36TargetARN</a>
     *        </p>
     *        </li>
     * @return Result of the UpdateChapCredentials operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.UpdateChapCredentials
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/UpdateChapCredentials"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateChapCredentialsResponse updateChapCredentials(
            Consumer<UpdateChapCredentialsRequest.Builder> updateChapCredentialsRequest) throws InvalidGatewayRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, StorageGatewayException {
        return updateChapCredentials(UpdateChapCredentialsRequest.builder().applyMutation(updateChapCredentialsRequest).build());
    }

    /**
     * <p>
     * Updates a file system association. This operation is only supported in the FSx File Gateways.
     * </p>
     *
     * @param updateFileSystemAssociationRequest
     * @return Result of the UpdateFileSystemAssociation operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.UpdateFileSystemAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/UpdateFileSystemAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateFileSystemAssociationResponse updateFileSystemAssociation(
            UpdateFileSystemAssociationRequest updateFileSystemAssociationRequest) throws InvalidGatewayRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, StorageGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a file system association. This operation is only supported in the FSx File Gateways.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateFileSystemAssociationRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateFileSystemAssociationRequest#builder()}
     * </p>
     *
     * @param updateFileSystemAssociationRequest
     *        A {@link Consumer} that will call methods on {@link UpdateFileSystemAssociationInput.Builder} to create a
     *        request.
     * @return Result of the UpdateFileSystemAssociation operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.UpdateFileSystemAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/UpdateFileSystemAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateFileSystemAssociationResponse updateFileSystemAssociation(
            Consumer<UpdateFileSystemAssociationRequest.Builder> updateFileSystemAssociationRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        return updateFileSystemAssociation(UpdateFileSystemAssociationRequest.builder()
                .applyMutation(updateFileSystemAssociationRequest).build());
    }

    /**
     * <p>
     * Updates a gateway's metadata, which includes the gateway's name and time zone. To specify which gateway to
     * update, use the Amazon Resource Name (ARN) of the gateway in your request.
     * </p>
     * <note>
     * <p>
     * For gateways activated after September 2, 2015, the gateway's ARN contains the gateway ID rather than the gateway
     * name. However, changing the name of the gateway has no effect on the gateway's ARN.
     * </p>
     * </note>
     *
     * @param updateGatewayInformationRequest
     * @return Result of the UpdateGatewayInformation operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.UpdateGatewayInformation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/UpdateGatewayInformation"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateGatewayInformationResponse updateGatewayInformation(
            UpdateGatewayInformationRequest updateGatewayInformationRequest) throws InvalidGatewayRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, StorageGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a gateway's metadata, which includes the gateway's name and time zone. To specify which gateway to
     * update, use the Amazon Resource Name (ARN) of the gateway in your request.
     * </p>
     * <note>
     * <p>
     * For gateways activated after September 2, 2015, the gateway's ARN contains the gateway ID rather than the gateway
     * name. However, changing the name of the gateway has no effect on the gateway's ARN.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateGatewayInformationRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateGatewayInformationRequest#builder()}
     * </p>
     *
     * @param updateGatewayInformationRequest
     *        A {@link Consumer} that will call methods on {@link UpdateGatewayInformationInput.Builder} to create a
     *        request.
     * @return Result of the UpdateGatewayInformation operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.UpdateGatewayInformation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/UpdateGatewayInformation"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateGatewayInformationResponse updateGatewayInformation(
            Consumer<UpdateGatewayInformationRequest.Builder> updateGatewayInformationRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        return updateGatewayInformation(UpdateGatewayInformationRequest.builder().applyMutation(updateGatewayInformationRequest)
                .build());
    }

    /**
     * <p>
     * Updates the gateway virtual machine (VM) software. The request immediately triggers the software update.
     * </p>
     * <note>
     * <p>
     * When you make this request, you get a <code>200 OK</code> success response immediately. However, it might take
     * some time for the update to complete. You can call <a>DescribeGatewayInformation</a> to verify the gateway is in
     * the <code>STATE_RUNNING</code> state.
     * </p>
     * </note> <important>
     * <p>
     * A software update forces a system restart of your gateway. You can minimize the chance of any disruption to your
     * applications by increasing your iSCSI Initiators' timeouts. For more information about increasing iSCSI Initiator
     * timeouts for Windows and Linux, see <a href=
     * "https://docs.aws.amazon.com/storagegateway/latest/userguide/ConfiguringiSCSIClientInitiatorWindowsClient.html#CustomizeWindowsiSCSISettings"
     * >Customizing your Windows iSCSI settings</a> and <a href=
     * "https://docs.aws.amazon.com/storagegateway/latest/userguide/ConfiguringiSCSIClientInitiatorRedHatClient.html#CustomizeLinuxiSCSISettings"
     * >Customizing your Linux iSCSI settings</a>, respectively.
     * </p>
     * </important>
     *
     * @param updateGatewaySoftwareNowRequest
     *        A JSON object containing the Amazon Resource Name (ARN) of the gateway to update.
     * @return Result of the UpdateGatewaySoftwareNow operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.UpdateGatewaySoftwareNow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/UpdateGatewaySoftwareNow"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateGatewaySoftwareNowResponse updateGatewaySoftwareNow(
            UpdateGatewaySoftwareNowRequest updateGatewaySoftwareNowRequest) throws InvalidGatewayRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, StorageGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the gateway virtual machine (VM) software. The request immediately triggers the software update.
     * </p>
     * <note>
     * <p>
     * When you make this request, you get a <code>200 OK</code> success response immediately. However, it might take
     * some time for the update to complete. You can call <a>DescribeGatewayInformation</a> to verify the gateway is in
     * the <code>STATE_RUNNING</code> state.
     * </p>
     * </note> <important>
     * <p>
     * A software update forces a system restart of your gateway. You can minimize the chance of any disruption to your
     * applications by increasing your iSCSI Initiators' timeouts. For more information about increasing iSCSI Initiator
     * timeouts for Windows and Linux, see <a href=
     * "https://docs.aws.amazon.com/storagegateway/latest/userguide/ConfiguringiSCSIClientInitiatorWindowsClient.html#CustomizeWindowsiSCSISettings"
     * >Customizing your Windows iSCSI settings</a> and <a href=
     * "https://docs.aws.amazon.com/storagegateway/latest/userguide/ConfiguringiSCSIClientInitiatorRedHatClient.html#CustomizeLinuxiSCSISettings"
     * >Customizing your Linux iSCSI settings</a>, respectively.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateGatewaySoftwareNowRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateGatewaySoftwareNowRequest#builder()}
     * </p>
     *
     * @param updateGatewaySoftwareNowRequest
     *        A {@link Consumer} that will call methods on {@link UpdateGatewaySoftwareNowInput.Builder} to create a
     *        request. A JSON object containing the Amazon Resource Name (ARN) of the gateway to update.
     * @return Result of the UpdateGatewaySoftwareNow operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.UpdateGatewaySoftwareNow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/UpdateGatewaySoftwareNow"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateGatewaySoftwareNowResponse updateGatewaySoftwareNow(
            Consumer<UpdateGatewaySoftwareNowRequest.Builder> updateGatewaySoftwareNowRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        return updateGatewaySoftwareNow(UpdateGatewaySoftwareNowRequest.builder().applyMutation(updateGatewaySoftwareNowRequest)
                .build());
    }

    /**
     * <p>
     * Updates a gateway's weekly maintenance start time information, including day and time of the week. The
     * maintenance time is the time in your gateway's time zone.
     * </p>
     *
     * @param updateMaintenanceStartTimeRequest
     *        A JSON object containing the following fields:</p>
     *        <ul>
     *        <li>
     *        <p>
     *        <a>UpdateMaintenanceStartTimeInput&#36DayOfMonth</a>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <a>UpdateMaintenanceStartTimeInput&#36DayOfWeek</a>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <a>UpdateMaintenanceStartTimeInput&#36HourOfDay</a>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <a>UpdateMaintenanceStartTimeInput&#36MinuteOfHour</a>
     *        </p>
     *        </li>
     * @return Result of the UpdateMaintenanceStartTime operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.UpdateMaintenanceStartTime
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/UpdateMaintenanceStartTime"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateMaintenanceStartTimeResponse updateMaintenanceStartTime(
            UpdateMaintenanceStartTimeRequest updateMaintenanceStartTimeRequest) throws InvalidGatewayRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, StorageGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a gateway's weekly maintenance start time information, including day and time of the week. The
     * maintenance time is the time in your gateway's time zone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateMaintenanceStartTimeRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateMaintenanceStartTimeRequest#builder()}
     * </p>
     *
     * @param updateMaintenanceStartTimeRequest
     *        A {@link Consumer} that will call methods on {@link UpdateMaintenanceStartTimeInput.Builder} to create a
     *        request. A JSON object containing the following fields:</p>
     *        <ul>
     *        <li>
     *        <p>
     *        <a>UpdateMaintenanceStartTimeInput&#36DayOfMonth</a>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <a>UpdateMaintenanceStartTimeInput&#36DayOfWeek</a>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <a>UpdateMaintenanceStartTimeInput&#36HourOfDay</a>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <a>UpdateMaintenanceStartTimeInput&#36MinuteOfHour</a>
     *        </p>
     *        </li>
     * @return Result of the UpdateMaintenanceStartTime operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.UpdateMaintenanceStartTime
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/UpdateMaintenanceStartTime"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateMaintenanceStartTimeResponse updateMaintenanceStartTime(
            Consumer<UpdateMaintenanceStartTimeRequest.Builder> updateMaintenanceStartTimeRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        return updateMaintenanceStartTime(UpdateMaintenanceStartTimeRequest.builder()
                .applyMutation(updateMaintenanceStartTimeRequest).build());
    }

    /**
     * <p>
     * Updates a Network File System (NFS) file share. This operation is only supported in S3 File Gateways.
     * </p>
     * <note>
     * <p>
     * To leave a file share field unchanged, set the corresponding input field to null.
     * </p>
     * </note>
     * <p>
     * Updates the following file share settings:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Default storage class for your S3 bucket
     * </p>
     * </li>
     * <li>
     * <p>
     * Metadata defaults for your S3 bucket
     * </p>
     * </li>
     * <li>
     * <p>
     * Allowed NFS clients for your file share
     * </p>
     * </li>
     * <li>
     * <p>
     * Squash settings
     * </p>
     * </li>
     * <li>
     * <p>
     * Write status of your file share
     * </p>
     * </li>
     * </ul>
     *
     * @param updateNfsFileShareRequest
     *        UpdateNFSFileShareInput
     * @return Result of the UpdateNFSFileShare operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.UpdateNFSFileShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/UpdateNFSFileShare"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateNfsFileShareResponse updateNFSFileShare(UpdateNfsFileShareRequest updateNfsFileShareRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a Network File System (NFS) file share. This operation is only supported in S3 File Gateways.
     * </p>
     * <note>
     * <p>
     * To leave a file share field unchanged, set the corresponding input field to null.
     * </p>
     * </note>
     * <p>
     * Updates the following file share settings:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Default storage class for your S3 bucket
     * </p>
     * </li>
     * <li>
     * <p>
     * Metadata defaults for your S3 bucket
     * </p>
     * </li>
     * <li>
     * <p>
     * Allowed NFS clients for your file share
     * </p>
     * </li>
     * <li>
     * <p>
     * Squash settings
     * </p>
     * </li>
     * <li>
     * <p>
     * Write status of your file share
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateNfsFileShareRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateNfsFileShareRequest#builder()}
     * </p>
     *
     * @param updateNfsFileShareRequest
     *        A {@link Consumer} that will call methods on {@link UpdateNFSFileShareInput.Builder} to create a request.
     *        UpdateNFSFileShareInput
     * @return Result of the UpdateNFSFileShare operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.UpdateNFSFileShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/UpdateNFSFileShare"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateNfsFileShareResponse updateNFSFileShare(Consumer<UpdateNfsFileShareRequest.Builder> updateNfsFileShareRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        return updateNFSFileShare(UpdateNfsFileShareRequest.builder().applyMutation(updateNfsFileShareRequest).build());
    }

    /**
     * <p>
     * Updates a Server Message Block (SMB) file share. This operation is only supported for S3 File Gateways.
     * </p>
     * <note>
     * <p>
     * To leave a file share field unchanged, set the corresponding input field to null.
     * </p>
     * </note> <important>
     * <p>
     * File gateways require Security Token Service (Amazon Web Services STS) to be activated to enable you to create a
     * file share. Make sure that Amazon Web Services STS is activated in the Amazon Web Services Region you are
     * creating your file gateway in. If Amazon Web Services STS is not activated in this Amazon Web Services Region,
     * activate it. For information about how to activate Amazon Web Services STS, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_enable-regions.html">Activating and
     * deactivating Amazon Web Services STS in an Amazon Web Services Region</a> in the <i>Identity and Access
     * Management User Guide</i>.
     * </p>
     * <p>
     * File gateways don't support creating hard or symbolic links on a file share.
     * </p>
     * </important>
     *
     * @param updateSmbFileShareRequest
     *        UpdateSMBFileShareInput
     * @return Result of the UpdateSMBFileShare operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.UpdateSMBFileShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/UpdateSMBFileShare"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateSmbFileShareResponse updateSMBFileShare(UpdateSmbFileShareRequest updateSmbFileShareRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a Server Message Block (SMB) file share. This operation is only supported for S3 File Gateways.
     * </p>
     * <note>
     * <p>
     * To leave a file share field unchanged, set the corresponding input field to null.
     * </p>
     * </note> <important>
     * <p>
     * File gateways require Security Token Service (Amazon Web Services STS) to be activated to enable you to create a
     * file share. Make sure that Amazon Web Services STS is activated in the Amazon Web Services Region you are
     * creating your file gateway in. If Amazon Web Services STS is not activated in this Amazon Web Services Region,
     * activate it. For information about how to activate Amazon Web Services STS, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_enable-regions.html">Activating and
     * deactivating Amazon Web Services STS in an Amazon Web Services Region</a> in the <i>Identity and Access
     * Management User Guide</i>.
     * </p>
     * <p>
     * File gateways don't support creating hard or symbolic links on a file share.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSmbFileShareRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateSmbFileShareRequest#builder()}
     * </p>
     *
     * @param updateSmbFileShareRequest
     *        A {@link Consumer} that will call methods on {@link UpdateSMBFileShareInput.Builder} to create a request.
     *        UpdateSMBFileShareInput
     * @return Result of the UpdateSMBFileShare operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.UpdateSMBFileShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/UpdateSMBFileShare"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateSmbFileShareResponse updateSMBFileShare(Consumer<UpdateSmbFileShareRequest.Builder> updateSmbFileShareRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        return updateSMBFileShare(UpdateSmbFileShareRequest.builder().applyMutation(updateSmbFileShareRequest).build());
    }

    /**
     * <p>
     * Controls whether the shares on an S3 File Gateway are visible in a net view or browse list. The operation is only
     * supported for S3 File Gateways.
     * </p>
     *
     * @param updateSmbFileShareVisibilityRequest
     * @return Result of the UpdateSMBFileShareVisibility operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.UpdateSMBFileShareVisibility
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/UpdateSMBFileShareVisibility"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateSmbFileShareVisibilityResponse updateSMBFileShareVisibility(
            UpdateSmbFileShareVisibilityRequest updateSmbFileShareVisibilityRequest) throws InvalidGatewayRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, StorageGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Controls whether the shares on an S3 File Gateway are visible in a net view or browse list. The operation is only
     * supported for S3 File Gateways.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSmbFileShareVisibilityRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateSmbFileShareVisibilityRequest#builder()}
     * </p>
     *
     * @param updateSmbFileShareVisibilityRequest
     *        A {@link Consumer} that will call methods on {@link UpdateSMBFileShareVisibilityInput.Builder} to create a
     *        request.
     * @return Result of the UpdateSMBFileShareVisibility operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.UpdateSMBFileShareVisibility
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/UpdateSMBFileShareVisibility"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateSmbFileShareVisibilityResponse updateSMBFileShareVisibility(
            Consumer<UpdateSmbFileShareVisibilityRequest.Builder> updateSmbFileShareVisibilityRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        return updateSMBFileShareVisibility(UpdateSmbFileShareVisibilityRequest.builder()
                .applyMutation(updateSmbFileShareVisibilityRequest).build());
    }

    /**
     * <p>
     * Updates the list of Active Directory users and groups that have special permissions for SMB file shares on the
     * gateway.
     * </p>
     *
     * @param updateSmbLocalGroupsRequest
     * @return Result of the UpdateSMBLocalGroups operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.UpdateSMBLocalGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/UpdateSMBLocalGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateSmbLocalGroupsResponse updateSMBLocalGroups(UpdateSmbLocalGroupsRequest updateSmbLocalGroupsRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the list of Active Directory users and groups that have special permissions for SMB file shares on the
     * gateway.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSmbLocalGroupsRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateSmbLocalGroupsRequest#builder()}
     * </p>
     *
     * @param updateSmbLocalGroupsRequest
     *        A {@link Consumer} that will call methods on {@link UpdateSMBLocalGroupsInput.Builder} to create a
     *        request.
     * @return Result of the UpdateSMBLocalGroups operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.UpdateSMBLocalGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/UpdateSMBLocalGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateSmbLocalGroupsResponse updateSMBLocalGroups(
            Consumer<UpdateSmbLocalGroupsRequest.Builder> updateSmbLocalGroupsRequest) throws InvalidGatewayRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, StorageGatewayException {
        return updateSMBLocalGroups(UpdateSmbLocalGroupsRequest.builder().applyMutation(updateSmbLocalGroupsRequest).build());
    }

    /**
     * <p>
     * Updates the SMB security strategy on a file gateway. This action is only supported in file gateways.
     * </p>
     * <note>
     * <p>
     * This API is called Security level in the User Guide.
     * </p>
     * <p>
     * A higher security level can affect performance of the gateway.
     * </p>
     * </note>
     *
     * @param updateSmbSecurityStrategyRequest
     * @return Result of the UpdateSMBSecurityStrategy operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.UpdateSMBSecurityStrategy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/UpdateSMBSecurityStrategy"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateSmbSecurityStrategyResponse updateSMBSecurityStrategy(
            UpdateSmbSecurityStrategyRequest updateSmbSecurityStrategyRequest) throws InvalidGatewayRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, StorageGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the SMB security strategy on a file gateway. This action is only supported in file gateways.
     * </p>
     * <note>
     * <p>
     * This API is called Security level in the User Guide.
     * </p>
     * <p>
     * A higher security level can affect performance of the gateway.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSmbSecurityStrategyRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateSmbSecurityStrategyRequest#builder()}
     * </p>
     *
     * @param updateSmbSecurityStrategyRequest
     *        A {@link Consumer} that will call methods on {@link UpdateSMBSecurityStrategyInput.Builder} to create a
     *        request.
     * @return Result of the UpdateSMBSecurityStrategy operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.UpdateSMBSecurityStrategy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/UpdateSMBSecurityStrategy"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateSmbSecurityStrategyResponse updateSMBSecurityStrategy(
            Consumer<UpdateSmbSecurityStrategyRequest.Builder> updateSmbSecurityStrategyRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        return updateSMBSecurityStrategy(UpdateSmbSecurityStrategyRequest.builder()
                .applyMutation(updateSmbSecurityStrategyRequest).build());
    }

    /**
     * <p>
     * Updates a snapshot schedule configured for a gateway volume. This operation is only supported in the cached
     * volume and stored volume gateway types.
     * </p>
     * <p>
     * The default snapshot schedule for volume is once every 24 hours, starting at the creation time of the volume. You
     * can use this API to change the snapshot schedule configured for the volume.
     * </p>
     * <p>
     * In the request you must identify the gateway volume whose snapshot schedule you want to update, and the schedule
     * information, including when you want the snapshot to begin on a day and the frequency (in hours) of snapshots.
     * </p>
     *
     * @param updateSnapshotScheduleRequest
     *        A JSON object containing one or more of the following fields:</p>
     *        <ul>
     *        <li>
     *        <p>
     *        <a>UpdateSnapshotScheduleInput&#36Description</a>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <a>UpdateSnapshotScheduleInput&#36RecurrenceInHours</a>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <a>UpdateSnapshotScheduleInput&#36StartAt</a>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <a>UpdateSnapshotScheduleInput&#36VolumeARN</a>
     *        </p>
     *        </li>
     * @return Result of the UpdateSnapshotSchedule operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.UpdateSnapshotSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/UpdateSnapshotSchedule"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateSnapshotScheduleResponse updateSnapshotSchedule(UpdateSnapshotScheduleRequest updateSnapshotScheduleRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a snapshot schedule configured for a gateway volume. This operation is only supported in the cached
     * volume and stored volume gateway types.
     * </p>
     * <p>
     * The default snapshot schedule for volume is once every 24 hours, starting at the creation time of the volume. You
     * can use this API to change the snapshot schedule configured for the volume.
     * </p>
     * <p>
     * In the request you must identify the gateway volume whose snapshot schedule you want to update, and the schedule
     * information, including when you want the snapshot to begin on a day and the frequency (in hours) of snapshots.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSnapshotScheduleRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateSnapshotScheduleRequest#builder()}
     * </p>
     *
     * @param updateSnapshotScheduleRequest
     *        A {@link Consumer} that will call methods on {@link UpdateSnapshotScheduleInput.Builder} to create a
     *        request. A JSON object containing one or more of the following fields:</p>
     *        <ul>
     *        <li>
     *        <p>
     *        <a>UpdateSnapshotScheduleInput&#36Description</a>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <a>UpdateSnapshotScheduleInput&#36RecurrenceInHours</a>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <a>UpdateSnapshotScheduleInput&#36StartAt</a>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <a>UpdateSnapshotScheduleInput&#36VolumeARN</a>
     *        </p>
     *        </li>
     * @return Result of the UpdateSnapshotSchedule operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.UpdateSnapshotSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/UpdateSnapshotSchedule"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateSnapshotScheduleResponse updateSnapshotSchedule(
            Consumer<UpdateSnapshotScheduleRequest.Builder> updateSnapshotScheduleRequest) throws InvalidGatewayRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, StorageGatewayException {
        return updateSnapshotSchedule(UpdateSnapshotScheduleRequest.builder().applyMutation(updateSnapshotScheduleRequest)
                .build());
    }

    /**
     * <p>
     * Updates the type of medium changer in a tape gateway. When you activate a tape gateway, you select a medium
     * changer type for the tape gateway. This operation enables you to select a different type of medium changer after
     * a tape gateway is activated. This operation is only supported in the tape gateway type.
     * </p>
     *
     * @param updateVtlDeviceTypeRequest
     * @return Result of the UpdateVTLDeviceType operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.UpdateVTLDeviceType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/UpdateVTLDeviceType"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateVtlDeviceTypeResponse updateVTLDeviceType(UpdateVtlDeviceTypeRequest updateVtlDeviceTypeRequest)
            throws InvalidGatewayRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            StorageGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the type of medium changer in a tape gateway. When you activate a tape gateway, you select a medium
     * changer type for the tape gateway. This operation enables you to select a different type of medium changer after
     * a tape gateway is activated. This operation is only supported in the tape gateway type.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateVtlDeviceTypeRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateVtlDeviceTypeRequest#builder()}
     * </p>
     *
     * @param updateVtlDeviceTypeRequest
     *        A {@link Consumer} that will call methods on {@link UpdateVTLDeviceTypeInput.Builder} to create a request.
     * @return Result of the UpdateVTLDeviceType operation returned by the service.
     * @throws InvalidGatewayRequestException
     *         An exception occurred because an invalid gateway request was issued to the service. For more information,
     *         see the error and message fields.
     * @throws InternalServerErrorException
     *         An internal server error has occurred during the request. For more information, see the error and message
     *         fields.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws StorageGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample StorageGatewayClient.UpdateVTLDeviceType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/UpdateVTLDeviceType"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateVtlDeviceTypeResponse updateVTLDeviceType(
            Consumer<UpdateVtlDeviceTypeRequest.Builder> updateVtlDeviceTypeRequest) throws InvalidGatewayRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, StorageGatewayException {
        return updateVTLDeviceType(UpdateVtlDeviceTypeRequest.builder().applyMutation(updateVtlDeviceTypeRequest).build());
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }
}
