/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Unix file permissions and ownership information assigned, by default, to native S3 objects when an S3 File
 * Gateway discovers them in S3 buckets. This operation is only supported in S3 File Gateways.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NFSFileShareInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<NFSFileShareInfo.Builder, NFSFileShareInfo> {
    private static final SdkField<NFSFileShareDefaults> NFS_FILE_SHARE_DEFAULTS_FIELD = SdkField
            .<NFSFileShareDefaults> builder(MarshallingType.SDK_POJO).memberName("NFSFileShareDefaults")
            .getter(getter(NFSFileShareInfo::nfsFileShareDefaults)).setter(setter(Builder::nfsFileShareDefaults))
            .constructor(NFSFileShareDefaults::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NFSFileShareDefaults").build())
            .build();

    private static final SdkField<String> FILE_SHARE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FileShareARN").getter(getter(NFSFileShareInfo::fileShareARN)).setter(setter(Builder::fileShareARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileShareARN").build()).build();

    private static final SdkField<String> FILE_SHARE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FileShareId").getter(getter(NFSFileShareInfo::fileShareId)).setter(setter(Builder::fileShareId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileShareId").build()).build();

    private static final SdkField<String> FILE_SHARE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FileShareStatus").getter(getter(NFSFileShareInfo::fileShareStatus))
            .setter(setter(Builder::fileShareStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileShareStatus").build()).build();

    private static final SdkField<String> GATEWAY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GatewayARN").getter(getter(NFSFileShareInfo::gatewayARN)).setter(setter(Builder::gatewayARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayARN").build()).build();

    private static final SdkField<Boolean> KMS_ENCRYPTED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("KMSEncrypted").getter(getter(NFSFileShareInfo::kmsEncrypted)).setter(setter(Builder::kmsEncrypted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KMSEncrypted").build()).build();

    private static final SdkField<String> KMS_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("KMSKey")
            .getter(getter(NFSFileShareInfo::kmsKey)).setter(setter(Builder::kmsKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KMSKey").build()).build();

    private static final SdkField<String> PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Path")
            .getter(getter(NFSFileShareInfo::path)).setter(setter(Builder::path))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Path").build()).build();

    private static final SdkField<String> ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Role")
            .getter(getter(NFSFileShareInfo::role)).setter(setter(Builder::role))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Role").build()).build();

    private static final SdkField<String> LOCATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LocationARN").getter(getter(NFSFileShareInfo::locationARN)).setter(setter(Builder::locationARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocationARN").build()).build();

    private static final SdkField<String> DEFAULT_STORAGE_CLASS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DefaultStorageClass").getter(getter(NFSFileShareInfo::defaultStorageClass))
            .setter(setter(Builder::defaultStorageClass))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultStorageClass").build())
            .build();

    private static final SdkField<String> OBJECT_ACL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ObjectACL").getter(getter(NFSFileShareInfo::objectACLAsString)).setter(setter(Builder::objectACL))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectACL").build()).build();

    private static final SdkField<List<String>> CLIENT_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ClientList")
            .getter(getter(NFSFileShareInfo::clientList))
            .setter(setter(Builder::clientList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SQUASH_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Squash")
            .getter(getter(NFSFileShareInfo::squash)).setter(setter(Builder::squash))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Squash").build()).build();

    private static final SdkField<Boolean> READ_ONLY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ReadOnly").getter(getter(NFSFileShareInfo::readOnly)).setter(setter(Builder::readOnly))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReadOnly").build()).build();

    private static final SdkField<Boolean> GUESS_MIME_TYPE_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("GuessMIMETypeEnabled").getter(getter(NFSFileShareInfo::guessMIMETypeEnabled))
            .setter(setter(Builder::guessMIMETypeEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GuessMIMETypeEnabled").build())
            .build();

    private static final SdkField<Boolean> REQUESTER_PAYS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("RequesterPays").getter(getter(NFSFileShareInfo::requesterPays)).setter(setter(Builder::requesterPays))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequesterPays").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(NFSFileShareInfo::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> FILE_SHARE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FileShareName").getter(getter(NFSFileShareInfo::fileShareName)).setter(setter(Builder::fileShareName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileShareName").build()).build();

    private static final SdkField<CacheAttributes> CACHE_ATTRIBUTES_FIELD = SdkField
            .<CacheAttributes> builder(MarshallingType.SDK_POJO).memberName("CacheAttributes")
            .getter(getter(NFSFileShareInfo::cacheAttributes)).setter(setter(Builder::cacheAttributes))
            .constructor(CacheAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheAttributes").build()).build();

    private static final SdkField<String> NOTIFICATION_POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NotificationPolicy").getter(getter(NFSFileShareInfo::notificationPolicy))
            .setter(setter(Builder::notificationPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationPolicy").build())
            .build();

    private static final SdkField<String> VPC_ENDPOINT_DNS_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VPCEndpointDNSName").getter(getter(NFSFileShareInfo::vpcEndpointDNSName))
            .setter(setter(Builder::vpcEndpointDNSName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VPCEndpointDNSName").build())
            .build();

    private static final SdkField<String> BUCKET_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BucketRegion").getter(getter(NFSFileShareInfo::bucketRegion)).setter(setter(Builder::bucketRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BucketRegion").build()).build();

    private static final SdkField<String> AUDIT_DESTINATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuditDestinationARN").getter(getter(NFSFileShareInfo::auditDestinationARN))
            .setter(setter(Builder::auditDestinationARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuditDestinationARN").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NFS_FILE_SHARE_DEFAULTS_FIELD,
            FILE_SHARE_ARN_FIELD, FILE_SHARE_ID_FIELD, FILE_SHARE_STATUS_FIELD, GATEWAY_ARN_FIELD, KMS_ENCRYPTED_FIELD,
            KMS_KEY_FIELD, PATH_FIELD, ROLE_FIELD, LOCATION_ARN_FIELD, DEFAULT_STORAGE_CLASS_FIELD, OBJECT_ACL_FIELD,
            CLIENT_LIST_FIELD, SQUASH_FIELD, READ_ONLY_FIELD, GUESS_MIME_TYPE_ENABLED_FIELD, REQUESTER_PAYS_FIELD, TAGS_FIELD,
            FILE_SHARE_NAME_FIELD, CACHE_ATTRIBUTES_FIELD, NOTIFICATION_POLICY_FIELD, VPC_ENDPOINT_DNS_NAME_FIELD,
            BUCKET_REGION_FIELD, AUDIT_DESTINATION_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final NFSFileShareDefaults nfsFileShareDefaults;

    private final String fileShareARN;

    private final String fileShareId;

    private final String fileShareStatus;

    private final String gatewayARN;

    private final Boolean kmsEncrypted;

    private final String kmsKey;

    private final String path;

    private final String role;

    private final String locationARN;

    private final String defaultStorageClass;

    private final String objectACL;

    private final List<String> clientList;

    private final String squash;

    private final Boolean readOnly;

    private final Boolean guessMIMETypeEnabled;

    private final Boolean requesterPays;

    private final List<Tag> tags;

    private final String fileShareName;

    private final CacheAttributes cacheAttributes;

    private final String notificationPolicy;

    private final String vpcEndpointDNSName;

    private final String bucketRegion;

    private final String auditDestinationARN;

    private NFSFileShareInfo(BuilderImpl builder) {
        this.nfsFileShareDefaults = builder.nfsFileShareDefaults;
        this.fileShareARN = builder.fileShareARN;
        this.fileShareId = builder.fileShareId;
        this.fileShareStatus = builder.fileShareStatus;
        this.gatewayARN = builder.gatewayARN;
        this.kmsEncrypted = builder.kmsEncrypted;
        this.kmsKey = builder.kmsKey;
        this.path = builder.path;
        this.role = builder.role;
        this.locationARN = builder.locationARN;
        this.defaultStorageClass = builder.defaultStorageClass;
        this.objectACL = builder.objectACL;
        this.clientList = builder.clientList;
        this.squash = builder.squash;
        this.readOnly = builder.readOnly;
        this.guessMIMETypeEnabled = builder.guessMIMETypeEnabled;
        this.requesterPays = builder.requesterPays;
        this.tags = builder.tags;
        this.fileShareName = builder.fileShareName;
        this.cacheAttributes = builder.cacheAttributes;
        this.notificationPolicy = builder.notificationPolicy;
        this.vpcEndpointDNSName = builder.vpcEndpointDNSName;
        this.bucketRegion = builder.bucketRegion;
        this.auditDestinationARN = builder.auditDestinationARN;
    }

    /**
     * Returns the value of the NFSFileShareDefaults property for this object.
     * 
     * @return The value of the NFSFileShareDefaults property for this object.
     */
    public final NFSFileShareDefaults nfsFileShareDefaults() {
        return nfsFileShareDefaults;
    }

    /**
     * Returns the value of the FileShareARN property for this object.
     * 
     * @return The value of the FileShareARN property for this object.
     */
    public final String fileShareARN() {
        return fileShareARN;
    }

    /**
     * Returns the value of the FileShareId property for this object.
     * 
     * @return The value of the FileShareId property for this object.
     */
    public final String fileShareId() {
        return fileShareId;
    }

    /**
     * Returns the value of the FileShareStatus property for this object.
     * 
     * @return The value of the FileShareStatus property for this object.
     */
    public final String fileShareStatus() {
        return fileShareStatus;
    }

    /**
     * Returns the value of the GatewayARN property for this object.
     * 
     * @return The value of the GatewayARN property for this object.
     */
    public final String gatewayARN() {
        return gatewayARN;
    }

    /**
     * <p>
     * Set to <code>true</code> to use Amazon S3 server-side encryption with your own KMS key, or <code>false</code> to
     * use a key managed by Amazon S3. Optional.
     * </p>
     * <p>
     * Valid Values: <code>true</code> | <code>false</code>
     * </p>
     * 
     * @return Set to <code>true</code> to use Amazon S3 server-side encryption with your own KMS key, or
     *         <code>false</code> to use a key managed by Amazon S3. Optional.</p>
     *         <p>
     *         Valid Values: <code>true</code> | <code>false</code>
     */
    public final Boolean kmsEncrypted() {
        return kmsEncrypted;
    }

    /**
     * Returns the value of the KMSKey property for this object.
     * 
     * @return The value of the KMSKey property for this object.
     */
    public final String kmsKey() {
        return kmsKey;
    }

    /**
     * Returns the value of the Path property for this object.
     * 
     * @return The value of the Path property for this object.
     */
    public final String path() {
        return path;
    }

    /**
     * Returns the value of the Role property for this object.
     * 
     * @return The value of the Role property for this object.
     */
    public final String role() {
        return role;
    }

    /**
     * Returns the value of the LocationARN property for this object.
     * 
     * @return The value of the LocationARN property for this object.
     */
    public final String locationARN() {
        return locationARN;
    }

    /**
     * <p>
     * The default storage class for objects put into an Amazon S3 bucket by the S3 File Gateway. The default value is
     * <code>S3_STANDARD</code>. Optional.
     * </p>
     * <p>
     * Valid Values: <code>S3_STANDARD</code> | <code>S3_INTELLIGENT_TIERING</code> | <code>S3_STANDARD_IA</code> |
     * <code>S3_ONEZONE_IA</code>
     * </p>
     * 
     * @return The default storage class for objects put into an Amazon S3 bucket by the S3 File Gateway. The default
     *         value is <code>S3_STANDARD</code>. Optional.</p>
     *         <p>
     *         Valid Values: <code>S3_STANDARD</code> | <code>S3_INTELLIGENT_TIERING</code> |
     *         <code>S3_STANDARD_IA</code> | <code>S3_ONEZONE_IA</code>
     */
    public final String defaultStorageClass() {
        return defaultStorageClass;
    }

    /**
     * Returns the value of the ObjectACL property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #objectACL} will
     * return {@link ObjectACL#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #objectACLAsString}.
     * </p>
     * 
     * @return The value of the ObjectACL property for this object.
     * @see ObjectACL
     */
    public final ObjectACL objectACL() {
        return ObjectACL.fromValue(objectACL);
    }

    /**
     * Returns the value of the ObjectACL property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #objectACL} will
     * return {@link ObjectACL#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #objectACLAsString}.
     * </p>
     * 
     * @return The value of the ObjectACL property for this object.
     * @see ObjectACL
     */
    public final String objectACLAsString() {
        return objectACL;
    }

    /**
     * For responses, this returns true if the service returned a value for the ClientList property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasClientList() {
        return clientList != null && !(clientList instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the ClientList property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasClientList} method.
     * </p>
     * 
     * @return The value of the ClientList property for this object.
     */
    public final List<String> clientList() {
        return clientList;
    }

    /**
     * Returns the value of the Squash property for this object.
     * 
     * @return The value of the Squash property for this object.
     */
    public final String squash() {
        return squash;
    }

    /**
     * <p>
     * A value that sets the write status of a file share. Set this value to <code>true</code> to set the write status
     * to read-only, otherwise set to <code>false</code>.
     * </p>
     * <p>
     * Valid Values: <code>true</code> | <code>false</code>
     * </p>
     * 
     * @return A value that sets the write status of a file share. Set this value to <code>true</code> to set the write
     *         status to read-only, otherwise set to <code>false</code>.</p>
     *         <p>
     *         Valid Values: <code>true</code> | <code>false</code>
     */
    public final Boolean readOnly() {
        return readOnly;
    }

    /**
     * <p>
     * A value that enables guessing of the MIME type for uploaded objects based on file extensions. Set this value to
     * <code>true</code> to enable MIME type guessing, otherwise set to <code>false</code>. The default value is
     * <code>true</code>.
     * </p>
     * <p>
     * Valid Values: <code>true</code> | <code>false</code>
     * </p>
     * 
     * @return A value that enables guessing of the MIME type for uploaded objects based on file extensions. Set this
     *         value to <code>true</code> to enable MIME type guessing, otherwise set to <code>false</code>. The default
     *         value is <code>true</code>.</p>
     *         <p>
     *         Valid Values: <code>true</code> | <code>false</code>
     */
    public final Boolean guessMIMETypeEnabled() {
        return guessMIMETypeEnabled;
    }

    /**
     * <p>
     * A value that sets who pays the cost of the request and the cost associated with data download from the S3 bucket.
     * If this value is set to <code>true</code>, the requester pays the costs; otherwise, the S3 bucket owner pays.
     * However, the S3 bucket owner always pays the cost of storing data.
     * </p>
     * <note>
     * <p>
     * <code>RequesterPays</code> is a configuration for the S3 bucket that backs the file share, so make sure that the
     * configuration on the file share is the same as the S3 bucket configuration.
     * </p>
     * </note>
     * <p>
     * Valid Values: <code>true</code> | <code>false</code>
     * </p>
     * 
     * @return A value that sets who pays the cost of the request and the cost associated with data download from the S3
     *         bucket. If this value is set to <code>true</code>, the requester pays the costs; otherwise, the S3 bucket
     *         owner pays. However, the S3 bucket owner always pays the cost of storing data.</p> <note>
     *         <p>
     *         <code>RequesterPays</code> is a configuration for the S3 bucket that backs the file share, so make sure
     *         that the configuration on the file share is the same as the S3 bucket configuration.
     *         </p>
     *         </note>
     *         <p>
     *         Valid Values: <code>true</code> | <code>false</code>
     */
    public final Boolean requesterPays() {
        return requesterPays;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of up to 50 tags assigned to the NFS file share, sorted alphabetically by key name. Each tag is a
     * key-value pair. For a gateway with more than 10 tags assigned, you can view all tags using the
     * <code>ListTagsForResource</code> API operation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of up to 50 tags assigned to the NFS file share, sorted alphabetically by key name. Each tag is a
     *         key-value pair. For a gateway with more than 10 tags assigned, you can view all tags using the
     *         <code>ListTagsForResource</code> API operation.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The name of the file share. Optional.
     * </p>
     * <note>
     * <p>
     * <code>FileShareName</code> must be set if an S3 prefix name is set in <code>LocationARN</code>, or if an access
     * point or access point alias is used.
     * </p>
     * </note>
     * 
     * @return The name of the file share. Optional.</p> <note>
     *         <p>
     *         <code>FileShareName</code> must be set if an S3 prefix name is set in <code>LocationARN</code>, or if an
     *         access point or access point alias is used.
     *         </p>
     */
    public final String fileShareName() {
        return fileShareName;
    }

    /**
     * <p>
     * Refresh cache information for the file share.
     * </p>
     * 
     * @return Refresh cache information for the file share.
     */
    public final CacheAttributes cacheAttributes() {
        return cacheAttributes;
    }

    /**
     * <p>
     * The notification policy of the file share. <code>SettlingTimeInSeconds</code> controls the number of seconds to
     * wait after the last point in time a client wrote to a file before generating an <code>ObjectUploaded</code>
     * notification. Because clients can make many small writes to files, it's best to set this parameter for as long as
     * possible to avoid generating multiple notifications for the same file in a small time period.
     * </p>
     * <note>
     * <p>
     * <code>SettlingTimeInSeconds</code> has no effect on the timing of the object uploading to Amazon S3, only the
     * timing of the notification.
     * </p>
     * </note>
     * <p>
     * The following example sets <code>NotificationPolicy</code> on with <code>SettlingTimeInSeconds</code> set to 60.
     * </p>
     * <p>
     * <code>{\"Upload\": {\"SettlingTimeInSeconds\": 60}}</code>
     * </p>
     * <p>
     * The following example sets <code>NotificationPolicy</code> off.
     * </p>
     * <p>
     * <code>{}</code>
     * </p>
     * 
     * @return The notification policy of the file share. <code>SettlingTimeInSeconds</code> controls the number of
     *         seconds to wait after the last point in time a client wrote to a file before generating an
     *         <code>ObjectUploaded</code> notification. Because clients can make many small writes to files, it's best
     *         to set this parameter for as long as possible to avoid generating multiple notifications for the same
     *         file in a small time period.</p> <note>
     *         <p>
     *         <code>SettlingTimeInSeconds</code> has no effect on the timing of the object uploading to Amazon S3, only
     *         the timing of the notification.
     *         </p>
     *         </note>
     *         <p>
     *         The following example sets <code>NotificationPolicy</code> on with <code>SettlingTimeInSeconds</code> set
     *         to 60.
     *         </p>
     *         <p>
     *         <code>{\"Upload\": {\"SettlingTimeInSeconds\": 60}}</code>
     *         </p>
     *         <p>
     *         The following example sets <code>NotificationPolicy</code> off.
     *         </p>
     *         <p>
     *         <code>{}</code>
     */
    public final String notificationPolicy() {
        return notificationPolicy;
    }

    /**
     * <p>
     * Specifies the DNS name for the VPC endpoint that the NFS file share uses to connect to Amazon S3.
     * </p>
     * <note>
     * <p>
     * This parameter is required for NFS file shares that connect to Amazon S3 through a VPC endpoint, a VPC access
     * point, or an access point alias that points to a VPC access point.
     * </p>
     * </note>
     * 
     * @return Specifies the DNS name for the VPC endpoint that the NFS file share uses to connect to Amazon S3.</p>
     *         <note>
     *         <p>
     *         This parameter is required for NFS file shares that connect to Amazon S3 through a VPC endpoint, a VPC
     *         access point, or an access point alias that points to a VPC access point.
     *         </p>
     */
    public final String vpcEndpointDNSName() {
        return vpcEndpointDNSName;
    }

    /**
     * <p>
     * Specifies the Region of the S3 bucket where the NFS file share stores files.
     * </p>
     * <note>
     * <p>
     * This parameter is required for NFS file shares that connect to Amazon S3 through a VPC endpoint, a VPC access
     * point, or an access point alias that points to a VPC access point.
     * </p>
     * </note>
     * 
     * @return Specifies the Region of the S3 bucket where the NFS file share stores files.</p> <note>
     *         <p>
     *         This parameter is required for NFS file shares that connect to Amazon S3 through a VPC endpoint, a VPC
     *         access point, or an access point alias that points to a VPC access point.
     *         </p>
     */
    public final String bucketRegion() {
        return bucketRegion;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the storage used for audit logs.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the storage used for audit logs.
     */
    public final String auditDestinationARN() {
        return auditDestinationARN;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nfsFileShareDefaults());
        hashCode = 31 * hashCode + Objects.hashCode(fileShareARN());
        hashCode = 31 * hashCode + Objects.hashCode(fileShareId());
        hashCode = 31 * hashCode + Objects.hashCode(fileShareStatus());
        hashCode = 31 * hashCode + Objects.hashCode(gatewayARN());
        hashCode = 31 * hashCode + Objects.hashCode(kmsEncrypted());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKey());
        hashCode = 31 * hashCode + Objects.hashCode(path());
        hashCode = 31 * hashCode + Objects.hashCode(role());
        hashCode = 31 * hashCode + Objects.hashCode(locationARN());
        hashCode = 31 * hashCode + Objects.hashCode(defaultStorageClass());
        hashCode = 31 * hashCode + Objects.hashCode(objectACLAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasClientList() ? clientList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(squash());
        hashCode = 31 * hashCode + Objects.hashCode(readOnly());
        hashCode = 31 * hashCode + Objects.hashCode(guessMIMETypeEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(requesterPays());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(fileShareName());
        hashCode = 31 * hashCode + Objects.hashCode(cacheAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(notificationPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(vpcEndpointDNSName());
        hashCode = 31 * hashCode + Objects.hashCode(bucketRegion());
        hashCode = 31 * hashCode + Objects.hashCode(auditDestinationARN());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NFSFileShareInfo)) {
            return false;
        }
        NFSFileShareInfo other = (NFSFileShareInfo) obj;
        return Objects.equals(nfsFileShareDefaults(), other.nfsFileShareDefaults())
                && Objects.equals(fileShareARN(), other.fileShareARN()) && Objects.equals(fileShareId(), other.fileShareId())
                && Objects.equals(fileShareStatus(), other.fileShareStatus()) && Objects.equals(gatewayARN(), other.gatewayARN())
                && Objects.equals(kmsEncrypted(), other.kmsEncrypted()) && Objects.equals(kmsKey(), other.kmsKey())
                && Objects.equals(path(), other.path()) && Objects.equals(role(), other.role())
                && Objects.equals(locationARN(), other.locationARN())
                && Objects.equals(defaultStorageClass(), other.defaultStorageClass())
                && Objects.equals(objectACLAsString(), other.objectACLAsString()) && hasClientList() == other.hasClientList()
                && Objects.equals(clientList(), other.clientList()) && Objects.equals(squash(), other.squash())
                && Objects.equals(readOnly(), other.readOnly())
                && Objects.equals(guessMIMETypeEnabled(), other.guessMIMETypeEnabled())
                && Objects.equals(requesterPays(), other.requesterPays()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(fileShareName(), other.fileShareName())
                && Objects.equals(cacheAttributes(), other.cacheAttributes())
                && Objects.equals(notificationPolicy(), other.notificationPolicy())
                && Objects.equals(vpcEndpointDNSName(), other.vpcEndpointDNSName())
                && Objects.equals(bucketRegion(), other.bucketRegion())
                && Objects.equals(auditDestinationARN(), other.auditDestinationARN());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NFSFileShareInfo").add("NFSFileShareDefaults", nfsFileShareDefaults())
                .add("FileShareARN", fileShareARN()).add("FileShareId", fileShareId()).add("FileShareStatus", fileShareStatus())
                .add("GatewayARN", gatewayARN()).add("KMSEncrypted", kmsEncrypted()).add("KMSKey", kmsKey()).add("Path", path())
                .add("Role", role()).add("LocationARN", locationARN()).add("DefaultStorageClass", defaultStorageClass())
                .add("ObjectACL", objectACLAsString()).add("ClientList", hasClientList() ? clientList() : null)
                .add("Squash", squash()).add("ReadOnly", readOnly()).add("GuessMIMETypeEnabled", guessMIMETypeEnabled())
                .add("RequesterPays", requesterPays()).add("Tags", hasTags() ? tags() : null)
                .add("FileShareName", fileShareName()).add("CacheAttributes", cacheAttributes())
                .add("NotificationPolicy", notificationPolicy()).add("VPCEndpointDNSName", vpcEndpointDNSName())
                .add("BucketRegion", bucketRegion()).add("AuditDestinationARN", auditDestinationARN()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NFSFileShareDefaults":
            return Optional.ofNullable(clazz.cast(nfsFileShareDefaults()));
        case "FileShareARN":
            return Optional.ofNullable(clazz.cast(fileShareARN()));
        case "FileShareId":
            return Optional.ofNullable(clazz.cast(fileShareId()));
        case "FileShareStatus":
            return Optional.ofNullable(clazz.cast(fileShareStatus()));
        case "GatewayARN":
            return Optional.ofNullable(clazz.cast(gatewayARN()));
        case "KMSEncrypted":
            return Optional.ofNullable(clazz.cast(kmsEncrypted()));
        case "KMSKey":
            return Optional.ofNullable(clazz.cast(kmsKey()));
        case "Path":
            return Optional.ofNullable(clazz.cast(path()));
        case "Role":
            return Optional.ofNullable(clazz.cast(role()));
        case "LocationARN":
            return Optional.ofNullable(clazz.cast(locationARN()));
        case "DefaultStorageClass":
            return Optional.ofNullable(clazz.cast(defaultStorageClass()));
        case "ObjectACL":
            return Optional.ofNullable(clazz.cast(objectACLAsString()));
        case "ClientList":
            return Optional.ofNullable(clazz.cast(clientList()));
        case "Squash":
            return Optional.ofNullable(clazz.cast(squash()));
        case "ReadOnly":
            return Optional.ofNullable(clazz.cast(readOnly()));
        case "GuessMIMETypeEnabled":
            return Optional.ofNullable(clazz.cast(guessMIMETypeEnabled()));
        case "RequesterPays":
            return Optional.ofNullable(clazz.cast(requesterPays()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "FileShareName":
            return Optional.ofNullable(clazz.cast(fileShareName()));
        case "CacheAttributes":
            return Optional.ofNullable(clazz.cast(cacheAttributes()));
        case "NotificationPolicy":
            return Optional.ofNullable(clazz.cast(notificationPolicy()));
        case "VPCEndpointDNSName":
            return Optional.ofNullable(clazz.cast(vpcEndpointDNSName()));
        case "BucketRegion":
            return Optional.ofNullable(clazz.cast(bucketRegion()));
        case "AuditDestinationARN":
            return Optional.ofNullable(clazz.cast(auditDestinationARN()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NFSFileShareInfo, T> g) {
        return obj -> g.apply((NFSFileShareInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NFSFileShareInfo> {
        /**
         * Sets the value of the NFSFileShareDefaults property for this object.
         *
         * @param nfsFileShareDefaults
         *        The new value for the NFSFileShareDefaults property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nfsFileShareDefaults(NFSFileShareDefaults nfsFileShareDefaults);

        /**
         * Sets the value of the NFSFileShareDefaults property for this object.
         *
         * This is a convenience method that creates an instance of the {@link NFSFileShareDefaults.Builder} avoiding
         * the need to create one manually via {@link NFSFileShareDefaults#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NFSFileShareDefaults.Builder#build()} is called immediately and
         * its result is passed to {@link #nfsFileShareDefaults(NFSFileShareDefaults)}.
         * 
         * @param nfsFileShareDefaults
         *        a consumer that will call methods on {@link NFSFileShareDefaults.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #nfsFileShareDefaults(NFSFileShareDefaults)
         */
        default Builder nfsFileShareDefaults(Consumer<NFSFileShareDefaults.Builder> nfsFileShareDefaults) {
            return nfsFileShareDefaults(NFSFileShareDefaults.builder().applyMutation(nfsFileShareDefaults).build());
        }

        /**
         * Sets the value of the FileShareARN property for this object.
         *
         * @param fileShareARN
         *        The new value for the FileShareARN property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileShareARN(String fileShareARN);

        /**
         * Sets the value of the FileShareId property for this object.
         *
         * @param fileShareId
         *        The new value for the FileShareId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileShareId(String fileShareId);

        /**
         * Sets the value of the FileShareStatus property for this object.
         *
         * @param fileShareStatus
         *        The new value for the FileShareStatus property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileShareStatus(String fileShareStatus);

        /**
         * Sets the value of the GatewayARN property for this object.
         *
         * @param gatewayARN
         *        The new value for the GatewayARN property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayARN(String gatewayARN);

        /**
         * <p>
         * Set to <code>true</code> to use Amazon S3 server-side encryption with your own KMS key, or <code>false</code>
         * to use a key managed by Amazon S3. Optional.
         * </p>
         * <p>
         * Valid Values: <code>true</code> | <code>false</code>
         * </p>
         * 
         * @param kmsEncrypted
         *        Set to <code>true</code> to use Amazon S3 server-side encryption with your own KMS key, or
         *        <code>false</code> to use a key managed by Amazon S3. Optional.</p>
         *        <p>
         *        Valid Values: <code>true</code> | <code>false</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsEncrypted(Boolean kmsEncrypted);

        /**
         * Sets the value of the KMSKey property for this object.
         *
         * @param kmsKey
         *        The new value for the KMSKey property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKey(String kmsKey);

        /**
         * Sets the value of the Path property for this object.
         *
         * @param path
         *        The new value for the Path property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder path(String path);

        /**
         * Sets the value of the Role property for this object.
         *
         * @param role
         *        The new value for the Role property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder role(String role);

        /**
         * Sets the value of the LocationARN property for this object.
         *
         * @param locationARN
         *        The new value for the LocationARN property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder locationARN(String locationARN);

        /**
         * <p>
         * The default storage class for objects put into an Amazon S3 bucket by the S3 File Gateway. The default value
         * is <code>S3_STANDARD</code>. Optional.
         * </p>
         * <p>
         * Valid Values: <code>S3_STANDARD</code> | <code>S3_INTELLIGENT_TIERING</code> | <code>S3_STANDARD_IA</code> |
         * <code>S3_ONEZONE_IA</code>
         * </p>
         * 
         * @param defaultStorageClass
         *        The default storage class for objects put into an Amazon S3 bucket by the S3 File Gateway. The default
         *        value is <code>S3_STANDARD</code>. Optional.</p>
         *        <p>
         *        Valid Values: <code>S3_STANDARD</code> | <code>S3_INTELLIGENT_TIERING</code> |
         *        <code>S3_STANDARD_IA</code> | <code>S3_ONEZONE_IA</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultStorageClass(String defaultStorageClass);

        /**
         * Sets the value of the ObjectACL property for this object.
         *
         * @param objectACL
         *        The new value for the ObjectACL property for this object.
         * @see ObjectACL
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ObjectACL
         */
        Builder objectACL(String objectACL);

        /**
         * Sets the value of the ObjectACL property for this object.
         *
         * @param objectACL
         *        The new value for the ObjectACL property for this object.
         * @see ObjectACL
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ObjectACL
         */
        Builder objectACL(ObjectACL objectACL);

        /**
         * Sets the value of the ClientList property for this object.
         *
         * @param clientList
         *        The new value for the ClientList property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientList(Collection<String> clientList);

        /**
         * Sets the value of the ClientList property for this object.
         *
         * @param clientList
         *        The new value for the ClientList property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientList(String... clientList);

        /**
         * Sets the value of the Squash property for this object.
         *
         * @param squash
         *        The new value for the Squash property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder squash(String squash);

        /**
         * <p>
         * A value that sets the write status of a file share. Set this value to <code>true</code> to set the write
         * status to read-only, otherwise set to <code>false</code>.
         * </p>
         * <p>
         * Valid Values: <code>true</code> | <code>false</code>
         * </p>
         * 
         * @param readOnly
         *        A value that sets the write status of a file share. Set this value to <code>true</code> to set the
         *        write status to read-only, otherwise set to <code>false</code>.</p>
         *        <p>
         *        Valid Values: <code>true</code> | <code>false</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readOnly(Boolean readOnly);

        /**
         * <p>
         * A value that enables guessing of the MIME type for uploaded objects based on file extensions. Set this value
         * to <code>true</code> to enable MIME type guessing, otherwise set to <code>false</code>. The default value is
         * <code>true</code>.
         * </p>
         * <p>
         * Valid Values: <code>true</code> | <code>false</code>
         * </p>
         * 
         * @param guessMIMETypeEnabled
         *        A value that enables guessing of the MIME type for uploaded objects based on file extensions. Set this
         *        value to <code>true</code> to enable MIME type guessing, otherwise set to <code>false</code>. The
         *        default value is <code>true</code>.</p>
         *        <p>
         *        Valid Values: <code>true</code> | <code>false</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder guessMIMETypeEnabled(Boolean guessMIMETypeEnabled);

        /**
         * <p>
         * A value that sets who pays the cost of the request and the cost associated with data download from the S3
         * bucket. If this value is set to <code>true</code>, the requester pays the costs; otherwise, the S3 bucket
         * owner pays. However, the S3 bucket owner always pays the cost of storing data.
         * </p>
         * <note>
         * <p>
         * <code>RequesterPays</code> is a configuration for the S3 bucket that backs the file share, so make sure that
         * the configuration on the file share is the same as the S3 bucket configuration.
         * </p>
         * </note>
         * <p>
         * Valid Values: <code>true</code> | <code>false</code>
         * </p>
         * 
         * @param requesterPays
         *        A value that sets who pays the cost of the request and the cost associated with data download from the
         *        S3 bucket. If this value is set to <code>true</code>, the requester pays the costs; otherwise, the S3
         *        bucket owner pays. However, the S3 bucket owner always pays the cost of storing data.</p> <note>
         *        <p>
         *        <code>RequesterPays</code> is a configuration for the S3 bucket that backs the file share, so make
         *        sure that the configuration on the file share is the same as the S3 bucket configuration.
         *        </p>
         *        </note>
         *        <p>
         *        Valid Values: <code>true</code> | <code>false</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requesterPays(Boolean requesterPays);

        /**
         * <p>
         * A list of up to 50 tags assigned to the NFS file share, sorted alphabetically by key name. Each tag is a
         * key-value pair. For a gateway with more than 10 tags assigned, you can view all tags using the
         * <code>ListTagsForResource</code> API operation.
         * </p>
         * 
         * @param tags
         *        A list of up to 50 tags assigned to the NFS file share, sorted alphabetically by key name. Each tag is
         *        a key-value pair. For a gateway with more than 10 tags assigned, you can view all tags using the
         *        <code>ListTagsForResource</code> API operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of up to 50 tags assigned to the NFS file share, sorted alphabetically by key name. Each tag is a
         * key-value pair. For a gateway with more than 10 tags assigned, you can view all tags using the
         * <code>ListTagsForResource</code> API operation.
         * </p>
         * 
         * @param tags
         *        A list of up to 50 tags assigned to the NFS file share, sorted alphabetically by key name. Each tag is
         *        a key-value pair. For a gateway with more than 10 tags assigned, you can view all tags using the
         *        <code>ListTagsForResource</code> API operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of up to 50 tags assigned to the NFS file share, sorted alphabetically by key name. Each tag is a
         * key-value pair. For a gateway with more than 10 tags assigned, you can view all tags using the
         * <code>ListTagsForResource</code> API operation.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.storagegateway.model.Tag.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.storagegateway.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.storagegateway.model.Tag.Builder#build()} is called immediately and
         * its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.storagegateway.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The name of the file share. Optional.
         * </p>
         * <note>
         * <p>
         * <code>FileShareName</code> must be set if an S3 prefix name is set in <code>LocationARN</code>, or if an
         * access point or access point alias is used.
         * </p>
         * </note>
         * 
         * @param fileShareName
         *        The name of the file share. Optional.</p> <note>
         *        <p>
         *        <code>FileShareName</code> must be set if an S3 prefix name is set in <code>LocationARN</code>, or if
         *        an access point or access point alias is used.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileShareName(String fileShareName);

        /**
         * <p>
         * Refresh cache information for the file share.
         * </p>
         * 
         * @param cacheAttributes
         *        Refresh cache information for the file share.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheAttributes(CacheAttributes cacheAttributes);

        /**
         * <p>
         * Refresh cache information for the file share.
         * </p>
         * This is a convenience method that creates an instance of the {@link CacheAttributes.Builder} avoiding the
         * need to create one manually via {@link CacheAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CacheAttributes.Builder#build()} is called immediately and its
         * result is passed to {@link #cacheAttributes(CacheAttributes)}.
         * 
         * @param cacheAttributes
         *        a consumer that will call methods on {@link CacheAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cacheAttributes(CacheAttributes)
         */
        default Builder cacheAttributes(Consumer<CacheAttributes.Builder> cacheAttributes) {
            return cacheAttributes(CacheAttributes.builder().applyMutation(cacheAttributes).build());
        }

        /**
         * <p>
         * The notification policy of the file share. <code>SettlingTimeInSeconds</code> controls the number of seconds
         * to wait after the last point in time a client wrote to a file before generating an
         * <code>ObjectUploaded</code> notification. Because clients can make many small writes to files, it's best to
         * set this parameter for as long as possible to avoid generating multiple notifications for the same file in a
         * small time period.
         * </p>
         * <note>
         * <p>
         * <code>SettlingTimeInSeconds</code> has no effect on the timing of the object uploading to Amazon S3, only the
         * timing of the notification.
         * </p>
         * </note>
         * <p>
         * The following example sets <code>NotificationPolicy</code> on with <code>SettlingTimeInSeconds</code> set to
         * 60.
         * </p>
         * <p>
         * <code>{\"Upload\": {\"SettlingTimeInSeconds\": 60}}</code>
         * </p>
         * <p>
         * The following example sets <code>NotificationPolicy</code> off.
         * </p>
         * <p>
         * <code>{}</code>
         * </p>
         * 
         * @param notificationPolicy
         *        The notification policy of the file share. <code>SettlingTimeInSeconds</code> controls the number of
         *        seconds to wait after the last point in time a client wrote to a file before generating an
         *        <code>ObjectUploaded</code> notification. Because clients can make many small writes to files, it's
         *        best to set this parameter for as long as possible to avoid generating multiple notifications for the
         *        same file in a small time period.</p> <note>
         *        <p>
         *        <code>SettlingTimeInSeconds</code> has no effect on the timing of the object uploading to Amazon S3,
         *        only the timing of the notification.
         *        </p>
         *        </note>
         *        <p>
         *        The following example sets <code>NotificationPolicy</code> on with <code>SettlingTimeInSeconds</code>
         *        set to 60.
         *        </p>
         *        <p>
         *        <code>{\"Upload\": {\"SettlingTimeInSeconds\": 60}}</code>
         *        </p>
         *        <p>
         *        The following example sets <code>NotificationPolicy</code> off.
         *        </p>
         *        <p>
         *        <code>{}</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationPolicy(String notificationPolicy);

        /**
         * <p>
         * Specifies the DNS name for the VPC endpoint that the NFS file share uses to connect to Amazon S3.
         * </p>
         * <note>
         * <p>
         * This parameter is required for NFS file shares that connect to Amazon S3 through a VPC endpoint, a VPC access
         * point, or an access point alias that points to a VPC access point.
         * </p>
         * </note>
         * 
         * @param vpcEndpointDNSName
         *        Specifies the DNS name for the VPC endpoint that the NFS file share uses to connect to Amazon S3.</p>
         *        <note>
         *        <p>
         *        This parameter is required for NFS file shares that connect to Amazon S3 through a VPC endpoint, a VPC
         *        access point, or an access point alias that points to a VPC access point.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcEndpointDNSName(String vpcEndpointDNSName);

        /**
         * <p>
         * Specifies the Region of the S3 bucket where the NFS file share stores files.
         * </p>
         * <note>
         * <p>
         * This parameter is required for NFS file shares that connect to Amazon S3 through a VPC endpoint, a VPC access
         * point, or an access point alias that points to a VPC access point.
         * </p>
         * </note>
         * 
         * @param bucketRegion
         *        Specifies the Region of the S3 bucket where the NFS file share stores files.</p> <note>
         *        <p>
         *        This parameter is required for NFS file shares that connect to Amazon S3 through a VPC endpoint, a VPC
         *        access point, or an access point alias that points to a VPC access point.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketRegion(String bucketRegion);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the storage used for audit logs.
         * </p>
         * 
         * @param auditDestinationARN
         *        The Amazon Resource Name (ARN) of the storage used for audit logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder auditDestinationARN(String auditDestinationARN);
    }

    static final class BuilderImpl implements Builder {
        private NFSFileShareDefaults nfsFileShareDefaults;

        private String fileShareARN;

        private String fileShareId;

        private String fileShareStatus;

        private String gatewayARN;

        private Boolean kmsEncrypted;

        private String kmsKey;

        private String path;

        private String role;

        private String locationARN;

        private String defaultStorageClass;

        private String objectACL;

        private List<String> clientList = DefaultSdkAutoConstructList.getInstance();

        private String squash;

        private Boolean readOnly;

        private Boolean guessMIMETypeEnabled;

        private Boolean requesterPays;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String fileShareName;

        private CacheAttributes cacheAttributes;

        private String notificationPolicy;

        private String vpcEndpointDNSName;

        private String bucketRegion;

        private String auditDestinationARN;

        private BuilderImpl() {
        }

        private BuilderImpl(NFSFileShareInfo model) {
            nfsFileShareDefaults(model.nfsFileShareDefaults);
            fileShareARN(model.fileShareARN);
            fileShareId(model.fileShareId);
            fileShareStatus(model.fileShareStatus);
            gatewayARN(model.gatewayARN);
            kmsEncrypted(model.kmsEncrypted);
            kmsKey(model.kmsKey);
            path(model.path);
            role(model.role);
            locationARN(model.locationARN);
            defaultStorageClass(model.defaultStorageClass);
            objectACL(model.objectACL);
            clientList(model.clientList);
            squash(model.squash);
            readOnly(model.readOnly);
            guessMIMETypeEnabled(model.guessMIMETypeEnabled);
            requesterPays(model.requesterPays);
            tags(model.tags);
            fileShareName(model.fileShareName);
            cacheAttributes(model.cacheAttributes);
            notificationPolicy(model.notificationPolicy);
            vpcEndpointDNSName(model.vpcEndpointDNSName);
            bucketRegion(model.bucketRegion);
            auditDestinationARN(model.auditDestinationARN);
        }

        public final NFSFileShareDefaults.Builder getNfsFileShareDefaults() {
            return nfsFileShareDefaults != null ? nfsFileShareDefaults.toBuilder() : null;
        }

        public final void setNfsFileShareDefaults(NFSFileShareDefaults.BuilderImpl nfsFileShareDefaults) {
            this.nfsFileShareDefaults = nfsFileShareDefaults != null ? nfsFileShareDefaults.build() : null;
        }

        @Override
        public final Builder nfsFileShareDefaults(NFSFileShareDefaults nfsFileShareDefaults) {
            this.nfsFileShareDefaults = nfsFileShareDefaults;
            return this;
        }

        public final String getFileShareARN() {
            return fileShareARN;
        }

        public final void setFileShareARN(String fileShareARN) {
            this.fileShareARN = fileShareARN;
        }

        @Override
        public final Builder fileShareARN(String fileShareARN) {
            this.fileShareARN = fileShareARN;
            return this;
        }

        public final String getFileShareId() {
            return fileShareId;
        }

        public final void setFileShareId(String fileShareId) {
            this.fileShareId = fileShareId;
        }

        @Override
        public final Builder fileShareId(String fileShareId) {
            this.fileShareId = fileShareId;
            return this;
        }

        public final String getFileShareStatus() {
            return fileShareStatus;
        }

        public final void setFileShareStatus(String fileShareStatus) {
            this.fileShareStatus = fileShareStatus;
        }

        @Override
        public final Builder fileShareStatus(String fileShareStatus) {
            this.fileShareStatus = fileShareStatus;
            return this;
        }

        public final String getGatewayARN() {
            return gatewayARN;
        }

        public final void setGatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
        }

        @Override
        public final Builder gatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
            return this;
        }

        public final Boolean getKmsEncrypted() {
            return kmsEncrypted;
        }

        public final void setKmsEncrypted(Boolean kmsEncrypted) {
            this.kmsEncrypted = kmsEncrypted;
        }

        @Override
        public final Builder kmsEncrypted(Boolean kmsEncrypted) {
            this.kmsEncrypted = kmsEncrypted;
            return this;
        }

        public final String getKmsKey() {
            return kmsKey;
        }

        public final void setKmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
        }

        @Override
        public final Builder kmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
            return this;
        }

        public final String getPath() {
            return path;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final String getRole() {
            return role;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        public final String getLocationARN() {
            return locationARN;
        }

        public final void setLocationARN(String locationARN) {
            this.locationARN = locationARN;
        }

        @Override
        public final Builder locationARN(String locationARN) {
            this.locationARN = locationARN;
            return this;
        }

        public final String getDefaultStorageClass() {
            return defaultStorageClass;
        }

        public final void setDefaultStorageClass(String defaultStorageClass) {
            this.defaultStorageClass = defaultStorageClass;
        }

        @Override
        public final Builder defaultStorageClass(String defaultStorageClass) {
            this.defaultStorageClass = defaultStorageClass;
            return this;
        }

        public final String getObjectACL() {
            return objectACL;
        }

        public final void setObjectACL(String objectACL) {
            this.objectACL = objectACL;
        }

        @Override
        public final Builder objectACL(String objectACL) {
            this.objectACL = objectACL;
            return this;
        }

        @Override
        public final Builder objectACL(ObjectACL objectACL) {
            this.objectACL(objectACL == null ? null : objectACL.toString());
            return this;
        }

        public final Collection<String> getClientList() {
            if (clientList instanceof SdkAutoConstructList) {
                return null;
            }
            return clientList;
        }

        public final void setClientList(Collection<String> clientList) {
            this.clientList = FileShareClientListCopier.copy(clientList);
        }

        @Override
        public final Builder clientList(Collection<String> clientList) {
            this.clientList = FileShareClientListCopier.copy(clientList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clientList(String... clientList) {
            clientList(Arrays.asList(clientList));
            return this;
        }

        public final String getSquash() {
            return squash;
        }

        public final void setSquash(String squash) {
            this.squash = squash;
        }

        @Override
        public final Builder squash(String squash) {
            this.squash = squash;
            return this;
        }

        public final Boolean getReadOnly() {
            return readOnly;
        }

        public final void setReadOnly(Boolean readOnly) {
            this.readOnly = readOnly;
        }

        @Override
        public final Builder readOnly(Boolean readOnly) {
            this.readOnly = readOnly;
            return this;
        }

        public final Boolean getGuessMIMETypeEnabled() {
            return guessMIMETypeEnabled;
        }

        public final void setGuessMIMETypeEnabled(Boolean guessMIMETypeEnabled) {
            this.guessMIMETypeEnabled = guessMIMETypeEnabled;
        }

        @Override
        public final Builder guessMIMETypeEnabled(Boolean guessMIMETypeEnabled) {
            this.guessMIMETypeEnabled = guessMIMETypeEnabled;
            return this;
        }

        public final Boolean getRequesterPays() {
            return requesterPays;
        }

        public final void setRequesterPays(Boolean requesterPays) {
            this.requesterPays = requesterPays;
        }

        @Override
        public final Builder requesterPays(Boolean requesterPays) {
            this.requesterPays = requesterPays;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getFileShareName() {
            return fileShareName;
        }

        public final void setFileShareName(String fileShareName) {
            this.fileShareName = fileShareName;
        }

        @Override
        public final Builder fileShareName(String fileShareName) {
            this.fileShareName = fileShareName;
            return this;
        }

        public final CacheAttributes.Builder getCacheAttributes() {
            return cacheAttributes != null ? cacheAttributes.toBuilder() : null;
        }

        public final void setCacheAttributes(CacheAttributes.BuilderImpl cacheAttributes) {
            this.cacheAttributes = cacheAttributes != null ? cacheAttributes.build() : null;
        }

        @Override
        public final Builder cacheAttributes(CacheAttributes cacheAttributes) {
            this.cacheAttributes = cacheAttributes;
            return this;
        }

        public final String getNotificationPolicy() {
            return notificationPolicy;
        }

        public final void setNotificationPolicy(String notificationPolicy) {
            this.notificationPolicy = notificationPolicy;
        }

        @Override
        public final Builder notificationPolicy(String notificationPolicy) {
            this.notificationPolicy = notificationPolicy;
            return this;
        }

        public final String getVpcEndpointDNSName() {
            return vpcEndpointDNSName;
        }

        public final void setVpcEndpointDNSName(String vpcEndpointDNSName) {
            this.vpcEndpointDNSName = vpcEndpointDNSName;
        }

        @Override
        public final Builder vpcEndpointDNSName(String vpcEndpointDNSName) {
            this.vpcEndpointDNSName = vpcEndpointDNSName;
            return this;
        }

        public final String getBucketRegion() {
            return bucketRegion;
        }

        public final void setBucketRegion(String bucketRegion) {
            this.bucketRegion = bucketRegion;
        }

        @Override
        public final Builder bucketRegion(String bucketRegion) {
            this.bucketRegion = bucketRegion;
            return this;
        }

        public final String getAuditDestinationARN() {
            return auditDestinationARN;
        }

        public final void setAuditDestinationARN(String auditDestinationARN) {
            this.auditDestinationARN = auditDestinationARN;
        }

        @Override
        public final Builder auditDestinationARN(String auditDestinationARN) {
            this.auditDestinationARN = auditDestinationARN;
            return this;
        }

        @Override
        public NFSFileShareInfo build() {
            return new NFSFileShareInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
