/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.storagegateway.StorageGatewayClient;
import software.amazon.awssdk.services.storagegateway.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.storagegateway.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.storagegateway.model.Tag;

public class ListTagsForResourceIterable
implements SdkIterable<ListTagsForResourceResponse> {
    private final StorageGatewayClient client;
    private final ListTagsForResourceRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTagsForResourceIterable(StorageGatewayClient client, ListTagsForResourceRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListTagsForResourceResponseFetcher();
    }

    public Iterator<ListTagsForResourceResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Tag> tags() {
        Function<ListTagsForResourceResponse, Iterator> getIterator = response -> {
            if (response != null && response.tags() != null) {
                return response.tags().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListTagsForResourceResponseFetcher
    implements SyncPageFetcher<ListTagsForResourceResponse> {
        private ListTagsForResourceResponseFetcher() {
        }

        public boolean hasNextPage(ListTagsForResourceResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public ListTagsForResourceResponse nextPage(ListTagsForResourceResponse previousPage) {
            if (previousPage == null) {
                return ListTagsForResourceIterable.this.client.listTagsForResource(ListTagsForResourceIterable.this.firstRequest);
            }
            return ListTagsForResourceIterable.this.client.listTagsForResource((ListTagsForResourceRequest)((Object)ListTagsForResourceIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

