/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.storagegateway.DefaultStorageGatewayAsyncClient;
import software.amazon.awssdk.services.storagegateway.DefaultStorageGatewayBaseClientBuilder;
import software.amazon.awssdk.services.storagegateway.StorageGatewayAsyncClient;
import software.amazon.awssdk.services.storagegateway.StorageGatewayAsyncClientBuilder;
import software.amazon.awssdk.services.storagegateway.StorageGatewayServiceClientConfiguration;
import software.amazon.awssdk.services.storagegateway.endpoints.StorageGatewayEndpointProvider;

@SdkInternalApi
final class DefaultStorageGatewayAsyncClientBuilder
extends DefaultStorageGatewayBaseClientBuilder<StorageGatewayAsyncClientBuilder, StorageGatewayAsyncClient>
implements StorageGatewayAsyncClientBuilder {
    DefaultStorageGatewayAsyncClientBuilder() {
    }

    @Override
    public DefaultStorageGatewayAsyncClientBuilder endpointProvider(StorageGatewayEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final StorageGatewayAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultStorageGatewayAsyncClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        StorageGatewayServiceClientConfiguration serviceClientConfiguration = StorageGatewayServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultStorageGatewayAsyncClient(serviceClientConfiguration, clientConfiguration);
    }
}

