/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An automatic tape creation policy consists of automatic tape creation rules where each rule defines when and how to
 * create new tapes. For more information about automatic tape creation, see <a href=
 * "https://docs.aws.amazon.com/storagegateway/latest/userguide/GettingStartedCreateTapes.html#CreateTapesAutomatically"
 * >Creating Tapes Automatically</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutomaticTapeCreationRule implements SdkPojo, Serializable,
        ToCopyableBuilder<AutomaticTapeCreationRule.Builder, AutomaticTapeCreationRule> {
    private static final SdkField<String> TAPE_BARCODE_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TapeBarcodePrefix").getter(getter(AutomaticTapeCreationRule::tapeBarcodePrefix))
            .setter(setter(Builder::tapeBarcodePrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TapeBarcodePrefix").build()).build();

    private static final SdkField<String> POOL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("PoolId")
            .getter(getter(AutomaticTapeCreationRule::poolId)).setter(setter(Builder::poolId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoolId").build()).build();

    private static final SdkField<Long> TAPE_SIZE_IN_BYTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("TapeSizeInBytes").getter(getter(AutomaticTapeCreationRule::tapeSizeInBytes))
            .setter(setter(Builder::tapeSizeInBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TapeSizeInBytes").build()).build();

    private static final SdkField<Integer> MINIMUM_NUM_TAPES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MinimumNumTapes").getter(getter(AutomaticTapeCreationRule::minimumNumTapes))
            .setter(setter(Builder::minimumNumTapes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinimumNumTapes").build()).build();

    private static final SdkField<Boolean> WORM_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN).memberName("Worm")
            .getter(getter(AutomaticTapeCreationRule::worm)).setter(setter(Builder::worm))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Worm").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TAPE_BARCODE_PREFIX_FIELD,
            POOL_ID_FIELD, TAPE_SIZE_IN_BYTES_FIELD, MINIMUM_NUM_TAPES_FIELD, WORM_FIELD));

    private static final long serialVersionUID = 1L;

    private final String tapeBarcodePrefix;

    private final String poolId;

    private final Long tapeSizeInBytes;

    private final Integer minimumNumTapes;

    private final Boolean worm;

    private AutomaticTapeCreationRule(BuilderImpl builder) {
        this.tapeBarcodePrefix = builder.tapeBarcodePrefix;
        this.poolId = builder.poolId;
        this.tapeSizeInBytes = builder.tapeSizeInBytes;
        this.minimumNumTapes = builder.minimumNumTapes;
        this.worm = builder.worm;
    }

    /**
     * <p>
     * A prefix that you append to the barcode of the virtual tape that you are creating. This prefix makes the barcode
     * unique.
     * </p>
     * <note>
     * <p>
     * The prefix must be 1-4 characters in length and must be one of the uppercase letters from A to Z.
     * </p>
     * </note>
     * 
     * @return A prefix that you append to the barcode of the virtual tape that you are creating. This prefix makes the
     *         barcode unique.</p> <note>
     *         <p>
     *         The prefix must be 1-4 characters in length and must be one of the uppercase letters from A to Z.
     *         </p>
     */
    public final String tapeBarcodePrefix() {
        return tapeBarcodePrefix;
    }

    /**
     * <p>
     * The ID of the pool that you want to add your tape to for archiving. The tape in this pool is archived in the
     * Amazon S3 storage class that is associated with the pool. When you use your backup application to eject the tape,
     * the tape is archived directly into the storage class (S3 Glacier or S3 Glacier Deep Archive) that corresponds to
     * the pool.
     * </p>
     * 
     * @return The ID of the pool that you want to add your tape to for archiving. The tape in this pool is archived in
     *         the Amazon S3 storage class that is associated with the pool. When you use your backup application to
     *         eject the tape, the tape is archived directly into the storage class (S3 Glacier or S3 Glacier Deep
     *         Archive) that corresponds to the pool.
     */
    public final String poolId() {
        return poolId;
    }

    /**
     * <p>
     * The size, in bytes, of the virtual tape capacity.
     * </p>
     * 
     * @return The size, in bytes, of the virtual tape capacity.
     */
    public final Long tapeSizeInBytes() {
        return tapeSizeInBytes;
    }

    /**
     * <p>
     * The minimum number of available virtual tapes that the gateway maintains at all times. If the number of tapes on
     * the gateway goes below this value, the gateway creates as many new tapes as are needed to have
     * <code>MinimumNumTapes</code> on the gateway. For more information about automatic tape creation, see <a href=
     * "https://docs.aws.amazon.com/storagegateway/latest/userguide/GettingStartedCreateTapes.html#CreateTapesAutomatically"
     * >Creating Tapes Automatically</a>.
     * </p>
     * 
     * @return The minimum number of available virtual tapes that the gateway maintains at all times. If the number of
     *         tapes on the gateway goes below this value, the gateway creates as many new tapes as are needed to have
     *         <code>MinimumNumTapes</code> on the gateway. For more information about automatic tape creation, see <a
     *         href=
     *         "https://docs.aws.amazon.com/storagegateway/latest/userguide/GettingStartedCreateTapes.html#CreateTapesAutomatically"
     *         >Creating Tapes Automatically</a>.
     */
    public final Integer minimumNumTapes() {
        return minimumNumTapes;
    }

    /**
     * <p>
     * Set to <code>true</code> to indicate that tapes are to be archived as write-once-read-many (WORM). Set to
     * <code>false</code> when WORM is not enabled for tapes.
     * </p>
     * 
     * @return Set to <code>true</code> to indicate that tapes are to be archived as write-once-read-many (WORM). Set to
     *         <code>false</code> when WORM is not enabled for tapes.
     */
    public final Boolean worm() {
        return worm;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(tapeBarcodePrefix());
        hashCode = 31 * hashCode + Objects.hashCode(poolId());
        hashCode = 31 * hashCode + Objects.hashCode(tapeSizeInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(minimumNumTapes());
        hashCode = 31 * hashCode + Objects.hashCode(worm());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutomaticTapeCreationRule)) {
            return false;
        }
        AutomaticTapeCreationRule other = (AutomaticTapeCreationRule) obj;
        return Objects.equals(tapeBarcodePrefix(), other.tapeBarcodePrefix()) && Objects.equals(poolId(), other.poolId())
                && Objects.equals(tapeSizeInBytes(), other.tapeSizeInBytes())
                && Objects.equals(minimumNumTapes(), other.minimumNumTapes()) && Objects.equals(worm(), other.worm());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutomaticTapeCreationRule").add("TapeBarcodePrefix", tapeBarcodePrefix())
                .add("PoolId", poolId()).add("TapeSizeInBytes", tapeSizeInBytes()).add("MinimumNumTapes", minimumNumTapes())
                .add("Worm", worm()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TapeBarcodePrefix":
            return Optional.ofNullable(clazz.cast(tapeBarcodePrefix()));
        case "PoolId":
            return Optional.ofNullable(clazz.cast(poolId()));
        case "TapeSizeInBytes":
            return Optional.ofNullable(clazz.cast(tapeSizeInBytes()));
        case "MinimumNumTapes":
            return Optional.ofNullable(clazz.cast(minimumNumTapes()));
        case "Worm":
            return Optional.ofNullable(clazz.cast(worm()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AutomaticTapeCreationRule, T> g) {
        return obj -> g.apply((AutomaticTapeCreationRule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutomaticTapeCreationRule> {
        /**
         * <p>
         * A prefix that you append to the barcode of the virtual tape that you are creating. This prefix makes the
         * barcode unique.
         * </p>
         * <note>
         * <p>
         * The prefix must be 1-4 characters in length and must be one of the uppercase letters from A to Z.
         * </p>
         * </note>
         * 
         * @param tapeBarcodePrefix
         *        A prefix that you append to the barcode of the virtual tape that you are creating. This prefix makes
         *        the barcode unique.</p> <note>
         *        <p>
         *        The prefix must be 1-4 characters in length and must be one of the uppercase letters from A to Z.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tapeBarcodePrefix(String tapeBarcodePrefix);

        /**
         * <p>
         * The ID of the pool that you want to add your tape to for archiving. The tape in this pool is archived in the
         * Amazon S3 storage class that is associated with the pool. When you use your backup application to eject the
         * tape, the tape is archived directly into the storage class (S3 Glacier or S3 Glacier Deep Archive) that
         * corresponds to the pool.
         * </p>
         * 
         * @param poolId
         *        The ID of the pool that you want to add your tape to for archiving. The tape in this pool is archived
         *        in the Amazon S3 storage class that is associated with the pool. When you use your backup application
         *        to eject the tape, the tape is archived directly into the storage class (S3 Glacier or S3 Glacier Deep
         *        Archive) that corresponds to the pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder poolId(String poolId);

        /**
         * <p>
         * The size, in bytes, of the virtual tape capacity.
         * </p>
         * 
         * @param tapeSizeInBytes
         *        The size, in bytes, of the virtual tape capacity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tapeSizeInBytes(Long tapeSizeInBytes);

        /**
         * <p>
         * The minimum number of available virtual tapes that the gateway maintains at all times. If the number of tapes
         * on the gateway goes below this value, the gateway creates as many new tapes as are needed to have
         * <code>MinimumNumTapes</code> on the gateway. For more information about automatic tape creation, see <a href=
         * "https://docs.aws.amazon.com/storagegateway/latest/userguide/GettingStartedCreateTapes.html#CreateTapesAutomatically"
         * >Creating Tapes Automatically</a>.
         * </p>
         * 
         * @param minimumNumTapes
         *        The minimum number of available virtual tapes that the gateway maintains at all times. If the number
         *        of tapes on the gateway goes below this value, the gateway creates as many new tapes as are needed to
         *        have <code>MinimumNumTapes</code> on the gateway. For more information about automatic tape creation,
         *        see <a href=
         *        "https://docs.aws.amazon.com/storagegateway/latest/userguide/GettingStartedCreateTapes.html#CreateTapesAutomatically"
         *        >Creating Tapes Automatically</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minimumNumTapes(Integer minimumNumTapes);

        /**
         * <p>
         * Set to <code>true</code> to indicate that tapes are to be archived as write-once-read-many (WORM). Set to
         * <code>false</code> when WORM is not enabled for tapes.
         * </p>
         * 
         * @param worm
         *        Set to <code>true</code> to indicate that tapes are to be archived as write-once-read-many (WORM). Set
         *        to <code>false</code> when WORM is not enabled for tapes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder worm(Boolean worm);
    }

    static final class BuilderImpl implements Builder {
        private String tapeBarcodePrefix;

        private String poolId;

        private Long tapeSizeInBytes;

        private Integer minimumNumTapes;

        private Boolean worm;

        private BuilderImpl() {
        }

        private BuilderImpl(AutomaticTapeCreationRule model) {
            tapeBarcodePrefix(model.tapeBarcodePrefix);
            poolId(model.poolId);
            tapeSizeInBytes(model.tapeSizeInBytes);
            minimumNumTapes(model.minimumNumTapes);
            worm(model.worm);
        }

        public final String getTapeBarcodePrefix() {
            return tapeBarcodePrefix;
        }

        public final void setTapeBarcodePrefix(String tapeBarcodePrefix) {
            this.tapeBarcodePrefix = tapeBarcodePrefix;
        }

        @Override
        public final Builder tapeBarcodePrefix(String tapeBarcodePrefix) {
            this.tapeBarcodePrefix = tapeBarcodePrefix;
            return this;
        }

        public final String getPoolId() {
            return poolId;
        }

        public final void setPoolId(String poolId) {
            this.poolId = poolId;
        }

        @Override
        public final Builder poolId(String poolId) {
            this.poolId = poolId;
            return this;
        }

        public final Long getTapeSizeInBytes() {
            return tapeSizeInBytes;
        }

        public final void setTapeSizeInBytes(Long tapeSizeInBytes) {
            this.tapeSizeInBytes = tapeSizeInBytes;
        }

        @Override
        public final Builder tapeSizeInBytes(Long tapeSizeInBytes) {
            this.tapeSizeInBytes = tapeSizeInBytes;
            return this;
        }

        public final Integer getMinimumNumTapes() {
            return minimumNumTapes;
        }

        public final void setMinimumNumTapes(Integer minimumNumTapes) {
            this.minimumNumTapes = minimumNumTapes;
        }

        @Override
        public final Builder minimumNumTapes(Integer minimumNumTapes) {
            this.minimumNumTapes = minimumNumTapes;
            return this;
        }

        public final Boolean getWorm() {
            return worm;
        }

        public final void setWorm(Boolean worm) {
            this.worm = worm;
        }

        @Override
        public final Builder worm(Boolean worm) {
            this.worm = worm;
            return this;
        }

        @Override
        public AutomaticTapeCreationRule build() {
            return new AutomaticTapeCreationRule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
