/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.storagegateway.model.PoolARNsCopier;
import software.amazon.awssdk.services.storagegateway.model.StorageGatewayRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTapePoolsRequest
extends StorageGatewayRequest
implements ToCopyableBuilder<Builder, ListTapePoolsRequest> {
    private static final SdkField<List<String>> POOL_AR_NS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PoolARNs").getter(ListTapePoolsRequest.getter(ListTapePoolsRequest::poolARNs)).setter(ListTapePoolsRequest.setter(Builder::poolARNs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoolARNs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(ListTapePoolsRequest.getter(ListTapePoolsRequest::marker)).setter(ListTapePoolsRequest.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final SdkField<Integer> LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Limit").getter(ListTapePoolsRequest.getter(ListTapePoolsRequest::limit)).setter(ListTapePoolsRequest.setter(Builder::limit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limit").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POOL_AR_NS_FIELD, MARKER_FIELD, LIMIT_FIELD));
    private final List<String> poolARNs;
    private final String marker;
    private final Integer limit;

    private ListTapePoolsRequest(BuilderImpl builder) {
        super(builder);
        this.poolARNs = builder.poolARNs;
        this.marker = builder.marker;
        this.limit = builder.limit;
    }

    public final boolean hasPoolARNs() {
        return this.poolARNs != null && !(this.poolARNs instanceof SdkAutoConstructList);
    }

    public final List<String> poolARNs() {
        return this.poolARNs;
    }

    public final String marker() {
        return this.marker;
    }

    public final Integer limit() {
        return this.limit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPoolARNs() ? this.poolARNs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTapePoolsRequest)) {
            return false;
        }
        ListTapePoolsRequest other = (ListTapePoolsRequest)((Object)obj);
        return this.hasPoolARNs() == other.hasPoolARNs() && Objects.equals(this.poolARNs(), other.poolARNs()) && Objects.equals(this.marker(), other.marker()) && Objects.equals(this.limit(), other.limit());
    }

    public final String toString() {
        return ToString.builder((String)"ListTapePoolsRequest").add("PoolARNs", this.hasPoolARNs() ? this.poolARNs() : null).add("Marker", (Object)this.marker()).add("Limit", (Object)this.limit()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PoolARNs": {
                return Optional.ofNullable(clazz.cast(this.poolARNs()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "Limit": {
                return Optional.ofNullable(clazz.cast(this.limit()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTapePoolsRequest, T> g) {
        return obj -> g.apply((ListTapePoolsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends StorageGatewayRequest.BuilderImpl
    implements Builder {
        private List<String> poolARNs = DefaultSdkAutoConstructList.getInstance();
        private String marker;
        private Integer limit;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTapePoolsRequest model) {
            super(model);
            this.poolARNs(model.poolARNs);
            this.marker(model.marker);
            this.limit(model.limit);
        }

        public final Collection<String> getPoolARNs() {
            if (this.poolARNs instanceof SdkAutoConstructList) {
                return null;
            }
            return this.poolARNs;
        }

        public final void setPoolARNs(Collection<String> poolARNs) {
            this.poolARNs = PoolARNsCopier.copy(poolARNs);
        }

        @Override
        public final Builder poolARNs(Collection<String> poolARNs) {
            this.poolARNs = PoolARNsCopier.copy(poolARNs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder poolARNs(String ... poolARNs) {
            this.poolARNs(Arrays.asList(poolARNs));
            return this;
        }

        public final String getMarker() {
            return this.marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final Integer getLimit() {
            return this.limit;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListTapePoolsRequest build() {
            return new ListTapePoolsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends StorageGatewayRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTapePoolsRequest> {
        public Builder poolARNs(Collection<String> var1);

        public Builder poolARNs(String ... var1);

        public Builder marker(String var1);

        public Builder limit(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

