/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.storagegateway.StorageGatewayClient;
import software.amazon.awssdk.services.storagegateway.internal.UserAgentUtils;
import software.amazon.awssdk.services.storagegateway.model.FileSystemAssociationSummary;
import software.amazon.awssdk.services.storagegateway.model.ListFileSystemAssociationsRequest;
import software.amazon.awssdk.services.storagegateway.model.ListFileSystemAssociationsResponse;

public class ListFileSystemAssociationsIterable
implements SdkIterable<ListFileSystemAssociationsResponse> {
    private final StorageGatewayClient client;
    private final ListFileSystemAssociationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListFileSystemAssociationsIterable(StorageGatewayClient client, ListFileSystemAssociationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListFileSystemAssociationsResponseFetcher();
    }

    public Iterator<ListFileSystemAssociationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<FileSystemAssociationSummary> fileSystemAssociationSummaryList() {
        Function<ListFileSystemAssociationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.fileSystemAssociationSummaryList() != null) {
                return response.fileSystemAssociationSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListFileSystemAssociationsResponseFetcher
    implements SyncPageFetcher<ListFileSystemAssociationsResponse> {
        private ListFileSystemAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(ListFileSystemAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextMarker());
        }

        public ListFileSystemAssociationsResponse nextPage(ListFileSystemAssociationsResponse previousPage) {
            if (previousPage == null) {
                return ListFileSystemAssociationsIterable.this.client.listFileSystemAssociations(ListFileSystemAssociationsIterable.this.firstRequest);
            }
            return ListFileSystemAssociationsIterable.this.client.listFileSystemAssociations((ListFileSystemAssociationsRequest)((Object)ListFileSystemAssociationsIterable.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

