/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.storagegateway.StorageGatewayAsyncClient;
import software.amazon.awssdk.services.storagegateway.internal.UserAgentUtils;
import software.amazon.awssdk.services.storagegateway.model.FileShareInfo;
import software.amazon.awssdk.services.storagegateway.model.ListFileSharesRequest;
import software.amazon.awssdk.services.storagegateway.model.ListFileSharesResponse;

public class ListFileSharesPublisher
implements SdkPublisher<ListFileSharesResponse> {
    private final StorageGatewayAsyncClient client;
    private final ListFileSharesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListFileSharesPublisher(StorageGatewayAsyncClient client, ListFileSharesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListFileSharesPublisher(StorageGatewayAsyncClient client, ListFileSharesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListFileSharesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListFileSharesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<FileShareInfo> fileShareInfoList() {
        Function<ListFileSharesResponse, Iterator> getIterator = response -> {
            if (response != null && response.fileShareInfoList() != null) {
                return response.fileShareInfoList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListFileSharesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListFileSharesResponseFetcher
    implements AsyncPageFetcher<ListFileSharesResponse> {
        private ListFileSharesResponseFetcher() {
        }

        public boolean hasNextPage(ListFileSharesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextMarker());
        }

        public CompletableFuture<ListFileSharesResponse> nextPage(ListFileSharesResponse previousPage) {
            if (previousPage == null) {
                return ListFileSharesPublisher.this.client.listFileShares(ListFileSharesPublisher.this.firstRequest);
            }
            return ListFileSharesPublisher.this.client.listFileShares((ListFileSharesRequest)((Object)ListFileSharesPublisher.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

