/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.storagegateway.model.CacheAttributes;
import software.amazon.awssdk.services.storagegateway.model.EncryptionType;
import software.amazon.awssdk.services.storagegateway.model.FileShareClientListCopier;
import software.amazon.awssdk.services.storagegateway.model.NFSFileShareDefaults;
import software.amazon.awssdk.services.storagegateway.model.ObjectACL;
import software.amazon.awssdk.services.storagegateway.model.Tag;
import software.amazon.awssdk.services.storagegateway.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NFSFileShareInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NFSFileShareInfo> {
    private static final SdkField<NFSFileShareDefaults> NFS_FILE_SHARE_DEFAULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NFSFileShareDefaults").getter(NFSFileShareInfo.getter(NFSFileShareInfo::nfsFileShareDefaults)).setter(NFSFileShareInfo.setter(Builder::nfsFileShareDefaults)).constructor(NFSFileShareDefaults::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NFSFileShareDefaults").build()}).build();
    private static final SdkField<String> FILE_SHARE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FileShareARN").getter(NFSFileShareInfo.getter(NFSFileShareInfo::fileShareARN)).setter(NFSFileShareInfo.setter(Builder::fileShareARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileShareARN").build()}).build();
    private static final SdkField<String> FILE_SHARE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FileShareId").getter(NFSFileShareInfo.getter(NFSFileShareInfo::fileShareId)).setter(NFSFileShareInfo.setter(Builder::fileShareId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileShareId").build()}).build();
    private static final SdkField<String> FILE_SHARE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FileShareStatus").getter(NFSFileShareInfo.getter(NFSFileShareInfo::fileShareStatus)).setter(NFSFileShareInfo.setter(Builder::fileShareStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileShareStatus").build()}).build();
    private static final SdkField<String> GATEWAY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GatewayARN").getter(NFSFileShareInfo.getter(NFSFileShareInfo::gatewayARN)).setter(NFSFileShareInfo.setter(Builder::gatewayARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayARN").build()}).build();
    private static final SdkField<String> ENCRYPTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EncryptionType").getter(NFSFileShareInfo.getter(NFSFileShareInfo::encryptionTypeAsString)).setter(NFSFileShareInfo.setter(Builder::encryptionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionType").build()}).build();
    private static final SdkField<Boolean> KMS_ENCRYPTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("KMSEncrypted").getter(NFSFileShareInfo.getter(NFSFileShareInfo::kmsEncrypted)).setter(NFSFileShareInfo.setter(Builder::kmsEncrypted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KMSEncrypted").build()}).build();
    private static final SdkField<String> KMS_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KMSKey").getter(NFSFileShareInfo.getter(NFSFileShareInfo::kmsKey)).setter(NFSFileShareInfo.setter(Builder::kmsKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KMSKey").build()}).build();
    private static final SdkField<String> PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Path").getter(NFSFileShareInfo.getter(NFSFileShareInfo::path)).setter(NFSFileShareInfo.setter(Builder::path)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Path").build()}).build();
    private static final SdkField<String> ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Role").getter(NFSFileShareInfo.getter(NFSFileShareInfo::role)).setter(NFSFileShareInfo.setter(Builder::role)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Role").build()}).build();
    private static final SdkField<String> LOCATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LocationARN").getter(NFSFileShareInfo.getter(NFSFileShareInfo::locationARN)).setter(NFSFileShareInfo.setter(Builder::locationARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocationARN").build()}).build();
    private static final SdkField<String> DEFAULT_STORAGE_CLASS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DefaultStorageClass").getter(NFSFileShareInfo.getter(NFSFileShareInfo::defaultStorageClass)).setter(NFSFileShareInfo.setter(Builder::defaultStorageClass)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultStorageClass").build()}).build();
    private static final SdkField<String> OBJECT_ACL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ObjectACL").getter(NFSFileShareInfo.getter(NFSFileShareInfo::objectACLAsString)).setter(NFSFileShareInfo.setter(Builder::objectACL)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectACL").build()}).build();
    private static final SdkField<List<String>> CLIENT_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ClientList").getter(NFSFileShareInfo.getter(NFSFileShareInfo::clientList)).setter(NFSFileShareInfo.setter(Builder::clientList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SQUASH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Squash").getter(NFSFileShareInfo.getter(NFSFileShareInfo::squash)).setter(NFSFileShareInfo.setter(Builder::squash)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Squash").build()}).build();
    private static final SdkField<Boolean> READ_ONLY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ReadOnly").getter(NFSFileShareInfo.getter(NFSFileShareInfo::readOnly)).setter(NFSFileShareInfo.setter(Builder::readOnly)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReadOnly").build()}).build();
    private static final SdkField<Boolean> GUESS_MIME_TYPE_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("GuessMIMETypeEnabled").getter(NFSFileShareInfo.getter(NFSFileShareInfo::guessMIMETypeEnabled)).setter(NFSFileShareInfo.setter(Builder::guessMIMETypeEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GuessMIMETypeEnabled").build()}).build();
    private static final SdkField<Boolean> REQUESTER_PAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("RequesterPays").getter(NFSFileShareInfo.getter(NFSFileShareInfo::requesterPays)).setter(NFSFileShareInfo.setter(Builder::requesterPays)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequesterPays").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(NFSFileShareInfo.getter(NFSFileShareInfo::tags)).setter(NFSFileShareInfo.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> FILE_SHARE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FileShareName").getter(NFSFileShareInfo.getter(NFSFileShareInfo::fileShareName)).setter(NFSFileShareInfo.setter(Builder::fileShareName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileShareName").build()}).build();
    private static final SdkField<CacheAttributes> CACHE_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CacheAttributes").getter(NFSFileShareInfo.getter(NFSFileShareInfo::cacheAttributes)).setter(NFSFileShareInfo.setter(Builder::cacheAttributes)).constructor(CacheAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheAttributes").build()}).build();
    private static final SdkField<String> NOTIFICATION_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NotificationPolicy").getter(NFSFileShareInfo.getter(NFSFileShareInfo::notificationPolicy)).setter(NFSFileShareInfo.setter(Builder::notificationPolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationPolicy").build()}).build();
    private static final SdkField<String> VPC_ENDPOINT_DNS_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VPCEndpointDNSName").getter(NFSFileShareInfo.getter(NFSFileShareInfo::vpcEndpointDNSName)).setter(NFSFileShareInfo.setter(Builder::vpcEndpointDNSName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VPCEndpointDNSName").build()}).build();
    private static final SdkField<String> BUCKET_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BucketRegion").getter(NFSFileShareInfo.getter(NFSFileShareInfo::bucketRegion)).setter(NFSFileShareInfo.setter(Builder::bucketRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BucketRegion").build()}).build();
    private static final SdkField<String> AUDIT_DESTINATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AuditDestinationARN").getter(NFSFileShareInfo.getter(NFSFileShareInfo::auditDestinationARN)).setter(NFSFileShareInfo.setter(Builder::auditDestinationARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuditDestinationARN").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NFS_FILE_SHARE_DEFAULTS_FIELD, FILE_SHARE_ARN_FIELD, FILE_SHARE_ID_FIELD, FILE_SHARE_STATUS_FIELD, GATEWAY_ARN_FIELD, ENCRYPTION_TYPE_FIELD, KMS_ENCRYPTED_FIELD, KMS_KEY_FIELD, PATH_FIELD, ROLE_FIELD, LOCATION_ARN_FIELD, DEFAULT_STORAGE_CLASS_FIELD, OBJECT_ACL_FIELD, CLIENT_LIST_FIELD, SQUASH_FIELD, READ_ONLY_FIELD, GUESS_MIME_TYPE_ENABLED_FIELD, REQUESTER_PAYS_FIELD, TAGS_FIELD, FILE_SHARE_NAME_FIELD, CACHE_ATTRIBUTES_FIELD, NOTIFICATION_POLICY_FIELD, VPC_ENDPOINT_DNS_NAME_FIELD, BUCKET_REGION_FIELD, AUDIT_DESTINATION_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final NFSFileShareDefaults nfsFileShareDefaults;
    private final String fileShareARN;
    private final String fileShareId;
    private final String fileShareStatus;
    private final String gatewayARN;
    private final String encryptionType;
    private final Boolean kmsEncrypted;
    private final String kmsKey;
    private final String path;
    private final String role;
    private final String locationARN;
    private final String defaultStorageClass;
    private final String objectACL;
    private final List<String> clientList;
    private final String squash;
    private final Boolean readOnly;
    private final Boolean guessMIMETypeEnabled;
    private final Boolean requesterPays;
    private final List<Tag> tags;
    private final String fileShareName;
    private final CacheAttributes cacheAttributes;
    private final String notificationPolicy;
    private final String vpcEndpointDNSName;
    private final String bucketRegion;
    private final String auditDestinationARN;

    private NFSFileShareInfo(BuilderImpl builder) {
        this.nfsFileShareDefaults = builder.nfsFileShareDefaults;
        this.fileShareARN = builder.fileShareARN;
        this.fileShareId = builder.fileShareId;
        this.fileShareStatus = builder.fileShareStatus;
        this.gatewayARN = builder.gatewayARN;
        this.encryptionType = builder.encryptionType;
        this.kmsEncrypted = builder.kmsEncrypted;
        this.kmsKey = builder.kmsKey;
        this.path = builder.path;
        this.role = builder.role;
        this.locationARN = builder.locationARN;
        this.defaultStorageClass = builder.defaultStorageClass;
        this.objectACL = builder.objectACL;
        this.clientList = builder.clientList;
        this.squash = builder.squash;
        this.readOnly = builder.readOnly;
        this.guessMIMETypeEnabled = builder.guessMIMETypeEnabled;
        this.requesterPays = builder.requesterPays;
        this.tags = builder.tags;
        this.fileShareName = builder.fileShareName;
        this.cacheAttributes = builder.cacheAttributes;
        this.notificationPolicy = builder.notificationPolicy;
        this.vpcEndpointDNSName = builder.vpcEndpointDNSName;
        this.bucketRegion = builder.bucketRegion;
        this.auditDestinationARN = builder.auditDestinationARN;
    }

    public final NFSFileShareDefaults nfsFileShareDefaults() {
        return this.nfsFileShareDefaults;
    }

    public final String fileShareARN() {
        return this.fileShareARN;
    }

    public final String fileShareId() {
        return this.fileShareId;
    }

    public final String fileShareStatus() {
        return this.fileShareStatus;
    }

    public final String gatewayARN() {
        return this.gatewayARN;
    }

    public final EncryptionType encryptionType() {
        return EncryptionType.fromValue(this.encryptionType);
    }

    public final String encryptionTypeAsString() {
        return this.encryptionType;
    }

    @Deprecated
    public final Boolean kmsEncrypted() {
        return this.kmsEncrypted;
    }

    public final String kmsKey() {
        return this.kmsKey;
    }

    public final String path() {
        return this.path;
    }

    public final String role() {
        return this.role;
    }

    public final String locationARN() {
        return this.locationARN;
    }

    public final String defaultStorageClass() {
        return this.defaultStorageClass;
    }

    public final ObjectACL objectACL() {
        return ObjectACL.fromValue(this.objectACL);
    }

    public final String objectACLAsString() {
        return this.objectACL;
    }

    public final boolean hasClientList() {
        return this.clientList != null && !(this.clientList instanceof SdkAutoConstructList);
    }

    public final List<String> clientList() {
        return this.clientList;
    }

    public final String squash() {
        return this.squash;
    }

    public final Boolean readOnly() {
        return this.readOnly;
    }

    public final Boolean guessMIMETypeEnabled() {
        return this.guessMIMETypeEnabled;
    }

    public final Boolean requesterPays() {
        return this.requesterPays;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final String fileShareName() {
        return this.fileShareName;
    }

    public final CacheAttributes cacheAttributes() {
        return this.cacheAttributes;
    }

    public final String notificationPolicy() {
        return this.notificationPolicy;
    }

    public final String vpcEndpointDNSName() {
        return this.vpcEndpointDNSName;
    }

    public final String bucketRegion() {
        return this.bucketRegion;
    }

    public final String auditDestinationARN() {
        return this.auditDestinationARN;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.nfsFileShareDefaults());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileShareARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileShareId());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileShareStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsEncrypted());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.path());
        hashCode = 31 * hashCode + Objects.hashCode(this.role());
        hashCode = 31 * hashCode + Objects.hashCode(this.locationARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultStorageClass());
        hashCode = 31 * hashCode + Objects.hashCode(this.objectACLAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasClientList() ? this.clientList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.squash());
        hashCode = 31 * hashCode + Objects.hashCode(this.readOnly());
        hashCode = 31 * hashCode + Objects.hashCode(this.guessMIMETypeEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.requesterPays());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.fileShareName());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.notificationPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcEndpointDNSName());
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.auditDestinationARN());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NFSFileShareInfo)) {
            return false;
        }
        NFSFileShareInfo other = (NFSFileShareInfo)obj;
        return Objects.equals(this.nfsFileShareDefaults(), other.nfsFileShareDefaults()) && Objects.equals(this.fileShareARN(), other.fileShareARN()) && Objects.equals(this.fileShareId(), other.fileShareId()) && Objects.equals(this.fileShareStatus(), other.fileShareStatus()) && Objects.equals(this.gatewayARN(), other.gatewayARN()) && Objects.equals(this.encryptionTypeAsString(), other.encryptionTypeAsString()) && Objects.equals(this.kmsEncrypted(), other.kmsEncrypted()) && Objects.equals(this.kmsKey(), other.kmsKey()) && Objects.equals(this.path(), other.path()) && Objects.equals(this.role(), other.role()) && Objects.equals(this.locationARN(), other.locationARN()) && Objects.equals(this.defaultStorageClass(), other.defaultStorageClass()) && Objects.equals(this.objectACLAsString(), other.objectACLAsString()) && this.hasClientList() == other.hasClientList() && Objects.equals(this.clientList(), other.clientList()) && Objects.equals(this.squash(), other.squash()) && Objects.equals(this.readOnly(), other.readOnly()) && Objects.equals(this.guessMIMETypeEnabled(), other.guessMIMETypeEnabled()) && Objects.equals(this.requesterPays(), other.requesterPays()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.fileShareName(), other.fileShareName()) && Objects.equals(this.cacheAttributes(), other.cacheAttributes()) && Objects.equals(this.notificationPolicy(), other.notificationPolicy()) && Objects.equals(this.vpcEndpointDNSName(), other.vpcEndpointDNSName()) && Objects.equals(this.bucketRegion(), other.bucketRegion()) && Objects.equals(this.auditDestinationARN(), other.auditDestinationARN());
    }

    public final String toString() {
        return ToString.builder((String)"NFSFileShareInfo").add("NFSFileShareDefaults", (Object)this.nfsFileShareDefaults()).add("FileShareARN", (Object)this.fileShareARN()).add("FileShareId", (Object)this.fileShareId()).add("FileShareStatus", (Object)this.fileShareStatus()).add("GatewayARN", (Object)this.gatewayARN()).add("EncryptionType", (Object)this.encryptionTypeAsString()).add("KMSEncrypted", (Object)this.kmsEncrypted()).add("KMSKey", (Object)this.kmsKey()).add("Path", (Object)this.path()).add("Role", (Object)this.role()).add("LocationARN", (Object)this.locationARN()).add("DefaultStorageClass", (Object)this.defaultStorageClass()).add("ObjectACL", (Object)this.objectACLAsString()).add("ClientList", this.hasClientList() ? this.clientList() : null).add("Squash", (Object)this.squash()).add("ReadOnly", (Object)this.readOnly()).add("GuessMIMETypeEnabled", (Object)this.guessMIMETypeEnabled()).add("RequesterPays", (Object)this.requesterPays()).add("Tags", this.hasTags() ? this.tags() : null).add("FileShareName", (Object)this.fileShareName()).add("CacheAttributes", (Object)this.cacheAttributes()).add("NotificationPolicy", (Object)this.notificationPolicy()).add("VPCEndpointDNSName", (Object)this.vpcEndpointDNSName()).add("BucketRegion", (Object)this.bucketRegion()).add("AuditDestinationARN", (Object)this.auditDestinationARN()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NFSFileShareDefaults": {
                return Optional.ofNullable(clazz.cast(this.nfsFileShareDefaults()));
            }
            case "FileShareARN": {
                return Optional.ofNullable(clazz.cast(this.fileShareARN()));
            }
            case "FileShareId": {
                return Optional.ofNullable(clazz.cast(this.fileShareId()));
            }
            case "FileShareStatus": {
                return Optional.ofNullable(clazz.cast(this.fileShareStatus()));
            }
            case "GatewayARN": {
                return Optional.ofNullable(clazz.cast(this.gatewayARN()));
            }
            case "EncryptionType": {
                return Optional.ofNullable(clazz.cast(this.encryptionTypeAsString()));
            }
            case "KMSEncrypted": {
                return Optional.ofNullable(clazz.cast(this.kmsEncrypted()));
            }
            case "KMSKey": {
                return Optional.ofNullable(clazz.cast(this.kmsKey()));
            }
            case "Path": {
                return Optional.ofNullable(clazz.cast(this.path()));
            }
            case "Role": {
                return Optional.ofNullable(clazz.cast(this.role()));
            }
            case "LocationARN": {
                return Optional.ofNullable(clazz.cast(this.locationARN()));
            }
            case "DefaultStorageClass": {
                return Optional.ofNullable(clazz.cast(this.defaultStorageClass()));
            }
            case "ObjectACL": {
                return Optional.ofNullable(clazz.cast(this.objectACLAsString()));
            }
            case "ClientList": {
                return Optional.ofNullable(clazz.cast(this.clientList()));
            }
            case "Squash": {
                return Optional.ofNullable(clazz.cast(this.squash()));
            }
            case "ReadOnly": {
                return Optional.ofNullable(clazz.cast(this.readOnly()));
            }
            case "GuessMIMETypeEnabled": {
                return Optional.ofNullable(clazz.cast(this.guessMIMETypeEnabled()));
            }
            case "RequesterPays": {
                return Optional.ofNullable(clazz.cast(this.requesterPays()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "FileShareName": {
                return Optional.ofNullable(clazz.cast(this.fileShareName()));
            }
            case "CacheAttributes": {
                return Optional.ofNullable(clazz.cast(this.cacheAttributes()));
            }
            case "NotificationPolicy": {
                return Optional.ofNullable(clazz.cast(this.notificationPolicy()));
            }
            case "VPCEndpointDNSName": {
                return Optional.ofNullable(clazz.cast(this.vpcEndpointDNSName()));
            }
            case "BucketRegion": {
                return Optional.ofNullable(clazz.cast(this.bucketRegion()));
            }
            case "AuditDestinationARN": {
                return Optional.ofNullable(clazz.cast(this.auditDestinationARN()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NFSFileShareInfo, T> g) {
        return obj -> g.apply((NFSFileShareInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private NFSFileShareDefaults nfsFileShareDefaults;
        private String fileShareARN;
        private String fileShareId;
        private String fileShareStatus;
        private String gatewayARN;
        private String encryptionType;
        private Boolean kmsEncrypted;
        private String kmsKey;
        private String path;
        private String role;
        private String locationARN;
        private String defaultStorageClass;
        private String objectACL;
        private List<String> clientList = DefaultSdkAutoConstructList.getInstance();
        private String squash;
        private Boolean readOnly;
        private Boolean guessMIMETypeEnabled;
        private Boolean requesterPays;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String fileShareName;
        private CacheAttributes cacheAttributes;
        private String notificationPolicy;
        private String vpcEndpointDNSName;
        private String bucketRegion;
        private String auditDestinationARN;

        private BuilderImpl() {
        }

        private BuilderImpl(NFSFileShareInfo model) {
            this.nfsFileShareDefaults(model.nfsFileShareDefaults);
            this.fileShareARN(model.fileShareARN);
            this.fileShareId(model.fileShareId);
            this.fileShareStatus(model.fileShareStatus);
            this.gatewayARN(model.gatewayARN);
            this.encryptionType(model.encryptionType);
            this.kmsEncrypted(model.kmsEncrypted);
            this.kmsKey(model.kmsKey);
            this.path(model.path);
            this.role(model.role);
            this.locationARN(model.locationARN);
            this.defaultStorageClass(model.defaultStorageClass);
            this.objectACL(model.objectACL);
            this.clientList(model.clientList);
            this.squash(model.squash);
            this.readOnly(model.readOnly);
            this.guessMIMETypeEnabled(model.guessMIMETypeEnabled);
            this.requesterPays(model.requesterPays);
            this.tags(model.tags);
            this.fileShareName(model.fileShareName);
            this.cacheAttributes(model.cacheAttributes);
            this.notificationPolicy(model.notificationPolicy);
            this.vpcEndpointDNSName(model.vpcEndpointDNSName);
            this.bucketRegion(model.bucketRegion);
            this.auditDestinationARN(model.auditDestinationARN);
        }

        public final NFSFileShareDefaults.Builder getNfsFileShareDefaults() {
            return this.nfsFileShareDefaults != null ? this.nfsFileShareDefaults.toBuilder() : null;
        }

        public final void setNfsFileShareDefaults(NFSFileShareDefaults.BuilderImpl nfsFileShareDefaults) {
            this.nfsFileShareDefaults = nfsFileShareDefaults != null ? nfsFileShareDefaults.build() : null;
        }

        @Override
        public final Builder nfsFileShareDefaults(NFSFileShareDefaults nfsFileShareDefaults) {
            this.nfsFileShareDefaults = nfsFileShareDefaults;
            return this;
        }

        public final String getFileShareARN() {
            return this.fileShareARN;
        }

        public final void setFileShareARN(String fileShareARN) {
            this.fileShareARN = fileShareARN;
        }

        @Override
        public final Builder fileShareARN(String fileShareARN) {
            this.fileShareARN = fileShareARN;
            return this;
        }

        public final String getFileShareId() {
            return this.fileShareId;
        }

        public final void setFileShareId(String fileShareId) {
            this.fileShareId = fileShareId;
        }

        @Override
        public final Builder fileShareId(String fileShareId) {
            this.fileShareId = fileShareId;
            return this;
        }

        public final String getFileShareStatus() {
            return this.fileShareStatus;
        }

        public final void setFileShareStatus(String fileShareStatus) {
            this.fileShareStatus = fileShareStatus;
        }

        @Override
        public final Builder fileShareStatus(String fileShareStatus) {
            this.fileShareStatus = fileShareStatus;
            return this;
        }

        public final String getGatewayARN() {
            return this.gatewayARN;
        }

        public final void setGatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
        }

        @Override
        public final Builder gatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
            return this;
        }

        public final String getEncryptionType() {
            return this.encryptionType;
        }

        public final void setEncryptionType(String encryptionType) {
            this.encryptionType = encryptionType;
        }

        @Override
        public final Builder encryptionType(String encryptionType) {
            this.encryptionType = encryptionType;
            return this;
        }

        @Override
        public final Builder encryptionType(EncryptionType encryptionType) {
            this.encryptionType(encryptionType == null ? null : encryptionType.toString());
            return this;
        }

        @Deprecated
        public final Boolean getKmsEncrypted() {
            return this.kmsEncrypted;
        }

        @Deprecated
        public final void setKmsEncrypted(Boolean kmsEncrypted) {
            this.kmsEncrypted = kmsEncrypted;
        }

        @Override
        @Deprecated
        public final Builder kmsEncrypted(Boolean kmsEncrypted) {
            this.kmsEncrypted = kmsEncrypted;
            return this;
        }

        public final String getKmsKey() {
            return this.kmsKey;
        }

        public final void setKmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
        }

        @Override
        public final Builder kmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
            return this;
        }

        public final String getPath() {
            return this.path;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final String getRole() {
            return this.role;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        public final String getLocationARN() {
            return this.locationARN;
        }

        public final void setLocationARN(String locationARN) {
            this.locationARN = locationARN;
        }

        @Override
        public final Builder locationARN(String locationARN) {
            this.locationARN = locationARN;
            return this;
        }

        public final String getDefaultStorageClass() {
            return this.defaultStorageClass;
        }

        public final void setDefaultStorageClass(String defaultStorageClass) {
            this.defaultStorageClass = defaultStorageClass;
        }

        @Override
        public final Builder defaultStorageClass(String defaultStorageClass) {
            this.defaultStorageClass = defaultStorageClass;
            return this;
        }

        public final String getObjectACL() {
            return this.objectACL;
        }

        public final void setObjectACL(String objectACL) {
            this.objectACL = objectACL;
        }

        @Override
        public final Builder objectACL(String objectACL) {
            this.objectACL = objectACL;
            return this;
        }

        @Override
        public final Builder objectACL(ObjectACL objectACL) {
            this.objectACL(objectACL == null ? null : objectACL.toString());
            return this;
        }

        public final Collection<String> getClientList() {
            if (this.clientList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.clientList;
        }

        public final void setClientList(Collection<String> clientList) {
            this.clientList = FileShareClientListCopier.copy(clientList);
        }

        @Override
        public final Builder clientList(Collection<String> clientList) {
            this.clientList = FileShareClientListCopier.copy(clientList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clientList(String ... clientList) {
            this.clientList(Arrays.asList(clientList));
            return this;
        }

        public final String getSquash() {
            return this.squash;
        }

        public final void setSquash(String squash) {
            this.squash = squash;
        }

        @Override
        public final Builder squash(String squash) {
            this.squash = squash;
            return this;
        }

        public final Boolean getReadOnly() {
            return this.readOnly;
        }

        public final void setReadOnly(Boolean readOnly) {
            this.readOnly = readOnly;
        }

        @Override
        public final Builder readOnly(Boolean readOnly) {
            this.readOnly = readOnly;
            return this;
        }

        public final Boolean getGuessMIMETypeEnabled() {
            return this.guessMIMETypeEnabled;
        }

        public final void setGuessMIMETypeEnabled(Boolean guessMIMETypeEnabled) {
            this.guessMIMETypeEnabled = guessMIMETypeEnabled;
        }

        @Override
        public final Builder guessMIMETypeEnabled(Boolean guessMIMETypeEnabled) {
            this.guessMIMETypeEnabled = guessMIMETypeEnabled;
            return this;
        }

        public final Boolean getRequesterPays() {
            return this.requesterPays;
        }

        public final void setRequesterPays(Boolean requesterPays) {
            this.requesterPays = requesterPays;
        }

        @Override
        public final Builder requesterPays(Boolean requesterPays) {
            this.requesterPays = requesterPays;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getFileShareName() {
            return this.fileShareName;
        }

        public final void setFileShareName(String fileShareName) {
            this.fileShareName = fileShareName;
        }

        @Override
        public final Builder fileShareName(String fileShareName) {
            this.fileShareName = fileShareName;
            return this;
        }

        public final CacheAttributes.Builder getCacheAttributes() {
            return this.cacheAttributes != null ? this.cacheAttributes.toBuilder() : null;
        }

        public final void setCacheAttributes(CacheAttributes.BuilderImpl cacheAttributes) {
            this.cacheAttributes = cacheAttributes != null ? cacheAttributes.build() : null;
        }

        @Override
        public final Builder cacheAttributes(CacheAttributes cacheAttributes) {
            this.cacheAttributes = cacheAttributes;
            return this;
        }

        public final String getNotificationPolicy() {
            return this.notificationPolicy;
        }

        public final void setNotificationPolicy(String notificationPolicy) {
            this.notificationPolicy = notificationPolicy;
        }

        @Override
        public final Builder notificationPolicy(String notificationPolicy) {
            this.notificationPolicy = notificationPolicy;
            return this;
        }

        public final String getVpcEndpointDNSName() {
            return this.vpcEndpointDNSName;
        }

        public final void setVpcEndpointDNSName(String vpcEndpointDNSName) {
            this.vpcEndpointDNSName = vpcEndpointDNSName;
        }

        @Override
        public final Builder vpcEndpointDNSName(String vpcEndpointDNSName) {
            this.vpcEndpointDNSName = vpcEndpointDNSName;
            return this;
        }

        public final String getBucketRegion() {
            return this.bucketRegion;
        }

        public final void setBucketRegion(String bucketRegion) {
            this.bucketRegion = bucketRegion;
        }

        @Override
        public final Builder bucketRegion(String bucketRegion) {
            this.bucketRegion = bucketRegion;
            return this;
        }

        public final String getAuditDestinationARN() {
            return this.auditDestinationARN;
        }

        public final void setAuditDestinationARN(String auditDestinationARN) {
            this.auditDestinationARN = auditDestinationARN;
        }

        @Override
        public final Builder auditDestinationARN(String auditDestinationARN) {
            this.auditDestinationARN = auditDestinationARN;
            return this;
        }

        public NFSFileShareInfo build() {
            return new NFSFileShareInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NFSFileShareInfo> {
        public Builder nfsFileShareDefaults(NFSFileShareDefaults var1);

        default public Builder nfsFileShareDefaults(Consumer<NFSFileShareDefaults.Builder> nfsFileShareDefaults) {
            return this.nfsFileShareDefaults((NFSFileShareDefaults)((NFSFileShareDefaults.Builder)NFSFileShareDefaults.builder().applyMutation(nfsFileShareDefaults)).build());
        }

        public Builder fileShareARN(String var1);

        public Builder fileShareId(String var1);

        public Builder fileShareStatus(String var1);

        public Builder gatewayARN(String var1);

        public Builder encryptionType(String var1);

        public Builder encryptionType(EncryptionType var1);

        @Deprecated
        public Builder kmsEncrypted(Boolean var1);

        public Builder kmsKey(String var1);

        public Builder path(String var1);

        public Builder role(String var1);

        public Builder locationARN(String var1);

        public Builder defaultStorageClass(String var1);

        public Builder objectACL(String var1);

        public Builder objectACL(ObjectACL var1);

        public Builder clientList(Collection<String> var1);

        public Builder clientList(String ... var1);

        public Builder squash(String var1);

        public Builder readOnly(Boolean var1);

        public Builder guessMIMETypeEnabled(Boolean var1);

        public Builder requesterPays(Boolean var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder fileShareName(String var1);

        public Builder cacheAttributes(CacheAttributes var1);

        default public Builder cacheAttributes(Consumer<CacheAttributes.Builder> cacheAttributes) {
            return this.cacheAttributes((CacheAttributes)((CacheAttributes.Builder)CacheAttributes.builder().applyMutation(cacheAttributes)).build());
        }

        public Builder notificationPolicy(String var1);

        public Builder vpcEndpointDNSName(String var1);

        public Builder bucketRegion(String var1);

        public Builder auditDestinationARN(String var1);
    }
}

