/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * AttachVolumeOutput
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AttachVolumeResponse extends StorageGatewayResponse implements
        ToCopyableBuilder<AttachVolumeResponse.Builder, AttachVolumeResponse> {
    private static final SdkField<String> VOLUME_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VolumeARN").getter(getter(AttachVolumeResponse::volumeARN)).setter(setter(Builder::volumeARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeARN").build()).build();

    private static final SdkField<String> TARGET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetARN").getter(getter(AttachVolumeResponse::targetARN)).setter(setter(Builder::targetARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetARN").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOLUME_ARN_FIELD,
            TARGET_ARN_FIELD));

    private final String volumeARN;

    private final String targetARN;

    private AttachVolumeResponse(BuilderImpl builder) {
        super(builder);
        this.volumeARN = builder.volumeARN;
        this.targetARN = builder.targetARN;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the volume that was attached to the gateway.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the volume that was attached to the gateway.
     */
    public final String volumeARN() {
        return volumeARN;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the volume target, which includes the iSCSI name for the initiator that was
     * used to connect to the target.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the volume target, which includes the iSCSI name for the initiator that
     *         was used to connect to the target.
     */
    public final String targetARN() {
        return targetARN;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(volumeARN());
        hashCode = 31 * hashCode + Objects.hashCode(targetARN());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttachVolumeResponse)) {
            return false;
        }
        AttachVolumeResponse other = (AttachVolumeResponse) obj;
        return Objects.equals(volumeARN(), other.volumeARN()) && Objects.equals(targetARN(), other.targetARN());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AttachVolumeResponse").add("VolumeARN", volumeARN()).add("TargetARN", targetARN()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VolumeARN":
            return Optional.ofNullable(clazz.cast(volumeARN()));
        case "TargetARN":
            return Optional.ofNullable(clazz.cast(targetARN()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AttachVolumeResponse, T> g) {
        return obj -> g.apply((AttachVolumeResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends StorageGatewayResponse.Builder, SdkPojo, CopyableBuilder<Builder, AttachVolumeResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the volume that was attached to the gateway.
         * </p>
         * 
         * @param volumeARN
         *        The Amazon Resource Name (ARN) of the volume that was attached to the gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeARN(String volumeARN);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the volume target, which includes the iSCSI name for the initiator that was
         * used to connect to the target.
         * </p>
         * 
         * @param targetARN
         *        The Amazon Resource Name (ARN) of the volume target, which includes the iSCSI name for the initiator
         *        that was used to connect to the target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetARN(String targetARN);
    }

    static final class BuilderImpl extends StorageGatewayResponse.BuilderImpl implements Builder {
        private String volumeARN;

        private String targetARN;

        private BuilderImpl() {
        }

        private BuilderImpl(AttachVolumeResponse model) {
            super(model);
            volumeARN(model.volumeARN);
            targetARN(model.targetARN);
        }

        public final String getVolumeARN() {
            return volumeARN;
        }

        public final void setVolumeARN(String volumeARN) {
            this.volumeARN = volumeARN;
        }

        @Override
        public final Builder volumeARN(String volumeARN) {
            this.volumeARN = volumeARN;
            return this;
        }

        public final String getTargetARN() {
            return targetARN;
        }

        public final void setTargetARN(String targetARN) {
            this.targetARN = targetARN;
        }

        @Override
        public final Builder targetARN(String targetARN) {
            this.targetARN = targetARN;
            return this;
        }

        @Override
        public AttachVolumeResponse build() {
            return new AttachVolumeResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
