/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.storagegateway.model.CacheAttributes;
import software.amazon.awssdk.services.storagegateway.model.CaseSensitivity;
import software.amazon.awssdk.services.storagegateway.model.EncryptionType;
import software.amazon.awssdk.services.storagegateway.model.ObjectACL;
import software.amazon.awssdk.services.storagegateway.model.StorageGatewayRequest;
import software.amazon.awssdk.services.storagegateway.model.UserListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateSmbFileShareRequest
extends StorageGatewayRequest
implements ToCopyableBuilder<Builder, UpdateSmbFileShareRequest> {
    private static final SdkField<String> FILE_SHARE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FileShareARN").getter(UpdateSmbFileShareRequest.getter(UpdateSmbFileShareRequest::fileShareARN)).setter(UpdateSmbFileShareRequest.setter(Builder::fileShareARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileShareARN").build()}).build();
    private static final SdkField<String> ENCRYPTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EncryptionType").getter(UpdateSmbFileShareRequest.getter(UpdateSmbFileShareRequest::encryptionTypeAsString)).setter(UpdateSmbFileShareRequest.setter(Builder::encryptionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionType").build()}).build();
    private static final SdkField<Boolean> KMS_ENCRYPTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("KMSEncrypted").getter(UpdateSmbFileShareRequest.getter(UpdateSmbFileShareRequest::kmsEncrypted)).setter(UpdateSmbFileShareRequest.setter(Builder::kmsEncrypted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KMSEncrypted").build()}).build();
    private static final SdkField<String> KMS_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KMSKey").getter(UpdateSmbFileShareRequest.getter(UpdateSmbFileShareRequest::kmsKey)).setter(UpdateSmbFileShareRequest.setter(Builder::kmsKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KMSKey").build()}).build();
    private static final SdkField<String> DEFAULT_STORAGE_CLASS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DefaultStorageClass").getter(UpdateSmbFileShareRequest.getter(UpdateSmbFileShareRequest::defaultStorageClass)).setter(UpdateSmbFileShareRequest.setter(Builder::defaultStorageClass)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultStorageClass").build()}).build();
    private static final SdkField<String> OBJECT_ACL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ObjectACL").getter(UpdateSmbFileShareRequest.getter(UpdateSmbFileShareRequest::objectACLAsString)).setter(UpdateSmbFileShareRequest.setter(Builder::objectACL)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectACL").build()}).build();
    private static final SdkField<Boolean> READ_ONLY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ReadOnly").getter(UpdateSmbFileShareRequest.getter(UpdateSmbFileShareRequest::readOnly)).setter(UpdateSmbFileShareRequest.setter(Builder::readOnly)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReadOnly").build()}).build();
    private static final SdkField<Boolean> GUESS_MIME_TYPE_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("GuessMIMETypeEnabled").getter(UpdateSmbFileShareRequest.getter(UpdateSmbFileShareRequest::guessMIMETypeEnabled)).setter(UpdateSmbFileShareRequest.setter(Builder::guessMIMETypeEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GuessMIMETypeEnabled").build()}).build();
    private static final SdkField<Boolean> REQUESTER_PAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("RequesterPays").getter(UpdateSmbFileShareRequest.getter(UpdateSmbFileShareRequest::requesterPays)).setter(UpdateSmbFileShareRequest.setter(Builder::requesterPays)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequesterPays").build()}).build();
    private static final SdkField<Boolean> SMBACL_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("SMBACLEnabled").getter(UpdateSmbFileShareRequest.getter(UpdateSmbFileShareRequest::smbaclEnabled)).setter(UpdateSmbFileShareRequest.setter(Builder::smbaclEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SMBACLEnabled").build()}).build();
    private static final SdkField<Boolean> ACCESS_BASED_ENUMERATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AccessBasedEnumeration").getter(UpdateSmbFileShareRequest.getter(UpdateSmbFileShareRequest::accessBasedEnumeration)).setter(UpdateSmbFileShareRequest.setter(Builder::accessBasedEnumeration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessBasedEnumeration").build()}).build();
    private static final SdkField<List<String>> ADMIN_USER_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AdminUserList").getter(UpdateSmbFileShareRequest.getter(UpdateSmbFileShareRequest::adminUserList)).setter(UpdateSmbFileShareRequest.setter(Builder::adminUserList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdminUserList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> VALID_USER_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ValidUserList").getter(UpdateSmbFileShareRequest.getter(UpdateSmbFileShareRequest::validUserList)).setter(UpdateSmbFileShareRequest.setter(Builder::validUserList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidUserList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> INVALID_USER_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InvalidUserList").getter(UpdateSmbFileShareRequest.getter(UpdateSmbFileShareRequest::invalidUserList)).setter(UpdateSmbFileShareRequest.setter(Builder::invalidUserList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvalidUserList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> AUDIT_DESTINATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AuditDestinationARN").getter(UpdateSmbFileShareRequest.getter(UpdateSmbFileShareRequest::auditDestinationARN)).setter(UpdateSmbFileShareRequest.setter(Builder::auditDestinationARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuditDestinationARN").build()}).build();
    private static final SdkField<String> CASE_SENSITIVITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CaseSensitivity").getter(UpdateSmbFileShareRequest.getter(UpdateSmbFileShareRequest::caseSensitivityAsString)).setter(UpdateSmbFileShareRequest.setter(Builder::caseSensitivity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CaseSensitivity").build()}).build();
    private static final SdkField<String> FILE_SHARE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FileShareName").getter(UpdateSmbFileShareRequest.getter(UpdateSmbFileShareRequest::fileShareName)).setter(UpdateSmbFileShareRequest.setter(Builder::fileShareName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileShareName").build()}).build();
    private static final SdkField<CacheAttributes> CACHE_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CacheAttributes").getter(UpdateSmbFileShareRequest.getter(UpdateSmbFileShareRequest::cacheAttributes)).setter(UpdateSmbFileShareRequest.setter(Builder::cacheAttributes)).constructor(CacheAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheAttributes").build()}).build();
    private static final SdkField<String> NOTIFICATION_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NotificationPolicy").getter(UpdateSmbFileShareRequest.getter(UpdateSmbFileShareRequest::notificationPolicy)).setter(UpdateSmbFileShareRequest.setter(Builder::notificationPolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationPolicy").build()}).build();
    private static final SdkField<Boolean> OPLOCKS_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("OplocksEnabled").getter(UpdateSmbFileShareRequest.getter(UpdateSmbFileShareRequest::oplocksEnabled)).setter(UpdateSmbFileShareRequest.setter(Builder::oplocksEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OplocksEnabled").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_SHARE_ARN_FIELD, ENCRYPTION_TYPE_FIELD, KMS_ENCRYPTED_FIELD, KMS_KEY_FIELD, DEFAULT_STORAGE_CLASS_FIELD, OBJECT_ACL_FIELD, READ_ONLY_FIELD, GUESS_MIME_TYPE_ENABLED_FIELD, REQUESTER_PAYS_FIELD, SMBACL_ENABLED_FIELD, ACCESS_BASED_ENUMERATION_FIELD, ADMIN_USER_LIST_FIELD, VALID_USER_LIST_FIELD, INVALID_USER_LIST_FIELD, AUDIT_DESTINATION_ARN_FIELD, CASE_SENSITIVITY_FIELD, FILE_SHARE_NAME_FIELD, CACHE_ATTRIBUTES_FIELD, NOTIFICATION_POLICY_FIELD, OPLOCKS_ENABLED_FIELD));
    private final String fileShareARN;
    private final String encryptionType;
    private final Boolean kmsEncrypted;
    private final String kmsKey;
    private final String defaultStorageClass;
    private final String objectACL;
    private final Boolean readOnly;
    private final Boolean guessMIMETypeEnabled;
    private final Boolean requesterPays;
    private final Boolean smbaclEnabled;
    private final Boolean accessBasedEnumeration;
    private final List<String> adminUserList;
    private final List<String> validUserList;
    private final List<String> invalidUserList;
    private final String auditDestinationARN;
    private final String caseSensitivity;
    private final String fileShareName;
    private final CacheAttributes cacheAttributes;
    private final String notificationPolicy;
    private final Boolean oplocksEnabled;

    private UpdateSmbFileShareRequest(BuilderImpl builder) {
        super(builder);
        this.fileShareARN = builder.fileShareARN;
        this.encryptionType = builder.encryptionType;
        this.kmsEncrypted = builder.kmsEncrypted;
        this.kmsKey = builder.kmsKey;
        this.defaultStorageClass = builder.defaultStorageClass;
        this.objectACL = builder.objectACL;
        this.readOnly = builder.readOnly;
        this.guessMIMETypeEnabled = builder.guessMIMETypeEnabled;
        this.requesterPays = builder.requesterPays;
        this.smbaclEnabled = builder.smbaclEnabled;
        this.accessBasedEnumeration = builder.accessBasedEnumeration;
        this.adminUserList = builder.adminUserList;
        this.validUserList = builder.validUserList;
        this.invalidUserList = builder.invalidUserList;
        this.auditDestinationARN = builder.auditDestinationARN;
        this.caseSensitivity = builder.caseSensitivity;
        this.fileShareName = builder.fileShareName;
        this.cacheAttributes = builder.cacheAttributes;
        this.notificationPolicy = builder.notificationPolicy;
        this.oplocksEnabled = builder.oplocksEnabled;
    }

    public final String fileShareARN() {
        return this.fileShareARN;
    }

    public final EncryptionType encryptionType() {
        return EncryptionType.fromValue(this.encryptionType);
    }

    public final String encryptionTypeAsString() {
        return this.encryptionType;
    }

    @Deprecated
    public final Boolean kmsEncrypted() {
        return this.kmsEncrypted;
    }

    public final String kmsKey() {
        return this.kmsKey;
    }

    public final String defaultStorageClass() {
        return this.defaultStorageClass;
    }

    public final ObjectACL objectACL() {
        return ObjectACL.fromValue(this.objectACL);
    }

    public final String objectACLAsString() {
        return this.objectACL;
    }

    public final Boolean readOnly() {
        return this.readOnly;
    }

    public final Boolean guessMIMETypeEnabled() {
        return this.guessMIMETypeEnabled;
    }

    public final Boolean requesterPays() {
        return this.requesterPays;
    }

    public final Boolean smbaclEnabled() {
        return this.smbaclEnabled;
    }

    public final Boolean accessBasedEnumeration() {
        return this.accessBasedEnumeration;
    }

    public final boolean hasAdminUserList() {
        return this.adminUserList != null && !(this.adminUserList instanceof SdkAutoConstructList);
    }

    public final List<String> adminUserList() {
        return this.adminUserList;
    }

    public final boolean hasValidUserList() {
        return this.validUserList != null && !(this.validUserList instanceof SdkAutoConstructList);
    }

    public final List<String> validUserList() {
        return this.validUserList;
    }

    public final boolean hasInvalidUserList() {
        return this.invalidUserList != null && !(this.invalidUserList instanceof SdkAutoConstructList);
    }

    public final List<String> invalidUserList() {
        return this.invalidUserList;
    }

    public final String auditDestinationARN() {
        return this.auditDestinationARN;
    }

    public final CaseSensitivity caseSensitivity() {
        return CaseSensitivity.fromValue(this.caseSensitivity);
    }

    public final String caseSensitivityAsString() {
        return this.caseSensitivity;
    }

    public final String fileShareName() {
        return this.fileShareName;
    }

    public final CacheAttributes cacheAttributes() {
        return this.cacheAttributes;
    }

    public final String notificationPolicy() {
        return this.notificationPolicy;
    }

    public final Boolean oplocksEnabled() {
        return this.oplocksEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.fileShareARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsEncrypted());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultStorageClass());
        hashCode = 31 * hashCode + Objects.hashCode(this.objectACLAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.readOnly());
        hashCode = 31 * hashCode + Objects.hashCode(this.guessMIMETypeEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.requesterPays());
        hashCode = 31 * hashCode + Objects.hashCode(this.smbaclEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessBasedEnumeration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdminUserList() ? this.adminUserList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasValidUserList() ? this.validUserList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInvalidUserList() ? this.invalidUserList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.auditDestinationARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.caseSensitivityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileShareName());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.notificationPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.oplocksEnabled());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSmbFileShareRequest)) {
            return false;
        }
        UpdateSmbFileShareRequest other = (UpdateSmbFileShareRequest)((Object)obj);
        return Objects.equals(this.fileShareARN(), other.fileShareARN()) && Objects.equals(this.encryptionTypeAsString(), other.encryptionTypeAsString()) && Objects.equals(this.kmsEncrypted(), other.kmsEncrypted()) && Objects.equals(this.kmsKey(), other.kmsKey()) && Objects.equals(this.defaultStorageClass(), other.defaultStorageClass()) && Objects.equals(this.objectACLAsString(), other.objectACLAsString()) && Objects.equals(this.readOnly(), other.readOnly()) && Objects.equals(this.guessMIMETypeEnabled(), other.guessMIMETypeEnabled()) && Objects.equals(this.requesterPays(), other.requesterPays()) && Objects.equals(this.smbaclEnabled(), other.smbaclEnabled()) && Objects.equals(this.accessBasedEnumeration(), other.accessBasedEnumeration()) && this.hasAdminUserList() == other.hasAdminUserList() && Objects.equals(this.adminUserList(), other.adminUserList()) && this.hasValidUserList() == other.hasValidUserList() && Objects.equals(this.validUserList(), other.validUserList()) && this.hasInvalidUserList() == other.hasInvalidUserList() && Objects.equals(this.invalidUserList(), other.invalidUserList()) && Objects.equals(this.auditDestinationARN(), other.auditDestinationARN()) && Objects.equals(this.caseSensitivityAsString(), other.caseSensitivityAsString()) && Objects.equals(this.fileShareName(), other.fileShareName()) && Objects.equals(this.cacheAttributes(), other.cacheAttributes()) && Objects.equals(this.notificationPolicy(), other.notificationPolicy()) && Objects.equals(this.oplocksEnabled(), other.oplocksEnabled());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateSmbFileShareRequest").add("FileShareARN", (Object)this.fileShareARN()).add("EncryptionType", (Object)this.encryptionTypeAsString()).add("KMSEncrypted", (Object)this.kmsEncrypted()).add("KMSKey", (Object)this.kmsKey()).add("DefaultStorageClass", (Object)this.defaultStorageClass()).add("ObjectACL", (Object)this.objectACLAsString()).add("ReadOnly", (Object)this.readOnly()).add("GuessMIMETypeEnabled", (Object)this.guessMIMETypeEnabled()).add("RequesterPays", (Object)this.requesterPays()).add("SMBACLEnabled", (Object)this.smbaclEnabled()).add("AccessBasedEnumeration", (Object)this.accessBasedEnumeration()).add("AdminUserList", this.hasAdminUserList() ? this.adminUserList() : null).add("ValidUserList", this.hasValidUserList() ? this.validUserList() : null).add("InvalidUserList", this.hasInvalidUserList() ? this.invalidUserList() : null).add("AuditDestinationARN", (Object)this.auditDestinationARN()).add("CaseSensitivity", (Object)this.caseSensitivityAsString()).add("FileShareName", (Object)this.fileShareName()).add("CacheAttributes", (Object)this.cacheAttributes()).add("NotificationPolicy", (Object)this.notificationPolicy()).add("OplocksEnabled", (Object)this.oplocksEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FileShareARN": {
                return Optional.ofNullable(clazz.cast(this.fileShareARN()));
            }
            case "EncryptionType": {
                return Optional.ofNullable(clazz.cast(this.encryptionTypeAsString()));
            }
            case "KMSEncrypted": {
                return Optional.ofNullable(clazz.cast(this.kmsEncrypted()));
            }
            case "KMSKey": {
                return Optional.ofNullable(clazz.cast(this.kmsKey()));
            }
            case "DefaultStorageClass": {
                return Optional.ofNullable(clazz.cast(this.defaultStorageClass()));
            }
            case "ObjectACL": {
                return Optional.ofNullable(clazz.cast(this.objectACLAsString()));
            }
            case "ReadOnly": {
                return Optional.ofNullable(clazz.cast(this.readOnly()));
            }
            case "GuessMIMETypeEnabled": {
                return Optional.ofNullable(clazz.cast(this.guessMIMETypeEnabled()));
            }
            case "RequesterPays": {
                return Optional.ofNullable(clazz.cast(this.requesterPays()));
            }
            case "SMBACLEnabled": {
                return Optional.ofNullable(clazz.cast(this.smbaclEnabled()));
            }
            case "AccessBasedEnumeration": {
                return Optional.ofNullable(clazz.cast(this.accessBasedEnumeration()));
            }
            case "AdminUserList": {
                return Optional.ofNullable(clazz.cast(this.adminUserList()));
            }
            case "ValidUserList": {
                return Optional.ofNullable(clazz.cast(this.validUserList()));
            }
            case "InvalidUserList": {
                return Optional.ofNullable(clazz.cast(this.invalidUserList()));
            }
            case "AuditDestinationARN": {
                return Optional.ofNullable(clazz.cast(this.auditDestinationARN()));
            }
            case "CaseSensitivity": {
                return Optional.ofNullable(clazz.cast(this.caseSensitivityAsString()));
            }
            case "FileShareName": {
                return Optional.ofNullable(clazz.cast(this.fileShareName()));
            }
            case "CacheAttributes": {
                return Optional.ofNullable(clazz.cast(this.cacheAttributes()));
            }
            case "NotificationPolicy": {
                return Optional.ofNullable(clazz.cast(this.notificationPolicy()));
            }
            case "OplocksEnabled": {
                return Optional.ofNullable(clazz.cast(this.oplocksEnabled()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateSmbFileShareRequest, T> g) {
        return obj -> g.apply((UpdateSmbFileShareRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends StorageGatewayRequest.BuilderImpl
    implements Builder {
        private String fileShareARN;
        private String encryptionType;
        private Boolean kmsEncrypted;
        private String kmsKey;
        private String defaultStorageClass;
        private String objectACL;
        private Boolean readOnly;
        private Boolean guessMIMETypeEnabled;
        private Boolean requesterPays;
        private Boolean smbaclEnabled;
        private Boolean accessBasedEnumeration;
        private List<String> adminUserList = DefaultSdkAutoConstructList.getInstance();
        private List<String> validUserList = DefaultSdkAutoConstructList.getInstance();
        private List<String> invalidUserList = DefaultSdkAutoConstructList.getInstance();
        private String auditDestinationARN;
        private String caseSensitivity;
        private String fileShareName;
        private CacheAttributes cacheAttributes;
        private String notificationPolicy;
        private Boolean oplocksEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSmbFileShareRequest model) {
            super(model);
            this.fileShareARN(model.fileShareARN);
            this.encryptionType(model.encryptionType);
            this.kmsEncrypted(model.kmsEncrypted);
            this.kmsKey(model.kmsKey);
            this.defaultStorageClass(model.defaultStorageClass);
            this.objectACL(model.objectACL);
            this.readOnly(model.readOnly);
            this.guessMIMETypeEnabled(model.guessMIMETypeEnabled);
            this.requesterPays(model.requesterPays);
            this.smbaclEnabled(model.smbaclEnabled);
            this.accessBasedEnumeration(model.accessBasedEnumeration);
            this.adminUserList(model.adminUserList);
            this.validUserList(model.validUserList);
            this.invalidUserList(model.invalidUserList);
            this.auditDestinationARN(model.auditDestinationARN);
            this.caseSensitivity(model.caseSensitivity);
            this.fileShareName(model.fileShareName);
            this.cacheAttributes(model.cacheAttributes);
            this.notificationPolicy(model.notificationPolicy);
            this.oplocksEnabled(model.oplocksEnabled);
        }

        public final String getFileShareARN() {
            return this.fileShareARN;
        }

        public final void setFileShareARN(String fileShareARN) {
            this.fileShareARN = fileShareARN;
        }

        @Override
        public final Builder fileShareARN(String fileShareARN) {
            this.fileShareARN = fileShareARN;
            return this;
        }

        public final String getEncryptionType() {
            return this.encryptionType;
        }

        public final void setEncryptionType(String encryptionType) {
            this.encryptionType = encryptionType;
        }

        @Override
        public final Builder encryptionType(String encryptionType) {
            this.encryptionType = encryptionType;
            return this;
        }

        @Override
        public final Builder encryptionType(EncryptionType encryptionType) {
            this.encryptionType(encryptionType == null ? null : encryptionType.toString());
            return this;
        }

        @Deprecated
        public final Boolean getKmsEncrypted() {
            return this.kmsEncrypted;
        }

        @Deprecated
        public final void setKmsEncrypted(Boolean kmsEncrypted) {
            this.kmsEncrypted = kmsEncrypted;
        }

        @Override
        @Deprecated
        public final Builder kmsEncrypted(Boolean kmsEncrypted) {
            this.kmsEncrypted = kmsEncrypted;
            return this;
        }

        public final String getKmsKey() {
            return this.kmsKey;
        }

        public final void setKmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
        }

        @Override
        public final Builder kmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
            return this;
        }

        public final String getDefaultStorageClass() {
            return this.defaultStorageClass;
        }

        public final void setDefaultStorageClass(String defaultStorageClass) {
            this.defaultStorageClass = defaultStorageClass;
        }

        @Override
        public final Builder defaultStorageClass(String defaultStorageClass) {
            this.defaultStorageClass = defaultStorageClass;
            return this;
        }

        public final String getObjectACL() {
            return this.objectACL;
        }

        public final void setObjectACL(String objectACL) {
            this.objectACL = objectACL;
        }

        @Override
        public final Builder objectACL(String objectACL) {
            this.objectACL = objectACL;
            return this;
        }

        @Override
        public final Builder objectACL(ObjectACL objectACL) {
            this.objectACL(objectACL == null ? null : objectACL.toString());
            return this;
        }

        public final Boolean getReadOnly() {
            return this.readOnly;
        }

        public final void setReadOnly(Boolean readOnly) {
            this.readOnly = readOnly;
        }

        @Override
        public final Builder readOnly(Boolean readOnly) {
            this.readOnly = readOnly;
            return this;
        }

        public final Boolean getGuessMIMETypeEnabled() {
            return this.guessMIMETypeEnabled;
        }

        public final void setGuessMIMETypeEnabled(Boolean guessMIMETypeEnabled) {
            this.guessMIMETypeEnabled = guessMIMETypeEnabled;
        }

        @Override
        public final Builder guessMIMETypeEnabled(Boolean guessMIMETypeEnabled) {
            this.guessMIMETypeEnabled = guessMIMETypeEnabled;
            return this;
        }

        public final Boolean getRequesterPays() {
            return this.requesterPays;
        }

        public final void setRequesterPays(Boolean requesterPays) {
            this.requesterPays = requesterPays;
        }

        @Override
        public final Builder requesterPays(Boolean requesterPays) {
            this.requesterPays = requesterPays;
            return this;
        }

        public final Boolean getSmbaclEnabled() {
            return this.smbaclEnabled;
        }

        public final void setSmbaclEnabled(Boolean smbaclEnabled) {
            this.smbaclEnabled = smbaclEnabled;
        }

        @Override
        public final Builder smbaclEnabled(Boolean smbaclEnabled) {
            this.smbaclEnabled = smbaclEnabled;
            return this;
        }

        public final Boolean getAccessBasedEnumeration() {
            return this.accessBasedEnumeration;
        }

        public final void setAccessBasedEnumeration(Boolean accessBasedEnumeration) {
            this.accessBasedEnumeration = accessBasedEnumeration;
        }

        @Override
        public final Builder accessBasedEnumeration(Boolean accessBasedEnumeration) {
            this.accessBasedEnumeration = accessBasedEnumeration;
            return this;
        }

        public final Collection<String> getAdminUserList() {
            if (this.adminUserList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.adminUserList;
        }

        public final void setAdminUserList(Collection<String> adminUserList) {
            this.adminUserList = UserListCopier.copy(adminUserList);
        }

        @Override
        public final Builder adminUserList(Collection<String> adminUserList) {
            this.adminUserList = UserListCopier.copy(adminUserList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder adminUserList(String ... adminUserList) {
            this.adminUserList(Arrays.asList(adminUserList));
            return this;
        }

        public final Collection<String> getValidUserList() {
            if (this.validUserList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.validUserList;
        }

        public final void setValidUserList(Collection<String> validUserList) {
            this.validUserList = UserListCopier.copy(validUserList);
        }

        @Override
        public final Builder validUserList(Collection<String> validUserList) {
            this.validUserList = UserListCopier.copy(validUserList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validUserList(String ... validUserList) {
            this.validUserList(Arrays.asList(validUserList));
            return this;
        }

        public final Collection<String> getInvalidUserList() {
            if (this.invalidUserList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.invalidUserList;
        }

        public final void setInvalidUserList(Collection<String> invalidUserList) {
            this.invalidUserList = UserListCopier.copy(invalidUserList);
        }

        @Override
        public final Builder invalidUserList(Collection<String> invalidUserList) {
            this.invalidUserList = UserListCopier.copy(invalidUserList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder invalidUserList(String ... invalidUserList) {
            this.invalidUserList(Arrays.asList(invalidUserList));
            return this;
        }

        public final String getAuditDestinationARN() {
            return this.auditDestinationARN;
        }

        public final void setAuditDestinationARN(String auditDestinationARN) {
            this.auditDestinationARN = auditDestinationARN;
        }

        @Override
        public final Builder auditDestinationARN(String auditDestinationARN) {
            this.auditDestinationARN = auditDestinationARN;
            return this;
        }

        public final String getCaseSensitivity() {
            return this.caseSensitivity;
        }

        public final void setCaseSensitivity(String caseSensitivity) {
            this.caseSensitivity = caseSensitivity;
        }

        @Override
        public final Builder caseSensitivity(String caseSensitivity) {
            this.caseSensitivity = caseSensitivity;
            return this;
        }

        @Override
        public final Builder caseSensitivity(CaseSensitivity caseSensitivity) {
            this.caseSensitivity(caseSensitivity == null ? null : caseSensitivity.toString());
            return this;
        }

        public final String getFileShareName() {
            return this.fileShareName;
        }

        public final void setFileShareName(String fileShareName) {
            this.fileShareName = fileShareName;
        }

        @Override
        public final Builder fileShareName(String fileShareName) {
            this.fileShareName = fileShareName;
            return this;
        }

        public final CacheAttributes.Builder getCacheAttributes() {
            return this.cacheAttributes != null ? this.cacheAttributes.toBuilder() : null;
        }

        public final void setCacheAttributes(CacheAttributes.BuilderImpl cacheAttributes) {
            this.cacheAttributes = cacheAttributes != null ? cacheAttributes.build() : null;
        }

        @Override
        public final Builder cacheAttributes(CacheAttributes cacheAttributes) {
            this.cacheAttributes = cacheAttributes;
            return this;
        }

        public final String getNotificationPolicy() {
            return this.notificationPolicy;
        }

        public final void setNotificationPolicy(String notificationPolicy) {
            this.notificationPolicy = notificationPolicy;
        }

        @Override
        public final Builder notificationPolicy(String notificationPolicy) {
            this.notificationPolicy = notificationPolicy;
            return this;
        }

        public final Boolean getOplocksEnabled() {
            return this.oplocksEnabled;
        }

        public final void setOplocksEnabled(Boolean oplocksEnabled) {
            this.oplocksEnabled = oplocksEnabled;
        }

        @Override
        public final Builder oplocksEnabled(Boolean oplocksEnabled) {
            this.oplocksEnabled = oplocksEnabled;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSmbFileShareRequest build() {
            return new UpdateSmbFileShareRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends StorageGatewayRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateSmbFileShareRequest> {
        public Builder fileShareARN(String var1);

        public Builder encryptionType(String var1);

        public Builder encryptionType(EncryptionType var1);

        @Deprecated
        public Builder kmsEncrypted(Boolean var1);

        public Builder kmsKey(String var1);

        public Builder defaultStorageClass(String var1);

        public Builder objectACL(String var1);

        public Builder objectACL(ObjectACL var1);

        public Builder readOnly(Boolean var1);

        public Builder guessMIMETypeEnabled(Boolean var1);

        public Builder requesterPays(Boolean var1);

        public Builder smbaclEnabled(Boolean var1);

        public Builder accessBasedEnumeration(Boolean var1);

        public Builder adminUserList(Collection<String> var1);

        public Builder adminUserList(String ... var1);

        public Builder validUserList(Collection<String> var1);

        public Builder validUserList(String ... var1);

        public Builder invalidUserList(Collection<String> var1);

        public Builder invalidUserList(String ... var1);

        public Builder auditDestinationARN(String var1);

        public Builder caseSensitivity(String var1);

        public Builder caseSensitivity(CaseSensitivity var1);

        public Builder fileShareName(String var1);

        public Builder cacheAttributes(CacheAttributes var1);

        default public Builder cacheAttributes(Consumer<CacheAttributes.Builder> cacheAttributes) {
            return this.cacheAttributes((CacheAttributes)((CacheAttributes.Builder)CacheAttributes.builder().applyMutation(cacheAttributes)).build());
        }

        public Builder notificationPolicy(String var1);

        public Builder oplocksEnabled(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

