/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.storagegateway.model.StorageGatewayResponse;
import software.amazon.awssdk.services.storagegateway.model.VolumeInfo;
import software.amazon.awssdk.services.storagegateway.model.VolumeInfosCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListVolumesResponse
extends StorageGatewayResponse
implements ToCopyableBuilder<Builder, ListVolumesResponse> {
    private static final SdkField<String> GATEWAY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GatewayARN").getter(ListVolumesResponse.getter(ListVolumesResponse::gatewayARN)).setter(ListVolumesResponse.setter(Builder::gatewayARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayARN").build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(ListVolumesResponse.getter(ListVolumesResponse::marker)).setter(ListVolumesResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final SdkField<List<VolumeInfo>> VOLUME_INFOS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("VolumeInfos").getter(ListVolumesResponse.getter(ListVolumesResponse::volumeInfos)).setter(ListVolumesResponse.setter(Builder::volumeInfos)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeInfos").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VolumeInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_ARN_FIELD, MARKER_FIELD, VOLUME_INFOS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("GatewayARN", GATEWAY_ARN_FIELD);
            this.put("Marker", MARKER_FIELD);
            this.put("VolumeInfos", VOLUME_INFOS_FIELD);
        }
    });
    private final String gatewayARN;
    private final String marker;
    private final List<VolumeInfo> volumeInfos;

    private ListVolumesResponse(BuilderImpl builder) {
        super(builder);
        this.gatewayARN = builder.gatewayARN;
        this.marker = builder.marker;
        this.volumeInfos = builder.volumeInfos;
    }

    public final String gatewayARN() {
        return this.gatewayARN;
    }

    public final String marker() {
        return this.marker;
    }

    public final boolean hasVolumeInfos() {
        return this.volumeInfos != null && !(this.volumeInfos instanceof SdkAutoConstructList);
    }

    public final List<VolumeInfo> volumeInfos() {
        return this.volumeInfos;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVolumeInfos() ? this.volumeInfos() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListVolumesResponse)) {
            return false;
        }
        ListVolumesResponse other = (ListVolumesResponse)((Object)obj);
        return Objects.equals(this.gatewayARN(), other.gatewayARN()) && Objects.equals(this.marker(), other.marker()) && this.hasVolumeInfos() == other.hasVolumeInfos() && Objects.equals(this.volumeInfos(), other.volumeInfos());
    }

    public final String toString() {
        return ToString.builder((String)"ListVolumesResponse").add("GatewayARN", (Object)this.gatewayARN()).add("Marker", (Object)this.marker()).add("VolumeInfos", this.hasVolumeInfos() ? this.volumeInfos() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GatewayARN": {
                return Optional.ofNullable(clazz.cast(this.gatewayARN()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "VolumeInfos": {
                return Optional.ofNullable(clazz.cast(this.volumeInfos()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListVolumesResponse, T> g) {
        return obj -> g.apply((ListVolumesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends StorageGatewayResponse.BuilderImpl
    implements Builder {
        private String gatewayARN;
        private String marker;
        private List<VolumeInfo> volumeInfos = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListVolumesResponse model) {
            super(model);
            this.gatewayARN(model.gatewayARN);
            this.marker(model.marker);
            this.volumeInfos(model.volumeInfos);
        }

        public final String getGatewayARN() {
            return this.gatewayARN;
        }

        public final void setGatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
        }

        @Override
        public final Builder gatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
            return this;
        }

        public final String getMarker() {
            return this.marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final List<VolumeInfo.Builder> getVolumeInfos() {
            List<VolumeInfo.Builder> result = VolumeInfosCopier.copyToBuilder(this.volumeInfos);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVolumeInfos(Collection<VolumeInfo.BuilderImpl> volumeInfos) {
            this.volumeInfos = VolumeInfosCopier.copyFromBuilder(volumeInfos);
        }

        @Override
        public final Builder volumeInfos(Collection<VolumeInfo> volumeInfos) {
            this.volumeInfos = VolumeInfosCopier.copy(volumeInfos);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumeInfos(VolumeInfo ... volumeInfos) {
            this.volumeInfos(Arrays.asList(volumeInfos));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumeInfos(Consumer<VolumeInfo.Builder> ... volumeInfos) {
            this.volumeInfos(Stream.of(volumeInfos).map(c -> (VolumeInfo)((VolumeInfo.Builder)VolumeInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListVolumesResponse build() {
            return new ListVolumesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends StorageGatewayResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListVolumesResponse> {
        public Builder gatewayARN(String var1);

        public Builder marker(String var1);

        public Builder volumeInfos(Collection<VolumeInfo> var1);

        public Builder volumeInfos(VolumeInfo ... var1);

        public Builder volumeInfos(Consumer<VolumeInfo.Builder> ... var1);
    }
}

