/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TapeInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TapeInfo> {
    private static final SdkField<String> TAPE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TapeARN").getter(TapeInfo.getter(TapeInfo::tapeARN)).setter(TapeInfo.setter(Builder::tapeARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TapeARN").build()}).build();
    private static final SdkField<String> TAPE_BARCODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TapeBarcode").getter(TapeInfo.getter(TapeInfo::tapeBarcode)).setter(TapeInfo.setter(Builder::tapeBarcode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TapeBarcode").build()}).build();
    private static final SdkField<Long> TAPE_SIZE_IN_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("TapeSizeInBytes").getter(TapeInfo.getter(TapeInfo::tapeSizeInBytes)).setter(TapeInfo.setter(Builder::tapeSizeInBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TapeSizeInBytes").build()}).build();
    private static final SdkField<String> TAPE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TapeStatus").getter(TapeInfo.getter(TapeInfo::tapeStatus)).setter(TapeInfo.setter(Builder::tapeStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TapeStatus").build()}).build();
    private static final SdkField<String> GATEWAY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GatewayARN").getter(TapeInfo.getter(TapeInfo::gatewayARN)).setter(TapeInfo.setter(Builder::gatewayARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayARN").build()}).build();
    private static final SdkField<String> POOL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PoolId").getter(TapeInfo.getter(TapeInfo::poolId)).setter(TapeInfo.setter(Builder::poolId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoolId").build()}).build();
    private static final SdkField<Instant> RETENTION_START_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("RetentionStartDate").getter(TapeInfo.getter(TapeInfo::retentionStartDate)).setter(TapeInfo.setter(Builder::retentionStartDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetentionStartDate").build()}).build();
    private static final SdkField<Instant> POOL_ENTRY_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("PoolEntryDate").getter(TapeInfo.getter(TapeInfo::poolEntryDate)).setter(TapeInfo.setter(Builder::poolEntryDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoolEntryDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TAPE_ARN_FIELD, TAPE_BARCODE_FIELD, TAPE_SIZE_IN_BYTES_FIELD, TAPE_STATUS_FIELD, GATEWAY_ARN_FIELD, POOL_ID_FIELD, RETENTION_START_DATE_FIELD, POOL_ENTRY_DATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("TapeARN", TAPE_ARN_FIELD);
            this.put("TapeBarcode", TAPE_BARCODE_FIELD);
            this.put("TapeSizeInBytes", TAPE_SIZE_IN_BYTES_FIELD);
            this.put("TapeStatus", TAPE_STATUS_FIELD);
            this.put("GatewayARN", GATEWAY_ARN_FIELD);
            this.put("PoolId", POOL_ID_FIELD);
            this.put("RetentionStartDate", RETENTION_START_DATE_FIELD);
            this.put("PoolEntryDate", POOL_ENTRY_DATE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String tapeARN;
    private final String tapeBarcode;
    private final Long tapeSizeInBytes;
    private final String tapeStatus;
    private final String gatewayARN;
    private final String poolId;
    private final Instant retentionStartDate;
    private final Instant poolEntryDate;

    private TapeInfo(BuilderImpl builder) {
        this.tapeARN = builder.tapeARN;
        this.tapeBarcode = builder.tapeBarcode;
        this.tapeSizeInBytes = builder.tapeSizeInBytes;
        this.tapeStatus = builder.tapeStatus;
        this.gatewayARN = builder.gatewayARN;
        this.poolId = builder.poolId;
        this.retentionStartDate = builder.retentionStartDate;
        this.poolEntryDate = builder.poolEntryDate;
    }

    public final String tapeARN() {
        return this.tapeARN;
    }

    public final String tapeBarcode() {
        return this.tapeBarcode;
    }

    public final Long tapeSizeInBytes() {
        return this.tapeSizeInBytes;
    }

    public final String tapeStatus() {
        return this.tapeStatus;
    }

    public final String gatewayARN() {
        return this.gatewayARN;
    }

    public final String poolId() {
        return this.poolId;
    }

    public final Instant retentionStartDate() {
        return this.retentionStartDate;
    }

    public final Instant poolEntryDate() {
        return this.poolEntryDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.tapeARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.tapeBarcode());
        hashCode = 31 * hashCode + Objects.hashCode(this.tapeSizeInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.tapeStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.poolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.retentionStartDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.poolEntryDate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TapeInfo)) {
            return false;
        }
        TapeInfo other = (TapeInfo)obj;
        return Objects.equals(this.tapeARN(), other.tapeARN()) && Objects.equals(this.tapeBarcode(), other.tapeBarcode()) && Objects.equals(this.tapeSizeInBytes(), other.tapeSizeInBytes()) && Objects.equals(this.tapeStatus(), other.tapeStatus()) && Objects.equals(this.gatewayARN(), other.gatewayARN()) && Objects.equals(this.poolId(), other.poolId()) && Objects.equals(this.retentionStartDate(), other.retentionStartDate()) && Objects.equals(this.poolEntryDate(), other.poolEntryDate());
    }

    public final String toString() {
        return ToString.builder((String)"TapeInfo").add("TapeARN", (Object)this.tapeARN()).add("TapeBarcode", (Object)this.tapeBarcode()).add("TapeSizeInBytes", (Object)this.tapeSizeInBytes()).add("TapeStatus", (Object)this.tapeStatus()).add("GatewayARN", (Object)this.gatewayARN()).add("PoolId", (Object)this.poolId()).add("RetentionStartDate", (Object)this.retentionStartDate()).add("PoolEntryDate", (Object)this.poolEntryDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TapeARN": {
                return Optional.ofNullable(clazz.cast(this.tapeARN()));
            }
            case "TapeBarcode": {
                return Optional.ofNullable(clazz.cast(this.tapeBarcode()));
            }
            case "TapeSizeInBytes": {
                return Optional.ofNullable(clazz.cast(this.tapeSizeInBytes()));
            }
            case "TapeStatus": {
                return Optional.ofNullable(clazz.cast(this.tapeStatus()));
            }
            case "GatewayARN": {
                return Optional.ofNullable(clazz.cast(this.gatewayARN()));
            }
            case "PoolId": {
                return Optional.ofNullable(clazz.cast(this.poolId()));
            }
            case "RetentionStartDate": {
                return Optional.ofNullable(clazz.cast(this.retentionStartDate()));
            }
            case "PoolEntryDate": {
                return Optional.ofNullable(clazz.cast(this.poolEntryDate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<TapeInfo, T> g) {
        return obj -> g.apply((TapeInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String tapeARN;
        private String tapeBarcode;
        private Long tapeSizeInBytes;
        private String tapeStatus;
        private String gatewayARN;
        private String poolId;
        private Instant retentionStartDate;
        private Instant poolEntryDate;

        private BuilderImpl() {
        }

        private BuilderImpl(TapeInfo model) {
            this.tapeARN(model.tapeARN);
            this.tapeBarcode(model.tapeBarcode);
            this.tapeSizeInBytes(model.tapeSizeInBytes);
            this.tapeStatus(model.tapeStatus);
            this.gatewayARN(model.gatewayARN);
            this.poolId(model.poolId);
            this.retentionStartDate(model.retentionStartDate);
            this.poolEntryDate(model.poolEntryDate);
        }

        public final String getTapeARN() {
            return this.tapeARN;
        }

        public final void setTapeARN(String tapeARN) {
            this.tapeARN = tapeARN;
        }

        @Override
        public final Builder tapeARN(String tapeARN) {
            this.tapeARN = tapeARN;
            return this;
        }

        public final String getTapeBarcode() {
            return this.tapeBarcode;
        }

        public final void setTapeBarcode(String tapeBarcode) {
            this.tapeBarcode = tapeBarcode;
        }

        @Override
        public final Builder tapeBarcode(String tapeBarcode) {
            this.tapeBarcode = tapeBarcode;
            return this;
        }

        public final Long getTapeSizeInBytes() {
            return this.tapeSizeInBytes;
        }

        public final void setTapeSizeInBytes(Long tapeSizeInBytes) {
            this.tapeSizeInBytes = tapeSizeInBytes;
        }

        @Override
        public final Builder tapeSizeInBytes(Long tapeSizeInBytes) {
            this.tapeSizeInBytes = tapeSizeInBytes;
            return this;
        }

        public final String getTapeStatus() {
            return this.tapeStatus;
        }

        public final void setTapeStatus(String tapeStatus) {
            this.tapeStatus = tapeStatus;
        }

        @Override
        public final Builder tapeStatus(String tapeStatus) {
            this.tapeStatus = tapeStatus;
            return this;
        }

        public final String getGatewayARN() {
            return this.gatewayARN;
        }

        public final void setGatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
        }

        @Override
        public final Builder gatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
            return this;
        }

        public final String getPoolId() {
            return this.poolId;
        }

        public final void setPoolId(String poolId) {
            this.poolId = poolId;
        }

        @Override
        public final Builder poolId(String poolId) {
            this.poolId = poolId;
            return this;
        }

        public final Instant getRetentionStartDate() {
            return this.retentionStartDate;
        }

        public final void setRetentionStartDate(Instant retentionStartDate) {
            this.retentionStartDate = retentionStartDate;
        }

        @Override
        public final Builder retentionStartDate(Instant retentionStartDate) {
            this.retentionStartDate = retentionStartDate;
            return this;
        }

        public final Instant getPoolEntryDate() {
            return this.poolEntryDate;
        }

        public final void setPoolEntryDate(Instant poolEntryDate) {
            this.poolEntryDate = poolEntryDate;
        }

        @Override
        public final Builder poolEntryDate(Instant poolEntryDate) {
            this.poolEntryDate = poolEntryDate;
            return this;
        }

        public TapeInfo build() {
            return new TapeInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TapeInfo> {
        public Builder tapeARN(String var1);

        public Builder tapeBarcode(String var1);

        public Builder tapeSizeInBytes(Long var1);

        public Builder tapeStatus(String var1);

        public Builder gatewayARN(String var1);

        public Builder poolId(String var1);

        public Builder retentionStartDate(Instant var1);

        public Builder poolEntryDate(Instant var1);
    }
}

