/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.storagegateway.model.FolderListCopier;
import software.amazon.awssdk.services.storagegateway.model.StorageGatewayRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RefreshCacheRequest
extends StorageGatewayRequest
implements ToCopyableBuilder<Builder, RefreshCacheRequest> {
    private static final SdkField<String> FILE_SHARE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FileShareARN").getter(RefreshCacheRequest.getter(RefreshCacheRequest::fileShareARN)).setter(RefreshCacheRequest.setter(Builder::fileShareARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileShareARN").build()}).build();
    private static final SdkField<List<String>> FOLDER_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FolderList").getter(RefreshCacheRequest.getter(RefreshCacheRequest::folderList)).setter(RefreshCacheRequest.setter(Builder::folderList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FolderList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> RECURSIVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Recursive").getter(RefreshCacheRequest.getter(RefreshCacheRequest::recursive)).setter(RefreshCacheRequest.setter(Builder::recursive)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Recursive").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_SHARE_ARN_FIELD, FOLDER_LIST_FIELD, RECURSIVE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("FileShareARN", FILE_SHARE_ARN_FIELD);
            this.put("FolderList", FOLDER_LIST_FIELD);
            this.put("Recursive", RECURSIVE_FIELD);
        }
    });
    private final String fileShareARN;
    private final List<String> folderList;
    private final Boolean recursive;

    private RefreshCacheRequest(BuilderImpl builder) {
        super(builder);
        this.fileShareARN = builder.fileShareARN;
        this.folderList = builder.folderList;
        this.recursive = builder.recursive;
    }

    public final String fileShareARN() {
        return this.fileShareARN;
    }

    public final boolean hasFolderList() {
        return this.folderList != null && !(this.folderList instanceof SdkAutoConstructList);
    }

    public final List<String> folderList() {
        return this.folderList;
    }

    public final Boolean recursive() {
        return this.recursive;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.fileShareARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFolderList() ? this.folderList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.recursive());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RefreshCacheRequest)) {
            return false;
        }
        RefreshCacheRequest other = (RefreshCacheRequest)((Object)obj);
        return Objects.equals(this.fileShareARN(), other.fileShareARN()) && this.hasFolderList() == other.hasFolderList() && Objects.equals(this.folderList(), other.folderList()) && Objects.equals(this.recursive(), other.recursive());
    }

    public final String toString() {
        return ToString.builder((String)"RefreshCacheRequest").add("FileShareARN", (Object)this.fileShareARN()).add("FolderList", this.hasFolderList() ? this.folderList() : null).add("Recursive", (Object)this.recursive()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FileShareARN": {
                return Optional.ofNullable(clazz.cast(this.fileShareARN()));
            }
            case "FolderList": {
                return Optional.ofNullable(clazz.cast(this.folderList()));
            }
            case "Recursive": {
                return Optional.ofNullable(clazz.cast(this.recursive()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<RefreshCacheRequest, T> g) {
        return obj -> g.apply((RefreshCacheRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends StorageGatewayRequest.BuilderImpl
    implements Builder {
        private String fileShareARN;
        private List<String> folderList = DefaultSdkAutoConstructList.getInstance();
        private Boolean recursive;

        private BuilderImpl() {
        }

        private BuilderImpl(RefreshCacheRequest model) {
            super(model);
            this.fileShareARN(model.fileShareARN);
            this.folderList(model.folderList);
            this.recursive(model.recursive);
        }

        public final String getFileShareARN() {
            return this.fileShareARN;
        }

        public final void setFileShareARN(String fileShareARN) {
            this.fileShareARN = fileShareARN;
        }

        @Override
        public final Builder fileShareARN(String fileShareARN) {
            this.fileShareARN = fileShareARN;
            return this;
        }

        public final Collection<String> getFolderList() {
            if (this.folderList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.folderList;
        }

        public final void setFolderList(Collection<String> folderList) {
            this.folderList = FolderListCopier.copy(folderList);
        }

        @Override
        public final Builder folderList(Collection<String> folderList) {
            this.folderList = FolderListCopier.copy(folderList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder folderList(String ... folderList) {
            this.folderList(Arrays.asList(folderList));
            return this;
        }

        public final Boolean getRecursive() {
            return this.recursive;
        }

        public final void setRecursive(Boolean recursive) {
            this.recursive = recursive;
        }

        @Override
        public final Builder recursive(Boolean recursive) {
            this.recursive = recursive;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RefreshCacheRequest build() {
            return new RefreshCacheRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends StorageGatewayRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RefreshCacheRequest> {
        public Builder fileShareARN(String var1);

        public Builder folderList(Collection<String> var1);

        public Builder folderList(String ... var1);

        public Builder recursive(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

