/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.storagegateway.model.DiskIdsCopier;
import software.amazon.awssdk.services.storagegateway.model.StorageGatewayRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AddWorkingStorageRequest
extends StorageGatewayRequest
implements ToCopyableBuilder<Builder, AddWorkingStorageRequest> {
    private static final SdkField<String> GATEWAY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GatewayARN").getter(AddWorkingStorageRequest.getter(AddWorkingStorageRequest::gatewayARN)).setter(AddWorkingStorageRequest.setter(Builder::gatewayARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayARN").build()}).build();
    private static final SdkField<List<String>> DISK_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DiskIds").getter(AddWorkingStorageRequest.getter(AddWorkingStorageRequest::diskIds)).setter(AddWorkingStorageRequest.setter(Builder::diskIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DiskIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_ARN_FIELD, DISK_IDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AddWorkingStorageRequest.memberNameToFieldInitializer();
    private final String gatewayARN;
    private final List<String> diskIds;

    private AddWorkingStorageRequest(BuilderImpl builder) {
        super(builder);
        this.gatewayARN = builder.gatewayARN;
        this.diskIds = builder.diskIds;
    }

    public final String gatewayARN() {
        return this.gatewayARN;
    }

    public final boolean hasDiskIds() {
        return this.diskIds != null && !(this.diskIds instanceof SdkAutoConstructList);
    }

    public final List<String> diskIds() {
        return this.diskIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDiskIds() ? this.diskIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddWorkingStorageRequest)) {
            return false;
        }
        AddWorkingStorageRequest other = (AddWorkingStorageRequest)((Object)obj);
        return Objects.equals(this.gatewayARN(), other.gatewayARN()) && this.hasDiskIds() == other.hasDiskIds() && Objects.equals(this.diskIds(), other.diskIds());
    }

    public final String toString() {
        return ToString.builder((String)"AddWorkingStorageRequest").add("GatewayARN", (Object)this.gatewayARN()).add("DiskIds", this.hasDiskIds() ? this.diskIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GatewayARN": {
                return Optional.ofNullable(clazz.cast(this.gatewayARN()));
            }
            case "DiskIds": {
                return Optional.ofNullable(clazz.cast(this.diskIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("GatewayARN", GATEWAY_ARN_FIELD);
        map.put("DiskIds", DISK_IDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AddWorkingStorageRequest, T> g) {
        return obj -> g.apply((AddWorkingStorageRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends StorageGatewayRequest.BuilderImpl
    implements Builder {
        private String gatewayARN;
        private List<String> diskIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AddWorkingStorageRequest model) {
            super(model);
            this.gatewayARN(model.gatewayARN);
            this.diskIds(model.diskIds);
        }

        public final String getGatewayARN() {
            return this.gatewayARN;
        }

        public final void setGatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
        }

        @Override
        public final Builder gatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
            return this;
        }

        public final Collection<String> getDiskIds() {
            if (this.diskIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.diskIds;
        }

        public final void setDiskIds(Collection<String> diskIds) {
            this.diskIds = DiskIdsCopier.copy(diskIds);
        }

        @Override
        public final Builder diskIds(Collection<String> diskIds) {
            this.diskIds = DiskIdsCopier.copy(diskIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder diskIds(String ... diskIds) {
            this.diskIds(Arrays.asList(diskIds));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AddWorkingStorageRequest build() {
            return new AddWorkingStorageRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends StorageGatewayRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AddWorkingStorageRequest> {
        public Builder gatewayARN(String var1);

        public Builder diskIds(Collection<String> var1);

        public Builder diskIds(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

