/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SMBSecurityStrategy {
    CLIENT_SPECIFIED("ClientSpecified"),
    MANDATORY_SIGNING("MandatorySigning"),
    MANDATORY_ENCRYPTION("MandatoryEncryption"),
    MANDATORY_ENCRYPTION_NO_AES128("MandatoryEncryptionNoAes128"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SMBSecurityStrategy> VALUE_MAP;
    private final String value;

    private SMBSecurityStrategy(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SMBSecurityStrategy fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SMBSecurityStrategy> knownValues() {
        EnumSet<SMBSecurityStrategy> knownValues = EnumSet.allOf(SMBSecurityStrategy.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SMBSecurityStrategy.class, SMBSecurityStrategy::toString);
    }
}

