/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A JSON object containing one or more of the following fields:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a>ActivateGatewayInput$ActivationKey</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>ActivateGatewayInput$GatewayName</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>ActivateGatewayInput$GatewayRegion</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>ActivateGatewayInput$GatewayTimezone</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>ActivateGatewayInput$GatewayType</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>ActivateGatewayInput$TapeDriveType</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>ActivateGatewayInput$MediumChangerType</a>
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ActivateGatewayRequest extends StorageGatewayRequest implements
        ToCopyableBuilder<ActivateGatewayRequest.Builder, ActivateGatewayRequest> {
    private static final SdkField<String> ACTIVATION_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ActivateGatewayRequest::activationKey)).setter(setter(Builder::activationKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActivationKey").build()).build();

    private static final SdkField<String> GATEWAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ActivateGatewayRequest::gatewayName)).setter(setter(Builder::gatewayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayName").build()).build();

    private static final SdkField<String> GATEWAY_TIMEZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ActivateGatewayRequest::gatewayTimezone)).setter(setter(Builder::gatewayTimezone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayTimezone").build()).build();

    private static final SdkField<String> GATEWAY_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ActivateGatewayRequest::gatewayRegion)).setter(setter(Builder::gatewayRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayRegion").build()).build();

    private static final SdkField<String> GATEWAY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ActivateGatewayRequest::gatewayType)).setter(setter(Builder::gatewayType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayType").build()).build();

    private static final SdkField<String> TAPE_DRIVE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ActivateGatewayRequest::tapeDriveType)).setter(setter(Builder::tapeDriveType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TapeDriveType").build()).build();

    private static final SdkField<String> MEDIUM_CHANGER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ActivateGatewayRequest::mediumChangerType)).setter(setter(Builder::mediumChangerType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediumChangerType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIVATION_KEY_FIELD,
            GATEWAY_NAME_FIELD, GATEWAY_TIMEZONE_FIELD, GATEWAY_REGION_FIELD, GATEWAY_TYPE_FIELD, TAPE_DRIVE_TYPE_FIELD,
            MEDIUM_CHANGER_TYPE_FIELD));

    private final String activationKey;

    private final String gatewayName;

    private final String gatewayTimezone;

    private final String gatewayRegion;

    private final String gatewayType;

    private final String tapeDriveType;

    private final String mediumChangerType;

    private ActivateGatewayRequest(BuilderImpl builder) {
        super(builder);
        this.activationKey = builder.activationKey;
        this.gatewayName = builder.gatewayName;
        this.gatewayTimezone = builder.gatewayTimezone;
        this.gatewayRegion = builder.gatewayRegion;
        this.gatewayType = builder.gatewayType;
        this.tapeDriveType = builder.tapeDriveType;
        this.mediumChangerType = builder.mediumChangerType;
    }

    /**
     * <p>
     * Your gateway activation key. You can obtain the activation key by sending an HTTP GET request with redirects
     * enabled to the gateway IP address (port 80). The redirect URL returned in the response provides you the
     * activation key for your gateway in the query string parameter <code>activationKey</code>. It may also include
     * other activation-related parameters, however, these are merely defaults -- the arguments you pass to the
     * <code>ActivateGateway</code> API call determine the actual configuration of your gateway.
     * </p>
     * <p>
     * For more information, see https://docs.aws.amazon.com/storagegateway/latest/userguide/get-activation-key.html in
     * the Storage Gateway User Guide.
     * </p>
     * 
     * @return Your gateway activation key. You can obtain the activation key by sending an HTTP GET request with
     *         redirects enabled to the gateway IP address (port 80). The redirect URL returned in the response provides
     *         you the activation key for your gateway in the query string parameter <code>activationKey</code>. It may
     *         also include other activation-related parameters, however, these are merely defaults -- the arguments you
     *         pass to the <code>ActivateGateway</code> API call determine the actual configuration of your gateway.
     *         </p>
     *         <p>
     *         For more information, see
     *         https://docs.aws.amazon.com/storagegateway/latest/userguide/get-activation-key.html in the Storage
     *         Gateway User Guide.
     */
    public String activationKey() {
        return activationKey;
    }

    /**
     * <p>
     * The name you configured for your gateway.
     * </p>
     * 
     * @return The name you configured for your gateway.
     */
    public String gatewayName() {
        return gatewayName;
    }

    /**
     * <p>
     * A value that indicates the time zone you want to set for the gateway. The time zone is of the format "GMT-hr:mm"
     * or "GMT+hr:mm". For example, GMT-4:00 indicates the time is 4 hours behind GMT. GMT+2:00 indicates the time is 2
     * hours ahead of GMT. The time zone is used, for example, for scheduling snapshots and your gateway's maintenance
     * schedule.
     * </p>
     * 
     * @return A value that indicates the time zone you want to set for the gateway. The time zone is of the format
     *         "GMT-hr:mm" or "GMT+hr:mm". For example, GMT-4:00 indicates the time is 4 hours behind GMT. GMT+2:00
     *         indicates the time is 2 hours ahead of GMT. The time zone is used, for example, for scheduling snapshots
     *         and your gateway's maintenance schedule.
     */
    public String gatewayTimezone() {
        return gatewayTimezone;
    }

    /**
     * <p>
     * A value that indicates the region where you want to store your data. The gateway region specified must be the
     * same region as the region in your <code>Host</code> header in the request. For more information about available
     * regions and endpoints for AWS Storage Gateway, see <a
     * href="http://docs.aws.amazon.com/general/latest/gr/rande.html#sg_region">Regions and Endpoints</a> in the
     * <i>Amazon Web Services Glossary</i>.
     * </p>
     * <p>
     * Valid Values: "us-east-1", "us-east-2", "us-west-1", "us-west-2", "ca-central-1", "eu-west-1", "eu-central-1",
     * "eu-west-2", "eu-west-3", "ap-northeast-1", "ap-northeast-2", "ap-southeast-1", "ap-southeast-2", "ap-south-1",
     * "sa-east-1"
     * </p>
     * 
     * @return A value that indicates the region where you want to store your data. The gateway region specified must be
     *         the same region as the region in your <code>Host</code> header in the request. For more information about
     *         available regions and endpoints for AWS Storage Gateway, see <a
     *         href="http://docs.aws.amazon.com/general/latest/gr/rande.html#sg_region">Regions and Endpoints</a> in the
     *         <i>Amazon Web Services Glossary</i>.</p>
     *         <p>
     *         Valid Values: "us-east-1", "us-east-2", "us-west-1", "us-west-2", "ca-central-1", "eu-west-1",
     *         "eu-central-1", "eu-west-2", "eu-west-3", "ap-northeast-1", "ap-northeast-2", "ap-southeast-1",
     *         "ap-southeast-2", "ap-south-1", "sa-east-1"
     */
    public String gatewayRegion() {
        return gatewayRegion;
    }

    /**
     * <p>
     * A value that defines the type of gateway to activate. The type specified is critical to all later functions of
     * the gateway and cannot be changed after activation. The default value is <code>CACHED</code>.
     * </p>
     * <p>
     * Valid Values: "STORED", "CACHED", "VTL", "FILE_S3"
     * </p>
     * 
     * @return A value that defines the type of gateway to activate. The type specified is critical to all later
     *         functions of the gateway and cannot be changed after activation. The default value is <code>CACHED</code>
     *         . </p>
     *         <p>
     *         Valid Values: "STORED", "CACHED", "VTL", "FILE_S3"
     */
    public String gatewayType() {
        return gatewayType;
    }

    /**
     * <p>
     * The value that indicates the type of tape drive to use for tape gateway. This field is optional.
     * </p>
     * <p>
     * Valid Values: "IBM-ULT3580-TD5"
     * </p>
     * 
     * @return The value that indicates the type of tape drive to use for tape gateway. This field is optional.</p>
     *         <p>
     *         Valid Values: "IBM-ULT3580-TD5"
     */
    public String tapeDriveType() {
        return tapeDriveType;
    }

    /**
     * <p>
     * The value that indicates the type of medium changer to use for tape gateway. This field is optional.
     * </p>
     * <p>
     * Valid Values: "STK-L700", "AWS-Gateway-VTL"
     * </p>
     * 
     * @return The value that indicates the type of medium changer to use for tape gateway. This field is optional.</p>
     *         <p>
     *         Valid Values: "STK-L700", "AWS-Gateway-VTL"
     */
    public String mediumChangerType() {
        return mediumChangerType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(activationKey());
        hashCode = 31 * hashCode + Objects.hashCode(gatewayName());
        hashCode = 31 * hashCode + Objects.hashCode(gatewayTimezone());
        hashCode = 31 * hashCode + Objects.hashCode(gatewayRegion());
        hashCode = 31 * hashCode + Objects.hashCode(gatewayType());
        hashCode = 31 * hashCode + Objects.hashCode(tapeDriveType());
        hashCode = 31 * hashCode + Objects.hashCode(mediumChangerType());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActivateGatewayRequest)) {
            return false;
        }
        ActivateGatewayRequest other = (ActivateGatewayRequest) obj;
        return Objects.equals(activationKey(), other.activationKey()) && Objects.equals(gatewayName(), other.gatewayName())
                && Objects.equals(gatewayTimezone(), other.gatewayTimezone())
                && Objects.equals(gatewayRegion(), other.gatewayRegion()) && Objects.equals(gatewayType(), other.gatewayType())
                && Objects.equals(tapeDriveType(), other.tapeDriveType())
                && Objects.equals(mediumChangerType(), other.mediumChangerType());
    }

    @Override
    public String toString() {
        return ToString.builder("ActivateGatewayRequest").add("ActivationKey", activationKey()).add("GatewayName", gatewayName())
                .add("GatewayTimezone", gatewayTimezone()).add("GatewayRegion", gatewayRegion())
                .add("GatewayType", gatewayType()).add("TapeDriveType", tapeDriveType())
                .add("MediumChangerType", mediumChangerType()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ActivationKey":
            return Optional.ofNullable(clazz.cast(activationKey()));
        case "GatewayName":
            return Optional.ofNullable(clazz.cast(gatewayName()));
        case "GatewayTimezone":
            return Optional.ofNullable(clazz.cast(gatewayTimezone()));
        case "GatewayRegion":
            return Optional.ofNullable(clazz.cast(gatewayRegion()));
        case "GatewayType":
            return Optional.ofNullable(clazz.cast(gatewayType()));
        case "TapeDriveType":
            return Optional.ofNullable(clazz.cast(tapeDriveType()));
        case "MediumChangerType":
            return Optional.ofNullable(clazz.cast(mediumChangerType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ActivateGatewayRequest, T> g) {
        return obj -> g.apply((ActivateGatewayRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends StorageGatewayRequest.Builder, SdkPojo, CopyableBuilder<Builder, ActivateGatewayRequest> {
        /**
         * <p>
         * Your gateway activation key. You can obtain the activation key by sending an HTTP GET request with redirects
         * enabled to the gateway IP address (port 80). The redirect URL returned in the response provides you the
         * activation key for your gateway in the query string parameter <code>activationKey</code>. It may also include
         * other activation-related parameters, however, these are merely defaults -- the arguments you pass to the
         * <code>ActivateGateway</code> API call determine the actual configuration of your gateway.
         * </p>
         * <p>
         * For more information, see https://docs.aws.amazon.com/storagegateway/latest/userguide/get-activation-key.html
         * in the Storage Gateway User Guide.
         * </p>
         * 
         * @param activationKey
         *        Your gateway activation key. You can obtain the activation key by sending an HTTP GET request with
         *        redirects enabled to the gateway IP address (port 80). The redirect URL returned in the response
         *        provides you the activation key for your gateway in the query string parameter
         *        <code>activationKey</code>. It may also include other activation-related parameters, however, these
         *        are merely defaults -- the arguments you pass to the <code>ActivateGateway</code> API call determine
         *        the actual configuration of your gateway. </p>
         *        <p>
         *        For more information, see
         *        https://docs.aws.amazon.com/storagegateway/latest/userguide/get-activation-key.html in the Storage
         *        Gateway User Guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activationKey(String activationKey);

        /**
         * <p>
         * The name you configured for your gateway.
         * </p>
         * 
         * @param gatewayName
         *        The name you configured for your gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayName(String gatewayName);

        /**
         * <p>
         * A value that indicates the time zone you want to set for the gateway. The time zone is of the format
         * "GMT-hr:mm" or "GMT+hr:mm". For example, GMT-4:00 indicates the time is 4 hours behind GMT. GMT+2:00
         * indicates the time is 2 hours ahead of GMT. The time zone is used, for example, for scheduling snapshots and
         * your gateway's maintenance schedule.
         * </p>
         * 
         * @param gatewayTimezone
         *        A value that indicates the time zone you want to set for the gateway. The time zone is of the format
         *        "GMT-hr:mm" or "GMT+hr:mm". For example, GMT-4:00 indicates the time is 4 hours behind GMT. GMT+2:00
         *        indicates the time is 2 hours ahead of GMT. The time zone is used, for example, for scheduling
         *        snapshots and your gateway's maintenance schedule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayTimezone(String gatewayTimezone);

        /**
         * <p>
         * A value that indicates the region where you want to store your data. The gateway region specified must be the
         * same region as the region in your <code>Host</code> header in the request. For more information about
         * available regions and endpoints for AWS Storage Gateway, see <a
         * href="http://docs.aws.amazon.com/general/latest/gr/rande.html#sg_region">Regions and Endpoints</a> in the
         * <i>Amazon Web Services Glossary</i>.
         * </p>
         * <p>
         * Valid Values: "us-east-1", "us-east-2", "us-west-1", "us-west-2", "ca-central-1", "eu-west-1",
         * "eu-central-1", "eu-west-2", "eu-west-3", "ap-northeast-1", "ap-northeast-2", "ap-southeast-1",
         * "ap-southeast-2", "ap-south-1", "sa-east-1"
         * </p>
         * 
         * @param gatewayRegion
         *        A value that indicates the region where you want to store your data. The gateway region specified must
         *        be the same region as the region in your <code>Host</code> header in the request. For more information
         *        about available regions and endpoints for AWS Storage Gateway, see <a
         *        href="http://docs.aws.amazon.com/general/latest/gr/rande.html#sg_region">Regions and Endpoints</a> in
         *        the <i>Amazon Web Services Glossary</i>.</p>
         *        <p>
         *        Valid Values: "us-east-1", "us-east-2", "us-west-1", "us-west-2", "ca-central-1", "eu-west-1",
         *        "eu-central-1", "eu-west-2", "eu-west-3", "ap-northeast-1", "ap-northeast-2", "ap-southeast-1",
         *        "ap-southeast-2", "ap-south-1", "sa-east-1"
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayRegion(String gatewayRegion);

        /**
         * <p>
         * A value that defines the type of gateway to activate. The type specified is critical to all later functions
         * of the gateway and cannot be changed after activation. The default value is <code>CACHED</code>.
         * </p>
         * <p>
         * Valid Values: "STORED", "CACHED", "VTL", "FILE_S3"
         * </p>
         * 
         * @param gatewayType
         *        A value that defines the type of gateway to activate. The type specified is critical to all later
         *        functions of the gateway and cannot be changed after activation. The default value is
         *        <code>CACHED</code>. </p>
         *        <p>
         *        Valid Values: "STORED", "CACHED", "VTL", "FILE_S3"
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayType(String gatewayType);

        /**
         * <p>
         * The value that indicates the type of tape drive to use for tape gateway. This field is optional.
         * </p>
         * <p>
         * Valid Values: "IBM-ULT3580-TD5"
         * </p>
         * 
         * @param tapeDriveType
         *        The value that indicates the type of tape drive to use for tape gateway. This field is optional.</p>
         *        <p>
         *        Valid Values: "IBM-ULT3580-TD5"
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tapeDriveType(String tapeDriveType);

        /**
         * <p>
         * The value that indicates the type of medium changer to use for tape gateway. This field is optional.
         * </p>
         * <p>
         * Valid Values: "STK-L700", "AWS-Gateway-VTL"
         * </p>
         * 
         * @param mediumChangerType
         *        The value that indicates the type of medium changer to use for tape gateway. This field is
         *        optional.</p>
         *        <p>
         *        Valid Values: "STK-L700", "AWS-Gateway-VTL"
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediumChangerType(String mediumChangerType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends StorageGatewayRequest.BuilderImpl implements Builder {
        private String activationKey;

        private String gatewayName;

        private String gatewayTimezone;

        private String gatewayRegion;

        private String gatewayType;

        private String tapeDriveType;

        private String mediumChangerType;

        private BuilderImpl() {
        }

        private BuilderImpl(ActivateGatewayRequest model) {
            super(model);
            activationKey(model.activationKey);
            gatewayName(model.gatewayName);
            gatewayTimezone(model.gatewayTimezone);
            gatewayRegion(model.gatewayRegion);
            gatewayType(model.gatewayType);
            tapeDriveType(model.tapeDriveType);
            mediumChangerType(model.mediumChangerType);
        }

        public final String getActivationKey() {
            return activationKey;
        }

        @Override
        public final Builder activationKey(String activationKey) {
            this.activationKey = activationKey;
            return this;
        }

        public final void setActivationKey(String activationKey) {
            this.activationKey = activationKey;
        }

        public final String getGatewayName() {
            return gatewayName;
        }

        @Override
        public final Builder gatewayName(String gatewayName) {
            this.gatewayName = gatewayName;
            return this;
        }

        public final void setGatewayName(String gatewayName) {
            this.gatewayName = gatewayName;
        }

        public final String getGatewayTimezone() {
            return gatewayTimezone;
        }

        @Override
        public final Builder gatewayTimezone(String gatewayTimezone) {
            this.gatewayTimezone = gatewayTimezone;
            return this;
        }

        public final void setGatewayTimezone(String gatewayTimezone) {
            this.gatewayTimezone = gatewayTimezone;
        }

        public final String getGatewayRegion() {
            return gatewayRegion;
        }

        @Override
        public final Builder gatewayRegion(String gatewayRegion) {
            this.gatewayRegion = gatewayRegion;
            return this;
        }

        public final void setGatewayRegion(String gatewayRegion) {
            this.gatewayRegion = gatewayRegion;
        }

        public final String getGatewayType() {
            return gatewayType;
        }

        @Override
        public final Builder gatewayType(String gatewayType) {
            this.gatewayType = gatewayType;
            return this;
        }

        public final void setGatewayType(String gatewayType) {
            this.gatewayType = gatewayType;
        }

        public final String getTapeDriveType() {
            return tapeDriveType;
        }

        @Override
        public final Builder tapeDriveType(String tapeDriveType) {
            this.tapeDriveType = tapeDriveType;
            return this;
        }

        public final void setTapeDriveType(String tapeDriveType) {
            this.tapeDriveType = tapeDriveType;
        }

        public final String getMediumChangerType() {
            return mediumChangerType;
        }

        @Override
        public final Builder mediumChangerType(String mediumChangerType) {
            this.mediumChangerType = mediumChangerType;
            return this;
        }

        public final void setMediumChangerType(String mediumChangerType) {
            this.mediumChangerType = mediumChangerType;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ActivateGatewayRequest build() {
            return new ActivateGatewayRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
