/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * CreateNFSFileShareInput
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateNfsFileShareRequest extends StorageGatewayRequest implements
        ToCopyableBuilder<CreateNfsFileShareRequest.Builder, CreateNfsFileShareRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateNfsFileShareRequest::clientToken)).setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build()).build();

    private static final SdkField<NFSFileShareDefaults> NFS_FILE_SHARE_DEFAULTS_FIELD = SdkField
            .<NFSFileShareDefaults> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateNfsFileShareRequest::nfsFileShareDefaults)).setter(setter(Builder::nfsFileShareDefaults))
            .constructor(NFSFileShareDefaults::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NFSFileShareDefaults").build())
            .build();

    private static final SdkField<String> GATEWAY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateNfsFileShareRequest::gatewayARN)).setter(setter(Builder::gatewayARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayARN").build()).build();

    private static final SdkField<Boolean> KMS_ENCRYPTED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(CreateNfsFileShareRequest::kmsEncrypted)).setter(setter(Builder::kmsEncrypted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KMSEncrypted").build()).build();

    private static final SdkField<String> KMS_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateNfsFileShareRequest::kmsKey)).setter(setter(Builder::kmsKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KMSKey").build()).build();

    private static final SdkField<String> ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateNfsFileShareRequest::role)).setter(setter(Builder::role))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Role").build()).build();

    private static final SdkField<String> LOCATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateNfsFileShareRequest::locationARN)).setter(setter(Builder::locationARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocationARN").build()).build();

    private static final SdkField<String> DEFAULT_STORAGE_CLASS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateNfsFileShareRequest::defaultStorageClass)).setter(setter(Builder::defaultStorageClass))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultStorageClass").build())
            .build();

    private static final SdkField<String> OBJECT_ACL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateNfsFileShareRequest::objectACLAsString)).setter(setter(Builder::objectACL))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectACL").build()).build();

    private static final SdkField<List<String>> CLIENT_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(CreateNfsFileShareRequest::clientList))
            .setter(setter(Builder::clientList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SQUASH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateNfsFileShareRequest::squash)).setter(setter(Builder::squash))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Squash").build()).build();

    private static final SdkField<Boolean> READ_ONLY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(CreateNfsFileShareRequest::readOnly)).setter(setter(Builder::readOnly))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReadOnly").build()).build();

    private static final SdkField<Boolean> GUESS_MIME_TYPE_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(CreateNfsFileShareRequest::guessMIMETypeEnabled)).setter(setter(Builder::guessMIMETypeEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GuessMIMETypeEnabled").build())
            .build();

    private static final SdkField<Boolean> REQUESTER_PAYS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(CreateNfsFileShareRequest::requesterPays)).setter(setter(Builder::requesterPays))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequesterPays").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            NFS_FILE_SHARE_DEFAULTS_FIELD, GATEWAY_ARN_FIELD, KMS_ENCRYPTED_FIELD, KMS_KEY_FIELD, ROLE_FIELD, LOCATION_ARN_FIELD,
            DEFAULT_STORAGE_CLASS_FIELD, OBJECT_ACL_FIELD, CLIENT_LIST_FIELD, SQUASH_FIELD, READ_ONLY_FIELD,
            GUESS_MIME_TYPE_ENABLED_FIELD, REQUESTER_PAYS_FIELD));

    private final String clientToken;

    private final NFSFileShareDefaults nfsFileShareDefaults;

    private final String gatewayARN;

    private final Boolean kmsEncrypted;

    private final String kmsKey;

    private final String role;

    private final String locationARN;

    private final String defaultStorageClass;

    private final String objectACL;

    private final List<String> clientList;

    private final String squash;

    private final Boolean readOnly;

    private final Boolean guessMIMETypeEnabled;

    private final Boolean requesterPays;

    private CreateNfsFileShareRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.nfsFileShareDefaults = builder.nfsFileShareDefaults;
        this.gatewayARN = builder.gatewayARN;
        this.kmsEncrypted = builder.kmsEncrypted;
        this.kmsKey = builder.kmsKey;
        this.role = builder.role;
        this.locationARN = builder.locationARN;
        this.defaultStorageClass = builder.defaultStorageClass;
        this.objectACL = builder.objectACL;
        this.clientList = builder.clientList;
        this.squash = builder.squash;
        this.readOnly = builder.readOnly;
        this.guessMIMETypeEnabled = builder.guessMIMETypeEnabled;
        this.requesterPays = builder.requesterPays;
    }

    /**
     * <p>
     * A unique string value that you supply that is used by file gateway to ensure idempotent file share creation.
     * </p>
     * 
     * @return A unique string value that you supply that is used by file gateway to ensure idempotent file share
     *         creation.
     */
    public String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * File share default values. Optional.
     * </p>
     * 
     * @return File share default values. Optional.
     */
    public NFSFileShareDefaults nfsFileShareDefaults() {
        return nfsFileShareDefaults;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the file gateway on which you want to create a file share.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the file gateway on which you want to create a file share.
     */
    public String gatewayARN() {
        return gatewayARN;
    }

    /**
     * <p>
     * True to use Amazon S3 server side encryption with your own AWS KMS key, or false to use a key managed by Amazon
     * S3. Optional.
     * </p>
     * 
     * @return True to use Amazon S3 server side encryption with your own AWS KMS key, or false to use a key managed by
     *         Amazon S3. Optional.
     */
    public Boolean kmsEncrypted() {
        return kmsEncrypted;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) AWS KMS key used for Amazon S3 server side encryption. This value can only be set
     * when KMSEncrypted is true. Optional.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) AWS KMS key used for Amazon S3 server side encryption. This value can only
     *         be set when KMSEncrypted is true. Optional.
     */
    public String kmsKey() {
        return kmsKey;
    }

    /**
     * <p>
     * The ARN of the AWS Identity and Access Management (IAM) role that a file gateway assumes when it accesses the
     * underlying storage.
     * </p>
     * 
     * @return The ARN of the AWS Identity and Access Management (IAM) role that a file gateway assumes when it accesses
     *         the underlying storage.
     */
    public String role() {
        return role;
    }

    /**
     * <p>
     * The ARN of the backed storage used for storing file data.
     * </p>
     * 
     * @return The ARN of the backed storage used for storing file data.
     */
    public String locationARN() {
        return locationARN;
    }

    /**
     * <p>
     * The default storage class for objects put into an Amazon S3 bucket by the file gateway. Possible values are
     * <code>S3_STANDARD</code>, <code>S3_STANDARD_IA</code>, or <code>S3_ONEZONE_IA</code>. If this field is not
     * populated, the default value <code>S3_STANDARD</code> is used. Optional.
     * </p>
     * 
     * @return The default storage class for objects put into an Amazon S3 bucket by the file gateway. Possible values
     *         are <code>S3_STANDARD</code>, <code>S3_STANDARD_IA</code>, or <code>S3_ONEZONE_IA</code>. If this field
     *         is not populated, the default value <code>S3_STANDARD</code> is used. Optional.
     */
    public String defaultStorageClass() {
        return defaultStorageClass;
    }

    /**
     * <p>
     * A value that sets the access control list permission for objects in the S3 bucket that a file gateway puts
     * objects into. The default value is "private".
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #objectACL} will
     * return {@link ObjectACL#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #objectACLAsString}.
     * </p>
     * 
     * @return A value that sets the access control list permission for objects in the S3 bucket that a file gateway
     *         puts objects into. The default value is "private".
     * @see ObjectACL
     */
    public ObjectACL objectACL() {
        return ObjectACL.fromValue(objectACL);
    }

    /**
     * <p>
     * A value that sets the access control list permission for objects in the S3 bucket that a file gateway puts
     * objects into. The default value is "private".
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #objectACL} will
     * return {@link ObjectACL#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #objectACLAsString}.
     * </p>
     * 
     * @return A value that sets the access control list permission for objects in the S3 bucket that a file gateway
     *         puts objects into. The default value is "private".
     * @see ObjectACL
     */
    public String objectACLAsString() {
        return objectACL;
    }

    /**
     * <p>
     * The list of clients that are allowed to access the file gateway. The list must contain either valid IP addresses
     * or valid CIDR blocks.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The list of clients that are allowed to access the file gateway. The list must contain either valid IP
     *         addresses or valid CIDR blocks.
     */
    public List<String> clientList() {
        return clientList;
    }

    /**
     * <p>
     * Maps a user to anonymous user. Valid options are the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>RootSquash</code> - Only root is mapped to anonymous user.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NoSquash</code> - No one is mapped to anonymous user
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AllSquash</code> - Everyone is mapped to anonymous user.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Maps a user to anonymous user. Valid options are the following: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>RootSquash</code> - Only root is mapped to anonymous user.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NoSquash</code> - No one is mapped to anonymous user
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AllSquash</code> - Everyone is mapped to anonymous user.
     *         </p>
     *         </li>
     */
    public String squash() {
        return squash;
    }

    /**
     * <p>
     * A value that sets the write status of a file share. This value is true if the write status is read-only, and
     * otherwise false.
     * </p>
     * 
     * @return A value that sets the write status of a file share. This value is true if the write status is read-only,
     *         and otherwise false.
     */
    public Boolean readOnly() {
        return readOnly;
    }

    /**
     * <p>
     * A value that enables guessing of the MIME type for uploaded objects based on file extensions. Set this value to
     * true to enable MIME type guessing, and otherwise to false. The default value is true.
     * </p>
     * 
     * @return A value that enables guessing of the MIME type for uploaded objects based on file extensions. Set this
     *         value to true to enable MIME type guessing, and otherwise to false. The default value is true.
     */
    public Boolean guessMIMETypeEnabled() {
        return guessMIMETypeEnabled;
    }

    /**
     * <p>
     * A value that sets the access control list permission for objects in the Amazon S3 bucket that a file gateway puts
     * objects into. The default value is <code>private</code>.
     * </p>
     * 
     * @return A value that sets the access control list permission for objects in the Amazon S3 bucket that a file
     *         gateway puts objects into. The default value is <code>private</code>.
     */
    public Boolean requesterPays() {
        return requesterPays;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(nfsFileShareDefaults());
        hashCode = 31 * hashCode + Objects.hashCode(gatewayARN());
        hashCode = 31 * hashCode + Objects.hashCode(kmsEncrypted());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKey());
        hashCode = 31 * hashCode + Objects.hashCode(role());
        hashCode = 31 * hashCode + Objects.hashCode(locationARN());
        hashCode = 31 * hashCode + Objects.hashCode(defaultStorageClass());
        hashCode = 31 * hashCode + Objects.hashCode(objectACLAsString());
        hashCode = 31 * hashCode + Objects.hashCode(clientList());
        hashCode = 31 * hashCode + Objects.hashCode(squash());
        hashCode = 31 * hashCode + Objects.hashCode(readOnly());
        hashCode = 31 * hashCode + Objects.hashCode(guessMIMETypeEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(requesterPays());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateNfsFileShareRequest)) {
            return false;
        }
        CreateNfsFileShareRequest other = (CreateNfsFileShareRequest) obj;
        return Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(nfsFileShareDefaults(), other.nfsFileShareDefaults())
                && Objects.equals(gatewayARN(), other.gatewayARN()) && Objects.equals(kmsEncrypted(), other.kmsEncrypted())
                && Objects.equals(kmsKey(), other.kmsKey()) && Objects.equals(role(), other.role())
                && Objects.equals(locationARN(), other.locationARN())
                && Objects.equals(defaultStorageClass(), other.defaultStorageClass())
                && Objects.equals(objectACLAsString(), other.objectACLAsString())
                && Objects.equals(clientList(), other.clientList()) && Objects.equals(squash(), other.squash())
                && Objects.equals(readOnly(), other.readOnly())
                && Objects.equals(guessMIMETypeEnabled(), other.guessMIMETypeEnabled())
                && Objects.equals(requesterPays(), other.requesterPays());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateNfsFileShareRequest").add("ClientToken", clientToken())
                .add("NFSFileShareDefaults", nfsFileShareDefaults()).add("GatewayARN", gatewayARN())
                .add("KMSEncrypted", kmsEncrypted()).add("KMSKey", kmsKey()).add("Role", role())
                .add("LocationARN", locationARN()).add("DefaultStorageClass", defaultStorageClass())
                .add("ObjectACL", objectACLAsString()).add("ClientList", clientList()).add("Squash", squash())
                .add("ReadOnly", readOnly()).add("GuessMIMETypeEnabled", guessMIMETypeEnabled())
                .add("RequesterPays", requesterPays()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "NFSFileShareDefaults":
            return Optional.ofNullable(clazz.cast(nfsFileShareDefaults()));
        case "GatewayARN":
            return Optional.ofNullable(clazz.cast(gatewayARN()));
        case "KMSEncrypted":
            return Optional.ofNullable(clazz.cast(kmsEncrypted()));
        case "KMSKey":
            return Optional.ofNullable(clazz.cast(kmsKey()));
        case "Role":
            return Optional.ofNullable(clazz.cast(role()));
        case "LocationARN":
            return Optional.ofNullable(clazz.cast(locationARN()));
        case "DefaultStorageClass":
            return Optional.ofNullable(clazz.cast(defaultStorageClass()));
        case "ObjectACL":
            return Optional.ofNullable(clazz.cast(objectACLAsString()));
        case "ClientList":
            return Optional.ofNullable(clazz.cast(clientList()));
        case "Squash":
            return Optional.ofNullable(clazz.cast(squash()));
        case "ReadOnly":
            return Optional.ofNullable(clazz.cast(readOnly()));
        case "GuessMIMETypeEnabled":
            return Optional.ofNullable(clazz.cast(guessMIMETypeEnabled()));
        case "RequesterPays":
            return Optional.ofNullable(clazz.cast(requesterPays()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateNfsFileShareRequest, T> g) {
        return obj -> g.apply((CreateNfsFileShareRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends StorageGatewayRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateNfsFileShareRequest> {
        /**
         * <p>
         * A unique string value that you supply that is used by file gateway to ensure idempotent file share creation.
         * </p>
         * 
         * @param clientToken
         *        A unique string value that you supply that is used by file gateway to ensure idempotent file share
         *        creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * File share default values. Optional.
         * </p>
         * 
         * @param nfsFileShareDefaults
         *        File share default values. Optional.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nfsFileShareDefaults(NFSFileShareDefaults nfsFileShareDefaults);

        /**
         * <p>
         * File share default values. Optional.
         * </p>
         * This is a convenience that creates an instance of the {@link NFSFileShareDefaults.Builder} avoiding the need
         * to create one manually via {@link NFSFileShareDefaults#builder()}.
         *
         * When the {@link Consumer} completes, {@link NFSFileShareDefaults.Builder#build()} is called immediately and
         * its result is passed to {@link #nfsFileShareDefaults(NFSFileShareDefaults)}.
         * 
         * @param nfsFileShareDefaults
         *        a consumer that will call methods on {@link NFSFileShareDefaults.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #nfsFileShareDefaults(NFSFileShareDefaults)
         */
        default Builder nfsFileShareDefaults(Consumer<NFSFileShareDefaults.Builder> nfsFileShareDefaults) {
            return nfsFileShareDefaults(NFSFileShareDefaults.builder().applyMutation(nfsFileShareDefaults).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the file gateway on which you want to create a file share.
         * </p>
         * 
         * @param gatewayARN
         *        The Amazon Resource Name (ARN) of the file gateway on which you want to create a file share.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayARN(String gatewayARN);

        /**
         * <p>
         * True to use Amazon S3 server side encryption with your own AWS KMS key, or false to use a key managed by
         * Amazon S3. Optional.
         * </p>
         * 
         * @param kmsEncrypted
         *        True to use Amazon S3 server side encryption with your own AWS KMS key, or false to use a key managed
         *        by Amazon S3. Optional.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsEncrypted(Boolean kmsEncrypted);

        /**
         * <p>
         * The Amazon Resource Name (ARN) AWS KMS key used for Amazon S3 server side encryption. This value can only be
         * set when KMSEncrypted is true. Optional.
         * </p>
         * 
         * @param kmsKey
         *        The Amazon Resource Name (ARN) AWS KMS key used for Amazon S3 server side encryption. This value can
         *        only be set when KMSEncrypted is true. Optional.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKey(String kmsKey);

        /**
         * <p>
         * The ARN of the AWS Identity and Access Management (IAM) role that a file gateway assumes when it accesses the
         * underlying storage.
         * </p>
         * 
         * @param role
         *        The ARN of the AWS Identity and Access Management (IAM) role that a file gateway assumes when it
         *        accesses the underlying storage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder role(String role);

        /**
         * <p>
         * The ARN of the backed storage used for storing file data.
         * </p>
         * 
         * @param locationARN
         *        The ARN of the backed storage used for storing file data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder locationARN(String locationARN);

        /**
         * <p>
         * The default storage class for objects put into an Amazon S3 bucket by the file gateway. Possible values are
         * <code>S3_STANDARD</code>, <code>S3_STANDARD_IA</code>, or <code>S3_ONEZONE_IA</code>. If this field is not
         * populated, the default value <code>S3_STANDARD</code> is used. Optional.
         * </p>
         * 
         * @param defaultStorageClass
         *        The default storage class for objects put into an Amazon S3 bucket by the file gateway. Possible
         *        values are <code>S3_STANDARD</code>, <code>S3_STANDARD_IA</code>, or <code>S3_ONEZONE_IA</code>. If
         *        this field is not populated, the default value <code>S3_STANDARD</code> is used. Optional.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultStorageClass(String defaultStorageClass);

        /**
         * <p>
         * A value that sets the access control list permission for objects in the S3 bucket that a file gateway puts
         * objects into. The default value is "private".
         * </p>
         * 
         * @param objectACL
         *        A value that sets the access control list permission for objects in the S3 bucket that a file gateway
         *        puts objects into. The default value is "private".
         * @see ObjectACL
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ObjectACL
         */
        Builder objectACL(String objectACL);

        /**
         * <p>
         * A value that sets the access control list permission for objects in the S3 bucket that a file gateway puts
         * objects into. The default value is "private".
         * </p>
         * 
         * @param objectACL
         *        A value that sets the access control list permission for objects in the S3 bucket that a file gateway
         *        puts objects into. The default value is "private".
         * @see ObjectACL
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ObjectACL
         */
        Builder objectACL(ObjectACL objectACL);

        /**
         * <p>
         * The list of clients that are allowed to access the file gateway. The list must contain either valid IP
         * addresses or valid CIDR blocks.
         * </p>
         * 
         * @param clientList
         *        The list of clients that are allowed to access the file gateway. The list must contain either valid IP
         *        addresses or valid CIDR blocks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientList(Collection<String> clientList);

        /**
         * <p>
         * The list of clients that are allowed to access the file gateway. The list must contain either valid IP
         * addresses or valid CIDR blocks.
         * </p>
         * 
         * @param clientList
         *        The list of clients that are allowed to access the file gateway. The list must contain either valid IP
         *        addresses or valid CIDR blocks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientList(String... clientList);

        /**
         * <p>
         * Maps a user to anonymous user. Valid options are the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>RootSquash</code> - Only root is mapped to anonymous user.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NoSquash</code> - No one is mapped to anonymous user
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AllSquash</code> - Everyone is mapped to anonymous user.
         * </p>
         * </li>
         * </ul>
         * 
         * @param squash
         *        Maps a user to anonymous user. Valid options are the following: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>RootSquash</code> - Only root is mapped to anonymous user.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NoSquash</code> - No one is mapped to anonymous user
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AllSquash</code> - Everyone is mapped to anonymous user.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder squash(String squash);

        /**
         * <p>
         * A value that sets the write status of a file share. This value is true if the write status is read-only, and
         * otherwise false.
         * </p>
         * 
         * @param readOnly
         *        A value that sets the write status of a file share. This value is true if the write status is
         *        read-only, and otherwise false.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readOnly(Boolean readOnly);

        /**
         * <p>
         * A value that enables guessing of the MIME type for uploaded objects based on file extensions. Set this value
         * to true to enable MIME type guessing, and otherwise to false. The default value is true.
         * </p>
         * 
         * @param guessMIMETypeEnabled
         *        A value that enables guessing of the MIME type for uploaded objects based on file extensions. Set this
         *        value to true to enable MIME type guessing, and otherwise to false. The default value is true.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder guessMIMETypeEnabled(Boolean guessMIMETypeEnabled);

        /**
         * <p>
         * A value that sets the access control list permission for objects in the Amazon S3 bucket that a file gateway
         * puts objects into. The default value is <code>private</code>.
         * </p>
         * 
         * @param requesterPays
         *        A value that sets the access control list permission for objects in the Amazon S3 bucket that a file
         *        gateway puts objects into. The default value is <code>private</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requesterPays(Boolean requesterPays);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends StorageGatewayRequest.BuilderImpl implements Builder {
        private String clientToken;

        private NFSFileShareDefaults nfsFileShareDefaults;

        private String gatewayARN;

        private Boolean kmsEncrypted;

        private String kmsKey;

        private String role;

        private String locationARN;

        private String defaultStorageClass;

        private String objectACL;

        private List<String> clientList = DefaultSdkAutoConstructList.getInstance();

        private String squash;

        private Boolean readOnly;

        private Boolean guessMIMETypeEnabled;

        private Boolean requesterPays;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateNfsFileShareRequest model) {
            super(model);
            clientToken(model.clientToken);
            nfsFileShareDefaults(model.nfsFileShareDefaults);
            gatewayARN(model.gatewayARN);
            kmsEncrypted(model.kmsEncrypted);
            kmsKey(model.kmsKey);
            role(model.role);
            locationARN(model.locationARN);
            defaultStorageClass(model.defaultStorageClass);
            objectACL(model.objectACL);
            clientList(model.clientList);
            squash(model.squash);
            readOnly(model.readOnly);
            guessMIMETypeEnabled(model.guessMIMETypeEnabled);
            requesterPays(model.requesterPays);
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final NFSFileShareDefaults.Builder getNfsFileShareDefaults() {
            return nfsFileShareDefaults != null ? nfsFileShareDefaults.toBuilder() : null;
        }

        @Override
        public final Builder nfsFileShareDefaults(NFSFileShareDefaults nfsFileShareDefaults) {
            this.nfsFileShareDefaults = nfsFileShareDefaults;
            return this;
        }

        public final void setNfsFileShareDefaults(NFSFileShareDefaults.BuilderImpl nfsFileShareDefaults) {
            this.nfsFileShareDefaults = nfsFileShareDefaults != null ? nfsFileShareDefaults.build() : null;
        }

        public final String getGatewayARN() {
            return gatewayARN;
        }

        @Override
        public final Builder gatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
            return this;
        }

        public final void setGatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
        }

        public final Boolean getKmsEncrypted() {
            return kmsEncrypted;
        }

        @Override
        public final Builder kmsEncrypted(Boolean kmsEncrypted) {
            this.kmsEncrypted = kmsEncrypted;
            return this;
        }

        public final void setKmsEncrypted(Boolean kmsEncrypted) {
            this.kmsEncrypted = kmsEncrypted;
        }

        public final String getKmsKey() {
            return kmsKey;
        }

        @Override
        public final Builder kmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
            return this;
        }

        public final void setKmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
        }

        public final String getRole() {
            return role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        public final String getLocationARN() {
            return locationARN;
        }

        @Override
        public final Builder locationARN(String locationARN) {
            this.locationARN = locationARN;
            return this;
        }

        public final void setLocationARN(String locationARN) {
            this.locationARN = locationARN;
        }

        public final String getDefaultStorageClass() {
            return defaultStorageClass;
        }

        @Override
        public final Builder defaultStorageClass(String defaultStorageClass) {
            this.defaultStorageClass = defaultStorageClass;
            return this;
        }

        public final void setDefaultStorageClass(String defaultStorageClass) {
            this.defaultStorageClass = defaultStorageClass;
        }

        public final String getObjectACLAsString() {
            return objectACL;
        }

        @Override
        public final Builder objectACL(String objectACL) {
            this.objectACL = objectACL;
            return this;
        }

        @Override
        public final Builder objectACL(ObjectACL objectACL) {
            this.objectACL(objectACL.toString());
            return this;
        }

        public final void setObjectACL(String objectACL) {
            this.objectACL = objectACL;
        }

        public final Collection<String> getClientList() {
            return clientList;
        }

        @Override
        public final Builder clientList(Collection<String> clientList) {
            this.clientList = FileShareClientListCopier.copy(clientList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clientList(String... clientList) {
            clientList(Arrays.asList(clientList));
            return this;
        }

        public final void setClientList(Collection<String> clientList) {
            this.clientList = FileShareClientListCopier.copy(clientList);
        }

        public final String getSquash() {
            return squash;
        }

        @Override
        public final Builder squash(String squash) {
            this.squash = squash;
            return this;
        }

        public final void setSquash(String squash) {
            this.squash = squash;
        }

        public final Boolean getReadOnly() {
            return readOnly;
        }

        @Override
        public final Builder readOnly(Boolean readOnly) {
            this.readOnly = readOnly;
            return this;
        }

        public final void setReadOnly(Boolean readOnly) {
            this.readOnly = readOnly;
        }

        public final Boolean getGuessMIMETypeEnabled() {
            return guessMIMETypeEnabled;
        }

        @Override
        public final Builder guessMIMETypeEnabled(Boolean guessMIMETypeEnabled) {
            this.guessMIMETypeEnabled = guessMIMETypeEnabled;
            return this;
        }

        public final void setGuessMIMETypeEnabled(Boolean guessMIMETypeEnabled) {
            this.guessMIMETypeEnabled = guessMIMETypeEnabled;
        }

        public final Boolean getRequesterPays() {
            return requesterPays;
        }

        @Override
        public final Builder requesterPays(Boolean requesterPays) {
            this.requesterPays = requesterPays;
            return this;
        }

        public final void setRequesterPays(Boolean requesterPays) {
            this.requesterPays = requesterPays;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateNfsFileShareRequest build() {
            return new CreateNfsFileShareRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
