/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * CreateTapesInput
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateTapesRequest extends StorageGatewayRequest implements
        ToCopyableBuilder<CreateTapesRequest.Builder, CreateTapesRequest> {
    private static final SdkField<String> GATEWAY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateTapesRequest::gatewayARN)).setter(setter(Builder::gatewayARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayARN").build()).build();

    private static final SdkField<Long> TAPE_SIZE_IN_BYTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(CreateTapesRequest::tapeSizeInBytes)).setter(setter(Builder::tapeSizeInBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TapeSizeInBytes").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateTapesRequest::clientToken)).setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build()).build();

    private static final SdkField<Integer> NUM_TAPES_TO_CREATE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(CreateTapesRequest::numTapesToCreate)).setter(setter(Builder::numTapesToCreate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumTapesToCreate").build()).build();

    private static final SdkField<String> TAPE_BARCODE_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateTapesRequest::tapeBarcodePrefix)).setter(setter(Builder::tapeBarcodePrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TapeBarcodePrefix").build()).build();

    private static final SdkField<Boolean> KMS_ENCRYPTED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(CreateTapesRequest::kmsEncrypted)).setter(setter(Builder::kmsEncrypted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KMSEncrypted").build()).build();

    private static final SdkField<String> KMS_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateTapesRequest::kmsKey)).setter(setter(Builder::kmsKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KMSKey").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_ARN_FIELD,
            TAPE_SIZE_IN_BYTES_FIELD, CLIENT_TOKEN_FIELD, NUM_TAPES_TO_CREATE_FIELD, TAPE_BARCODE_PREFIX_FIELD,
            KMS_ENCRYPTED_FIELD, KMS_KEY_FIELD));

    private final String gatewayARN;

    private final Long tapeSizeInBytes;

    private final String clientToken;

    private final Integer numTapesToCreate;

    private final String tapeBarcodePrefix;

    private final Boolean kmsEncrypted;

    private final String kmsKey;

    private CreateTapesRequest(BuilderImpl builder) {
        super(builder);
        this.gatewayARN = builder.gatewayARN;
        this.tapeSizeInBytes = builder.tapeSizeInBytes;
        this.clientToken = builder.clientToken;
        this.numTapesToCreate = builder.numTapesToCreate;
        this.tapeBarcodePrefix = builder.tapeBarcodePrefix;
        this.kmsEncrypted = builder.kmsEncrypted;
        this.kmsKey = builder.kmsKey;
    }

    /**
     * <p>
     * The unique Amazon Resource Name (ARN) that represents the gateway to associate the virtual tapes with. Use the
     * <a>ListGateways</a> operation to return a list of gateways for your account and region.
     * </p>
     * 
     * @return The unique Amazon Resource Name (ARN) that represents the gateway to associate the virtual tapes with.
     *         Use the <a>ListGateways</a> operation to return a list of gateways for your account and region.
     */
    public String gatewayARN() {
        return gatewayARN;
    }

    /**
     * <p>
     * The size, in bytes, of the virtual tapes that you want to create.
     * </p>
     * <note>
     * <p>
     * The size must be aligned by gigabyte (1024*1024*1024 byte).
     * </p>
     * </note>
     * 
     * @return The size, in bytes, of the virtual tapes that you want to create.</p> <note>
     *         <p>
     *         The size must be aligned by gigabyte (1024*1024*1024 byte).
     *         </p>
     */
    public Long tapeSizeInBytes() {
        return tapeSizeInBytes;
    }

    /**
     * <p>
     * A unique identifier that you use to retry a request. If you retry a request, use the same
     * <code>ClientToken</code> you specified in the initial request.
     * </p>
     * <note>
     * <p>
     * Using the same <code>ClientToken</code> prevents creating the tape multiple times.
     * </p>
     * </note>
     * 
     * @return A unique identifier that you use to retry a request. If you retry a request, use the same
     *         <code>ClientToken</code> you specified in the initial request.</p> <note>
     *         <p>
     *         Using the same <code>ClientToken</code> prevents creating the tape multiple times.
     *         </p>
     */
    public String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The number of virtual tapes that you want to create.
     * </p>
     * 
     * @return The number of virtual tapes that you want to create.
     */
    public Integer numTapesToCreate() {
        return numTapesToCreate;
    }

    /**
     * <p>
     * A prefix that you append to the barcode of the virtual tape you are creating. This prefix makes the barcode
     * unique.
     * </p>
     * <note>
     * <p>
     * The prefix must be 1 to 4 characters in length and must be one of the uppercase letters from A to Z.
     * </p>
     * </note>
     * 
     * @return A prefix that you append to the barcode of the virtual tape you are creating. This prefix makes the
     *         barcode unique.</p> <note>
     *         <p>
     *         The prefix must be 1 to 4 characters in length and must be one of the uppercase letters from A to Z.
     *         </p>
     */
    public String tapeBarcodePrefix() {
        return tapeBarcodePrefix;
    }

    /**
     * <p>
     * True to use Amazon S3 server side encryption with your own AWS KMS key, or false to use a key managed by Amazon
     * S3. Optional.
     * </p>
     * 
     * @return True to use Amazon S3 server side encryption with your own AWS KMS key, or false to use a key managed by
     *         Amazon S3. Optional.
     */
    public Boolean kmsEncrypted() {
        return kmsEncrypted;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the AWS KMS key used for Amazon S3 server side encryption. This value can only
     * be set when KMSEncrypted is true. Optional.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the AWS KMS key used for Amazon S3 server side encryption. This value
     *         can only be set when KMSEncrypted is true. Optional.
     */
    public String kmsKey() {
        return kmsKey;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(gatewayARN());
        hashCode = 31 * hashCode + Objects.hashCode(tapeSizeInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(numTapesToCreate());
        hashCode = 31 * hashCode + Objects.hashCode(tapeBarcodePrefix());
        hashCode = 31 * hashCode + Objects.hashCode(kmsEncrypted());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKey());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTapesRequest)) {
            return false;
        }
        CreateTapesRequest other = (CreateTapesRequest) obj;
        return Objects.equals(gatewayARN(), other.gatewayARN()) && Objects.equals(tapeSizeInBytes(), other.tapeSizeInBytes())
                && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(numTapesToCreate(), other.numTapesToCreate())
                && Objects.equals(tapeBarcodePrefix(), other.tapeBarcodePrefix())
                && Objects.equals(kmsEncrypted(), other.kmsEncrypted()) && Objects.equals(kmsKey(), other.kmsKey());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateTapesRequest").add("GatewayARN", gatewayARN()).add("TapeSizeInBytes", tapeSizeInBytes())
                .add("ClientToken", clientToken()).add("NumTapesToCreate", numTapesToCreate())
                .add("TapeBarcodePrefix", tapeBarcodePrefix()).add("KMSEncrypted", kmsEncrypted()).add("KMSKey", kmsKey())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GatewayARN":
            return Optional.ofNullable(clazz.cast(gatewayARN()));
        case "TapeSizeInBytes":
            return Optional.ofNullable(clazz.cast(tapeSizeInBytes()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "NumTapesToCreate":
            return Optional.ofNullable(clazz.cast(numTapesToCreate()));
        case "TapeBarcodePrefix":
            return Optional.ofNullable(clazz.cast(tapeBarcodePrefix()));
        case "KMSEncrypted":
            return Optional.ofNullable(clazz.cast(kmsEncrypted()));
        case "KMSKey":
            return Optional.ofNullable(clazz.cast(kmsKey()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateTapesRequest, T> g) {
        return obj -> g.apply((CreateTapesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends StorageGatewayRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateTapesRequest> {
        /**
         * <p>
         * The unique Amazon Resource Name (ARN) that represents the gateway to associate the virtual tapes with. Use
         * the <a>ListGateways</a> operation to return a list of gateways for your account and region.
         * </p>
         * 
         * @param gatewayARN
         *        The unique Amazon Resource Name (ARN) that represents the gateway to associate the virtual tapes with.
         *        Use the <a>ListGateways</a> operation to return a list of gateways for your account and region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayARN(String gatewayARN);

        /**
         * <p>
         * The size, in bytes, of the virtual tapes that you want to create.
         * </p>
         * <note>
         * <p>
         * The size must be aligned by gigabyte (1024*1024*1024 byte).
         * </p>
         * </note>
         * 
         * @param tapeSizeInBytes
         *        The size, in bytes, of the virtual tapes that you want to create.</p> <note>
         *        <p>
         *        The size must be aligned by gigabyte (1024*1024*1024 byte).
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tapeSizeInBytes(Long tapeSizeInBytes);

        /**
         * <p>
         * A unique identifier that you use to retry a request. If you retry a request, use the same
         * <code>ClientToken</code> you specified in the initial request.
         * </p>
         * <note>
         * <p>
         * Using the same <code>ClientToken</code> prevents creating the tape multiple times.
         * </p>
         * </note>
         * 
         * @param clientToken
         *        A unique identifier that you use to retry a request. If you retry a request, use the same
         *        <code>ClientToken</code> you specified in the initial request.</p> <note>
         *        <p>
         *        Using the same <code>ClientToken</code> prevents creating the tape multiple times.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The number of virtual tapes that you want to create.
         * </p>
         * 
         * @param numTapesToCreate
         *        The number of virtual tapes that you want to create.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numTapesToCreate(Integer numTapesToCreate);

        /**
         * <p>
         * A prefix that you append to the barcode of the virtual tape you are creating. This prefix makes the barcode
         * unique.
         * </p>
         * <note>
         * <p>
         * The prefix must be 1 to 4 characters in length and must be one of the uppercase letters from A to Z.
         * </p>
         * </note>
         * 
         * @param tapeBarcodePrefix
         *        A prefix that you append to the barcode of the virtual tape you are creating. This prefix makes the
         *        barcode unique.</p> <note>
         *        <p>
         *        The prefix must be 1 to 4 characters in length and must be one of the uppercase letters from A to Z.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tapeBarcodePrefix(String tapeBarcodePrefix);

        /**
         * <p>
         * True to use Amazon S3 server side encryption with your own AWS KMS key, or false to use a key managed by
         * Amazon S3. Optional.
         * </p>
         * 
         * @param kmsEncrypted
         *        True to use Amazon S3 server side encryption with your own AWS KMS key, or false to use a key managed
         *        by Amazon S3. Optional.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsEncrypted(Boolean kmsEncrypted);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the AWS KMS key used for Amazon S3 server side encryption. This value can
         * only be set when KMSEncrypted is true. Optional.
         * </p>
         * 
         * @param kmsKey
         *        The Amazon Resource Name (ARN) of the AWS KMS key used for Amazon S3 server side encryption. This
         *        value can only be set when KMSEncrypted is true. Optional.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKey(String kmsKey);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends StorageGatewayRequest.BuilderImpl implements Builder {
        private String gatewayARN;

        private Long tapeSizeInBytes;

        private String clientToken;

        private Integer numTapesToCreate;

        private String tapeBarcodePrefix;

        private Boolean kmsEncrypted;

        private String kmsKey;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTapesRequest model) {
            super(model);
            gatewayARN(model.gatewayARN);
            tapeSizeInBytes(model.tapeSizeInBytes);
            clientToken(model.clientToken);
            numTapesToCreate(model.numTapesToCreate);
            tapeBarcodePrefix(model.tapeBarcodePrefix);
            kmsEncrypted(model.kmsEncrypted);
            kmsKey(model.kmsKey);
        }

        public final String getGatewayARN() {
            return gatewayARN;
        }

        @Override
        public final Builder gatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
            return this;
        }

        public final void setGatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
        }

        public final Long getTapeSizeInBytes() {
            return tapeSizeInBytes;
        }

        @Override
        public final Builder tapeSizeInBytes(Long tapeSizeInBytes) {
            this.tapeSizeInBytes = tapeSizeInBytes;
            return this;
        }

        public final void setTapeSizeInBytes(Long tapeSizeInBytes) {
            this.tapeSizeInBytes = tapeSizeInBytes;
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final Integer getNumTapesToCreate() {
            return numTapesToCreate;
        }

        @Override
        public final Builder numTapesToCreate(Integer numTapesToCreate) {
            this.numTapesToCreate = numTapesToCreate;
            return this;
        }

        public final void setNumTapesToCreate(Integer numTapesToCreate) {
            this.numTapesToCreate = numTapesToCreate;
        }

        public final String getTapeBarcodePrefix() {
            return tapeBarcodePrefix;
        }

        @Override
        public final Builder tapeBarcodePrefix(String tapeBarcodePrefix) {
            this.tapeBarcodePrefix = tapeBarcodePrefix;
            return this;
        }

        public final void setTapeBarcodePrefix(String tapeBarcodePrefix) {
            this.tapeBarcodePrefix = tapeBarcodePrefix;
        }

        public final Boolean getKmsEncrypted() {
            return kmsEncrypted;
        }

        @Override
        public final Builder kmsEncrypted(Boolean kmsEncrypted) {
            this.kmsEncrypted = kmsEncrypted;
            return this;
        }

        public final void setKmsEncrypted(Boolean kmsEncrypted) {
            this.kmsEncrypted = kmsEncrypted;
        }

        public final String getKmsKey() {
            return kmsKey;
        }

        @Override
        public final Builder kmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
            return this;
        }

        public final void setKmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateTapesRequest build() {
            return new CreateTapesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
