/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A JSON object containing the following fields:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a>DeleteBandwidthRateLimitInput$BandwidthType</a>
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteBandwidthRateLimitRequest extends StorageGatewayRequest implements
        ToCopyableBuilder<DeleteBandwidthRateLimitRequest.Builder, DeleteBandwidthRateLimitRequest> {
    private static final SdkField<String> GATEWAY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DeleteBandwidthRateLimitRequest::gatewayARN)).setter(setter(Builder::gatewayARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayARN").build()).build();

    private static final SdkField<String> BANDWIDTH_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DeleteBandwidthRateLimitRequest::bandwidthType)).setter(setter(Builder::bandwidthType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BandwidthType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_ARN_FIELD,
            BANDWIDTH_TYPE_FIELD));

    private final String gatewayARN;

    private final String bandwidthType;

    private DeleteBandwidthRateLimitRequest(BuilderImpl builder) {
        super(builder);
        this.gatewayARN = builder.gatewayARN;
        this.bandwidthType = builder.bandwidthType;
    }

    /**
     * Returns the value of the GatewayARN property for this object.
     * 
     * @return The value of the GatewayARN property for this object.
     */
    public String gatewayARN() {
        return gatewayARN;
    }

    /**
     * <p>
     * One of the BandwidthType values that indicates the gateway bandwidth rate limit to delete.
     * </p>
     * <p>
     * Valid Values: <code>Upload</code>, <code>Download</code>, <code>All</code>.
     * </p>
     * 
     * @return One of the BandwidthType values that indicates the gateway bandwidth rate limit to delete.</p>
     *         <p>
     *         Valid Values: <code>Upload</code>, <code>Download</code>, <code>All</code>.
     */
    public String bandwidthType() {
        return bandwidthType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(gatewayARN());
        hashCode = 31 * hashCode + Objects.hashCode(bandwidthType());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteBandwidthRateLimitRequest)) {
            return false;
        }
        DeleteBandwidthRateLimitRequest other = (DeleteBandwidthRateLimitRequest) obj;
        return Objects.equals(gatewayARN(), other.gatewayARN()) && Objects.equals(bandwidthType(), other.bandwidthType());
    }

    @Override
    public String toString() {
        return ToString.builder("DeleteBandwidthRateLimitRequest").add("GatewayARN", gatewayARN())
                .add("BandwidthType", bandwidthType()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GatewayARN":
            return Optional.ofNullable(clazz.cast(gatewayARN()));
        case "BandwidthType":
            return Optional.ofNullable(clazz.cast(bandwidthType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteBandwidthRateLimitRequest, T> g) {
        return obj -> g.apply((DeleteBandwidthRateLimitRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends StorageGatewayRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteBandwidthRateLimitRequest> {
        /**
         * Sets the value of the GatewayARN property for this object.
         *
         * @param gatewayARN
         *        The new value for the GatewayARN property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayARN(String gatewayARN);

        /**
         * <p>
         * One of the BandwidthType values that indicates the gateway bandwidth rate limit to delete.
         * </p>
         * <p>
         * Valid Values: <code>Upload</code>, <code>Download</code>, <code>All</code>.
         * </p>
         * 
         * @param bandwidthType
         *        One of the BandwidthType values that indicates the gateway bandwidth rate limit to delete.</p>
         *        <p>
         *        Valid Values: <code>Upload</code>, <code>Download</code>, <code>All</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bandwidthType(String bandwidthType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends StorageGatewayRequest.BuilderImpl implements Builder {
        private String gatewayARN;

        private String bandwidthType;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteBandwidthRateLimitRequest model) {
            super(model);
            gatewayARN(model.gatewayARN);
            bandwidthType(model.bandwidthType);
        }

        public final String getGatewayARN() {
            return gatewayARN;
        }

        @Override
        public final Builder gatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
            return this;
        }

        public final void setGatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
        }

        public final String getBandwidthType() {
            return bandwidthType;
        }

        @Override
        public final Builder bandwidthType(String bandwidthType) {
            this.bandwidthType = bandwidthType;
            return this;
        }

        public final void setBandwidthType(String bandwidthType) {
            this.bandwidthType = bandwidthType;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteBandwidthRateLimitRequest build() {
            return new DeleteBandwidthRateLimitRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
