/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeSnapshotScheduleResponse extends StorageGatewayResponse implements
        ToCopyableBuilder<DescribeSnapshotScheduleResponse.Builder, DescribeSnapshotScheduleResponse> {
    private static final SdkField<String> VOLUME_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeSnapshotScheduleResponse::volumeARN)).setter(setter(Builder::volumeARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeARN").build()).build();

    private static final SdkField<Integer> START_AT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(DescribeSnapshotScheduleResponse::startAt)).setter(setter(Builder::startAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartAt").build()).build();

    private static final SdkField<Integer> RECURRENCE_IN_HOURS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(DescribeSnapshotScheduleResponse::recurrenceInHours)).setter(setter(Builder::recurrenceInHours))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecurrenceInHours").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeSnapshotScheduleResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> TIMEZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeSnapshotScheduleResponse::timezone)).setter(setter(Builder::timezone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timezone").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOLUME_ARN_FIELD,
            START_AT_FIELD, RECURRENCE_IN_HOURS_FIELD, DESCRIPTION_FIELD, TIMEZONE_FIELD));

    private final String volumeARN;

    private final Integer startAt;

    private final Integer recurrenceInHours;

    private final String description;

    private final String timezone;

    private DescribeSnapshotScheduleResponse(BuilderImpl builder) {
        super(builder);
        this.volumeARN = builder.volumeARN;
        this.startAt = builder.startAt;
        this.recurrenceInHours = builder.recurrenceInHours;
        this.description = builder.description;
        this.timezone = builder.timezone;
    }

    /**
     * Returns the value of the VolumeARN property for this object.
     * 
     * @return The value of the VolumeARN property for this object.
     */
    public String volumeARN() {
        return volumeARN;
    }

    /**
     * Returns the value of the StartAt property for this object.
     * 
     * @return The value of the StartAt property for this object.
     */
    public Integer startAt() {
        return startAt;
    }

    /**
     * Returns the value of the RecurrenceInHours property for this object.
     * 
     * @return The value of the RecurrenceInHours property for this object.
     */
    public Integer recurrenceInHours() {
        return recurrenceInHours;
    }

    /**
     * Returns the value of the Description property for this object.
     * 
     * @return The value of the Description property for this object.
     */
    public String description() {
        return description;
    }

    /**
     * Returns the value of the Timezone property for this object.
     * 
     * @return The value of the Timezone property for this object.
     */
    public String timezone() {
        return timezone;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(volumeARN());
        hashCode = 31 * hashCode + Objects.hashCode(startAt());
        hashCode = 31 * hashCode + Objects.hashCode(recurrenceInHours());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(timezone());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSnapshotScheduleResponse)) {
            return false;
        }
        DescribeSnapshotScheduleResponse other = (DescribeSnapshotScheduleResponse) obj;
        return Objects.equals(volumeARN(), other.volumeARN()) && Objects.equals(startAt(), other.startAt())
                && Objects.equals(recurrenceInHours(), other.recurrenceInHours())
                && Objects.equals(description(), other.description()) && Objects.equals(timezone(), other.timezone());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeSnapshotScheduleResponse").add("VolumeARN", volumeARN()).add("StartAt", startAt())
                .add("RecurrenceInHours", recurrenceInHours()).add("Description", description()).add("Timezone", timezone())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VolumeARN":
            return Optional.ofNullable(clazz.cast(volumeARN()));
        case "StartAt":
            return Optional.ofNullable(clazz.cast(startAt()));
        case "RecurrenceInHours":
            return Optional.ofNullable(clazz.cast(recurrenceInHours()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Timezone":
            return Optional.ofNullable(clazz.cast(timezone()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeSnapshotScheduleResponse, T> g) {
        return obj -> g.apply((DescribeSnapshotScheduleResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends StorageGatewayResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeSnapshotScheduleResponse> {
        /**
         * Sets the value of the VolumeARN property for this object.
         *
         * @param volumeARN
         *        The new value for the VolumeARN property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeARN(String volumeARN);

        /**
         * Sets the value of the StartAt property for this object.
         *
         * @param startAt
         *        The new value for the StartAt property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startAt(Integer startAt);

        /**
         * Sets the value of the RecurrenceInHours property for this object.
         *
         * @param recurrenceInHours
         *        The new value for the RecurrenceInHours property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recurrenceInHours(Integer recurrenceInHours);

        /**
         * Sets the value of the Description property for this object.
         *
         * @param description
         *        The new value for the Description property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * Sets the value of the Timezone property for this object.
         *
         * @param timezone
         *        The new value for the Timezone property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timezone(String timezone);
    }

    static final class BuilderImpl extends StorageGatewayResponse.BuilderImpl implements Builder {
        private String volumeARN;

        private Integer startAt;

        private Integer recurrenceInHours;

        private String description;

        private String timezone;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSnapshotScheduleResponse model) {
            super(model);
            volumeARN(model.volumeARN);
            startAt(model.startAt);
            recurrenceInHours(model.recurrenceInHours);
            description(model.description);
            timezone(model.timezone);
        }

        public final String getVolumeARN() {
            return volumeARN;
        }

        @Override
        public final Builder volumeARN(String volumeARN) {
            this.volumeARN = volumeARN;
            return this;
        }

        public final void setVolumeARN(String volumeARN) {
            this.volumeARN = volumeARN;
        }

        public final Integer getStartAt() {
            return startAt;
        }

        @Override
        public final Builder startAt(Integer startAt) {
            this.startAt = startAt;
            return this;
        }

        public final void setStartAt(Integer startAt) {
            this.startAt = startAt;
        }

        public final Integer getRecurrenceInHours() {
            return recurrenceInHours;
        }

        @Override
        public final Builder recurrenceInHours(Integer recurrenceInHours) {
            this.recurrenceInHours = recurrenceInHours;
            return this;
        }

        public final void setRecurrenceInHours(Integer recurrenceInHours) {
            this.recurrenceInHours = recurrenceInHours;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getTimezone() {
            return timezone;
        }

        @Override
        public final Builder timezone(String timezone) {
            this.timezone = timezone;
            return this;
        }

        public final void setTimezone(String timezone) {
            this.timezone = timezone;
        }

        @Override
        public DescribeSnapshotScheduleResponse build() {
            return new DescribeSnapshotScheduleResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
