/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeStorediScsiVolumesResponse extends StorageGatewayResponse implements
        ToCopyableBuilder<DescribeStorediScsiVolumesResponse.Builder, DescribeStorediScsiVolumesResponse> {
    private static final SdkField<List<StorediSCSIVolume>> STOREDI_SCSI_VOLUMES_FIELD = SdkField
            .<List<StorediSCSIVolume>> builder(MarshallingType.LIST)
            .getter(getter(DescribeStorediScsiVolumesResponse::storediSCSIVolumes))
            .setter(setter(Builder::storediSCSIVolumes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorediSCSIVolumes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StorediSCSIVolume> builder(MarshallingType.SDK_POJO)
                                            .constructor(StorediSCSIVolume::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STOREDI_SCSI_VOLUMES_FIELD));

    private final List<StorediSCSIVolume> storediSCSIVolumes;

    private DescribeStorediScsiVolumesResponse(BuilderImpl builder) {
        super(builder);
        this.storediSCSIVolumes = builder.storediSCSIVolumes;
    }

    /**
     * Returns the value of the StorediSCSIVolumes property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The value of the StorediSCSIVolumes property for this object.
     */
    public List<StorediSCSIVolume> storediSCSIVolumes() {
        return storediSCSIVolumes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(storediSCSIVolumes());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStorediScsiVolumesResponse)) {
            return false;
        }
        DescribeStorediScsiVolumesResponse other = (DescribeStorediScsiVolumesResponse) obj;
        return Objects.equals(storediSCSIVolumes(), other.storediSCSIVolumes());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeStorediScsiVolumesResponse").add("StorediSCSIVolumes", storediSCSIVolumes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StorediSCSIVolumes":
            return Optional.ofNullable(clazz.cast(storediSCSIVolumes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeStorediScsiVolumesResponse, T> g) {
        return obj -> g.apply((DescribeStorediScsiVolumesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends StorageGatewayResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeStorediScsiVolumesResponse> {
        /**
         * Sets the value of the StorediSCSIVolumes property for this object.
         *
         * @param storediSCSIVolumes
         *        The new value for the StorediSCSIVolumes property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storediSCSIVolumes(Collection<StorediSCSIVolume> storediSCSIVolumes);

        /**
         * Sets the value of the StorediSCSIVolumes property for this object.
         *
         * @param storediSCSIVolumes
         *        The new value for the StorediSCSIVolumes property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storediSCSIVolumes(StorediSCSIVolume... storediSCSIVolumes);

        /**
         * Sets the value of the StorediSCSIVolumes property for this object.
         *
         * This is a convenience that creates an instance of the {@link List<StorediSCSIVolume>.Builder} avoiding the
         * need to create one manually via {@link List<StorediSCSIVolume>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<StorediSCSIVolume>.Builder#build()} is called immediately
         * and its result is passed to {@link #storediSCSIVolumes(List<StorediSCSIVolume>)}.
         * 
         * @param storediSCSIVolumes
         *        a consumer that will call methods on {@link List<StorediSCSIVolume>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #storediSCSIVolumes(List<StorediSCSIVolume>)
         */
        Builder storediSCSIVolumes(Consumer<StorediSCSIVolume.Builder>... storediSCSIVolumes);
    }

    static final class BuilderImpl extends StorageGatewayResponse.BuilderImpl implements Builder {
        private List<StorediSCSIVolume> storediSCSIVolumes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStorediScsiVolumesResponse model) {
            super(model);
            storediSCSIVolumes(model.storediSCSIVolumes);
        }

        public final Collection<StorediSCSIVolume.Builder> getStorediSCSIVolumes() {
            return storediSCSIVolumes != null ? storediSCSIVolumes.stream().map(StorediSCSIVolume::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder storediSCSIVolumes(Collection<StorediSCSIVolume> storediSCSIVolumes) {
            this.storediSCSIVolumes = StorediSCSIVolumesCopier.copy(storediSCSIVolumes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder storediSCSIVolumes(StorediSCSIVolume... storediSCSIVolumes) {
            storediSCSIVolumes(Arrays.asList(storediSCSIVolumes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder storediSCSIVolumes(Consumer<StorediSCSIVolume.Builder>... storediSCSIVolumes) {
            storediSCSIVolumes(Stream.of(storediSCSIVolumes).map(c -> StorediSCSIVolume.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setStorediSCSIVolumes(Collection<StorediSCSIVolume.BuilderImpl> storediSCSIVolumes) {
            this.storediSCSIVolumes = StorediSCSIVolumesCopier.copyFromBuilder(storediSCSIVolumes);
        }

        @Override
        public DescribeStorediScsiVolumesResponse build() {
            return new DescribeStorediScsiVolumesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
