/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * DescribeTapeRecoveryPointsOutput
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeTapeRecoveryPointsResponse extends StorageGatewayResponse implements
        ToCopyableBuilder<DescribeTapeRecoveryPointsResponse.Builder, DescribeTapeRecoveryPointsResponse> {
    private static final SdkField<String> GATEWAY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeTapeRecoveryPointsResponse::gatewayARN)).setter(setter(Builder::gatewayARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayARN").build()).build();

    private static final SdkField<List<TapeRecoveryPointInfo>> TAPE_RECOVERY_POINT_INFOS_FIELD = SdkField
            .<List<TapeRecoveryPointInfo>> builder(MarshallingType.LIST)
            .getter(getter(DescribeTapeRecoveryPointsResponse::tapeRecoveryPointInfos))
            .setter(setter(Builder::tapeRecoveryPointInfos))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TapeRecoveryPointInfos").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TapeRecoveryPointInfo> builder(MarshallingType.SDK_POJO)
                                            .constructor(TapeRecoveryPointInfo::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeTapeRecoveryPointsResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_ARN_FIELD,
            TAPE_RECOVERY_POINT_INFOS_FIELD, MARKER_FIELD));

    private final String gatewayARN;

    private final List<TapeRecoveryPointInfo> tapeRecoveryPointInfos;

    private final String marker;

    private DescribeTapeRecoveryPointsResponse(BuilderImpl builder) {
        super(builder);
        this.gatewayARN = builder.gatewayARN;
        this.tapeRecoveryPointInfos = builder.tapeRecoveryPointInfos;
        this.marker = builder.marker;
    }

    /**
     * Returns the value of the GatewayARN property for this object.
     * 
     * @return The value of the GatewayARN property for this object.
     */
    public String gatewayARN() {
        return gatewayARN;
    }

    /**
     * <p>
     * An array of TapeRecoveryPointInfos that are available for the specified gateway.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of TapeRecoveryPointInfos that are available for the specified gateway.
     */
    public List<TapeRecoveryPointInfo> tapeRecoveryPointInfos() {
        return tapeRecoveryPointInfos;
    }

    /**
     * <p>
     * An opaque string that indicates the position at which the virtual tape recovery points that were listed for
     * description ended.
     * </p>
     * <p>
     * Use this marker in your next request to list the next set of virtual tape recovery points in the list. If there
     * are no more recovery points to describe, this field does not appear in the response.
     * </p>
     * 
     * @return An opaque string that indicates the position at which the virtual tape recovery points that were listed
     *         for description ended.</p>
     *         <p>
     *         Use this marker in your next request to list the next set of virtual tape recovery points in the list. If
     *         there are no more recovery points to describe, this field does not appear in the response.
     */
    public String marker() {
        return marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(gatewayARN());
        hashCode = 31 * hashCode + Objects.hashCode(tapeRecoveryPointInfos());
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTapeRecoveryPointsResponse)) {
            return false;
        }
        DescribeTapeRecoveryPointsResponse other = (DescribeTapeRecoveryPointsResponse) obj;
        return Objects.equals(gatewayARN(), other.gatewayARN())
                && Objects.equals(tapeRecoveryPointInfos(), other.tapeRecoveryPointInfos())
                && Objects.equals(marker(), other.marker());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeTapeRecoveryPointsResponse").add("GatewayARN", gatewayARN())
                .add("TapeRecoveryPointInfos", tapeRecoveryPointInfos()).add("Marker", marker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GatewayARN":
            return Optional.ofNullable(clazz.cast(gatewayARN()));
        case "TapeRecoveryPointInfos":
            return Optional.ofNullable(clazz.cast(tapeRecoveryPointInfos()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeTapeRecoveryPointsResponse, T> g) {
        return obj -> g.apply((DescribeTapeRecoveryPointsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends StorageGatewayResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeTapeRecoveryPointsResponse> {
        /**
         * Sets the value of the GatewayARN property for this object.
         *
         * @param gatewayARN
         *        The new value for the GatewayARN property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayARN(String gatewayARN);

        /**
         * <p>
         * An array of TapeRecoveryPointInfos that are available for the specified gateway.
         * </p>
         * 
         * @param tapeRecoveryPointInfos
         *        An array of TapeRecoveryPointInfos that are available for the specified gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tapeRecoveryPointInfos(Collection<TapeRecoveryPointInfo> tapeRecoveryPointInfos);

        /**
         * <p>
         * An array of TapeRecoveryPointInfos that are available for the specified gateway.
         * </p>
         * 
         * @param tapeRecoveryPointInfos
         *        An array of TapeRecoveryPointInfos that are available for the specified gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tapeRecoveryPointInfos(TapeRecoveryPointInfo... tapeRecoveryPointInfos);

        /**
         * <p>
         * An array of TapeRecoveryPointInfos that are available for the specified gateway.
         * </p>
         * This is a convenience that creates an instance of the {@link List<TapeRecoveryPointInfo>.Builder} avoiding
         * the need to create one manually via {@link List<TapeRecoveryPointInfo>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TapeRecoveryPointInfo>.Builder#build()} is called
         * immediately and its result is passed to {@link #tapeRecoveryPointInfos(List<TapeRecoveryPointInfo>)}.
         * 
         * @param tapeRecoveryPointInfos
         *        a consumer that will call methods on {@link List<TapeRecoveryPointInfo>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tapeRecoveryPointInfos(List<TapeRecoveryPointInfo>)
         */
        Builder tapeRecoveryPointInfos(Consumer<TapeRecoveryPointInfo.Builder>... tapeRecoveryPointInfos);

        /**
         * <p>
         * An opaque string that indicates the position at which the virtual tape recovery points that were listed for
         * description ended.
         * </p>
         * <p>
         * Use this marker in your next request to list the next set of virtual tape recovery points in the list. If
         * there are no more recovery points to describe, this field does not appear in the response.
         * </p>
         * 
         * @param marker
         *        An opaque string that indicates the position at which the virtual tape recovery points that were
         *        listed for description ended.</p>
         *        <p>
         *        Use this marker in your next request to list the next set of virtual tape recovery points in the list.
         *        If there are no more recovery points to describe, this field does not appear in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);
    }

    static final class BuilderImpl extends StorageGatewayResponse.BuilderImpl implements Builder {
        private String gatewayARN;

        private List<TapeRecoveryPointInfo> tapeRecoveryPointInfos = DefaultSdkAutoConstructList.getInstance();

        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTapeRecoveryPointsResponse model) {
            super(model);
            gatewayARN(model.gatewayARN);
            tapeRecoveryPointInfos(model.tapeRecoveryPointInfos);
            marker(model.marker);
        }

        public final String getGatewayARN() {
            return gatewayARN;
        }

        @Override
        public final Builder gatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
            return this;
        }

        public final void setGatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
        }

        public final Collection<TapeRecoveryPointInfo.Builder> getTapeRecoveryPointInfos() {
            return tapeRecoveryPointInfos != null ? tapeRecoveryPointInfos.stream().map(TapeRecoveryPointInfo::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tapeRecoveryPointInfos(Collection<TapeRecoveryPointInfo> tapeRecoveryPointInfos) {
            this.tapeRecoveryPointInfos = TapeRecoveryPointInfosCopier.copy(tapeRecoveryPointInfos);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tapeRecoveryPointInfos(TapeRecoveryPointInfo... tapeRecoveryPointInfos) {
            tapeRecoveryPointInfos(Arrays.asList(tapeRecoveryPointInfos));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tapeRecoveryPointInfos(Consumer<TapeRecoveryPointInfo.Builder>... tapeRecoveryPointInfos) {
            tapeRecoveryPointInfos(Stream.of(tapeRecoveryPointInfos)
                    .map(c -> TapeRecoveryPointInfo.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTapeRecoveryPointInfos(Collection<TapeRecoveryPointInfo.BuilderImpl> tapeRecoveryPointInfos) {
            this.tapeRecoveryPointInfos = TapeRecoveryPointInfosCopier.copyFromBuilder(tapeRecoveryPointInfos);
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public DescribeTapeRecoveryPointsResponse build() {
            return new DescribeTapeRecoveryPointsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
