/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a recovery point.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TapeRecoveryPointInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<TapeRecoveryPointInfo.Builder, TapeRecoveryPointInfo> {
    private static final SdkField<String> TAPE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TapeRecoveryPointInfo::tapeARN)).setter(setter(Builder::tapeARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TapeARN").build()).build();

    private static final SdkField<Instant> TAPE_RECOVERY_POINT_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(TapeRecoveryPointInfo::tapeRecoveryPointTime)).setter(setter(Builder::tapeRecoveryPointTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TapeRecoveryPointTime").build())
            .build();

    private static final SdkField<Long> TAPE_SIZE_IN_BYTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(TapeRecoveryPointInfo::tapeSizeInBytes)).setter(setter(Builder::tapeSizeInBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TapeSizeInBytes").build()).build();

    private static final SdkField<String> TAPE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TapeRecoveryPointInfo::tapeStatus)).setter(setter(Builder::tapeStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TapeStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TAPE_ARN_FIELD,
            TAPE_RECOVERY_POINT_TIME_FIELD, TAPE_SIZE_IN_BYTES_FIELD, TAPE_STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String tapeARN;

    private final Instant tapeRecoveryPointTime;

    private final Long tapeSizeInBytes;

    private final String tapeStatus;

    private TapeRecoveryPointInfo(BuilderImpl builder) {
        this.tapeARN = builder.tapeARN;
        this.tapeRecoveryPointTime = builder.tapeRecoveryPointTime;
        this.tapeSizeInBytes = builder.tapeSizeInBytes;
        this.tapeStatus = builder.tapeStatus;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the virtual tape.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the virtual tape.
     */
    public String tapeARN() {
        return tapeARN;
    }

    /**
     * <p>
     * The time when the point-in-time view of the virtual tape was replicated for later recovery.
     * </p>
     * <p>
     * The default time stamp format of the tape recovery point time is in the ISO8601 extended YYYY-MM-DD'T'HH:MM:SS'Z'
     * format.
     * </p>
     * 
     * @return The time when the point-in-time view of the virtual tape was replicated for later recovery.</p>
     *         <p>
     *         The default time stamp format of the tape recovery point time is in the ISO8601 extended
     *         YYYY-MM-DD'T'HH:MM:SS'Z' format.
     */
    public Instant tapeRecoveryPointTime() {
        return tapeRecoveryPointTime;
    }

    /**
     * <p>
     * The size, in bytes, of the virtual tapes to recover.
     * </p>
     * 
     * @return The size, in bytes, of the virtual tapes to recover.
     */
    public Long tapeSizeInBytes() {
        return tapeSizeInBytes;
    }

    /**
     * Returns the value of the TapeStatus property for this object.
     * 
     * @return The value of the TapeStatus property for this object.
     */
    public String tapeStatus() {
        return tapeStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(tapeARN());
        hashCode = 31 * hashCode + Objects.hashCode(tapeRecoveryPointTime());
        hashCode = 31 * hashCode + Objects.hashCode(tapeSizeInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(tapeStatus());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TapeRecoveryPointInfo)) {
            return false;
        }
        TapeRecoveryPointInfo other = (TapeRecoveryPointInfo) obj;
        return Objects.equals(tapeARN(), other.tapeARN())
                && Objects.equals(tapeRecoveryPointTime(), other.tapeRecoveryPointTime())
                && Objects.equals(tapeSizeInBytes(), other.tapeSizeInBytes()) && Objects.equals(tapeStatus(), other.tapeStatus());
    }

    @Override
    public String toString() {
        return ToString.builder("TapeRecoveryPointInfo").add("TapeARN", tapeARN())
                .add("TapeRecoveryPointTime", tapeRecoveryPointTime()).add("TapeSizeInBytes", tapeSizeInBytes())
                .add("TapeStatus", tapeStatus()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TapeARN":
            return Optional.ofNullable(clazz.cast(tapeARN()));
        case "TapeRecoveryPointTime":
            return Optional.ofNullable(clazz.cast(tapeRecoveryPointTime()));
        case "TapeSizeInBytes":
            return Optional.ofNullable(clazz.cast(tapeSizeInBytes()));
        case "TapeStatus":
            return Optional.ofNullable(clazz.cast(tapeStatus()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TapeRecoveryPointInfo, T> g) {
        return obj -> g.apply((TapeRecoveryPointInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TapeRecoveryPointInfo> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the virtual tape.
         * </p>
         * 
         * @param tapeARN
         *        The Amazon Resource Name (ARN) of the virtual tape.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tapeARN(String tapeARN);

        /**
         * <p>
         * The time when the point-in-time view of the virtual tape was replicated for later recovery.
         * </p>
         * <p>
         * The default time stamp format of the tape recovery point time is in the ISO8601 extended
         * YYYY-MM-DD'T'HH:MM:SS'Z' format.
         * </p>
         * 
         * @param tapeRecoveryPointTime
         *        The time when the point-in-time view of the virtual tape was replicated for later recovery.</p>
         *        <p>
         *        The default time stamp format of the tape recovery point time is in the ISO8601 extended
         *        YYYY-MM-DD'T'HH:MM:SS'Z' format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tapeRecoveryPointTime(Instant tapeRecoveryPointTime);

        /**
         * <p>
         * The size, in bytes, of the virtual tapes to recover.
         * </p>
         * 
         * @param tapeSizeInBytes
         *        The size, in bytes, of the virtual tapes to recover.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tapeSizeInBytes(Long tapeSizeInBytes);

        /**
         * Sets the value of the TapeStatus property for this object.
         *
         * @param tapeStatus
         *        The new value for the TapeStatus property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tapeStatus(String tapeStatus);
    }

    static final class BuilderImpl implements Builder {
        private String tapeARN;

        private Instant tapeRecoveryPointTime;

        private Long tapeSizeInBytes;

        private String tapeStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(TapeRecoveryPointInfo model) {
            tapeARN(model.tapeARN);
            tapeRecoveryPointTime(model.tapeRecoveryPointTime);
            tapeSizeInBytes(model.tapeSizeInBytes);
            tapeStatus(model.tapeStatus);
        }

        public final String getTapeARN() {
            return tapeARN;
        }

        @Override
        public final Builder tapeARN(String tapeARN) {
            this.tapeARN = tapeARN;
            return this;
        }

        public final void setTapeARN(String tapeARN) {
            this.tapeARN = tapeARN;
        }

        public final Instant getTapeRecoveryPointTime() {
            return tapeRecoveryPointTime;
        }

        @Override
        public final Builder tapeRecoveryPointTime(Instant tapeRecoveryPointTime) {
            this.tapeRecoveryPointTime = tapeRecoveryPointTime;
            return this;
        }

        public final void setTapeRecoveryPointTime(Instant tapeRecoveryPointTime) {
            this.tapeRecoveryPointTime = tapeRecoveryPointTime;
        }

        public final Long getTapeSizeInBytes() {
            return tapeSizeInBytes;
        }

        @Override
        public final Builder tapeSizeInBytes(Long tapeSizeInBytes) {
            this.tapeSizeInBytes = tapeSizeInBytes;
            return this;
        }

        public final void setTapeSizeInBytes(Long tapeSizeInBytes) {
            this.tapeSizeInBytes = tapeSizeInBytes;
        }

        public final String getTapeStatus() {
            return tapeStatus;
        }

        @Override
        public final Builder tapeStatus(String tapeStatus) {
            this.tapeStatus = tapeStatus;
            return this;
        }

        public final void setTapeStatus(String tapeStatus) {
            this.tapeStatus = tapeStatus;
        }

        @Override
        public TapeRecoveryPointInfo build() {
            return new TapeRecoveryPointInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
