/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * UpdateSMBFileShareInput
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateSmbFileShareRequest extends StorageGatewayRequest implements
        ToCopyableBuilder<UpdateSmbFileShareRequest.Builder, UpdateSmbFileShareRequest> {
    private static final SdkField<String> FILE_SHARE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateSmbFileShareRequest::fileShareARN)).setter(setter(Builder::fileShareARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileShareARN").build()).build();

    private static final SdkField<Boolean> KMS_ENCRYPTED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(UpdateSmbFileShareRequest::kmsEncrypted)).setter(setter(Builder::kmsEncrypted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KMSEncrypted").build()).build();

    private static final SdkField<String> KMS_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateSmbFileShareRequest::kmsKey)).setter(setter(Builder::kmsKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KMSKey").build()).build();

    private static final SdkField<String> DEFAULT_STORAGE_CLASS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateSmbFileShareRequest::defaultStorageClass)).setter(setter(Builder::defaultStorageClass))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultStorageClass").build())
            .build();

    private static final SdkField<String> OBJECT_ACL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateSmbFileShareRequest::objectACLAsString)).setter(setter(Builder::objectACL))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectACL").build()).build();

    private static final SdkField<Boolean> READ_ONLY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(UpdateSmbFileShareRequest::readOnly)).setter(setter(Builder::readOnly))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReadOnly").build()).build();

    private static final SdkField<Boolean> GUESS_MIME_TYPE_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(UpdateSmbFileShareRequest::guessMIMETypeEnabled)).setter(setter(Builder::guessMIMETypeEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GuessMIMETypeEnabled").build())
            .build();

    private static final SdkField<Boolean> REQUESTER_PAYS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(UpdateSmbFileShareRequest::requesterPays)).setter(setter(Builder::requesterPays))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequesterPays").build()).build();

    private static final SdkField<List<String>> VALID_USER_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(UpdateSmbFileShareRequest::validUserList))
            .setter(setter(Builder::validUserList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidUserList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> INVALID_USER_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(UpdateSmbFileShareRequest::invalidUserList))
            .setter(setter(Builder::invalidUserList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvalidUserList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_SHARE_ARN_FIELD,
            KMS_ENCRYPTED_FIELD, KMS_KEY_FIELD, DEFAULT_STORAGE_CLASS_FIELD, OBJECT_ACL_FIELD, READ_ONLY_FIELD,
            GUESS_MIME_TYPE_ENABLED_FIELD, REQUESTER_PAYS_FIELD, VALID_USER_LIST_FIELD, INVALID_USER_LIST_FIELD));

    private final String fileShareARN;

    private final Boolean kmsEncrypted;

    private final String kmsKey;

    private final String defaultStorageClass;

    private final String objectACL;

    private final Boolean readOnly;

    private final Boolean guessMIMETypeEnabled;

    private final Boolean requesterPays;

    private final List<String> validUserList;

    private final List<String> invalidUserList;

    private UpdateSmbFileShareRequest(BuilderImpl builder) {
        super(builder);
        this.fileShareARN = builder.fileShareARN;
        this.kmsEncrypted = builder.kmsEncrypted;
        this.kmsKey = builder.kmsKey;
        this.defaultStorageClass = builder.defaultStorageClass;
        this.objectACL = builder.objectACL;
        this.readOnly = builder.readOnly;
        this.guessMIMETypeEnabled = builder.guessMIMETypeEnabled;
        this.requesterPays = builder.requesterPays;
        this.validUserList = builder.validUserList;
        this.invalidUserList = builder.invalidUserList;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the SMB file share that you want to update.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the SMB file share that you want to update.
     */
    public String fileShareARN() {
        return fileShareARN;
    }

    /**
     * <p>
     * True to use Amazon S3 server side encryption with your own AWS KMS key, or false to use a key managed by Amazon
     * S3. Optional.
     * </p>
     * 
     * @return True to use Amazon S3 server side encryption with your own AWS KMS key, or false to use a key managed by
     *         Amazon S3. Optional.
     */
    public Boolean kmsEncrypted() {
        return kmsEncrypted;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the AWS KMS key used for Amazon S3 server side encryption. This value can only
     * be set when KMSEncrypted is true. Optional.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the AWS KMS key used for Amazon S3 server side encryption. This value
     *         can only be set when KMSEncrypted is true. Optional.
     */
    public String kmsKey() {
        return kmsKey;
    }

    /**
     * <p>
     * The default storage class for objects put into an Amazon S3 bucket by the file gateway. Possible values are
     * <code>S3_STANDARD</code>, <code>S3_STANDARD_IA</code>, or <code>S3_ONEZONE_IA</code>. If this field is not
     * populated, the default value <code>S3_STANDARD</code> is used. Optional.
     * </p>
     * 
     * @return The default storage class for objects put into an Amazon S3 bucket by the file gateway. Possible values
     *         are <code>S3_STANDARD</code>, <code>S3_STANDARD_IA</code>, or <code>S3_ONEZONE_IA</code>. If this field
     *         is not populated, the default value <code>S3_STANDARD</code> is used. Optional.
     */
    public String defaultStorageClass() {
        return defaultStorageClass;
    }

    /**
     * <p>
     * A value that sets the access control list permission for objects in the S3 bucket that a file gateway puts
     * objects into. The default value is "private".
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #objectACL} will
     * return {@link ObjectACL#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #objectACLAsString}.
     * </p>
     * 
     * @return A value that sets the access control list permission for objects in the S3 bucket that a file gateway
     *         puts objects into. The default value is "private".
     * @see ObjectACL
     */
    public ObjectACL objectACL() {
        return ObjectACL.fromValue(objectACL);
    }

    /**
     * <p>
     * A value that sets the access control list permission for objects in the S3 bucket that a file gateway puts
     * objects into. The default value is "private".
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #objectACL} will
     * return {@link ObjectACL#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #objectACLAsString}.
     * </p>
     * 
     * @return A value that sets the access control list permission for objects in the S3 bucket that a file gateway
     *         puts objects into. The default value is "private".
     * @see ObjectACL
     */
    public String objectACLAsString() {
        return objectACL;
    }

    /**
     * <p>
     * A value that sets the write status of a file share. This value is true if the write status is read-only, and
     * otherwise false.
     * </p>
     * 
     * @return A value that sets the write status of a file share. This value is true if the write status is read-only,
     *         and otherwise false.
     */
    public Boolean readOnly() {
        return readOnly;
    }

    /**
     * <p>
     * A value that enables guessing of the MIME type for uploaded objects based on file extensions. Set this value to
     * true to enable MIME type guessing, and otherwise to false. The default value is true.
     * </p>
     * 
     * @return A value that enables guessing of the MIME type for uploaded objects based on file extensions. Set this
     *         value to true to enable MIME type guessing, and otherwise to false. The default value is true.
     */
    public Boolean guessMIMETypeEnabled() {
        return guessMIMETypeEnabled;
    }

    /**
     * <p>
     * A value that sets the access control list permission for objects in the Amazon S3 bucket that a file gateway puts
     * objects into. The default value is <code>private</code>.
     * </p>
     * 
     * @return A value that sets the access control list permission for objects in the Amazon S3 bucket that a file
     *         gateway puts objects into. The default value is <code>private</code>.
     */
    public Boolean requesterPays() {
        return requesterPays;
    }

    /**
     * <p>
     * A list of users or groups in the Active Directory that are allowed to access the file share. A group must be
     * prefixed with the @ character. For example <code>@group1</code>. Can only be set if Authentication is set to
     * <code>ActiveDirectory</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of users or groups in the Active Directory that are allowed to access the file share. A group must
     *         be prefixed with the @ character. For example <code>@group1</code>. Can only be set if Authentication is
     *         set to <code>ActiveDirectory</code>.
     */
    public List<String> validUserList() {
        return validUserList;
    }

    /**
     * <p>
     * A list of users or groups in the Active Directory that are not allowed to access the file share. A group must be
     * prefixed with the @ character. For example <code>@group1</code>. Can only be set if Authentication is set to
     * <code>ActiveDirectory</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of users or groups in the Active Directory that are not allowed to access the file share. A group
     *         must be prefixed with the @ character. For example <code>@group1</code>. Can only be set if
     *         Authentication is set to <code>ActiveDirectory</code>.
     */
    public List<String> invalidUserList() {
        return invalidUserList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fileShareARN());
        hashCode = 31 * hashCode + Objects.hashCode(kmsEncrypted());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKey());
        hashCode = 31 * hashCode + Objects.hashCode(defaultStorageClass());
        hashCode = 31 * hashCode + Objects.hashCode(objectACLAsString());
        hashCode = 31 * hashCode + Objects.hashCode(readOnly());
        hashCode = 31 * hashCode + Objects.hashCode(guessMIMETypeEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(requesterPays());
        hashCode = 31 * hashCode + Objects.hashCode(validUserList());
        hashCode = 31 * hashCode + Objects.hashCode(invalidUserList());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSmbFileShareRequest)) {
            return false;
        }
        UpdateSmbFileShareRequest other = (UpdateSmbFileShareRequest) obj;
        return Objects.equals(fileShareARN(), other.fileShareARN()) && Objects.equals(kmsEncrypted(), other.kmsEncrypted())
                && Objects.equals(kmsKey(), other.kmsKey()) && Objects.equals(defaultStorageClass(), other.defaultStorageClass())
                && Objects.equals(objectACLAsString(), other.objectACLAsString()) && Objects.equals(readOnly(), other.readOnly())
                && Objects.equals(guessMIMETypeEnabled(), other.guessMIMETypeEnabled())
                && Objects.equals(requesterPays(), other.requesterPays())
                && Objects.equals(validUserList(), other.validUserList())
                && Objects.equals(invalidUserList(), other.invalidUserList());
    }

    @Override
    public String toString() {
        return ToString.builder("UpdateSmbFileShareRequest").add("FileShareARN", fileShareARN())
                .add("KMSEncrypted", kmsEncrypted()).add("KMSKey", kmsKey()).add("DefaultStorageClass", defaultStorageClass())
                .add("ObjectACL", objectACLAsString()).add("ReadOnly", readOnly())
                .add("GuessMIMETypeEnabled", guessMIMETypeEnabled()).add("RequesterPays", requesterPays())
                .add("ValidUserList", validUserList()).add("InvalidUserList", invalidUserList()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FileShareARN":
            return Optional.ofNullable(clazz.cast(fileShareARN()));
        case "KMSEncrypted":
            return Optional.ofNullable(clazz.cast(kmsEncrypted()));
        case "KMSKey":
            return Optional.ofNullable(clazz.cast(kmsKey()));
        case "DefaultStorageClass":
            return Optional.ofNullable(clazz.cast(defaultStorageClass()));
        case "ObjectACL":
            return Optional.ofNullable(clazz.cast(objectACLAsString()));
        case "ReadOnly":
            return Optional.ofNullable(clazz.cast(readOnly()));
        case "GuessMIMETypeEnabled":
            return Optional.ofNullable(clazz.cast(guessMIMETypeEnabled()));
        case "RequesterPays":
            return Optional.ofNullable(clazz.cast(requesterPays()));
        case "ValidUserList":
            return Optional.ofNullable(clazz.cast(validUserList()));
        case "InvalidUserList":
            return Optional.ofNullable(clazz.cast(invalidUserList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateSmbFileShareRequest, T> g) {
        return obj -> g.apply((UpdateSmbFileShareRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends StorageGatewayRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateSmbFileShareRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the SMB file share that you want to update.
         * </p>
         * 
         * @param fileShareARN
         *        The Amazon Resource Name (ARN) of the SMB file share that you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileShareARN(String fileShareARN);

        /**
         * <p>
         * True to use Amazon S3 server side encryption with your own AWS KMS key, or false to use a key managed by
         * Amazon S3. Optional.
         * </p>
         * 
         * @param kmsEncrypted
         *        True to use Amazon S3 server side encryption with your own AWS KMS key, or false to use a key managed
         *        by Amazon S3. Optional.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsEncrypted(Boolean kmsEncrypted);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the AWS KMS key used for Amazon S3 server side encryption. This value can
         * only be set when KMSEncrypted is true. Optional.
         * </p>
         * 
         * @param kmsKey
         *        The Amazon Resource Name (ARN) of the AWS KMS key used for Amazon S3 server side encryption. This
         *        value can only be set when KMSEncrypted is true. Optional.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKey(String kmsKey);

        /**
         * <p>
         * The default storage class for objects put into an Amazon S3 bucket by the file gateway. Possible values are
         * <code>S3_STANDARD</code>, <code>S3_STANDARD_IA</code>, or <code>S3_ONEZONE_IA</code>. If this field is not
         * populated, the default value <code>S3_STANDARD</code> is used. Optional.
         * </p>
         * 
         * @param defaultStorageClass
         *        The default storage class for objects put into an Amazon S3 bucket by the file gateway. Possible
         *        values are <code>S3_STANDARD</code>, <code>S3_STANDARD_IA</code>, or <code>S3_ONEZONE_IA</code>. If
         *        this field is not populated, the default value <code>S3_STANDARD</code> is used. Optional.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultStorageClass(String defaultStorageClass);

        /**
         * <p>
         * A value that sets the access control list permission for objects in the S3 bucket that a file gateway puts
         * objects into. The default value is "private".
         * </p>
         * 
         * @param objectACL
         *        A value that sets the access control list permission for objects in the S3 bucket that a file gateway
         *        puts objects into. The default value is "private".
         * @see ObjectACL
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ObjectACL
         */
        Builder objectACL(String objectACL);

        /**
         * <p>
         * A value that sets the access control list permission for objects in the S3 bucket that a file gateway puts
         * objects into. The default value is "private".
         * </p>
         * 
         * @param objectACL
         *        A value that sets the access control list permission for objects in the S3 bucket that a file gateway
         *        puts objects into. The default value is "private".
         * @see ObjectACL
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ObjectACL
         */
        Builder objectACL(ObjectACL objectACL);

        /**
         * <p>
         * A value that sets the write status of a file share. This value is true if the write status is read-only, and
         * otherwise false.
         * </p>
         * 
         * @param readOnly
         *        A value that sets the write status of a file share. This value is true if the write status is
         *        read-only, and otherwise false.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readOnly(Boolean readOnly);

        /**
         * <p>
         * A value that enables guessing of the MIME type for uploaded objects based on file extensions. Set this value
         * to true to enable MIME type guessing, and otherwise to false. The default value is true.
         * </p>
         * 
         * @param guessMIMETypeEnabled
         *        A value that enables guessing of the MIME type for uploaded objects based on file extensions. Set this
         *        value to true to enable MIME type guessing, and otherwise to false. The default value is true.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder guessMIMETypeEnabled(Boolean guessMIMETypeEnabled);

        /**
         * <p>
         * A value that sets the access control list permission for objects in the Amazon S3 bucket that a file gateway
         * puts objects into. The default value is <code>private</code>.
         * </p>
         * 
         * @param requesterPays
         *        A value that sets the access control list permission for objects in the Amazon S3 bucket that a file
         *        gateway puts objects into. The default value is <code>private</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requesterPays(Boolean requesterPays);

        /**
         * <p>
         * A list of users or groups in the Active Directory that are allowed to access the file share. A group must be
         * prefixed with the @ character. For example <code>@group1</code>. Can only be set if Authentication is set to
         * <code>ActiveDirectory</code>.
         * </p>
         * 
         * @param validUserList
         *        A list of users or groups in the Active Directory that are allowed to access the file share. A group
         *        must be prefixed with the @ character. For example <code>@group1</code>. Can only be set if
         *        Authentication is set to <code>ActiveDirectory</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validUserList(Collection<String> validUserList);

        /**
         * <p>
         * A list of users or groups in the Active Directory that are allowed to access the file share. A group must be
         * prefixed with the @ character. For example <code>@group1</code>. Can only be set if Authentication is set to
         * <code>ActiveDirectory</code>.
         * </p>
         * 
         * @param validUserList
         *        A list of users or groups in the Active Directory that are allowed to access the file share. A group
         *        must be prefixed with the @ character. For example <code>@group1</code>. Can only be set if
         *        Authentication is set to <code>ActiveDirectory</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validUserList(String... validUserList);

        /**
         * <p>
         * A list of users or groups in the Active Directory that are not allowed to access the file share. A group must
         * be prefixed with the @ character. For example <code>@group1</code>. Can only be set if Authentication is set
         * to <code>ActiveDirectory</code>.
         * </p>
         * 
         * @param invalidUserList
         *        A list of users or groups in the Active Directory that are not allowed to access the file share. A
         *        group must be prefixed with the @ character. For example <code>@group1</code>. Can only be set if
         *        Authentication is set to <code>ActiveDirectory</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invalidUserList(Collection<String> invalidUserList);

        /**
         * <p>
         * A list of users or groups in the Active Directory that are not allowed to access the file share. A group must
         * be prefixed with the @ character. For example <code>@group1</code>. Can only be set if Authentication is set
         * to <code>ActiveDirectory</code>.
         * </p>
         * 
         * @param invalidUserList
         *        A list of users or groups in the Active Directory that are not allowed to access the file share. A
         *        group must be prefixed with the @ character. For example <code>@group1</code>. Can only be set if
         *        Authentication is set to <code>ActiveDirectory</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invalidUserList(String... invalidUserList);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends StorageGatewayRequest.BuilderImpl implements Builder {
        private String fileShareARN;

        private Boolean kmsEncrypted;

        private String kmsKey;

        private String defaultStorageClass;

        private String objectACL;

        private Boolean readOnly;

        private Boolean guessMIMETypeEnabled;

        private Boolean requesterPays;

        private List<String> validUserList = DefaultSdkAutoConstructList.getInstance();

        private List<String> invalidUserList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSmbFileShareRequest model) {
            super(model);
            fileShareARN(model.fileShareARN);
            kmsEncrypted(model.kmsEncrypted);
            kmsKey(model.kmsKey);
            defaultStorageClass(model.defaultStorageClass);
            objectACL(model.objectACL);
            readOnly(model.readOnly);
            guessMIMETypeEnabled(model.guessMIMETypeEnabled);
            requesterPays(model.requesterPays);
            validUserList(model.validUserList);
            invalidUserList(model.invalidUserList);
        }

        public final String getFileShareARN() {
            return fileShareARN;
        }

        @Override
        public final Builder fileShareARN(String fileShareARN) {
            this.fileShareARN = fileShareARN;
            return this;
        }

        public final void setFileShareARN(String fileShareARN) {
            this.fileShareARN = fileShareARN;
        }

        public final Boolean getKmsEncrypted() {
            return kmsEncrypted;
        }

        @Override
        public final Builder kmsEncrypted(Boolean kmsEncrypted) {
            this.kmsEncrypted = kmsEncrypted;
            return this;
        }

        public final void setKmsEncrypted(Boolean kmsEncrypted) {
            this.kmsEncrypted = kmsEncrypted;
        }

        public final String getKmsKey() {
            return kmsKey;
        }

        @Override
        public final Builder kmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
            return this;
        }

        public final void setKmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
        }

        public final String getDefaultStorageClass() {
            return defaultStorageClass;
        }

        @Override
        public final Builder defaultStorageClass(String defaultStorageClass) {
            this.defaultStorageClass = defaultStorageClass;
            return this;
        }

        public final void setDefaultStorageClass(String defaultStorageClass) {
            this.defaultStorageClass = defaultStorageClass;
        }

        public final String getObjectACLAsString() {
            return objectACL;
        }

        @Override
        public final Builder objectACL(String objectACL) {
            this.objectACL = objectACL;
            return this;
        }

        @Override
        public final Builder objectACL(ObjectACL objectACL) {
            this.objectACL(objectACL.toString());
            return this;
        }

        public final void setObjectACL(String objectACL) {
            this.objectACL = objectACL;
        }

        public final Boolean getReadOnly() {
            return readOnly;
        }

        @Override
        public final Builder readOnly(Boolean readOnly) {
            this.readOnly = readOnly;
            return this;
        }

        public final void setReadOnly(Boolean readOnly) {
            this.readOnly = readOnly;
        }

        public final Boolean getGuessMIMETypeEnabled() {
            return guessMIMETypeEnabled;
        }

        @Override
        public final Builder guessMIMETypeEnabled(Boolean guessMIMETypeEnabled) {
            this.guessMIMETypeEnabled = guessMIMETypeEnabled;
            return this;
        }

        public final void setGuessMIMETypeEnabled(Boolean guessMIMETypeEnabled) {
            this.guessMIMETypeEnabled = guessMIMETypeEnabled;
        }

        public final Boolean getRequesterPays() {
            return requesterPays;
        }

        @Override
        public final Builder requesterPays(Boolean requesterPays) {
            this.requesterPays = requesterPays;
            return this;
        }

        public final void setRequesterPays(Boolean requesterPays) {
            this.requesterPays = requesterPays;
        }

        public final Collection<String> getValidUserList() {
            return validUserList;
        }

        @Override
        public final Builder validUserList(Collection<String> validUserList) {
            this.validUserList = FileShareUserListCopier.copy(validUserList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validUserList(String... validUserList) {
            validUserList(Arrays.asList(validUserList));
            return this;
        }

        public final void setValidUserList(Collection<String> validUserList) {
            this.validUserList = FileShareUserListCopier.copy(validUserList);
        }

        public final Collection<String> getInvalidUserList() {
            return invalidUserList;
        }

        @Override
        public final Builder invalidUserList(Collection<String> invalidUserList) {
            this.invalidUserList = FileShareUserListCopier.copy(invalidUserList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder invalidUserList(String... invalidUserList) {
            invalidUserList(Arrays.asList(invalidUserList));
            return this;
        }

        public final void setInvalidUserList(Collection<String> invalidUserList) {
            this.invalidUserList = FileShareUserListCopier.copy(invalidUserList);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSmbFileShareRequest build() {
            return new UpdateSmbFileShareRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
