/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VolumeRecoveryPointInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VolumeRecoveryPointInfo> {
    private static final SdkField<String> VOLUME_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VolumeARN").getter(VolumeRecoveryPointInfo.getter(VolumeRecoveryPointInfo::volumeARN)).setter(VolumeRecoveryPointInfo.setter(Builder::volumeARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeARN").build()}).build();
    private static final SdkField<Long> VOLUME_SIZE_IN_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("VolumeSizeInBytes").getter(VolumeRecoveryPointInfo.getter(VolumeRecoveryPointInfo::volumeSizeInBytes)).setter(VolumeRecoveryPointInfo.setter(Builder::volumeSizeInBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeSizeInBytes").build()}).build();
    private static final SdkField<Long> VOLUME_USAGE_IN_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("VolumeUsageInBytes").getter(VolumeRecoveryPointInfo.getter(VolumeRecoveryPointInfo::volumeUsageInBytes)).setter(VolumeRecoveryPointInfo.setter(Builder::volumeUsageInBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeUsageInBytes").build()}).build();
    private static final SdkField<String> VOLUME_RECOVERY_POINT_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VolumeRecoveryPointTime").getter(VolumeRecoveryPointInfo.getter(VolumeRecoveryPointInfo::volumeRecoveryPointTime)).setter(VolumeRecoveryPointInfo.setter(Builder::volumeRecoveryPointTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeRecoveryPointTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOLUME_ARN_FIELD, VOLUME_SIZE_IN_BYTES_FIELD, VOLUME_USAGE_IN_BYTES_FIELD, VOLUME_RECOVERY_POINT_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = VolumeRecoveryPointInfo.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String volumeARN;
    private final Long volumeSizeInBytes;
    private final Long volumeUsageInBytes;
    private final String volumeRecoveryPointTime;

    private VolumeRecoveryPointInfo(BuilderImpl builder) {
        this.volumeARN = builder.volumeARN;
        this.volumeSizeInBytes = builder.volumeSizeInBytes;
        this.volumeUsageInBytes = builder.volumeUsageInBytes;
        this.volumeRecoveryPointTime = builder.volumeRecoveryPointTime;
    }

    public final String volumeARN() {
        return this.volumeARN;
    }

    public final Long volumeSizeInBytes() {
        return this.volumeSizeInBytes;
    }

    public final Long volumeUsageInBytes() {
        return this.volumeUsageInBytes;
    }

    public final String volumeRecoveryPointTime() {
        return this.volumeRecoveryPointTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeSizeInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeUsageInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeRecoveryPointTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VolumeRecoveryPointInfo)) {
            return false;
        }
        VolumeRecoveryPointInfo other = (VolumeRecoveryPointInfo)obj;
        return Objects.equals(this.volumeARN(), other.volumeARN()) && Objects.equals(this.volumeSizeInBytes(), other.volumeSizeInBytes()) && Objects.equals(this.volumeUsageInBytes(), other.volumeUsageInBytes()) && Objects.equals(this.volumeRecoveryPointTime(), other.volumeRecoveryPointTime());
    }

    public final String toString() {
        return ToString.builder((String)"VolumeRecoveryPointInfo").add("VolumeARN", (Object)this.volumeARN()).add("VolumeSizeInBytes", (Object)this.volumeSizeInBytes()).add("VolumeUsageInBytes", (Object)this.volumeUsageInBytes()).add("VolumeRecoveryPointTime", (Object)this.volumeRecoveryPointTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VolumeARN": {
                return Optional.ofNullable(clazz.cast(this.volumeARN()));
            }
            case "VolumeSizeInBytes": {
                return Optional.ofNullable(clazz.cast(this.volumeSizeInBytes()));
            }
            case "VolumeUsageInBytes": {
                return Optional.ofNullable(clazz.cast(this.volumeUsageInBytes()));
            }
            case "VolumeRecoveryPointTime": {
                return Optional.ofNullable(clazz.cast(this.volumeRecoveryPointTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("VolumeARN", VOLUME_ARN_FIELD);
        map.put("VolumeSizeInBytes", VOLUME_SIZE_IN_BYTES_FIELD);
        map.put("VolumeUsageInBytes", VOLUME_USAGE_IN_BYTES_FIELD);
        map.put("VolumeRecoveryPointTime", VOLUME_RECOVERY_POINT_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VolumeRecoveryPointInfo, T> g) {
        return obj -> g.apply((VolumeRecoveryPointInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String volumeARN;
        private Long volumeSizeInBytes;
        private Long volumeUsageInBytes;
        private String volumeRecoveryPointTime;

        private BuilderImpl() {
        }

        private BuilderImpl(VolumeRecoveryPointInfo model) {
            this.volumeARN(model.volumeARN);
            this.volumeSizeInBytes(model.volumeSizeInBytes);
            this.volumeUsageInBytes(model.volumeUsageInBytes);
            this.volumeRecoveryPointTime(model.volumeRecoveryPointTime);
        }

        public final String getVolumeARN() {
            return this.volumeARN;
        }

        public final void setVolumeARN(String volumeARN) {
            this.volumeARN = volumeARN;
        }

        @Override
        public final Builder volumeARN(String volumeARN) {
            this.volumeARN = volumeARN;
            return this;
        }

        public final Long getVolumeSizeInBytes() {
            return this.volumeSizeInBytes;
        }

        public final void setVolumeSizeInBytes(Long volumeSizeInBytes) {
            this.volumeSizeInBytes = volumeSizeInBytes;
        }

        @Override
        public final Builder volumeSizeInBytes(Long volumeSizeInBytes) {
            this.volumeSizeInBytes = volumeSizeInBytes;
            return this;
        }

        public final Long getVolumeUsageInBytes() {
            return this.volumeUsageInBytes;
        }

        public final void setVolumeUsageInBytes(Long volumeUsageInBytes) {
            this.volumeUsageInBytes = volumeUsageInBytes;
        }

        @Override
        public final Builder volumeUsageInBytes(Long volumeUsageInBytes) {
            this.volumeUsageInBytes = volumeUsageInBytes;
            return this;
        }

        public final String getVolumeRecoveryPointTime() {
            return this.volumeRecoveryPointTime;
        }

        public final void setVolumeRecoveryPointTime(String volumeRecoveryPointTime) {
            this.volumeRecoveryPointTime = volumeRecoveryPointTime;
        }

        @Override
        public final Builder volumeRecoveryPointTime(String volumeRecoveryPointTime) {
            this.volumeRecoveryPointTime = volumeRecoveryPointTime;
            return this;
        }

        public VolumeRecoveryPointInfo build() {
            return new VolumeRecoveryPointInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VolumeRecoveryPointInfo> {
        public Builder volumeARN(String var1);

        public Builder volumeSizeInBytes(Long var1);

        public Builder volumeUsageInBytes(Long var1);

        public Builder volumeRecoveryPointTime(String var1);
    }
}

