/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociateFileSystemRequest extends StorageGatewayRequest implements
        ToCopyableBuilder<AssociateFileSystemRequest.Builder, AssociateFileSystemRequest> {
    private static final SdkField<String> USER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserName").getter(getter(AssociateFileSystemRequest::userName)).setter(setter(Builder::userName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserName").build()).build();

    private static final SdkField<String> PASSWORD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Password").getter(getter(AssociateFileSystemRequest::password)).setter(setter(Builder::password))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Password").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientToken").getter(getter(AssociateFileSystemRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build()).build();

    private static final SdkField<String> GATEWAY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GatewayARN").getter(getter(AssociateFileSystemRequest::gatewayARN)).setter(setter(Builder::gatewayARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayARN").build()).build();

    private static final SdkField<String> LOCATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LocationARN").getter(getter(AssociateFileSystemRequest::locationARN))
            .setter(setter(Builder::locationARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocationARN").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(AssociateFileSystemRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> AUDIT_DESTINATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuditDestinationARN").getter(getter(AssociateFileSystemRequest::auditDestinationARN))
            .setter(setter(Builder::auditDestinationARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuditDestinationARN").build())
            .build();

    private static final SdkField<CacheAttributes> CACHE_ATTRIBUTES_FIELD = SdkField
            .<CacheAttributes> builder(MarshallingType.SDK_POJO).memberName("CacheAttributes")
            .getter(getter(AssociateFileSystemRequest::cacheAttributes)).setter(setter(Builder::cacheAttributes))
            .constructor(CacheAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheAttributes").build()).build();

    private static final SdkField<EndpointNetworkConfiguration> ENDPOINT_NETWORK_CONFIGURATION_FIELD = SdkField
            .<EndpointNetworkConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("EndpointNetworkConfiguration")
            .getter(getter(AssociateFileSystemRequest::endpointNetworkConfiguration))
            .setter(setter(Builder::endpointNetworkConfiguration))
            .constructor(EndpointNetworkConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointNetworkConfiguration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_NAME_FIELD,
            PASSWORD_FIELD, CLIENT_TOKEN_FIELD, GATEWAY_ARN_FIELD, LOCATION_ARN_FIELD, TAGS_FIELD, AUDIT_DESTINATION_ARN_FIELD,
            CACHE_ATTRIBUTES_FIELD, ENDPOINT_NETWORK_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String userName;

    private final String password;

    private final String clientToken;

    private final String gatewayARN;

    private final String locationARN;

    private final List<Tag> tags;

    private final String auditDestinationARN;

    private final CacheAttributes cacheAttributes;

    private final EndpointNetworkConfiguration endpointNetworkConfiguration;

    private AssociateFileSystemRequest(BuilderImpl builder) {
        super(builder);
        this.userName = builder.userName;
        this.password = builder.password;
        this.clientToken = builder.clientToken;
        this.gatewayARN = builder.gatewayARN;
        this.locationARN = builder.locationARN;
        this.tags = builder.tags;
        this.auditDestinationARN = builder.auditDestinationARN;
        this.cacheAttributes = builder.cacheAttributes;
        this.endpointNetworkConfiguration = builder.endpointNetworkConfiguration;
    }

    /**
     * <p>
     * The user name of the user credential that has permission to access the root share D$ of the Amazon FSx file
     * system. The user account must belong to the Amazon FSx delegated admin user group.
     * </p>
     * 
     * @return The user name of the user credential that has permission to access the root share D$ of the Amazon FSx
     *         file system. The user account must belong to the Amazon FSx delegated admin user group.
     */
    public final String userName() {
        return userName;
    }

    /**
     * <p>
     * The password of the user credential.
     * </p>
     * 
     * @return The password of the user credential.
     */
    public final String password() {
        return password;
    }

    /**
     * <p>
     * A unique string value that you supply that is used by the FSx File Gateway to ensure idempotent file system
     * association creation.
     * </p>
     * 
     * @return A unique string value that you supply that is used by the FSx File Gateway to ensure idempotent file
     *         system association creation.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * Returns the value of the GatewayARN property for this object.
     * 
     * @return The value of the GatewayARN property for this object.
     */
    public final String gatewayARN() {
        return gatewayARN;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon FSx file system to associate with the FSx File Gateway.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon FSx file system to associate with the FSx File Gateway.
     */
    public final String locationARN() {
        return locationARN;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of up to 50 tags that can be assigned to the file system association. Each tag is a key-value pair.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of up to 50 tags that can be assigned to the file system association. Each tag is a key-value
     *         pair.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the storage used for the audit logs.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the storage used for the audit logs.
     */
    public final String auditDestinationARN() {
        return auditDestinationARN;
    }

    /**
     * Returns the value of the CacheAttributes property for this object.
     * 
     * @return The value of the CacheAttributes property for this object.
     */
    public final CacheAttributes cacheAttributes() {
        return cacheAttributes;
    }

    /**
     * <p>
     * Specifies the network configuration information for the gateway associated with the Amazon FSx file system.
     * </p>
     * <note>
     * <p>
     * If multiple file systems are associated with this gateway, this parameter's <code>IpAddresses</code> field is
     * required.
     * </p>
     * </note>
     * 
     * @return Specifies the network configuration information for the gateway associated with the Amazon FSx file
     *         system.</p> <note>
     *         <p>
     *         If multiple file systems are associated with this gateway, this parameter's <code>IpAddresses</code>
     *         field is required.
     *         </p>
     */
    public final EndpointNetworkConfiguration endpointNetworkConfiguration() {
        return endpointNetworkConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(userName());
        hashCode = 31 * hashCode + Objects.hashCode(password());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(gatewayARN());
        hashCode = 31 * hashCode + Objects.hashCode(locationARN());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(auditDestinationARN());
        hashCode = 31 * hashCode + Objects.hashCode(cacheAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(endpointNetworkConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateFileSystemRequest)) {
            return false;
        }
        AssociateFileSystemRequest other = (AssociateFileSystemRequest) obj;
        return Objects.equals(userName(), other.userName()) && Objects.equals(password(), other.password())
                && Objects.equals(clientToken(), other.clientToken()) && Objects.equals(gatewayARN(), other.gatewayARN())
                && Objects.equals(locationARN(), other.locationARN()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(auditDestinationARN(), other.auditDestinationARN())
                && Objects.equals(cacheAttributes(), other.cacheAttributes())
                && Objects.equals(endpointNetworkConfiguration(), other.endpointNetworkConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssociateFileSystemRequest").add("UserName", userName())
                .add("Password", password() == null ? null : "*** Sensitive Data Redacted ***").add("ClientToken", clientToken())
                .add("GatewayARN", gatewayARN()).add("LocationARN", locationARN()).add("Tags", hasTags() ? tags() : null)
                .add("AuditDestinationARN", auditDestinationARN()).add("CacheAttributes", cacheAttributes())
                .add("EndpointNetworkConfiguration", endpointNetworkConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserName":
            return Optional.ofNullable(clazz.cast(userName()));
        case "Password":
            return Optional.ofNullable(clazz.cast(password()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "GatewayARN":
            return Optional.ofNullable(clazz.cast(gatewayARN()));
        case "LocationARN":
            return Optional.ofNullable(clazz.cast(locationARN()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "AuditDestinationARN":
            return Optional.ofNullable(clazz.cast(auditDestinationARN()));
        case "CacheAttributes":
            return Optional.ofNullable(clazz.cast(cacheAttributes()));
        case "EndpointNetworkConfiguration":
            return Optional.ofNullable(clazz.cast(endpointNetworkConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("UserName", USER_NAME_FIELD);
        map.put("Password", PASSWORD_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("GatewayARN", GATEWAY_ARN_FIELD);
        map.put("LocationARN", LOCATION_ARN_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("AuditDestinationARN", AUDIT_DESTINATION_ARN_FIELD);
        map.put("CacheAttributes", CACHE_ATTRIBUTES_FIELD);
        map.put("EndpointNetworkConfiguration", ENDPOINT_NETWORK_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssociateFileSystemRequest, T> g) {
        return obj -> g.apply((AssociateFileSystemRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends StorageGatewayRequest.Builder, SdkPojo, CopyableBuilder<Builder, AssociateFileSystemRequest> {
        /**
         * <p>
         * The user name of the user credential that has permission to access the root share D$ of the Amazon FSx file
         * system. The user account must belong to the Amazon FSx delegated admin user group.
         * </p>
         * 
         * @param userName
         *        The user name of the user credential that has permission to access the root share D$ of the Amazon FSx
         *        file system. The user account must belong to the Amazon FSx delegated admin user group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userName(String userName);

        /**
         * <p>
         * The password of the user credential.
         * </p>
         * 
         * @param password
         *        The password of the user credential.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder password(String password);

        /**
         * <p>
         * A unique string value that you supply that is used by the FSx File Gateway to ensure idempotent file system
         * association creation.
         * </p>
         * 
         * @param clientToken
         *        A unique string value that you supply that is used by the FSx File Gateway to ensure idempotent file
         *        system association creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * Sets the value of the GatewayARN property for this object.
         *
         * @param gatewayARN
         *        The new value for the GatewayARN property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayARN(String gatewayARN);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Amazon FSx file system to associate with the FSx File Gateway.
         * </p>
         * 
         * @param locationARN
         *        The Amazon Resource Name (ARN) of the Amazon FSx file system to associate with the FSx File Gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder locationARN(String locationARN);

        /**
         * <p>
         * A list of up to 50 tags that can be assigned to the file system association. Each tag is a key-value pair.
         * </p>
         * 
         * @param tags
         *        A list of up to 50 tags that can be assigned to the file system association. Each tag is a key-value
         *        pair.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of up to 50 tags that can be assigned to the file system association. Each tag is a key-value pair.
         * </p>
         * 
         * @param tags
         *        A list of up to 50 tags that can be assigned to the file system association. Each tag is a key-value
         *        pair.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of up to 50 tags that can be assigned to the file system association. Each tag is a key-value pair.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.storagegateway.model.Tag.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.storagegateway.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.storagegateway.model.Tag.Builder#build()} is called immediately and
         * its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.storagegateway.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the storage used for the audit logs.
         * </p>
         * 
         * @param auditDestinationARN
         *        The Amazon Resource Name (ARN) of the storage used for the audit logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder auditDestinationARN(String auditDestinationARN);

        /**
         * Sets the value of the CacheAttributes property for this object.
         *
         * @param cacheAttributes
         *        The new value for the CacheAttributes property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheAttributes(CacheAttributes cacheAttributes);

        /**
         * Sets the value of the CacheAttributes property for this object.
         *
         * This is a convenience method that creates an instance of the {@link CacheAttributes.Builder} avoiding the
         * need to create one manually via {@link CacheAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CacheAttributes.Builder#build()} is called immediately and its
         * result is passed to {@link #cacheAttributes(CacheAttributes)}.
         * 
         * @param cacheAttributes
         *        a consumer that will call methods on {@link CacheAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cacheAttributes(CacheAttributes)
         */
        default Builder cacheAttributes(Consumer<CacheAttributes.Builder> cacheAttributes) {
            return cacheAttributes(CacheAttributes.builder().applyMutation(cacheAttributes).build());
        }

        /**
         * <p>
         * Specifies the network configuration information for the gateway associated with the Amazon FSx file system.
         * </p>
         * <note>
         * <p>
         * If multiple file systems are associated with this gateway, this parameter's <code>IpAddresses</code> field is
         * required.
         * </p>
         * </note>
         * 
         * @param endpointNetworkConfiguration
         *        Specifies the network configuration information for the gateway associated with the Amazon FSx file
         *        system.</p> <note>
         *        <p>
         *        If multiple file systems are associated with this gateway, this parameter's <code>IpAddresses</code>
         *        field is required.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointNetworkConfiguration(EndpointNetworkConfiguration endpointNetworkConfiguration);

        /**
         * <p>
         * Specifies the network configuration information for the gateway associated with the Amazon FSx file system.
         * </p>
         * <note>
         * <p>
         * If multiple file systems are associated with this gateway, this parameter's <code>IpAddresses</code> field is
         * required.
         * </p>
         * </note> This is a convenience method that creates an instance of the
         * {@link EndpointNetworkConfiguration.Builder} avoiding the need to create one manually via
         * {@link EndpointNetworkConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EndpointNetworkConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #endpointNetworkConfiguration(EndpointNetworkConfiguration)}.
         * 
         * @param endpointNetworkConfiguration
         *        a consumer that will call methods on {@link EndpointNetworkConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #endpointNetworkConfiguration(EndpointNetworkConfiguration)
         */
        default Builder endpointNetworkConfiguration(Consumer<EndpointNetworkConfiguration.Builder> endpointNetworkConfiguration) {
            return endpointNetworkConfiguration(EndpointNetworkConfiguration.builder()
                    .applyMutation(endpointNetworkConfiguration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends StorageGatewayRequest.BuilderImpl implements Builder {
        private String userName;

        private String password;

        private String clientToken;

        private String gatewayARN;

        private String locationARN;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String auditDestinationARN;

        private CacheAttributes cacheAttributes;

        private EndpointNetworkConfiguration endpointNetworkConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateFileSystemRequest model) {
            super(model);
            userName(model.userName);
            password(model.password);
            clientToken(model.clientToken);
            gatewayARN(model.gatewayARN);
            locationARN(model.locationARN);
            tags(model.tags);
            auditDestinationARN(model.auditDestinationARN);
            cacheAttributes(model.cacheAttributes);
            endpointNetworkConfiguration(model.endpointNetworkConfiguration);
        }

        public final String getUserName() {
            return userName;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final String getPassword() {
            return password;
        }

        public final void setPassword(String password) {
            this.password = password;
        }

        @Override
        public final Builder password(String password) {
            this.password = password;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getGatewayARN() {
            return gatewayARN;
        }

        public final void setGatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
        }

        @Override
        public final Builder gatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
            return this;
        }

        public final String getLocationARN() {
            return locationARN;
        }

        public final void setLocationARN(String locationARN) {
            this.locationARN = locationARN;
        }

        @Override
        public final Builder locationARN(String locationARN) {
            this.locationARN = locationARN;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getAuditDestinationARN() {
            return auditDestinationARN;
        }

        public final void setAuditDestinationARN(String auditDestinationARN) {
            this.auditDestinationARN = auditDestinationARN;
        }

        @Override
        public final Builder auditDestinationARN(String auditDestinationARN) {
            this.auditDestinationARN = auditDestinationARN;
            return this;
        }

        public final CacheAttributes.Builder getCacheAttributes() {
            return cacheAttributes != null ? cacheAttributes.toBuilder() : null;
        }

        public final void setCacheAttributes(CacheAttributes.BuilderImpl cacheAttributes) {
            this.cacheAttributes = cacheAttributes != null ? cacheAttributes.build() : null;
        }

        @Override
        public final Builder cacheAttributes(CacheAttributes cacheAttributes) {
            this.cacheAttributes = cacheAttributes;
            return this;
        }

        public final EndpointNetworkConfiguration.Builder getEndpointNetworkConfiguration() {
            return endpointNetworkConfiguration != null ? endpointNetworkConfiguration.toBuilder() : null;
        }

        public final void setEndpointNetworkConfiguration(EndpointNetworkConfiguration.BuilderImpl endpointNetworkConfiguration) {
            this.endpointNetworkConfiguration = endpointNetworkConfiguration != null ? endpointNetworkConfiguration.build()
                    : null;
        }

        @Override
        public final Builder endpointNetworkConfiguration(EndpointNetworkConfiguration endpointNetworkConfiguration) {
            this.endpointNetworkConfiguration = endpointNetworkConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateFileSystemRequest build() {
            return new AssociateFileSystemRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
